const {
	SelectControl,
} = wp.components;

let currentImageSize = 'full',
	currentAvailableImageSizes = [];

export default class ImageSizes extends React.Component{

	constructor( props ) {
		super();

		this.state = {
			availableImageSizes: currentAvailableImageSizes,
			imageSize: currentImageSize
		}
	}

	componentDidMount() {
		if( !currentAvailableImageSizes.length ) {
			this.setAvailableImageSizes(this.props.imageID);
		}
	}

	componentWillReceiveProps(nextProps) {
		if (nextProps.imageID !== this.props.imageID) {
			this.setAvailableImageSizes(nextProps.imageID);
		}
	}

	setAvailableImageSizes(imageID) {
		this.setState({
			availableImageSizes: []
		})

		$.post(
			ajaxurl,
			{
				action:'get_available_image_sizes',
				image_id: imageID
			},
			(response) => {
				currentAvailableImageSizes = response;
				this.setState({
					availableImageSizes: response
				})
			}
		);
	}

	render() {
		return (
			<SelectControl
				value={this.state.imageSize}
				options={this.state.availableImageSizes.map(({ value, label }) => ({
					value: value,
					label: label
				}))}
				onChange={newImageSize => {
					currentImageSize = newImageSize;
					this.props.onChange(currentImageSize);
					this.setState({
						imageSize: currentImageSize
					})
				}}
			/>
		)
	}
}