export default class JetIcon extends wp.element.Component {
	shouldComponentUpdate( nextProps ) {
		return (
			this.props.icon !== nextProps.icon
		);
	}

	render() {
		const { icon }    = this.props;
		const defaultIcon = '36';

		let iconID;
		let map = {
			'circle-progress': '3',
			'pricing-table': '4',
			'map': '8',
			'timer': '9',
			'animated-box': '11',
			'banner': '10',
			'progress-bar': '34',
			'inline-svg': '44',
			'image-comparison': '29',
		}

		if ( map[ icon ] ) {
			iconID = map[ icon ];
		} else {
			iconID = defaultIcon;
		}

		return (
			<i className={`jetelements-icon-${iconID}`} aria-hidden="true"></i>
		);
	}
}