import {
	getTimeRemaining
} from "./utils/timeDate";

jQuery(document).ready(function($) {

	/* JetGuten Countdown Timer */
	let countdownTimerName = '.jet-guten-countdown-timer',
		$countdownTimers = $(countdownTimerName);

	$countdownTimers.each(function() {
		let $this = $(this),
			$daysValue = $(this).find(`${countdownTimerName}__days ${countdownTimerName}__value`),
			$hoursValue = $(this).find(`${countdownTimerName}__hours ${countdownTimerName}__value`),
			$minutesValue = $(this).find(`${countdownTimerName}__minutes ${countdownTimerName}__value`),
			$secondsValue = $(this).find(`${countdownTimerName}__seconds ${countdownTimerName}__value`),
			endDate = $this.data('end-date'),
			timeInterval;

		timeInterval = setInterval(() => {
			let timeRemaining = getTimeRemaining(endDate);

			$daysValue.text(timeRemaining.days);
			$hoursValue.text(timeRemaining.hours);
			$minutesValue.text(timeRemaining.minutes);
			$secondsValue.text(timeRemaining.seconds);

			if (timeRemaining.countdownOver) {
				clearInterval(timeInterval);
			}
		}, 1000);

	});

});