export function getTimeRemaining(endTime) {
	let timeRemaining = new Date(endTime) - new Date(),
		seconds = Math.floor((timeRemaining / 1000) % 60),
		minutes = Math.floor((timeRemaining / 1000 / 60) % 60),
		hours = Math.floor((timeRemaining / (1000 * 60 * 60)) % 24),
		days = Math.floor(timeRemaining / (1000 * 60 * 60 * 24)),
		countdownOver = false;

	if (!endTime || 0 >= timeRemaining) {
		days = 0;
		hours = 0
		minutes = 0;
		seconds = 0;
		countdownOver = true;
	}

	return {
		days,
		hours,
		minutes,
		seconds,
		countdownOver
	};
}