/*!
  ImageLinks - jQuery Interactive Image Map
  @name jquery.imagelinks.js
  @description jQuery plugin for creating an interactive image maps for news, posters, albums and etc
  @version 1.0.1
  @author Max Lavrentiev
  @site http://www.avirtum.com
  @copyright (c) Max Lavrentiev
*/
!function(f,s,r,e){"use strict";function o(){this.isMobile=function(){return/Mobi|Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)},this.transitionEvent=function(){var t,i=r.createElement("fakeelement"),o={transition:"transitionend",OTransition:"otransitionend",MozTransition:"transitionend",WebkitTransition:"webkitTransitionEnd"};for(t in o)if(i.style[t]!==e)return o[t];return null},this.animationEvent=function(){var t,i=r.createElement("fakeelement"),o={animation:"animationend",MSAnimationEnd:"msAnimationEnd",OAnimation:"oAnimationEnd",MozAnimation:"mozAnimationEnd",WebkitAnimation:"webkitAnimationEnd"};for(t in o)if(i.style[t]!==e)return o[t];return null}}var l="imagelinks-instance";function n(t,i){this.util=new o,this.$container=null,this.config=null,this.controls={},this.imageWidth=0,this.imageHeight=0,this.markers=[],this.tooltipZindex=[],this.bodyClick=!1,this.themeClass=null,this.timerIdResize=null,this.timerIdScroll=null,this.ready=!1,this._init(t,i)}n.prototype={VERSION:"1.0.0",defaults:{theme:"default",width:null,height:null,imgSrc:null,delayResize:100,markers:[],className:null,onPreInit:null,onLoad:null},defaultsMarker:{x:0,y:0,width:null,height:null,angle:null,imgSrc:null,link:null,linkNewWindow:!1,responsive:!1,noevents:!1,tooltip:null,data:null,dataSelector:null,className:null},defaultsTooltip:{active:!0,placement:"top",offset:{x:0,y:0},width:null,widthFromCSS:!1,trigger:"hover",followCursor:!1,responsive:!1,interactive:!0,smart:!1,showOnInit:!1,showAnimation:null,hideAnimation:null,duration:300,data:null,dataSelector:null,className:null},util:null,_init:function(t,i){this.$container=t,this.config=i,this._create()},_create:function(){var i=this;function o(){i._buildDOM(),i._setTheme(i.config.theme),i._bind(),i._initMarkers(),i._beforeReady(),i._updateSize(),i._ready()}var e=new Image;e.onload=f.proxy(function(t){i.imageWidth=e.width,i.imageHeight=e.height,setTimeout(o,300)},this),e.onerror=f.proxy(function(t){console.error('Cannot load image "'+i.config.imgSrc+'"')},this),e.src=i.config.imgSrc},_setTheme:function(t){this.$container.removeClass(this.themeClass),this.themeClass=t?"imgl-theme-"+t.toLowerCase():null,this.$container.addClass(this.themeClass)},_buildDOM:function(){this.controls.$image=f("<div>").addClass("imgl-image").css({"background-image":"url("+this.config.imgSrc+")"}),this.controls.$stage=f("<div>").addClass("imgl-stage"),this.controls.$markers=f("<ul>").addClass("imgl-markers"),//!!!
this.controls.$tooltips=f("<div>").addClass("imgl-tooltips"),this.controls.$lastMarker=f("<li>").addClass("imgl-marker-last").attr("tabindex",1),this.controls.$stage.append(this.controls.$markers.append(this.controls.$lastMarker),this.controls.$tooltips),this.controls.$image.append(this.controls.$stage),this.$container.prepend(this.controls.$image).addClass("imgl-map").addClass(this.config.className),null!=this.config.width&&this.$container.css({width:this.config.width}),null!=this.config.height&&this.$container.css({height:this.config.height})},_bind:function(){f(s).on("resize",f.proxy(this._onResize,this)),f(s).on("scroll",f.proxy(this._onScroll,this)),f("body").on("click",f.proxy(this._onBodyClickTooltip,this)),this.controls.$lastMarker.on("focus",f.proxy(this._onLastMarkerFocus,this))},_unbind:function(){f(s).off("resize",f.proxy(this._onResize,this)),f(s).off("scroll",f.proxy(this._onScroll,this)),f("body").off("click",f.proxy(this._onBodyClickTooltip,this)),this.controls.$lastMarker.off("focus",f.proxy(this._onLastMarkerFocus,this))},_beforeReady:function(){this.$container.addClass("imgl-before-ready"),this.$container.get(0).offsetHeight,this.$container.is(":hidden")&&this.$container.css("display","block");for(var t=0;t<this.markers.length;t++){var i,o=this.markers[t];o.cfg.tooltip.widthFromCSS||(i=o.$tooltip.get(0).getBoundingClientRect(),i=o.cfg.tooltip.width||i.width+1,o.$tooltip.css({width:i})),o.$tooltipPos.css({width:"auto"}),!o.cfg.tooltip.showOnInit&&"sticky"!=o.cfg.tooltip.trigger||this._showTooltip(o)}this.$container.removeClass("imgl-before-ready")},_ready:function(){if(this.config.onLoad){var t=null;if("string"==typeof this.config.onLoad)try{t=new Function(this.config.onLoad)}catch(t){console.error('Can not compile "onLoad" function: '+t.message)}else"function"==typeof this.config.onLoad&&(t=this.config.onLoad);t&&t.call(this)}this.$container.addClass("imgl-ready"),this.ready=!0,this.$container.trigger("imagelinks:ready",[this])},_destroy:function(){this._unbind(),this.controls.$image.remove(),this.$container.removeClass("imgl-ready").removeClass("imgl-map").removeClass(this.config.className),this._setTheme(null),0},_updateSize:function(){for(var t=this.imageHeight/this.imageWidth,i=this.controls.$image.width(),t=null==this.config.height?t*i:this.$container.height(),o=(null==this.config.height&&this.controls.$image.css({height:t}),i/this.imageWidth),e=t/this.imageHeight,s=0;s<this.markers.length;s++){var r=this.markers[s];r.cfg.responsive&&r.$markerZoom.css({transform:"scale("+o+","+e+")"}),r.cfg.tooltip.responsive&&r.$tooltipZoom.css({transform:"scale("+o+","+e+")"}),r.tooltipVisible&&this._showTooltip(r)}},_updatePlacement:function(){for(var t=0;t<this.markers.length;t++){var i=this.markers[t];i.tooltipVisible&&this._showTooltip(i)}},_initMarkers:function(){if(this.config.markers)for(var t=0;t<this.config.markers.length;t++){var i=this.config.markers[t];this._addMarker(i)}},_addMarker:function(t){t.tooltip=f.extend(!0,{},this.defaultsTooltip,t.tooltip);var i,t=f.extend(!0,{},this.defaultsMarker,t),o=f("<li>").addClass("imgl-marker-wrap").addClass(t.className),e=f("<div>").addClass("imgl-marker-pos").css({top:t.y+"%",left:t.x+"%"}),s=f("<div>").addClass("imgl-marker-offset"),r=f("<div>").addClass("imgl-marker-zoom"),a=f("<div>").addClass("imgl-marker"),l=(t.imgSrc&&a.css({"background-image":"url("+t.imgSrc+")"}),t.noevents&&a.addClass("imgl-noevents"),"focus"==t.tooltip.trigger&&a.attr("tabindex",1),t.autoWidth||null==t.width||a.css({width:t.width}),t.autoHeight||null==t.height||a.css({height:t.height}),null!=t.angle&&a.css({transform:"rotate("+t.angle+"deg)"}),t.data?a.html(t.data):t.dataSelector?(i=f(t.dataSelector)).length&&(i.detach(),a.append(i)):(i=this.$container.find(".imgl-store > .imgl-pin-"+(this.markers.length+1))).length&&(i.detach(),a.append(i)),o.append(e.append(r.append(s.append(a)))),this.controls.$markers.append(o),this.controls.$lastMarker.detach(),this.controls.$markers.append(this.controls.$lastMarker),t.tooltip=f.extend(!0,{},this.defaultsTooltip,t.tooltip),f("<div>").addClass("imgl-tooltip-wrap").addClass("imgl-hide").addClass(t.tooltip.className)),c=f("<div>").addClass("imgl-tooltip-pos").css({top:t.y+"%",left:t.x+"%"}),p=f("<div>").addClass("imgl-tooltip-zoom"),d=f("<div>").addClass("imgl-tooltip-offset"),n=f("<div>").addClass("imgl-tooltip-form"),g=f("<div>").addClass("imgl-tooltip-arrow"),m=f("<div>").addClass("imgl-tooltip-frame"),h=f("<div>").addClass("imgl-tooltip"),t=((t.tooltip.showAnimation||t.tooltip.hideAnimation)&&t.tooltip.duration&&n.css({"animation-duration":t.tooltip.duration+"ms","-webkit-animation-duration":t.tooltip.duration+"ms"}),t.tooltip.data?h.html(t.tooltip.data):t.tooltip.dataSelector?(i=f(t.tooltip.dataSelector)).length&&(i.detach(),h.append(i)):(i=this.$container.find(".imgl-store .imgl-tt-"+(this.markers.length+1))).length&&(i.detach(),h.append(i)),l.append(c.append(p.append(d.append(n.append(m.append(h),g))))),this.controls.$tooltips.append(l),{$markerWrap:o,$markerPos:e,$markerZoom:r,$markerOffset:s,$marker:a,$tooltipWrap:l,$tooltipPos:c,$tooltipZoom:p,$tooltipOffset:d,$tooltipForm:n,$tooltipFrame:m,$tooltip:h,tooltipVisible:!1,cfg:t});this._bindMarker(t),this.markers.push(t),this._updateBodyClick()},_bindMarker:function(t){switch(t.cfg.link&&t.$marker.on("click",f.proxy(this._onMarkerClickLink,this,t)),t.cfg.tooltip.trigger){case"hover":t.$marker.on("mouseenter",f.proxy(this._onMarkerEnterTooltip,this,t)),t.$marker.on("mouseleave",f.proxy(this._onMarkerLeaveTooltip,this,t)),this.util.isMobile()&&(t.$marker.on("focus",f.proxy(this._onMarkerFocusTooltip,this,t)),t.$marker.on("blur",f.proxy(this._onMarkerBlurTooltip,this,t)));break;case"focus":t.$marker.on("focus",f.proxy(this._onMarkerFocusTooltip,this,t)),t.$marker.on("blur",f.proxy(this._onMarkerBlurTooltip,this,t));break;case"click":case"clickbody":t.$marker.on("click",f.proxy(this._onMarkerClickTooltip,this,t))}},_deleteMarker:function(t){var i;return 0<=t&&t<this.markers.length&&((i=this.markers[t]).$markerWrap.remove(),i.$tooltipWrap.remove(),this.markers.splice(t,1),!0)},_updateBodyClick:function(){this.bodyClick=!1;for(var t=0;t<this.markers.length;t++){var i=this.markers[t];if("clickbody"==i.cfg.tooltip.trigger||"focus"==i.cfg.tooltip.trigger){this.bodyClick=!0;break}}},_getViewportOffset:function(t){var i=f(s),o=i.scrollLeft(),i=i.scrollTop(),e=t.get(0).getBoundingClientRect(),t=t.offset();return{left:t.left-o,top:t.top-i,bottom:Math.max(r.documentElement.clientHeight,s.innerHeight||0)-t.top+i-e.height,right:Math.max(r.documentElement.clientWidth,s.innerWidth||0)-t.left+o-e.width}},_showTooltip:function(t,c,i,p){if(t.cfg.tooltip.active){var d=this.imageHeight/this.imageWidth,g=this.$container.width(),d=null==this.config.height?d*g:this.$container.height(),g=g/this.imageWidth,d=d/this.imageHeight,o="hover"==t.cfg.tooltip.trigger&&t.cfg.tooltip.followCursor?5:(!t.cfg.autoHeight&&t.cfg.height?t.cfg.height:t.$marker.height())*(t.cfg.responsive&&!t.cfg.tooltip.responsive?d:1)/2,e="hover"==t.cfg.tooltip.trigger&&t.cfg.tooltip.followCursor?5:(!t.cfg.autoWidth&&t.cfg.width?t.cfg.width:t.$marker.width())*(t.cfg.responsive&&!t.cfg.tooltip.responsive?g:1)/2,s=t.cfg.tooltip.offset.y,r=t.cfg.tooltip.offset.x;switch(c=c||!1,i=i||t.cfg.tooltip.placement,p=p||!1,t.$tooltipWrap.removeClass(t.$tooltipWrap.data("placement")),t.$tooltipWrap.addClass("imgl-tooltip-"+i).data("placement","imgl-tooltip-"+i),i){case"top-left":o=-o,e=-e,s=-s;break;case"top":o=-o,s=-s,r=e=0;break;case"top-right":o=-o,s=-s,r=-r;break;case"right-top":o=-o;break;case"right":s=o=0;break;case"right-bottom":s=-s;break;case"bottom-right":r=-r;break;case"bottom":r=e=0;break;case"bottom-left":e=-e;break;case"left-bottom":e=-e,s=-s,r=-r;break;case"left":e=-e,s=o=0,r=-r;break;case"left-top":o=-o,e=-e,r=-r;break;default:o=e=t.cfg.tooltip.followCursor?5:0}if(t.$tooltipOffset.css({"margin-top":o,"margin-left":e}),t.cfg.tooltip.followCursor&&"hover"==t.cfg.tooltip.trigger&&(t.$marker.on("mousemove",f.proxy(this._onMarkerMouseMoveTooltip,this,t)),t.$tooltipWrap.addClass("imgl-noevents-hard")),t.$tooltipPos.css({top:t.cfg.y+"%",left:t.cfg.x+"%","margin-top":s,"margin-left":r}),t.tooltipVisible||(t.tooltipVisible=!0,t.$tooltipWrap.addClass("imgl-show").removeClass("imgl-hide"),d=0<this.tooltipZindex.length?Math.max.apply(null,this.tooltipZindex)+1:1,this.tooltipZindex.push(d),t.$tooltipPos.css("z-index",d),c&&t.cfg.tooltip.showAnimation&&(t.$tooltipForm.removeClass(t.cfg.tooltip.showAnimation).removeClass(t.cfg.tooltip.hideAnimation),t.$tooltipForm.addClass(t.cfg.tooltip.showAnimation),t.$tooltipForm.one(this.util.animationEvent(),f.proxy(function(t,i){f(i.target).removeClass(t.cfg.tooltip.showAnimation)},this,t)))),!p&&t.cfg.tooltip.smart){var a=this._getViewportOffset(t.$markerOffset),l=this._getViewportOffset(t.$tooltipOffset),n=t.$markerOffset.get(0).getBoundingClientRect(),h=t.$tooltipOffset.get(0).getBoundingClientRect();switch(i){case"top-left":l.right<0&&(i=0<a.left+n.width-h.width?i.replace("-left","-right"):i.replace("-left","")),l.top<0&&(i=i.replace("top","bottom"));break;case"top":l.right<0&&0<a.left+n.width-h.width&&(i+="-right"),l.left<0&&0<a.right+n.width-h.width&&(i+="-left"),l.top<0&&(i=i.replace("top","bottom"));break;case"top-right":l.left<0&&(i=0<a.right+n.width-h.width?i.replace("-right","-left"):i.replace("-right","")),l.top<0&&(i=i.replace("top","bottom"));break;case"right-top":l.top<0&&n.height>h.height&&(i=i.replace("-top","-bottom")),l.right<0&&(i=i.replace("right","left"));break;case"right":l.top<0&&(n.height>h.height?i+="-bottom":i+="-top"),l.bottom<0&&(n.height>h.height?i+="-top":i+="-bottom"),l.right<0&&(i=i.replace("right","left"));break;case"right-bottom":l.bottom<0&&n.height>h.height&&(i=i.replace("-bottom","-top")),l.right<0&&(i=i.replace("right","left"));break;case"bottom-right":l.left<0&&(i=0<a.right+n.width-h.width?i.replace("-right","-left"):i.replace("-right","")),l.bottom<0&&(i=i.replace("bottom","top"));break;case"bottom":l.right<0&&0<a.left+n.width-h.width&&(i+="-right"),l.left<0&&0<a.right+n.width-h.width&&(i+="-left"),l.top<0&&(i=i.replace("bottom","top"));break;case"bottom-left":l.right<0&&(i=0<a.left+n.width-h.width?i.replace("-left","-right"):i.replace("-left","")),l.bottom<0&&(i=i.replace("bottom","top"));break;case"left-bottom":l.bottom<0&&n.height>h.height&&(i=i.replace("-bottom","-top")),l.left<0&&(i=i.replace("left","right"));break;case"left":l.top<0&&(n.height>h.height?i+="-bottom":i+="-top"),l.bottom<0&&(n.height>h.height?i+="-top":i+="-bottom"),l.left<0&&(i=i.replace("left","right"));break;case"left-top":l.top<0&&n.height>h.height&&(i=i.replace("-top","-bottom")),l.left<0&&(i=i.replace("left","right"))}this._showTooltip(t,!1,i,!0,!1)}}},_hideTooltip:function(t){t.$marker.off("mousemove",f.proxy(this._onMarkerMouseMoveTooltip,t,this)),t.$tooltipWrap.removeClass("imgl-noevents-hard"),t.tooltipVisible&&(t.tooltipVisible=!1,t.cfg.tooltip.hideAnimation?(t.$tooltipForm.removeClass(t.cfg.tooltip.showAnimation).removeClass(t.cfg.tooltip.hideAnimation),t.$tooltipForm.addClass(t.cfg.tooltip.hideAnimation),t.$tooltipForm.one(this.util.animationEvent(),f.proxy(function(t,i){f(i.target).removeClass(t.cfg.tooltip.hideAnimation),t.tooltipVisible||this.__hideTooltip(t)},this,t))):this.__hideTooltip(t))},__hideTooltip:function(t){t.$tooltipWrap.addClass("imgl-hide").removeClass("imgl-show");var i=this.tooltipZindex.indexOf(parseInt(t.$tooltipPos.css("z-index"),10));-1<i&&this.tooltipZindex.splice(i,1),t.$tooltipPos.css("z-index",""),t.$tooltip.detach(),t.$tooltip.get(0).offsetHeight,t.$tooltip.appendTo(t.$tooltipFrame)},_onMarkerClickLink:function(t,i){t.cfg.link&&s.open(t.cfg.link,t.cfg.linkNewWindow?"_blank":"_self")},_onMarkerEnterTooltip:function(t,i){this._showTooltip(t,!0)},_onMarkerLeaveTooltip:function(t,i){i=i.relatedTarget||i.toElement;t.cfg.tooltip.interactive&&(0!==t.$tooltipWrap.has(i).length||t.$tooltipWrap.is(i))||t.$marker.is(i)?t.$tooltipWrap.one("mouseleave",f.proxy(this._onMarkerLeaveTooltip,this,t)):this._hideTooltip(t)},_onMarkerMouseMoveTooltip:function(t,i){var o=this.controls.$stage.get(0).getBoundingClientRect(),e=(i.clientY-o.y)/o.height*100,i=(i.clientX-o.x)/o.width*100;t.$tooltipPos.css({top:e+"%",left:i+"%"})},_onMarkerFocusTooltip:function(t,i){this._showTooltip(t,!0)},_onMarkerBlurTooltip:function(t,i){this._hideTooltip(t)},_onMarkerClickTooltip:function(t,i){t.tooltipVisible?this._hideTooltip(t):this._showTooltip(t,!0)},_onBodyClickTooltip:function(t){if(this.bodyClick)for(var i=t.target||t.relatedTarget||t.toElement,o=0;o<this.markers.length;o++){var e=this.markers[o];0<e.$markerWrap.has(i).length||e.$markerWrap.is(i)||e.tooltipVisible&&("clickbody"==e.cfg.tooltip.trigger||"focus"==e.cfg.tooltip.trigger&&!e.$marker.is(":focus"))&&(!e.tooltipVisible||e.cfg.tooltip.interactive&&(0!==e.$tooltipWrap.has(i).length||e.$tooltipWrap.is(i))||this._hideTooltip(e))}},_onLastMarkerFocus:function(t){this.markers.length&&this.markers[0].$marker.focus()},_onResize:function(){var t;this.ready&&(t=this,clearTimeout(this.timerIdResize),this.timerIdResize=setTimeout(function(){t._updateSize()},this.config.delayResize))},_onScroll:function(){var t;this.ready&&(t=this,clearTimeout(this.timerIdScroll),this.timerIdScroll=setTimeout(function(){t._updatePlacement()},100))},setTheme:function(t){this._setTheme(t)},addMarker:function(t){this._addMarker(t)},deleteMarker:function(t){return this._deleteMarker(t)}},f.fn.imagelinks=function(a,t){return"instance"==a?f(this).data(l)||void console.error('Calling "instance" method on not initialized instance is forbidden'):this.each(function(){var o=f(this),e=o.data(l),t=o.data("json-src"),s=o.data("img-src"),r=f.isPlainObject(a)?a:t?null:{};if("destroy"==a)return e?(o.removeData(l),void e._destroy()):void console.error('Calling "destroy" method on not initialized instance is forbidden');function i(){var t=f.extend(!0,{},n.prototype.defaults,r);if(null==t.imgSrc&&s&&(t.imgSrc=s),t.onPreInit){var i=null;if("string"==typeof t.onPreInit)try{i=new Function("config",t.onPreInit)}catch(t){console.error('Can not compile "onPreInit" function: '+t.message)}else"function"==typeof t.onPreInit&&(i=t.onPreInit);i&&i.call(this,t)}e=new n(o,t),o.data(l,e)}e&&(o.removeData(l),e._destroy(),e=null),null==r?f.ajax({url:t,type:"GET",dataType:"json"}).done(function(t){r=f.isPlainObject(t)?t:{}}).fail(function(){r={}}).always(function(){i()}):i()})},f(".imgl-map").imagelinks()}(jQuery,window,document);