/**
 * Front js file, handles most of the js functionality.
 *
 * @package fwdrl
 * @since fwdrl 3.0
 */
 
jQuery(document).ready(function($){
    
    'use strict';

    var last_scroll = 0;
    var scrollObj;
    var ww = 0;
    var rlShow;
    var resized = 0;

    /**
     * Initialize main.
     */
    function init(){

        $(window).on('resize', resizeHandler);        
        $(window).on('scroll',function(){
            var scroll = $(window).scrollTop();
            if(Math.abs(scroll - last_scroll) > $(window).height() * 0.1){
                last_scroll = scroll;
                if(page == "main"){
                	startToUpdateCubes();
            	}
                revealStuff();
            }

            if(page == 'api'){
        		sideBarScroll();
        	}
        });

        setupRL();
       
        if(page == "main"){
        	$('.header').addClass('reveal');
        	initCubes();
        	registerGrid();
        	buildGrid();
        	addGridEvents();

            $('.home .play').on('click', function(e){
               rl0.show('tutorials', 0);
            });
        }else if(page == "api"){
        	$('.header').addClass('reveal-top');
        	initScrollToAnchor();
            hljs.initHighlightingOnLoad();
        }else if(page == "demo"){
        	$('.header').addClass('reveal');
        	$('.section1').addClass('reveal');
        	setupDemoGrids();
        }else if(page == "pricing"){
            $('.header').addClass('reveal');
        }

        if(window['docs']){
    		showDocs()
    	}
        
        initHeaderHome();
        revealStuff();
        resizeHandler();
        if(page == "main"){
        	startToUpdateCubes();
    	}else if(page == 'api'){
    		initSidebar();
    		sideBarScroll();
    		setTimeout(function(){
    			sideBarScroll();
    		}, 100);
    	}
        setTimeout(resizeHandler, 100);
    }

    function resizeHandler(){
       	ww = $(window).width();
      
        if(page == "main"){
        	resizeCube();
			buildGrid();
			resizeFeaturesImg();
			if(resized >= 2){
				resetGallery();
			}
   	    }else if(page == 'api'){
   	    	resizeSidebar();
   	    }

   	    resized ++;
    }

    // Menu.
    var vMenuShowed = false;
    $('.vertical-menu-toggle').on('click', function(){
        if(!vMenuShowed){
            vMenuShowed = true;
            $('.vertical-menu-toggle').addClass('vertical-menu--showed');
            $('.secondary-navigation').addClass('secondary-menu-show');
            $('#theme_holder').css({'z-index':1});
            $(window).on('click', closeSecondaryMenu);
        }else{
            vMenuShowed = false;
            $('.vertical-menu-toggle').removeClass('vertical-menu--showed');
            $('.secondary-navigation').removeClass('secondary-menu-show');
        }
    });

    function closeSecondaryMenu(e){
        var vmc = FWDRLUtils.getViewportMouseCoordinates(e);    
        if(!FWDRLUtils.hitTest($('.vertical-menu-toggle')[0], vmc.screenX, vmc.screenY)
          && !FWDRLUtils.hitTest($('.vertical-menu-toggle')[0], vmc.screenX, vmc.screenY)){
            vMenuShowed = false;
            $('.vertical-menu-toggle').removeClass('vertical-menu--showed');
            $('.secondary-navigation').removeClass('secondary-menu-show');
            $('#theme_holder').css({'z-index':200});
        }
    }


    // Scroll smooth.
   	var scrObj = {scrStart:0, scrEnd:0}
    function initScrollToAnchor(){
    	var anchors = document.querySelectorAll('a[href^="#"]');
    	for(var i=0; i<anchors.length; i++) {
	        anchors[i].addEventListener( 'click', anchor, false );   
	    }

	    window.addEventListener('wheel', stopScrollToAnchorAnim, false);
    	window.addEventListener('touchstart', stopScrollToAnchorAnim, false);

	    function anchor( event ) {
        
	        event.preventDefault(); 
	        event.stopPropagation();

	        scrObj.scrEnd = window.pageYOffset;

	        var id = this.getAttribute( 'href' ),
	            el = document.getElementById(id.replace('#', ''));
	        	scrObj.scrStart = el ? Math.round( el.getBoundingClientRect().top - document.body.getBoundingClientRect().top - 20) : null;

	        if(el){
	            scrObj.scrStart = Math.min(scrObj.scrStart, document.body.scrollHeight - window.innerHeight);
          		FWDAnimation.to(scrObj, .8, {scrEnd:scrObj.scrStart, onUpdate:function(e){
	            	window.scrollTo(0, scrObj.scrEnd);
	            }, ease:Expo.easeInOut});
	        }
	    }
    }

    function stopScrollToAnchorAnim(){
    	FWDAnimation.killTweensOf(scrObj);
    	//FWDAnimation.killTweensOf(scrObj2);
    }


    // Reveal stuff.
    function revealStuff(){ 
      	if(isVisible($('.demos-header'))){
           $('.demos-header').addClass('reveal');
        }

        if(isVisible($('.api-main'))){
           $('.api-main').addClass('reveal-top');
        }
 
        if(isVisible($('.multimedia'), -100)){
           $('.multimedia').addClass('reveal');
        }

        if(isVisible($('.section2'), -100)){
           $('.section2').addClass('reveal');
        }

        if(isVisible($('.section3'), -100)){
           $('.section3').addClass('reveal');
        }

        if(isVisible($('.section4'), -100)){
           $('.section4').addClass('reveal');
        }

        if(isVisible($('.gallery'), -200)){
           showGallery();
           $('.gallery').addClass('reveal');
        }

        if(isVisible($('.more-demos'), -200)){
           $('.more-demos').addClass('reveal');
        }

        $('.main-ft .ft-col.fwd-hide').each(function(index, element){
            if(isVisible($(this), -200)){
                $(this).addClass('reveal');
                setupFeaturedImages(index);
            }
        });

        $('.pricing .col').each(function(index, element){
            if(isVisible($(this), -200)){
                $(this).addClass('reveal');
            }
        });

        if(isVisible($('.passion'), -200)){
           $('.passion').addClass('reveal');
        }

        if(isVisible($('.features'), -200)){
           $('.features').addClass('reveal-top');
        }

        if(isVisible($('.boxes'), -200)){
           $('.boxes').addClass('reveal');
        }

        if(isVisible($('.quality .col1'), -200)){
           $('.quality .col1').addClass('reveal');
           showQuality(0);
        }

        if(isVisible($('.quality .col2'), -200)){
           $('.quality .col2').addClass('reveal');
           showQuality(1);
        }

        if(isVisible($('.ready'), -200)){
           $('.ready').addClass('reveal');
        }

        if(isVisible($('.footer-main'), -200)){
           $('.footer-main').addClass('reveal');
        }
    }

    function isVisible(element, offset, checkBottom, both){
        if(element.hasClass('reveal') || !element.length){
           return;
        }
        
        if(!offset){
            offset = 0;
        }  

        var scroll_pos = $(window).scrollTop();
        var window_height = $(window).height();
        var el_top = $(element).offset().top;
        var el_height = $(element).height();
        var el_bottom = el_top + el_height;
        var result = ((el_top - offset < scroll_pos + window_height));
        if(checkBottom){
        	result = (el_bottom - scroll_pos > 0);
        }else if(both){
        	result = ((el_top - offset + el_height) > scroll_pos && (el_top - offset - window_height) < scroll_pos);
        }
        return result;
    }


    /**
     * Help sidebar.
     */
    var sBar = $('aside');
    var sBarHolder = $('main');
    var scrObj2 = {'offsetTop':0}
    var curSideClick;
    var asideShowed = false;
    
    var mainA;
    var sideA;

    $('.help-menu-toggle').on('click', function(e){
    	 if(!asideShowed){
    	 	asideShowed = true;
    	 	$('aside').addClass('showed');
    	 	$(window).on('click', closeAside);
    	 }else{
    	 	asideShowed = false;
    	 	$('aside').removeClass('showed');
    	 }
    });

    function closeAside(e){
        var vmc = FWDRLUtils.getViewportMouseCoordinates(e);    

        if(!FWDRLUtils.hitTest($('aside')[0], vmc.screenX, vmc.screenY)
        && !FWDRLUtils.hitTest($('.help-menu-toggle')[0], vmc.screenX, vmc.screenY)){
           asideShowed = false;
           $('aside').removeClass('showed');
        }
    }
   
    function initSidebar(){
    	sideA = $('.api-main aside')[0].querySelectorAll('[href]');
    	mainA = $('.api-main main')[0].querySelectorAll('[id]:not(.img)');
    	
    	for(var i=0; i<mainA.length; i++){
    		var el = mainA[i];
    	}
    	for(var i=0; i<sideA.length; i++){
    		var el = sideA[i];
    		
    		el.addEventListener('click', function(e){
    			
    			for(var i=0; i<sideA.length; i++){
    				var el = sideA[i];
    				el.className = '';
    			}
    			curSideClick = e.target;
    			setTimeout(function(){
    				curSideClick.className = 'active';
    			}, 250)
    			
    		})
    	}
    }

    function resizeSidebar(){
    	//var wW = window.outerWidth;	
    	//sBar.css({'height':(wH - 40) + 'px'});
    }

    function sideBarScroll(){

    	var wH = window.innerHeight;
    	var scroll_pos = $(window).scrollTop();
    	var top = sBarHolder.offset().top;
    	if(scroll_pos > top - 20){
    		sBar.css({'position': 'fixed', 'top':20})
    	}else{
    		sBar.css({'position': 'absolute', 'top':0})
    	}

    	for(var i=0; i<mainA.length; i++){
    		var el = mainA[i];
    		var nextEl = mainA[i + 1];
    		var next2El = mainA[i + 2];
    		var curEl = mainA[0];

    		if(el.getBoundingClientRect().y < 100){
    			curEl = el;
    		}

    		for(var j=0; j<mainA.length; j++){
    			var el2 =  mainA[j];
    			if(el2.getBoundingClientRect().y < 100){
					curEl = el2;
				}
    		}
    	}

    	for(var i=0; i<sideA.length; i++){
    		var el = sideA[i];
    		el.className = '';
    		
    		if(curEl.id == el.href.match(/#(.*)/g)[0].substr(1)){
    			curEl = el;
    			curEl.className = 'active';
    		}
    	}

    	/*if(prevEl != curEl){
    	   scrObj2.offsetTop = sBar[0].scrollTop;
    	   FWDAnimation.killTweensOf(scrObj2)
		   FWDAnimation.to(scrObj2, .8,{offsetTop:curEl.offsetTop, onUpdate:function(e){
            	//sBar[0].scrollTop  = scrObj2.offsetTop;
           }, ease:Expo.easeOut});
    	}*/
    	//prevEl = curEl;

    }


    /**
     * Setup RL.
     */
    function setupRL(){
    	new FWDRL({	
			instanceName:"rl0",
			mainFolderPath:"content",
			volume: .9,
            rightClickContextMenu: "disabled"
		});

        
        rl0.addListener(FWDRL.EVP_STOP, function(e){
           if(e.guId == 'tutorials'){
               rl0.hide();
           }
        })

		rl0.addListener(FWDRL.SHOW_START, function(e){
			rlShow = true;
			if(page == "main"){
				stopToUpdateCubes();
			}
			
			if(e.guId == 'single_items_gallery'){
				rl0.showThumbnails = false,
				rl0.showSlideShowButton = false,
				rl0.showCounter = false,
				rl0.useDrag = false,
				rl0.showNextAndPrevBtns = false

				if(e.mId == 11){
					rl0.shareButtons = [];
					rl0.showFullscreenButton = false;
				}
			}else if(e.guId == 'image_gallery_gallery'){
				rl0.buttonsAlignment = 'top';
				if(e.mId == 1){
					rl0.captionPosition = "bottomin";
				}else if(e.mId == 2){
					rl0.captionPosition = "topin";
				}else if(e.mId == 3){
					rl0.caption = false;
				}else if(e.mId == 4){
					rl0.buttonsAlignment = 'in';
				}else if(e.mId == 5){
					rl0.buttonsAlignment = 'out';
				}else if(e.mId == 6){
					rl0.slideShowAutoPlay = true;
				}else if(e.mId == 7){
					rl0.showSlideShowButton = false;
					rl0.slideShowAutoPlay = true;
				}else if(e.mId == 8){
					rl0.showThumbnails = false;
				}else if(e.mId == 9){
					rl0.showThumbnails = false;
					rl0.caption = false;
				}else if(e.mId == 10){
					rl0.shareButtons = [];
					rl0.showZoomButton = false;
					rl0.showFullscreenButton = false;
					rl0.showSlideShowButton = false;
					rl0.showThumbnails = false;
					rl0.caption = false;
				}else if(e.mId == 11){
					rl0.shareButtons = [];
					rl0.showNextAndPrevBtns = false
					rl0.showCloseButton = false;
					rl0.showZoomButton = false;
					rl0.showFullscreenButton = false;
					rl0.showSlideShowButton = false;
					rl0.showThumbnails = false;
					rl0.caption = false;
				}
			}else if(e.guId == 'video_gallery_gallery'){
				if(e.mId == 1){
					rl0.videoAutoPlay = true;
					rl0.nextVideoAutoPlay = true;
				}
			}else if(e.guId == 'tutorials'){
                rl0.videoAutoPlay = true;   
                rl0.showFullscreenButton = false;
            }
		});	

		rl0.addListener(FWDRL.HIDE_START, function(){
			rlShow = false;
			if(page == "main"){
				startToUpdateCubes();
			}
		});		
    }

    /**
     * Header home.
     */
     function initHeaderHome(){
     	$('.header .play svg').on('mouseover', function(e){
     		$(e.currentTarget).addClass('tutorial-animation');
     	});

     	$('.header .play svg').on('mouseleave', function(e){
     		$(e.currentTarget).removeClass('tutorial-animation');
     	});
     }

     /**
     * Featured images.
     */
     function resizeFeaturesImg(){
        var sw = $(window).outerWidth();
      
        if(sw > 950){
     	    var containerW = 1290;
            var containerH = 508;
            var scale = $('.main-ft').width() / containerW;
            var h = Math.round(containerH * scale);
            $('.main-ft .image').each(function(indx, el){
                $(el).height(h);
            });
        }else{
            var containerW = 860;
            var containerH = 569;
            var scale = $('.main-ft').width() / containerW;
            var h = Math.round(containerH * scale);
            $('.main-ft .image').each(function(indx, el){
                $(el).height(h);
            });
        }
    }


    function showDocs(){
       
        new FWDSI({ 
            //main settings
            instanceName:"presets_img_",
            displayType:"responsive",
            parentId:"presets_img",
            imageSource:"assets/preset.jpg",
            initializeOnlyWhenVisible:"yes",
            maskType:"square",
            showPreloader:'no',
            maxWidth:1844,
            maxHeight:948
        });

        new FWDSI({ 
            //main settings
            instanceName:"playlist_img_",
            displayType:"responsive",
            parentId:"playlist_img",
            imageSource:"assets/playlist.jpg",
            initializeOnlyWhenVisible:"yes",
            maskType:"square",
            showPreloader:'no',
            maxWidth:900,
            maxHeight:744
        });

        new FWDSI({ 
            //main settings
            instanceName:"track_img_",
            displayType:"responsive",
            parentId:"track_img",
            imageSource:"assets/track.jpg",
            initializeOnlyWhenVisible:"yes",
            maskType:"square",
            showPreloader:'no',
            maxWidth:995,
            maxHeight:835
        });

        new FWDSI({ 
            //main settings
            instanceName:"shortcode_img_",
            displayType:"responsive",
            parentId:"shortcode_img",
            imageSource:"assets/shortcode.jpg",
            initializeOnlyWhenVisible:"yes",
            maskType:"square",
            showPreloader:'no',
            maxWidth:1361,
            maxHeight:790
        });
      	

    	$('#presets_img').on('click', function(){
    		rl0.show('gallery', 0, 'docsProps')
    	});

        $('#playlist_img').on('click', function(){
            rl0.show('gallery', 1, 'docsProps')
        });

        $('#track_img').on('click', function(){
            rl0.show('gallery', 2, 'docsProps')
        });

         $('#shortcode_img').on('click', function(){
            rl0.show('gallery', 3, 'docsProps')
        });
    }

    window['docsProps'] = {
    	buttonsAlignment:'top',
    	shareButtons:[],
		showThumbnails:false,
		showSlideShowButton:false,
		showCounter:false,
		useDrag:false,
		showNextAndPrevBtns:false
	}

	// Init.
	init();
});


/*! highlight.js */
!function(e){var n="object"==typeof window&&window||"object"==typeof self&&self;"undefined"!=typeof exports?e(exports):n&&(n.hljs=e({}),"function"==typeof define&&define.amd&&define([],function(){return n.hljs}))}(function(e){function n(e){return e.replace(/[&<>]/gm,function(e){return I[e]})}function t(e){return e.nodeName.toLowerCase()}function r(e,n){var t=e&&e.exec(n);return t&&0===t.index}function i(e){return k.test(e)}function a(e){var n,t,r,a,o=e.className+" ";if(o+=e.parentNode?e.parentNode.className:"",t=B.exec(o))return R(t[1])?t[1]:"no-highlight";for(o=o.split(/\s+/),n=0,r=o.length;r>n;n++)if(a=o[n],i(a)||R(a))return a}function o(e,n){var t,r={};for(t in e)r[t]=e[t];if(n)for(t in n)r[t]=n[t];return r}function u(e){var n=[];return function r(e,i){for(var a=e.firstChild;a;a=a.nextSibling)3===a.nodeType?i+=a.nodeValue.length:1===a.nodeType&&(n.push({event:"start",offset:i,node:a}),i=r(a,i),t(a).match(/br|hr|img|input/)||n.push({event:"stop",offset:i,node:a}));return i}(e,0),n}function c(e,r,i){function a(){return e.length&&r.length?e[0].offset!==r[0].offset?e[0].offset<r[0].offset?e:r:"start"===r[0].event?e:r:e.length?e:r}function o(e){function r(e){return" "+e.nodeName+'="'+n(e.value)+'"'}l+="<"+t(e)+w.map.call(e.attributes,r).join("")+">"}function u(e){l+="</"+t(e)+">"}function c(e){("start"===e.event?o:u)(e.node)}for(var s=0,l="",f=[];e.length||r.length;){var g=a();if(l+=n(i.substring(s,g[0].offset)),s=g[0].offset,g===e){f.reverse().forEach(u);do c(g.splice(0,1)[0]),g=a();while(g===e&&g.length&&g[0].offset===s);f.reverse().forEach(o)}else"start"===g[0].event?f.push(g[0].node):f.pop(),c(g.splice(0,1)[0])}return l+n(i.substr(s))}function s(e){function n(e){return e&&e.source||e}function t(t,r){return new RegExp(n(t),"m"+(e.cI?"i":"")+(r?"g":""))}function r(i,a){if(!i.compiled){if(i.compiled=!0,i.k=i.k||i.bK,i.k){var u={},c=function(n,t){e.cI&&(t=t.toLowerCase()),t.split(" ").forEach(function(e){var t=e.split("|");u[t[0]]=[n,t[1]?Number(t[1]):1]})};"string"==typeof i.k?c("keyword",i.k):E(i.k).forEach(function(e){c(e,i.k[e])}),i.k=u}i.lR=t(i.l||/\w+/,!0),a&&(i.bK&&(i.b="\\b("+i.bK.split(" ").join("|")+")\\b"),i.b||(i.b=/\B|\b/),i.bR=t(i.b),i.e||i.eW||(i.e=/\B|\b/),i.e&&(i.eR=t(i.e)),i.tE=n(i.e)||"",i.eW&&a.tE&&(i.tE+=(i.e?"|":"")+a.tE)),i.i&&(i.iR=t(i.i)),null==i.r&&(i.r=1),i.c||(i.c=[]);var s=[];i.c.forEach(function(e){e.v?e.v.forEach(function(n){s.push(o(e,n))}):s.push("self"===e?i:e)}),i.c=s,i.c.forEach(function(e){r(e,i)}),i.starts&&r(i.starts,a);var l=i.c.map(function(e){return e.bK?"\\.?("+e.b+")\\.?":e.b}).concat([i.tE,i.i]).map(n).filter(Boolean);i.t=l.length?t(l.join("|"),!0):{exec:function(){return null}}}}r(e)}function l(e,t,i,a){function o(e,n){var t,i;for(t=0,i=n.c.length;i>t;t++)if(r(n.c[t].bR,e))return n.c[t]}function u(e,n){if(r(e.eR,n)){for(;e.endsParent&&e.parent;)e=e.parent;return e}return e.eW?u(e.parent,n):void 0}function c(e,n){return!i&&r(n.iR,e)}function g(e,n){var t=N.cI?n[0].toLowerCase():n[0];return e.k.hasOwnProperty(t)&&e.k[t]}function h(e,n,t,r){var i=r?"":y.classPrefix,a='<span class="'+i,o=t?"":C;return a+=e+'">',a+n+o}function p(){var e,t,r,i;if(!E.k)return n(B);for(i="",t=0,E.lR.lastIndex=0,r=E.lR.exec(B);r;)i+=n(B.substring(t,r.index)),e=g(E,r),e?(M+=e[1],i+=h(e[0],n(r[0]))):i+=n(r[0]),t=E.lR.lastIndex,r=E.lR.exec(B);return i+n(B.substr(t))}function d(){var e="string"==typeof E.sL;if(e&&!x[E.sL])return n(B);var t=e?l(E.sL,B,!0,L[E.sL]):f(B,E.sL.length?E.sL:void 0);return E.r>0&&(M+=t.r),e&&(L[E.sL]=t.top),h(t.language,t.value,!1,!0)}function b(){k+=null!=E.sL?d():p(),B=""}function v(e){k+=e.cN?h(e.cN,"",!0):"",E=Object.create(e,{parent:{value:E}})}function m(e,n){if(B+=e,null==n)return b(),0;var t=o(n,E);if(t)return t.skip?B+=n:(t.eB&&(B+=n),b(),t.rB||t.eB||(B=n)),v(t,n),t.rB?0:n.length;var r=u(E,n);if(r){var i=E;i.skip?B+=n:(i.rE||i.eE||(B+=n),b(),i.eE&&(B=n));do E.cN&&(k+=C),E.skip||(M+=E.r),E=E.parent;while(E!==r.parent);return r.starts&&v(r.starts,""),i.rE?0:n.length}if(c(n,E))throw new Error('Illegal lexeme "'+n+'" for mode "'+(E.cN||"<unnamed>")+'"');return B+=n,n.length||1}var N=R(e);if(!N)throw new Error('Unknown language: "'+e+'"');s(N);var w,E=a||N,L={},k="";for(w=E;w!==N;w=w.parent)w.cN&&(k=h(w.cN,"",!0)+k);var B="",M=0;try{for(var I,j,O=0;;){if(E.t.lastIndex=O,I=E.t.exec(t),!I)break;j=m(t.substring(O,I.index),I[0]),O=I.index+j}for(m(t.substr(O)),w=E;w.parent;w=w.parent)w.cN&&(k+=C);return{r:M,value:k,language:e,top:E}}catch(T){if(T.message&&-1!==T.message.indexOf("Illegal"))return{r:0,value:n(t)};throw T}}function f(e,t){t=t||y.languages||E(x);var r={r:0,value:n(e)},i=r;return t.filter(R).forEach(function(n){var t=l(n,e,!1);t.language=n,t.r>i.r&&(i=t),t.r>r.r&&(i=r,r=t)}),i.language&&(r.second_best=i),r}function g(e){return y.tabReplace||y.useBR?e.replace(M,function(e,n){return y.useBR&&"\n"===e?"<br>":y.tabReplace?n.replace(/\t/g,y.tabReplace):void 0}):e}function h(e,n,t){var r=n?L[n]:t,i=[e.trim()];return e.match(/\bhljs\b/)||i.push("hljs"),-1===e.indexOf(r)&&i.push(r),i.join(" ").trim()}function p(e){var n,t,r,o,s,p=a(e);i(p)||(y.useBR?(n=document.createElementNS("http://www.w3.org/1999/xhtml","div"),n.innerHTML=e.innerHTML.replace(/\n/g,"").replace(/<br[ \/]*>/g,"\n")):n=e,s=n.textContent,r=p?l(p,s,!0):f(s),t=u(n),t.length&&(o=document.createElementNS("http://www.w3.org/1999/xhtml","div"),o.innerHTML=r.value,r.value=c(t,u(o),s)),r.value=g(r.value),e.innerHTML=r.value,e.className=h(e.className,p,r.language),e.result={language:r.language,re:r.r},r.second_best&&(e.second_best={language:r.second_best.language,re:r.second_best.r}))}function d(e){y=o(y,e)}function b(){if(!b.called){b.called=!0;var e=document.querySelectorAll("pre code");w.forEach.call(e,p)}}function v(){addEventListener("DOMContentLoaded",b,!1),addEventListener("load",b,!1)}function m(n,t){var r=x[n]=t(e);r.aliases&&r.aliases.forEach(function(e){L[e]=n})}function N(){return E(x)}function R(e){return e=(e||"").toLowerCase(),x[e]||x[L[e]]}var w=[],E=Object.keys,x={},L={},k=/^(no-?highlight|plain|text)$/i,B=/\blang(?:uage)?-([\w-]+)\b/i,M=/((^(<[^>]+>|\t|)+|(?:\n)))/gm,C="</span>",y={classPrefix:"hljs-",tabReplace:null,useBR:!1,languages:void 0},I={"&":"&amp;","<":"&lt;",">":"&gt;"};return e.highlight=l,e.highlightAuto=f,e.fixMarkup=g,e.highlightBlock=p,e.configure=d,e.initHighlighting=b,e.initHighlightingOnLoad=v,e.registerLanguage=m,e.listLanguages=N,e.getLanguage=R,e.inherit=o,e.IR="[a-zA-Z]\\w*",e.UIR="[a-zA-Z_]\\w*",e.NR="\\b\\d+(\\.\\d+)?",e.CNR="(-?)(\\b0[xX][a-fA-F0-9]+|(\\b\\d+(\\.\\d*)?|\\.\\d+)([eE][-+]?\\d+)?)",e.BNR="\\b(0b[01]+)",e.RSR="!|!=|!==|%|%=|&|&&|&=|\\*|\\*=|\\+|\\+=|,|-|-=|/=|/|:|;|<<|<<=|<=|<|===|==|=|>>>=|>>=|>=|>>>|>>|>|\\?|\\[|\\{|\\(|\\^|\\^=|\\||\\|=|\\|\\||~",e.BE={b:"\\\\[\\s\\S]",r:0},e.ASM={cN:"string",b:"'",e:"'",i:"\\n",c:[e.BE]},e.QSM={cN:"string",b:'"',e:'"',i:"\\n",c:[e.BE]},e.PWM={b:/\b(a|an|the|are|I'm|isn't|don't|doesn't|won't|but|just|should|pretty|simply|enough|gonna|going|wtf|so|such|will|you|your|like)\b/},e.C=function(n,t,r){var i=e.inherit({cN:"comment",b:n,e:t,c:[]},r||{});return i.c.push(e.PWM),i.c.push({cN:"doctag",b:"(?:TODO|FIXME|NOTE|BUG|XXX):",r:0}),i},e.CLCM=e.C("//","$"),e.CBCM=e.C("/\\*","\\*/"),e.HCM=e.C("#","$"),e.NM={cN:"number",b:e.NR,r:0},e.CNM={cN:"number",b:e.CNR,r:0},e.BNM={cN:"number",b:e.BNR,r:0},e.CSSNM={cN:"number",b:e.NR+"(%|em|ex|ch|rem|vw|vh|vmin|vmax|cm|mm|in|pt|pc|px|deg|grad|rad|turn|s|ms|Hz|kHz|dpi|dpcm|dppx)?",r:0},e.RM={cN:"regexp",b:/\//,e:/\/[gimuy]*/,i:/\n/,c:[e.BE,{b:/\[/,e:/\]/,r:0,c:[e.BE]}]},e.TM={cN:"title",b:e.IR,r:0},e.UTM={cN:"title",b:e.UIR,r:0},e.METHOD_GUARD={b:"\\.\\s*"+e.UIR,r:0},e});hljs.registerLanguage("xml",function(s){var e="[A-Za-z0-9\\._:-]+",t={eW:!0,i:/</,r:0,c:[{cN:"attr",b:e,r:0},{b:/=\s*/,r:0,c:[{cN:"string",endsParent:!0,v:[{b:/"/,e:/"/},{b:/'/,e:/'/},{b:/[^\s"'=<>`]+/}]}]}]};return{aliases:["html","xhtml","rss","atom","xjb","xsd","xsl","plist"],cI:!0,c:[{cN:"meta",b:"<!DOCTYPE",e:">",r:10,c:[{b:"\\[",e:"\\]"}]},s.C("<!--","-->",{r:10}),{b:"<\\!\\[CDATA\\[",e:"\\]\\]>",r:10},{b:/<\?(php)?/,e:/\?>/,sL:"php",c:[{b:"/\\*",e:"\\*/",skip:!0}]},{cN:"tag",b:"<style(?=\\s|>|$)",e:">",k:{name:"style"},c:[t],starts:{e:"</style>",rE:!0,sL:["css","xml"]}},{cN:"tag",b:"<script(?=\\s|>|$)",e:">",k:{name:"script"},c:[t],starts:{e:"</script>",rE:!0,sL:["actionscript","javascript","handlebars","xml"]}},{cN:"meta",v:[{b:/<\?xml/,e:/\?>/,r:10},{b:/<\?\w+/,e:/\?>/}]},{cN:"tag",b:"</?",e:"/?>",c:[{cN:"name",b:/[^\/><\s]+/,r:0},t]}]}});hljs.registerLanguage("javascript",function(e){var r="[A-Za-z$_][0-9A-Za-z$_]*",t={keyword:"in of if for while finally var new function do return void else break catch instanceof with throw case default try this switch continue typeof delete let yield const export super debugger as async await static import from as",literal:"true false null undefined NaN Infinity",built_in:"eval isFinite isNaN parseFloat parseInt decodeURI decodeURIComponent encodeURI encodeURIComponent escape unescape Object Function Boolean Error EvalError InternalError RangeError ReferenceError StopIteration SyntaxError TypeError URIError Number Math Date String RegExp Array Float32Array Float64Array Int16Array Int32Array Int8Array Uint16Array Uint32Array Uint8Array Uint8ClampedArray ArrayBuffer DataView JSON Intl arguments require module console window document Symbol Set Map WeakSet WeakMap Proxy Reflect Promise"},a={cN:"number",v:[{b:"\\b(0[bB][01]+)"},{b:"\\b(0[oO][0-7]+)"},{b:e.CNR}],r:0},n={cN:"subst",b:"\\$\\{",e:"\\}",k:t,c:[]},c={cN:"string",b:"`",e:"`",c:[e.BE,n]};n.c=[e.ASM,e.QSM,c,a,e.RM];var s=n.c.concat([e.CBCM,e.CLCM]);return{aliases:["js","jsx"],k:t,c:[{cN:"meta",r:10,b:/^\s*['"]use (strict|asm)['"]/},{cN:"meta",b:/^#!/,e:/$/},e.ASM,e.QSM,c,e.CLCM,e.CBCM,a,{b:/[{,]\s*/,r:0,c:[{b:r+"\\s*:",rB:!0,r:0,c:[{cN:"attr",b:r,r:0}]}]},{b:"("+e.RSR+"|\\b(case|return|throw)\\b)\\s*",k:"return throw case",c:[e.CLCM,e.CBCM,e.RM,{cN:"function",b:"(\\(.*?\\)|"+r+")\\s*=>",rB:!0,e:"\\s*=>",c:[{cN:"params",v:[{b:r},{b:/\(\s*\)/},{b:/\(/,e:/\)/,eB:!0,eE:!0,k:t,c:s}]}]},{b:/</,e:/(\/\w+|\w+\/)>/,sL:"xml",c:[{b:/<\w+\s*\/>/,skip:!0},{b:/<\w+/,e:/(\/\w+|\w+\/)>/,skip:!0,c:[{b:/<\w+\s*\/>/,skip:!0},"self"]}]}],r:0},{cN:"function",bK:"function",e:/\{/,eE:!0,c:[e.inherit(e.TM,{b:r}),{cN:"params",b:/\(/,e:/\)/,eB:!0,eE:!0,c:s}],i:/\[|%/},{b:/\$[(.]/},e.METHOD_GUARD,{cN:"class",bK:"class",e:/[{;=]/,eE:!0,i:/[:"\[\]]/,c:[{bK:"extends"},e.UTM]},{bK:"constructor",e:/\{/,eE:!0}],i:/#(?!!)/}});