<?php
/*
Plugin Name: MP3 Sticky Player
Plugin URI: http://codecanyon.net/user/FWDesign/portfolio
Description: This is the WordPress plugin with a CMS menu for the installation and configuration of the MP3 Sticky Player.
Author: FWD
Text Domain: fwdmsp
Version: 7.5.1
Author URI: https://webdesign-flash.ro/
*/


include_once "php/FWDMSP.php";
include_once "php/FWDMSPData.php";

function fwdmsp_check_if_admin(){
	$roles = wp_get_current_user()->roles;
	$role = "administrator";
	 
	return in_array($role, $roles);
}

function fwdmsp_admin_init(){
	if (fwdmsp_check_if_admin()){
		$role = get_role("administrator");
		$role->add_cap(FWDMSP::CAPABILITY);
	}
}

function fwdmsp_init_plugin(){	
	$msp = new FWDMSP();
	$msp->init();
}

add_action("init", "fwdmsp_init_plugin");
add_action("admin_init", "fwdmsp_admin_init");
add_filter("plugin_action_links_" . plugin_basename(__FILE__), array("FWDMSP", "fwdmsp_set_action_links"));

?>