/**
 * Shortcode.
 *
 * @package fwdmsp
 * @since fwdmsp 1.0
 */

jQuery(document).ready(function($){
	
	'use strict';
	
	fwdmspPresetsObj = unescapeHtml(fwdmspPresetsObj);
  	fwdmspPresetsObj = JSON.parse(fwdmspPresetsObj);

  	fwdmspMainPlaylistsObj = unescapeHtml(fwdmspMainPlaylistsObj);
  	fwdmspMainPlaylistsObj = JSON.parse(fwdmspMainPlaylistsObj);

  	fwdmspPlaylists_ar = unescapeHtml(fwdmspPlaylists_ar);
  	fwdmspPlaylists_ar = JSON.parse(fwdmspPlaylists_ar);


	$(".fwdmsp-meta-box img").fwdTooltip({
    
  	});

	$.each(fwdmspPresetsObj, function(i, el){
		$("#fwdmsp_presets_list").append('<option value="' + el.name + '">' + el.name + '</option>');
		setShortodeIntext();
	});

	$("#fwdmsp_presets_list").change(function(){
		sid = $("#fwdmsp_presets_list").val();
		setShortodeIntext();
	});

	$("#fwdmsp_start_at_playlist_list").change(function(){
		curPlId = $('#fwdmsp_start_at_playlist_list option:selected').index();
		curPl = mainPl[curPlId - 1];
		setShortodeIntext();
	});

	$("#fwdmsp_start_at_track_select").change(function(){
		setShortodeIntext();
	});

	$('#fwdmsp_start_at_track_input').on('keyup', function(){
		setShortodeIntext();
	});
	
	$("#fwdmsp_div").hide();

	var mainPl;
	var mplId = 0;
	var prevMplId = -1;
	var curPl;
	var curPlId = 0;
	var prevCurPlId = -1;
	var plType;

	function setShortodeIntext(){
		if(fwdmspMainPlaylistsObj.length > 0){
			
			mplId = $('#fwdmsp_main_playlists_list option:selected').index();
		
			if(fwdmspPlaylists_ar.length){
				
				if(!fwdmspPlaylists_ar[mplId]) return;

				// Main playlist.
				mainPl = fwdmspPlaylists_ar[mplId]['playlists'];

				// Cur playlist.
				if(prevMplId != mainPl){
					$("#fwdmsp_start_at_playlist_list").empty();
					$("#fwdmsp_start_at_playlist_list").prepend("<option value='preset'>preset</option>")
					$.each(mainPl, function(i, el){
						$("#fwdmsp_start_at_playlist_list").append('<option value="' + el.name + '">' + el.name + '</option>');
					});
					$('#fwdmsp_start_at_track_input').val('');
				}
				
				curPl = mainPl[curPlId - 1];
				if(curPl){
					plType = curPl.type;
				}else{
					plType = undefined;
				}
				
				if(prevCurPlId != curPlId){
					$("#fwdmsp_start_at_track_select").empty();
					$("#fwdmsp_start_at_track_select").prepend("<option value='preset'>preset</option>")
					if(curPl && curPl['tracks']){	
						$.each(curPl['tracks'], function(i, el){
							$("#fwdmsp_start_at_track_select").append('<option value="' + el.name + '">' + el.name + '</option>');
						});
					}
					$('#fwdmsp_start_at_track_input').val('');
				}
			
				prevMplId = mainPl;
				prevCurPlId = curPlId;
			}
			var startAtSubplaylPlaylist = '';
			var startAtTrack = $('#fwdmsp_start_at_track_input').val();

			if(curPl){
				startAtSubplaylPlaylist = $('#fwdmsp_start_at_playlist_list').val();
				if(plType == 'normal'){
					startAtTrack = $('#fwdmsp_start_at_track_select').val();
				}
			}else{
				startAtSubplaylPlaylist = 'preset';
			}
			
			if(!mainPl.length){
				startAtSubplaylPlaylist = 'preset';
				startAtTrack = 'preset';
			}
			
			$("#fwdmsp_shortocde").show();
			$("#fwdmsp_shortocde").val('[fwdmsp preset_id="' + sid + '" playlist_id="' + pid + '" start_playlist_id="' + startAtSubplaylPlaylist  + '" start_track_id="' + startAtTrack + '"]');
		}else{
			$("#fwdmsp_shortocde").hide();
		}

		hideShowDetails();
		
	}

	function hideShowDetails(){
		
		if(!mainPl || !mainPl.length){
			$('#fwdmsp-pl').css({'display':'none'});
			$('#fwdmsp-track-select').css({'display':'none'});
			$('#fwdmsp-track-input').css({'display':'none'});
		}else{
			$('#fwdmsp-pl').css({'display':'table-row'});
			$('#fwdmsp-track-select').css({'display':'table-row'});
			$('#fwdmsp-track-input').css({'display':'table-row'});

			if(!plType || plType != 'normal'){
				$('#fwdmsp-track-select').css({'display':'none'});
				$('#fwdmsp-track-input').css({'display':'table-row'});
			}else{
				$('#fwdmsp-track-select').css({'display':'table-row'});
				$('#fwdmsp-track-input').css({'display':'none'});
			}
		}
	}
		
	if(fwdmspMainPlaylistsObj.length > 0){
		$.each(fwdmspMainPlaylistsObj, function(i, el){
			$("#fwdmsp_main_playlists_list").append('<option value="' + el.name + '">' + el.name + "</option>");
		});

		$("#fwdmsp_main_playlists_list").change(function(){	
			pid = $("#fwdmsp_main_playlists_list").val();
			curPlId = 0;
			prevMplId = -1;
			prevCurPlId = -1;
			setShortodeIntext();
		});
		
		var sid = $("#fwdmsp_presets_list").val();
		var pid = $("#fwdmsp_main_playlists_list").val();

		$("#fwdmsp_shortcode_btn").click(function(){		
			var shortcode = '[fwdmsp preset_id="' + sid + '" playlist_id="' + pid + '"]';
		
			if (typeof tinymce != "undefined"){
			    var editor = tinymce.get("content");
			    
			    if (editor && (editor instanceof tinymce.Editor) && ($("textarea#content:hidden").length != 0)){
			        editor.selection.setContent(shortcode);
			        editor.save({no_events: true});
			    }else{
					var text = $("textarea#content").val();
					var select_pos1 = $("textarea#content").prop("selectionStart");
					var select_pos2 = $("textarea#content").prop("selectionEnd");
					
					var new_text = text.slice(0, select_pos1) + shortcode + text.slice(select_pos2);
					
					$("textarea#content").val(new_text);
			    } 
			}else{
				var text = $("textarea#content").val();
				var select_pos1 = $("textarea#content").prop("selectionStart");
				var select_pos2 = $("textarea#content").prop("selectionEnd");
				
				var new_text = text.slice(0, select_pos1) + shortcode + text.slice(select_pos2);
				
				$("textarea#content").val(new_text);
			}
			
			$("#fwdmsp_div").hide();
			$("#fwdmsp_div").fadeIn(600);
			$("#fwdmsp_msg").html("The shortcode has been added!");
			return false;
		});
	}else{
		var td = $("#fwdmsp_main_playlists_list").parent();
		
		$("#fwdmsp_main_playlists_list").remove();
		td.append("<em>No playlists are available.</em>");
		
		$("#fwdmsp_shortcode_btn").prop("disabled", true);
		$("#fwdmsp_shortcode_btn").css("cursor", "default");
	}
	
	setShortodeIntext();

	// Utils.
	function escapeHtml(str) {
	    var map = {
	        "&": "&amp;",
	        "<": "&lt;",
	        ">": "&gt;",
	        "\"": "&quot;",
	        "'": "&#039;"
	    };
	    str = str.replace(/'/g, "\"");
	    return str.replace(/[&<>"']/g, function(m) { return map[m]; });
	}

  	function unescapeHtml(str) {
	    var map = {
	        "&amp;": "&",
	        "&lt;": "<",
	        "&gt;": ">",
	        "&quot;": "\"",
	        "&#039;": "'"
	    };
	    return str.replace(/(&amp;|&lt;|&gt;|&quot;|&#039;)/g, function(m) { return map[m]; });
  	}

	function removeFirstAndLastChar(str){
	    str = str.substring(1);
	    str = str.slice(0, -1);
	    return str;
	}
});