<?php
/**
 * Main class.
 *
 * @package fwdmsp
 * @since fwdmsp 1.0
 */

class FWDMSP{
	
	const MIN_WP_VER =  "3.5.0";
	const CAPABILITY = "edit_fwdmsp";
	const VERSION = '7.5.1';
	private $_msg;
	private $_data;
	private $_dir_url;
    private static $_msp_id = 0;
    private static $_pl_id = 0;
    

    // Initialize.
    public function init(){
		$this->_dir_url = plugin_dir_url(dirname(__FILE__));
	
    	// Set hooks.
    	add_action("admin_menu", array($this, "fwdmps_add_plugin_menu"));
		add_shortcode("fwdmsp", array($this, "fwdmsp_fwdmsp_set_player"));
		add_action('admin_enqueue_scripts', array($this, "fwdmsp_enqueue_admin_files"));
		add_action("wp_enqueue_scripts", array($this, "fwdmsp_add_scripts_and_styles"));
		
		// Set data.
		$this->_data = new FWDMSPData();
		$this->_data->init();

		// Make plugin available for translation.
		load_plugin_textdomain('fwdmsp', false, basename(realpath(__DIR__ . '/..')) . '/languages/');
    }
	

    // Add plugin menu.
    public function fwdmps_add_plugin_menu(){

    	// Add menus.
        add_menu_page("Player Title", "MP3 Sticky Player", FWDMSP::CAPABILITY, "fwdmsp-menu-general-settings", array($this, "fwdmsp_set_general_settings"), esc_url_raw($this->_dir_url) . "content/icons/menu-icon.png");
       	add_submenu_page("fwdmsp-menu-general-settings", __('General settings', 'fwdmsp'), __('General settings', 'fwdmsp'), FWDMSP::CAPABILITY, "fwdmsp-menu-general-settings");
       	add_submenu_page("fwdmsp-menu-general-settings", __('Playlists manager', 'fwdmsp'), __('Playlists manager', 'fwdmsp'), FWDMSP::CAPABILITY, "fwdmsp-menu-Playlists-Manager", array($this, "fwdmsp_set_playlists_manager"));
       	add_submenu_page("fwdmsp-menu-general-settings", __('CSS Editor', 'fwdmsp'), __('CSS Editor', 'fwdmsp'), FWDMSP::CAPABILITY, "fwdmsp-menu-CSS-Editor", array($this, "fwdmsp_set_css_editor"));
       	
       	// Add meta boxes.
       	$post_type_screens = array("post", "page");
       	$args = array(
	       'public'   => true,
	       '_builtin' => false,
	    );
       	$custom_post_types = get_post_types($args);
       	foreach ($custom_post_types as $screen){
       		$post_type_screens[] = $screen;
       	}

    	foreach ($post_type_screens as $screen){
       		add_meta_box("fwdmsp-shortcode-generator", "MP3 Sticky Player Shortcode Generator",  array($this, "fwdmsp_set_custom_meta_box"), $screen, "side", "default");
    	}
    }


    // Add backend files.
    public function fwdmsp_enqueue_admin_files($hook){

    	// Playlist manager.
    	if($hook == 'mp3-sticky-player_page_fwdmsp-menu-Playlists-Manager'){
    		wp_enqueue_style("fwdmsp_playlist_manager", esc_url_raw($this->_dir_url) . "css/playlist_manager.css", array(), FWDMSP::VERSION);
    		wp_enqueue_style("fwdmsp_fwd_ui_css", esc_url_raw($this->_dir_url) . "css/fwd_ui.css", array(), '1.10.4');
			wp_enqueue_script("fwdmsp_fwdtooltip", esc_url_raw($this->_dir_url) . "js/fwdtooltip.js", array(), '1.0');
			wp_enqueue_script("jquery-ui-sortable");
			wp_enqueue_script("jquery-ui-accordion");
			wp_enqueue_script("jquery-ui-dialog");
			wp_enqueue_media();
	        wp_enqueue_script("fwdmsp_playlist_manager_script", esc_url_raw($this->_dir_url) . "js/playlist_manager.js", array(), FWDMSP::VERSION, true);

	    // General settings.
    	}else if($hook == 'toplevel_page_fwdmsp-menu-general-settings'){
			wp_enqueue_style("fwdmsp_fwd_ui_css", esc_url_raw($this->_dir_url) . "css/fwd_ui.css", array(), '1.10.4');
			wp_enqueue_style("fwdmsp_general_settings", esc_url_raw($this->_dir_url) . "css/general_settings.css", array(), FWDMSP::VERSION);
			wp_enqueue_script("fwdmsp_fwdtooltip", esc_url_raw($this->_dir_url) . "js/fwdtooltip.js", array(), '1.0');
			wp_enqueue_script("jquery-ui-tabs");
	    	wp_enqueue_style("fwdmsp_spectrum_css", esc_url_raw($this->_dir_url) . "css/spectrum.css");
	    	wp_enqueue_script("fwdmsp_spectrum_script", esc_url_raw($this->_dir_url) . "js/spectrum.js");
			wp_enqueue_media();
	        wp_enqueue_script("fwdmsp_general_settings_script", esc_url_raw($this->_dir_url) . "js/general_settings.js", array(), FWDMSP::VERSION, true);
	     
	    // CSS editor.
    	}else if($hook == 'mp3-sticky-player_page_fwdmsp-menu-CSS-Editor'){
    		wp_enqueue_style("fwdmsp_fwd_ui_css", esc_url_raw($this->_dir_url) . "css/fwd_ui.css", array(), '1.10.4');
    		wp_enqueue_style("fwdmsp_css_editor", esc_url_raw($this->_dir_url) . "css/css_editor.css", array(), FWDMSP::VERSION);
			wp_enqueue_script("fwdmsp_css_editor", $this->_dir_url . "js/css_editor.js", array(), FWDMSP::VERSION);
    	
		// Shortcode.
    	}else if($hook == 'post.php' || $hook == 'post-new.php'){
    		wp_enqueue_style("fwdmsp_schortcode_css", esc_url_raw($this->_dir_url) . "css/shortcode.css", array(), FWDMSP::VERSION);
    		wp_enqueue_style("fwdmsp_fwd_ui_css", esc_url_raw($this->_dir_url) . "css/fwd_ui.css", array(), '1.10.4');
			wp_enqueue_script("fwduvp_fwdtooltip", esc_url_raw($this->_dir_url) . "js/fwdtooltip.js", array(), '1.0');
			wp_enqueue_script("fwdmsp_shortcode_script", esc_url_raw($this->_dir_url) . "js/shortcode.js", array(), FWDMSP::VERSION, true);
    	}
	}

	public function fwdmsp_add_scripts_and_styles($posts){
		global $post, $wpdb;
    	if(empty($post)) return;
		
		$shortcode_found = false;
       	if(has_shortcode($post->post_content, 'fwdmsp')){
          	$shortcode_found = true;
       	}else if(isset($post->ID)){ 
          	$result = $wpdb->get_var($wpdb->prepare(
            "SELECT count(*) FROM $wpdb->postmeta " .
            "WHERE post_id = %d and meta_value LIKE '%%fwdmsp%%'", $post->ID));
          	$shortcode_found = !empty($result);
       	}
       	
       	// Uncomment this to add the front requires js/css files only if the shortcode is found in the page/post/custom post.
		//if(!empty($shortcode_found)){
			wp_enqueue_style("fwdmsp_msp_css", esc_url_raw($this->_dir_url) . "css/fwdmsp.css", array(), FWDMSP::VERSION);
			wp_register_script('fwdmsp', esc_url_raw($this->_dir_url) . "js/FWDMSP.js", array(), FWDMSP::VERSION, true);
			wp_enqueue_script("fwdmsp");
		//}		

		return $posts;
	}
    

    // Check WP version.
	private function fwdmsp_check_wp_ver(){
	    global $wp_version;
	    
		$exit_msg = "The MP3 Sticky Player plugin requires WordPress " . FWDMSP::MIN_WP_VER . " or newer. <a href='http://codex.wordpress.org/Updating_WordPress'>Please update!</a>";
		
		if (version_compare($wp_version, FWDMSP::MIN_WP_VER) <= 0){
			echo $exit_msg;
			return false;
		}
		return true;
	}
	

	// Check if user is logged in.
	public function fwdmsp_is_user_logged_in() {
		$user = wp_get_current_user();
	 
		return $user->exists();
	}
	

	// Set general settings.
    public function fwdmsp_set_general_settings(){
    	if (!$this->fwdmsp_check_wp_ver()){
    		return;
    	}
    	
    	$tootlTipImgSrc = esc_url_raw($this->_dir_url) . "content/icons/help-icon.png"; 
		$fwdmspIconsPath = esc_url_raw($this->_dir_url) . "content/icons/";
		
		// Update data.
    	$set_id = 0;
		$set_order_id = 0;
		$tab_init_id = 0;
		$msg = '';

	    if (!empty($_POST) && check_admin_referer("fwdmsp_general_settings_update", "fwdmsp_general_settings_nonce")){
			$data_obj = json_decode(str_replace("\\", "", $_POST["settings_data"]), true);
			
			$action = $data_obj["action"];
			$fwdmspSettingsAr = $data_obj["settings_ar"];

			// Validate input.
			foreach($fwdmspSettingsAr as $key => $value) {	
				if(!empty($fwdmspSettingsAr[$key]["googleAnalyticsTrackingCode"])){
					$fwdmspSettingsAr[$key]["googleAnalyticsTrackingCode"] = sanitize_text_field($fwdmspSettingsAr[$key]["googleAnalyticsTrackingCode"]);
				}

				if(!empty($fwdmspSettingsAr[$key]["proxyCors"])){
					$fwdmspSettingsAr[$key]["proxyCors"] = sanitize_text_field($fwdmspSettingsAr[$key]["proxyCors"]);
				}
				
				if(!empty($fwdmspSettingsAr[$key]["privatePassword"])){
					$fwdmspSettingsAr[$key]["privatePassword"] = sanitize_text_field($fwdmspSettingsAr[$key]["privatePassword"]);
				}

				if(!empty($fwdmspSettingsAr[$key]["loggedInMessage"])){
					$fwdmspSettingsAr[$key]["loggedInMessage"] = esc_html($fwdmspSettingsAr[$key]["loggedInMessage"]);
				}

				if(!empty($fwdmspSettingsAr[$key]["ytbAPiKey"])){
					$fwdmspSettingsAr[$key]["ytbAPiKey"] = sanitize_text_field($fwdmspSettingsAr[$key]["ytbAPiKey"]);
				}

				if(!empty($fwdmspSettingsAr[$key]["soundCloudAPIKey"])){
					$fwdmspSettingsAr[$key]["soundCloudAPIKey"] = sanitize_text_field($fwdmspSettingsAr[$key]["soundCloudAPIKey"]);
				}		
			}

			switch ($action){
			    case "add":
			        $msg = esc_html__("Your new preset has been added!", 'fwdmsp');
			        $set_id = $data_obj["set_id"];
					$set_order_id = $data_obj["set_order_id"];
					$tab_init_id = $data_obj["tab_init_id"];
			        break;
			    case "save":
			      	$msg = esc_html__("Your preset settings have been updated!", 'fwdmsp');
			        $set_id = $data_obj["set_id"];
					$set_order_id = $data_obj["set_order_id"];
					$tab_init_id = $data_obj["tab_init_id"];
			        break;
			    case "del":
			        $msg = esc_html__("Your preset has been deleted!", 'fwdmsp');
			        break;
			}
			
			$this->_data->settings_ar = $fwdmspSettingsAr;
			$this->_data->set_data();
		}
	
        // Add and escape required js vars.
        $vars = 'var fwdmspSettingsAr = ' . '"' . esc_html(htmlspecialchars(json_encode($this->_data->settings_ar))) . '";';
        $vars .= 'var fwdmspSpacesUrl = ' . '"' . esc_url_raw($this->_dir_url) . "content/spaces/" . '";';
        $vars .= 'var fwdmspSetId = ' .  esc_html($set_id) .';';
    	$vars .= 'var fwdmspCurOrderId = ' .  esc_html($set_order_id) .';';
    	$vars .= 'var fwdmspTabInitId = ' . esc_html($tab_init_id) .';';
        wp_add_inline_script('fwdmsp_general_settings_script', $vars);

    	include_once "general_settings.php";
    }
    

    // Set plylists.
 	public function fwdmsp_set_playlists_manager(){
 
    	if (!$this->fwdmsp_check_wp_ver()){
    		return;
    	}
    	
    	// Update data.
        $msg = '';
        $tootlTipImgSrc = esc_url_raw($this->_dir_url) . "content/icons/help-icon.png"; 
    	$fwdmspIconsPath = esc_url_raw($this->_dir_url) . "content/icons/";

		if (!empty($_POST) && check_admin_referer("fwdmsp_playlist_manager_update", "fwdmsp_playlist_manager_nonce")){
			$fwdMainPlaylistsAr = json_decode(str_replace("\\", "", $_POST["playlist_data"]), true);

			foreach($fwdMainPlaylistsAr as &$mainPlaylist){

				if(!empty($mainPlaylist['name'])){
					$mainPlaylist['name'] = sanitize_text_field($this->fwdmsp_clean_name($mainPlaylist['name']));

					foreach($mainPlaylist['playlists'] as &$pl){
						if(!empty($pl['source'])){
							if($pl['type'] == 'folder'){
								$pl['source'] = sanitize_text_field($this->fwdmsp_clean_folder_name($pl['source']));
							}else{
								$pl['source'] = esc_url_raw($pl['source']);
							}
						}

						if(!empty($pl['name'])){
							$pl['name'] = sanitize_text_field($this->fwdmsp_clean_name($pl['name']));
						}

						if(!empty($pl['thumb'])){
							$pl['thumb'] = esc_url_raw($pl['thumb']);
						}

						if(!empty($pl['text'])){
							$pl['text'] = wp_kses_post($pl['text']);
						}

						foreach($pl['tracks'] as &$trk){
							if(!empty($trk['name'])){
								$trk['name'] = sanitize_text_field($this->fwdmsp_clean_name($trk['name']));
							}

							if(!empty($trk['password'])){
								$trk['password'] = sanitize_text_field($trk['password']);
							}

							if(!empty($trk['audio'])){
								$trk['audio'] = esc_url_raw($trk['audio']);
							}
							
							if(!empty($trk['thumb'])){
								$trk['thumb'] = esc_url_raw($trk['thumb']);
							}

							if(!empty($trk['buy'])){
								$trk['buy'] = sanitize_text_field($trk['buy']);
							}

							if(!empty($trk['title'])){
								$trk['title'] = wp_kses_post($trk['title']);
							}
						}
					}
				}
			}

			unset($mainPlaylist);
			unset($pl);
			unset($trk);

			$this->_data->main_playlists_ar = $fwdMainPlaylistsAr;
			$this->_data->set_data();
			
			$msg = esc_html__("Your playlists have been updated!", 'fwdmsp');
		}

        // Add and escape required js vars.
        $vars = 'var fwdMainPlaylistsAr = ' . '"' . esc_html(htmlspecialchars(json_encode($this->_data->main_playlists_ar)), ENT_QUOTES) . '";';
        $vars .= 'var fwdmspIconsPath = ' . '"' . esc_url_raw($this->_dir_url) . "content/icons/" . '";';
        $vars .= 'var fwdmspDelete = ' . '"' . esc_html__('Delete', 'fwdmsp') . '";';
        $vars .= 'var fwdmspEdit__ = ' . '"' . esc_html__('Edit', 'fwdmsp') . '";';
        $vars .= 'var fwdmspAddNewPlaylist__ = ' . '"' . esc_html__('Add new playlist', 'fwdmsp') . '";';
        $vars .= 'var fwdmspAddNewTrack__ = ' . '"' . esc_html__('Add new track', 'fwdmsp') . '";';
        $vars .= 'var fwdmspAdd__ = ' . '"' . esc_html__('Add', 'fwdmsp') . '";';
        $vars .= 'var fwdmspUpdate__ = ' . '"' . esc_html__('Update', 'fwdmsp') . '";';
        $vars .= 'var fwdmspCancel__ = ' . '"' . esc_html__('Cancel', 'fwdmsp') . '";';
     	$vars .= 'var fwdmspYes__ = ' . '"' . esc_html__('Yes', 'fwdmsp') . '";';
     	$vars .= 'var fwdmspNo__ = ' . '"' . esc_html__('No', 'fwdmsp') . '";';
     	$vars .= 'var fwdmspPlaylistTip__ = ' . '"' . esc_html__('The playlist name and thumbnail path fields are required (and also the playlist source if the type is not normal).', 'fwdmsp') . '";';
     	$vars .= 'var fwdmspPodcastPl__ = ' . '"' . esc_html__('The source represents the path of a Podcast URL.', 'fwdmsp') . '";';
     	$vars .= 'var fwdmspSoundcloudPl__ = ' . '"' . esc_html__('The source represents the URL of a Soundcloud playlist.', 'fwdmsp') . '";';
     	$vars .= 'var fwdmspFolderPl__ = ' . '"' . esc_html__('The source represents the relative path to a folder containing only MP3 files that must be a subfolder of the content folder contained in the plugin directory wp-content/plugins/fwdmsp.', 'fwdmsp') . '";';
     	$vars .= 'var fwdmspYoutubePl__ = ' . '"' . esc_html__('The source represents the URL of a Youtube playlist.', 'fwdmsp') . '";';
     	$vars .= 'var fwdmspXMLPl__ = ' . '"' . esc_html__('The source represents the absolute path to a XML file that is sepcially formated to create a playlist for MSP. You can see an example at http://webdesign-flash.ro/w/msp/content/playlist1.xml or in the download files by oppening playlist1.xml file.', 'fwdmsp') . '";';
     	$vars .= 'var fwdmspPlsPl__ = ' . '"' . esc_html__('The source represents the relative or absolute path to a PLS file(Audio Playlist).', 'fwdmsp') . '";';
        wp_add_inline_script('fwdmsp_playlist_manager_script', $vars);
      
    	include_once "playlist_manager.php";
    }
    

    // Set CSS editor.
    public function fwdmsp_set_css_editor(){
    	if (!$this->fwdmsp_check_wp_ver()){
    		return;
    	}
    	
    	$msg = "";
    	$scroll_pos = 0;
    	
    	$css_file = plugin_dir_path(dirname(__FILE__)) . "css/fwdmsp.css";
    	
	    if (!empty($_POST) && check_admin_referer("fwdmsp_css_editor_update", "fwdmsp_css_editor_nonce")){
			$handle = fopen($css_file, "w") or die("Cannot open file: " . $css_file);
			
			$data = str_replace("\\", "", $_POST["css_data"]);
			$data = str_replace("'e", "'\\e", $data);
			
			fwrite($handle, $data);
			
			$msg = __("The CSS file has been updated!", 'fwdmsp');
		}
	  			
		$handle = fopen($css_file, "r") or die("Cannot open file: " . $css_file);
    	include_once "css_editor.php";
    	fclose($handle);
    }

    // Set custom shortcode metabox.
	public function fwdmsp_set_custom_meta_box($post){
		
		// Add and escape required js vars.
		$tootlTipImgSrc = esc_url($this->_dir_url) . "content/icons/help-icon.png"; 
		$playlists_ar = $this->_data->main_playlists_ar;

		// Presets.
		$presetsNames = array();
		foreach ($this->_data->settings_ar as $setting){
    		$el = array(
				"id" => $setting["name"],
				"name" => $setting["name"]
		   	);
    		array_push($presetsNames, $el);
    	}
    	
    	// Playlists.
		$mainPlaylistsNames = array();
		if (isset($this->_data->main_playlists_ar)){
			foreach ($this->_data->main_playlists_ar as $main_playlist){
	    		$el = array(
					"id" => $main_playlist["name"],
					"name" => $main_playlist["name"]
			   	);
	    				   
	    		array_push($mainPlaylistsNames, $el);
	    	}
		}

		$vars = 'var fwdmspPresetsObj = ' . '"' . esc_html(htmlspecialchars(json_encode($presetsNames))) . '";';
		$vars .= 'var fwdmspMainPlaylistsObj = ' . '"' . esc_html(htmlspecialchars(json_encode($mainPlaylistsNames))) . '";';
		$vars .= 'var fwdmspPlaylists_ar = ' . '"' . esc_html(htmlspecialchars(json_encode($playlists_ar))) . '";';
		wp_add_inline_script('fwdmsp_shortcode_script', $vars);

    	include_once "meta_box.php";
	}
    

    // Set actions links.
	public static function fwdmsp_set_action_links($links){
		$settings_link = "<a href='" . get_admin_url(null, "admin.php?page=fwdmsp-menu-general-settings") . "'>Settings</a>";
   		array_unshift($links, $settings_link);
   		
   		return $links;
	}
    

    // Get contructor.
    public function fwdmsp_get_constructor($preset, $main_playlist, $pid, $start_playlist_id, $start_track_id){

    	$startAtPlaylist = $preset['start_at_playlist'];
    	$startAtTrack = $preset['start_at_track'];
    
    	if($start_track_id){
    		$reg_exp = "/^\d+$/";
    		if(preg_match($reg_exp, $start_track_id, $matches)){
				$startAtTrack = $start_track_id;
			}
    	}
    
    	foreach($main_playlist["playlists"] as $plId=>$playlist){
    		if($playlist['name'] === $start_playlist_id){
    			$startAtPlaylist = $plId;
    		}

    		foreach($playlist["tracks"] as $trkId=>$trk){
    			if($trk['name'] === $start_track_id){
	    			$startAtTrack = $trkId;
	    		}
    		}
    	}
	
		$isLoggedIn = $this->fwdmsp_is_user_logged_in();
		if($preset['playIfLoggedIn'] == "yes" && $isLoggedIn) $preset['playIfLoggedIn'] = 'no';


		/**
    	  *  Minified constructor to optimize page loading and also make sure it works
    	  *  in all themes, even those with wired plugins/code that tries to modify scripts
    	  *  and other unexpected bad code...
    	  */
    	$output = "document.addEventListener('DOMContentLoaded', function(event) {FWDMSPUtils.checkIfHasTransofrms();new FWDMSP({" . "instanceName:'fwdmspPlayer" . esc_html(FWDMSP::$_msp_id) . "',playlistsId:\"fwdmspMainPlaylist" . html_entity_decode(esc_html($pid), ENT_QUOTES) . "\",mainFolderPath:'" . esc_url_raw($this->_dir_url) . "content'," . "skinPath:'" . esc_html($preset['skin_path']) . "',showMainScrubberAndVolumeScrubberToolTipLabel:'" . esc_html($preset['showMainScrubberAndVolumeScrubberToolTipLabel']) . "',scrubbersToolTipLabelBackgroundColor:'" . esc_html($preset['scrubbersToolTipLabelBackgroundColor']) . "',scrubbersToolTipLabelFontColor:'" . esc_html($preset['scrubbersToolTipLabelFontColor']) . "',atbTimeTextColorNormal:'" . esc_html($preset['atbTimeTextColorNormal']) . "',atbTimeTextColorSelected:'" . esc_html($preset['atbTimeTextColorSelected']) . "',atbButtonTextNormalColor:'" . esc_html($preset['atbButtonTextNormalColor']) . "',atbButtonTextSelectedColor:'" . esc_html($preset['atbButtonTextSelectedColor']) . "',atbButtonBackgroundNormalColor:'" . esc_html($preset['atbButtonBackgroundNormalColor']) . "',atbButtonBackgroundSelectedColor:'" . esc_html($preset['atbButtonBackgroundSelectedColor']) . "',proxyCors:'" . esc_html($preset['proxyCors']) . "',youtubeAPIKey:'" . esc_html($preset['ytbAPiKey']) . "',showSoundCloudUserNameInTitle:'" . esc_html($preset['show_soundcloud_username_in_title']) . "',soundCloudAPIKey:'" . esc_html($preset['soundCloudAPIKey']) . "',googleAnalyticsTrackingCode:'" . esc_html($preset['googleAnalyticsTrackingCode']) . "',verticalPosition:'" . esc_html($preset['verticalPosition']) . "',horizontalPosition:'" . esc_html($preset['horizontalPosition']) . "',useYoutube:'" . esc_html($preset['use_youtube']) . "',useDeepLinking:'" . esc_html($preset['use_deeplinking']) . "',rightClickContextMenu:'" . esc_html($preset['right_click_context_menu']) . "',showButtonsToolTips:'" . esc_html($preset['show_buttons_tooltips']) . "',animate:'" . esc_html($preset['animate']) . "',autoPlay:'" . esc_html($preset['autoplay']) . "',startAtRandomTrack:'" . esc_html($preset['start_at_random_track']) . "',loop:'" . esc_html($preset['loop']) . "',shuffle:'" . esc_html($preset['shuffle']) . "',maxWidth:" . esc_html($preset['max_width']) . ",showMainBackground:'" . esc_html($preset['showMainBackground']) . "',useContinuousPlayback:'" . esc_html($preset['useContinuousPlayback']) . "',addKeyboardSupport:'" . esc_html($preset['addKeyboardSupport']) . "',playIfLoggedIn:'" .  esc_html($preset['playIfLoggedIn']) . "',playIfLoggedInMessage:\"" . html_entity_decode(esc_html($preset['loggedInMessage']), ENT_QUOTES) . "\",volume:" . esc_html($preset['volume']) . ",useVideo:'" . esc_html($preset['use_video']) . "',showPlaybackRateButton:'" . esc_html($preset['showPlaybackRateButton']) . "',openPopupOnPlay:'" . esc_html($preset['openPopupOnPlay']) . "',defaultPlaybackRate:" . esc_html($preset['defaultPlaybackRate']) . ",playlistSelectorHeight:" . esc_html($preset['playlistSelectorHeight']) . ",playbackRateWindowTextColor:'" . esc_html($preset['playbackRateWindowTextColor']) . "',playTrackAfterPlaylistLoad:'" . esc_html($preset['playTrackAfterPlaylistLoad']) . "',showFullScreenButton:'" . esc_html($preset['show_full_screen_button']) . "',useHEXColorsForSkin:'" . esc_html($preset['use_HEX_colors_for_skin']) . "',normalHEXButtonsColor:'" . esc_html($preset['normal_HEX_buttons_color']) . "',useVectorIcons:'" . esc_html($preset['useVectorIcons']) . "',toolTipsButtonsHideDelay:" . esc_html($preset['tooltips_buttons_hide_delay'])  . ",toolTipsButtonsBackgroundColor:'" . esc_html($preset['toolTipsButtonsBackgroundColor']) . "',toolTipsButtonFontColor:'" . esc_html($preset['tooltips_button_font_color']) . "'," . "showControllerByDefault:'" . esc_html($preset['show_controller_by_default']) . "',showThumbnail:'" . esc_html($preset['show_thumbnail']) . "',showNextAndPrevButtons:'" . esc_html($preset['show_next_and_prev_buttons']) . "',disableScrubber:'" . esc_html($preset['disable_scrubber']) . "',showLoopButton:'" . esc_html($preset['show_loop_button']) . "',showShuffleButton:'" . esc_html($preset['show_shuffle_button']) . "',showDownloadMp3Button:'" . esc_html($preset['show_download_mp3_button']) . "',showShareButton:'" . esc_html($preset['show_share_button']) . "',showBuyButton:'" . esc_html($preset['show_buy_button']) . "',expandBackground:'" . esc_html($preset['expand_background']) . "',titleColor:'" . esc_html($preset['title_color']) . "',timeColor:'" . esc_html($preset['time_color']) . "'," . "controllerHeight:" . esc_html($preset['controller_height']) . ",startSpaceBetweenButtons:" . esc_html($preset['start_space_between_buttons']) . ",spaceBetweenButtons:" . esc_html($preset['space_between_buttons']) . ",separatorOffsetOutSpace:" . esc_html($preset['separator_offset_out_space']) . ",separatorOffsetInSpace:" . esc_html($preset['separator_offset_in_space']) . ",lastButtonsOffsetTop:" . esc_html($preset['last_buttons_offset_top']) . ",allButtonsOffsetTopAndBottom:" . esc_html($preset['all_buttons_offset_top_and_bottom']) . ",titleBarOffsetTop:" . esc_html($preset['title_bar_offset_top']) . ",mainScrubberOffsetTop:" . esc_html($preset['main_scrubber_offset_top']) . ",spaceBetweenMainScrubberAndTime:" . esc_html($preset['space_between_main_scrubber_and_time']) . ",startTimeSpace:" . esc_html($preset['start_time_space']) . ",scrubbersOffsetWidth:" . esc_html($preset['scrubbers_offset_width']) . ",scrubbersOffestTotalWidth:" . esc_html($preset['scrubbers_offset_total_width']) . ",volumeButtonAndScrubberOffsetTop:" . esc_html($preset['volume_button_and_scrubber_offset_top']) . ",spaceBetweenVolumeButtonAndScrubber:" . esc_html($preset['space_between_volume_button_and_scrubber']) . ",volumeScrubberOffestWidth:" . esc_html($preset['volume_scrubber_offset_width']) . ",scrubberOffsetBottom:" . esc_html($preset['scrubber_offset_bottom']) . ",playbackRateButtonsMargins:" . esc_html($preset['playbackRateButtonsMargins']) . "," . "showPlaylistsButtonAndPlaylists:'" . esc_html($preset['show_playlists_button_and_playlists']) . "',showPlaylistsSearchInput:'" . esc_html($preset['showPlaylistsSearchInput']) . "',usePlaylistsSelectBox:'" . esc_html($preset['usePlaylistsSelectBox']) . "',randomizePlaylist:'" . esc_html($preset['randomizePlaylist']) . "',mainSelectorBackgroundSelectedColor:'" . esc_html($preset['mainSelectorBackgroundSelectedColor']) . "',mainSelectorTextNormalColor:'" . esc_html($preset['mainSelectorTextNormalColor']) . "',mainSelectorTextSelectedColor:'" . esc_html($preset['mainSelectorTextSelectedColor']) . "',mainButtonTextNormalColor:'" . esc_html($preset['mainButtonTextNormalColor']) . "',mainButtonTextSelectedColor:'" . esc_html($preset['mainButtonTextSelectedColor']) . "',showPlaylistsSelectBoxNumbers:'" . esc_html($preset['showPlaylistsSelectBoxNumbers']) . "',showPlaylistsByDefault:'" . esc_html($preset['show_playlists_by_default']) . "',thumbnailSelectedType:'" . esc_html($preset['thumbnail_selected_type']) . "',startAtPlaylist:" . esc_html($startAtPlaylist) . ",startAtTrack:" . esc_html($startAtTrack) . ",buttonsMargins:" . esc_html($preset['buttons_margins']) . ",thumbnailMaxWidth:" . esc_html($preset['thumbnail_max_width']) . ",thumbnailMaxHeight:" . esc_html($preset['thumbnail_max_height']) . ",horizontalSpaceBetweenThumbnails:" . esc_html($preset['horizontal_space_between_thumbnails']) . ",verticalSpaceBetweenThumbnails:" . esc_html($preset['vertical_space_between_thumbnails']) . "," . "showPlayListButtonAndPlaylist:'" . esc_html($preset['show_playlist_button_and_playlist']) . "',showPlayListOnMobile:'" . esc_html($preset['showPlayListOnMobile']) . "',showPlayListByDefault:'" . esc_html($preset['show_playlist_by_default']) . "',showPlaylistItemPlayButton:'" . esc_html($preset['show_playlist_item_play_button']) . "',showPlaylistItemDownloadButton:'" . esc_html($preset['show_playlist_item_download_button']) . "',showPlaylistItemBuyButton:'" . esc_html($preset['show_playlist_item_buy_button']) . "',forceDisableDownloadButtonForPodcast:'" . esc_html($preset['force_disable_download_button_for_podcast']) . "',forceDisableDownloadButtonForOfficialFM:'" . esc_html($preset['force_disable_download_button_for_official_fm']) . "',forceDisableDownloadButtonForFolder:'" . esc_html($preset['force_disable_download_button_for_folder']) . "',addScrollBarMouseWheelSupport:'" . esc_html($preset['add_scrollbar_mouse_wheel_support']) . "',showTracksNumbers:'" . esc_html($preset['show_tracks_numbers']) . "',playlistBackgroundColor:'" . esc_html($preset['playlist_background_color']) . "',trackTitleNormalColor:'" . esc_html($preset['track_title_normal_color']) . "',trackTitleSelectedColor:'" . esc_html($preset['track_title_selected_color']) . "',trackDurationColor:'" . esc_html($preset['track_duration_color']) . "',playlistItemHeight:" . esc_html($preset['playlistItemHeight']) . ",maxPlaylistItems:" . esc_html($preset['max_playlist_items']) . ",nrOfVisiblePlaylistItems:" . esc_html($preset['nr_of_visible_playlist_items']) . ",trackTitleOffsetLeft:" . esc_html($preset['track_title_offset_left']) . ",playPauseButtonOffsetLeftAndRight:" . esc_html($preset['play_pause_button_offset_left_and_right']) . ",durationOffsetRight:" . esc_html($preset['duration_offset_right']) . ",downloadButtonOffsetRight:" . esc_html($preset['download_button_offset_right']) . ",borderColor:'" . esc_html($preset['borderColor']) . "',secondaryLabelsColor:'" . esc_html($preset['secondaryLabelsColor']) . "',textColor:'" . esc_html($preset['textColor']) . "',inputBackgroundColor:'" . esc_html($preset['inputBackgroundColor']) . "',inputColor:'" . esc_html($preset['inputColor']) . "',privatePassword:'" .  esc_html(md5($preset['privatePassword'])) . "',scrollbarOffestWidth:" . esc_html($preset['scrollbar_offset_width']) . "," . "openerAlignment:'" . esc_html($preset['opener_alignment']) . "',showOpener:'" . esc_html($preset['show_opener']) . "',showOpenerPlayPauseButton:'" . esc_html($preset['show_opener_play_pause_button']) . "',openerEqulizerOffsetLeft:" . esc_html($preset['opener_equlizer_offset_left']) . ",openerEqulizerOffsetTop:" . esc_html($preset['opener_equlizer_offset_top']) . "," ."showPopupButton:'" . esc_html($preset['show_popup_button']) . "',popupWindowBackgroundColor:'" . esc_html($preset['popup_window_background_color']) . "',popupWindowWidth:" . esc_html($preset['popup_window_width']) . ",popupWindowHeight:" . esc_html($preset['popup_window_height']) . "," . "showSearchBar:'" . esc_html($preset['show_search_bar']) . "',showSortButtons:'" . esc_html($preset['show_sort_buttons']) . "',searchInputColor:'" . esc_html($preset['search_input_color']) . "',searchBarHeight:" . esc_html($preset['search_bar_height']) . ",inputSearchTextOffsetTop:" . esc_html($preset['input_search_text_offset_top']) . ",inputSearchOffsetLeft:" . esc_html($preset['input_search_offset_left']) . ",useVisualizer:'" . esc_html($preset['useVisualizer']) . "',useDumyVisualizeOnIOS:'" . esc_html($preset['useDumyVisualizeOnIOS']) . "',visualizerRandomPreset:'" . esc_html($preset['visualizerRandomPreset'])  . "',visualizerPreset:'"  . esc_html($preset['visualizerPreset']) .  "',visualizerColor:[" .  "'" . html_entity_decode(esc_html(implode("','",array_reverse($preset['visualizerColor']))), ENT_QUOTES) . "'" . "],visualizerCapColor:'" . esc_html($preset['visualizerCapColor']) . "'})});";// All dynamic content was escaped!

    		return $output;
    }
    

    // Get main playlist.
    public function fwdmsp_get_main_playlist($pid){
    	$main_playlist = NULL;
    	
    	foreach ($this->_data->main_playlists_ar as $pl){
    		if ($pl["name"] == $pid){
    			$main_playlist = $pl;
    		}
    	}
    	
    	if (is_null($main_playlist)){
    		return;
    	}
    	
    	// To be safe force display none, this must be hidden!
    	$main_playlist_str = '<ul id="fwdmspMainPlaylist' . html_entity_decode(esc_html($pid), ENT_QUOTES) . '" class="fwdmsp-playlist">';
		$normal_playlist_str = "";
    	
    	foreach ($main_playlist["playlists"] as $playlist){
			if ($playlist["type"] == "normal"){
				$main_playlist_str .= '<li data-source="fwdmspPlaylist' . esc_html(FWDMSP::$_pl_id) . '" data-playlist-name="' . html_entity_decode(esc_html($playlist['name']), ENT_QUOTES) . '"';
				
				// To be safe force display none, this must be hidden!
				$normal_playlist_str .= '<ul id="fwdmspPlaylist' . esc_html(FWDMSP::$_pl_id) . '" class="fwdmsp-playlist">';
				
				foreach ($playlist["tracks"] as $track){
					if($track['encrypt'] == "yes"){
						$normal_playlist_str .= '<li data-path="encrypt:' . base64_encode(esc_url_raw($track["audio"])) . '"';
					}else{
						$normal_playlist_str .= '<li data-path="' . esc_url_raw($track["audio"]) . '"';
					}
					
					$trackType = NULL;
					if($track['type'] == "shoutcast"){
						$trackType = "shoutcast";
					}else if($track['type'] == "icecast"){
						$trackType = "icecast";
					}
					
					if (strlen($track["thumb"]) >= 1){
						$normal_playlist_str .= ' data-thumbpath="' . esc_url_raw($track["thumb"]) . '"';
					}
					
					if(!is_null($trackType)){
						$normal_playlist_str .= ' data-type="' . esc_html($trackType) . '"';
					}
					
					if (strlen($track["duration"]) >= 1){
						$normal_playlist_str .= ' data-duration="' . esc_html($track["duration"]) . '"';
					}
					
					$normal_playlist_str .= ' data-is-private="' . esc_html($track["isPrivate"]) . '"';
					
					if($track["password"]){
						$normal_playlist_str .= ' data-private-video-password="' . esc_html(md5($track["password"])) . '"';
					}
					
					if (strlen($track["startAtTime"]) >= 1){
						$normal_playlist_str .= ' data-start-at-time="' . esc_html($track["startAtTime"]) . '"';
					}
					
					if (strlen($track["stopAtTime"]) >= 1){
						$normal_playlist_str .= ' data-stop-at-time="' . esc_html($track["stopAtTime"]) . '"';
					}
					
					if (isset($track["buy"]) && strlen($track["buy"]) >= 1){
						$normal_playlist_str .= ' data-buy-url="' . esc_html($track["buy"]) . '"';
					}

					if (isset($track["useATB"]) && $track["useATB"] == 'yes'){
						$normal_playlist_str .= ' data-use-a-to-b="' . esc_html($track["useATB"]) . '"';
					}

					if(isset($track["playOnlyIfLoggedIn"])){
						$isLoggedIn = $this->fwdmsp_is_user_logged_in();
						if($track["playOnlyIfLoggedIn"] == 'yes' && !$isLoggedIn){
							 $normal_playlist_str .= ' data-play-if-logged-in="yes"';
						}
					}
					
					$normal_playlist_str .= ' data-downloadable="' . esc_html($track["dl"]) . '">';
					$normal_playlist_str .= wp_kses($track["title"], wp_kses_allowed_html('post'));
					
					$normal_playlist_str .= "</li>";
				}
				
				$normal_playlist_str .= "</ul>";
				
				FWDMSP::$_pl_id++;
			}else if ($playlist["type"] == "folder"){
					$main_playlist_str .= '<li data-source="folder:' . html_entity_decode(esc_html($playlist['source']), ENT_QUOTES) . '" data-playlist-name="' . html_entity_decode(esc_html($playlist['name']), ENT_QUOTES) . '"';
			}else if ($playlist["type"] == "youtube"){

				$youtube_playlist_source = "list=";

				$reg_exp = "/[\?\&]list\=.+/";

				if (preg_match($reg_exp, $playlist["source"], $matches)){
					$youtube_playlist_source .= substr($matches[0], 6);
				}

				$main_playlist_str .= '<li data-source="' . esc_html($youtube_playlist_source)  . '" data-playlist-name="' . html_entity_decode(esc_html($playlist['name']), ENT_QUOTES) . '"';
			}else if ($playlist["type"] == "xml"){
				$main_playlist_str .= '<li data-source="' . esc_url_raw($playlist["source"])  . '" data-playlist-name="' . html_entity_decode(esc_html($playlist['name']), ENT_QUOTES) . '"';
			}else{
				$main_playlist_str .= '<li data-source="' . esc_url_raw($playlist["source"])  .'" data-playlist-name="' . html_entity_decode(esc_html($playlist['name']), ENT_QUOTES) . '"';
			}
			
			
			if(strlen($playlist["thumb"]) >= 1){
				$main_playlist_str .= ' data-thumbnail-path="' . esc_url_raw($playlist["thumb"]) . '">';
			}else{
				$main_playlist_str .= '">';
			}
			
			$main_playlist_str .= wp_kses($playlist["text"], wp_kses_allowed_html('post'));
    		
    		$main_playlist_str .= '</li>';
    	}
    	
    	$main_playlist_str .= '</ul>';
		$main_playlist_str .= $normal_playlist_str;
    	return $main_playlist_str; // All dynamic content was escaped.
    }
    

    // Set player.
 	public function fwdmsp_fwdmsp_set_player($atts){
		extract(shortcode_atts(array("preset_id" => 0, "playlist_id" => 0, "start_playlist_id" => '', "start_track_id" => 0), $atts, "fwdmsp"));

		// Check presets.
		$preset = NULL;
		foreach ($this->_data->settings_ar as $set){
    		if ($set["name"] == $preset_id){
    			$preset = $set;
    		}
    	}
    	
    	if (is_null($preset)){
    		return "Preset with id <strong>". esc_html($preset_id) . "</strong> does not exist!";
    	}
    	
    	// Check playlist.
    	$main_playlist = NULL;
    	foreach ($this->_data->main_playlists_ar as $pl){
    		if ($pl["name"] == $playlist_id){
    			$main_playlist = $pl;
    		}
    	}
    	 	
    	if (is_null($main_playlist)){
    		return "Main playlist with id <strong>". esc_html($playlist_id) . "</strong> does not exist!";
    	}
		
		// Get data for output.
		$msp_constructor = $this->fwdmsp_get_constructor($preset, $main_playlist, $playlist_id, $start_playlist_id, $start_track_id);
		$msp_div = '<div id="fwdmspDiv' . esc_html(FWDMSP::$_msp_id) . '"></div>';
		$msp_main_playlist = $this->fwdmsp_get_main_playlist($playlist_id);
		FWDMSP::$_msp_id++;

		$msp_output =  $msp_div . $msp_main_playlist;

		// Register JS.
		wp_register_script( 'fwdmsp-dummy-handle-footer', '', [], '', true );
   		wp_enqueue_script( 'fwdmsp-dummy-handle-footer'  );
    	wp_add_inline_script( 'fwdmsp-dummy-handle-footer', $msp_constructor );

		return $msp_output; // All dynamic content was escaped.
	}
	

	// Clean function for names/labels.
	private function fwdmsp_clean_name($string) {
		$string = preg_replace('/"/', '\'', $string);
	   	return preg_replace('/[\[\]\&\/<>|\\\\]/', '', $string);
	}

	private function fwdmsp_clean_folder_name($string) {
		$string = preg_replace('/"/', '\'', $string);
	   	return preg_replace('/[\/<>|\\\\]/', '', $string);
	}
}
?>