<?php
/**
 * Plugin data.
 *
 * @package fwdmsp
 * @since fwdmsp 1.0
 */

class FWDMSPData{

	const DEFAULT_SKINS_NR = 8;
	public $settings_ar;
    public $main_playlists_ar;
	

    // Initialize.
    public function init(){
		$cur_data = get_option("fwdmsp_data");

		// Uncomment this to reset presets!
		//$this->reset_presets();
	      
	    if (!$cur_data){
	    	$this->init_settings();
	    	$this->init_playlist();
	    	$this->set_data();
	    }
		
		$this->set_updates();
    	$this->get_data();
    }
	

	// Reset presets.
	private function reset_presets(){
		$this->get_data();
		$this->init_settings();
	    $this->set_data();
	}


	// Set updates.
	private function set_updates(){
		$this->get_data();
		
   		foreach ($this->settings_ar as &$preset){
			// update new or existing fields

			if(!array_key_exists("useDumyVisualizeOnIOS", $preset)){
				$preset["useDumyVisualizeOnIOS"] = 'yes';
			}

   			if(!array_key_exists("playbackRateButtonsMargins", $preset)){
				$preset["playbackRateButtonsMargins"] = 0;
			}
   			
   			if(!array_key_exists("showPlayListOnMobile", $preset)){
				$preset["showPlayListOnMobile"] = 'yes';
			}

			if(!array_key_exists("playIfLoggedIn", $preset)){
				$preset["playIfLoggedIn"] = 'no';
			}
   			
   			if(!array_key_exists("openPopupOnPlay", $preset)){
				$preset["openPopupOnPlay"] = "no";
			}

   			if(!array_key_exists("proxyCors", $preset)){
				$preset["proxyCors"] = "";
			}

    		if(!array_key_exists("ytbAPiKey", $preset)){
				$preset["ytbAPiKey"] = "";
			}

			if(!array_key_exists("playlistItemHeight", $preset)){
				$preset["playlistItemHeight"] = 33;
			}

			if(!array_key_exists("playlistSelectorHeight", $preset)){
				$preset["playlistSelectorHeight"] = 37;
			}

			if(!array_key_exists("useVisualizer", $preset)){
				$preset["useVisualizer"] = "yes";
			}

			if(!array_key_exists("visualizerRandomPreset", $preset)){
				$preset["visualizerRandomPreset"] = "no";
			}

			if(!array_key_exists("visualizerPreset", $preset)){
				$preset["visualizerPreset"] = "bars1";
			}

			if(!array_key_exists("visualizerColor", $preset)){
				$preset["visualizerColor"] = array("#AAAAAA", "#999999", "#888888", "#777777", "#666666");
			}

			if(!array_key_exists("visualizerCapColor", $preset)){
				$preset["visualizerCapColor"] = "#FFFFFF"; 
			}
			
			if (!array_key_exists("showMainScrubberAndVolumeScrubberToolTipLabel", $preset)){
				$preset["showMainScrubberAndVolumeScrubberToolTipLabel"] = "yes";
			}
			
			if (!array_key_exists("useContinuousPlayback", $preset)){

				$preset["useContinuousPlayback"] = "no";
			}
			if (!array_key_exists("googleAnalyticsTrackingCode", $preset)){
				$preset["googleAnalyticsTrackingCode"] = "";
			}
			if (!array_key_exists("playTrackOnlyWhenLoggedIn", $preset)){

				$preset["playTrackOnlyWhenLoggedIn"] = "no";
			}
			
			if (!array_key_exists("loggedInMessage", $preset)){

				$preset["loggedInMessage"] = "Please login to play the track.";
			}	
			
			if (!array_key_exists("show_share_button", $preset)){
	    		$preset["show_share_button"] = "yes";
			}
			
			if (!array_key_exists("showPlaybackRateButton", $preset)){
	    		$preset["showPlaybackRateButton"] = "yes";
			}
			
			if (!array_key_exists("privatePassword", $preset)){
	    		$preset["privatePassword"] = "Melinda";
			}
			
			if (!array_key_exists("showPlaylistsSearchInput", $preset)){
	    		$preset["showPlaylistsSearchInput"] = "yes";
			}
			
			if (!array_key_exists("addKeyboardSupport", $preset)){
	    		$preset["addKeyboardSupport"] = "yes";
			}
			
			if (!array_key_exists("showMainBackground", $preset)){
	    		$preset["showMainBackground"] = "yes";
			}
			
			
			if (!array_key_exists("randomizePlaylist", $preset)){
	    		$preset["randomizePlaylist"] = "no";
			}
			
			if (!array_key_exists("defaultPlaybackRate", $preset)){
	    		$preset["defaultPlaybackRate"] = 1;
			}
			if (!array_key_exists("playTrackAfterPlaylistLoad", $preset)){
	    		$preset["playTrackAfterPlaylistLoad"] = "no";
			}
			
			
			if (!array_key_exists("soundCloudAPIKey", $preset)){
	    		$preset["soundCloudAPIKey"] = "";
			}
			if (!array_key_exists("start_at_random_track", $preset)){
	    		$preset["start_at_random_track"] = "no";
			}
			
			if (!array_key_exists("usePlaylistsSelectBox", $preset)){
	    		$preset["usePlaylistsSelectBox"] = "yes";
			}
			
			if (!array_key_exists("showPlaylistsSelectBoxNumbers", $preset)){
	    		$preset["showPlaylistsSelectBoxNumbers"] = "yes";
			}
			
			if (!array_key_exists("verticalPosition", $preset)){
	    		$preset["verticalPosition"] = "bottom";
			}
			
			if (!array_key_exists("horizontalPosition", $preset)){
	    		$preset["horizontalPosition"] = "center";
			}
			
			if (!array_key_exists("use_youtube", $preset))

	    	{

	    		$preset["use_youtube"] = "yes";

			}
			
			if (!array_key_exists("use_HEX_colors_for_skin", $preset)){

	    		$preset["use_HEX_colors_for_skin"] =  "no";

			}
			
			if (!array_key_exists("normal_HEX_buttons_color", $preset)){
	    		$preset["normal_HEX_buttons_color"] =  "#FF0000";
			}
			
			if (!array_key_exists("useVectorIcons", $preset)){
	    		$preset["useVectorIcons"] =  "no";
			}
			
			if(!array_key_exists("use_video", $preset)){

	    		$preset["use_video"] =  "yes";

			}
			
			if(!array_key_exists("show_full_screen_button", $preset)){

	    		$preset["show_full_screen_button"] =  "yes";

			}
			
			if (!array_key_exists("show_next_and_prev_buttons", $preset))
	    	{
	    		$preset["show_next_and_prev_buttons"] = "yes";
			}
			
			if (!array_key_exists("disable_scrubber", $preset))
	    	{
	    		$preset["disable_scrubber"] = "no";
			}
		
			if (!array_key_exists("show_buy_button", $preset))
	    	{
	    		$preset["show_buy_button"] = "yes";
			}
			
			if (!array_key_exists("show_playlist_item_buy_button", $preset))
	    	{
	    		$preset["show_playlist_item_buy_button"] = "yes";
			}
			
			if (!array_key_exists("show_tracks_numbers", $preset))
	    	{
	    		$preset["show_tracks_numbers"] = "yes";
			}
			
			if (!array_key_exists("show_opener", $preset))
	    	{
	    		$preset["show_opener"] = "yes";
			}
			
			if (!array_key_exists("show_opener_play_pause_button", $preset))
	    	{
	    		$preset["show_opener_play_pause_button"] = "yes";
			}
			
			
			if (!array_key_exists("show_search_bar", $preset))
	    	{
	    		$preset["show_search_bar"] = "yes";
			}
			
			if (!array_key_exists("show_sort_buttons", $preset))
	    	{
	    		$preset["show_sort_buttons"] = "yes";
			}
			
			switch ($preset["skin_path"]){
				case "minimal_skin_dark":

					if (!array_key_exists("toolTipsButtonsBackgroundColor", $preset)){
			    		$preset["toolTipsButtonsBackgroundColor"] = "#FFFFFF";
					}

					if (!array_key_exists("atbTimeBackgroundColor", $preset)){
						$preset["atbTimeBackgroundColor"] = "#transparent";
					}
					if (!array_key_exists("atbTimeTextColorNormal", $preset)){
						$preset["atbTimeTextColorNormal"] = "#888888";
					}
					if (!array_key_exists("atbTimeTextColorSelected", $preset)){
						$preset["atbTimeTextColorSelected"] = "#FFFFFF";
					}
					if (!array_key_exists("atbButtonTextNormalColor", $preset)){
						$preset["atbButtonTextNormalColor"] = "#888888";
					}
					if (!array_key_exists("atbButtonTextSelectedColor", $preset)){
						$preset["atbButtonTextSelectedColor"] = "#FFFFFF";
					}
					if (!array_key_exists("atbButtonBackgroundNormalColor", $preset)){
						$preset["atbButtonBackgroundNormalColor"] = "#FFFFFF";
					}
					if (!array_key_exists("atbButtonBackgroundSelectedColor", $preset)){
						$preset["atbButtonBackgroundSelectedColor"] = "#000000";
					}
					
					if (!array_key_exists("scrubbersToolTipLabelBackgroundColor", $preset)){
						$preset["scrubbersToolTipLabelBackgroundColor"] = "#FFFFFF";
					}
					if (!array_key_exists("scrubbersToolTipLabelFontColor", $preset)){
						$preset["scrubbersToolTipLabelFontColor"] = "#5a5a5a";
					}
					if (!array_key_exists("mainSelectorBackgroundSelectedColor", $preset)){
						$preset["mainSelectorBackgroundSelectedColor"] = "#FFFFFF";
					}
					if (!array_key_exists("mainSelectorTextNormalColor", $preset)){
						$preset["mainSelectorTextNormalColor"] = "#FFFFFF";
					}
					if (!array_key_exists("mainSelectorTextSelectedColor", $preset)){
						$preset["mainSelectorTextSelectedColor"] = "#000000";
					}
					if (!array_key_exists("mainButtonTextNormalColor", $preset)){
						$preset["mainButtonTextNormalColor"] = "#888888";
					}
					if (!array_key_exists("mainButtonTextSelectedColor", $preset)){
						$preset["mainButtonTextSelectedColor"] = "#FFFFFF";
					}
					if (!array_key_exists("playbackRateWindowTextColor", $preset)){
						$preset["playbackRateWindowTextColor"] = "#000000";
					}
					
					
					if (!array_key_exists("borderColor", $preset)){
						$preset["borderColor"] = "#333333";
					}
					if (!array_key_exists("secondaryLabelsColor", $preset)){
						$preset["secondaryLabelsColor"] = "#a1a1a1";
					}
					if (!array_key_exists("textColor", $preset)){
						$preset["textColor"] = "#5a5a5a";
					}
					if (!array_key_exists("inputBackgroundColor", $preset)){
						$preset["inputBackgroundColor"] = "#000000";
					}
					if (!array_key_exists("inputColor", $preset)){
						$preset["inputColor"] = "#FFFFFF";
					}
					
					
					if (!array_key_exists("playlist_background_color", $preset)){
						$preset["playlist_background_color"] = "#000000";
					}
					
					if (!array_key_exists("search_input_color", $preset))
					{
						$preset["search_input_color"] = "#999999";
					}
					
					if (!array_key_exists("search_bar_height", $preset))
					{
						$preset["search_bar_height"] = 38;
					}
					
					if (!array_key_exists("input_search_text_offset_top", $preset))
					{
						$preset["input_search_text_offset_top"] = 1;
					}
					
					if (!array_key_exists("input_search_offset_left", $preset))
					{
						$preset["input_search_offset_left"] = 0;
					}
					break;
				case "modern_skin_dark":
					if (!array_key_exists("toolTipsButtonsBackgroundColor", $preset)){
			    		$preset["toolTipsButtonsBackgroundColor"] = "#FFFFFF";
					}

					if (!array_key_exists("atbTimeBackgroundColor", $preset)){
						$preset["atbTimeBackgroundColor"] = "#transparent";
					}
					if (!array_key_exists("atbTimeTextColorNormal", $preset)){
						$preset["atbTimeTextColorNormal"] = "#888888";
					}
					if (!array_key_exists("atbTimeTextColorSelected", $preset)){
						$preset["atbTimeTextColorSelected"] = "#FFFFFF";
					}
					if (!array_key_exists("atbButtonTextNormalColor", $preset)){
						$preset["atbButtonTextNormalColor"] = "#888888";
					}
					if (!array_key_exists("atbButtonTextSelectedColor", $preset)){
						$preset["atbButtonTextSelectedColor"] = "#FFFFFF";
					}
					if (!array_key_exists("atbButtonBackgroundNormalColor", $preset)){
						$preset["atbButtonBackgroundNormalColor"] = "#FFFFFF";
					}
					if (!array_key_exists("atbButtonBackgroundSelectedColor", $preset)){
						$preset["atbButtonBackgroundSelectedColor"] = "#000000";
					}

					if (!array_key_exists("scrubbersToolTipLabelBackgroundColor", $preset)){
						$preset["scrubbersToolTipLabelBackgroundColor"] = "#FFFFFF";
					}
					if (!array_key_exists("scrubbersToolTipLabelFontColor", $preset)){
						$preset["scrubbersToolTipLabelFontColor"] = "#5a5a5a";
					}
				
					if (!array_key_exists("mainSelectorBackgroundSelectedColor", $preset)){
						$preset["mainSelectorBackgroundSelectedColor"] = "#FFFFFF";
					}
					if (!array_key_exists("mainSelectorTextNormalColor", $preset)){
						$preset["mainSelectorTextNormalColor"] = "#FFFFFF";
					}
					if (!array_key_exists("mainSelectorTextSelectedColor", $preset)){
						$preset["mainSelectorTextSelectedColor"] = "#000000";
					}
					if (!array_key_exists("mainButtonTextNormalColor", $preset)){
						$preset["mainButtonTextNormalColor"] = "#888888";
					}
					if (!array_key_exists("mainButtonTextSelectedColor", $preset)){
						$preset["mainButtonTextSelectedColor"] = "#FFFFFF";
					}
					
					if (!array_key_exists("playbackRateWindowTextColor", $preset)){
						$preset["playbackRateWindowTextColor"] = "#000000";
					}

					if (!array_key_exists("borderColor", $preset)){
						$preset["borderColor"] = "#333333";
					}
					if (!array_key_exists("secondaryLabelsColor", $preset)){
						$preset["secondaryLabelsColor"] = "#a1a1a1";
					}
					if (!array_key_exists("textColor", $preset)){
						$preset["textColor"] = "#5a5a5a";
					}
					if (!array_key_exists("inputBackgroundColor", $preset)){
						$preset["inputBackgroundColor"] = "#000000";
					}
					if (!array_key_exists("inputColor", $preset)){
						$preset["inputColor"] = "#FFFFFF";
					}
					
					if (!array_key_exists("playlist_background_color", $preset)){
						$preset["playlist_background_color"] = "#000000";
					}
					
					if (!array_key_exists("search_input_color", $preset))
					{
						$preset["search_input_color"] = "#888888";
					}
					
					if (!array_key_exists("search_bar_height", $preset))
					{
						$preset["search_bar_height"] = 42;
					}
					
					if (!array_key_exists("input_search_text_offset_top", $preset))
					{
						$preset["input_search_text_offset_top"] = 1;
					}
					
					if (!array_key_exists("input_search_offset_left", $preset))
					{
						$preset["input_search_offset_left"] = 0;
					}
					break;
				case "classic_skin_dark":

					if (!array_key_exists("toolTipsButtonsBackgroundColor", $preset)){
			    		$preset["toolTipsButtonsBackgroundColor"] = "#FFFFFF";
					}

					if (!array_key_exists("atbTimeBackgroundColor", $preset)){
						$preset["atbTimeBackgroundColor"] = "#transparent";
					}
					if (!array_key_exists("atbTimeTextColorNormal", $preset)){
						$preset["atbTimeTextColorNormal"] = "#bdbdbd";
					}
					if (!array_key_exists("atbTimeTextColorSelected", $preset)){
						$preset["atbTimeTextColorSelected"] = "#FFFFFF";
					}
					if (!array_key_exists("atbButtonTextNormalColor", $preset)){
						$preset["atbButtonTextNormalColor"] = "#888888";
					}
					if (!array_key_exists("atbButtonTextSelectedColor", $preset)){
						$preset["atbButtonTextSelectedColor"] = "#FFFFFF";
					}
					if (!array_key_exists("atbButtonBackgroundNormalColor", $preset)){
						$preset["atbButtonBackgroundNormalColor"] = "#FFFFFF";
					}
					if (!array_key_exists("atbButtonBackgroundSelectedColor", $preset)){
						$preset["atbButtonBackgroundSelectedColor"] = "#000000";
					}

					if (!array_key_exists("scrubbersToolTipLabelBackgroundColor", $preset)){
						$preset["scrubbersToolTipLabelBackgroundColor"] = "#FFFFFF";
					}
					if (!array_key_exists("scrubbersToolTipLabelFontColor", $preset)){
						$preset["scrubbersToolTipLabelFontColor"] = "#5a5a5a";
					}
			
					if (!array_key_exists("mainSelectorBackgroundSelectedColor", $preset)){
						$preset["mainSelectorBackgroundSelectedColor"] = "#FFFFFF";
					}
					if (!array_key_exists("mainSelectorTextNormalColor", $preset)){
						$preset["mainSelectorTextNormalColor"] = "#FFFFFF";
					}
					if (!array_key_exists("mainSelectorTextSelectedColor", $preset)){
						$preset["mainSelectorTextSelectedColor"] = "#000000";
					}
					if (!array_key_exists("mainButtonTextNormalColor", $preset)){
						$preset["mainButtonTextNormalColor"] = "#888888";
					}
					if (!array_key_exists("mainButtonTextSelectedColor", $preset)){
						$preset["mainButtonTextSelectedColor"] = "#FFFFFF";
					}
					if (!array_key_exists("playbackRateWindowTextColor", $preset)){
						$preset["playbackRateWindowTextColor"] = "#000000";
					}
					
					if (!array_key_exists("borderColor", $preset)){
						$preset["borderColor"] = "#333333";
					}
					if (!array_key_exists("secondaryLabelsColor", $preset)){
						$preset["secondaryLabelsColor"] = "#a1a1a1";
					}
					if (!array_key_exists("textColor", $preset)){
						$preset["textColor"] = "#5a5a5a";
					}
					if (!array_key_exists("inputBackgroundColor", $preset)){
						$preset["inputBackgroundColor"] = "#000000";
					}
					if (!array_key_exists("inputColor", $preset)){
						$preset["inputColor"] = "#FFFFFF";
					}
					
					if (!array_key_exists("playlist_background_color", $preset))
					{
						$preset["playlist_background_color"] = "#000000";
					}
					
					if (!array_key_exists("search_input_color", $preset))
					{
						$preset["search_input_color"] = "#bdbdbd";
					}
					
					if (!array_key_exists("search_bar_height", $preset))
					{
						$preset["search_bar_height"] = 40;
					}
					
					if (!array_key_exists("input_search_text_offset_top", $preset))
					{
						$preset["input_search_text_offset_top"] = 1;
					}
					
					if (!array_key_exists("input_search_offset_left", $preset))
					{
						$preset["input_search_offset_left"] = 0;
					}
					break;
				case "metal_skin_dark":

					if (!array_key_exists("toolTipsButtonsBackgroundColor", $preset)){
			    		$preset["toolTipsButtonsBackgroundColor"] = "#FFFFFF";
					}

					if (!array_key_exists("atbTimeBackgroundColor", $preset)){
						$preset["atbTimeBackgroundColor"] = "#transparent";
					}
					if (!array_key_exists("atbTimeTextColorNormal", $preset)){
						$preset["atbTimeTextColorNormal"] = "#999999";
					}
					if (!array_key_exists("atbTimeTextColorSelected", $preset)){
						$preset["atbTimeTextColorSelected"] = "#FFFFFF";
					}
					if (!array_key_exists("atbButtonTextNormalColor", $preset)){
						$preset["atbButtonTextNormalColor"] = "#888888";
					}
					if (!array_key_exists("atbButtonTextSelectedColor", $preset)){
						$preset["atbButtonTextSelectedColor"] = "#FFFFFF";
					}
					if (!array_key_exists("atbButtonBackgroundNormalColor", $preset)){
						$preset["atbButtonBackgroundNormalColor"] = "#FFFFFF";
					}
					if (!array_key_exists("atbButtonBackgroundSelectedColor", $preset)){
						$preset["atbButtonBackgroundSelectedColor"] = "#000000";
					}

					if (!array_key_exists("scrubbersToolTipLabelBackgroundColor", $preset)){
						$preset["scrubbersToolTipLabelBackgroundColor"] = "#FFFFFF";
					}
					if (!array_key_exists("scrubbersToolTipLabelFontColor", $preset)){
						$preset["scrubbersToolTipLabelFontColor"] = "#5a5a5a";
					}
					
					if (!array_key_exists("mainSelectorBackgroundSelectedColor", $preset)){
						$preset["mainSelectorBackgroundSelectedColor"] = "#FFFFFF";
					}
					if (!array_key_exists("mainSelectorTextNormalColor", $preset)){
						$preset["mainSelectorTextNormalColor"] = "#FFFFFF";
					}
					if (!array_key_exists("mainSelectorTextSelectedColor", $preset)){
						$preset["mainSelectorTextSelectedColor"] = "#000000";
					}
					if (!array_key_exists("mainButtonTextNormalColor", $preset)){
						$preset["mainButtonTextNormalColor"] = "#999999";
					}
					if (!array_key_exists("mainButtonTextSelectedColor", $preset)){
						$preset["mainButtonTextSelectedColor"] = "#FFFFFF";
					}
					if (!array_key_exists("playbackRateWindowTextColor", $preset)){
						$preset["playbackRateWindowTextColor"] = "#000000";
					}
					
					if (!array_key_exists("playlist_background_color", $preset))
					{
						$preset["playlist_background_color"] = "#000000";
					}
					
					if (!array_key_exists("search_input_color", $preset))
					{
						$preset["search_input_color"] = "#999999";
					}
					
					if (!array_key_exists("search_bar_height", $preset))
					{
						$preset["search_bar_height"] = 44;
					}
					
					if (!array_key_exists("borderColor", $preset)){
						$preset["borderColor"] = "#333333";
					}
					if (!array_key_exists("secondaryLabelsColor", $preset)){
						$preset["secondaryLabelsColor"] = "#a1a1a1";
					}
					if (!array_key_exists("textColor", $preset)){
						$preset["textColor"] = "#5a5a5a";
					}
					if (!array_key_exists("inputBackgroundColor", $preset)){
						$preset["inputBackgroundColor"] = "#000000";
					}
					if (!array_key_exists("inputColor", $preset)){
						$preset["inputColor"] = "#FFFFFF";
					}
					if (!array_key_exists("input_search_text_offset_top", $preset))
					{
						$preset["input_search_text_offset_top"] = 2;
					}
					
					if (!array_key_exists("input_search_offset_left", $preset))
					{
						$preset["input_search_offset_left"] = 2;
					}
					break;
				case "minimal_skin_white":
					if (!array_key_exists("toolTipsButtonsBackgroundColor", $preset)){
			    		$preset["toolTipsButtonsBackgroundColor"] = "#000000";
					}

					if (!array_key_exists("atbTimeBackgroundColor", $preset)){
						$preset["atbTimeBackgroundColor"] = "#transparent";
					}
					if (!array_key_exists("atbTimeTextColorNormal", $preset)){
						$preset["atbTimeTextColorNormal"] = "#919191";
					}
					if (!array_key_exists("atbTimeTextColorSelected", $preset)){
						$preset["atbTimeTextColorSelected"] = "#000000";
					}
					if (!array_key_exists("atbButtonTextNormalColor", $preset)){
						$preset["atbButtonTextNormalColor"] = "#FFFFFF";
					}
					if (!array_key_exists("atbButtonTextSelectedColor", $preset)){
						$preset["atbButtonTextSelectedColor"] = "#888888";
					}
					if (!array_key_exists("atbButtonBackgroundNormalColor", $preset)){
						$preset["atbButtonBackgroundNormalColor"] = "#000000";
					}
					if (!array_key_exists("atbButtonBackgroundSelectedColor", $preset)){
						$preset["atbButtonBackgroundSelectedColor"] = "#FFFFFF";
					}

					if (!array_key_exists("scrubbersToolTipLabelBackgroundColor", $preset)){
						$preset["scrubbersToolTipLabelBackgroundColor"] = "#919191";
					}
					if (!array_key_exists("scrubbersToolTipLabelFontColor", $preset)){
						$preset["scrubbersToolTipLabelFontColor"] = "#FFFFFF";
					}
				
					if (!array_key_exists("mainSelectorBackgroundSelectedColor", $preset)){
						$preset["mainSelectorBackgroundSelectedColor"] = "#000000";
					}
					if (!array_key_exists("mainSelectorTextNormalColor", $preset)){
						$preset["mainSelectorTextNormalColor"] = "#000000";
					}
					if (!array_key_exists("mainSelectorTextSelectedColor", $preset)){
						$preset["mainSelectorTextSelectedColor"] = "#FFFFFF";
					}
					if (!array_key_exists("mainButtonTextNormalColor", $preset)){
						$preset["mainButtonTextNormalColor"] = "#6a6a6a";
					}
					if (!array_key_exists("mainButtonTextSelectedColor", $preset)){
						$preset["mainButtonTextSelectedColor"] = "#000000";
					}
					if (!array_key_exists("playbackRateWindowTextColor", $preset)){
						$preset["playbackRateWindowTextColor"] = "#FFFFFF";
					}
					if (!array_key_exists("playlist_background_color", $preset))
					{
						$preset["playlist_background_color"] = "#FFFFFF";
					}
					
					if (!array_key_exists("search_input_color", $preset))
					{
						$preset["search_input_color"] = "#000000";
					}
					
					if (!array_key_exists("search_bar_height", $preset))
					{
						$preset["search_bar_height"] = 38;
					}
					
					if (!array_key_exists("input_search_text_offset_top", $preset))
					{
						$preset["input_search_text_offset_top"] = 2;
					}
					
					if (!array_key_exists("input_search_offset_left", $preset))
					{
						$preset["input_search_offset_left"] = 0;
					}
				
					if (!array_key_exists("borderColor", $preset)){
						$preset["borderColor"] = "#CDCDCD";
					}
					if (!array_key_exists("secondaryLabelsColor", $preset)){
						$preset["secondaryLabelsColor"] = "#444444";
					}
					if (!array_key_exists("textColor", $preset)){
						$preset["textColor"] = "#777777";
					}
					if (!array_key_exists("inputBackgroundColor", $preset)){
						$preset["inputBackgroundColor"] = "#c0c0c0";
					}
					if (!array_key_exists("inputColor", $preset)){
						$preset["inputColor"] = "#333333";
					}
					break;
				case "modern_skin_white":
					if (!array_key_exists("toolTipsButtonsBackgroundColor", $preset)){
			    		$preset["toolTipsButtonsBackgroundColor"] = "#000000";
					}

					if (!array_key_exists("atbTimeBackgroundColor", $preset)){
						$preset["atbTimeBackgroundColor"] = "#transparent";
					}
					if (!array_key_exists("atbTimeTextColorNormal", $preset)){
						$preset["atbTimeTextColorNormal"] = "#000000";
					}
					if (!array_key_exists("atbTimeTextColorSelected", $preset)){
						$preset["atbTimeTextColorSelected"] = "#000000";
					}
					if (!array_key_exists("atbButtonTextNormalColor", $preset)){
						$preset["atbButtonTextNormalColor"] = "#888888";
					}
					if (!array_key_exists("atbButtonTextSelectedColor", $preset)){
						$preset["atbButtonTextSelectedColor"] = "#FFFFFF";
					}
					if (!array_key_exists("atbButtonBackgroundNormalColor", $preset)){
						$preset["atbButtonBackgroundNormalColor"] = "#FFFFFF";
					}
					if (!array_key_exists("atbButtonBackgroundSelectedColor", $preset)){
						$preset["atbButtonBackgroundSelectedColor"] = "#000000";
					}

					if (!array_key_exists("scrubbersToolTipLabelBackgroundColor", $preset)){
						$preset["scrubbersToolTipLabelBackgroundColor"] = "#FFFFFF";
					}
					if (!array_key_exists("scrubbersToolTipLabelFontColor", $preset)){
						$preset["scrubbersToolTipLabelFontColor"] = "#5a5a5a";
					}
				
					if (!array_key_exists("mainSelectorBackgroundSelectedColor", $preset)){
						$preset["mainSelectorBackgroundSelectedColor"] = "#000000";
					}
					if (!array_key_exists("mainSelectorTextNormalColor", $preset)){
						$preset["mainSelectorTextNormalColor"] = "#000000";
					}
					if (!array_key_exists("mainSelectorTextSelectedColor", $preset)){
						$preset["mainSelectorTextSelectedColor"] = "#FFFFFF";
					}
					if (!array_key_exists("mainButtonTextNormalColor", $preset)){
						$preset["mainButtonTextNormalColor"] = "#6a6a6a";
					}
					if (!array_key_exists("mainButtonTextSelectedColor", $preset)){
						$preset["mainButtonTextSelectedColor"] = "#000000";
					}
					if (!array_key_exists("playbackRateWindowTextColor", $preset)){
						$preset["playbackRateWindowTextColor"] = "#FFFFFF";
					}
					
					if (!array_key_exists("playlist_background_color", $preset))
					{
						$preset["playlist_background_color"] = "#AAAAAA";
					}
					
					if (!array_key_exists("search_input_color", $preset))
					{
						$preset["search_input_color"] = "#000000";
					}
					
					if (!array_key_exists("search_bar_height", $preset))
					{
						$preset["search_bar_height"] = 42;
					}
					
					if (!array_key_exists("input_search_text_offset_top", $preset))
					{
						$preset["input_search_text_offset_top"] = 2;
					}
					
					if (!array_key_exists("input_search_offset_left", $preset))
					{
						$preset["input_search_offset_left"] = 0;
					}
					if (!array_key_exists("borderColor", $preset)){
						$preset["borderColor"] = "#CDCDCD";
					}
					if (!array_key_exists("secondaryLabelsColor", $preset)){
						$preset["secondaryLabelsColor"] = "#444444";
					}
					if (!array_key_exists("textColor", $preset)){
						$preset["textColor"] = "#777777";
					}
					if (!array_key_exists("inputBackgroundColor", $preset)){
						$preset["inputBackgroundColor"] = "#c0c0c0";
					}
					if (!array_key_exists("inputColor", $preset)){
						$preset["inputColor"] = "#333333";
					}
					break;
				case "classic_skin_white":
					if (!array_key_exists("toolTipsButtonsBackgroundColor", $preset)){
			    		$preset["toolTipsButtonsBackgroundColor"] = "#494949";
					}

					if (!array_key_exists("atbTimeBackgroundColor", $preset)){
						$preset["atbTimeBackgroundColor"] = "#transparent";
					}
					if (!array_key_exists("atbTimeTextColorNormal", $preset)){
						$preset["atbTimeTextColorNormal"] = "#666666";
					}
					if (!array_key_exists("atbTimeTextColorSelected", $preset)){
						$preset["atbTimeTextColorSelected"] = "#000000";
					}
					if (!array_key_exists("atbButtonTextNormalColor", $preset)){
						$preset["atbButtonTextNormalColor"] = "#888888";
					}
					if (!array_key_exists("atbButtonTextSelectedColor", $preset)){
						$preset["atbButtonTextSelectedColor"] = "#FFFFFF";
					}
					if (!array_key_exists("atbButtonBackgroundNormalColor", $preset)){
						$preset["atbButtonBackgroundNormalColor"] = "#FFFFFF";
					}
					if (!array_key_exists("atbButtonBackgroundSelectedColor", $preset)){
						$preset["atbButtonBackgroundSelectedColor"] = "#000000";
					}

					if (!array_key_exists("scrubbersToolTipLabelBackgroundColor", $preset)){
						$preset["scrubbersToolTipLabelBackgroundColor"] = "#FFFFFF";
					}
					if (!array_key_exists("scrubbersToolTipLabelFontColor", $preset)){
						$preset["scrubbersToolTipLabelFontColor"] = "#5a5a5a";
					}

					if (!array_key_exists("mainSelectorBackgroundSelectedColor", $preset)){
						$preset["mainSelectorBackgroundSelectedColor"] = "#FFFFFF";
					}
					if (!array_key_exists("mainSelectorTextNormalColor", $preset)){
						$preset["mainSelectorTextNormalColor"] = "#FFFFFF";
					}
					if (!array_key_exists("mainSelectorTextSelectedColor", $preset)){
						$preset["mainSelectorTextSelectedColor"] = "#000000";
					}
					if (!array_key_exists("mainButtonTextNormalColor", $preset)){
						$preset["mainButtonTextNormalColor"] = "#FFFFFF";
					}
					if (!array_key_exists("mainButtonTextSelectedColor", $preset)){
						$preset["mainButtonTextSelectedColor"] = "#333333";
					}

					if (!array_key_exists("playbackRateWindowTextColor", $preset)){
						$preset["playbackRateWindowTextColor"] = "#FFFFFF";
					}
					if (!array_key_exists("playlist_background_color", $preset))
					{
						$preset["playlist_background_color"] = "#BBBBBB";
					}
					
					if (!array_key_exists("search_input_color", $preset))
					{
						$preset["search_input_color"] = "#FFFFFF";
					}
					
					if (!array_key_exists("search_bar_height", $preset))
					{
						$preset["search_bar_height"] = 40;
					}
					
					if (!array_key_exists("input_search_text_offset_top", $preset))
					{
						$preset["input_search_text_offset_top"] = 2;
					}
					
					if (!array_key_exists("input_search_offset_left", $preset))
					{
						$preset["input_search_offset_left"] = -2;
					}
					if (!array_key_exists("borderColor", $preset)){
						$preset["borderColor"] = "#CDCDCD";
					}
					if (!array_key_exists("secondaryLabelsColor", $preset)){
						$preset["secondaryLabelsColor"] = "#444444";
					}
					if (!array_key_exists("textColor", $preset)){
						$preset["textColor"] = "#777777";
					}
					if (!array_key_exists("inputBackgroundColor", $preset)){
						$preset["inputBackgroundColor"] = "#c0c0c0";
					}
					if (!array_key_exists("inputColor", $preset)){
						$preset["inputColor"] = "#333333";
					}
					break;
				case "metal_skin_white":
					if (!array_key_exists("toolTipsButtonsBackgroundColor", $preset)){
			    		$preset["toolTipsButtonsBackgroundColor"] = "#FFFFFF";
					}

					if (!array_key_exists("atbTimeBackgroundColor", $preset)){
						$preset["atbTimeBackgroundColor"] = "#transparent";
					}
					if (!array_key_exists("atbTimeTextColorNormal", $preset)){
						$preset["atbTimeTextColorNormal"] = "#919191";
					}
					if (!array_key_exists("atbTimeTextColorSelected", $preset)){
						$preset["atbTimeTextColorSelected"] = "#000000";
					}
					if (!array_key_exists("atbButtonTextNormalColor", $preset)){
						$preset["atbButtonTextNormalColor"] = "#FFFFFF";
					}
					if (!array_key_exists("atbButtonTextSelectedColor", $preset)){
						$preset["atbButtonTextSelectedColor"] = "#888888";
					}
					if (!array_key_exists("atbButtonBackgroundNormalColor", $preset)){
						$preset["atbButtonBackgroundNormalColor"] = "#000000";
					}
					if (!array_key_exists("atbButtonBackgroundSelectedColor", $preset)){
						$preset["atbButtonBackgroundSelectedColor"] = "#FFFFFF";
					}

					if (!array_key_exists("scrubbersToolTipLabelBackgroundColor", $preset)){
						$preset["scrubbersToolTipLabelBackgroundColor"] = "#FFFFFF";
					}
					if (!array_key_exists("scrubbersToolTipLabelFontColor", $preset)){
						$preset["scrubbersToolTipLabelFontColor"] = "#5a5a5a";
					}
				
					if (!array_key_exists("mainSelectorBackgroundSelectedColor", $preset)){
						$preset["mainSelectorBackgroundSelectedColor"] = "#333333";
					}
					if (!array_key_exists("mainSelectorTextNormalColor", $preset)){
						$preset["mainSelectorTextNormalColor"] = "#000000";
					}
					if (!array_key_exists("mainSelectorTextSelectedColor", $preset)){
						$preset["mainSelectorTextSelectedColor"] = "#FFFFFF";
					}
					if (!array_key_exists("mainButtonTextNormalColor", $preset)){
						$preset["mainButtonTextNormalColor"] = "#6a6a6a";
					}
					if (!array_key_exists("mainButtonTextSelectedColor", $preset)){
						$preset["mainButtonTextSelectedColor"] = "#000000";
					}
					if (!array_key_exists("playbackRateWindowTextColor", $preset)){
						$preset["playbackRateWindowTextColor"] = "#FFFFFF";
					}
					if (!array_key_exists("playlist_background_color", $preset))
					{
						$preset["playlist_background_color"] = "#e6e4e6";
					}
					
					if (!array_key_exists("search_input_color", $preset))
					{
						$preset["search_input_color"] = "#000000";
					}
					
					if (!array_key_exists("search_bar_height", $preset))
					{
						$preset["search_bar_height"] = 44;
					}
					
					if (!array_key_exists("input_search_text_offset_top", $preset))
					{
						$preset["input_search_text_offset_top"] = 2;
					}
					
					if (!array_key_exists("input_search_offset_left", $preset))
					{
						$preset["input_search_offset_left"] = 2;
					}
					if (!array_key_exists("borderColor", $preset)){
						$preset["borderColor"] = "#CDCDCD";
					}
					if (!array_key_exists("secondaryLabelsColor", $preset)){
						$preset["secondaryLabelsColor"] = "#444444";
					}
					if (!array_key_exists("textColor", $preset)){
						$preset["textColor"] = "#777777";
					}
					if (!array_key_exists("inputBackgroundColor", $preset)){
						$preset["inputBackgroundColor"] = "#c0c0c0";
					}
					if (!array_key_exists("inputColor", $preset)){
						$preset["inputColor"] = "#333333";
					}
					break;
			}
    	}
		
		$this->set_data();
	}
    

    // Init data.
    private function init_settings(){
    	$this->settings_ar = array(
									array(
											// main settings
											"id" => 0,
											"use_youtube" => "no",
											"use_video" => "no",
											"openPopupOnPlay" => "no",
											"start_at_random_track" => "no",
											"soundCloudAPIKey" => "",
											"ytbAPiKey" => "",
											"proxyCors" => "",
											"show_full_screen_button" => "yes",
											"showPlaybackRateButton" => "yes",
											"privatePassword" => "Melinda",
											"showPlaylistsSearchInput" => "yes",
											"showMainBackground" => "yes",
											"addKeyboardSupport" => "yes",
											"defaultPlaybackRate" => 1,
											"playbackRateWindowTextColor" => "#000000",
											"playTrackAfterPlaylistLoad" => "no",
											//password window
											"borderColor" => "#333333",
											"secondaryLabelsColor" => "#a1a1a1",
											"textColor" => "#5a5a5a",
											"inputBackgroundColor" => "#000000",
											"inputColor" => "#FFFFFF",
											
											"horizontalPosition" => "center",
											"verticalPosition" => "bottom",
											"use_HEX_colors_for_skin" => "no",
											"normal_HEX_buttons_color" => "#FF0000",
											"useVectorIcons" => "no",
											"name" => "skin_minimal_dark",
											"skin_path" => "minimal_skin_dark",
											"show_soundcloud_username_in_title" => "yes",
											"verticalPosition" => "bottom",
											"use_deeplinking" => "yes",
											"right_click_context_menu" => "developer",
											"show_buttons_tooltips" => "yes",
											"animate" => "yes",
											"autoplay" => "no",
											"loop" => "no",
											"shuffle" => "no",
											"max_width" => 850,
											"volume" => .9,
											"tooltips_buttons_hide_delay" => 1.5,
											"toolTipsButtonsBackgroundColor" => "#FFFFFF",
											"tooltips_button_font_color" => "#5a5a5a",
											"playTrackOnlyWhenLoggedIn" => "no",
											"googleAnalyticsTrackingCode" => "",
											"playIfLoggedIn" => "no",
											"useContinuousPlayback"	=> "no",
											"loggedInMessage" => "Please login to play the track.",
											"showMainScrubberAndVolumeScrubberToolTipLabel" => "yes",
											"scrubbersToolTipLabelBackgroundColor" => "#FFFFFF",
											"scrubbersToolTipLabelFontColor" => "#5a5a5a",
											
											// controller settings
											"show_controller_by_default" => "yes",
											"show_thumbnail" => "yes",
											"disable_scrubber" => "no",
											"show_next_and_prev_buttons" => "yes",
											"show_loop_button" => "yes",
											"show_shuffle_button" => "yes",
											"show_download_mp3_button" => "yes",
											"show_share_button" => "yes",
											"show_buy_button" => "yes",
											"expand_background" => "no",
											"title_color" => "#FFFFFF",
											"time_color" => "#888888",
											
											// controller align and size settings
											"controller_height" => 76,
											"start_space_between_buttons" => 9,
											"space_between_buttons" => 8,
											"separator_offset_out_space" => 5,
											"separator_offset_in_space" => 9,
											"last_buttons_offset_top" => 14,
											"all_buttons_offset_top_and_bottom" => 14,
											"title_bar_offset_top" => 13,
											"main_scrubber_offset_top" => 47,
											"space_between_main_scrubber_and_time" => 10,
											"start_time_space" => 10,
											"scrubbers_offset_width" => 2,
											"scrubbers_offset_total_width" => 0,
											"volume_button_and_scrubber_offset_top" => 47,
											"space_between_volume_button_and_scrubber" => 6,
											"volume_scrubber_offset_width" => 4,
											"scrubber_offset_bottom" => 10,
											"equalizer_offset_left" => 1,
											
											// playlists window settings
											"show_playlists_button_and_playlists" => "yes",
											"usePlaylistsSelectBox" => "yes",
											"showPlaylistsSelectBoxNumbers" => "yes",
											"show_playlists_by_default" => "no",
											"thumbnail_selected_type" => "opacity",
											"start_at_playlist" => 0,
											"start_at_track" => 0,
											"buttons_margins" => 7,
											"thumbnail_max_width" => 330,
											"thumbnail_max_height" => 330,
											"horizontal_space_between_thumbnails" => 40,
											"vertical_space_between_thumbnails" => 40,
											
											// playlist settings
											"show_playlist_button_and_playlist" => "yes",
											"randomizePlaylist" => "no",
											"showPlayListOnMobile" => "yes",
											"show_playlist_by_default" => "no",
											"show_playlist_item_play_button" => "yes",
											"show_playlist_item_download_button" => "yes",
											"show_playlist_item_buy_button" => "yes",
											"force_disable_download_button_for_podcast" => "yes",
											"force_disable_download_button_for_official_fm" => "yes",
											"force_disable_download_button_for_folder" => "yes",
											"add_scrollbar_mouse_wheel_support" => "yes",
											"track_title_normal_color" => "#888888",
											"track_title_selected_color" => "#FFFFFF",
											"track_duration_color" => "#888888",
											"mainSelectorBackgroundSelectedColor" => "#FFFFFF",
											"mainSelectorTextNormalColor" => "#FFFFFF",
											"mainSelectorTextSelectedColor" => "#000000",
											"mainButtonTextNormalColor" => "#888888",
											"mainButtonTextSelectedColor" => "#FFFFFF",
											"playlistSelectorHeight" => 37,
											"playlistItemHeight" => 33,
											"max_playlist_items" => 100,
											"nr_of_visible_playlist_items" => 9,
											"track_title_offset_left" => 0,
											"play_pause_button_offset_left_and_right" => 11,
											"duration_offset_right" => 9,
											"download_button_offset_right" => 11,
											"scrollbar_offset_width" => 7,
											
											//opener settings
											"show_opener" => "yes",
											"show_opener_play_pause_button" => "yes",
											"opener_alignment" => "right",
											"show_oppener_play_pause_button" => "yes",
											"opener_equlizer_offset_left" => 3,
											"opener_equlizer_offset_top" => -1,
											
											// popup settings
											"show_popup_button" => "yes",
											"popup_window_background_color" => "#878787",
											"popup_window_width" => 850,
											"popup_window_height" => 451,

											//a to b loop
											"playbackRateButtonsMargins" => 7,
											"atbTimeBackgroundColor" => "transparent",
											"atbTimeTextColorNormal" => "#888888",
											"atbTimeTextColorSelected" => "#FFFFFF",
											"atbButtonTextNormalColor" => "#888888",
											"atbButtonTextSelectedColor" => "#FFFFFF",
											"atbButtonBackgroundNormalColor" => "#FFFFFF",
											"atbButtonBackgroundSelectedColor" => "#000000",

											// visualizer
											"useVisualizer" => "yes",
											"useDumyVisualizeOnIOS" => "yes",
											"visualizerRandomPreset" => "no",
											"visualizerPreset" => "bars1",
											"visualizerColor" => array("#AAAAAA", "#999999", "#888888", "#777777", "#666666"),
											"visualizerCapColor" => "#FFFFFF"
				
									),
									array(
											// main settings
											"id" => 1,
											"use_youtube" => "no",
											"use_video" => "no",
											"openPopupOnPlay" => "no",
											"start_at_random_track" => "no",
											"soundCloudAPIKey" => "",
											"ytbAPiKey" => "",
											"proxyCors" => "",
											"show_full_screen_button" => "yes",
											"showPlaybackRateButton" => "yes",
											"privatePassword" => "Melinda",
											"showPlaylistsSearchInput" => "yes",
											"showMainBackground" => "yes",
											"addKeyboardSupport" => "yes",
											"defaultPlaybackRate" => 1,
											"playbackRateWindowTextColor" => "#000000",
											"playTrackAfterPlaylistLoad" => "no",
											//password window
											"borderColor" => "#333333",
											"secondaryLabelsColor" => "#a1a1a1",
											"textColor" => "#5a5a5a",
											"inputBackgroundColor" => "#000000",
											"inputColor" => "#FFFFFF",
											
											"horizontalPosition" => "center",
											"verticalPosition" => "bottom",
											"use_HEX_colors_for_skin" => "no",
											"normal_HEX_buttons_color" => "#FF0000",
											"useVectorIcons" => "no",
											"name" => "skin_modern_dark",
											"skin_path" => "modern_skin_dark",
											"show_soundcloud_username_in_title" => "yes",
											"verticalPosition" => "bottom",
											"use_deeplinking" => "yes",
											"right_click_context_menu" => "developer",
											"show_buttons_tooltips" => "yes",
											"animate" => "yes",
											"autoplay" => "no",
											"loop" => "no",
											"shuffle" => "no",
											"max_width" => 900,
											"volume" => .9,
											"tooltips_buttons_hide_delay" => 1.5,
											"toolTipsButtonsBackgroundColor" => "#FFFFFF",
											"tooltips_button_font_color" => "#000000",
											"playTrackOnlyWhenLoggedIn" => "no",
											"googleAnalyticsTrackingCode" => "",
											"playIfLoggedIn" => "no",
											"useContinuousPlayback"	=> "no",
											"loggedInMessage" => "Please login to play the track.",
											"showMainScrubberAndVolumeScrubberToolTipLabel" => "yes",
											"scrubbersToolTipLabelBackgroundColor" => "#FFFFFF",
											"scrubbersToolTipLabelFontColor" => "#000000",
											
											// controller settings
											"show_controller_by_default" => "yes",
											"show_thumbnail" => "yes",
											"disable_scrubber" => "no",
											"show_next_and_prev_buttons" => "yes",
											"show_loop_button" => "yes",
											"show_shuffle_button" => "yes",
											"show_download_mp3_button" => "yes",
											"show_share_button" => "yes",
											"show_buy_button" => "yes",
											"expand_background" => "no",
											"title_color" => "#FFFFFF",
											"time_color" => "#777777",
											
											// controller align and size settings
											"controller_height" => 85,
											"start_space_between_buttons" => 10,
											"space_between_buttons" => 10,
											"separator_offset_out_space" => 4,
											"separator_offset_in_space" => 7,
											"last_buttons_offset_top" => 7,
											"all_buttons_offset_top_and_bottom" => 15,
											"title_bar_offset_top" => 12,
											"main_scrubber_offset_top" => 53,
											"space_between_main_scrubber_and_time" => 6,
											"start_time_space" => 10,
											"scrubbers_offset_width" => 3,
											"scrubbers_offset_total_width" => -6,
											"volume_button_and_scrubber_offset_top" => 46,
											"space_between_volume_button_and_scrubber" => 5,
											"volume_scrubber_offset_width" => 2,
											"scrubber_offset_bottom" => 6,
											"equalizer_offset_left" => 2,
											
											// playlists window settings
											"show_playlists_button_and_playlists" => "yes",
											"usePlaylistsSelectBox" => "yes",
											"showPlaylistsSelectBoxNumbers" => "yes",
											"mainSelectorBackgroundSelectedColor" => "#FFFFFF",
											"mainSelectorTextNormalColor" => "#FFFFFF",
											"mainSelectorTextSelectedColor" => "#000000",
											"mainButtonTextNormalColor" => "#888888",
											"mainButtonTextSelectedColor" => "#FFFFFF",
											"show_playlists_by_default" => "no",
											"thumbnail_selected_type" => "opacity",
											"start_at_playlist" => 0,
											"start_at_track" => 0,
											"buttons_margins" => 7,
											"thumbnail_max_width" => 330,
											"thumbnail_max_height" => 330,
											"horizontal_space_between_thumbnails" => 40,
											"vertical_space_between_thumbnails" => 40,
											
											// playlist settings
											"show_playlist_button_and_playlist" => "yes",
											"randomizePlaylist" => "no",
											"showPlayListOnMobile" => "yes",
											"show_playlist_by_default" => "no",
											"show_playlist_item_play_button" => "yes",
											"show_playlist_item_download_button" => "yes",
											"show_playlist_item_buy_button" => "yes",
											"force_disable_download_button_for_podcast" => "yes",
											"force_disable_download_button_for_official_fm" => "yes",
											"force_disable_download_button_for_folder" => "yes",
											"add_scrollbar_mouse_wheel_support" => "yes",
											"track_title_normal_color" => "#777777",
											"track_title_selected_color" => "#FFFFFF",
											"track_duration_color" => "#777777",
											"playlistSelectorHeight" => 37,
											"playlistItemHeight" => 33,
											"max_playlist_items" => 100,
											"nr_of_visible_playlist_items" => 9,
											"track_title_offset_left" => 0,
											"play_pause_button_offset_left_and_right" => 11,
											"duration_offset_right" => 9,
											"download_button_offset_right" => 11,
											"scrollbar_offset_width" => 7,
											
											//opener settings
											"show_opener" => "yes",
											"show_opener_play_pause_button" => "yes",
											"opener_alignment" => "right",
											"show_oppener_play_pause_button" => "yes",
											"opener_equlizer_offset_left" => 3,
											"opener_equlizer_offset_top" => -1,
											
											// popup settings
											"show_popup_button" => "yes",
											"popup_window_background_color" => "#878787",
											"popup_window_width" => 850,
											"popup_window_height" => 464,

											//a to b loop
											"playbackRateButtonsMargins" => 7,
											"atbTimeBackgroundColor" => "transparent",
											"atbTimeTextColorNormal" => "#888888",
											"atbTimeTextColorSelected" => "#FFFFFF",
											"atbButtonTextNormalColor" => "#888888",
											"atbButtonTextSelectedColor" => "#FFFFFF",
											"atbButtonBackgroundNormalColor" => "#FFFFFF",
											"atbButtonBackgroundSelectedColor" => "#000000",

											// visualizer
											"useVisualizer" => "yes",
											"useDumyVisualizeOnIOS" => "yes",
											"visualizerRandomPreset" => "no",
											"visualizerPreset" => "bars1",
											"visualizerColor" => array("#AAAAAA", "#999999", "#888888", "#777777", "#666666"),
											"visualizerCapColor" => "#FFFFFF"
									),
									array(
											// main settings
											"id" => 2,
											"use_youtube" => "no",
											"use_video" => "no",
											"openPopupOnPlay" => "no",
											"start_at_random_track" => "no",
											"soundCloudAPIKey" => "",
											"ytbAPiKey" => "",
											"proxyCors" => "",
											"show_full_screen_button" => "yes",
											"showPlaybackRateButton" => "yes",
											"privatePassword" => "Melinda",
											"showPlaylistsSearchInput" => "yes",
											"showMainBackground" => "yes",
											"addKeyboardSupport" => "yes",
											"defaultPlaybackRate" => 1,
											"playbackRateWindowTextColor" => "#000000",
											"playTrackAfterPlaylistLoad" => "no",
											//password window
											"borderColor" => "#333333",
											"secondaryLabelsColor" => "#a1a1a1",
											"textColor" => "#5a5a5a",
											"inputBackgroundColor" => "#000000",
											"inputColor" => "#FFFFFF",
											
											"horizontalPosition" => "center",
											"verticalPosition" => "bottom",
											"use_HEX_colors_for_skin" => "no",
											"normal_HEX_buttons_color" => "#FF0000",
											"useVectorIcons" => "no",
											"name" => "skin_classic_dark",
											"skin_path" => "classic_skin_dark",
											"show_soundcloud_username_in_title" => "yes",
											"verticalPosition" => "bottom",
											"use_deeplinking" => "yes",
											"right_click_context_menu" => "developer",
											"show_buttons_tooltips" => "yes",
											"animate" => "yes",
											"autoplay" => "no",
											"loop" => "no",
											"shuffle" => "no",
											"max_width" => 850,
											"volume" => .9,
											"tooltips_buttons_hide_delay" => 1.5,
											"toolTipsButtonsBackgroundColor" => "#FFFFFF",
											"tooltips_button_font_color" => "#000000",
											"playTrackOnlyWhenLoggedIn" => "no",
											"googleAnalyticsTrackingCode" => "",
											"playIfLoggedIn" => "no",
											"useContinuousPlayback"	=> "no",
											"loggedInMessage" => "Please login to play the track.",
											"showMainScrubberAndVolumeScrubberToolTipLabel" => "yes",
											"scrubbersToolTipLabelBackgroundColor" => "#FFFFFF",
											"scrubbersToolTipLabelFontColor" => "#000000",
											
											// controller settings
											"show_controller_by_default" => "yes",
											"show_thumbnail" => "yes",
											"disable_scrubber" => "no",
											"show_next_and_prev_buttons" => "yes",
											"show_loop_button" => "yes",
											"show_shuffle_button" => "yes",
											"show_download_mp3_button" => "yes",
											"show_share_button" => "yes",
											"show_buy_button" => "yes",
											"expand_background" => "yes",
											"title_color" => "#FFFFFF",
											"time_color" => "#888888",
											
											// controller align and size settings
											"controller_height" => 82,
											"start_space_between_buttons" => 10,
											"space_between_buttons" => 12,
											"separator_offset_out_space" => 12,
											"separator_offset_in_space" => 17,
											"last_buttons_offset_top" => 16,
											"all_buttons_offset_top_and_bottom" => 16,
											"title_bar_offset_top" => 14,
											"main_scrubber_offset_top" => 52,
											"space_between_main_scrubber_and_time" => 10,
											"start_time_space" => 10,
											"scrubbers_offset_width" => 2,
											"scrubbers_offset_total_width" => 0,
											"volume_button_and_scrubber_offset_top" => 52,
											"space_between_volume_button_and_scrubber" => 9,
											"volume_scrubber_offset_width" => 6,
											"scrubber_offset_bottom" => 6,
											"equalizer_offset_left" => 1,
											
											// playlists window settings
											"show_playlists_button_and_playlists" => "yes",
											"usePlaylistsSelectBox" => "yes",
											"showPlaylistsSelectBoxNumbers" => "yes",
											"mainSelectorBackgroundSelectedColor" => "#FFFFFF",
											"mainSelectorTextNormalColor" => "#FFFFFF",
											"mainSelectorTextSelectedColor" => "#000000",
											"mainButtonTextNormalColor" => "#888888",
											"mainButtonTextSelectedColor" => "#FFFFFF",
											"show_playlists_by_default" => "no",
											"thumbnail_selected_type" => "opacity",
											"start_at_playlist" => 0,
											"start_at_track" => 0,
											"buttons_margins" => 7,
											"thumbnail_max_width" => 330,
											"thumbnail_max_height" => 330,
											"horizontal_space_between_thumbnails" => 40,
											"vertical_space_between_thumbnails" => 40,
											
											// playlist settings
											"show_playlist_button_and_playlist" => "yes",
											"randomizePlaylist" => "no",
											"showPlayListOnMobile" => "yes",
											"show_playlist_by_default" => "no",
											"show_playlist_item_play_button" => "yes",
											"show_playlist_item_download_button" => "yes",
											"show_playlist_item_buy_button" => "yes",
											"force_disable_download_button_for_podcast" => "yes",
											"force_disable_download_button_for_official_fm" => "yes",
											"force_disable_download_button_for_folder" => "yes",
											"add_scrollbar_mouse_wheel_support" => "yes",
											"track_title_normal_color" => "#888888",
											"track_title_selected_color" => "#FFFFFF",
											"track_duration_color" => "#bdbdbd",
											"playlistSelectorHeight" => 37,
											"playlistItemHeight" => 33,
											"max_playlist_items" => 100,
											"nr_of_visible_playlist_items" => 9,
											"track_title_offset_left" => 0,
											"play_pause_button_offset_left_and_right" => 11,
											"duration_offset_right" => 9,
											"download_button_offset_right" => 11,
											"scrollbar_offset_width" => 7,
											
											//opener settings
											"show_opener" => "yes",
											"show_opener_play_pause_button" => "yes",
											"opener_alignment" => "right",
											"show_oppener_play_pause_button" => "yes",
											"opener_equlizer_offset_left" => 3,
											"opener_equlizer_offset_top" => -1,
											
											// popup settings
											"show_popup_button" => "yes",
											"popup_window_background_color" => "#000000",
											"popup_window_width" => 850,
											"popup_window_height" => 458,

											//a to b loop
											"playbackRateButtonsMargins" => 7,
											"atbTimeBackgroundColor" => "transparent",
											"atbTimeTextColorNormal" => "#bdbdbd",
											"atbTimeTextColorSelected" => "#FFFFFF",
											"atbButtonTextNormalColor" => "#888888",
											"atbButtonTextSelectedColor" => "#FFFFFF",
											"atbButtonBackgroundNormalColor" => "#FFFFFF",
											"atbButtonBackgroundSelectedColor" => "#000000",

											// visualizer
											"useVisualizer" => "yes",
											"useDumyVisualizeOnIOS" => "yes",
											"visualizerRandomPreset" => "no",
											"visualizerPreset" => "bars1",
											"visualizerColor" => array("#AAAAAA", "#999999", "#888888", "#777777", "#666666"),
											"visualizerCapColor" => "#FFFFFF"
									),
									array(
											// main settings
											"id" => 3,
											"use_youtube" => "no",
											"use_video" => "no",
											"openPopupOnPlay" => "no",
											"start_at_random_track" => "no",
											"soundCloudAPIKey" => "",
											"ytbAPiKey" => "",
											"proxyCors" => "",
											"show_full_screen_button" => "yes",
											"showPlaybackRateButton" => "yes",
											"privatePassword" => "Melinda",
											"showPlaylistsSearchInput" => "yes",
											"showMainBackground" => "yes",
											"addKeyboardSupport" => "yes",
											"defaultPlaybackRate" => 1,
											"playbackRateWindowTextColor" => "#000000",
											"playTrackAfterPlaylistLoad" => "no",
											//password window
											"borderColor" => "#333333",
											"secondaryLabelsColor" => "#a1a1a1",
											"textColor" => "#5a5a5a",
											"inputBackgroundColor" => "#000000",
											"inputColor" => "#FFFFFF",
											
											"horizontalPosition" => "center",
											"verticalPosition" => "bottom",
											"use_HEX_colors_for_skin" => "no",
											"normal_HEX_buttons_color" => "#FF0000",
											"useVectorIcons" => "no",
											"name" => "skin_metal_dark",
											"skin_path" => "metal_skin_dark",
											"show_soundcloud_username_in_title" => "yes",
											"verticalPosition" => "bottom",
											"use_deeplinking" => "yes",
											"right_click_context_menu" => "developer",
											"show_buttons_tooltips" => "yes",
											"animate" => "yes",
											"autoplay" => "no",
											"loop" => "no",
											"shuffle" => "no",
											"max_width" => 900,
											"volume" => .9,
											"tooltips_buttons_hide_delay" => 1.5,
											"toolTipsButtonsBackgroundColor" => "#FFFFFF",
											"tooltips_button_font_color" => "#000000",
											"playTrackOnlyWhenLoggedIn" => "no",
											"googleAnalyticsTrackingCode" => "",
											"playIfLoggedIn" => "no",
											"useContinuousPlayback"	=> "no",
											"loggedInMessage" => "Please login to play the track.",
											"showMainScrubberAndVolumeScrubberToolTipLabel" => "yes",
											"scrubbersToolTipLabelBackgroundColor" => "#FFFFFF",
											"scrubbersToolTipLabelFontColor" => "#000000",
											
											// controller settings
											"show_controller_by_default" => "yes",
											"show_thumbnail" => "yes",
											"disable_scrubber" => "no",
											"show_next_and_prev_buttons" => "yes",
											"show_loop_button" => "yes",
											"show_shuffle_button" => "yes",
											"show_download_mp3_button" => "yes",
											"show_share_button" => "yes",
											"show_buy_button" => "yes",
											"expand_background" => "no",
											"title_color" => "#FFFFFF",
											"time_color" => "#999999",
											
											// controller align and size settings
											"controller_height" => 88,
											"start_space_between_buttons" => 9,
											"space_between_buttons" => 9,
											"separator_offset_out_space" => 4,
											"separator_offset_in_space" => 9,
											"last_buttons_offset_top" => 10,
											"all_buttons_offset_top_and_bottom" => 16,
											"title_bar_offset_top" => 15,
											"main_scrubber_offset_top" => 55,
											"space_between_main_scrubber_and_time" => 6,
											"start_time_space" => 10,
											"scrubbers_offset_width" => 2,
											"scrubbers_offset_total_width" => -6,
											"volume_button_and_scrubber_offset_top" => 48,
											"space_between_volume_button_and_scrubber" => 7,
											"volume_scrubber_offset_width" => 2,
											"scrubber_offset_bottom" => 9,
											"equalizer_offset_left" => 2,
											
											// playlists window settings
											"show_playlists_button_and_playlists" => "yes",
											"usePlaylistsSelectBox" => "yes",
											"mainSelectorBackgroundSelectedColor" => "#FFFFFF",
											"mainSelectorTextNormalColor" => "#FFFFFF",
											"mainSelectorTextSelectedColor" => "#000000",
											"mainButtonTextNormalColor" => "#999999",
											"mainButtonTextSelectedColor" => "#FFFFFF",
											"showPlaylistsSelectBoxNumbers" => "yes",
											"show_playlists_by_default" => "no",
											"thumbnail_selected_type" => "opacity",
											"start_at_playlist" => 0,
											"start_at_track" => 0,
											"buttons_margins" => 0,
											"thumbnail_max_width" => 330,
											"thumbnail_max_height" => 330,
											"horizontal_space_between_thumbnails" => 40,
											"vertical_space_between_thumbnails" => 40,
											
											// playlist settings
											"show_playlist_button_and_playlist" => "yes",
											"randomizePlaylist" => "no",
											"showPlayListOnMobile" => "yes",
											"show_playlist_by_default" => "no",
											"show_playlist_item_play_button" => "yes",
											"show_playlist_item_download_button" => "yes",
											"show_playlist_item_buy_button" => "yes",
											"force_disable_download_button_for_podcast" => "yes",
											"force_disable_download_button_for_official_fm" => "yes",
											"force_disable_download_button_for_folder" => "yes",
											"add_scrollbar_mouse_wheel_support" => "yes",
											"track_title_normal_color" => "#999999",
											"track_title_selected_color" => "#FFFFFF",
											"track_duration_color" => "#999999",
											"playlistSelectorHeight" => 37,
											"playlistItemHeight" => 33,
											"max_playlist_items" => 100,
											"nr_of_visible_playlist_items" => 9,
											"track_title_offset_left" => 0,
											"play_pause_button_offset_left_and_right" => 11,
											"duration_offset_right" => 9,
											"download_button_offset_right" => 11,
											"scrollbar_offset_width" => 7,
											
											//opener settings
											"show_opener" => "yes",
											"show_opener_play_pause_button" => "yes",
											"opener_alignment" => "right",
											"show_oppener_play_pause_button" => "yes",
											"opener_equlizer_offset_left" => 3,
											"opener_equlizer_offset_top" => -1,
											
											// popup settings
											"show_popup_button" => "yes",
											"popup_window_background_color" => "#878787",
											"popup_window_width" => 900,
											"popup_window_height" => 469,

											//a to b loop
											"playbackRateButtonsMargins" => 0,
											"atbTimeBackgroundColor" => "transparent",
											"atbTimeTextColorNormal" => "#999999",
											"atbTimeTextColorSelected" => "#FFFFFF",
											"atbButtonTextNormalColor" => "#888888",
											"atbButtonTextSelectedColor" => "#FFFFFF",
											"atbButtonBackgroundNormalColor" => "#FFFFFF",
											"atbButtonBackgroundSelectedColor" => "#000000",

											// visualizer
											"useVisualizer" => "yes",
											"useDumyVisualizeOnIOS" => "yes",
											"visualizerRandomPreset" => "no",
											"visualizerPreset" => "bars1",
											"visualizerColor" => array("#AAAAAA", "#999999", "#888888", "#777777", "#666666"),
											"visualizerCapColor" => "#FFFFFF"
									),
									array(
											// main settings
											"id" => 4,
											"use_youtube" => "no",
											"use_video" => "no",
											"openPopupOnPlay" => "no",
											"start_at_random_track" => "no",
											"soundCloudAPIKey" => "",
											"ytbAPiKey" => "",
											"proxyCors" => "",
											"show_full_screen_button" => "yes",
											"showPlaybackRateButton" => "yes",
											"privatePassword" => "Melinda",
											"showPlaylistsSearchInput" => "yes",
											"showMainBackground" => "yes",
											"addKeyboardSupport" => "yes",
											"defaultPlaybackRate" => 1,
											"playbackRateWindowTextColor" => "#000000",
											"playTrackAfterPlaylistLoad" => "no",

											//password window
											"borderColor" => "#CDCDCD",
											"secondaryLabelsColor" => "#444444",
											"textColor" => "#777777",
											"inputBackgroundColor" => "#c0c0c0",
											"inputColor" => "#333333",
											
											"horizontalPosition" => "center",
											"verticalPosition" => "bottom",
											"use_HEX_colors_for_skin" => "no",
											"normal_HEX_buttons_color" => "#FF0000",
											"useVectorIcons" => "no",
											"name" => "skin_minimal_white",
											"skin_path" => "minimal_skin_white",
											"show_soundcloud_username_in_title" => "yes",
											"verticalPosition" => "bottom",
											"use_deeplinking" => "yes",
											"right_click_context_menu" => "developer",
											"show_buttons_tooltips" => "yes",
											"animate" => "yes",
											"autoplay" => "no",
											"loop" => "no",
											"shuffle" => "no",
											"max_width" => 850,
											"volume" => .9,
											"tooltips_buttons_hide_delay" => 1.5,
											"toolTipsButtonsBackgroundColor" => "#000000",
											"tooltips_button_font_color" => "#FFFFFF",
											"playTrackOnlyWhenLoggedIn" => "no",
											"googleAnalyticsTrackingCode" => "",
											"playIfLoggedIn" => "no",
											"useContinuousPlayback"	=> "no",
											"loggedInMessage" => "Please login to play the track.",
											"showMainScrubberAndVolumeScrubberToolTipLabel" => "yes",
											"scrubbersToolTipLabelBackgroundColor" => "#000000",
											"scrubbersToolTipLabelFontColor" => "#FFFFFF",
											
											// controller settings
											"show_controller_by_default" => "yes",
											"show_thumbnail" => "yes",
											"disable_scrubber" => "no",
											"show_next_and_prev_buttons" => "yes",
											"show_loop_button" => "yes",
											"show_shuffle_button" => "yes",
											"show_download_mp3_button" => "yes",
											"show_share_button" => "yes",
											"show_buy_button" => "yes",
											"expand_background" => "no",
											"title_color" => "#000000",
											"time_color" => "#6a6a6a",
											
											// controller align and size settings
											"controller_height" => 76,
											"start_space_between_buttons" => 9,
											"space_between_buttons" => 8,
											"separator_offset_out_space" => 5,
											"separator_offset_in_space" => 9,
											"last_buttons_offset_top" => 14,
											"all_buttons_offset_top_and_bottom" => 14,
											"title_bar_offset_top" => 13,
											"main_scrubber_offset_top" => 47,
											"space_between_main_scrubber_and_time" => 10,
											"start_time_space" => 10,
											"scrubbers_offset_width" => 2,
											"scrubbers_offset_total_width" => 0,
											"volume_button_and_scrubber_offset_top" => 47,
											"space_between_volume_button_and_scrubber" => 6,
											"volume_scrubber_offset_width" => 4,
											"scrubber_offset_bottom" => 10,
											"equalizer_offset_left" => 1,
											
											// playlists window settings
											"show_playlists_button_and_playlists" => "yes",
											"usePlaylistsSelectBox" => "yes",
											"mainSelectorBackgroundSelectedColor" => "#000000",
											"mainSelectorTextNormalColor" => "#000000",
											"mainSelectorTextSelectedColor" => "#FFFFFF",
											"mainButtonTextNormalColor" => "#6a6a6a",
											"mainButtonTextSelectedColor" => "#000000",
											"showPlaylistsSelectBoxNumbers" => "yes",
											"show_playlists_by_default" => "no",
											"thumbnail_selected_type" => "opacity",
											"start_at_playlist" => 0,
											"start_at_track" => 0,
											"buttons_margins" => 7,
											"thumbnail_max_width" => 330,
											"thumbnail_max_height" => 330,
											"horizontal_space_between_thumbnails" => 40,
											"vertical_space_between_thumbnails" => 40,
											
											// playlist settings
											"show_playlist_button_and_playlist" => "yes",
											"randomizePlaylist" => "no",
											"showPlayListOnMobile" => "yes",
											"show_playlist_by_default" => "no",
											"show_playlist_item_play_button" => "yes",
											"show_playlist_item_download_button" => "yes",
											"show_playlist_item_buy_button" => "yes",
											"force_disable_download_button_for_podcast" => "yes",
											"force_disable_download_button_for_official_fm" => "yes",
											"force_disable_download_button_for_folder" => "yes",
											"add_scrollbar_mouse_wheel_support" => "yes",
											"track_title_normal_color" => "#6a6a6a",
											"track_title_selected_color" => "#000000",
											"track_duration_color" => "#6a6a6a",
											"playlistSelectorHeight" => 37,
											"playlistItemHeight" => 33,
											"max_playlist_items" => 100,
											"nr_of_visible_playlist_items" => 9,
											"track_title_offset_left" => 0,
											"play_pause_button_offset_left_and_right" => 11,
											"duration_offset_right" => 9,
											"download_button_offset_right" => 11,
											"scrollbar_offset_width" => 7,
											
											//opener settings
											"show_opener" => "yes",
											"show_opener_play_pause_button" => "yes",
											"opener_alignment" => "right",
											"show_oppener_play_pause_button" => "yes",
											"opener_equlizer_offset_left" => 3,
											"opener_equlizer_offset_top" => -1,
											
											// popup settings
											"show_popup_button" => "yes",
											"popup_window_background_color" => "#878787",
											"popup_window_width" => 850,
											"popup_window_height" => 451,

											//a to b loop
											"playbackRateButtonsMargins" => 7,
											"atbTimeBackgroundColor" => "transparent",
											"atbTimeTextColorNormal" => "#919191",
											"atbTimeTextColorSelected" => "#000000",
											"atbButtonTextNormalColor" => "#FFFFFF",
											"atbButtonTextSelectedColor" => "#888888",
											"atbButtonBackgroundNormalColor" => "#000000",
											"atbButtonBackgroundSelectedColor" => "#FFFFFF",

											// visualizer
											"useVisualizer" => "yes",
											"useDumyVisualizeOnIOS" => "yes",
											"visualizerRandomPreset" => "no",
											"visualizerPreset" => "bars1",
											"visualizerColor" => array("#AAAAAA", "#999999", "#888888", "#777777", "#666666"),
											"visualizerCapColor" => "#FFFFFF"
									),
									array(
											// main settings
											"id" => 5,
											"use_youtube" => "no",
											"use_video" => "no",
											"openPopupOnPlay" => "no",
											"start_at_random_track" => "no",
											"soundCloudAPIKey" => "",
											"ytbAPiKey" => "",
											"proxyCors" => "",
											"show_full_screen_button" => "yes",
											"showPlaybackRateButton" => "yes",
											"privatePassword" => "Melinda",
											"showPlaylistsSearchInput" => "yes",
											"showMainBackground" => "yes",
											"addKeyboardSupport" => "yes",
											"defaultPlaybackRate" => 1,
											"playbackRateWindowTextColor" => "#000000",
											"playTrackAfterPlaylistLoad" => "no",
											//password window
											"borderColor" => "#CDCDCD",
											"secondaryLabelsColor" => "#444444",
											"textColor" => "#777777",
											"inputBackgroundColor" => "#c0c0c0",
											"inputColor" => "#333333",
											
											"horizontalPosition" => "center",
											"verticalPosition" => "bottom",
											"use_HEX_colors_for_skin" => "no",
											"normal_HEX_buttons_color" => "#FF0000",
											"useVectorIcons" => "no",
											"name" => "skin_modern_white",
											"skin_path" => "modern_skin_white",
											"show_soundcloud_username_in_title" => "yes",
											"verticalPosition" => "bottom",
											"use_deeplinking" => "yes",
											"right_click_context_menu" => "developer",
											"show_buttons_tooltips" => "yes",
											"animate" => "yes",
											"autoplay" => "no",
											"loop" => "no",
											"shuffle" => "no",
											"max_width" => 900,
											"volume" => .9,
											"tooltips_buttons_hide_delay" => 1.5,
											"toolTipsButtonsBackgroundColor" => "#000000",
											"tooltips_button_font_color" => "#FFFFFF",
											"playTrackOnlyWhenLoggedIn" => "no",
											"googleAnalyticsTrackingCode" => "",
											"playIfLoggedIn" => "no",
											"useContinuousPlayback"	=> "no",
											"loggedInMessage" => "Please login to play the track.",
											"showMainScrubberAndVolumeScrubberToolTipLabel" => "yes",
											"scrubbersToolTipLabelBackgroundColor" => "#000000",
											"scrubbersToolTipLabelFontColor" => "#FFFFFF",
											
											// controller settings
											"show_controller_by_default" => "yes",
											"show_thumbnail" => "yes",
											"disable_scrubber" => "no",
											"show_next_and_prev_buttons" => "yes",
											"show_loop_button" => "yes",
											"show_shuffle_button" => "yes",
											"show_download_mp3_button" => "yes",
											"show_share_button" => "yes",
											"show_buy_button" => "yes",
											"expand_background" => "no",
											"title_color" => "#000000",
											"time_color" => "#6a6a6a",
											
											// controller align and size settings
											"controller_height" => 85,
											"start_space_between_buttons" => 10,
											"space_between_buttons" => 10,
											"separator_offset_out_space" => 4,
											"separator_offset_in_space" => 7,
											"last_buttons_offset_top" => 7,
											"all_buttons_offset_top_and_bottom" => 15,
											"title_bar_offset_top" => 12,
											"main_scrubber_offset_top" => 53,
											"space_between_main_scrubber_and_time" => 6,
											"start_time_space" => 10,
											"scrubbers_offset_width" => 3,
											"scrubbers_offset_total_width" => -6,
											"volume_button_and_scrubber_offset_top" => 46,
											"space_between_volume_button_and_scrubber" => 5,
											"volume_scrubber_offset_width" => 2,
											"scrubber_offset_bottom" => 6,
											"equalizer_offset_left" => 2,
											
											// playlists window settings
											"show_playlists_button_and_playlists" => "yes",
											"usePlaylistsSelectBox" => "yes",
											"mainSelectorBackgroundSelectedColor" => "#000000",
											"mainSelectorTextNormalColor" => "#000000",
											"mainSelectorTextSelectedColor" => "#FFFFFF",
											"mainButtonTextNormalColor" => "#6a6a6a",
											"mainButtonTextSelectedColor" => "#000000",
											"showPlaylistsSelectBoxNumbers" => "yes",
											"show_playlists_by_default" => "no",
											"thumbnail_selected_type" => "opacity",
											"start_at_playlist" => 0,
											"start_at_track" => 0,
											"buttons_margins" => 7,
											"thumbnail_max_width" => 330,
											"thumbnail_max_height" => 330,
											"horizontal_space_between_thumbnails" => 40,
											"vertical_space_between_thumbnails" => 40,
											
											// playlist settings
											"show_playlist_button_and_playlist" => "yes",
											"randomizePlaylist" => "no",
											"showPlayListOnMobile" => "yes",
											"show_playlist_by_default" => "no",
											"show_playlist_item_play_button" => "yes",
											"show_playlist_item_download_button" => "yes",
											"show_playlist_item_buy_button" => "yes",
											"force_disable_download_button_for_podcast" => "yes",
											"force_disable_download_button_for_official_fm" => "yes",
											"force_disable_download_button_for_folder" => "yes",
											"add_scrollbar_mouse_wheel_support" => "yes",
											"track_title_normal_color" => "#6a6a6a",
											"track_title_selected_color" => "#000000",
											"track_duration_color" => "#6a6a6a",
											"playlistSelectorHeight" => 37,
											"playlistItemHeight" => 33,
											"max_playlist_items" => 100,
											"nr_of_visible_playlist_items" => 9,
											"track_title_offset_left" => 0,
											"play_pause_button_offset_left_and_right" => 11,
											"duration_offset_right" => 9,
											"download_button_offset_right" => 11,
											"scrollbar_offset_width" => 7,
											
											//opener settings
											"show_opener" => "yes",
											"show_opener_play_pause_button" => "yes",
											"opener_alignment" => "right",
											"show_oppener_play_pause_button" => "yes",
											"opener_equlizer_offset_left" => 3,
											"opener_equlizer_offset_top" => -1,
											
											// popup settings
											"show_popup_button" => "yes",
											"popup_window_background_color" => "#878787",
											"popup_window_width" => 850,
											"popup_window_height" => 464,

											//a to b loop
											"playbackRateButtonsMargins" => 7,
											"atbTimeBackgroundColor" => "transparent",
											"atbTimeTextColorNormal" => "#000000",
											"atbTimeTextColorSelected" => "#000000",
											"atbButtonTextNormalColor" => "#888888",
											"atbButtonTextSelectedColor" => "#FFFFFF",
											"atbButtonBackgroundNormalColor" => "#FFFFFF",
											"atbButtonBackgroundSelectedColor" => "#000000",

											// visualizer
											"useVisualizer" => "yes",
											"useDumyVisualizeOnIOS" => "yes",
											"visualizerRandomPreset" => "no",
											"visualizerPreset" => "bars1",
											"visualizerColor" => array("#AAAAAA", "#999999", "#888888", "#777777", "#666666"),
											"visualizerCapColor" => "#FFFFFF"
									),
									array(
											// main settings
											"id" => 6,
											"use_youtube" => "no",
											"use_video" => "no",
											"openPopupOnPlay" => "no",
											"start_at_random_track" => "no",
											"soundCloudAPIKey" => "",
											"ytbAPiKey" => "",
											"proxyCors" => "",
											"show_full_screen_button" => "yes",
											"showPlaybackRateButton" => "yes",
											"privatePassword" => "Melinda",
											"showPlaylistsSearchInput" => "yes",
											"showMainBackground" => "yes",
											"addKeyboardSupport" => "yes",
											"defaultPlaybackRate" => 1,
											"playbackRateWindowTextColor" => "#000000",
											"playTrackAfterPlaylistLoad" => "no",
											//password window
											"borderColor" => "#CDCDCD",
											"secondaryLabelsColor" => "#444444",
											"textColor" => "#777777",
											"inputBackgroundColor" => "#c0c0c0",
											"inputColor" => "#333333",
											
											"horizontalPosition" => "center",
											"verticalPosition" => "bottom",
											"use_HEX_colors_for_skin" => "no",
											"normal_HEX_buttons_color" => "#FF0000",
											"useVectorIcons" => "no",
											"name" => "skin_classic_white",
											"skin_path" => "classic_skin_white",
											"show_soundcloud_username_in_title" => "yes",
											"verticalPosition" => "bottom",
											"use_deeplinking" => "yes",
											"right_click_context_menu" => "developer",
											"show_buttons_tooltips" => "yes",
											"animate" => "yes",
											"autoplay" => "no",
											"loop" => "no",
											"shuffle" => "no",
											"max_width" => 850,
											"volume" => .9,
											"tooltips_buttons_hide_delay" => 1.5,
											"toolTipsButtonsBackgroundColor" => "#494949",
											"tooltips_button_font_color" => "#FFFFFF",
											"playTrackOnlyWhenLoggedIn" => "no",
											"googleAnalyticsTrackingCode" => "",
											"playIfLoggedIn" => "no",
											"useContinuousPlayback"	=> "no",
											"loggedInMessage" => "Please login to play the track.",
											"showMainScrubberAndVolumeScrubberToolTipLabel" => "yes",
											"scrubbersToolTipLabelBackgroundColor" => "#494949",
											"scrubbersToolTipLabelFontColor" => "#FFFFFF",
											
											// controller settings
											"show_controller_by_default" => "yes",
											"show_thumbnail" => "yes",
											"disable_scrubber" => "no",
											"show_next_and_prev_buttons" => "yes",
											"show_loop_button" => "yes",
											"show_shuffle_button" => "yes",
											"show_download_mp3_button" => "yes",
											"show_share_button" => "yes",
											"show_buy_button" => "yes",
											"expand_background" => "yes",
											"title_color" => "#FFFFFF",
											"time_color" => "#FFFFFF",
											
											// controller align and size settings
											"controller_height" => 82,
											"start_space_between_buttons" => 10,
											"space_between_buttons" => 12,
											"separator_offset_out_space" => 12,
											"separator_offset_in_space" => 17,
											"last_buttons_offset_top" => 16,
											"all_buttons_offset_top_and_bottom" => 16,
											"title_bar_offset_top" => 14,
											"main_scrubber_offset_top" => 52,
											"space_between_main_scrubber_and_time" => 10,
											"start_time_space" => 10,
											"scrubbers_offset_width" => 2,
											"scrubbers_offset_total_width" => 0,
											"volume_button_and_scrubber_offset_top" => 48,
											"space_between_volume_button_and_scrubber" => 9,
											"volume_scrubber_offset_width" => 6,
											"scrubber_offset_bottom" => 6,
											"equalizer_offset_left" => 1,
											
											// playlists window settings
											"show_playlists_button_and_playlists" => "yes",
											"usePlaylistsSelectBox" => "yes",
											"mainSelectorBackgroundSelectedColor" => "#FFFFFF",
											"mainSelectorTextNormalColor" => "#FFFFFF",
											"mainSelectorTextSelectedColor" => "#000000",
											"mainButtonTextNormalColor" => "#FFFFFF",
											"mainButtonTextSelectedColor" => "#333333",
											"showPlaylistsSelectBoxNumbers" => "yes",
											"show_playlists_by_default" => "no",
											"thumbnail_selected_type" => "opacity",
											"start_at_playlist" => 0,
											"start_at_track" => 0,
											"buttons_margins" => 7,
											"thumbnail_max_width" => 330,
											"thumbnail_max_height" => 330,
											"horizontal_space_between_thumbnails" => 40,
											"vertical_space_between_thumbnails" => 40,
											
											// playlist settings
											"show_playlist_button_and_playlist" => "yes",
											"randomizePlaylist" => "no",
											"showPlayListOnMobile" => "yes",
											"show_playlist_by_default" => "no",
											"show_playlist_item_play_button" => "yes",
											"show_playlist_item_download_button" => "yes",
											"show_playlist_item_buy_button" => "yes",
											"force_disable_download_button_for_podcast" => "yes",
											"force_disable_download_button_for_official_fm" => "yes",
											"force_disable_download_button_for_folder" => "yes",
											"add_scrollbar_mouse_wheel_support" => "yes",
											"track_title_normal_color" => "#FFFFFF",
											"track_title_selected_color" => "#333333",
											"track_duration_color" => "#FFFFFF",
											"playlistSelectorHeight" => 37,
											"playlistItemHeight" => 33,
											"max_playlist_items" => 100,
											"nr_of_visible_playlist_items" => 9,
											"track_title_offset_left" => 0,
											"play_pause_button_offset_left_and_right" => 11,
											"duration_offset_right" => 9,
											"download_button_offset_right" => 11,
											"scrollbar_offset_width" => 7,
											
											//opener settings
											"show_opener" => "yes",
											"show_opener_play_pause_button" => "yes",
											"opener_alignment" => "right",
											"show_oppener_play_pause_button" => "yes",
											"opener_equlizer_offset_left" => 3,
											"opener_equlizer_offset_top" => -1,
											
											// popup settings
											"show_popup_button" => "yes",
											"popup_window_background_color" => "#878787",
											"popup_window_width" => 850,
											"popup_window_height" => 458,

											//a to b loop
											"playbackRateButtonsMargins" => 7,
											"atbTimeBackgroundColor" => "transparent",
											"atbTimeTextColorNormal" => "#888888",
											"atbTimeTextColorSelected" => "#FFFFFF",
											"atbButtonTextNormalColor" => "#888888",
											"atbButtonTextSelectedColor" => "#FFFFFF",
											"atbButtonBackgroundNormalColor" => "#FFFFFF",
											"atbButtonBackgroundSelectedColor" => "#000000",

											// visualizer
											"useVisualizer" => "yes",
											"useDumyVisualizeOnIOS" => "yes",
											"visualizerRandomPreset" => "no",
											"visualizerPreset" => "bars1",
											"visualizerColor" => array("#AAAAAA", "#999999", "#888888", "#777777", "#666666"),
											"visualizerCapColor" => "#FFFFFF"
									),
									array(
											// main settings
											"id" => 7,
											"use_youtube" => "no",
											"use_video" => "no",
											"openPopupOnPlay" => "no",
											"start_at_random_track" => "no",
											"soundCloudAPIKey" => "",
											"ytbAPiKey" => "",
											"proxyCors" => "",
											"show_full_screen_button" => "yes",
											"showPlaybackRateButton" => "yes",
											"privatePassword" => "Melinda",
											"showPlaylistsSearchInput" => "yes",
											"showMainBackground" => "yes",
											"addKeyboardSupport" => "yes",
											"defaultPlaybackRate" => 1,
											"playbackRateWindowTextColor" => "#000000",
											"playTrackAfterPlaylistLoad" => "no",
											//password window
											"borderColor" => "#CDCDCD",
											"secondaryLabelsColor" => "#444444",
											"textColor" => "#777777",
											"inputBackgroundColor" => "#c0c0c0",
											"inputColor" => "#333333",
											
											"horizontalPosition" => "center",
											"verticalPosition" => "bottom",
											"use_HEX_colors_for_skin" => "no",
											"normal_HEX_buttons_color" => "#FF0000",
											"useVectorIcons" => "no",
											"name" => "skin_metal_white",
											"skin_path" => "metal_skin_white",
											"show_soundcloud_username_in_title" => "yes",
											"verticalPosition" => "bottom",
											"use_deeplinking" => "yes",
											"right_click_context_menu" => "developer",
											"show_buttons_tooltips" => "yes",
											"animate" => "yes",
											"autoplay" => "no",
											"loop" => "no",
											"shuffle" => "no",
											"max_width" => 900,
											"volume" => .9,
											"tooltips_buttons_hide_delay" => 1.5,
											"toolTipsButtonsBackgroundColor" => "#000000",
											"tooltips_button_font_color" => "#FFFFFF",
											"playTrackOnlyWhenLoggedIn" => "no",
											"googleAnalyticsTrackingCode" => "",
											"playIfLoggedIn" => "no",
											"useContinuousPlayback"	=> "no",
											"loggedInMessage" => "Please login to play the track.",
											"showMainScrubberAndVolumeScrubberToolTipLabel" => "yes",
											"scrubbersToolTipLabelBackgroundColor" => "#000000",
											"scrubbersToolTipLabelFontColor" => "#FFFFFF",
											
											// controller settings
											"show_controller_by_default" => "yes",
											"show_thumbnail" => "yes",
											"disable_scrubber" => "no",
											"show_next_and_prev_buttons" => "yes",
											"show_loop_button" => "yes",
											"show_shuffle_button" => "yes",
											"show_download_mp3_button" => "yes",
											"show_share_button" => "yes",
											"show_buy_button" => "yes",
											"expand_background" => "no",
											"title_color" => "#000000",
											"time_color" => "#919191",
											
											// controller align and size settings
											"controller_height" => 88,
											"start_space_between_buttons" => 9,
											"space_between_buttons" => 9,
											"separator_offset_out_space" => 4,
											"separator_offset_in_space" => 9,
											"last_buttons_offset_top" => 8,
											"all_buttons_offset_top_and_bottom" => 16,
											"title_bar_offset_top" => 15,
											"main_scrubber_offset_top" => 55,
											"space_between_main_scrubber_and_time" => 6,
											"start_time_space" => 10,
											"scrubbers_offset_width" => 2,
											"scrubbers_offset_total_width" => -6,
											"volume_button_and_scrubber_offset_top" => 48,
											"space_between_volume_button_and_scrubber" => 7,
											"volume_scrubber_offset_width" => 2,
											"scrubber_offset_bottom" => 9,
											"equalizer_offset_left" => 2,
											
											// playlists window settings
											"show_playlists_button_and_playlists" => "yes",
											"usePlaylistsSelectBox" => "yes",
											"mainSelectorBackgroundSelectedColor" => "#333333",
											"mainSelectorTextNormalColor" => "#000000",
											"mainSelectorTextSelectedColor" => "#FFFFFF",
											"mainButtonTextNormalColor" => "#6a6a6a",
											"mainButtonTextSelectedColor" => "#000000",

											"showPlaylistsSelectBoxNumbers" => "yes",
											"show_playlists_by_default" => "no",
											"thumbnail_selected_type" => "opacity",
											"start_at_playlist" => 0,
											"start_at_track" => 0,
											"buttons_margins" => 0,
											"thumbnail_max_width" => 330,
											"thumbnail_max_height" => 330,
											"horizontal_space_between_thumbnails" => 40,
											"vertical_space_between_thumbnails" => 40,
											
											// playlist settings
											"show_playlist_button_and_playlist" => "yes",
											"randomizePlaylist" => "no",
											"showPlayListOnMobile" => "yes",
											"show_playlist_by_default" => "no",
											"show_playlist_item_play_button" => "yes",
											"show_playlist_item_download_button" => "yes",
											"show_playlist_item_buy_button" => "yes",
											"force_disable_download_button_for_podcast" => "yes",
											"force_disable_download_button_for_official_fm" => "yes",
											"force_disable_download_button_for_folder" => "yes",
											"add_scrollbar_mouse_wheel_support" => "yes",
											"track_title_normal_color" => "#6a6a6a",
											"track_title_selected_color" => "#000000",
											"track_duration_color" => "#6a6a6a",
											"playlistSelectorHeight" => 37,
											"playlistItemHeight" => 33,
											"max_playlist_items" => 100,
											"nr_of_visible_playlist_items" => 9,
											"track_title_offset_left" => 0,
											"play_pause_button_offset_left_and_right" => 11,
											"duration_offset_right" => 9,
											"download_button_offset_right" => 11,
											"scrollbar_offset_width" => 7,
											
											//opener settings
											"show_opener" => "yes",
											"show_opener_play_pause_button" => "yes",
											"opener_alignment" => "right",
											"show_oppener_play_pause_button" => "yes",
											"opener_equlizer_offset_left" => 3,
											"opener_equlizer_offset_top" => -1,
											
											// popup settings
											"show_popup_button" => "yes",
											"popup_window_background_color" => "#878787",
											"popup_window_width" => 900,
											"popup_window_height" => 469,

											//a to b loop
											"playbackRateButtonsMargins" => 0,
											"atbTimeBackgroundColor" => "transparent",
											"atbTimeTextColorNormal" => "#919191",
											"atbTimeTextColorSelected" => "#000000",
											"atbButtonTextNormalColor" => "#FFFFFF",
											"atbButtonTextSelectedColor" => "#888888",
											"atbButtonBackgroundNormalColor" => "#000000",
											"atbButtonBackgroundSelectedColor" => "#FFFFFF",

											// visualizer
											"useVisualizer" => "yes",
											"useDumyVisualizeOnIOS" => "yes",
											"visualizerRandomPreset" => "no",
											"visualizerPreset" => "bars1",
											"visualizerColor" => array("#AAAAAA", "#999999", "#888888", "#777777", "#666666"),
											"visualizerCapColor" => "#FFFFFF"
										)
							      );
    }


    public function init_playlist(){
    	$this->main_playlists_ar = array();
    }

    // Get data.
    public function get_data(){
	    $cur_data = get_option("fwdmsp_data");
	       
	    $this->settings_ar = $cur_data->settings_ar;
	    $this->main_playlists_ar = $cur_data->main_playlists_ar;
    }
    
    
    // Set data.
    public function set_data(){
    	update_option("fwdmsp_data", $this);
    }
}

?>