<fieldset class="ui-widget fwdmsp">
	<label for="skins"><?php esc_html_e('Select your preset:', 'fwdmsp'); ?></label>
	
    <select id="skins" class="ui-widget ui-corner-all"></select>
    <label id="preset_id" for="skins"></label>
    
    <p id="tips"><?php esc_html_e('All form fields are required.', 'fwdmsp'); ?></p>
</fieldset>

<form class="form fwdmsp" action="" method="post">
	<div id="tabs">
	  	<ul class="menu">
		    <li><a href="#tab1"><img src=<?php echo esc_url($fwdmspIconsPath) . "tab1-icon.png" ?>><span><?php esc_html_e('Main settings', 'fwdmsp'); ?></span></a></li>
		    <li><a href="#tab2"><img src=<?php echo esc_url($fwdmspIconsPath) . "tab2-icon.png" ?>><span><?php esc_html_e('Controller settings', 'fwdmsp'); ?></span></a></li>
		    <li><a href="#tab3"><img src=<?php echo esc_url($fwdmspIconsPath) . "tab3-icon.png" ?>><span><?php esc_html_e('Controller align and size settings', 'fwdmsp'); ?></span></a></li>
		    <li><a href="#tab4"><img src=<?php echo esc_url($fwdmspIconsPath) . "tab4-icon.png" ?>><span><?php esc_html_e('Playlists window settings', 'fwdmsp'); ?></span></a></li>
		    <li><a href="#tab5"><img src=<?php echo esc_url($fwdmspIconsPath) . "tab5-icon.png" ?>><span><?php esc_html_e('Playlist settings', 'fwdmsp'); ?></span></a></li>
		    <li><a href="#tab6"><img src=<?php echo esc_url($fwdmspIconsPath) . "tab6-icon.png" ?>><span><?php esc_html_e('Opener settings', 'fwdmsp'); ?></span></a></li>
		    <li><a href="#tab7"><img src=<?php echo esc_url($fwdmspIconsPath) . "tab7-icon.png" ?>><span><?php esc_html_e('Popup settings', 'fwdmsp'); ?></span></a></li>
		    <li><a href="#tab8"><img src=<?php echo esc_url($fwdmspIconsPath) . "tab8-icon.png" ?>><span><?php esc_html_e('Search bar settings', 'fwdmsp'); ?></span></a></li>
			<li><a href="#tab9"><img src=<?php echo esc_url($fwdmspIconsPath) . "tab2-icon.png" ?>><span><?php esc_html_e('Password window settings', 'fwdmsp'); ?></span></a></li>
			<li><a href="#tab10"><img src=<?php echo esc_url($fwdmspIconsPath) . "ab-icon.png" ?>><span><?php esc_html_e('A to B loop settings', 'fwdmsp'); ?></span></a></li>
			<li><a href="#tab11"><img src=<?php echo esc_url($fwdmspIconsPath) . "visualizer.png" ?>><span><?php esc_html_e('Visualizer settings', 'fwdmsp'); ?></span></a></li>
	  	</ul>
							
	  	<div id="tab1" class="tab">
			<table>
    			<tr>
		    		<td>
		    			<label for="name"><?php esc_html_e('Preset name:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="name" class="text ui-widget-content ui-corner-all">
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="skin_path"><?php esc_html_e('Skin type:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="skin_path" class="ui-corner-all">
							<option value="minimal_skin_dark">minimal-skin-dark</option>
							<option value="modern_skin_dark">modern-skin-dark</option>
							<option value="classic_skin_dark">classic-skin-dark</option>
							<option value="metal_skin_dark">metal-skin-dark</option>
							<option value="minimal_skin_white">minimal-skin-white</option>
							<option value="modern_skin_white">modern-skin-white</option>
							<option value="classic_skin_white">classic-skin-white</option>
							<option value="metal_skin_white">metal-skin-white</option>
							<option value="hex_dark">hex-dark</option>
							<option value="hex_white">hex-white</option>
						</select>
		    		</td>
		    	</tr>
			
				<tr>
		    		<td>
		    			<label for="showMainBackground"><?php esc_html_e('Show main background color:', 'fwdmsp'); ?></label>
		    		</td>

		    		<td>
		    			<select id="showMainBackground" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('Show or hide the main transparent background.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
				
				<tr>
		    		<td>
		    			<label for="use_HEX_colors_for_skin"><?php esc_html_e('Use HEX / CSS colors:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="use_HEX_colors_for_skin" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This feature allows to add hexadecimal colors to all buttons and some player elements just like it\'s done with CSS and even more, we have done it in a cool way that all graphics will retain the texture and at the same time apply the chosen color. Please note that this feature will work with all skins but we created a custom dark skin and a custom white skin specially for this, I suggest to use this skins, if you are using a dark theme set the \'Skin type:\' option to hex_dark if is the white theme set \'Skin type:\' to hex_white , both skins can be found in the plugin directory wp-plugins/fwdmsp/content.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
				
				<tr>
		    		<td>
		    			<label for="normal_HEX_buttons_color"><?php esc_html_e('First HEX color:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input id="normal_HEX_buttons_color" />
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="useVectorIcons"><?php esc_html_e('Use vector icons', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="useVectorIcons" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('Enable vector icons instead of the png icons.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="use_youtube"><?php esc_html_e('Use Youtube:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="use_youtube" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('Set this to no if you are not usint Youtube video.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="use_video"><?php esc_html_e('Use Video:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="use_video" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('Set this to no if you are not using mp4 videos.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="show_soundcloud_username_in_title"><?php esc_html_e('Show Soundcloud username in title:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="show_soundcloud_username_in_title" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This can set the player to show the Soundcloud username in the track title. The username is added at the beginning of the track title and is separated by \'-\' like this: username - track title.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="verticalPosition"><?php esc_html_e('Vertical alignment:', 'fwdmsp'); ?></label>
		    		</td>

		    		<td>
		    			<select id="verticalPosition" class="ui-corner-all">
							<option value="top"><?php esc_html_e('top', 'fwdmsp'); ?></option>	
							<option value="bottom"><?php esc_html_e('bottom', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
				
				<tr>
		    		<td>
		    			<label for="horizontalPosition"><?php esc_html_e('Horizontal alignment:', 'fwdmsp'); ?></label>
		    		</td>

		    		<td>
		    			<select id="horizontalPosition" class="ui-corner-all">
							<option value="left"><?php esc_html_e('left', 'fwdmsp'); ?></option>	
							<option value="center"><?php esc_html_e('center', 'fwdmsp'); ?></option>
							<option value="right"><?php esc_html_e('right', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="use_deeplinking"><?php esc_html_e('Use deeplinking:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="use_deeplinking" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This allows or not deeplinking. Adds a unique URL to each video.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
			</table>
			 
			<table>
				<tr>
		    		<td>
		    			<label for="right_click_context_menu"><?php esc_html_e('Right-click context menu:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="right_click_context_menu" class="ui-corner-all">
							<option value="developer"><?php esc_html_e('developer', 'fwdmsp'); ?></option>
							<option value="disabled"><?php esc_html_e('disabled', 'fwdmsp'); ?></option>
							<option value="default"><?php esc_html_e('default', 'fwdmsp'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('If \'developer\' the context menu will be the developer link \'made by FWD\'. If \'disabled\' the context menu will be disabled completely. If \'default\' the context menu will be the browser default.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="show_buttons_tooltips"><?php esc_html_e('Show buttons tooltips:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="show_buttons_tooltips" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="animate"><?php esc_html_e('Animate on intro:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="animate" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('If this is set to \'yes\' once the player is loaded and ready the controller will animate with a tween from top to bottom otherwise it will appear without any animation, please note that this option also applies to the playlist.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="autoplay"><?php esc_html_e('Autoplay:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="autoplay" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="loop"><?php esc_html_e('Loop:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="loop" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
				<td>
					<label for="show_full_screen_button"><?php esc_html_e('Show video/youtube full screen button:', 'fwdmsp'); ?></label>
				</td>
				<td>
					<select id="show_full_screen_button" class="ui-corner-all">
						<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
					</select>
				</td>
				<tr>
		    		<td>
		    			<label for="shuffle"><?php esc_html_e('Shuffle:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="shuffle" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="start_at_random_track"><?php esc_html_e('Start at random track:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="start_at_random_track" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>

		    	</tr>
				<tr>
		    		<td>
		    			<label for="googleAnalyticsTrackingCode"><?php esc_html_e('Google analytics tracking code:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="googleAnalyticsTrackingCode" class="text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('If you want to use google analytics set this option to the google analytics tracking code otherwise leave it blank.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="proxyCors"><?php esc_html_e('Proxy CORS server URL:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="proxyCors" class="text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This only applies to Soutcast and Icecast, if you are using a SSL page and your Shoutcast or Icecast streams are non secure add here the CORS server proxy URL, for more info please read documentation.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="soundCloudAPIKey"><?php esc_html_e('Soundcloud API KEY:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="soundCloudAPIKey" class="text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This value represents the API key or keys for SoundCloud, more then one key can be added separated by, if one dose not work the next one will be used and so on.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="ytbAPiKey"><?php esc_html_e('Youtube API KEY:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="ytbAPiKey" class="text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('Youtube API key used to load Youtube playlists, more info in documentation.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
		    </table>
			
			<table>
				<tr>
		    		<td>
		    			<label for="privatePassword"><?php esc_html_e('Global private tracks password:', 'fwdmsp'); ?></label>
		    		</td>

		    		<td>
		    			<input type="text" id="privatePassword" class="text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('The global password for private tracks.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="max_width"><?php esc_html_e('Player maximum width:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="max_width" class="text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This value represents the player maximum width in px units, think of this property as it would be the \'max-width\' CSS property.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="volume"><?php esc_html_e('Volume:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="volume" class="text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This is the volume level of the player. It must be a float value between 0 and 1.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="tooltips_buttons_hide_delay"><?php esc_html_e('Tooltips buttons hide delay:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="tooltips_buttons_hide_delay" class="text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This is a float number that represents the duration in seconds until the tooltip button is showed on mouse hover.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
		    	<tr>
					<td>
						<label for="toolTipsButtonsBackgroundColor"><?php esc_html_e('Tooltips button background color:', 'fwdmsp'); ?></label>
					</td>
					<td>
						<input id="toolTipsButtonsBackgroundColor" />
					</td>
				</tr>
		    	<tr>
		    		<td>
		    			<label for="tooltips_button_font_color"><?php esc_html_e('Tooltips button font color:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input id="tooltips_button_font_color" />
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="defaultPlaybackRate"><?php esc_html_e('Default track playback rate/speed:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="defaultPlaybackRate" class="text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This is a float number from 0.5 to 3 where 1 is the default normal playback rate/speed value.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="playbackRateWindowTextColor"><?php esc_html_e('Tooltips button font color:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input id="playbackRateWindowTextColor" />
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="addKeyboardSupport"><?php esc_html_e('Add keyboard support:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="addKeyboardSupport" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('Set this to yes if you want to add keyboard support (LEFT/RIGHT ARROWS:skip video 5 seconds forward or backward, UP/DOWN ARROWS: volume up or volume down, M:mute/unmute, SPACE:play/pause).', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="useContinuousPlayback"><?php esc_html_e('Use continuous playback:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="useContinuousPlayback" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('Set this to yes if you want the player to continue playing when loaded on a different page.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="playIfLoggedIn"><?php esc_html_e('Play track only when logged in:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="playIfLoggedIn" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="loggedInMessage"><?php esc_html_e('Message to show if user is not logged in:', 'fwdmsp'); ?></label>
		    		</td>

		    		<td>
		    			<input type="text" id="loggedInMessage" class="text ui-widget-content ui-corner-all">
		    		</td>
		    	</tr>
		
			</table>
		</div>
	  
		<div id="tab2" class="tab">
		  	<table>
		    	<tr>
		    		<td>
		    			<label for="show_controller_by_default"><?php esc_html_e('Show controller by default:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="show_controller_by_default" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('If this is set to \'yes\' the controller is showed as soon as the player is loaded and displayed.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="show_thumbnail"><?php esc_html_e('Show thumbnail:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="show_thumbnail" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This option hides or shows globally the current track playlist thumbnail.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="disable_scrubber"><?php esc_html_e('Disable audio scrubber:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="disable_scrubber" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('Set this option to yes if you want to prevent a user to be able to scrubb the audio.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
				
				<tr>
		    		<td>
		    			<label for="show_next_and_prev_buttons"><?php esc_html_e('Show next and prev play track buttons:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="show_next_and_prev_buttons" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
				
				<tr>
		    		<td>
		    			<label for="showPlaybackRateButton"><?php esc_html_e('Show playback rate/speed button:', 'fwdmsp'); ?></label>
		    		</td>

		    		<td>
		    			<select id="showPlaybackRateButton" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="show_loop_button"><?php esc_html_e('Show loop button:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="show_loop_button" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="show_shuffle_button"><?php esc_html_e('Show shuffle button:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="show_shuffle_button" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="openPopupOnPlay"><?php esc_html_e('Open in popup on play:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="openPopupOnPlay" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('If set to yes when the user is clicking on the play button the player will popup.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="show_download_mp3_button"><?php esc_html_e('Show download MP3 button:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="show_download_mp3_button" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="show_share_button"><?php esc_html_e('Show share button:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="show_share_button" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="show_buy_button"><?php esc_html_e('Show buy button:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="show_buy_button" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="showMainScrubberAndVolumeScrubberToolTipLabel"><?php esc_html_e('Show main scrubber and volume scrubber tooltip:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="showMainScrubberAndVolumeScrubberToolTipLabel" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
				</tr>
		    </table>

			<table>
				<tr>
		    		<td>
		    			<label for="scrubbersToolTipLabelBackgroundColor"><?php esc_html_e('Main scrubber and volume scrubber tooltip background color:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input id="scrubbersToolTipLabelBackgroundColor" />
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="scrubbersToolTipLabelFontColor"><?php esc_html_e('Main scrubber and volume scrubber tooltip font color:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input id="scrubbersToolTipLabelFontColor" />
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="expand_background"><?php esc_html_e('Repeat background:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="expand_background" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This option is like the CSS \'background-repeat\' property for the controller background image. If set to \'no\' it will expand the image to fill the controller size.', 'fwdmsp'); ?>">
		    		</td>
				</tr>
				<tr>
		    		<td>
		    			<label for="title_color"><?php esc_html_e('Title color:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input id="title_color" />
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="time_color"><?php esc_html_e('Time color:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input id="time_color" />
		    		</td>
		    	</tr>
			</table>
		</div>
		  
		<div id="tab3" class="tab">
	    	<table>
	    		<tr>
		    		<td>
		    			<label for="controller_height"><?php esc_html_e('Controller height:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="controller_height" class="text ui-widget-content ui-corner-all">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="start_space_between_buttons"><?php esc_html_e('Start space between buttons:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="start_space_between_buttons" class="text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" id="start_space_between_buttons_img" title="">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="space_between_buttons"><?php esc_html_e('Space between buttons:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="space_between_buttons" class="text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" id="space_between_buttons_img" title="">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="separator_offset_out_space"><?php esc_html_e('Separator offset out space:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="separator_offset_out_space" class="text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" id="separator_offset_out_space_img" title="">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="separator_offset_in_space"><?php esc_html_e('Separator offset in space:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="separator_offset_in_space" class="text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" id="separator_offset_in_space_img" title="">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="last_buttons_offset_top"><?php esc_html_e('Last buttons offset top:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="last_buttons_offset_top" class="text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" id="last_buttons_offset_top_img" title="">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="all_buttons_offset_top_and_bottom"><?php esc_html_e('All buttons offset top and bottom:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="all_buttons_offset_top_and_bottom" class="text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" id="all_buttons_offset_top_and_bottom_img" title="">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="title_bar_offset_top"><?php esc_html_e('Title bar offset top:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="title_bar_offset_top" class="text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" id="title_bar_offset_top_img" title="">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="main_scrubber_offset_top"><?php esc_html_e('Main scrubber offset top:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="main_scrubber_offset_top" class="text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" id="main_scrubber_offset_top_img" title="">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="space_between_main_scrubber_and_time"><?php esc_html_e('Space between main scrubber and time:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="space_between_main_scrubber_and_time" class="text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" id="space_between_main_scrubber_and_time_img" title="">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="start_time_space"><?php esc_html_e('Start time space:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="start_time_space" class="text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" id="start_time_space_img" title="">
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="scrubbers_offset_width"><?php esc_html_e('Scrubbers offset width:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="scrubbers_offset_width" class="text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This is a number that represents the total amount in pixels removed from the scrubber bars progress lines when they are at the end.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
			</table>

			<table>	
				<tr>
		    		<td>
		    			<label for="scrubbers_offset_total_width"><?php esc_html_e('Scrubbers offset total width:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="scrubbers_offset_total_width" class="text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This is a number that represents the total amount in pixels added to the entire scrubber bar.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="volume_button_and_scrubber_offset_top"><?php esc_html_e('Volume button and scrubber offset top:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="volume_button_and_scrubber_offset_top" class="text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" id="volume_button_and_scrubber_offset_top_img" title="">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="space_between_volume_button_and_scrubber"><?php esc_html_e('Space between volume button and scrubber:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="space_between_volume_button_and_scrubber" class="text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" id="space_between_volume_button_and_scrubber_img" title="">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="volume_scrubber_offset_width"><?php esc_html_e('Volume scrubber offset width:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="volume_scrubber_offset_width" class="text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This is a number that represents an addition to the volume scrubber total width.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="scrubber_offset_bottom"><?php esc_html_e('Scrubber offset bottom:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="scrubber_offset_bottom" class="text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" id="scrubber_offset_bottom_img" title="">
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="playbackRateButtonsMargins"><?php esc_html_e('Close button offest top and right:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="playbackRateButtonsMargins" class="text ui-widget-content ui-corner-all">
		    		</td>
		    	</tr>
		    </table>
		</div>
	
		<div id="tab4" class="tab">
			<table>
		    	<tr>
		    		<td>
		    			<label for="show_playlists_button_and_playlists"><?php esc_html_e('Show playlists button and playlists:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="show_playlists_button_and_playlists" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="show_playlists_by_default"><?php esc_html_e('Show playlists by default:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="show_playlists_by_default" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('If this is set to \'yes\' the playlists window is showed as soon as the player is loaded and displayed.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="thumbnail_selected_type"><?php esc_html_e('Thumbnail selected type:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="thumbnail_selected_type" class="ui-corner-all">
							<option value="opacity"><?php esc_html_e('opacity', 'fwdmsp'); ?></option>
							<option value="threshold"><?php esc_html_e('threshold', 'fwdmsp'); ?></option>
							<option value="blackAndWhite"><?php esc_html_e('black-and-white', 'fwdmsp'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This represents the playlist thumbnail selected state (please note that this setting is always \'opacity\' when tested locally or on a mobile device).', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
				
				
				<tr>
		    		<td>
		    			<label for="showPlaylistsSearchInput"><?php esc_html_e('Show playlists search box:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="showPlaylistsSearchInput" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
				
				<tr>
		    		<td>
		    			<label for="usePlaylistsSelectBox"><?php esc_html_e('Show playlists combo-box/select:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="usePlaylistsSelectBox" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
				
				<tr>
		    		<td>
		    			<label for="showPlaylistsSelectBoxNumbers"><?php esc_html_e('Show playlists combo-box/select count numbers:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="showPlaylistsSelectBoxNumbers" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
				
		    	<tr>
		    		<td>
		    			<label for="start_at_playlist"><?php esc_html_e('Start at playlist:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="start_at_playlist" class="text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This a number that represents the playlist number that will be loaded when the player loads the first time. If deeplinking is used and the browser URL has a playlist link this option is ignored. The playlists count starts from 0 (zero).', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="start_at_track"><?php esc_html_e('Start at track:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="start_at_track" class="text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This a number that represents the track number that will be loaded when the player loads the first time. If deeplinking is used and the browser URL has a track link this option is ignored. The tracks count starts from 0 (zero).', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="buttons_margins"><?php esc_html_e('Buttons margins:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="buttons_margins" class="text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This is a number that represents the margins offset for the prev, next and close buttons from the playlists window.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="thumbnail_max_width"><?php esc_html_e('Thumbnail maximum width:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="thumbnail_max_width" class="text ui-widget-content ui-corner-all">
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="thumbnail_max_height"><?php esc_html_e('Thumbnail maximum height:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="thumbnail_max_height" class="text ui-widget-content ui-corner-all">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="horizontal_space_between_thumbnails"><?php esc_html_e('Horizontal space between thumbnails:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="horizontal_space_between_thumbnails" class="text ui-widget-content ui-corner-all">
		    		</td>
		    	</tr>
		    </table>

			<table>
				<tr>
		    		<td>
		    			<label for="vertical_space_between_thumbnails"><?php esc_html_e('Vertical space between thumbnails:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="vertical_space_between_thumbnails" class="text ui-widget-content ui-corner-all">
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="playlistSelectorHeight"><?php esc_html_e('Combo-box selector height:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="playlistSelectorHeight" class="text ui-widget-content ui-corner-all">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="mainSelectorBackgroundSelectedColor"><?php esc_html_e('Combo-box selector background color:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input id="mainSelectorBackgroundSelectedColor" />
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="mainSelectorTextNormalColor"><?php esc_html_e('Combo-box selector text normal color:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input id="mainSelectorTextNormalColor" />
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="mainSelectorTextSelectedColor"><?php esc_html_e('Combo-box selector text selected color:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input id="mainSelectorTextSelectedColor" />
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="mainButtonTextNormalColor"><?php esc_html_e('Combo-box button text normal color:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input id="mainButtonTextNormalColor" />
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="mainButtonTextSelectedColor"><?php esc_html_e('Combo-box button text selected color:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input id="mainButtonTextSelectedColor" />
		    		</td>
		    	</tr>
			</table>
		</div>
			
		<div id="tab5" class="tab">
			<table>
		    	<tr>
		    		<td>
		    			<label for="show_playlist_button_and_playlist"><?php esc_html_e('Show playlist button and playlist:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="show_playlist_button_and_playlist" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
						
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="randomizePlaylist"><?php esc_html_e('Randomize playlist:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="randomizePlaylist" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="showPlayListOnMobile"><?php esc_html_e('Show playlist on mobile:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="showPlayListOnMobile" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This option hides or shows the playlist button and playlist on the mobile devices.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr> 	
		    	<tr>
		    		<td>
		    			<label for="show_playlist_by_default"><?php esc_html_e('Show playlist by default:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="show_playlist_by_default" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('If this is set to \'yes\' the playlist is showed as soon as the player is loaded and displayed otherwise the playlist is hidden and it will only appear if the playlist button is clicked or touched.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="playTrackAfterPlaylistLoad"><?php esc_html_e('Play track after the playlsit has loaded:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="playTrackAfterPlaylistLoad" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This option allows to play after the playlist has loaded even if autoplay is set to no.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="show_playlist_item_play_button"><?php esc_html_e('Show playlist item play button:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="show_playlist_item_play_button" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="show_playlist_item_download_button"><?php esc_html_e('Show playlist item download button:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="show_playlist_item_download_button" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This option hides or shows the download button globally for all tracks, it overwrites the individual playlist track settings.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="show_playlist_item_buy_button"><?php esc_html_e('Show playlist item buy button:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="show_playlist_item_buy_button" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This option hides or shows the buy button globally for all tracks, it overwrites the individual playlist track settings.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="force_disable_download_button_for_podcast"><?php esc_html_e('Disable download button for podcast tracks:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="force_disable_download_button_for_podcast" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="force_disable_download_button_for_official_fm"><?php esc_html_e('Disable download button for official.fm tracks:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="force_disable_download_button_for_official_fm" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="force_disable_download_button_for_folder"><?php esc_html_e('Disable download button for folder tracks:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="force_disable_download_button_for_folder" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="add_scrollbar_mouse_wheel_support"><?php esc_html_e('Add scrollbar mouse wheel support:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="add_scrollbar_mouse_wheel_support" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
			</table>
			
			<table>
				<tr>
		    		<td>
		    			<label for="show_tracks_numbers"><?php esc_html_e('Show tracks numbers:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="show_tracks_numbers" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="playlist_background_color"><?php esc_html_e('Playlist background color:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input id="playlist_background_color" />
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="track_title_normal_color"><?php esc_html_e('Track title normal color:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input id="track_title_normal_color" />
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="track_title_selected_color"><?php esc_html_e('Track title selected color:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input id="track_title_selected_color" />
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="track_duration_color"><?php esc_html_e('Track duration color:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input id="track_duration_color" />
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="playlistItemHeight"><?php esc_html_e('Playlist item height:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="playlistItemHeight" class="text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('The playlist item height in px, maximum height is 50.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="max_playlist_items">Maximum playlist items:</label>
		    		</td>
		    		<td>
		    			<input type="text" id="max_playlist_items" class="text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This option is useful if the number of playlist items needs to be limited, for example if a playlist is loaded from Soundcloud and it has 1000 tracks it will be too large to display so the playlist will display only 100 tracks. If you want to load the total available number of tracks without limitation just set this number to a large number like 10000.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="nr_of_visible_playlist_items"><?php esc_html_e('Number of visible playlist items:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="nr_of_visible_playlist_items" class="text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('Limit to the maximum number of playlist visible items, for example if you have 100 playlist items the playlist can be set to show only 20 playlist items and the rest can be scrolled, if the total number of playlist items is greater than this value all playlist items will be showed.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="track_title_offset_left"><?php esc_html_e('Track title offset left:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="track_title_offset_left" class="text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" id="track_title_offset_left_img" title="">
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="play_pause_button_offset_left_and_right"><?php esc_html_e('Play/pause button offset left and right:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="play_pause_button_offset_left_and_right" class="text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" id="play_pause_button_offset_left_and_right_img" title="">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="duration_offset_right"><?php esc_html_e('Duration offset right:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="duration_offset_right" class="text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" id="duration_offset_right_img" title="">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="download_button_offset_right"><?php esc_html_e('Download button offset right:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="download_button_offset_right" class="text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This number represents the total amount in pixels for the offset of the download button to the right.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
		    </table>
			
			<table>
				<tr>
		    		<td>
		    			<label for="scrollbar_offset_width"><?php esc_html_e('Scrollbar offset width:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="scrollbar_offset_width" class="text ui-widget-content ui-corner-all">
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This number represents the total amount in pixels removed from the playlist width at the end, for making room for the scrollbar.', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
			</table>
		</div>
		
		<div id="tab6" class="tab">
			<table>
				<tr>
		    		<td>
		    			<label for="show_opener"><?php esc_html_e('Show opener:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="show_opener" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="opener_alignment"><?php esc_html_e('Opener alignment:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="opener_alignment" class="ui-corner-all">
							<option value="left"><?php esc_html_e('left', 'fwdmsp'); ?></option>
							<option value="right"><?php esc_html_e('right', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="show_opener_play_pause_button"><?php esc_html_e('Show opener play/pause button:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="show_opener_play_pause_button" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="opener_equlizer_offset_left"><?php esc_html_e('Opener equalizer offset left:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="opener_equlizer_offset_left" class="text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This number represents the opener equalizer left offset (left margin).', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="opener_equlizer_offset_top"><?php esc_html_e('Opener equalizer offset top:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="opener_equlizer_offset_top" class="text ui-widget-content ui-corner-all">
		    			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This number represents the opener equalizer top offset (top margin).', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
			</table>
		</div>
		
		<div id="tab7" class="tab">
			<table>
				<tr>
		    		<td>
		    			<label for="show_popup_button"><?php esc_html_e('Show popup button:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="show_popup_button" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="popup_window_background_color"><?php esc_html_e('Popup window background color:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input id="popup_window_background_color" />
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="popup_window_width"><?php esc_html_e('Popup window width:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="popup_window_width" class="text ui-widget-content ui-corner-all">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="popup_window_height"><?php esc_html_e('Popup window height:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="popup_window_height" class="text ui-widget-content ui-corner-all">
		    		</td>
		    	</tr>
			</table>
		</div>
		
		<div id="tab8" class="tab">
			<table>
				<tr>
		    		<td>
		    			<label for="show_search_bar"><?php esc_html_e('Show search bar:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="show_search_bar" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="show_sort_buttons"><?php esc_html_e('Show sort buttons:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="show_sort_buttons" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="search_input_color"><?php esc_html_e('Search input color:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input id="search_input_color" />
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="search_bar_height"><?php esc_html_e('Search bar height:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="search_bar_height" class="text ui-widget-content ui-corner-all">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="input_search_text_offset_top"><?php esc_html_e('Input search text offset top:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="input_search_text_offset_top" class="text ui-widget-content ui-corner-all">
		    		</td>
		    	</tr>
				<tr>
		    		<td>
		    			<label for="input_search_offset_left"><?php esc_html_e('Input search offset left:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<input type="text" id="input_search_offset_left" class="text ui-widget-content ui-corner-all">
		    		</td>
		    	</tr>
			</table>
		</div>

		<div id="tab9" class="tab">
			<table>
				<tr>
					<td>
						<label for="borderColor"><?php esc_html_e('Border color:', 'fwdmsp'); ?></label>
					</td>
					<td>
						<input id="borderColor" />
					</td>
				</tr>
				<tr>
					<td>
						<label for="secondaryLabelsColor"><?php esc_html_e('Label color:', 'fwdmsp'); ?></label>
					</td>
					<td>
						<input id="secondaryLabelsColor" />
					</td>
				</tr>
				<tr>
					<td>
						<label for="textColor"><?php esc_html_e('Text color:', 'fwdmsp'); ?></label>
					</td>
					<td>
						<input id="textColor" />
					</td>
				</tr>
				<tr>
					<td>
						<label for="inputBackgroundColor"><?php esc_html_e('Input background color:', 'fwdmsp'); ?></label>
					</td>
					<td>
						<input id="inputBackgroundColor" />
					</td>
				</tr>
				<tr>
					<td>
						<label for="inputColor"><?php esc_html_e('Input text color:', 'fwdmsp'); ?></label>
					</td>
					<td>
						<input id="inputColor" />
					</td>
				</tr>
			</table>
		</div>

		<div id="tab10" class="tab">
			<table>
				<tr>
					<td>
						<label for="atbTimeTextColorNormal"><?php esc_html_e('Time text normal color:', 'fwdmsp'); ?></label>
					</td>
					<td>
						<input id="atbTimeTextColorNormal" />
					</td>
				</tr>
				<tr>
					<td>
						<label for="atbTimeTextColorSelected"><?php esc_html_e('Time text selected color:', 'fwdmsp'); ?></label>
					</td>
					<td>
						<input id="atbTimeTextColorSelected" />
					</td>
				</tr>
				<tr>
					<td>
						<label for="atbButtonTextNormalColor"><?php esc_html_e('Button text normal color:', 'fwdmsp'); ?></label>
					</td>
					<td>
						<input id="atbButtonTextNormalColor" />
					</td>
				</tr>
				<tr>
					<td>
						<label for="atbButtonTextSelectedColor"><?php esc_html_e('Button text selected color:', 'fwdmsp'); ?></label>
					</td>
					<td>
						<input id="atbButtonTextSelectedColor" />
					</td>
				</tr>
				<tr>
					<td>
						<label for="atbButtonBackgroundNormalColor"><?php esc_html_e('Button background normal color:', 'fwdmsp'); ?></label>
					</td>
					<td>
						<input id="atbButtonBackgroundNormalColor" />
					</td>
				</tr>
				<tr>
					<td>
						<label for="atbButtonBackgroundSelectedColor"><?php esc_html_e('Button background selected color:', 'fwdmsp'); ?></label>
					</td>
					<td>
						<input id="atbButtonBackgroundSelectedColor" />
					</td>
				</tr>
			</table>
		</div>

		<div id="tab11" class="tab">
			<table>
				<tr>
		    		<td>
		    			<label for="useVisualizer"><?php esc_html_e('Use visualizer:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="useVisualizer" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="useDumyVisualizeOnIOS"><?php esc_html_e('Use visualizer on IOS:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="useDumyVisualizeOnIOS" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('On IOS there is a bug that literally prevents the visualizer from starting and also breaks the player the audio does not start, this was fixed in versions 14, 15, and 16 and came back in Version 17, it is a total disaster and there is no way around this but to create a dummy visualizer... please test this option on your iPhone and if it works leave it yes, most likely this will be fixed again in Version 18 or not :)', 'fwdmsp'); ?>">
		    		</td>
		    	</tr>
		    	
		    	<tr>
		    		<td>
		    			<label for="visualizerPreset"><?php esc_html_e('Presets:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="visualizerPreset" class="ui-corner-all">
							<option value="bars1">bars1</option>
							<option value="bars2">bars2</option>
							<option value="wave1">wave1</option>
							<option value="wave2">wave2</option>
						</select>
		    		</td>
		    	</tr>
		    	<tr>
		    		<td>
		    			<label for="visualizerRandomPreset"><?php esc_html_e('Use random preset:', 'fwdmsp'); ?></label>
		    		</td>
		    		<td>
		    			<select id="visualizerRandomPreset" class="ui-corner-all">
							<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
							<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
						</select>
		    		</td>
		    	</tr>
				<tr>
					<td>
						<label for="visColor1"><?php esc_html_e('Visualizer color 1:', 'fwdmsp'); ?></label>
					</td>
					<td>
						<input id="visColor1" />
					</td>
				</tr>
				<tr>
					<td>
						<label for="visColor2"><?php esc_html_e('Visualizer color 2:', 'fwdmsp'); ?></label>
					</td>
					<td>
						<input id="visColor2" />
					</td>
				</tr>
				<tr>
					<td>
						<label for="visColor3"><?php esc_html_e('Visualizer color 3:', 'fwdmsp'); ?></label>
					</td>
					<td>
						<input id="visColor3" />
					</td>
				</tr>
				<tr>
					<td>
						<label for="visColor4"><?php esc_html_e('Visualizer color 4:', 'fwdmsp'); ?></label>
					</td>
					<td>
						<input id="visColor4" />
					</td>
				</tr>
				<tr>
					<td>
						<label for="visColor5"><?php esc_html_e('Visualizer color 5:', 'fwdmsp'); ?></label>
					</td>
					<td>
						<input id="visColor5" />
					</td>
				</tr>

				<tr>
					<td>
						<label for="visualizerCapColor"><?php esc_html_e('Visualizer cap color:', 'fwdmsp'); ?></label>
					</td>
					<td>
						<input id="visualizerCapColor" />
						<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This is the color of the visualizer cap color if the preset is set to bars1.', 'fwdmsp'); ?>">
					</td>
				</tr>
				
			</table>
		</div>
	</div>
	
	<input type="hidden" id="settings_data" name="settings_data" value="">
	
	<input id="add_btn" type="submit" name="submit" value="<?php esc_html_e('Add new preset', 'fwdmsp'); ?>" />
	<input id="update_btn" type="submit" name="submit" value="<?php esc_html_e('Update preset settings', 'fwdmsp'); ?>" />
	<input id="del_btn" type="submit" name="submit" value="<?php esc_html_e('Delete preset', 'fwdmsp'); ?>" />
	
	<?php wp_nonce_field("fwdmsp_general_settings_update", "fwdmsp_general_settings_nonce"); ?>
</form>

<?php if(!(empty($msg))): ?>
<div class='fwd-updated'>
	<p class="fwd-updated-p">
		<?php echo esc_html($msg); ?>
	</p>
</div>
<?php endif; ?>