<!-- Main playlist. -->
<div id="add-main-playlist-dialog" title="<?php esc_html_e('Add new main playlist', 'fwdmsp'); ?>">
<p id="add_mp_tips"><?php esc_html_e('The name field is required.', 'fwdmsp'); ?></p>	
	<fieldset>
    	<label for="mp_name">Name:</label>
    	<input type="text" id="mp_name" class="text ui-widget-content ui-corner-all">
  	</fieldset>
</div>

<div id="edit-main-playlist-dialog" title="<?php esc_html_e('Edit main playlist', 'fwdmsp'); ?>">
	<p id="edit_mp_tips"><?php esc_html_e('The name field is required.', 'fwdmsp'); ?></p>
	
	<fieldset>
    	<label for="mp_name_edit"><?php esc_html_e('Name:', 'fwdmsp'); ?></label>
    	<input type="text" id="mp_name_edit" class="text ui-widget-content ui-corner-all">
  	</fieldset>
</div>

<div id="delete-main-playlist-dialog" title="<?php esc_html_e('Delete main playlist', 'fwdmsp'); ?>">
	<fieldset>
    	<label><?php esc_html_e('Are you sure you want to delete this main playlist?', 'fwdmsp'); ?></label>
  	</fieldset>
</div>

<div id="add-playlist-dialog" title="<?php esc_html_e('Add new playlist', 'fwdmsp'); ?>">
	<p id="add_pl_tips"><?php esc_html_e('The playlist name field is required.', 'fwdmsp'); ?></p>
	
	<fieldset>
    	<label for="pl_name"><?php esc_html_e('Playlist name:', 'fwdmsp'); ?></label>
    	<br>
    	<input type="text" id="pl_name" class="text ui-widget-content ui-corner-all">
		
		<br><br>
		<label for="pl_type"><?php esc_html_e('Playlist type:', 'fwdmsp'); ?></label>
    	<select id="pl_type" class="ui-corner-all">
			<option value="normal">Normal</option>
			<option value="podcast">Podcast</option>
			<option value="soundcloud">Soundcloud</option>
			<option value="folder">Folder</option>
			<option value="youtube">Youtube</option>
			<option value="xml">Xml</option>
			<option value="pls">Pls</option>
		</select>
		
		<br><br>
		<div id="pl_source_div">
			<label for="pl_source"><?php esc_html_e('Playlist source:', 'fwdmsp'); ?></label>
			<br>
			<input type="text" id="pl_source" class="text ui-widget-content ui-corner-all">
			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" id="source_help_img" title="Source help.">
		</div>
		
		<br>
    	<div id="upload_pl_thumb_div">
    		<label for="pl_thumb"><?php esc_html_e('Playlist thumbnail path (enter a URL or upload an image):', 'fwdmsp'); ?></label>

    		<table>
    			<tr>
		    		<td>
		    			<input id="pl_thumb" type="text" class="text ui-widget-content ui-corner-all">
		    		 	<button id="upload_pl_thumb_button"><?php esc_html_e('Add Image', 'fwdmsp'); ?></button>
		    		</td>
		    		<td>
		    			<img src="" id="upload_pl_thumb">
		    		</td>
		    	</tr>
		    </table>
		</div>
		
		<br><br>
		<div id="pl_text_div">
			<label><?php esc_html_e('Playlist text:', 'fwdmsp'); ?></label>
			<?php
				$settings = array("media_buttons" => false, "wpautop" => false, "editor_class" => "fwd_editor_class", "tinymce" => false);
				wp_editor("", "pltext", $settings);
			?>
			<br>
			<strong><?php esc_html_e('Text template:', 'fwdmsp'); ?></strong>
			<br><br>
			&lt;p class="fwdmsp-categories-title"&gt;&lt;span class="fwdmsp-header"&gt;Title: &lt;/span&gt;&lt;span class="fwdmsp-title"&gt;Playlist type&lt;/span&gt;&lt;/p&gt;&lt;p class="fwdmsp-categories-type"&gt;&lt;span class="fwdmsp-header"&gt;Type: &lt;/span&gt;HTML&lt;/p&gt;&lt;p class="fwdmsp-categories-description"&gt;&lt;span class="fwdmsp-header"&gt;Description: &lt;/span&gt; Description details.&lt;/p&gt;
			<br><br>
		</div>
		
  	</fieldset>
</div>

<div id="edit-playlist-dialog" title="<?php esc_html_e('Edit playlist', 'fwdmsp'); ?>">
	<p id="edit_pl_tips"><?php esc_html_e('The playlist name field is required.', 'fwdmsp'); ?></p>
	
	<fieldset>
    	<label for="pl_name_edit"><?php esc_html_e('Playlist name:', 'fwdmsp'); ?></label>
		<br>
    	<input type="text" id="pl_name_edit" class="text ui-widget-content ui-corner-all">
		
		<br><br>
		<label for="pl_type_edit"><?php esc_html_e('Playlist type:', 'fwdmsp'); ?></label>
    	<select id="pl_type_edit" class="ui-corner-all">
			<option value="normal">Normal</option>
			<option value="podcast">Podcast</option>
			<option value="soundcloud">Soundcloud</option>
			<option value="folder">Folder</option>
			<option value="youtube">Youtube</option>
			<option value="xml">Xml</option>
			<option value="pls">Pls</option>
		</select>
		
		<br><br>
		<div id="pl_source_div_edit">
			<label for="pl_source_edit"><?php esc_html_e('Playlist source:', 'fwdmsp'); ?></label>
			<br>
			<input type="text" id="pl_source_edit" class="text ui-widget-content ui-corner-all">
			<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" id="source_help_img_edit" title="<?php esc_html_e('Source help.', 'fwdmsp'); ?>">
		</div>
		
		<br>
    	<div id="upload_pl_thumb_div_edit">
    		<label for="pl_thumb_edit"><?php esc_html_e('Playlist thumbnail path (enter a URL or upload an image):', 'fwdmsp'); ?></label>
    		<table>
    			<tr>
		    		<td >
		    			<input id="pl_thumb_edit" type="text" class="text ui-widget-content ui-corner-all">
		    		 	<button id="upload_pl_thumb_button_edit"><?php esc_html_e('Add Image', 'fwdmsp'); ?></button>
		    		</td>
		    		<td>
		    			<img src="" id="upload_pl_thumb_edit">
		    		</td>
		    	</tr>
		    </table>
		</div>
		
		<br><br>
		<div id="pl_text_div_edit">
			<label><?php esc_html_e('Playlist text:', 'fwdmsp'); ?></label>
			<?php
				$settings = array("media_buttons" => false, "wpautop" => false, "editor_class" => "fwd_editor_class", "tinymce" => false);
				wp_editor("", "pltextedit", $settings);
			?>
			<br>
			<strong><?php esc_html_e('Text template:', 'fwdmsp'); ?></strong>
			<br><br>
			&lt;p class="fwdmsp-categories-title"&gt;&lt;span class="fwdmsp-header"&gt;Title: &lt;/span&gt;&lt;span class="fwdmsp-title"&gt;Playlist type&lt;/span&gt;&lt;/p&gt;&lt;p class="fwdmsp-categories-type"&gt;&lt;span class="fwdmsp-header"&gt;Type: &lt;/span&gt;HTML&lt;/p&gt;&lt;p class="fwdmsp-categories-description"&gt;&lt;span class="fwdmsp-header"&gt;Description: &lt;/span&gt; Description details.&lt;/p&gt;
			<br><br>
		</div>
		
  	</fieldset>
</div>

<div id="delete-playlist-dialog" title="<?php esc_html_e('Delete playlist', 'fwdmsp'); ?>">
	<fieldset>
    	<label><?php esc_html_e('Are you sure you want to delete this playlist?', 'fwdmsp'); ?></label>
  	</fieldset>
</div>


<!-- Tracks. -->
<div id="add-track-dialog" title="Add new track">
	<p id="add_tr_tips"><?php esc_html_e('The track name and path fields are required.', 'fwdmsp'); ?></p>
	
	<fieldset>
		<table>
			<tr>
				<td>
					<label><?php esc_html_e('Track name:', 'fwdmsp'); ?></label>
				</td>
				<td>
					<input type="text" id="tr_name" class="text ui-widget-content ui-corner-all">
				</td>
			</tr>
			<tr>
				<td>
					<label><?php esc_html_e('Type:', 'fwdmsp'); ?></label>
				</td>
				<td>
					<select id="track_type" class="ui-corner-all">
						<option value="multimedia">multimedia</option>
						<option value="shoutcast">shoutcast</option>
						<option value="icecast">icecast</option>
					</select>
					<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('If you are using Shoutcast or Icecast set this to one of the two options and please note that only Shoutcast / Icecast Version 2 or higher are supported. For all other formats set it to multimedia.', 'fwdmsp'); ?>">
				</td>
			</tr>
		</table>
    
    	<div id="upload_audio_div">
    		<label for="tr_audio"><?php esc_html_e('Track path (enter a URL or upload a track using the media uploader):', 'fwdmsp'); ?></label>
    		<table>
    			<tr>
		    		<td>
		    			<input id="tr_audio" type="text" class="text ui-widget-content ui-corner-all">
		    		 	<button id="upload_audio_button"><?php esc_html_e('Add video(mp4) or audio(mp3)', 'fwdmsp'); ?></button>
		    		</td>
		    	</tr>
		    </table>
		</div>
		
    	<div id="upload_thumb_div">
    		<label for="tr_thumb"><?php esc_html_e('Track thumbnail path (enter a URL or upload an image):', 'fwdmsp'); ?></label>
    		<table>
    			<tr>
		    		<td>
		    			<input id="tr_thumb" type="text" class="text ui-widget-content ui-corner-all">
		    		 	<button id="upload_thumb_button"><?php esc_html_e('Add Image', 'fwdmsp'); ?></button>
		    		</td>
		    		<td>
		    			<img src="" id="upload_thumb">
		    		</td>
		    	</tr>
		    </table>
		</div>
		
		<table class="table2">
			<tr>
				<td>
					<label><?php esc_html_e('Is private:', 'fwdmsp'); ?></label>
				</td>
				<td>
					<select id="is_private" class="ui-corner-all">
						<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
						<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
					</select>
					<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('Set this to yes if you want a private track, this way a user will be required to enter a password to view / listen the track.', 'fwdmsp'); ?>">
				</td>
			</tr>

			<tr>
				<td>
					<label><?php esc_html_e('Track password:', 'fwdmsp'); ?></label>
				</td>
				<td>
					<input id="password" type="text" class="text ui-widget-content ui-corner-all">
					<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('A unique password for this video can be set here, if left blank the global password will be used that is set in the general settings under the used preset.', 'fwdmsp'); ?>">
				</td>
			</tr>

			<tr>
				<td>
					<label><?php esc_html_e('Start at time:', 'fwdmsp'); ?></label>
				</td>
				<td>
					<input type="text" id="startAtTime" class="text ui-widget-content ui-corner-all">
					<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This is an optional feature to start playing the track at a specified time. You can leave it empty, otherwise it\'s value must have a \'hours:minutes:seconds\' format (for example 00:02:01).', 'fwdmsp'); ?>">
				</td>
			</tr>

			<tr>
				<td>
					<label><?php esc_html_e('Stop at time:', 'fwdmsp'); ?></label>
				</td>
				<td>
					<input type="text" id="stopAtTime" class="text ui-widget-content ui-corner-all">
					<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This is an optional feature to stop playing the track at a specified time. You can leave it empty, otherwise it\'s value must have a \'hours:minutes:seconds\' format (for example 00:02:01).', 'fwdmsp'); ?>">
				</td>
			</tr>

			<tr>
				<td>
					<label><?php esc_html_e('Buy URL / Javascript function:', 'fwdmsp'); ?></label>
				</td>
				<td>
					<input type="text" id="tr_buy" class="text ui-widget-content ui-corner-all">
				<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This is an optional feature to add a buy button for the track in the playlist which on click can open an URL or can call a javascript function. If you don\'t want a buy button just leave this field empty.', 'fwdmsp'); ?>">
				</td>
			</tr>

			<tr>
				<td>
					<label><?php esc_html_e('Track duration:', 'fwdmsp'); ?></label>
				</td>
				<td>
					<input type="text" id="tr_duration" class="text ui-widget-content ui-corner-all">
					<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This is an optional feature to show the duration of the track in the playlist. You can leave it empty, otherwise its value must have a \'mm:ss\' or \'hours:minutes:seconds\' format (for example 02:30).', 'fwdmsp'); ?>">
				</td>
			</tr>

			<tr>
				<td>
					<label><?php esc_html_e('Downloadable:', 'fwdmsp'); ?></label>
				</td>
				<td>
					<select id="tr_dl" class="ui-corner-all">
						<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
						<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
					</select>
				</td>
			</tr>

			<tr>
				<td>
					<label><?php esc_html_e('Encrypt:', 'fwdmsp'); ?></label>
				</td>
				<td>
					<select id="encrypt" class="ui-corner-all">
						<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
						<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
					</select>
					<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('Set this feature to yes if you wish to encrypt the tracks paths this way it will not be possible to see / steal the tracks location by viewing the page source.', 'fwdmsp'); ?>">
				</td>
			</tr>

			<tr>
				<td>
					<label><?php esc_html_e('Use A to B loop:', 'fwdmsp'); ?></label>
				</td>
				<td>
					<select id="use_a_to_b" class="ui-corner-all">
						<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
						<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
					</select>
				</td>
			</tr>

			<tr>
				<td>
					<label><?php esc_html_e('Play only if logged in:', 'fwdmsp'); ?></label>
				</td>
				<td>
					<select id="play_only_if_logged_in" class="ui-corner-all">
						<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
						<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
					</select>
				</td>
			</tr>
		</table>
			
		<br><br>
		<div id="tr_title_div">
			<label><?php esc_html_e('Track title:', 'fwdmsp'); ?></label>
			<?php
				$settings = array("media_buttons" => false, "wpautop" => false, "editor_class" => "fwd_editor_class", "tinymce" => false);
				wp_editor("", "trtitle", $settings);
			?>
			<br>
			<strong><?php esc_html_e('Text template:', 'fwdmsp'); ?></strong>
			<br><br>
			&lt;p&gt;&lt;span class="fwdmsp-artist"&gt;Title&lt;/span&gt;&lt;span class="fwdmsp-title"&gt; - Description&lt;/span&gt;&lt;/p&gt;
			<br><br>
		</div>
  	</fieldset>
</div>

<div id="edit-track-dialog" title="<?php esc_html_e('Edit track', 'fwdmsp'); ?>">
	<p id="edit_tr_tips"><?php esc_html_e('The track name and path fields are required.', 'fwdmsp'); ?></p>
	
	<fieldset>
		<table>
			<tr>
				<td>
					<label><?php esc_html_e('Track name:', 'fwdmsp'); ?></label>
				</td>
				<td>
					<input type="text" id="tr_name_edit" class="text ui-widget-content ui-corner-all">
				</td>
			</tr>
			<tr>
				<td>
					<label for="track_type_edit"><?php esc_html_e('Type:', 'fwdmsp'); ?></label>
				</td>
				<td>
					<select id="track_type_edit" class="ui-corner-all">
						<option value="multimedia">multimedia</option>
						<option value="shoutcast">shoutcast</option>
						<option value="icecast">icecast</option>
					</select>
					<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('If you are using Shoutcast or Icecast set this to one of the two options and please note that only Shoutcast / Icecast Version 2 or higher are supported. For all other formats set it to multimedia.', 'fwdmsp'); ?>">
				</td>
			</tr>
		</table>
    	
    	<div id="upload_audio_div">
    		<label for="tr_audio_edit"><?php esc_html_e('Track path (enter a URL or upload a track using the media uploader):', 'fwdmsp'); ?></label>

    		<table>
    			<tr>
		    		<td>
		    			<input id="tr_audio_edit" type="text" class="text ui-widget-content ui-corner-all">
		    		 	<button id="upload_audio_button_edit"><?php esc_html_e('Add video(mp4) or audio(mp3)', 'fwdmsp'); ?></button>
		    		</td>
		    	</tr>
		    </table>
		</div>
		
		
    	<div id="upload_thumb_div_edit">
    		<label for="tr_thumb"><?php esc_html_e('Track thumbnail path (enter a URL or upload an image):', 'fwdmsp'); ?></label>
    		<table>
    			<tr>
		    		<td>
		    			<input id="tr_thumb_edit" type="text" class="text ui-widget-content ui-corner-all">
		    		 	<button id="upload_thumb_button_edit"><?php esc_html_e('Add Image', 'fwdmsp'); ?></button>
		    		</td>
		    		<td>
		    			<img src="" id="upload_thumb_edit">
		    		</td>
		    	</tr>
		    </table>
		</div>
		
		<table class="table2">
			<tr>
				<td>
					<label><?php esc_html_e('Is private:', 'fwdmsp'); ?></label>
				</td>
				<td>
					<select id="is_private_edit" class="ui-corner-all">
						<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
						<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
					</select>
					<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('Set this to yes if you want a private track, this way a user will be required to enter a password to view / listen the track.', 'fwdmsp'); ?>">
				</td>
			</tr>
			<tr>
				<td>
					<label><?php esc_html_e('Track password:', 'fwdmsp'); ?></label>
				</td>
				<td>
					<input id="password_edit" type="text"  class="text ui-widget-content ui-corner-all">
					<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('A unique password for this video can be set here, if left blank the global password will be used that is set in the general settings under the used preset.', 'fwdmsp'); ?>">
				</td>
			</tr>
			<tr>
				<td>
					<label><?php esc_html_e('Start at time:', 'fwdmsp'); ?></label>
				</td>
				<td>
					<input type="text" id="startAtTimeEdit" class="text ui-widget-content ui-corner-all">
					<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This is an optional feature to start playing the track at a specified time. You can leave it empty, otherwise it\'s value must have a \'hours:minutes:seconds\' format (for example 00:02:01).', 'fwdmsp'); ?>">
				</td>
			</tr>
			<tr>
				<td>
					<label><?php esc_html_e('Stop at time:', 'fwdmsp'); ?></label>
				</td>
				<td>
					<input type="text" id="stopAtTimeEdit"  class="text ui-widget-content ui-corner-all">
					<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This is an optional feature to stop playing the track at a specified time. You can leave it empty, otherwise it\'s value must have a \'hours:minutes:seconds\' format (for example 00:02:01).', 'fwdmsp'); ?>">
				</td>
			</tr>
			<tr>
				<td>
					<label><?php esc_html_e('Buy URL / Javascript function:', 'fwdmsp'); ?></label>
				</td>
				<td>
					<input type="text" id="tr_buy_edit" class="text ui-widget-content ui-corner-all">
					<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This is an optional feature to add a buy button for the track in the playlist which on click can open an URL or can call a javascript function. If you don\'t want a buy button just leave this field empty.', 'fwdmsp'); ?>">
				</td>
			</tr>
			<tr>
				<td>
					<label><?php esc_html_e('Track duration:', 'fwdmsp'); ?></label>
				</td>
				<td>
					<input type="text" id="tr_duration_edit" class="text ui-widget-content ui-corner-all">
					<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('This is an optional feature to show the duration of the track in the playlist. You can leave it empty, otherwise its value must have a \'mm:ss\' or \'hours:minutes:seconds\' format (for example 02:30).', 'fwdmsp'); ?>">
				</td>
			</tr>
			<tr>
				<td>
					<label><?php esc_html_e('Downloadable:', 'fwdmsp'); ?></label>
				</td>
				<td>
					<select id="tr_dl_edit" class="ui-corner-all">
						<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
						<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
					</select>
				</td>
			</tr>
			<tr>
				<td>
					<label><?php esc_html_e('Encrypt:', 'fwdmsp'); ?></label>
				</td>
				<td>
					<select id="encrypt_edit" class="ui-corner-all">
						<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
						<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
					</select>
					<img class="img-tooltip" src="<?php echo esc_url($tootlTipImgSrc); ?>" title="<?php esc_html_e('Set this feature to yes if you wish to encrypt the tracks paths this way it will not be possible to see / steal the tracks location by viewing the page source.', 'fwdmsp'); ?>">
				</td>
			</tr>
			<tr>
				<td>
					<label><?php esc_html_e('Use A to B loop:', 'fwdmsp'); ?></label>
				</td>
				<td>
					<select id="use_a_to_b_edit" class="ui-corner-all">
						<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
						<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
					</select>
				</td>
			</tr>
			<tr>
				<td>
					<label><?php esc_html_e('Play only if logged in:', 'fwdmsp'); ?></label>
				</td>
				<td>
					<select id="play_only_if_logged_in_edit" class="ui-corner-all">
						<option value="yes"><?php esc_html_e('yes', 'fwdmsp'); ?></option>
						<option value="no"><?php esc_html_e('no', 'fwdmsp'); ?></option>
					</select>
				</td>
			</tr>
		</table>

		
		<br><br>
		<div id="tr_title_div_edit">
			<label><?php esc_html_e('Track title:', 'fwdmsp'); ?></label>
			<?php
				$settings = array("media_buttons" => false, "wpautop" => false, "editor_class" => "fwd_editor_class", "tinymce" => false);
				wp_editor("", "trtitleedit", $settings);
			?>
			<br>
			<strong>Text template:</strong>
			<br><br>
			&lt;p&gt;&lt;span class="fwdmsp-artist"&gt;Title&lt;/span&gt;&lt;span class="fwdmsp-title"&gt; - Description&lt;/span&gt;&lt;/p&gt;
			<br><br>
		</div>
  	</fieldset>
</div>

<div id="delete-track-dialog" title="<?php esc_html_e('Delete track', 'fwdmsp'); ?>">
	<fieldset>
    	<label><?php esc_html_e('Are you sure you want to delete this track?', 'fwdmsp'); ?></label>
  	</fieldset>
</div>

<!-- Form. -->
<form action="" method="post" class="fwdmsp">
	<div class="ui-widget ui-widget-content ui-corner-all holder">
		<h3><?php esc_html_e('All main playlists:', 'fwdmsp'); ?></h3>
	  	
		<div id="main_playlists">
			<?php 
				$playlists_str = "";
				
				if (isset($this->_data->main_playlists_ar)){
					foreach ($this->_data->main_playlists_ar as $main_playlist){
			    		$mid = $main_playlist["id"];
			    		$playlists_str .= "<div id='mp" . esc_html($mid) . "' class='main-playlist'>";
			    		$playlists_str .= "<h3 class='main-playlist-header'>" . esc_html($main_playlist["name"]) . "<span>ID : " . esc_html($mid) . "</span></h3>";			    		
			    		$playlists_str .= "<div>";			    		
			    		$playlists_str .= "<div id='mp" . esc_html($mid) . "_pls' class='pls'>";
			    		
			    		foreach ($main_playlist["playlists"] as $pid => $playlist){
							if ($playlist["type"] == "normal"){
								$playlists_str .= "<div id='mp" . esc_html($mid) . "_pl" . esc_html($pid) . "' class='playlist playlist-count'>";
								$playlists_str .= "<h3 class='playlist-header-sort playlist-header normal'><span class='text'>" . esc_html($playlist["name"]) . "</span></h3>";
								$playlists_str .= "<div>";
								$playlists_str .= "<div id='mp" . esc_html($mid) . "_pl" . esc_html($pid) . "_trs' class='trs'>";
								
								foreach ($playlist["tracks"] as $tid => $track){
									$playlists_str .= "<div id='mp" . esc_html($mid) . "_pl" . esc_html($pid) . "_tr" . esc_html($tid) . "' class='fwd-track'>";
									$playlists_str .= "<h3 class='track-header'>" . esc_html($track["name"]) . "</h3>";
									$playlists_str .= "<img src='" . esc_html($track['thumb']) . "' class='fwd-audio-image-img' id='mp" . esc_html($mid) . "_pl" . esc_html($pid) . "_tr" . esc_html($tid) . "_img'/>";
									$playlists_str .= "<button class='delete_track_btn' id='mp" . esc_html($mid) . "_pl" . esc_html($pid) . "_tr" . esc_html($tid) . "_del_btn'>" . esc_html__('Delete','fwdmsp') . "</button>";
									$playlists_str .= "<button class='edit_track_btn' id='mp" . esc_html($mid) . "_pl" . esc_html($pid) . "_tr" . esc_html($tid) . "_edit_btn'>" . esc_html__('Edit','fwdmsp') . "</button>";
									$playlists_str .= "</div>";
								}
								
								$playlists_str .= "</div>";
								$playlists_str .= "<button class='add_track_btn' id='mp" . esc_html($mid) . "_pl" . esc_html($pid) . "_add_btn'>" . esc_html__('Add new track','fwdmsp') . "</button>";
								$playlists_str .= "<button class='edit_playlist_btn' id='mp" . esc_html($mid) . "_pl" . esc_html($pid) . "_edit_btn'>" . esc_html__('Edit','fwdmsp') . "</button>";
								$playlists_str .= "<button class='delete_playlist_btn' id='mp" . esc_html($mid) . "_pl" . esc_html($pid) . "_del_btn'>" . esc_html__('Delete','fwdmsp') . "</button>";
								$playlists_str .= "</div>";
								$playlists_str .= "</div>";
							}else{
								$playlists_str .= "<div id='mp" . esc_html($mid) . "_pl" . esc_html($pid) . "' class='fwd-playlist playlist-count'>";		    				
								$imgPath = $this->_dir_url . "content/icons/";
								
								switch ($playlist["type"]){
									case "podcast":
										$imgPath .= "podcast-icon.png";
										break;
									case "soundcloud":
										$imgPath .= "soundcloud-icon.png";
										break;
									case "official.fm":
										$imgPath .= "official-fm-icon.png";
										break;
									case "folder":
										$imgPath .= "folder-icon.png";
										break;
									case "youtube":
										$imgPath .= "youtube-icon.png";
										break;
									case "xml":
										$imgPath .= "xml-icon.png";
										break;
									case "pls":
										$imgPath .= "folder-icon.png";
										break;
								}
								
								$img = "<img class='playlist-icon' src='" . esc_html($imgPath) . "'>";								
								$playlists_str .= $img;							
								$playlists_str .= "<h3 class='playlist-header-sort pl-header other'><span class='text'>" . esc_html($playlist["name"]) . "</span></h3>";	
								$playlists_str .= "<button class='delete_playlist_btn2' id='mp" . esc_html($mid) . "_pl" . esc_html($pid) . "_del_btn'>" . esc_html__('Delete','fwdmsp') . "</button>";							
								$playlists_str .= "<button class='edit_playlist_btn2' id='mp" . esc_html($mid) . "_pl" . esc_html($pid) . "_edit_btn'>" . esc_html__('Edit','fwdmsp') . "</button>";													
								$playlists_str .= "</div>";
							}
		    			}
			    		
			    		$playlists_str .= "</div>";			    		
			    		$playlists_str .= "<button class='add_playlist_btn' id='mp" . esc_html($mid) . "_add_btn'>" . esc_html__('Add new playlist','fwdmsp') . "</button>";			    		
			    		$playlists_str .= "<button class='edit_main_playlist_btn' id='mp" . esc_html($mid) . "_edit_btn'>" . esc_html__('Edit','fwdmsp') . "</button>";			    		
			    		$playlists_str .= "<button class='delete_main_playlist_btn' id='mp" . esc_html($mid) . "_del_btn'>" . esc_html__('Delete','fwdmsp') . "</button>";			    		
			    		$playlists_str .= "</div>";			    		
			    		$playlists_str .= "</div>";
			    	}
			    	
			    	// Display and escape playlist.
			    	echo html_entity_decode(esc_html(htmlspecialchars($playlists_str)), ENT_QUOTES);
				}
			?>
		</div>
		
		<em id="mp_em"><?php esc_html_e('No main playlists are available.', 'fwdmsp'); ?></em>
		<button id="add_main_playlist_btn"><?php esc_html_e('Add new main playlist', 'fwdmsp'); ?></button>
  	</div>
  	
  	<input type="hidden" id="playlist_data" name="playlist_data" value="">
	<input id="update_btn" type="submit" name="submit" value="<?php esc_html_e('Update main playlists', 'fwdmsp'); ?>" />
	
	<?php wp_nonce_field("fwdmsp_playlist_manager_update", "fwdmsp_playlist_manager_nonce"); ?>
</form>

<?php if(!(empty($msg))): ?>
<div class='fwd-updated'>
	<p class="fwd-updated-p">
		<?php echo esc_html($msg); ?>
	</p>
</div>
<?php endif; ?>

