<div class="wrap">
<div id="lbg_logo">
			<h2><?php esc_html_e( 'Help', 'audio4-html5' );?></h2>
  </div>
<p><?php esc_html_e( 'This plugin requires at least WordPress 3.0', 'audio4-html5' );?></p>
<ul class="lbg_list-1">
  <li><a href="#videotutorials"><?php esc_html_e( 'Video Tutorials', 'audio4-html5' );?></a></li>
  <li><a href="#manage"><?php esc_html_e( 'Manage Players', 'audio4-html5' );?></a></li>
  <li><a href="#categories"><?php esc_html_e( 'Manage Categories', 'audio4-html5' );?></a></li>
  <li><a href="#settings"><?php esc_html_e( 'Player Settings', 'audio4-html5' );?></a></li>
  <li><a href="#shoutcast"><?php esc_html_e( 'Shoutcast and Iceast Link Structure', 'audio4-html5' );?></a></li>
  <li><a href="#playlist"><?php esc_html_e( 'Playlist', 'audio4-html5' );?></a></li>
  <li><a href="#shortcode"><?php esc_html_e( 'ShortCode', 'audio4-html5' );?></a></li>
  <li><a href="#facebook_share"><?php esc_html_e( 'Facebook Share', 'audio4-html5' );?></a></li>
</ul>
<p>&nbsp;</p>
<p><span class="lbg_subtitle"><a name="videotutorials" id="videotutorials"></a><?php esc_html_e( '1. Video Tutorials', 'audio4-html5' );?></span></p>
<p><?php esc_html_e( 'Step 1: Installation', 'audio4-html5' );?> - <a href="https://www.youtube.com/watch?v=BSaVLTUMxxM" target="_blank">https://www.youtube.com/watch?v=BSaVLTUMxxM</a><br />
<?php esc_html_e( 'Step 2: Create a new player and manage the player settings', 'audio4-html5' );?> - <a href="https://www.youtube.com/watch?v=wzZfXj4eXqw" target="_blank">https://www.youtube.com/watch?v=wzZfXj4eXqw</a><br />
<?php esc_html_e( 'Step 3: Manage the playlist and categories', 'audio4-html5' );?> - <a href="https://www.youtube.com/watch?v=uVM0_2iZ_fk" target="_blank">https://www.youtube.com/watch?v=uVM0_2iZ_fk</a></p>
<p>&nbsp;</p>
<p class="lbg_subtitle"><a name="manage" id="manage"></a><?php esc_html_e( '2. Manage Players', 'audio4-html5' );?></p>
<p class=""><?php esc_html_e( 'From this section you can:', 'audio4-html5' );?><br />
- <?php esc_html_e( 'add a new player', 'audio4-html5' );?> <br />
- <?php esc_html_e( 'select the player you want to edit by clicking &quot;Player Settings&quot;', 'audio4-html5' );?><br />
- <?php esc_html_e( 'add/edit playlist radio streams by clicking &quot;Playlist&quot;', 'audio4-html5' );?><br />
- <?php esc_html_e( 'delete an existing player by clicking &quot;Delete&quot;', 'audio4-html5' );?>
</p>
<p class="">&nbsp;</p>
<p class="lbg_subtitle"><a name="manage" id="manage"></a><?php esc_html_e( '3. Manage Categories', 'audio4-html5' );?></p>
<p class=""><?php esc_html_e( 'From this section you can:', 'audio4-html5' );?><br />
- <?php esc_html_e( 'add a new category', 'audio4-html5' );?> <br />
 - <?php esc_html_e( 'edit an existing category', 'audio4-html5' );?><br />
- <?php esc_html_e( 'delete an existing category', 'audio4-html5' );?>
</p>
<p class="">&nbsp;</p>
<p class="lbg_subtitle"><a name="settings" id="settings"></a><?php esc_html_e( '4. Player Settings', 'audio4-html5' );?></p>
<p><?php esc_html_e( 'From this section you can define the radio player  settings.', 'audio4-html5' );?></p>
<table class="wp-list-table widefat fixed pages" cellspacing="0">
  <tr>
    <td width="20%" align="left" valign="top" class="row-title"></td>
    <td width="80%" align="left" valign="top"></td>
  </tr>
  <tr>
    <td colspan="2" align="left" valign="top" class="lbg_regGray"><span class="regGray"><?php esc_html_e( 'General settings', 'audio4-html5' );?></span></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Skin Name', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'The audio player comes with 2 predefined controllers skins (white and black). By controllers we understand rewind, play, pause, previous, next, volume,   facebook, twitter, show/hide playlist buttons. These buttons are saved as .png images. If you need another color for these controllers, you have the PSD files included and you can save over one skin, the controllers with another color.', 'audio4-html5' );?>
      <p><?php esc_html_e( 'Possible values:', 'audio4-html5' );?><br />
        - <?php esc_html_e( 'whiteControllers', 'audio4-html5' );?><br />
    - <?php esc_html_e( 'blackControllers', 'audio4-html5' );?></p></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Responsive', 'audio4-html5' );?><br /></td>
    <td align="left" valign="top"><?php esc_html_e( 'Possible values:', 'audio4-html5' );?> <br />
      <strong>true</strong> - <?php esc_html_e( 'the player will responsive', 'audio4-html5' );?><br />
      <strong>false</strong> - <?php esc_html_e( 'the player will not be responsive', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Player Width', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'player width', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Auto Play', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Possible values:', 'audio4-html5' );?> <br />
      <strong>true</strong> - <?php esc_html_e( 'autoplays audio file', 'audio4-html5' );?><br />
      <strong>false</strong> - <?php esc_html_e( "doesn't autoplay audio file", "audio4-html5" );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Float', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Possible values:', 'audio4-html5' );?> <br />
      <strong>none</strong> - <?php esc_html_e( 'the audio player has no floating', 'audio4-html5' );?><br />
      <strong>left</strong> - <?php esc_html_e( 'the audio player floats left', 'audio4-html5' );?><br />
      <strong>true</strong> - <?php esc_html_e( 'the audio player floats right', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Default "No Image Available"', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'The path to "No Image Available" image which will appear when there is no image found in database', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Show Volume', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Possible values:', 'audio4-html5' );?> <br />
      <strong>true</strong> - <?php esc_html_e( 'volume buttons will appear', 'audio4-html5' );?><br />
      <strong>false</strong> -<?php esc_html_e( 'volume buttons will not appear', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Initial Volume', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'You can initialize the volume. The range is 0 to 1', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Volume Off State Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Volume slide color (hexa) - off state', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Volume On State Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Volume slide color (hexa) - on state', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Show Title', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Possible values:', 'audio4-html5' );?> <br />
      <strong>true</strong> - <?php esc_html_e( 'current playing song will appear', 'audio4-html5' );?><br />
      <strong>false</strong> - <?php esc_html_e( 'current playing song will appear', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Song Title - Text Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Audio file Title text area color (hexa) which resides next to the image', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Show Radio Station', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Possible values:', 'audio4-html5' );?> <br />
      <strong>true</strong> - <?php esc_html_e( 'radio station  name will appear', 'audio4-html5' );?><br />
      <strong>false</strong> - <?php esc_html_e( 'radio station  name will not appear', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Radio Station - Text Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Audio file Author text area color (hexa) which resides next to the image', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Color for Frame Behind Player', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'The color  (hexa) of the frame behind controllers and round photo', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Image Border Width', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'The width of border for the round photo ', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Image Border Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'The color  (hexa) of the border for the round photo ', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'FaceBook AppID', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'FaceBook AppID. Please check', 'audio4-html5' );?> <a href="#facebook_share"><?php esc_html_e( 'Facebook Share', 'audio4-html5' );?></a> <?php esc_html_e( 'section, for more informations', 'audio4-html5' );?></td>
  </tr>
  <tr>

    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'FaceBook Share Title', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'The title which will appear on FaceBook share. Please check', 'audio4-html5' );?> <a href="#facebook_share"><?php esc_html_e( 'Facebook Share', 'audio4-html5' );?></a> <?php esc_html_e( 'section, for more informations', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'FaceBook Share Description', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'The description which will appear on FaceBook share. Please check <a href="#facebook_share">Facebook Share</a> section, for more informations', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Beneath Title Background Color (when Playlist is Visible)', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'The background color (hexa or "transparent" value) of the area beneath the radio station name and current playing title when the playlist is visible', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Beneath Title Background Opacity (when Playlist is Visible)', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'The background opacity (hexa or "transparent" value) of the area beneath the radio station name and current playing title  when the playlist is visible. Values 0-100.', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Beneath Title Background Color (when Playlist is Hidden)', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'The background color (hexa or "transparent" value) of the area beneath the radio station name and current playing title when the playlist is not visible', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Beneath Title Background Opacity (when Playlist is Hidden)', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'The background opacity (hexa or "transparent" value) of the area beneath the radio station name and current playing title  when the playlist is not visible. Values 0-100.', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Beneath Title Background Border Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'The background bottom border color (hexa or "transparent" value) of the area beneath the radio station name and current playing title.', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Beneath Title Background Border Width', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'The background bottom border width of the area beneath the radio station name and current playing title.', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Refresh Interval for Now-Playing Info', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'The calling interval (in seconds) for the file which reads the current playing song', 'audio4-html5' );?></td>
  </tr>
	<tr>
		<td align="left" valign="top" class="row-title"><?php esc_html_e( 'Player Loading Delay', 'audio4-html5' );?></td>
		<td align="left" valign="top"><?php esc_html_e( 'The timeout delay (in seconds) for player loading', 'audio4-html5' );?></td>
	</tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Grab Artist Photo', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Possible values:', 'audio4-html5' );?> <br />
      <strong>true</strong> - <?php esc_html_e( 'it will grab the artish photo', 'audio4-html5' );?><br />
      <strong>false</strong> - <?php esc_html_e( 'it will always use the image specified by', 'audio4-html5' );?> '<span class="regb"><?php esc_html_e( 'Default "No Image Available"', 'audio4-html5' );?></span>' <?php esc_html_e( 'parameter', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Grab Stream Name and Genre', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Possible values:', 'audio4-html5' );?> <br />
      <strong>true</strong> - <?php esc_html_e( 'it will grab the stream name and stream genre', 'audio4-html5' );?><br />
      <strong>false</strong> - <?php esc_html_e( 'it will always use the stream name and stream genre defined in the playlist', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Translate Radio Station', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'You can translate &quot;Radio Station: &quot; in your own language (if needed)', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Translate Song Title', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'You can translate &quot;Now Playing: &quot;  in your own language (if needed)', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Translate Reading Data', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'You can translate &quot;reading data...&quot; in your own language (if needed)', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Translate All Radio Stations', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'You can translate &quot;ALL RADIO STATIONS&quot;  in your own language (if needed)', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title">&nbsp;</td>
    <td align="left" valign="top">&nbsp;</td>
  </tr>
  <tr>
    <td colspan="2" align="left" valign="top" class="regGray"><?php esc_html_e( 'Controllers Settings: Show/Hide buttons &amp; elements', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Show FaceBook Button', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Possible values:', 'audio4-html5' );?> <br />
      <strong>true</strong> - <?php esc_html_e( 'facebook button will appear', 'audio4-html5' );?><br />
      <strong>false</strong> - <?php esc_html_e( 'facebook button will not appear', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Show Twitter Button', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Possible values:', 'audio4-html5' );?> <br />
      <strong>true</strong> - <?php esc_html_e( 'twitter button will appear', 'audio4-html5' );?><br />
    <strong>false</strong> - <?php esc_html_e( 'twitter button will not appear', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Show Playlist Button', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Possible values:', 'audio4-html5' );?> <br />
      <strong>true</strong> - <?php esc_html_e( 'show/hide playlist button will appear', 'audio4-html5' );?><br />
      <strong>false</strong> - <?php esc_html_e( 'show/hide playlist  button will not appear', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Auto Hide Play Button', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Possible values:', 'audio4-html5' );?> <br />
      <strong>true</strong> - <?php esc_html_e( 'the play/pause button will autohide', 'audio4-html5' );?> <br />
      <strong>false</strong> -<?php esc_html_e( 'the play/pause button will not autohide ', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Show Next/Prev Button', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Possible values:', 'audio4-html5' );?> <br />
      <strong>true</strong> - <?php esc_html_e( 'the next/previous buttons will  appear', 'audio4-html5' );?><br />
      <strong>false</strong> -<?php esc_html_e( 'the next/previous buttons will not appear', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title">&nbsp;</td>
    <td align="left" valign="top">&nbsp;</td>
  </tr>
  <tr>
    <td colspan="2" align="left" valign="top" class="regGray"><?php esc_html_e( 'Playlist  Settings', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Show Playlist', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Possible values:', 'audio4-html5' );?> <br />
      <strong>true</strong> - <?php esc_html_e( 'playlist will appear', 'audio4-html5' );?><br />
    <strong>false</strong> - <?php esc_html_e( 'playlist will not appear', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Show Playlist On Init', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Possible values:', 'audio4-html5' );?> <br />
      <strong>true</strong> - <?php esc_html_e( 'playlist will appear on init', 'audio4-html5' );?><br />
    <strong>false</strong> - <?php esc_html_e( 'playlist will not appear on init', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Playlist Top Position', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Playlist distance from the audio player', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Playlist Over Website Content', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Possible values:', 'audio4-html5' );?> <br />
      <strong>true</strong> - <?php esc_html_e( 'the playlist will appear over the website content', 'audio4-html5' );?><br />
      <strong>false</strong> - <?php esc_html_e( 'the playlist will not appear over the website content', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Playlist Background Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Playlist background color (hexa)', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Playlist Record Background Off Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Playlist item background color (hexa) - OFF state', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Playlist Record Background On Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Playlist item background color (hexa) - ON state', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Playlist Record Bottom Border Off Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Playlist item bottom border color (hexa) - OFF state', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Playlist Record Bottom Border On Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Playlist item bottom border color (hexa) - ON state', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Playlist Record Text Off Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Playlist item text color (hexa) - OFF state', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Playlist Record Text On Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Playlist item text color (hexa) - ON state', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Number Of Items Per Screen', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Number of items shown in the playlist. You will have to scroll to see the rest', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Playlist Padding', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Playlist inner padding', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Show Playlist Number', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Possible values:', 'audio4-html5' );?> <br />
      <strong>true</strong> - <?php esc_html_e( 'the item number in the playlist will appear', 'audio4-html5' );?><br />
    <strong>false</strong> - <?php esc_html_e( 'the item number in the playlist will not appear', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Show Search Area', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Possible values:', 'audio4-html5' );?> <br />
      <strong>true</strong> - <?php esc_html_e( 'the search area will appear', 'audio4-html5' );?><br />
      <strong>false</strong> - <?php esc_html_e( 'the search area  will not appear ', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Search Area Background Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Search area  background color (hexa)', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Search Input Text', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Search input initial text, useful for translation purpose', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Search Input Background Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Search input  background color (hexa)', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Search Input Border Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Search input  border color (hexa)', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Search Input Text Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Search input  text color (hexa)', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title">&nbsp;</td>
    <td align="left" valign="top">&nbsp;</td>
  </tr>
  <tr>
    <td colspan="2" align="left" valign="top" class="regGray"><?php esc_html_e( 'Category  Settings', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Show Categories', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Possible values:', 'audio4-html5' );?> <br />
      <strong>true</strong> - <?php esc_html_e( 'the categories will appear', 'audio4-html5' );?><br />
      <strong>false</strong> - <?php esc_html_e( 'the categories will not appear', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'First Selected Category', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'The name of the first displayed category (in the top of the playlist). If no value is selected, since the categories will be alphabetically ordered,  the first one will be displayed as the first selected category', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Selected Category Background Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Selected category background color (hexa)', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Selected Category Off Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Selected category color (hexa) - OFF state', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Selected Category On Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Selected category color (hexa) - ON state', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Selected Category Bottom Margin ', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Selected category bottom margin', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Category Record Background Off Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Category item background color (hexa) - OFF state', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Category Record Background On Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Category item background color (hexa) - ON state', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Category Record Bottom Border Off Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Category item bottom border color (hexa) - OFF state', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Category Record Bottom Border On Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Category item bottom border color (hexa) - ON state', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Category Record Text Off Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Category item text color (hexa) - OFF state', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Category Record Text On Color', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Category item text color (hexa) - ON state', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title">&nbsp;</td>
    <td align="left" valign="top">&nbsp;</td>
  </tr>
</table>
<p>&nbsp;</p>

<p><span class="lbg_subtitle"><a name="shoutcast" id="shoutcast"></a><?php esc_html_e( '5. Shoutcast and Iceast Link Structure', 'audio4-html5' );?></span></p>
<p><strong>- <u><?php esc_html_e( 'SHOUTCAST LINK', 'audio4-html5' );?></u></strong></p>
<p>http://[domain]:[port] OR</p>
<p>http://[ip]:[port]</p>
<p>Ex: http://83.169.60.45:80</p>
<p><strong><?php esc_html_e( 'IMPORTANT:', 'audio4-html5' );?></strong> <?php esc_html_e( 'For the vast majority of the shoutcast streams, try appending &quot;/;&quot; to the stream so it looks like this:', 'audio4-html5' );?></p>
<p>http://[ip]:[port]/;</p>
<p>Ex: http://83.169.60.45:80/;</p>
<p><strong>- <u><?php esc_html_e( 'ICECAST LINK', 'audio4-html5' );?></u></strong></p>
<p>http://[domain]:[port]/mountpoint</p>
<p>Ex: http://87.230.59.20:80/iloveradio2.mp3</p>
<p>&nbsp;</p>
<p><strong>- <u><?php esc_html_e( 'RADIONOMY LINK', 'audio4-html5' );?></u></strong></p>
<p><?php esc_html_e( 'For radio hosted by radionomy.com, the link looks like this:', 'audio4-html5' );?> http://streaming.radionomy.com/ABC-Piano</p>
<p><?php esc_html_e( 'Due to the fact that the IP is unknown, the player can not access current playing song name and artist photo. It will play it and it will display the radio name.', 'audio4-html5' );?></p>
<p>&nbsp;</p>
<p><strong>NOTE:</strong> <?php esc_html_e( 'Radio Stream should be MP3 type, no support for AAC/AAC+ stream', 'audio4-html5' );?></p>
<p>&nbsp;</p>
<p class="lbg_subtitle"><a name="playlist" id="playlist"></a>6. <?php esc_html_e( 'Playlist', 'audio4-html5' );?></p>
<p><?php esc_html_e( 'From this section you can define radio streams in the playlist', 'audio4-html5' );?></p>
<table class="wp-list-table widefat fixed pages" cellspacing="0">
  <tr>
    <td width="30%" align="left" valign="top" class="row-title"></td>
    <td width="70%" align="left" valign="top"></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Stream', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'radio stream. For more informations regarding stream structure please check', 'audio4-html5' );?> <a href="#shoutcast"><?php esc_html_e( 'Shoutcast and Iceast Link Structure', 'audio4-html5' );?></a> <?php esc_html_e( 'section', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Stream Title', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Radio Stream title. This is an', 'audio4-html5' );?> <strong><?php esc_html_e( 'OPTIONAL', 'audio4-html5' );?></strong> <?php esc_html_e( 'parameter due to the fact that the plugin will automatically obtain the stream title', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title"><?php esc_html_e( 'Category', 'audio4-html5' );?></td>
    <td align="left" valign="top"><?php esc_html_e( 'Radio Stream category. This is an', 'audio4-html5' );?> <strong><?php esc_html_e( 'OPTIONAL', 'audio4-html5' );?></strong> <?php esc_html_e( 'parameter due to the fact that the plugin will automatically obtain the stream categories', 'audio4-html5' );?></td>
  </tr>
  <tr>
    <td align="left" valign="top" class="row-title">&nbsp;</td>
    <td align="left" valign="top">&nbsp;</td>
  </tr>
</table>
<p>&nbsp;</p>
<p><span class="lbg_subtitle"><a name="shortcode" id="shortcode"></a>7. <?php esc_html_e( 'ShortCode', 'audio4-html5' );?></span></p>
<p><?php esc_html_e( 'The shortcode is:', 'audio4-html5' );?> <br />
[lbg_audio4_html5_shoutcast settings_id='1']<br />
<?php esc_html_e( 'where', 'audio4-html5' );?> <br />
 settings_id <?php esc_html_e( 'is the player ID defined in &quot;Manage Players&quot; section', 'audio4-html5' );?></p>
<p>&nbsp;</p>
<p><span class="lbg_subtitle"><a name="facebook_share" id="facebook_share"></a>8. <?php esc_html_e( 'FaceBook Share', 'audio4-html5' );?></span></p>
<p><?php esc_html_e( 'In order for the Facebook share button to work you need to obtain a Facebook Application ID', 'audio4-html5' );?></p>
<p>1.<?php esc_html_e( ' Go to the', 'audio4-html5' );?> <a href="https://developers.facebook.com/apps" target="_blank"><?php esc_html_e( 'Facebook Developers Apps page', 'audio4-html5' );?></a> <?php esc_html_e( 'and sign in with your Facebook username and password.', 'audio4-html5' );?></p>
<p>2. <?php esc_html_e( 'Click the &quot;Add a New App&quot; button.', 'audio4-html5' );?></p>
<p><i><?php esc_html_e( 'If you do not see the option to create a new app in the upper right hand corner, click on &quot;Register as Developer.&quot;', 'audio4-html5' );?></i> </p>
<p>3. <?php esc_html_e( "After that you'll obtain an 'App ID' which you'll edit", "audio4-html5" );?> <span class="regb"><?php esc_html_e( 'Facebook App ID', 'audio4-html5' );?></span> <?php esc_html_e( 'parameter in Manage Players->Player Settings area of our plugin', 'audio4-html5' );?></p>
<p>4. <?php esc_html_e( 'Go to Settings->Basic tab (left area), select "Website" and insert your website URL and fill all the other information. Below you have a demo screenshot. Of course, you will use your own info.', 'audio4-html5' );?></p>
<p><img src="<?php echo plugins_url('images/facebookAppId.jpg', dirname(__FILE__))?>" width="1600" height="1511" alt="facebook appid" /></p>
<p>5. <?php esc_html_e( 'Go to Settings->Advanced tab (left area) and activate "Social Discovery"', 'audio4-html5' );?></p>
<p><img src="<?php echo plugins_url('images/status_and_review.jpg', dirname(__FILE__))?>" width="1600" height="770" alt="status and review" /></p>
<p>6. <?php esc_html_e( 'To personalize more the share content you can use', 'audio4-html5' );?> <span class="regb"><?php esc_html_e( 'Facebook Share Title', 'audio4-html5' );?></span> <?php esc_html_e( 'and', 'audio4-html5' );?> <span class="regb"><?php esc_html_e( 'Facebook Share Description', 'audio4-html5' );?></span> <?php esc_html_e( 'parameters when you initialize the player. Please check', 'audio4-html5' );?> <a href="#settings"><?php esc_html_e( 'Player Settings', 'audio4-html5' );?></a> <?php esc_html_e( 'section, to see all available parameters', 'audio4-html5' );?></p>

<p>&nbsp;</p>
</div>
