<script src="<?php echo plugins_url('../js/lbg_settings_page.js', __FILE__); ?>" type="text/javascript"></script>

<div class="wrap">
	<div id="lbg_logo">
			<h2><?php esc_html_e( 'Player Settings for player', 'audio4-html5' );?>: <span class="lbg_the_redb"><?php esc_html_e($_SESSION['xname'])?> - <?php esc_html_e( 'ID', 'audio4-html5' );?> #<?php esc_html_e($_SESSION['xid'])?></span></h2>
 	</div>

	<div class="lbg_magnifier"><img src="<?php echo plugins_url('images/icons/magnifier.png', dirname(__FILE__))?>" alt="add" align="absmiddle" /> <a href="javascript: void(0);" onclick="showDialogPreview(<?php echo strip_tags($_SESSION['xid'])?>)"><?php esc_html_e( 'Preview Player', 'audio4-html5' );?></a></div>

	<div id="previewDialog"><iframe id="previewDialogIframe" src="" width="100%" height="600" class="lbg_b0"></iframe></div>

  <form method="POST" enctype="multipart/form-data" id="form-player-settings">
	<script>
	jQuery(function() {
		var icons = {
			header: "ui-icon-circle-arrow-e",
			headerSelected: "ui-icon-circle-arrow-s"
		};
		jQuery( "#accordion" ).accordion({
			icons: icons,
			autoHeight: false
		});
	});
	</script>


<div id="accordion">
  <h3><a href="#">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<?php esc_html_e( 'General Settings', 'audio4-html5' );?></a></h3>
  <div class="lbg_pd30">
	  <table class="wp-list-table widefat fixed pages" cellspacing="0">

		  <tr>
		    <td align="right" valign="top" class="row-title" width="35%"><?php esc_html_e( 'Player Name', 'audio4-html5' );?></td>
		    <td align="left" valign="top" width="65%"><input name="name" type="text" size="40" id="name" value="<?php echo esc_attr($_SESSION['xname']);?>"/></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Skin Name', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><select name="skin" id="skin">
		      <option value="whiteControllers" <?php echo (($_POST['skin']=='whiteControllers')?'selected="selected"':'')?>>whiteControllers</option>
		      <option value="blackControllers" <?php echo (($_POST['skin']=='blackControllers')?'selected="selected"':'')?>>blackControllers</option>
            </select></td>
	      </tr>

		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Player Width', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="playerWidth" type="text" size="25" id="playerWidth" value="<?php echo esc_attr($_POST['playerWidth']);?>"/></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Responsive', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><select name="responsive" id="responsive">
		      <option value="true" <?php echo (($_POST['responsive']=='true')?'selected="selected"':'')?>>true</option>
		      <option value="false" <?php echo (($_POST['responsive']=='false')?'selected="selected"':'')?>>false</option>
		      </select></td>
	      </tr>
		<tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Auto Play', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><select name="autoPlay" id="autoPlay">
              <option value="true" <?php echo (($_POST['autoPlay']=='true')?'selected="selected"':'')?>>true</option>
              <option value="false" <?php echo (($_POST['autoPlay']=='false')?'selected="selected"':'')?>>false</option>
            </select></td>
	    </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Default "No Image Available"', 'audio4-html5' );?></td>
		    <td align="left" valign="top"><input name="noImageAvailable" type="text" id="noImageAvailable" size="80" value="<?php echo esc_attr($_POST['noImageAvailable']);?>" /> <input name="upload_noImageAvailable_button" type="button" id="upload_noImageAvailable_button" value="Change Image" />
		      <br />
		      Enter an URL or upload an image<br />
              <div id="noImageAvailable_preview_div" class="lbg_left_p0"> <img src="<?php echo esc_attr($_POST['noImageAvailable']);?>" alt="" name="noImageAvailable_preview" id="noImageAvailable_preview" /> </div></td>
	      </tr>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Grab Artist Photo', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><select name="grabLastFmPhoto" id="grabLastFmPhoto">
              <option value="true" <?php echo (($_POST['grabLastFmPhoto']=='true')?'selected="selected"':'')?>>true</option>
              <option value="false" <?php echo (($_POST['grabLastFmPhoto']=='false')?'selected="selected"':'')?>>false</option>
            </select></td>
	      </tr>
          <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Grab Stream Name and Genre', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><select name="grabStreamnameAndGenre" id="grabStreamnameAndGenre">
              <option value="true" <?php echo (($_POST['grabStreamnameAndGenre']=='true')?'selected="selected"':'')?>>true</option>
              <option value="false" <?php echo (($_POST['grabStreamnameAndGenre']=='false')?'selected="selected"':'')?>>false</option>
            </select></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Show Volume', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><select name="showVolume" id="showVolume">
              <option value="true" <?php echo (($_POST['showVolume']=='true')?'selected="selected"':'')?>>true</option>
              <option value="false" <?php echo (($_POST['showVolume']=='false')?'selected="selected"':'')?>>false</option>
            </select></td>
	   </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Initial Volume Value', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><script>
	jQuery(function() {
		jQuery( "#initialVolume-slider-range-min" ).slider({
			range: "min",
			value: <?php echo esc_js($_POST['initialVolume']);?>,
			min: 0,
			max: 1.01,
			step: 0.1,
			slide: function( event, ui ) {
				jQuery( "#initialVolume" ).val(ui.value );
			}
		});
		jQuery( "#initialVolume" ).val( jQuery( "#initialVolume-slider-range-min" ).slider( "value" ) );
	});
	        </script>
                <div id="initialVolume-slider-range-min" class="inlinefloatleft lbg_w200"></div>
		      <div class="inlinefloatleft lbg_pdleft20">
		        <input name="initialVolume" type="text" size="10" id="initialVolume" class="lbg_bor_black"/>
	          </div></td>
	    </tr>

		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Volume Off State Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="volumeOffColor" type="text" size="25" id="volumeOffColor" value="<?php echo esc_attr($_POST['volumeOffColor']);?>" style="background-color:#<?php echo esc_attr($_POST['volumeOffColor']);?>" />
            <script>
jQuery('#volumeOffColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Volume On State Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="volumeOnColor" type="text" size="25" id="volumeOnColor" value="<?php echo esc_attr($_POST['volumeOnColor']);?>" style="background-color:#<?php echo esc_attr($_POST['volumeOnColor']);?>" />
            <script>
jQuery('#volumeOnColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>

		 <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Show Title', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><select name="showTitle" id="showTitle">
              <option value="true" <?php echo (($_POST['showTitle']=='true')?'selected="selected"':'')?>>true</option>
              <option value="false" <?php echo (($_POST['showTitle']=='false')?'selected="selected"':'')?>>false</option>
            </select></td>
	   </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Song Title - Text Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="songTitleColor" type="text" size="25" id="songTitleColor" value="<?php echo esc_attr($_POST['songTitleColor']);?>" style="background-color:#<?php echo esc_attr($_POST['songTitleColor']);?>" />
            <script>
jQuery('#songTitleColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>
		 <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Show Radio Station', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><select name="showRadioStation" id="showRadioStation">
              <option value="true" <?php echo (($_POST['showRadioStation']=='true')?'selected="selected"':'')?>>true</option>
              <option value="false" <?php echo (($_POST['showRadioStation']=='false')?'selected="selected"':'')?>>false</option>
            </select></td>
	   </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Radio Station - Text Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="radioStationColor" type="text" size="25" id="radioStationColor" value="<?php echo esc_attr($_POST['radioStationColor']);?>" style="background-color:#<?php echo esc_attr($_POST['radioStationColor']);?>" />
            <script>
jQuery('#radioStationColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>
<tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Color for Frame Behind Player', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="frameBehindPlayerColor" type="text" size="25" id="frameBehindPlayerColor" value="<?php echo esc_attr($_POST['frameBehindPlayerColor']);?>" style="background-color:#<?php echo esc_attr($_POST['frameBehindPlayerColor']);?>" />
            <script>
jQuery('#frameBehindPlayerColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Image Border Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="imageBorderColor" type="text" size="25" id="imageBorderColor" value="<?php echo esc_attr($_POST['imageBorderColor']);?>" style="background-color:#<?php echo esc_attr($_POST['imageBorderColor']);?>" />
            <script>
jQuery('#imageBorderColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Image Border Width', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="imageBorderWidth" type="text" size="15" id="imageBorderWidth" value="<?php echo esc_attr($_POST['imageBorderWidth']);?>"/></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Beneath Title Background Color (when Playlist is Visible)', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="beneathTitleBackgroundColor_VisiblePlaylist" type="text" size="25" id="beneathTitleBackgroundColor_VisiblePlaylist" value="<?php echo esc_attr($_POST['beneathTitleBackgroundColor_VisiblePlaylist']);?>" style="background-color:#<?php echo esc_attr($_POST['beneathTitleBackgroundColor_VisiblePlaylist']);?>" />
            <script>
jQuery('#beneathTitleBackgroundColor_VisiblePlaylist').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Beneath Title Background Opacity (when Playlist is Visible)', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><script>
	jQuery(function() {
		jQuery( "#beneathTitleBackgroundOpacity_VisiblePlaylist-slider-range-min" ).slider({
			range: "min",
			value: <?php echo esc_js($_POST['beneathTitleBackgroundOpacity_VisiblePlaylist']);?>,
			min: 0,
			max: 100,
			slide: function( event, ui ) {
				jQuery( "#beneathTitleBackgroundOpacity_VisiblePlaylist" ).val(ui.value );
			}
		});
		jQuery( "#beneathTitleBackgroundOpacity_VisiblePlaylist" ).val( jQuery( "#beneathTitleBackgroundOpacity_VisiblePlaylist-slider-range-min" ).slider( "value" ) );
	});
	        </script>
                <div id="beneathTitleBackgroundOpacity_VisiblePlaylist-slider-range-min" class="inlinefloatleft lbg_w200"></div>
		      <div class="inlinefloatleft lbg_pdleft20">%
		        <input name="beneathTitleBackgroundOpacity_VisiblePlaylist" type="text" size="10" id="beneathTitleBackgroundOpacity_VisiblePlaylist" class="lbg_bor_black"/>
	          </div></td>
	    </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Beneath Title Background Color (when Playlist is Hidden)', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="beneathTitleBackgroundColor_HiddenPlaylist" type="text" size="25" id="beneathTitleBackgroundColor_HiddenPlaylist" value="<?php echo esc_attr($_POST['beneathTitleBackgroundColor_HiddenPlaylist']);?>" style="background-color:#<?php echo esc_attr($_POST['beneathTitleBackgroundColor_HiddenPlaylist']);?>" />
            <script>
jQuery('#beneathTitleBackgroundColor_HiddenPlaylist').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Beneath Title Background Opacity (when Playlist is Hidden)', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><script>
	jQuery(function() {
		jQuery( "#beneathTitleBackgroundOpacity_HiddenPlaylist-slider-range-min" ).slider({
			range: "min",
			value: <?php echo esc_js($_POST['beneathTitleBackgroundOpacity_HiddenPlaylist']);?>,
			min: 0,
			max: 100,
			slide: function( event, ui ) {
				jQuery( "#beneathTitleBackgroundOpacity_HiddenPlaylist" ).val(ui.value );
			}
		});
		jQuery( "#beneathTitleBackgroundOpacity_HiddenPlaylist" ).val( jQuery( "#beneathTitleBackgroundOpacity_HiddenPlaylist-slider-range-min" ).slider( "value" ) );
	});
	        </script>
                <div id="beneathTitleBackgroundOpacity_HiddenPlaylist-slider-range-min" class="inlinefloatleft lbg_w200"></div>
		      <div class="inlinefloatleft lbg_pdleft20">%
		        <input name="beneathTitleBackgroundOpacity_HiddenPlaylist" type="text" size="10" id="beneathTitleBackgroundOpacity_HiddenPlaylist" class="lbg_bor_black"/>
	          </div></td>
	    </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Beneath Title Background Border Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="beneathTitleBackgroundBorderColor" type="text" size="25" id="beneathTitleBackgroundBorderColor" value="<?php echo esc_attr($_POST['beneathTitleBackgroundBorderColor']);?>" style="background-color:#<?php echo esc_attr($_POST['beneathTitleBackgroundBorderColor']);?>" />
            <script>
jQuery('#beneathTitleBackgroundBorderColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Beneath Title Background Border Width', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="beneathTitleBackgroundBorderWidth" type="text" size="15" id="beneathTitleBackgroundBorderWidth" value="<?php echo esc_attr($_POST['beneathTitleBackgroundBorderWidth']);?>"/></td>
	      </tr>
           <tr>
             <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Translate Radio Station', 'audio4-html5' );?></td>
             <td align="left" valign="middle"><input name="translateRadioStation" type="text" size="45" id="translateRadioStation" value="<?php echo esc_attr($_POST['translateRadioStation']);?>"/></td>
           </tr>
           <tr>
             <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Translate Song Title', 'audio4-html5' );?></td>
             <td align="left" valign="middle"><input name="translateSongTitle" type="text" size="45" id="translateSongTitle" value="<?php echo esc_attr($_POST['translateSongTitle']);?>"/></td>
           </tr>
           <tr>
             <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Translate Reading Data', 'audio4-html5' );?></td>
             <td align="left" valign="middle"><input name="translateReadingData" type="text" size="45" id="translateReadingData" value="<?php echo esc_attr($_POST['translateReadingData']);?>"/></td>
           </tr>
           <tr>
             <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Translate All Radio Stations', 'audio4-html5' );?></td>
             <td align="left" valign="middle"><input name="translateAllRadioStations" type="text" size="45" id="translateAllRadioStations" value="<?php echo esc_attr($_POST['translateAllRadioStations']);?>"/></td>
           </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Refresh Interval for Now-Playing Info', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="nowPlayingInterval" type="text" size="25" id="nowPlayingInterval" value="<?php echo esc_attr($_POST['nowPlayingInterval']);?>"/></td>
	      </tr>
				<tr>
						<td align="right" valign="top" class="row-title"><?php esc_html_e( 'Player Loading Delay', 'audio4-html5' );?></td>
						<td align="left" valign="middle"><input name="delay" type="text" size="25" id="delay" value="<?php echo esc_attr($_POST['delay']);?>"/> <?php esc_html_e( 'seconds', 'audio4-html5' );?></td>
				</tr>
      <tr>
                <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Auto Hide Play Button', 'audio4-html5' );?></td>
                <td align="left" valign="middle"><select name="autoHidePlayButton" id="autoHidePlayButton">
                  <option value="true" <?php echo (($_POST['autoHidePlayButton']=='true')?'selected="selected"':'')?>>true</option>
                  <option value="false" <?php echo (($_POST['autoHidePlayButton']=='false')?'selected="selected"':'')?>>false</option>
                </select></td>
           </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Show Next/Prev Button', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><select name="showNextPrevBut" id="showNextPrevBut">
              <option value="true" <?php echo (($_POST['showNextPrevBut']=='true')?'selected="selected"':'')?>>true</option>
              <option value="false" <?php echo (($_POST['showNextPrevBut']=='false')?'selected="selected"':'')?>>false</option>
            </select></td>
	   </tr>
		 <tr>
		   <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Show Twitter Button', 'audio4-html5' );?></td>
		   <td align="left" valign="middle"><select name="showTwitterBut" id="showTwitterBut">
		     <option value="true" <?php echo (($_POST['showTwitterBut']=='true')?'selected="selected"':'')?>>true</option>
		     <option value="false" <?php echo (($_POST['showTwitterBut']=='false')?'selected="selected"':'')?>>false</option>
		     </select></td>
	      </tr>


		 <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Show FaceBook Button', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><select name="showFacebookBut" id="showFacebookBut">
              <option value="true" <?php echo (($_POST['showFacebookBut']=='true')?'selected="selected"':'')?>>true</option>
              <option value="false" <?php echo (($_POST['showFacebookBut']=='false')?'selected="selected"':'')?>>false</option>
            </select></td>
	   </tr>
		 <tr>
		   <td align="right" valign="top" class="row-title"><?php esc_html_e( 'FaceBook AppID', 'audio4-html5' );?></td>
		   <td align="left" valign="middle"><input name="facebookAppID" type="text" size="25" id="facebookAppID" value="<?php echo esc_attr($_POST['facebookAppID']);?>"/></td>
	      </tr>
		 <tr>
		   <td align="right" valign="top" class="row-title"><?php esc_html_e( 'FaceBook Share Title', 'audio4-html5' );?></td>
		   <td align="left" valign="middle"><input name="facebookShareTitle" type="text" size="45" id="facebookShareTitle" value="<?php echo esc_attr($_POST['facebookShareTitle']);?>"/></td>
	      </tr>
		 <tr>
		   <td align="right" valign="top" class="row-title"><?php esc_html_e( 'FaceBook Share Description', 'audio4-html5' );?></td>
		   <td align="left" valign="middle"><textarea name="facebookShareDescription" id="facebookShareDescription" cols="45" rows="5"><?php echo esc_attr($_POST['facebookShareDescription']);?></textarea></td>
	     </tr>
		 <tr>
		   <td align="right" valign="top" class="row-title">&nbsp;</td>
		   <td align="left" valign="middle">&nbsp;</td>
	      </tr>

      </table>
  </div>
  <h3><a href="#">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<?php esc_html_e( 'Playlist & Categories Settings', 'audio4-html5' );?></a></h3>
  <div class="lbg_pd30">
	  <table class="wp-list-table widefat fixed pages" cellspacing="0">
		 <tr>
		    <td align="right" valign="top" class="row-title" width="30%">Show Playlist On Init', 'audio4-html5' );?></td>
		    <td align="left" valign="middle" width="70%"><select name="showPlaylistOnInit" id="showPlaylistOnInit">
              <option value="true" <?php echo (($_POST['showPlaylistOnInit']=='true')?'selected="selected"':'')?>>true</option>
              <option value="false" <?php echo (($_POST['showPlaylistOnInit']=='false')?'selected="selected"':'')?>>false</option>
            </select></td>
	   </tr>
		 <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Show Playlist Button', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><select name="showPlaylistBut" id="showPlaylistBut">
              <option value="true" <?php echo (($_POST['showPlaylistBut']=='true')?'selected="selected"':'')?>>true</option>
              <option value="false" <?php echo (($_POST['showPlaylistBut']=='false')?'selected="selected"':'')?>>false</option>
            </select></td>
	   </tr>
		<tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Show Playlist', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><select name="showPlaylist" id="showPlaylist">
              <option value="true" <?php echo (($_POST['showPlaylist']=='true')?'selected="selected"':'')?>>true</option>
              <option value="false" <?php echo (($_POST['showPlaylist']=='false')?'selected="selected"':'')?>>false</option>
            </select></td>
	   </tr>

		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Playlist Top Position', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="playlistTopPos" type="text" size="25" id="playlistTopPos" value="<?php echo esc_attr($_POST['playlistTopPos']);?>"/></td>
	      </tr>
          <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Playlist Background Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="playlistBgColor" type="text" size="25" id="playlistBgColor" value="<?php echo esc_attr($_POST['playlistBgColor']);?>" style="background-color:#<?php echo esc_attr($_POST['playlistBgColor']);?>" />
            <script>
jQuery('#playlistBgColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Playlist Record Background Off Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="playlistRecordBgOffColor" type="text" size="25" id="playlistRecordBgOffColor" value="<?php echo esc_attr($_POST['playlistRecordBgOffColor']);?>" style="background-color:#<?php echo esc_attr($_POST['playlistRecordBgOffColor']);?>" />
            <script>
jQuery('#playlistRecordBgOffColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Playlist Record Background On Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="playlistRecordBgOnColor" type="text" size="25" id="playlistRecordBgOnColor" value="<?php echo esc_attr($_POST['playlistRecordBgOnColor']);?>" style="background-color:#<?php echo esc_attr($_POST['playlistRecordBgOnColor']);?>" />
            <script>
jQuery('#playlistRecordBgOnColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Playlist Record Bottom Border Off Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="playlistRecordBottomBorderOffColor" type="text" size="25" id="playlistRecordBottomBorderOffColor" value="<?php echo esc_attr($_POST['playlistRecordBottomBorderOffColor']);?>" style="background-color:#<?php echo esc_attr($_POST['playlistRecordBottomBorderOffColor']);?>" />
            <script>
jQuery('#playlistRecordBottomBorderOffColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Playlist Record Bottom Border On Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="playlistRecordBottomBorderOnColor" type="text" size="25" id="playlistRecordBottomBorderOnColor" value="<?php echo esc_attr($_POST['playlistRecordBottomBorderOnColor']);?>" style="background-color:#<?php echo esc_attr($_POST['playlistRecordBottomBorderOnColor']);?>" />
            <script>
jQuery('#playlistRecordBottomBorderOnColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Playlist Record Text Off Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="playlistRecordTextOffColor" type="text" size="25" id="playlistRecordTextOffColor" value="<?php echo esc_attr($_POST['playlistRecordTextOffColor']);?>" style="background-color:#<?php echo esc_attr($_POST['playlistRecordTextOffColor']);?>" />
            <script>
jQuery('#playlistRecordTextOffColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Playlist Record Text On Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="playlistRecordTextOnColor" type="text" size="25" id="playlistRecordTextOnColor" value="<?php echo esc_attr($_POST['playlistRecordTextOnColor']);?>" style="background-color:#<?php echo esc_attr($_POST['playlistRecordTextOnColor']);?>" />
            <script>
jQuery('#playlistRecordTextOnColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script>            </td>
	      </tr>

		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Number Of Items Per Screen', 'audio4-html5' );?></td>
		    <td align="left" valign="top"><input name="numberOfThumbsPerScreen" type="text" size="25" id="numberOfThumbsPerScreen" value="<?php echo stripslashes($_POST['numberOfThumbsPerScreen']);?>"/></td>
	    </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Playlist Padding', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="playlistPadding" type="text" size="25" id="playlistPadding" value="<?php echo esc_attr($_POST['playlistPadding']);?>"/></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Show Playlist Number', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><select name="showPlaylistNumber" id="showPlaylistNumber">
		      <option value="true" <?php echo (($_POST['showPlaylistNumber']=='true')?'selected="selected"':'')?>>true</option>
		      <option value="false" <?php echo (($_POST['showPlaylistNumber']=='false')?'selected="selected"':'')?>>false</option>
		      </select></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title">&nbsp;</td>
		    <td align="left" valign="middle">&nbsp;</td>
	      </tr>
		  <tr>
		    <td colspan="2" align="center" valign="top" class="lbg_regGray"><?php esc_html_e( '- The Categories -', 'audio4-html5' );?></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Show Categories', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><select name="showCategories" id="showCategories">
		      <option value="true" <?php echo (($_POST['showCategories']=='true')?'selected="selected"':'')?>>true</option>
		      <option value="false" <?php echo (($_POST['showCategories']=='false')?'selected="selected"':'')?>>false</option>
		      </select></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Category Record Background Off Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="categoryRecordBgOffColor" type="text" size="25" id="categoryRecordBgOffColor" value="<?php echo esc_attr($_POST['categoryRecordBgOffColor']);?>" style="background-color:#<?php echo esc_attr($_POST['categoryRecordBgOffColor']);?>" />
		      <script>
jQuery('#categoryRecordBgOffColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Category Record Background On Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="categoryRecordBgOnColor" type="text" size="25" id="categoryRecordBgOnColor" value="<?php echo esc_attr($_POST['categoryRecordBgOnColor']);?>" style="background-color:#<?php echo esc_attr($_POST['categoryRecordBgOnColor']);?>" />
		      <script>
jQuery('#categoryRecordBgOnColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Category Record Bottom Border Off Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="categoryRecordBottomBorderOffColor" type="text" size="25" id="categoryRecordBottomBorderOffColor" value="<?php echo esc_attr($_POST['categoryRecordBottomBorderOffColor']);?>" style="background-color:#<?php echo esc_attr($_POST['categoryRecordBottomBorderOffColor']);?>" />
		      <script>
jQuery('#categoryRecordBottomBorderOffColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Category Record Bottom Border On Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="categoryRecordBottomBorderOnColor" type="text" size="25" id="categoryRecordBottomBorderOnColor" value="<?php echo esc_attr($_POST['categoryRecordBottomBorderOnColor']);?>" style="background-color:#<?php echo esc_attr($_POST['categoryRecordBottomBorderOnColor']);?>" />
		      <script>
jQuery('#categoryRecordBottomBorderOnColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Category Record Text Off Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="categoryRecordTextOffColor" type="text" size="25" id="categoryRecordTextOffColor" value="<?php echo esc_attr($_POST['categoryRecordTextOffColor']);?>" style="background-color:#<?php echo esc_attr($_POST['categoryRecordTextOffColor']);?>" />
		      <script>
jQuery('#categoryRecordTextOffColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Category Record Text On Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="categoryRecordTextOnColor" type="text" size="25" id="categoryRecordTextOnColor" value="<?php echo esc_attr($_POST['categoryRecordTextOnColor']);?>" style="background-color:#<?php echo esc_attr($_POST['categoryRecordTextOnColor']);?>" />
		      <script>
jQuery('#categoryRecordTextOnColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title">&nbsp;</td>
		    <td align="left" valign="middle">&nbsp;</td>
	      </tr>
		  <tr>
		    <td colspan="2" align="center" valign="top" class="lbg_regGray"><?php esc_html_e( '- Selected Category -', 'audio4-html5' );?></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title">&nbsp;</td>
		    <td align="left" valign="middle">&nbsp;</td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'First Selected Category', 'audio4-html5' );?><br />
		      <span class="small_text"><?php esc_html_e( 'Write the exact name of the category you want to be set as first.', 'audio4-html5' );?>
		     <?php esc_html_e( ' If no value is selected, since the categories will be alphabetically ordered, the first one will be displayed as the first selected category', 'audio4-html5' );?></span></td>
		    <td align="left" valign="middle"><input name="firstCateg" type="text" size="25" id="firstCateg" value="<?php echo esc_attr($_POST['firstCateg']);?>"/></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Selected Category Background Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="selectedCategBg" type="text" size="25" id="selectedCategBg" value="<?php echo esc_attr($_POST['selectedCategBg']);?>" style="background-color:#<?php echo esc_attr($_POST['selectedCategBg']);?>" />
		      <script>
jQuery('#selectedCategBg').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Selected Category Off Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="selectedCategOffColor" type="text" size="25" id="selectedCategOffColor" value="<?php echo esc_attr($_POST['selectedCategOffColor']);?>" style="background-color:#<?php echo esc_attr($_POST['selectedCategOffColor']);?>" />
		      <script>
jQuery('#selectedCategOffColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Selected Category On Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="selectedCategOnColor" type="text" size="25" id="selectedCategOnColor" value="<?php echo esc_attr($_POST['selectedCategOnColor']);?>" style="background-color:#<?php echo esc_attr($_POST['selectedCategOnColor']);?>" />
		      <script>
jQuery('#selectedCategOnColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Selected Category Bottom Margin ', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="selectedCategMarginBottom" type="text" size="25" id="selectedCategMarginBottom" value="<?php echo esc_attr($_POST['selectedCategMarginBottom']);?>"/></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title">&nbsp;</td>
		    <td align="left" valign="middle">&nbsp;</td>
	      </tr>
		  <tr>
		    <td colspan="2" align="center" valign="top" class="lbg_regGray"><?php esc_html_e( '- Search Area -', 'audio4-html5' );?></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Show Search Area', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><select name="showSearchArea" id="showSearchArea">
		      <option value="true" <?php echo (($_POST['showSearchArea']=='true')?'selected="selected"':'')?>>true</option>
		      <option value="false" <?php echo (($_POST['showSearchArea']=='false')?'selected="selected"':'')?>>false</option>
	        </select></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Search Area Background Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="searchAreaBg" type="text" size="25" id="searchAreaBg" value="<?php echo esc_attr($_POST['searchAreaBg']);?>" style="background-color:#<?php echo esc_attr($_POST['searchAreaBg']);?>" />
	        <script>
jQuery('#searchAreaBg').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Search Input Text', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="searchInputText" type="text" size="50" id="searchInputText" value="<?php echo esc_attr($_POST['searchInputText']);?>"/></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Search Input Background Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="searchInputBg" type="text" size="25" id="searchInputBg" value="<?php echo esc_attr($_POST['searchInputBg']);?>" style="background-color:#<?php echo esc_attr($_POST['searchInputBg']);?>" />
		      <script>
jQuery('#searchInputBg').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Search Input Border Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="searchInputBorderColor" type="text" size="25" id="searchInputBorderColor" value="<?php echo esc_attr($_POST['searchInputBorderColor']);?>" style="background-color:#<?php echo esc_attr($_POST['searchInputBorderColor']);?>" />
		      <script>
jQuery('#searchInputBorderColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title"><?php esc_html_e( 'Search Input Text Color', 'audio4-html5' );?></td>
		    <td align="left" valign="middle"><input name="searchInputTextColor" type="text" size="25" id="searchInputTextColor" value="<?php echo esc_attr($_POST['searchInputTextColor']);?>" style="background-color:#<?php echo esc_attr($_POST['searchInputTextColor']);?>" />
		      <script>
jQuery('#searchInputTextColor').ColorPicker({
	onSubmit: function(hsb, hex, rgb, el) {
		jQuery(el).val(hex);
		jQuery(el).css("background-color",'#'+hex);
		jQuery(el).ColorPickerHide();
	},
	onBeforeShow: function () {
		jQuery(this).ColorPickerSetColor(this.value);
	}
})
.on('keyup', function(){
	jQuery(this).ColorPickerSetColor(this.value);
});
              </script></td>
	      </tr>
		  <tr>
		    <td align="right" valign="top" class="row-title">&nbsp;</td>
		    <td align="left" valign="middle">&nbsp;</td>
	      </tr>

      </table>
  </div>



</div>

<div class="lbg_cent_p"><input name="Submit" type="submit" id="Submit" class="button-primary" value="Update Player Settings"></div>

</form>
</div>
