<?php
/**
 * Compatibility related functionality for WooCommerce between major versions (like 2.x and 3.x).
 */

/**
 * Remove product gallery zoom as we do not support it currently.
 */
function mobilestore_remove_wc_product_gallery_zoom() {
	remove_theme_support( 'wc-product-gallery-zoom' );
	remove_theme_support( 'wc-product-gallery-lightbox' );
	remove_theme_support( 'wc-product-gallery-slider' );
}
add_action( 'after_setup_theme', 'mobilestore_remove_wc_product_gallery_zoom', 100 );

/**
 * Compatibility function to handle getting product gallery attachment IDs in both
 * WooCommerce 2.x and 3.x.
 *
 * @param WC_Product $product WC Product object.
 *
 * @return array
 */
function mobilestore_get_gallery_attachment_ids( $product ) {
	if ( method_exists( $product, 'get_gallery_image_ids' ) ) {
		$attachment_ids = $product->get_gallery_image_ids();
	} else {
		$attachment_ids = $product->get_gallery_attachment_ids();
	}

	return $attachment_ids;
}
