<!-- Back Button for Web-App Mode -->
<div class="wptouch-icon-arrow-left back-button tappable"><!-- css-button --></div>

	<?php if ( wptouch_has_menu( 'site_menu' ) ) { ?>
		<div id="menu" class="wptouch-menu show-hide-menu">
			<?php wptouch_show_menu( 'site_menu' ); ?>
			<?php if (  wptouch_fdn_show_login() ) { ?>
				<ul class="menu-tree login-link">
					<li>
					<?php if ( !is_user_logged_in() ) { ?>
					<a class="login-toggle tappable" href="<?php echo wp_login_url( esc_url_raw( $_SERVER['REQUEST_URI'] ) ); ?>">
						<i class="wptouch-icon-key"></i> Login
					</a>
				<?php } else { ?>
					<a href="<?php echo wp_logout_url( esc_url_raw( $_SERVER['REQUEST_URI'] ) ); ?>" class="tappable" title="<?php _e( 'Logout', 'wptouch-pro' ); ?>">
						<i class="wptouch-icon-user"></i>
						<?php _e( 'Logout', 'wptouch-pro' ); ?>
					</a>
				<?php } ?>
					</li>
				</ul>
			<?php } ?>
		</div>
	<?php } ?>

	<div class="page-wrapper" style="background-image: url(<?php simple_get_background_image(); ?>);"><!-- .page-wrapper tag closed in foundation's footer.php -->

	<?php do_action( 'wptouch_advertising_top' ); ?>

	<div class="menu-bumper">
		<?php if ( wptouch_has_menu( 'site_menu' ) ) { ?>
			<a href="#" class="toggle-button slide-toggle" data-effect-target="menu">
				<?php __( 'Toggle Menu', 'wptouch-pro' ); ?>
			</a>
		<?php } ?>

		<?php if ( function_exists( 'wptouch_fdn_show_login' ) ) { ?>
			<?php if ( wptouch_fdn_show_login() ) { ?>
				<?php if ( !is_user_logged_in() ) { ?>
					<a href="<?php echo wp_login_url( esc_url_raw( $_SERVER['REQUEST_URI'] ) ); ?>" class="login-button login-toggle" title="<?php _e( 'Login', 'wptouch-pro' ); ?>"></a>
				<?php } else { ?>
					<a href="<?php echo wp_logout_url( esc_url_raw( $_SERVER['REQUEST_URI'] ) ); ?>" class="login-button logout" title="<?php _e( 'Logout', 'wptouch-pro' ); ?>"></a>
				<?php } ?>
			<?php } ?>
		<?php } ?>
	</div>


	<div id="header-area">
		<a href="<?php wptouch_bloginfo( 'url' ); ?>">
			<?php if ( foundation_has_logo_image() ) { ?>
				<img src="<?php foundation_the_logo_image(); ?>" alt="logo image" />
			<?php } else { ?>
				<div class="heading-font site-title"><?php wptouch_bloginfo( 'site_title' ); ?></div>
			<?php } ?>
		</a>
	</div>

	<?php if ( is_home() || is_front_page() ) { // On homepage load the slider ?>
		<?php if ( function_exists( 'foundation_featured_slider' ) ) { ?>
			<?php foundation_featured_slider(); ?>
		<?php } ?>
	<?php } ?>
