<?php
if ( function_exists( 'amp_init' ) == false ) {
	require_once( 'wp-amp/amp.php' );
	add_action( 'wptouch_activated_addon_amp', 'amp_activate' );
	add_action( 'wptouch_deactivated_addon_amp', 'amp_deactivate' );
}

define( 'FOUNDATION_PAGE_AMP', __( 'Accelerated Mobile Pages', 'wptouch-pro' ) );

add_filter( 'amp_is_enabled', 'wptouch_amp_can_enable' );

add_filter( 'wptouch_addon_advertising_enable_ad_settings', 'wptouch_amp_maybe_show_multi_ad', 10, 2 );

add_action( 'wptouch_admin_page_render_wptouch-admin-theme-settings', 'foundation_amp_settings' );

// This must be in its own action with a -2 priority to get around Nextgen Gallery
add_action( 'init', 'amp_disable_nextgen_gallery', -2 );

add_action( 'pre_amp_render_post', 'wptouch_amp_init' );
function wptouch_amp_init() {
	// Ensure consistent content width
	add_filter( 'amp_content_max_width', 'wptouch_amp_change_content_width', 99 );

	// Ensure valid placeholder icon URL
	add_filter( 'amp_post_template_data', 'wptouch_amp_set_custom_placeholder_image' );

	// Replace wp-amp stylesheet with our version
	add_filter( 'amp_post_template_file', 'wptouch_amp_set_custom_style', 99, 3 );

	// Load Google Analytics if possible
	add_filter( 'amp_post_template_analytics', 'wptouch_amp_add_analytics' );

	// Customize post meta display based on customizer settings
	add_action( 'amp_post_template_meta_parts', 'wptouch_amp_template_meta_parts' );

	// Ensure Google Fonts are loaded correctly based on customizer settings
	remove_action( 'foundation_module_init_mobile', 'foundation_google_fonts_init' );
	add_action( 'amp_post_template_head', 'wptouch_amp_google_fonts_init' );

	// Output Google Ads if Basic Ads has a Google client/slot configured
	add_filter( 'wptouch_advertising_google-amp', 'wptouch_amp_output_google_ad' );

	// Enable AMP ad in Multi-Ads (disable others)
	add_filter( 'wptouch_addon_advertising_should_show_ad', 'wptouch_amp_maybe_show_multi_ad', 10, 2 );

	// Override jQuery enhanced (prevent possible problems)
	add_filter( 'wptouch_addon_jquery_e_enabled', '__return_false' );

	add_filter( 'amp_post_template_metadata', 'wptouch_amp_maybe_prevent_metadata', 10, 2 );

	// Prevent Infinity Cache (purely precautionary)
	add_filter( 'wptouch_addon_cache_current_page', '__return_false' );

	// Override Basic Ads advertising display (only permit Google ads for now)
	add_filter( 'wptouch_advertising_filter_ad_type', 'wptouch_amp_restrict_ads' );
	add_filter( 'foundation_ad_maybe_include_wrapper', '__return_false' );

	add_action( 'amp_post_template_footer', 'wptouch_amp_powered_by' );

	add_filter( 'amp_text_direction', 'wptouch_amp_output_text_direction' );

	// Remove share links
	remove_filter( 'the_content', 'foundation_handle_share_links_top', 100 );
	remove_filter( 'the_content', 'foundation_handle_share_links_bottom', 100 );
}

// Disable Nextgen Gallery resource manager in AMP
function amp_disable_nextgen_gallery() {
	// Prevent Nextgen Gallery from forcing JavaScript into the footer.
	define( 'NGG_DISABLE_RESOURCE_MANAGER', true );
}

// Ensure a consistent max-width, regardless of preview method
function wptouch_amp_change_content_width( $content_max_width ) {
	return 1040;
}

// Ensure valid placeholder icon URL
function wptouch_amp_set_custom_placeholder_image( $data ) {
	$data['placeholder_image_url'] = wptouch_get_multsite_aware_content_url( 'extensions/amp/wp-amp/assets/images/placeholder-icon.png' );

	return $data;
}

// Load our stylesheet to allow colours, etc. to be rendered
function wptouch_amp_set_custom_style( $file, $template_type, $post ) {
	if ( $template_type == 'style' ) {
		$file = wptouch_get_multsite_aware_install_path( 'extensions/amp/amp_style.php' );
	}

	return $file;
}

// Add Google Analytics if configured in WPtouch Pro admin via site ID
function wptouch_amp_add_analytics( $analytics ) {
	if ( empty( $analytics ) || ! is_array( $analytics ) ) {
		$analytics = array();
	}
	$settings = wptouch_get_settings();
	if ( ! empty( $settings->analytics_google_id ) ) {
		// Add the amp-analytics extension.
		add_action( 'amp_post_template_head', 'wptouch_amp_add_analytics_extention' );
		if ( 'simple' === strtolower( $settings->analytics_embed_method ) ) {
			// See https://developers.google.com/analytics/devguides/collection/amp-analytics/.
			global $post;
			$analytics['googleanalytics'] = array(
				'type'        => 'googleanalytics',
				'attributes'  => array(),
				'config_data' => array(
					'vars'     => array(
						'account' => $settings->analytics_google_id,
					),
					'triggers' => array(
						'trackPageview' => array(
							'on'      => 'visible',
							'request' => 'pageview',
							'vars'    => array(
								'title'            => esc_html( $post->post_title ),
								'documentLocation' => esc_url_raw( get_the_permalink( $post->ID ) ),
							),
						),
					),
				),
			);
		}
	}

	return $analytics;
}

/**
 * Add the necessary AMP analytics extension if outputting analytics.
 *
 * @see https://www.ampproject.org/docs/reference/components/amp-analytics.
 */
function wptouch_amp_add_analytics_extention() {
	?>
	<script async custom-element="amp-analytics" src="https://cdn.ampproject.org/v0/amp-analytics-0.1.js"></script>
	<?php
}

// Remove taxonomy info
function wptouch_amp_template_meta_parts( $template_meta_parts ) {
	$settings = wptouch_get_settings();

	if ( ! apply_filters( 'wptouch_amp_show_author', true ) ) {
		if ( ( $key = array_search( 'meta-author', $template_meta_parts ) ) !== false ) {
			unset( $template_meta_parts[ $key ] );
		}
	}

	if ( ! apply_filters( 'wptouch_amp_show_date', true ) ) {
		if ( ( $key = array_search( 'meta-time', $template_meta_parts ) ) !== false ) {
			unset( $template_meta_parts[ $key ] );
		}
	}

	if ( ! apply_filters( 'wptouch_amp_show_taxonomy', false ) ) {
		if ( ( $key = array_search( 'meta-taxonomy', $template_meta_parts ) ) !== false ) {
			unset( $template_meta_parts[ $key ] );
		}
	}

	return $template_meta_parts;
}

// Handle application of font selections (both built-in Google Fonts module and Google Fonts from Advanced Type)
global $inline_style_data;

function wptouch_amp_google_fonts_init() {
	global $google_fonts_enabled, $inline_style_data;
	$fonts = apply_filters( 'wptouch_amp_get_fonts', array(), true );

	if ( count( $fonts ) > 0 ) {
		$elements = array( 'body' => 'body, form *', 'heading' => 'nav.amp-wp-title-bar, h1, h2, h3, h4, h5, h6' );

		foreach ( $fonts as $selector => $font ) {
			preg_match( '/(.*):(.*)(:.?)(.*)/', $font, $font_info );
			if ( count( $font_info ) == 0 ) {
				preg_match( '/(.*):(.*)/', $font, $font_info );
			}

			$new_families[]    = $font;
			$inline_style_data .= "." . $selector . "-font, " . $elements[ $selector ] . "{\n";
			$inline_style_data .= "\t font-family: '" . $font_info[1] . "';\n";
			$inline_style_data .= "}\n";
		}

		if ( $new_families ) {
			$family = implode( '|', $new_families );
			echo '<link rel="stylesheet" type="text/css" href="https://fonts.googleapis.com/css?family=' . $family . '">';

			if ( $inline_style_data ) {
				add_filter( 'wptouch_amp_inject_css', 'wptouch_amp_add_font_css' );
			}
		}
	}
}

function wptouch_amp_add_font_css( $additional_css ) {
	global $inline_style_data;
	$additional_css .= $inline_style_data;

	return $additional_css;
}

function wptouch_amp_maybe_show_multi_ad( $show_ad, $slot = false ) {
	if ( $slot == 'amp' ) {
		return true;
	} else {
		return false;
	}
}

function wptouch_amp_restrict_ads( $advertising_type ) {
	if ( $advertising_type == 'google' ) {
		$advertising_type = 'google-amp';
	} else {
		$advertising_type = false;
	}

	return $advertising_type;
}

function wptouch_amp_output_google_ad() {
	$settings  = wptouch_get_settings( 'foundation' );
	$client_id = trim( $settings->google_adsense_id );
	$slot_id   = trim( $settings->google_slot_id );
	$width     = 320;
	$height    = 50;

	$ad_code = '<amp-ad width="' . $width . '" height="' . $height . '" type="adsense" data-ad-client="' . $client_id . '" data-ad-slot="' . $slot_id . '"></amp-ad>';

	return $ad_code;
}

function wptouch_amp_powered_by() {
	$settings = wptouch_get_settings();
	if ( $settings->show_wptouch_in_footer ) {
		echo sprintf( __( '<p class="powered-by-msg">Powered by %s%s%s', 'wptouch-pro' ), '
<a href="http://www.wptouch.com/?utm_campaign=wptouch-powered-by&utm_medium=web" target="_blank">', 'WPtouch Mobile Suite for WordPress ', '</a></p>' );
	}
}

function wptouch_amp_can_enable() {
	$site_icon = apply_filters( 'amp_site_icon_url', function_exists( 'get_site_icon_url' ) ? get_site_icon_url( 32 ) : false );

	if ( $site_icon && $site_icon != '' ) {
		return true;
	}

	return false;
}

function foundation_amp_settings( $page_options ) {
	wptouch_add_sub_page( FOUNDATION_PAGE_AMP, 'wptouch-addon-amp', $page_options );


	if ( ! wptouch_amp_can_enable() ) {
		wptouch_add_page_section(
			FOUNDATION_PAGE_AMP,
			__( 'Accelerated Mobile Pages', 'wptouch-pro' ),
			'amp-no-icon',
			array(
				wptouch_add_pro_setting(
					'no-setting-warning',
					'auto_configure',
					sprintf( __( '%sAMP display is currently disabled because you do not have a site icon set.%sSite icons are required by the AMP format.%s%sSet a site icon %sin the WordPress customizer%s to enable AMP display.%s', 'wptouch-pro' ), '<p>', '<br>', '</p>', '<p>', '<a href="' . admin_url( 'customize.php' ) . '">', '</a>', '</p>' ),
					false,
					WPTOUCH_SETTING_BASIC,
					'1.0'
				),
			),
			$page_options,
			ADDON_SETTING_DOMAIN
		);
	} else {
		wptouch_add_page_section(
			FOUNDATION_PAGE_AMP,
			__( 'Accelerated Mobile Pages', 'wptouch-pro' ),
			'amp-settings-in-customizer',
			array(
				wptouch_add_pro_setting(
					'custom',
					'auto_configure',
					false,
					false,
					WPTOUCH_SETTING_BASIC,
					'1.0'
				),
			),
			$page_options,
			ADDON_SETTING_DOMAIN
		);
	}

	return $page_options;
}

function wptouch_amp_ltr() {
	if ( wptouch_should_load_rtl() ) {
		return false;
	}

	return true;
}

function wptouch_amp_output_text_direction() {
	if ( wptouch_amp_ltr() ) {
		echo 'dir="ltr"';
	} else {
		echo 'dir="rtl"';
	}
}

function wptouch_amp_luma_corrected_color( $output_color, $background_color ) {
	$background_luma = wptouch_amp_hex_to_luma( $background_color );

	if ( $background_luma < 150 ) {
		return $output_color;
	} else {
		return '#444';
	}
}

function wptouch_amp_hex_char_to_digit( $hex_char ) {
	switch ( $hex_char ) {
		case 'a':
			return 10;
		case 'b':
			return 11;
		case 'c':
			return 12;
		case 'd':
			return 13;
		case 'e':
			return 14;
		case 'f':
			return 15;
		default:
			return $hex_char;
	}
}

function wptouch_amp_hex_to_num( $hex ) {
	$hex = ltrim( $hex, '0' );

	$digit_1 = substr( $hex, 0, 1 );
	$digit_2 = substr( $hex, 1, 1 );

	return wptouch_amp_hex_char_to_digit( $digit_1 ) * 16 + wptouch_amp_hex_char_to_digit( $digit_2 );
}

function wptouch_amp_hex_to_luma( $hex ) {
	// assumes 6 character long hex strings
	$hex = strtolower( ltrim( $hex, '#' ) );

	if ( strlen( $hex ) == 6 ) {
		$red_hex   = substr( $hex, 0, 2 );
		$green_hex = substr( $hex, 2, 2 );
		$blue_hex  = substr( $hex, 4, 2 );
	} else {
		$red_hex   = substr( $hex, 0, 1 ) . substr( $hex, 0, 1 );
		$green_hex = substr( $hex, 1, 1 ) . substr( $hex, 1, 1 );
		$blue_hex  = substr( $hex, 2, 1 ) . substr( $hex, 2, 1 );
	}

	$red   = wptouch_amp_hex_to_num( $red_hex );
	$green = wptouch_amp_hex_to_num( $green_hex );
	$blue  = wptouch_amp_hex_to_num( $blue_hex );

	$luma = round( 0.30 * $red + 0.59 * $green + 0.11 * $blue );

	return $luma;
}

add_action( 'wp', 'enable_debug' );
function enable_debug() {
	if ( isset( $_GET['dump_rewrite'] ) ) {
		echo '<pre>';
		$rewrite = new WP_Rewrite();
		print_r( $rewrite->wp_rewrite_rules() );
		echo '</pre>';
		die();
	}

	if ( isset( $_GET['check_amp_init'] ) ) {
		echo '<pre>';
		print_r( function_exists( 'amp_init' ) );
		print_r( function_exists( 'amp_maybe_add_actions' ) );
		echo '</pre>';
		die();
	}

	if ( isset( $_GET['reset_amp_init'] ) ) {
		amp_init();
		flush_rewrite_rules();
		echo '<pre>';
		$rewrite = new WP_Rewrite();
		print_r( $rewrite->wp_rewrite_rules() );
		echo '</pre>';
		die();
	}
}

function wptouch_amp_maybe_prevent_metadata( $metadata, $post ) {
	if ( ! isset( $metadata['image'] ) ) {
		$metadata = false;
	}

	return $metadata;
}

// Use v0.3 templates until we style for v0.4.
if ( function_exists( 'amp_backcompat_use_v03_templates' ) ) {
	amp_backcompat_use_v03_templates();
}
