/* Generic WP styling */
<?php if ( wptouch_amp_ltr() ) { ?>
	amp-img.alignright { float: right; margin: 0 0 1em 1em; }
	amp-img.alignleft { float: left; margin: 0 1em 1em 0; }
	amp-img.aligncenter { display: block; margin-left: auto; margin-right: auto; }
	.alignright { float: right; }
	.alignleft { float: left; }

	.wp-caption.alignleft { margin-right: 1em; }
	.wp-caption.alignright { margin-left: 1em; }
<?php } else { ?>
	amp-img.alignright { float: left; margin: 0 1em 1em; }
	amp-img.alignleft { float: right; margin: 0 0 1em 1em; }
	amp-img.aligncenter { display: block; margin-left: auto; margin-right: auto; }
	.alignright { float: left; }
	.alignleft { float: right; }

	.wp-caption.alignleft { margin-left: 1em; }
	.wp-caption.alignright { margin-right: 1em; }
<?php } ?>
.aligncenter { display: block; margin-left: auto; margin-right: auto; }

.amp-wp-enforced-sizes {
	/** Our sizes fallback is 100vw, and we have a padding on the container; the max-width here prevents the element from overflowing. **/
	max-width: 100%;
}

.amp-wp-unknown-size img {
	/** Worst case scenario when we can't figure out dimensions for an image. **/
	/** Force the image into a box of fixed dimensions and use object-fit to scale. **/
	object-fit: contain;
}

/* Template Styles */
.amp-wp-content, .amp-wp-title-bar div,.powered-by-msg {
	<?php $content_max_width = absint( $this->get( 'content_max_width' ) ); ?>
	<?php if ( $content_max_width > 0 ) : ?>
	max-width: <?php echo sprintf( '%dpx', $content_max_width ); ?>;
	margin: 0 auto;
	<?php endif; ?>
}

body {
	font-family: 'Merriweather', Serif;
	font-size: 16px;
	line-height: 1.8;
	background: #fff;
	color: #3d596d;
	padding-bottom: 100px;
}

.amp-wp-content {
	padding: 16px;
	overflow-wrap: break-word;
	word-wrap: break-word;
	font-weight: 400;
	color: #3d596d;
}

.amp-wp-title {
	margin: 54px 0 20px;
	font-size: 36px;
	line-height: 1.258;
	font-weight: 700;
	color: #2e4453;
}
	<?php if ( has_post_thumbnail() && apply_filters( 'amp_should_show_featured_image_in_header', true ) ) { ?>
	.amp-wp-title:before {
		content: '';
		display: block;
		background: url( <?php echo get_the_post_thumbnail_url(); ?> ) no-repeat top center;
		background-size: cover;
		min-height: 200px;
		margin: -26px -20px 15px;
		padding: 20px;
	}
	<?php } ?>

p,
ol,
ul,
figure {
	margin: 0 0 24px 0;
}

a,
a:visited {
	color: rgba( <?php echo wptouch_hex_to_rgb( apply_filters( 'wptouch_amp_link_color', '#0a89c0' ), true ); ?>, .8 );
}

a:hover,
a:active,
a:focus {
	color: <?php echo apply_filters( 'wptouch_amp_link_color', '#0a89c0' ); ?>
}

pre {
	overflow: scroll;
}

/* UI Fonts */
.amp-wp-meta,
.wp-caption-text {
	font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", "Roboto", "Oxygen-Sans", "Ubuntu", "Cantarell", "Helvetica Neue", sans-serif;
	font-size: 15px;
}


/* Meta */
ul.amp-wp-meta {
	display: block;
	margin: 0 -20px 16px;
	padding: 15px 20px 15px;
	background-color: rgba( <?php echo wptouch_hex_to_rgb( apply_filters( 'wptouch_amp_header_color', '#0a89c0' ), true ); ?>, .1 );
}

ul.amp-wp-meta li {
	list-style: none;
	display: inline-block;
	margin: 0;
	line-height: 24px;
	white-space: nowrap;
	overflow: hidden;
	text-overflow: ellipsis;
	max-width: 300px;
}

ul.amp-wp-meta li:before {
	content: "\2022";
	margin: 0 8px;
}

ul.amp-wp-meta li:first-child:before {
	display: none;
}

.amp-wp-meta .screen-reader-text {
	/* from twentyfifteen */
	clip: rect(1px, 1px, 1px, 1px);
	height: 1px;
	overflow: hidden;
	position: absolute;
	width: 1px;
}

.amp-wp-byline amp-img {
	border-radius: 50%;
	border: 0;
	background: #f3f6f8;
	position: relative;
	top: 6px;
	margin-right: 6px;
}


/* Titlebar */
nav.amp-wp-title-bar {
	background: <?php echo apply_filters( 'wptouch_amp_header_color', '#0a89c0' ); ?>;
	padding: 0 16px;
	position: fixed;
	z-index: 999;
	width: 100%;
}

nav.amp-wp-title-bar div {
	line-height: 54px;
	color: <?php echo wptouch_amp_luma_corrected_color( apply_filters( 'wptouch_amp_sitename_color', '#fff' ), apply_filters( 'wptouch_amp_header_color', '#0a89c0' ) ); ?>;
}

nav.amp-wp-title-bar a {
	color: <?php echo wptouch_amp_luma_corrected_color( apply_filters( 'wptouch_amp_sitename_color', '#fff' ), apply_filters( 'wptouch_amp_header_color', '#0a89c0' ) ); ?>;
	text-decoration: none;
}

	nav.amp-wp-title-bar .amp-wp-site-icon {
		/** site icon is 32px **/
		<?php if ( wptouch_amp_ltr() ) { ?>
			float: left;
			margin: 11px 8px 0 0;
		<?php } else { ?>
			float: right;
			margin: 11px 0 0 8px;
		<?php } ?>
		border-radius: 50%;
	}



/* Captions */
.wp-caption-text {
	padding: 8px 16px;
	font-style: italic;
}


/* Quotes */
blockquote {
	padding: 16px;
	margin: 8px 0 24px 0;
	border-left: 2px solid <?php echo apply_filters( 'wptouch_amp_header_color', '#0a89c0' ); ?>;
	color: #4f748e;
	background: rgba( <?php echo wptouch_hex_to_rgb( apply_filters( 'wptouch_amp_header_color', '#0a89c0' ), true ); ?>, .1 );
}

blockquote p:last-child {
	margin-bottom: 0;
}

/* Other Elements */
.amp-wp-content amp-ad {
	margin: 30px auto;
	display: block;
}

amp-carousel {
	background: #000;
}

amp-iframe,
amp-youtube,
amp-instagram,
amp-vine {
	background: #f3f6f8;
}

amp-carousel > amp-img > img {
	object-fit: contain;
}

.amp-wp-iframe-placeholder {
	background: #f3f6f8 url( <?php echo esc_url( $this->get( 'placeholder_image_url' ) ); ?> ) no-repeat center 40%;
	background-size: 48px 48px;
	min-height: 48px;
}

.powered-by-msg {
	border-top: 1px solid rgba( 0, 0, 0, 0.1 );
	margin-top: 30px;
	padding-top: 20px;
	<?php if ( wptouch_amp_ltr() ) { ?>
		padding-left: 20px;
	<?php } else { ?>
		padding-right: 20px;
	<?php } ?>
}

<?php echo apply_filters( 'wptouch_amp_inject_css', false ); ?>