<?php

require_once( AMP__DIR__ . '/includes/sanitizers/class-amp-base-sanitizer.php' );

/**
 * Strips blacklisted tags and attributes from content.
 * See following for blacklist:
 *     https://github.com/ampproject/amphtml/blob/master/spec/amp-html-format.md#html-tags
 */
class AMP_Script_Sanitizer extends AMP_Base_Sanitizer {
	public function sanitize() {
		$whitelisted_types = $this->get_whitelisted_types();
		$this->strip_scripts( $whitelisted_types );
	}

	private function strip_scripts( $whitelisted_types ) {
		$body     = $this->get_body_node();
		$elements = $body->getElementsByTagName( 'script' );
		$length   = $elements->length;

		for ( $i = $length - 1; $i >= 0; $i -- ) {
			$element     = $elements->item( $i );
			$parent_node = $element->parentNode;

			$remove_script = true;

			if ( $element->hasAttributes() ) {
				$attribute_length = $element->attributes->length;
				for ( $j = $attribute_length - 1; $j >= 0; $j -- ) {
					$attribute      = $element->attributes->item( $j );
					$attribute_name = strtolower( $attribute->name );
					if ( $attribute_name == 'type' && in_array( $attribute->value, $whitelisted_types ) ) {
						$remove_script = false;
					}
				}
			}

			if ( $remove_script && $parent_node ) {
				$parent_node->removeChild( $element );
			} else {
				$body->appendChild( $element );
			}

			if ( 'body' !== $parent_node->nodeName && AMP_DOM_Utils::is_node_empty( $parent_node ) ) {
				$parent_node->parentNode->removeChild( $parent_node );
			}
		}
	}

	private function get_whitelisted_types() {
		return array(
			'application/ld+json',
		);
	}
}
