var make_child_container = jQuery( '#parent_theme_templates' );
var parent_theme_location;
var child_theme_location;
var editor;
var edited_template;

function makeChildListTemplates() {
	var selected_theme = jQuery( '#child_theme_list :selected' );
	var button = jQuery( '#child_theme_copy' );

	if ( selected_theme.val() == '' ) {
		button.hide();
		make_child_container.empty();
	} else {
		var working_listing = jQuery( '<div class="loader"></div>' );

		parent_theme_location = jQuery.trim( selected_theme.attr( 'data-parent-theme' ) );
		child_theme_location = jQuery.trim( selected_theme.attr( 'data-location' ) );

		var params = {
			parent_theme_directory_name: parent_theme_location,
			child_theme_directory_name: child_theme_location,
		};

		jQuery( make_child_container ).empty();

		button.hide();

		make_child_container.prepend( working_listing );

		wptouchAdminAjax( 'wptouch_list_templates', params, function( result ) {
			make_child_container.empty();

			templates = JSON.parse( result );
			make_child_container.append( outputTemplates( templates, '', 0 ) );

			button.show();
		});

		return params.child_theme_directory_name;
	}
}

function outputTemplates( template_object, path, level ) {
	var next_level = level + 1;
	var template_options = '';

	for ( var prop in template_object ) {
		if ( typeof( template_object[ prop ].present ) == 'undefined' ) {
			var new_path = path + prop + '/';
			template_options = template_options + '<p class="directory level-' + level + '">' + prop + '/</p>';
			nested = template_object[ prop ];
			template_options = template_options + outputTemplates( nested, new_path, next_level );
		} else {
			// console.log( template );

			if ( template_object[ prop ].present ) {
				template_class = 'present';
				template_copy = 'disabled';
				template_button = '<button class="edit_button no-save">Edit Template</button>';
			} else {
				template_class = '';
				template_copy = '';
				template_button = '';
				jQuery( '#child_theme_copy' ).css( 'display', 'block' );
			}

			template_options = template_options + '<p class="level-' + level + ' ' + template_class + '"><input ' + template_copy + ' type="checkbox" id="template-' + template_object[ prop ].name + '" name="' + path +  template_object[ prop ].name + '" class="no-save"> <label for="template-' + template_object[ prop ].name + '">' + template_object[ prop ].name + '</label>' + template_button + '</p>';

		}
	}

	return template_options;
}

function copyTemplatesToChild( e ) {
	e.preventDefault();

	progressBar = jQuery( '#progress-copy-templates' ).find( '.bar' );
	progressArea = jQuery( '.copy-templates' );

	make_child_template_copy_modal.open();

	wptouchProgressBarStart( progressBar );

	var params = {
		parent_theme_directory_name: jQuery( '#child_theme_list :selected' ).attr( 'data-parent-theme' ),
		child_theme_directory_name: child_theme_location,
		selected_templates: jQuery( '#parent_theme_templates input' ).serializeArray()
	};

	console.log( params );

	wptouchAdminAjax( 'wptouch_copy_templates', params, function( result ) {
		var progressItem = jQuery( '#progress-copy-templates .progress' );
		var heading = jQuery( '.copy-templates h1' );
		if ( result == 1 ) {
			wptouchProgressBarSuccess( progressBar );
			makeChildListTemplates();
			setTimeout( function(){
				heading.slideUp();
				progressItem.addClass( 'complete' );
				jQuery( '.copy-success' ).slideDown();
			}, 1500);
		} else {
			wptouchProgressBarError( progressBar );
			setTimeout( function(){
				heading.slideUp();
				progressItem.addClass( 'complete' );
				jQuery( progressBar ).removeClass( 'bar-success' ).addClass( 'bar-issue' );
				jQuery( '.copy-failed' ).slideDown();
			}, 1500);
		}
	});
}

// In case we need to reload this list while page exists
function refreshChildThemeList() {
	wptouchAdminAjax( 'list_child_themes', false, function( result ) {
		if ( result != 'none' ) {
			selector = jQuery( '#child_theme_list' );
			jQuery( 'option:not(:first)', selector ).remove();
			child_themes = JSON.parse( result );
			child_themes.forEach( function( theme ) {
				selector.append( '<option value="' + theme.classname + '" data-location="' + theme.location + '" data-parent-theme="' + theme.parent + '">' + theme.name + '</option>' );
			});
		}
	});
}

var make_child_modal = jQuery('[data-remodal-id=modal-make-child]').remodal();
var make_child_template_copy_modal = jQuery('[data-remodal-id=modal-make-child-copy-templates]').remodal();
var make_child_template_edit_modal = jQuery('[data-remodal-id=modal-make-child-edit-template]').remodal();

var progressBar, progressArea;

// Animation to start the progressbar
function wptouchProgressBarStart( barElement ){
	jQuery( barElement ).animate({ width: '20%' }, 550 );
}

// Animation for an error response
function wptouchProgressBarError( barElement ){
	jQuery( barElement ).animate({ width: '100%' }, 500, function(){ jQuery( barElement ).addClass( 'bar-fail' ); } );
}

// Animation for an issue response
function wptouchProgressBarIssue( barElement ){
	jQuery( barElement ).animate({ width: '100%' }, 500, function(){ jQuery( barElement ).addClass( 'bar-issue' ); } );
}

// Animation for a response related to license issues
function wptouchProgressBarLicense( barElement ){
	jQuery( barElement ).animate({ width: '100%' }, 500, function(){ jQuery( barElement ).addClass( 'bar-license' ); } );
}

// Animation for a success response
function wptouchProgressBarSuccess( barElement ){
	jQuery( barElement ).animate({ width: '100%' }, 500, function(){ jQuery( barElement ).addClass( 'bar-success' ); } );
}

// Reset progressbar for new animations when license modals are closed
function wptouchProgressBarReset( barElement ){
	jQuery( barElement ).css( 'width', '0%' ).removeClass( 'bar-fail bar-issue bar-license bar-success' );
	jQuery( barElement ).parent().removeClass( 'complete' );
	jQuery( '.remodal h1' ).show();
}

jQuery( document ).on( 'closed', '.remodal', function ( e ) {
	wptouchProgressBarReset( progressBar );
	jQuery( '.status' ).hide();
	progressArea.show();
});

function doMakeChildReady() {
	refreshChildThemeList();
	selector = jQuery( '#child_theme_list' ).on( 'change', function() {
		child_theme_location = makeChildListTemplates();
	});

	button = jQuery( '#child_theme_copy' ).on( 'click', copyTemplatesToChild );

	var parentName = jQuery.trim( jQuery( '#make_child_parent :selected' ).text() );

	jQuery( '#make_child_parent' ).change( function() {
		parentName = jQuery.trim( jQuery( '#make_child_parent :selected' ).text() );
		jQuery( '#make_child_title' ).val( wptouchMakeChild.default_child_name.replace( '%s', jQuery.trim( parentName ) ) );
		jQuery( '#make_child_directory' ).val( jQuery( '#make_child_parent' ).val() + '-child' );
	});

	jQuery( '#make_child_parent' ).trigger( 'change' );

	jQuery ( '#make_child_title' ).blur( function() {
		if ( jQuery( this ).val() === '' ) { jQuery( '#make_child_parent' ).trigger( 'change' ); }
	});

	jQuery( '#make_child_action' ).click( function( e ) {
		e.preventDefault();

		progressBar = jQuery( '#progress-child-theme' ).find( '.bar' );
		progressArea = jQuery( '.creating' );

		wptouchProgressBarStart( progressBar );

		var params = {
			theme_parent: jQuery( '#make_child_parent' ).val(),
			theme_name: jQuery( '#make_child_title' ).val(),
			theme_parent_name: parentName,
			theme_directory_name: jQuery( '#make_child_directory' ).val()
		};

		make_child_modal.open();

		wptouchAdminAjax( 'wptouch_make_child', params, function( result ) {
			var progressItem = jQuery( '#progress-child-theme .progress' );

			if ( result == 'exists' ) {
				wptouchProgressBarError( progressBar );
				setTimeout( function(){
					jQuery( '.creating h1' ).slideUp();
					progressItem.addClass( 'complete' );
					jQuery( progressBar ).removeClass( 'bar-success' ).addClass( 'bar-issue' );
					jQuery( '.failed' ).slideDown();
				}, 1500);
			} else if ( result == 'pass' ) {
				wptouchProgressBarSuccess( progressBar );
				setTimeout( function(){
					jQuery( '.creating h1' ).slideUp();
					progressItem.addClass( 'complete' );
					jQuery( '.created' ).slideDown();
					jQuery( document ).on( 'closed', '.remodal', function () {
						wptouchAdminTriggerReload();
					});
				}, 1500);
			}
		});
	});

	jQuery( '#editor-container' ).appendTo( '#wpbody-content' );


	jQuery ( make_child_container ).on( 'click', '.edit_button', function( e ) {
		e.stopPropagation();
		e.preventDefault();

		edited_template = jQuery( this ).siblings( 'input' ).first().attr( 'name' );

		var params = {
			child_theme_directory_name: child_theme_location,
			template: edited_template
		};

		if ( params.child_theme_directory_name != '' ) {
			wptouchAdminAjax( 'wptouch_load_template', params, function( result ) {
				if ( result == 0 ) {
					alert( 'failed' );
				} else {
					template_data = JSON.parse( result );
					jQuery( '#editor' ).html( htmlencode( template_data.contents ) );
					editor = ace.edit( 'editor' );
					editor.setTheme( 'ace/theme/chrome' );

					if ( template_data.type == 'js' ) {
						editor.getSession().setMode( 'ace/mode/javascript' );
					} else if ( template_data.type == 'php' ) {
						editor.getSession().setMode( 'ace/mode/php' );
					} else if ( template_data.type == 'css' ) {
						editor.getSession().setMode( 'ace/mode/css' );
					}

					jQuery( '#wpadminbar' ).css( 'z-index', '-1' );

					jQuery( '#editor-container' ).addClass( 'show-editor' );

					jQuery( '#editor-container h2 span' ).text( params.template );

					// editor.setValue( template_data.contents );

					editor.getSession().on("changeAnnotation", function(){
						var annot = editor.getSession().getAnnotations();
						var disable_save = false;
						if ( annot.length > 0 ) {
							for (var key in annot){
								if (annot.hasOwnProperty(key) && annot[key].type == 'error' ) {
									disable_save = true;
								}
							}
						}

						if ( disable_save ) {
							jQuery( '#editor-container button' ).attr( 'disabled', true );
						} else {
							jQuery( '#editor-container button' ).attr( 'disabled', false );
						}
					});

				}
			});
		}
	});

	function htmlencode(str) {
		  var buf = [];
		  for (var i=str.length-1;i>=0;i--) {
		    buf.unshift(['&#', str[i].charCodeAt(), ';'].join(''));
		  }
		  return buf.join('');
		};


	jQuery( '#editor-container .cancel' ).on( 'click', function() {
		editor.destroy();
		jQuery( '#editor-container' ).removeClass( 'show-editor' );
				jQuery( '#wpadminbar' ).css( 'z-index', '' );
	});

	jQuery( '#editor-container button' ).on( 'click', function() {
		var params = {
			child_theme_directory_name: child_theme_location,
			template: edited_template,
			value: editor.getValue()
		};

		wptouchAdminAjax( 'wptouch_save_template', params, function( result ) {
			if ( result == 0 ) {
				alert( 'failed' );
			} else {
				result = JSON.parse( result );
				editor.destroy();
				jQuery( '#editor-container' ).removeClass( 'show-editor' );
				jQuery( '#wpadminbar' ).css( 'z-index', '' );
			}
		});
	});
}

jQuery( document ).ready( function() { doMakeChildReady(); });