<?php
define( 'MAKE_CHILD_CONTENT_VERSION', '2.1' );
define( 'MAKE_CHILD_PAGENAME', 'Make Child Theme' );

add_filter( 'wptouch_addon_options', 'wptouch_addon_make_child_options' );
add_filter( 'wptouch_setting_defaults_addons', 'wptouch_addon_make_child_settings_defaults' );
add_filter( 'admin_init', 'wptouch_addon_make_child_load_admin_js_css' );
add_action( 'wptouch_admin_ajax_wptouch_make_child', 'wptouch_actual_make_child' );
add_action( 'wptouch_admin_ajax_wptouch_list_templates', 'wptouch_addon_make_child_list_templates' );
add_action( 'wptouch_admin_ajax_list_child_themes', 'wptouch_addon_make_child_list_child_themes' );
add_action( 'wptouch_admin_ajax_wptouch_copy_templates', 'wptouch_addon_make_child_copy_templates' );
add_action( 'wptouch_admin_ajax_wptouch_load_template', 'wptouch_addon_make_child_load_template' );
add_action( 'wptouch_admin_ajax_wptouch_save_template', 'wptouch_addon_make_child_save_template' );
add_action( 'wptouch_after_settings_subpage_wptouch-addon-make-child', 'wptouch_addon_make_child_add_modals' );

function wptouch_addon_make_child_save_file( $file_name, $file_data ) {
	$f = fopen( $file_name, 'w+t' );
	if ( $f ) {
		fwrite( $f, $file_data );
		fclose( $f );
	}
}

function wptouch_addon_make_child_settings_defaults( $settings ) {
	$settings->make_child_title = '';
	$settings->make_child_parent = 'bauhaus';
	$settings->make_child_directory = 'bauhaus-child';
	$settings->make_child_icon = WPTOUCH_BASE_CONTENT_URL . '/extensions/make-child/screenshot.png';

	return $settings;
}

function wptouch_addon_make_child_options( $page_options ) {
	wptouch_add_sub_page(
		MAKE_CHILD_PAGENAME,
		'wptouch-addon-make-child',
		$page_options
	);

	global $wptouch_pro;
	$available_themes = $wptouch_pro->get_available_themes( false );

	$theme_list = array();
	foreach( $available_themes as $key => $theme ) {
		if ( $theme->name == 'Foundation' || $theme->name == 'Scaffold' || ( isset( $theme->parent_theme ) && strlen( $theme->parent_theme ) ) ) {
			continue;
		}

		$theme_list[ $theme->base ] = $theme->name;
	}

	$settings_array[] = wptouch_add_setting(
		'list',
		'make_child_parent',
		__( 'Parent theme', 'wptouch-pro' ),
		__( 'The parent theme your child will be based off of. This list only includes themes you have installed.', 'wptouch-pro' ),
		WPTOUCH_SETTING_BASIC,
		'3.9',
		$theme_list
	);

	$settings_array[] = wptouch_add_setting(
		'text',
		'make_child_title',
		__( 'Title of child theme', 'wptouch-pro' ),
		'',
		WPTOUCH_SETTING_BASIC,
		'3.9'
	);

	$settings_array[] = wptouch_add_setting(
		'text',
		'make_child_directory',
		__( 'Child theme directory name', 'wptouch-pro' ),
		'',
		WPTOUCH_SETTING_BASIC,
		'3.9'
	);

	$settings_array[] = wptouch_add_setting(
		'button',
		'make_child_action',
		__( 'Make Child Theme', 'wptouch-pro' ),
		'',
		WPTOUCH_SETTING_BASIC,
		'4.0'
	);

	wptouch_add_page_section(
		MAKE_CHILD_PAGENAME,
		__( 'Make Child Theme', 'wptouch-pro' ),
		'make-child-theme',
		$settings_array,
		$page_options,
		ADDON_SETTING_DOMAIN
	);

	wptouch_add_page_section(
		MAKE_CHILD_PAGENAME,
		__( 'Theme Templates', 'wptouch-pro' ),
		'make-child-theme-templates',
		array(
			wptouch_add_setting(
				'callback',
				'make_child_files',
				__( 'Child Theme', 'wptouch-pro' ),
				'',
				WPTOUCH_SETTING_BASIC,
				'4.1.3',
				'wptouch_addon_make_child_build_setting'
			),
		),
		$page_options,
		ADDON_SETTING_DOMAIN,
		false,
		__( 'Easily copy and customize templates from your theme\'s parent', 'wptouch_pro' )
	);

	return $page_options;
}

function wptouch_addon_make_child_load_admin_js_css(){
	global $wptouch_pro;
	if ( $wptouch_pro->admin_is_wptouch_page() ) {
		wp_enqueue_script(
			'make-child',
			WPTOUCH_BASE_CONTENT_URL . '/extensions/make-child/make-child-admin.js',
			array( 'wptouch-pro-admin' ),
			MAKE_CHILD_CONTENT_VERSION,
			true
		);

		wp_enqueue_script(
			'ace',
			'https://cdnjs.cloudflare.com/ajax/libs/ace/1.2.3/ace.js',
			array( 'make-child' ),
			false,
			true
		);

		wp_enqueue_style(
			'make-child',
			WPTOUCH_BASE_CONTENT_URL . '/extensions/make-child/make-child-admin.css',
			array( 'wptouch-admin-styles' ),
			MAKE_CHILD_CONTENT_VERSION
		);

		$make_child_strings = array(
			'default_child_name' => __( 'My %s Child', 'wptouch-pro' )
		);

		wp_localize_script( 'make-child', 'wptouchMakeChild', $make_child_strings );
	}
}

function wptouch_addon_make_child_build_setting() {
	$options = '';
	$child_themes = wptouch_addon_make_child_list_child_themes();

	foreach( $child_themes as $theme ) {
		$options .= '<option value="' . $theme[ 'classname' ] . '" data-location="' . $theme[ 'location' ] . '" data-parent-theme="' . $theme[ 'parent' ] . '">' . $theme[ 'name' ] . '</option>';
	}

	if ( count( $child_themes ) == 0 ) {
		$disable_picker = ' disabled';
	} else {
		$disable_picker = '';
	}

	echo '<select id="child_theme_list"'. $disable_picker . ' class="no-save"><option value="">' . __( 'Select&hellip;', 'wptouch-pro' ) . '</option>' . $options . '</select>';
	echo '<div id="parent_theme_templates"></div>';
	echo '<button id="child_theme_copy" class="no-save">' . __( 'Copy Selected', 'wptouch-pro' ) . '</button>';

	echo '<div id="editor-container" class="editor">';
	echo '	<h2>Template Editor: <span></span></h2>';
	echo '	<div id="editor-controls"><button class="primary" id="save-changes" class="no-save">' . __( 'Save and Close', 'wptouch-pro' ) . '</button> or <a href="#" class="cancel">' . __( 'close without saving', 'wptouch-pro' ) . '</a></div>';
	echo '	<div id="editor"></div>';
	echo '</div>';
}

function wptouch_actual_make_child( $admin_action ) {
	global $wptouch_pro;

	$theme_parent = $wptouch_pro->post[ 'theme_parent' ];
	$theme_parent_name = $wptouch_pro->post[ 'theme_parent_name' ];
	$theme_name = $wptouch_pro->post[ 'theme_name' ];
	$theme_directory_name = $wptouch_pro->post[ 'theme_directory_name' ];

	$template_directory = dirname( __FILE__ ) . DIRECTORY_SEPARATOR . 'templates' . DIRECTORY_SEPARATOR;

	$theme_location = WPTOUCH_CUSTOM_THEME_DIRECTORY . DIRECTORY_SEPARATOR . $theme_directory_name;
	if ( !file_exists( $theme_location ) ) {
		mkdir( $theme_location );
	} else {
		echo 'exists';
		die;
	}

	if ( file_exists( $theme_location ) ) {
		get_currentuserinfo();
		global $current_user;

		// We created the directory, now do the installation
		require_once( WPTOUCH_DIR . DIRECTORY_SEPARATOR . 'core' . DIRECTORY_SEPARATOR . 'file-operations.php' );

		$template_readme = wptouch_load_file( dirname( __FILE__ ) . DIRECTORY_SEPARATOR . 'templates' . DIRECTORY_SEPARATOR . 'readme.txt' );

		$new_readme = str_replace(
			array( '%themename%', '%originaltheme%', '%adminname%', '%sitename%', '%originalthemename%' ),
			array( $theme_name, $theme_parent, $current_user->display_name, html_entity_decode( get_bloginfo( 'name' ), ENT_QUOTES ), $theme_parent_name ),
			$template_readme
		);

		wptouch_addon_make_child_save_file( $theme_location . DIRECTORY_SEPARATOR . 'readme.txt', $new_readme );

		// Handle screenshot file
		if ( function_exists( 'imagecreatefrompng' ) ) {
			// Merge our child theme overlay with the original screenshot
			$source_image = imagecreatefrompng( WPTOUCH_CUSTOM_THEME_DIRECTORY . DIRECTORY_SEPARATOR . $theme_parent . DIRECTORY_SEPARATOR . 'screenshot.png' );
			imagealphablending( $source_image, true );
			imagesavealpha( $source_image, true );

			$overlay_image = imagecreatefrompng( dirname( __FILE__ ) . DIRECTORY_SEPARATOR . 'templates' . DIRECTORY_SEPARATOR. 'overlay.png' );

			imagecopy( $source_image, $overlay_image, 0, 0, 0, 0, 256, 256 );
			imagepng( $source_image, $theme_location . DIRECTORY_SEPARATOR . 'screenshot.png' );
		} else {
			// Just copy the original screenshot file
			wptouch_copy_file( WPTOUCH_CUSTOM_THEME_DIRECTORY . DIRECTORY_SEPARATOR . $theme_parent . DIRECTORY_SEPARATOR . 'screenshot.png', $theme_location . DIRECTORY_SEPARATOR . 'screenshot.png' );
		}

		// Copy stylefile
		mkdir( $theme_location . DIRECTORY_SEPARATOR . 'default' );
		wptouch_copy_file( $template_directory . 'style.css', $theme_location . DIRECTORY_SEPARATOR . 'default' . DIRECTORY_SEPARATOR . 'style.css');
	}

	echo 'pass';
	die;
}

function wptouch_addon_make_child_list_child_themes( $admin_action = false ) {
	require_once( WPTOUCH_DIR . '/core/admin-themes.php' );

	$child_themes = array();
	while ( wptouch_has_themes( true ) ) {
		wptouch_the_theme();

		if ( wptouch_is_theme_child() && wptouch_get_theme_parent() != 'foundation' ) {
			$child_themes[] = array( 'name' => wptouch_get_theme_title(), 'classname' => wptouch_convert_to_class_name( wptouch_get_theme_title() ), 'location' => wptouch_get_theme_location(), 'parent' => wptouch_convert_to_class_name( wptouch_get_theme_parent() ) );
		}
	}

	if ( !$admin_action ) {
		return $child_themes;
	} else {
		if ( count( $child_themes ) > 0 ) {
			echo json_encode( $child_themes );
		} else {
			echo 'none';
		}
		exit;
	}
}

function wptouch_addon_make_child_get_directory( $theme_directory, $existing_files = false ) {
	$blocked_files = array( '.', '..', ' ', '.DS_Store', 'images', 'functions.php' );
	$files = array();

	if ( $handle = opendir( $theme_directory ) ) {
		/* This is the correct way to loop over the directory. */
		while ( false !== ( $entry = readdir( $handle ) ) ) {
			if ( !in_array( $entry, $blocked_files ) ) {

				if ( is_dir( $theme_directory . '/' . $entry ) ) {

					if ( $existing_files && isset( $existing_files[ $entry ] ) ) {
						$compare_files = $existing_files[ $entry ];
					} else {
						$compare_files = $existing_files;
					}

					$files[ $entry ] = wptouch_addon_make_child_get_directory( $theme_directory . '/' . $entry, $compare_files );
				} else {
					if ( $existing_files ) {
						if ( in_array( $entry, $existing_files ) ) {
							$present = true;
						} else {
							$present = false;
						}

						$files[] = array( 'name' => $entry, 'present' => $present );
					} else {
						$files[]= $entry;
					}
				}
			}
		}

		closedir( $handle );
	}

	return $files;
}

function wptouch_addon_make_child_list_templates( $admin_action ) {
	global $wptouch_pro;

	$child_templates = array();
	$parent_templates = array();

	$child_theme_directory_name = explode( 'themes/', str_replace( '/wptouch_data', '', $wptouch_pro->post[ 'child_theme_directory_name' ] ) );
	$child_theme_location = WPTOUCH_CUSTOM_THEME_DIRECTORY . DIRECTORY_SEPARATOR . $child_theme_directory_name[ 1 ] . '/default';


	$parent_theme_directory_name = $wptouch_pro->post[ 'parent_theme_directory_name' ];
	$parent_theme_location = WPTOUCH_CUSTOM_THEME_DIRECTORY . DIRECTORY_SEPARATOR . $parent_theme_directory_name . '/default';

	$child_templates = wptouch_addon_make_child_get_directory( $child_theme_location );

	echo json_encode( wptouch_addon_make_child_get_directory( $parent_theme_location, $child_templates ) );
}

function wptouch_addon_make_child_copy_templates() {
	global $wptouch_pro;
	if ( wp_verify_nonce( $wptouch_pro->post[ 'wptouch_ajax_nonce' ], 'wptouch_admin_ajax' ) ) {
		$child_theme_directory_name = explode( 'themes/', str_replace( '/wptouch_data', '', $wptouch_pro->post[ 'child_theme_directory_name' ] ) );

		if ( count( $child_theme_directory_name ) < 2 ) {
			echo 0;
			exit;
		}

		$child_theme_location = WPTOUCH_CUSTOM_THEME_DIRECTORY . DIRECTORY_SEPARATOR . $child_theme_directory_name[ 1 ] . '/default';

		$parent_theme_directory_name = $wptouch_pro->post[ 'parent_theme_directory_name' ];
		$parent_theme_location = WPTOUCH_CUSTOM_THEME_DIRECTORY . DIRECTORY_SEPARATOR . $parent_theme_directory_name . '/default';

		foreach ( $wptouch_pro->post[ 'selected_templates' ] as $template ) {

			if ( strstr( $template[ 'name' ], '/' ) ) {
				$test_directory = $child_theme_location;
				$template_parts = explode( '/', $template[ 'name' ] );
				foreach ( $template_parts as $path_element ) {
					if ( !strstr( $path_element, '.' ) ) {
						$test_directory = $test_directory . '/' . $path_element;
						if ( !is_dir( $test_directory ) ) {
							mkdir( $test_directory );
						}
					}
				}
			}

			$src = $parent_theme_location . '/' . $template[ 'name' ];
			$dest = $child_theme_location . '/' . $template[ 'name' ];

			copy( $src, $dest );
		}
		echo 1;
	} else {
		echo 0;
	}
}

function wptouch_addon_make_child_load_template() {
	global $wptouch_pro;
	if ( wp_verify_nonce( $wptouch_pro->post[ 'wptouch_ajax_nonce' ], 'wptouch_admin_ajax' ) ) {
		if ( substr( $wptouch_pro->post[ 'template' ], 0, 1 ) == '/' || substr( $wptouch_pro->post[ 'template' ], 0, 2 ) == '..' ) {
			return 0;
		}

		$child_theme_directory_name = explode( 'themes/', str_replace( '/wptouch_data', '', $wptouch_pro->post[ 'child_theme_directory_name' ] ) );

		if ( count( $child_theme_directory_name ) < 2 ) {
			echo 0;
			exit;
		}

		$child_theme_location = WPTOUCH_CUSTOM_THEME_DIRECTORY . DIRECTORY_SEPARATOR . $child_theme_directory_name[ 1 ] . '/default';

		$template_contents = file_get_contents( $child_theme_location . '/' . $wptouch_pro->post[ 'template' ] );
		$template_type = pathinfo( $child_theme_location . $wptouch_pro->post[ 'template' ], PATHINFO_EXTENSION );

		echo json_encode( array( 'contents' => $template_contents, 'type' => $template_type ) );
	} else {
		echo 0;
	}
}

function wptouch_addon_make_child_save_template() {
	global $wptouch_pro;
	if ( wp_verify_nonce( $wptouch_pro->post[ 'wptouch_ajax_nonce' ], 'wptouch_admin_ajax' ) ) {
		if ( substr( $wptouch_pro->post[ 'template' ], 0, 1 ) == '/' || substr( $wptouch_pro->post[ 'template' ], 0, 2 ) == '..' ) {
			// echo 'no traversing';
			return 0;
		}

		$child_theme_directory_name = explode( 'themes/', str_replace( '/wptouch_data', '', $wptouch_pro->post[ 'child_theme_directory_name' ] ) );

		if ( count( $child_theme_directory_name ) < 2 ) {
			// echo 'directory nonsense';
			echo 0;
			exit;
		}

		$child_theme_location = WPTOUCH_CUSTOM_THEME_DIRECTORY . DIRECTORY_SEPARATOR . $child_theme_directory_name[ 1 ] . '/default';

		$template_write = file_put_contents( $child_theme_location . '/' . $wptouch_pro->post[ 'template' ], $wptouch_pro->post[ 'value' ] );

		echo json_encode( array( 'result' => $template_write ) );
	} else {
		// echo 'nonsense nonce';
		echo 0;
	}
}

function wptouch_addon_make_child_add_modals() {
	include_once( dirname(__FILE__) . '/make-child-modals.php' );
}
