<?php

require_once( dirname( __FILE__ ) . '/class-debug.php' );

class Power_Pack_CSS_Optimizer {
	var $helpers;
	var $cdn_domain;
	var $cdn_version;
	var $css_version;

	var $original_size;
	var $reduced_size;

	public function __construct( $css_version = 1, $cdn_domain = false, $cdn_version = 1 ) {
		require_once( dirname( __FILE__ ) . '/class-power-pack-helpers.php' );

		$this->helpers = new Power_Pack_Helpers( $cdn_domain, $cdn_version );
		$this->cdn_version = $cdn_version;
		$this->cdn_domain = $cdn_domain;
		$this->css_version = $css_version;

		$this->original_size = 0;
		$this->reduced_size = 0; 
	}

	public function minify_one_css_file( $css_file_name ) {
		$contents = $this->helpers->load_file( $css_file_name );
		if ( $contents ) {
			// Rewrite URLs
			require_once( dirname( __FILE__ ) . '/../utils/UriRewriter.php' );

			Power_Pack_Debug::get()->write( "\t\tAbout to rewrite: \n" . $css_file_name . "\n" . dirname( $css_file_name ) . "\n" . $_SERVER['DOCUMENT_ROOT'] );

			$css_url_rewriter = new Minify_CSS_UriRewriter;
			
			$new_contents = $css_url_rewriter->rewrite( 
				$contents, 
				dirname( $css_file_name )
			);

			Power_Pack_Debug::get()->write( "\t\tFinished rewriting" . $css_file_name );

			// Minify CSS
			require_once( dirname( __FILE__ ) . '/../utils/CSSmin.php' );	

			$css_min = new CSSMin;

			Power_Pack_Debug::get()->write( "\t\tMinifying: " . $css_file_name );

			$minified_content = $css_min->run( $new_contents );

			Power_Pack_Debug::get()->write( "\t\tFinished minifying" );

			if ( $this->cdn_domain && strlen( $this->cdn_domain ) ) {
				if ( preg_match_all( '#url\((.*)\)#iUs', $minified_content, $matches ) ) {
					for( $i = 0; $i < count( $matches[0] ); $i++) {
						$url_in_css_blob = $matches[0][$i];
						$url_param = trim( $matches[1][$i], "'\"" );

						if ( strpos( $url_in_css_blob, 'data:' ) === false ) {
							Power_Pack_Debug::get()->write( "\tInvestigating " . $url_in_css_blob . " => " . $url_param );
							$url_info = parse_url( $url_param );

							$can_replace = false;
							$scheme = ( isset( $_SERVER[ 'HTTPS' ] ) && $_SERVER[ 'HTTPS' ] == 'on' ) ? 'https' : 'http';
							$host = $_SERVER['HTTP_HOST'];
							if ( isset( $url_info[ 'host' ] ) ) {
								$host = $url_info[ 'host' ];
							}

							if ( $host == $_SERVER['HTTP_HOST'] ) {
								$query_url = add_query_arg( array( 'cdn_version' => $this->cdn_version ), $scheme . '://' . $this->cdn_domain . $url_info[ 'path' ] );
								$new_css_blob = str_replace( $url_param, $query_url, $url_in_css_blob );

								Power_Pack_Debug::get()->write( "\t\tReplacing " . $url_in_css_blob . " with " . $new_css_blob );

								$minified_content = str_replace( $url_in_css_blob, $new_css_blob, $minified_content );
							}
						}
					}
				}			
			}

			Power_Pack_Debug::get()->write( "\t\tReturning minified content" );

			return $minified_content;	
		} else {
			Power_Pack_Debug::get()->write( "\t\tCan't find contents" );
		}

		return false;
	}

	public function process( $buffer, $minify = true, $concatenate = true, $skip_minified_files = false ) {
		$css_files = array();
		
		$buffer_without_comments = $this->helpers->remove_comments( $buffer );

		if ( preg_match_all( '#(<link (.*)>)#iUs', $buffer_without_comments, $new_matches ) ) {
			foreach( $new_matches[1] as $possible_css_file ) {
				// Now check to see if it's a CSS file
				if ( preg_match( '#type=["\']text/css["\']#', $possible_css_file, $css_match ) ) {
					// We know it's a CSS file now

					if ( preg_match( '#href=["\'](.*)["\']#iUs', $possible_css_file, $css_file ) ) {
						
						$css_info = new stdClass;

						$css_info->link = $possible_css_file;
						$css_info->href = $css_file[1];

						$css_files[] = $css_info;
					}
				}
			}
		}

		$concatenated_info = '';
		$used_css_files = array();

		foreach( $css_files as $css_info ) {
			if ( $skip_minified_files && strpos( $css_info->href, '.min.css' ) !== false ) {
				// no point minifying CSS files that are already minified
				continue;
			}

			$url_info = parse_url( $css_info->href );

			$scheme = '';
			if ( isset( $url_info[ 'scheme' ] ) ) {
				$scheme = $url_info[ 'scheme' ];
			}

			$real_url = $scheme . '://' . $url_info['host'] . $url_info['path'];

			if ( $this->helpers->is_local_file( $real_url ) ) {
				$used_css_files[] = $css_info;

				$local_file = $this->helpers->convert_url_to_filename( $real_url );
				$concatenated_info = $concatenated_info . $local_file . filemtime( $local_file );
			}
		}

		foreach( $used_css_files as $css_file ) {
			$local_file = $this->helpers->convert_url_to_filename( $css_file->href );

			if ( file_exists( $local_file ) ) {
				$this->original_size += filesize( $local_file );
			}
		}

		if ( $concatenate ) {
			$concatenated_file = POWER_PACK_CACHE_CSS_DIR . '/' . md5( $this->css_version . $concatenated_info ) . '.min.css';

			if ( !file_exists( $concatenated_file ) ) {
				$concatenated_content = '';

				foreach( $used_css_files as $css_info ) {
					$url_info = parse_url( $css_info->href );

					$scheme = '';
					if ( isset( $url_info[ 'scheme' ] ) ) {
						$scheme = $url_info[ 'scheme' ];
					}

					$real_url = $scheme . '://' . $url_info['host'] . $url_info['path'];
					$local_file = $this->helpers->convert_url_to_filename( $real_url );

					Power_Pack_Debug::get()->write( 'Adding ' . $local_file . ' to concatenated CSS file' );

					$minified_content = $this->minify_one_css_file( $local_file );
					if ( $minified_content ) {
						$concatenated_content = $concatenated_content . $minified_content;
					} else {
						Power_Pack_Debug::get()->write( "\tERROR: Unable to add " . $local_file . " to concatenated CSS file" );
					}
				}		

				$this->helpers->save_file( $concatenated_file, $concatenated_content );
			}

			if ( file_exists( $concatenated_file ) ) {
				Power_Pack_Debug::get()->write( 'Serving concatenated CSS file ' . $concatenated_file );

				$used_css_file_count = count( $used_css_files );
				if ( 0 < $used_css_file_count ) {
					$link_to_replace = $used_css_files[ $used_css_file_count - 1 ];
					foreach ( $used_css_files as $css_info ) {
						if ( $link_to_replace->link != $css_info->link ) {
							// Get rid of this one.
							$buffer = str_replace( $css_info->link, '', $buffer );
						}
					}

					$this->reduced_size += filesize( $concatenated_file );
					$concat_url = $this->helpers->convert_filename_to_url( $concatenated_file );

					$buffer = str_replace( $link_to_replace->link, str_replace( $link_to_replace->href, $concat_url, $link_to_replace->link ), $buffer );
				}
			}
		} else {
			foreach( $used_css_files as $css_info ) {
				$url_info = parse_url( $css_info->href );

				$scheme = '';
				if ( isset( $url_info[ 'scheme' ] ) ) {
					$scheme = $url_info[ 'scheme' ];
				}

				$real_url = $scheme . '://' . $url_info['host'] . $url_info['path'];

				$local_file = $this->helpers->convert_url_to_filename( $real_url );
				$new_css_file = POWER_PACK_CACHE_CSS_DIR . '/' . md5( $this->css_version . $local_file . filemtime( $local_file ) ) . '.min.css';

				if ( !file_exists( $new_css_file ) ) {
					$min_content = $this->minify_one_css_file( $local_file );	
					$this->helpers->save_file( $new_css_file, $min_content );
				}

				if ( file_exists( $new_css_file ) ) {
					$this->reduced_size += filesize( $new_css_file );

					$new_css_url = $this->helpers->convert_filename_to_url( $new_css_file );
					if ( $url_info['query'] ) {
						$query_params = $this->helpers->get_url_params( $url_info['query'] );
						$new_css_url = add_query_arg( $query_params, $new_css_url );
					}

					$buffer = str_replace( $css_info->link, str_replace( $css_info->href, $new_css_url, $css_info->link ), $buffer );
				}
			}				
		}

		return $buffer;
	}
}
