<?php

static $debug_instance;

class Power_Pack_Debug {
	var $debug_file;

	static function get() {
		global $debug_instance;

		if ( !$debug_instance ) {
			$debug_instance = new Power_Pack_Debug;
		}

		return $debug_instance;
	}

	protected function __construct() {
		if ( POWER_PACK_DEBUG ) {
			$this->debug_file = fopen( POWER_PACK_CONTENT_DIR . '/power-pack-debug.txt', 'a+t' );	
		} else {
			$this->debug_file = false;
		}
	}

	public function write( $msg ) {
		if ( POWER_PACK_DEBUG ) {
			fwrite( $this->debug_file, time() . " => \t" . $msg . "\n" );
		}
	}
}