<?php

require_once( dirname( __FILE__ ) . '/class-debug.php' );

class Power_Pack_JS_Optimizer {
	var $helpers;
	var $js_version;
	var $optimize_external;

	var $original_size;
	var $reduced_size;

	public function __construct( $js_version = 1, $cdn_domain = false, $cdn_version = 1, $optimize_external = false ) {
		require_once( dirname( __FILE__ ) . '/class-power-pack-helpers.php' );

		$this->helpers = new Power_Pack_Helpers( $cdn_domain, $cdn_version );

		$this->js_version = $js_version;
		$this->optimize_external = $optimize_external;

		$this->original_size = 0;
		$this->reduced_size = 0;
	}

	public function minify_one_js_file( $js_file_name ) {
		$contents = $this->helpers->load_file( $js_file_name );
		if ( $contents ) {
			// Minify CSS
			require_once( dirname( __FILE__ ) . '/../utils/Minifier.php' );

			return Minifier::minify( $contents );
		}

		return false;
	}

	public function process( $buffer, $minify = true, $concatenate = true, $skip_minified_files = false ) {
		$buffer_without_comments = $this->helpers->remove_comments( $buffer );

		$js_files = array();
		if ( preg_match_all( '#(<script (.*)/script>)#iUs', $buffer_without_comments, $new_matches ) ) {
			foreach( $new_matches[1] as $possible_js_file ) {
				// Now check to see if it's a CSS file
				if ( preg_match( '#type=["\']text/javascript["\']#', $possible_js_file, $js_match ) ) {
					// We know it's a CSS file now

					if ( preg_match( '#src=["\'](.*)["\']#iUs', $possible_js_file, $js_file ) ) {

						$js_info = new stdClass;

						$js_info->link = $possible_js_file;
						$js_info->href = $js_file[1];

						$js_files[] = $js_info;
					}
				}
			}
		}

		$concatenated_info = '';
		$used_js_files = array();

		foreach( $js_files as $js_info ) {
			if ( $skip_minified_files && strpos( $js_info->href, '.min.js' ) !== false ) {
				// no point minifying CSS files that are already minified
				continue;
			}

			$url_info = parse_url( $js_info->href );

			$scheme = '';
			if ( isset( $url_info[ 'scheme' ] ) ) {
				$scheme = $url_info[ 'scheme' ];
			}

			$real_url = $scheme . '://' . $url_info['host'] . $url_info['path'];

			if ( $this->helpers->is_local_file( $real_url ) ) {
				$used_js_files[] = $js_info;

				$local_file = $this->helpers->convert_url_to_filename( $real_url );
				$concatenated_info = $concatenated_info . $local_file . filemtime( $local_file );
			} else if ( $this->optimize_external ) {
				$new_local_file = POWER_PACK_CACHE_JS_DIR . '/' . md5( $this->js_version . $real_url ) . '.js';

				if ( !file_exists( $new_local_file ) ) {
					$this->helpers->download_remote_file( $real_url, $new_local_file );
				}

				/* This doesn't work yet, need to figure out why */
				if ( file_exists( $new_local_file ) ) {
					$used_js_files[] = $js_info;

					$local_file = $this->helpers->convert_url_to_filename( $real_url );
					$concatenated_info = $concatenated_info . $local_file . filemtime( $new_local_file );
				}
			}
		}

		foreach( $used_js_files as $css_file ) {
			$local_file = $this->helpers->convert_url_to_filename( $css_file->href );

			if ( file_exists( $local_file ) ) {
				$this->original_size += filesize( $local_file );
			}
		}

		if ( $concatenate ) {
			$concatenated_file = POWER_PACK_CACHE_JS_DIR . '/' . md5( $this->js_version . $concatenated_info ) . '.min.js';
			if ( !file_exists( $concatenated_file ) ) {
				$concatenated_content = '';
				foreach( $used_js_files as $js_info ) {
					$url_info = parse_url( $js_info->href );

					$scheme = '';
					if ( isset( $url_info[ 'scheme' ] ) ) {
						$scheme = $url_info[ 'scheme' ];
					}

					$real_url = $scheme . '://' . $url_info['host'] . $url_info['path'];

					$local_file = $this->helpers->convert_url_to_filename( $real_url );

					Power_Pack_Debug::get()->write( 'Adding ' . $local_file . ' to concatenated JS file' );

					$minified_content = $this->minify_one_js_file( $local_file );

					if ( $minified_content ) {
						$concatenated_content = $concatenated_content . $minified_content;
					} else {
						Power_Pack_Debug::get()->write( "\tERROR: Unable to add " . $local_file . " to concatenated JS file" );
					}
				}

				$this->helpers->save_file( $concatenated_file, $concatenated_content );
			}

			if ( file_exists( $concatenated_file ) ) {
				Power_Pack_Debug::get()->write( 'Serving concatenated JS file ' . $concatenated_file );

				$used_js_file_count = count( $used_js_files );
				if ( 0 < $used_js_file_count ) {
					$link_to_replace = $used_js_files[ $used_js_file_count - 1 ];
					foreach ( $used_js_files as $js_info ) {
						if ( $link_to_replace->link != $js_info->link ) {
							// Get rid of this one
							Power_Pack_Debug::get()->write( 'Nulling out ' . $js_info->link );
							$buffer = str_replace( $js_info->link, '', $buffer );
						}
					}

					$this->reduced_size += filesize( $concatenated_file );

					$concat_url = $this->helpers->convert_filename_to_url( $concatenated_file );
					$buffer = str_replace( $link_to_replace->link, str_replace( $link_to_replace->href, $concat_url, $link_to_replace->link ), $buffer );
				}
			}
		} else {
			foreach( $used_js_files as $js_info ) {
				$url_info = parse_url( $js_info->href );

				$scheme = '';
				if ( isset( $url_info[ 'scheme' ] ) ) {
					$scheme = $url_info[ 'scheme' ];
				}

				$real_url = $scheme . '://' . $url_info['host'] . $url_info['path'];

				$local_file = $this->helpers->convert_url_to_filename( $real_url );

				$new_js_file = POWER_PACK_CACHE_JS_DIR . '/' . md5( $this->js_version . $local_file . filemtime( $local_file ) ) . '.min.js';

				if ( !file_exists( $new_js_file ) ) {
					$min_content = $this->minify_one_js_file( $local_file );

					$this->helpers->save_file( $new_js_file, $min_content );
				}

				if ( file_exists( $new_js_file ) ) {
					$this->reduced_size += filesize( $new_css_file );

					$new_js_url = $this->helpers->convert_filename_to_url( $new_js_file );
					if ( $url_info['query'] ) {
						$query_params = $this->helpers->get_url_params( $url_info['query'] );

						$new_js_url = add_query_arg( $query_params, $new_js_url );
					}

					$buffer = str_replace( $js_info->link, str_replace( $js_info->href, $new_js_url, $js_info->link ), $buffer );
				}
			}
		}

		return $buffer;
	}
}
