<?php

class Power_Pack_Helpers {
	var $cdn_domain;
	var $cdn_version;

	public function __construct( $cdn_domain = false, $cdn_version = 1 ) {
		$this->cdn_domain = $cdn_domain;
		$this->cdn_version = $cdn_version;
	}

	public function download_remote_file( $remote_url, $local_file ) {
		$open_url = $remote_url;
		if ( strpos( $remote_url, '//' ) == 0 ) {
			// we don't have a protocol
			$open_url = 'http:' . $remote_url;
		}

		$remote_file = @fopen( $open_url, 'rb');
		if ( $remote_file ) {

			// Remove http/https from this
			$dest_file = fopen( $local_file, 'w+b' );

			if ( $dest_file ) {
				while ( true ) {
					$data = fread( $remote_file, 8192 );

					if ( $data ) {
						fwrite( $dest_file, $data );
					}

					if ( feof( $remote_file ) ) {
						break;
					}
				}

				fclose( $dest_file );
			}

			fclose( $remote_file );

			return $local_file;
		}

		return false;
	}

	public function get_url_params( $param_string ) {
		$url_params = array();

		if ( $param_string ) {
			$each_param = explode( '&', $param_string );
			if ( $each_param ) {
				foreach( $each_param as $param ) {
					$key_value = explode( '=', $param );
					if ( $key_value ) {
						$url_params[ $key_value[0] ] = $key_value[1];
					}
				}
			}
		}

		return $url_params;
	}

	public function remove_comments( $buffer ) {
		if ( preg_match_all( '#<!--(.*)-->#iUs', $buffer, $matches ) ) {
			$to_find = array();
			$to_replace = array();

			foreach( $matches[0] as $match ) {
				$to_find[] = $match;
				$to_replace[] = '';
			}

			return str_replace( $to_find, $to_replace, $buffer );
		}

		return $buffer;
	}

	public function has_responsive_theme() {
		$responsive_theme = 0;

		if ( false === ( $already_detected = get_transient( 'response_checked_responsive_theme' ) ) ) {
			$contents = $this->load_file( get_stylesheet_directory() . '/style.css' );
			if ( $contents ) {
				if ( preg_match_all( '#@media (.*){#iUs', $contents, $matches ) ) {
					if ( is_array( $matches ) && count( $matches[0] ) ) {
						foreach( $matches[0] as $potential_media_line ) {
							if ( ( strpos( $potential_media_line, 'min-width' ) !== false ) || ( strpos( $potential_media_line, 'max-width' ) !== false ) ) {
								$responsive_theme = 1;

								break;
							}
						}
					}
				}
			}

			set_transient( 'response_checked_responsive_theme', $responsive_theme, 3600 );
		} else {
			$responsive_theme = $already_detected;
		}

		return ( $responsive_theme == 1 );
	}

	public function load_file( $file_name ) {
		$content = '';

		$f = fopen( $file_name, 'r' );
		if ( $f ) {
			while ( !feof( $f ) ) {
				$new_content = fread( $f, 8192 );
				if ( $new_content ) {
					$content = $content . $new_content;
				}
			}
		}

		return $content;
	}

	public function save_file( $file_name, $contents, $save_gzip_file = true ) {
		$f = fopen( $file_name, 'w+b' );
		if ( $f ) {
			fwrite( $f, $contents );
			fclose( $f );
		}

		if ( $save_gzip_file ) {
			$gzip_file = gzopen( $file_name . '.gz', 'wb9' );
			if ( $gzip_file ) {
				gzwrite( $gzip_file, $contents );
				gzclose( $gzip_file );
			}
		}
	}

	public function is_local_file( $url ) {
		$url_info = parse_url( $url );

		$scheme = '';
		if ( isset( $url_info[ 'scheme' ] ) ) {
			$scheme = $url_info[ 'scheme' ];
		}

		$server_root_url = $scheme . '://' . $_SERVER['HTTP_HOST'];
		$server_root_dir = $_SERVER['DOCUMENT_ROOT'];

		$test_local_file = str_replace( $server_root_url, $server_root_dir, $url );

		return ( $test_local_file != $url );
	}

	public function convert_url_to_filename( $url ) {
		$url_info = parse_url( $url );

		$scheme = '';
		if ( isset( $url_info[ 'scheme' ] ) ) {
			$scheme = $url_info[ 'scheme' ];
		}

		$server_root_url = $scheme . '://' . $_SERVER['HTTP_HOST'];
		$server_root_dir = $_SERVER['DOCUMENT_ROOT'];

		$local_file = str_replace( $server_root_url, $server_root_dir, $url );

		if ( strpos( $local_file, '?' ) !== false ) {
			$file_info = explode( '?', $local_file );

			return $file_info[0];
		} else {
			return $local_file;
		}
	}

	public function convert_filename_to_url( $filename, $change_to_cdn = true ) {
		$scheme = 'http';
		if ( isset( $_SERVER[ 'HTTPS' ] ) && $_SERVER[ 'HTTPS' ] == 'on' ) {
			$scheme = 'https';
		}

		$server_root_dir = rtrim( ABSPATH, '/' );
		if ( $this->cdn_domain && $change_to_cdn ) {
			$server_root_url = $scheme . '://' . rtrim( $this->cdn_domain, '/' );
			return add_query_arg( array( 'cdn_version' => $this->cdn_version ), str_replace( $server_root_dir, $server_root_url, $filename ) );
		} else {
			$server_root_url = $scheme . '://' . $_SERVER['HTTP_HOST'];
			return str_replace( $server_root_dir, $server_root_url, $filename );
		}
	}

	public function get_page_cache_version() {
		$settings = response_get_settings();

		return substr( md5( $settings->page_cache_version ), 0, 6 );
	}
}
