<?php

define( 'POWER_PACK_VERSION', '1.0.4' );
define( 'POWER_PACK_PAGENAME', 'Power Pack' );
define( 'POWER_PACK_DIR', WPTOUCH_CUSTOM_ADDON_DIRECTORY . '/power-pack' );
define( 'POWER_PACK_CONTENT_DIR', WPTOUCH_BASE_CONTENT_DIR . '/power-pack' );
define( 'POWER_PACK_MAX_CDN_URL', 4 );

if ( !defined( 'POWER_PACK_DEBUG' ) ) {
	define( 'POWER_PACK_DEBUG', 0 );
}

require_once( dirname( __FILE__ ) . '/include/class-page-cache.php' );
require_once( dirname( __FILE__ ) . '/include/class-responsive-images.php' );

require_once( dirname( __FILE__ ) . '/include/class-css-optimizer.php' );
require_once( dirname( __FILE__ ) . '/include/class-js-optimizer.php' );

add_filter( 'wptouch_setting_defaults_addons', 'wptouch_addon_power_pack_defaults' );
add_filter( 'wptouch_addon_options', 'wptouch_power_pack_addon_options' );

add_action( 'init', 'wptouch_power_pack_check_for_purge' );
add_action( 'init', 'wptouch_power_pack_admin_bar' );
add_action( 'init', 'wptouch_power_pack_check_dirs' );
add_filter( 'admin_init', 'wptouch_power_pack_load_admin_js_css' );

function wptouch_power_pack_check_dirs() {
	if ( !file_exists( POWER_PACK_CONTENT_DIR ) ) {
		mkdir( POWER_PACK_CONTENT_DIR );
	}

	if ( !file_exists( POWER_PACK_CACHE_DIR ) ) {
		mkdir( POWER_PACK_CACHE_DIR );
	}

	if ( !file_exists( POWER_PACK_CACHE_CSS_DIR ) ) {
		mkdir( POWER_PACK_CACHE_CSS_DIR );
	}

	if ( !file_exists( POWER_PACK_CACHE_JS_DIR ) ) {
		mkdir( POWER_PACK_CACHE_JS_DIR );
	}

	// Disable responsive images and infinity cache if enables
	if ( is_admin() ) {
		$settings = wptouch_get_settings();
		$to_disable = array( 'Infinity Cache', 'Responsive Images' );
		$was_changed = false;

		foreach( $to_disable as $addon ) {
			if ( isset( $settings->active_addons[ $addon ] ) ) {
				unset( $settings->active_addons[ $addon ] );
				$was_changed = true;
			}
		}

		if ( $was_changed ) {
			$settings->save();
		}
	}
}

function wptouch_power_pack_check_for_purge() {
	if ( wptouch_power_pack_cache_is_enabled() ) {
		if ( isset( $_GET[ 'wptouch_power_pack_purge' ] ) ) {
			$nonce = $_GET[ 'purge_nonce' ];
			if ( wp_verify_nonce( $nonce, 'power_pack_cache' ) ) {
				wptouch_power_pack_cache_handle_ajax_reset();

				wp_redirect( add_query_arg( array( 'wptouch_power_pack_purge' => false, 'purge_nonce' => false ) ) );
			}
		}
	}
}

function wptouch_power_pack_load_admin_js_css(){
	global $wptouch_pro;
	if ( $wptouch_pro->admin_is_wptouch_page() ) {
		wp_enqueue_style(
			'power-pack',
			WPTOUCH_BASE_CONTENT_URL . '/extensions/power-pack/admin.css',
			array( 'wptouch-admin-styles' ),
			POWER_PACK_VERSION
		);

		wp_enqueue_script(
			'power-pack',
			WPTOUCH_BASE_CONTENT_URL . '/extensions/power-pack/js/admin.js',
			array( 'wptouch-pro-admin' ),
			POWER_PACK_VERSION,
			true
		);
	}
}

function wptouch_power_pack_admin_bar() {
	add_action( 'admin_bar_menu', 'wptouch_power_pack_admin_bar_links', 999 );
}

function wptouch_power_pack_admin_bar_links() {
	global $wp_admin_bar;
	if ( !is_super_admin() || !is_admin_bar_showing() ) {
		return;
	}

	if ( wptouch_power_pack_cache_is_enabled() ) {
		$wp_admin_bar->add_node(
			array(
				'id'   => 'power_pack_cache',
				'meta' => array(),
				'title' => 'Power Pack',
				'href' => false
			)
		);

		$wp_admin_bar->add_node(
			array(
				'id' => 'power_pack_cache_purge',
				'meta' => array(),
				'title' => __( 'Purge Page Cache', 'wptouch-pro' ),
				'parent' => 'power_pack_cache',
				'href' => esc_url( add_query_arg( array( 'wptouch_power_pack_purge' => '1', 'purge_nonce' => wp_create_nonce( 'power_pack_cache' ) ), $_SERVER[ 'REQUEST_URI' ] ) )
			)
		);
	}
}

function wptouch_addon_power_pack_defaults( $settings ) {
	// Page Caching
	$settings->cache_last_flush_time = time();
	$settings->cache_enable = false;
	$settings->cache_enable_desktop = false;
	$settings->cache_garbage_collection_interval = 'hourly';
	$settings->cache_expiry_time = 3600;
	$settings->cache_ignored_urls = "/feed/\nsitemap.xml\nsitemap_index.xml";
	$settings->cache_enable_browser_cache = false;
	$settings->cache_optimize_enable_cdn = 0;

	if ( wptouch_power_pack_cache_can_use_gzip() ) {
		$settings->cache_compress_output = false;
	}

	// Responsive Images
	$settings->responsive_images_enable = true;
	$settings->media_optimize_on_desktop = true;

	// Minification
	$settings->minification_css_enable = false;
	$settings->minification_js_enable = false;

	for ( $i = 1; $i <= POWER_PACK_MAX_CDN_URL; $i++ ) {
		$name = 'media_optimize_cdn_prefix_' . $i;
		$settings->$name = false;
	}

	return $settings;
}


function wptouch_power_pack_addon_options( $page_options ) {
	wptouch_add_sub_page(
        POWER_PACK_PAGENAME,
        'wptouch-addon-power-pack',
        $page_options
    );

	$settings_array = array(
		wptouch_add_setting(
			'checkbox',
			'cache_enable',
			__( 'Enable Page Cache', 'wptouch-pro' ),
			'',
			WPTOUCH_SETTING_BASIC,
			'3.1'
		),
		wptouch_add_setting(
			'checkbox',
			'cache_enable_desktop',
			__( 'Create cache for desktop users', 'wptouch-pro' ),
			__( 'If you are using another cache plugin such as W3, you can disable this.', 'wptouch-pro' ),
			WPTOUCH_SETTING_BASIC,
			'3.1'
		),
	);

	if ( wptouch_power_pack_cache_can_use_gzip() ) {
		$settings_array[] = wptouch_add_setting(
			'checkbox',
			'cache_compress_output',
			__( 'Compress output using GZIP', 'wptouch-pro' ),
			'',
			WPTOUCH_SETTING_BASIC,
			'3.1'
		);
	}

	$settings_array[] = wptouch_add_setting(
		'list',
		'cache_expiry_time',
		__( 'Maximum age of cached content', 'wptouch-pro' ),
		__( 'Each cached page will automatically be regenerated after this period elapses', 'wptouch-pro' ),
		WPTOUCH_SETTING_BASIC,
		'3.1',
		array(
			900 => sprintf( _n( '%d minute', '%d minutes', 15, 'wptouch-pro' ), 15 ),
			1800 => sprintf( _n( '%d minute', '%d minutes', 30, 'wptouch-pro' ), 30 ),
			3600 => sprintf( _n( '%d hour', '%d hours', 1, 'wptouch-pro' ), 1 ),
			3600*3 => sprintf( _n( '%d hour', '%d hours', 3, 'wptouch-pro' ), 3 ),
			3600*6 => sprintf( _n( '%d hour', '%d hours', 6, 'wptouch-pro' ), 6 ),
			3600*12 => sprintf( _n( '%d hour', '%d hours', 12, 'wptouch-pro' ), 12 ),
			3600*24 => sprintf( _n( '%d hour', '%d hours', 24, 'wptouch-pro' ), 24 )
		)
	);

	$settings_array[] = wptouch_add_setting(
		'list',
		'cache_garbage_collection_interval',
		__( 'Remove stale cache file interval', 'wptouch-pro' ),
		'',
		WPTOUCH_SETTING_BASIC,
		'3.1',
		array(
			'hourly' => __( 'Hourly', 'wptouch-pro' ),
			'daily' => __( 'Daily', 'wptouch-pro' )
		)
	);

	$settings_array[] = wptouch_add_setting(
		'textarea',
		'cache_ignored_urls',
		__( 'Disable caching for any of these matched URL fragments', 'wptouch-pro' ),
		sprintf( __( 'Add one URL fragment per line, i.e. %s, to not cache pages that contain each URL fragment', 'wptouch-pro' ), '/support/' ),
		WPTOUCH_SETTING_BASIC,
		'3.1'
	);

	$settings_array_cdn[] = wptouch_add_setting(
		'radiolist',
		'cache_optimize_enable_cdn',
		__( 'Content Distribution Network', 'wptouch-pro' ),
		__( 'Using a content distribution network (CDN) can significantly enhance the responsiveness of your website.', 'wptouch-pro' ),
		WPTOUCH_SETTING_BASIC,
		'3.1',
		array(
			0 => __( 'Disabled', 'wptouch-pro' ),
			1 => __( 'Enabled', 'wptouch-pro' )
		)
	);

	for ( $i = 1; $i <= POWER_PACK_MAX_CDN_URL; $i++ ) {
		$settings_array_cdn[] = wptouch_add_setting(
			'text',
			'media_optimize_cdn_prefix_' . $i,
			sprintf( __( 'URL %d', 'wptouch-pro' ), $i ),
			sprintf( __( 'Add the URLs you have configured for your CDN, for example http://cdn%d.mysite.com. Add your domain for multisite as well.', 'wptouch-pro' ), $i ),
			WPTOUCH_SETTING_BASIC,
			'3.1'
		);

		$settings_array_cdn[] = wptouch_add_setting(
			'cdn_show',
			'media_optimize_cdn_prefix_' . $i
		);
	}

	$settings_array_images = array(
		wptouch_add_setting(
			'checkbox',
			'responsive_images_enable',
			__( 'Enable', 'wptouch-pro' ),
			'',
			WPTOUCH_SETTING_BASIC,
			'4.0'
		),
		wptouch_add_setting(
			'checkbox',
			'media_optimize_on_desktop',
			__( 'Make desktop images responsive', 'wptouch-pro' ),
			__( 'Applies srcset optimization to desktop theme as well as mobile theme.', 'wptouch-pro' ),
			WPTOUCH_SETTING_BASIC,
			'3.1'
		)
	);

	$settings_array_minification = array(
		wptouch_add_setting(
			'checkbox',
			'minification_css_enable',
			__( 'Enable CSS Minification', 'wptouch-pro' ),
			'',
			WPTOUCH_SETTING_BASIC,
			'4.0'
		),
		wptouch_add_setting(
			'checkbox',
			'minification_js_enable',
			__( 'Enable JS Minification', 'wptouch-pro' ),
			'',
			WPTOUCH_SETTING_BASIC,
			'4.0'
		)
	);

	wptouch_add_page_section(
		POWER_PACK_PAGENAME,
		__( 'Page Caching', 'wptouch-pro' ),
		'extension-power-pack-cache',
		$settings_array,
		$page_options,
		ADDON_SETTING_DOMAIN
	);

	wptouch_add_page_section(
		POWER_PACK_PAGENAME,
		__( 'Responsive Images', 'wptouch-pro' ),
		'extension-power-pack-responsive',
		$settings_array_images,
		$page_options,
		ADDON_SETTING_DOMAIN
	);

	wptouch_add_page_section(
		POWER_PACK_PAGENAME,
		__( 'Minification', 'wptouch-pro' ),
		'extension-power-pack-minification',
		$settings_array_minification,
		$page_options,
		ADDON_SETTING_DOMAIN
	);

	wptouch_add_page_section(
		POWER_PACK_PAGENAME,
		__( 'Distribution Network', 'wptouch-pro' ),
		'extension-power-pack-cdn',
		$settings_array_cdn,
		$page_options,
		ADDON_SETTING_DOMAIN
	);


	return $page_options;
}
