<?php
if (!class_exists('ARM_email_settings'))
{
	class ARM_email_settings
	{
		var $templates;
		var $isOptInsFeature;
		function __construct()
		{
			global $wpdb, $ARMember, $arm_slugs;
			$is_opt_ins_feature = get_option('arm_is_opt_ins_feature', 0);
			$this->isOptInsFeature = ($is_opt_ins_feature == '1') ? true : false;
			
			add_action('wp_ajax_arm_submit_email_template', array($this, 'arm_submit_email_template'));
			add_action('wp_ajax_arm_edit_template_data', array($this, 'arm_edit_template_data'));
			add_action('wp_ajax_arm_update_email_template_status', array($this, 'arm_update_email_template_status'));
			add_action('wp_ajax_arm_refresh_aweber', array($this, 'arm_refresh_aweber'));
			add_action('wp_ajax_arm_verify_mailchimp', array($this, 'arm_verify_mailchimp'));
			add_action('wp_ajax_arm_verify_sendinblue', array($this, 'arm_verify_sendinblue'));
			add_action('wp_ajax_arm_verify_mailerlite', array($this, 'arm_verify_mailerlite'));
			add_action('wp_ajax_arm_verify_constant', array($this, 'arm_verify_constant'));
			add_action('wp_ajax_arm_verify_getresponse', array($this, 'arm_verify_getresponse'));
			add_action('wp_ajax_arm_verify_madmimi', array($this, 'arm_verify_madmimi'));
			add_action('wp_ajax_arm_delete_mail_config', array($this, 'arm_delete_mail_config'));
			add_action('wp_ajax_arm_update_opt_ins_settings', array($this, 'arm_update_opt_ins_settings'));

			
			$this->templates = new stdClass;
			$this->templates->new_reg_user_admin = 'new-reg-user-admin';
			$this->templates->new_reg_user_with_payment = 'new-reg-user-with-payment';
			$this->templates->new_reg_user_without_payment = 'new-reg-user-without-payment';
			$this->templates->email_verify_user = 'email-verify-user';			
			$this->templates->account_verified_user = 'account-verified-user';
			$this->templates->change_password_user = 'change-password-user';	
			$this->templates->forgot_passowrd_user = 'forgot-passowrd-user';
			$this->templates->profile_updated_user = 'profile-updated-user';
                        $this->templates->profile_updated_notification_to_admin = 'profile-updated-notification-admin';
			$this->templates->grace_failed_payment = 'grace-failed-payment';
			$this->templates->grace_eot = 'grace-eot';
			$this->templates->failed_payment_admin = 'failed-payment-admin';
                        $this->templates->on_menual_activation = 'on-menual-activation';
		}


		function arm_redirect_aweber_url($verify_code_sent=0, $authorization_code='')
		{
			if((!empty($_REQUEST['arm_redirect_aweber']) && $_REQUEST['arm_redirect_aweber'] == 1) || (!empty($verify_code_sent) && !empty($authorization_code)) )
			{
				global $ARMember, $arm_capabilities_global,$arm_slugs;
				$ARMember->arm_check_user_cap($arm_capabilities_global['arm_manage_general_settings'], '1');

				$AUTHORIZE_URL = "https://auth.aweber.com/oauth2/authorize";
				$TOKEN_URL = "https://auth.aweber.com/oauth2/token";

				global $wpdb, $arfsiteurl, $MdlDb;

				$clientId = MEMBERSHIP_AWEBER_CLIENT_ID;

				$redirectUri = 'urn:ietf:wg:oauth:2.0:oob';

				if( empty( $verify_code_sent ) && empty( $authorization_code ) ){
					$verifierBytes = random_bytes(64);
					$codeVerifier = rtrim(strtr(base64_encode($verifierBytes), "+/", "-_"), "=");

					$challengeBytes = hash("sha256", $codeVerifier, true);
					$codeChallenge = rtrim(strtr(base64_encode($challengeBytes), "+/", "-_"), "=");

					update_option( 'arm_aweber_code_verifier', $codeVerifier );
					update_option( 'arm_aweber_code_challange', $codeChallenge );

					$state = uniqid();

					update_option( 'arm_aweber_state_code', $state );

					$scopes = array(
						"account.read",
						"list.read",
						"list.write",
						"subscriber.read",
						"subscriber.write",
						"email.read",
						"email.write",
						"subscriber.read-extended"
					);

					$authorizeQuery = array(
						"response_type" => "code",
						"client_id" => $clientId,
						"redirect_uri" => $redirectUri,
						"scope" => implode(" ",$scopes),
						"state" => $state,
						"code_challenge" => $codeChallenge,
						"code_challenge_method" => "S256"
					);

					header('location: ' . $AUTHORIZE_URL . "?" . http_build_query($authorizeQuery));
					die;
				}
				else if( !empty( $verify_code_sent ) )
				{
					$authorizationCode = !empty( $authorization_code ) ? $authorization_code : '';
					if( empty( $authorizationCode ) )
					{
						echo json_encode( array( 'error' => true, 'error_msg' => esc_html__('Authorization Code Not Found. Please re-authorize the Aweber and try again.', 'ARMember') ) );
						die;
					} 
					else 
					{
						$codeVerifier = get_option( 'arm_aweber_code_verifier' );
						if( empty( $codeVerifier ) )
						{
							echo json_encode( array( 'error' => true, 'error_msg' => esc_html__('Invalid Code. Please re-authorize the Aweber and try again by clicking on the "Get Authorize Code" button.', 'ARMember') ) );
							die;
						} 
						else 
						{
							$tokenQuery = array(
								"grant_type" => "authorization_code",
								"code" => $authorizationCode,
								"client_id" => $clientId,
								"code_verifier" => $codeVerifier,
							);
							$tokenUrl = $TOKEN_URL . "?" . http_build_query($tokenQuery);
							$response = wp_remote_post( $tokenUrl, array( 'timeout' => 45, ) );
							$body = $response['body'];
							$creds = json_decode($body, true);
							if( is_wp_error( $response ) || !empty($creds['error_description']))
							{
								echo json_encode( array( 'error' => true, 'error_msg' => esc_html__('Invalid Code. Please re-authorize the Aweber and try again by clicking on the "Get Authorize Code" button.', 'ARMember') ) );
								die;
							} 
							else 
							{
								$accessToken = $creds['access_token'];
								$refreshToken = $creds['refresh_token'];
								$expire_in = time() + $creds['expires_in'];

								set_transient( 'arm_aweber_access_token', $accessToken, $creds['expires_in'] );

								$acc_headers = array(
									'User-Agent' => 'AWeber-PHP-code-sample/1.0',
									'Accept' => 'application/json',
									'Authorization' => 'Bearer ' . $accessToken,
								);

								$acc_url = 'https://api.aweber.com/1.0/accounts';
								$acc_response = wp_remote_get( $acc_url, array( 'method' => 'GET', 'headers' => $acc_headers, 'timeout' => 5000 ) );

								$acc_response = json_decode($acc_response['body']);
								$acc_entries = $acc_response->entries;
								$acc_id = $acc_entries[0]->id;

								$advanced_list_data = array(
									'accessToken'   =>  $accessToken,
									'refreshToken'  =>  $refreshToken,
									'expires_in'     =>  $expire_in,
									'acc_id'        =>  $acc_id
								);

								update_option('arm_aweber_temp_credential',$advanced_list_data);

								$lists_url = "https://api.aweber.com/1.0/accounts/".$acc_id."/lists";

								$lists_response = wp_remote_get(
									$lists_url,
									array(
										'method' => 'GET', 
										'headers' => $acc_headers,
										'timeout' => 5000
									)
								);

								$lists_response = json_decode($lists_response['body']);
								$lists_entries = $lists_response->entries;

							
								return json_encode(
									array(
										'error' => false,
										'aweber_lists' => $lists_entries
									)
								);
							}
						}
					}
				}
			}			
		}

		function arm_get_email_template($temp_slug)
		{
			global $wpdb,$ARMember;
			$res = $wpdb->get_row( $wpdb->prepare("SELECT * FROM `".$ARMember->tbl_arm_email_templates."` WHERE `arm_template_slug`=%s",$temp_slug)); //phpcs:ignore --Reason $ARMember->tbl_arm_email_templates is a table name
			if (!empty($res)) {
				$res->arm_template_subject = isset($res->arm_template_subject) ? stripslashes($res->arm_template_subject) : '';
				$res->arm_template_content = isset($res->arm_template_content) ? stripslashes($res->arm_template_content) : '';
				return $res;
			}
			return false;
		}
		function arm_update_email_settings()
		{
			$arm_email_from_name = isset($_POST['arm_email_from_name']) ? sanitize_text_field($_POST['arm_email_from_name']) : ''; //phpcs:ignore
			$arm_email_from_email = isset($_POST['arm_email_from_email']) ? sanitize_email($_POST['arm_email_from_email']) : ''; //phpcs:ignore
			$arm_email_admin_email = isset($_POST['arm_email_admin_email']) ? sanitize_text_field($_POST['arm_email_admin_email']) : ''; //phpcs:ignore
			$server = isset($_POST['arm_email_server']) ? sanitize_text_field($_POST['arm_email_server']) : 'wordpress_server'; //phpcs:ignore

			$arm_mail_authentication = isset($_POST['arm_mail_authentication']) ? intval($_POST['arm_mail_authentication']) : '0'; //phpcs:ignore
			$smtp_mail_server = isset($_POST['arm_mail_server']) ? sanitize_text_field($_POST['arm_mail_server']) : '';//phpcs:ignore
			$smtp_mail_port = isset($_POST['arm_mail_port']) ? sanitize_text_field($_POST['arm_mail_port']) : '';//phpcs:ignore
			$smtp_mail_login_name = isset($_POST['arm_mail_login_name']) ? sanitize_text_field($_POST['arm_mail_login_name']) : '';//phpcs:ignore
			$smtp_mail_password = isset($_POST['arm_mail_password']) ? $_POST['arm_mail_password'] : ''; //phpcs:ignore
			$smtp_mail_enc = isset($_POST['arm_smtp_enc']) ? sanitize_text_field($_POST['arm_smtp_enc']) : 'none';//phpcs:ignore
			
			/** Google */
			$is_email_verified = isset($_POST['arm_gmail_verified_status']) ? sanitize_text_field( $_POST['arm_gmail_verified_status'] ) : '';//phpcs:ignore
			$old_settings = $this->arm_get_all_email_settings();
			$email_tools = (isset($old_settings['arm_email_tools'])) ? $old_settings['arm_email_tools'] : array();
			$email_tools['aweber']['consumer_key'] = '';
			$email_tools['aweber']['consumer_secret'] = '';
			$email_settings = array(
				'arm_email_from_name' => $arm_email_from_name,
				'arm_email_from_email' => $arm_email_from_email,
                                'arm_email_admin_email' => $arm_email_admin_email,
				'arm_email_server' => $server,
				'arm_mail_server' => $smtp_mail_server,
				'arm_mail_port' => $smtp_mail_port,
				'arm_mail_login_name' => $smtp_mail_login_name,
				'arm_mail_password' => $smtp_mail_password,
				'arm_smtp_enc' => $smtp_mail_enc,
				'arm_email_tools' => $email_tools,
				'arm_mail_authentication' => $arm_mail_authentication,
			);
			if($server == 'google_gmail' && $_POST['arm_gmail_verified_status'] == 1)//phpcs:ignore
			{
				$email_settings['arm_email_server'] = 'google_gmail';
				$email_settings['arm_google_client_id'] = isset($_POST['arm_google_client_id']) ? sanitize_text_field($_POST['arm_google_client_id']) : '';//phpcs:ignore
				$email_settings['arm_google_client_secret'] = isset($_POST['arm_google_client_secret']) ? sanitize_text_field($_POST['arm_google_client_secret']) : '';//phpcs:ignore
				$email_settings['arm_google_auth_url'] = isset($_POST['arm_google_auth_url']) ? sanitize_text_field($_POST['arm_google_auth_url']) : '';//phpcs:ignore
				$email_settings['arm_google_auth_token'] = isset($_POST['arm_google_auth_token']) ? sanitize_text_field($_POST['arm_google_auth_token']) : '';//phpcs:ignore
				$email_settings['arm_gmail_verified_status'] = isset($_POST['arm_gmail_verified_status']) ? intval($_POST['arm_gmail_verified_status']) : 0;//phpcs:ignore
				$email_settings['arm_google_connected_account'] = isset($_POST['arm_google_connected_account']) ? sanitize_text_field($_POST['arm_google_connected_account']) : '';//phpcs:ignore
				$email_settings['arm_google_auth_response'] = isset($_POST['arm_google_auth_response']) ? sanitize_textarea_field($_POST['arm_google_auth_response']) : '';//phpcs:ignore
			}
			update_option('arm_email_settings', $email_settings);
		}
		function arm_update_opt_ins_settings()
		{
			global $ARMember, $arm_capabilities_global;
			$response = array('type' => 'error', 'msg' => esc_html__('There is an error while updating opt-ins settings, please try again.', 'ARMember'));
			$posted_data = array_map( array( $ARMember, 'arm_recursive_sanitize_data'), $_POST ); //phpcs:ignore
			if (isset($posted_data['action']) && $posted_data['action'] == 'arm_update_opt_ins_settings') {
				$ARMember->arm_check_user_cap($arm_capabilities_global['arm_manage_general_settings'], '1'); //phpcs:ignore --Reason:Verifying nonce
				$email_settings = $this->arm_get_all_email_settings();
				$email_tools = (isset($posted_data['arm_email_tools'])) ? $posted_data['arm_email_tools'] : array();
				$old_email_tools = (isset($email_settings['arm_email_tools'])) ? $email_settings['arm_email_tools'] : array();
				if (isset($email_tools['aweber'])) {
					$email_tools['aweber']['temp'] = isset($old_email_tools['aweber']['temp']) ? $old_email_tools['aweber']['temp'] : array();
					$email_tools['aweber']['list'] = isset($old_email_tools['aweber']['list']) ? $old_email_tools['aweber']['list'] : array();
					$email_tools['aweber']['consumer_key'] = '';
					$email_tools['aweber']['consumer_secret'] = '';
				}
				if (isset($email_tools['mailchimp'])) {
					$email_tools['mailchimp']['list'] = isset($old_email_tools['mailchimp']['list']) ? $old_email_tools['mailchimp']['list'] : array();
				}
				if (isset($email_tools['constant'])) {
					$email_tools['constant']['list'] = isset($old_email_tools['constant']['list']) ? $old_email_tools['constant']['list'] : array();
				}
                if (isset($email_tools['getresponse'])) {
					$email_tools['getresponse']['list'] = isset($old_email_tools['getresponse']['list']) ? $old_email_tools['getresponse']['list'] : array();
				}
				if (isset($email_tools['madmimi'])) {
					$email_tools['madmimi']['list'] = isset($old_email_tools['madmimi']['list']) ? $old_email_tools['madmimi']['list'] : array();
				}
				if (isset($email_tools['mailerlite'])) {
					$email_tools['mailerlite']['list'] = isset($old_email_tools['mailerlite']['list']) ? $old_email_tools['mailerlite']['list'] : array();
				}
				if (isset($email_tools['sendinblue'])) {
					$email_tools['sendinblue']['list'] = isset($old_email_tools['sendinblue']['list']) ? $old_email_tools['sendinblue']['list'] : array();
				}
				$email_tools = apply_filters('arm_change_optin_settings_before_save', $email_tools);
				
				$email_settings['arm_email_tools'] = arm_array_map($email_tools);
				update_option('arm_email_settings', $email_settings);
                                
				do_action('arm_update_add_on_opt_in_settings', $_POST);//phpcs:ignore
				$response = array('type' => 'success', 'msg' => esc_html__('Opt-ins Settings Saved Successfully.', 'ARMember'));
			}
			echo json_encode($response);
			die();
		}
		function arm_refresh_aweber($authorization_code = '', $type = '')
		{
			global $wpdb, $ARMember, $arm_capabilities_global;
			$ARMember->arm_check_user_cap($arm_capabilities_global['arm_manage_general_settings'], '1'); //phpcs:ignore --Reason:Verifying nonce

			$email_settings = $this->arm_get_all_email_settings();
			$email_tools = (isset($email_settings['arm_email_tools'])) ? $email_settings['arm_email_tools'] : array();
			$statusRes = array('type' => 'error', 'msg' => esc_html__('Sorry, Something went wrong. Please try again.', 'ARMember'));
			$aweberListHtml = '';
			$authorization_code = (isset($_POST['consumer_key'])) ? sanitize_text_field($_POST['consumer_key']) : $authorization_code;//phpcs:ignore
			$arm_aweber_refresh_list = (isset($_POST['is_refresh'])) ? sanitize_text_field($_POST['is_refresh']) : '';//phpcs:ignore
			if( !empty( $authorization_code ) ){
				if(empty($arm_aweber_refresh_list))
				{
					$aweberLists = $this->arm_aweber_authorize_app( $authorization_code );
					if(!empty($aweberLists) && is_array($aweberLists))
					{
						$email_tools['aweber'] = array(
							'aweber_oauth_code'=>$authorization_code,
							'status' => 1,
							'list' => $aweberLists,
							'list_id' => $aweberLists[0]['id'],
						);
						$email_setttings['arm_email_tools'] = arm_array_map($email_tools);
						
						update_option('arm_email_settings', $email_setttings);
						$statusRes = array('type' => 'success', 'msg' => esc_html__('Settings has been verified.', 'ARMember'));
						foreach ($aweberLists as $list) {
							$aweberListHtml .= '<li data-label="' . esc_attr($list['name']) . '" data-value="' . esc_attr($list['id']) . '">' . esc_html($list['name']) . '</li>';
						}
					}
					else 
					{
						echo $aweberLists; //phpcs:ignore
						die;
					}
				}
				else
				{
					$aweberLists = $this->arm_aweber_refresh_list( $authorization_code);
					if(!empty($aweberLists) && is_array($aweberLists))
					{
						$get_email_list = get_option('arm_email_settings');
						$list_id = $get_email_list['arm_email_tools']['aweber']['list_id'];
						
						$email_tools['aweber'] = array(
							'aweber_oauth_code'=>$authorization_code,
							'status' => 1,
							'list' => $aweberLists,
							'list_id' => $list_id
						);
						$email_setttings['arm_email_tools'] = arm_array_map($email_tools);
						
						update_option('arm_email_settings', $email_setttings);
						$statusRes = array('type' => 'success', 'msg' => esc_html__('List Refreshed successfully.', 'ARMember'));
					}
					else 
					{
						echo $aweberLists; //phpcs:ignore
						die;
					}
				}
            } else {
                echo esc_html__('Authorization Code should not be empty', 'ARMember');
            }
			$statusRes['list'] = $aweberListHtml;
			if (isset($_POST['action']) && $_POST['action'] == 'arm_refresh_aweber') {//phpcs:ignore
				echo json_encode($statusRes);
				exit;
			} else {
				return $statusRes;
			}
		}
		function arm_aweber_refresh_token()
		{
			$clientId = MEMBERSHIP_AWEBER_CLIENT_ID;
			$email_settings = $this->arm_get_all_email_settings();
			$advanced_list_data = maybe_unserialize(get_option('arm_aweber_temp_credential'));
			$arm_aweber_refresh_token = !empty( $advanced_list_data['refreshToken'] ) ? $advanced_list_data['refreshToken'] : '';
            $arm_aweber_access_token = !empty( $advanced_list_data['accessToken'] ) ? $advanced_list_data['accessToken'] : '';           
			$tokenQuery = array(
				'client_id' => $clientId,
				'grant_type' => 'refresh_token',
				'refresh_token' => $arm_aweber_refresh_token,
			);
	
			$tokenUrl = "https://auth.aweber.com/oauth2/token?" . http_build_query($tokenQuery);            
			$response = wp_remote_post($tokenUrl);   
			if(!is_wp_error($response))
			{
				$body = $response['body'];            
				$newCreds = json_decode($body, true);
				do_action('arm_general_log_entry', 'aweber', 'Renewal Tockens response', 'armember', $body);
				$accessToken = $newCreds['access_token'];
				set_transient( 'arm_aweber_access_token', $accessToken, $newCreds['expires_in'] );                              

				$advanced_list_data = array(
					'accessToken'   =>  $newCreds['access_token'],
					'refreshToken'  =>  $newCreds['refresh_token'],
					'expires_in'     => $newCreds['expires_in'],
					'acc_id'        =>  $advanced_list_data['acc_id']
				);
				$email_settings['arm_email_tools']['aweber']['temp'] = $advanced_list_data;
				update_option('arm_aweber_temp_credential',$advanced_list_data);
				return $advanced_list_data;
			}
			else
			{
				return false;
			}
		}

		function arm_aweber_refresh_list($authorization_code){
			
			global $wpdb, $ARMember, $arm_capabilities_global;
			$ARMember->arm_check_user_cap($arm_capabilities_global['arm_manage_general_settings'], '1');
			
			$email_settings = $this->arm_get_all_email_settings();
			$advanced_list_data = maybe_unserialize(get_option('arm_aweber_temp_credential'));
			$arm_aweber_refresh_token = !empty( $advanced_list_data['refreshToken'] ) ? $advanced_list_data['refreshToken'] : '';
            $arm_aweber_access_token = !empty( $advanced_list_data['accessToken'] ) ? $advanced_list_data['accessToken'] : '';
			$statusRes = array('type' => 'error', 'msg' => esc_html__('Sorry, Something went wrong. Please try again.', 'ARMember'));
			if( $advanced_list_data['expires_in'] < time() ){
				$advanced_list_data = $this->arm_aweber_refresh_token();
            }
			$acc_id = $advanced_list_data['acc_id'];
			$acc_headers = array(
                'User-Agent' => 'AWeber-PHP-code-sample/1.0',
                'Accept' => 'application/json',
                'Authorization' => 'Bearer ' . $advanced_list_data['accessToken'],
			);

			$lists_url = "https://api.aweber.com/1.0/accounts/".$acc_id."/lists";

			$lists_response = wp_remote_get( $lists_url,
                array(
                    'method' => 'GET', 
                    'headers' => $acc_headers,
                    'timeout' => 5000
                )
            );
			if(!is_wp_error($lists_response))
			{
				$lists_response = json_decode($lists_response['body'],true);
				$aweber_lists = !empty( $lists_response['entries'] ) ? $lists_response['entries'] : array();
				return $aweber_lists;
			}
		}

		
		function arm_aweber_authorize_app($authorization_code)
		{
			$verify_code_sent = 1;
			$verify_code = $this->arm_redirect_aweber_url($verify_code_sent, $authorization_code);
			if( is_wp_error( $verify_code ) ){
				return esc_html__( 'Something went wrong while verifying Authorization', 'ARMember');
			} else {
				$response = json_decode( $verify_code, true );
				if( !empty( $response['aweber_lists']) ){
					return $response['aweber_lists'];
				} else if(!empty($response['error']) && $response['error'] == true) {
					return $response['msg'];
				}
				return $response;
			}
		}
		function arm_verify_mailchimp($api_key = '')
		{
			global $wpdb, $ARMember, $arm_capabilities_global;
			$ARMember->arm_check_user_cap($arm_capabilities_global['arm_manage_general_settings'], '1'); //phpcs:ignore --Reason:Verifying nonce
			$email_setttings = $this->arm_get_all_email_settings();
			$email_tools = (isset($email_setttings['arm_email_tools'])) ? $email_setttings['arm_email_tools'] : array();
			$mailchimpList = '';
			$statusRes = array('type' => 'error', 'msg' => esc_html__('Sorry, Something went wrong. Please try again.', 'ARMember'));
			$api_key = (isset($_POST['api_key'])) ? sanitize_text_field($_POST['api_key']) : $api_key;//phpcs:ignore
			if (!empty($api_key)) {
				$mailchimpResp = $this->arm_get_mailchimp_list($api_key);

				do_action('arm_general_log_entry', 'mailchimp', 'verify MailChimp list response', 'armember', $mailchimpResp);

				if ($mailchimpResp['type'] == 'error') {
					$statusRes = array('type' => 'error', 'msg' => $mailchimpResp['message']);
				} else {
					$lists = $mailchimpResp['list'];
					if (count($lists) > 0) {
						$email_tools['mailchimp'] = array(
							'api_key' => $api_key,
							'status' => 1,
							'list' => $lists,
							'list_id' => $lists[0]['id'],
						);
						$email_setttings['arm_email_tools'] = arm_array_map($email_tools);
						update_option('arm_email_settings', $email_setttings);
						$statusRes = array('type' => 'success', 'msg' => esc_html__('Settings has been verified.', 'ARMember'));
						foreach ($lists as $list) {
							$mailchimpList .= '<li data-label="' . esc_attr($list['name']) . '" data-value="' . esc_attr($list['id']) . '">' . esc_html($list['name']) . '</li>';
						}
					} else {
						$statusRes = array('type' => 'error', 'msg' => esc_html__('Mailchimp List Not Found.', 'ARMember'));
					}
				}
			}
			$statusRes['list'] = $mailchimpList;

			if (isset($_POST['action']) && $_POST['action'] == 'arm_verify_mailchimp') {//phpcs:ignore
				echo json_encode($statusRes);
				exit;
			} else {
				return $statusRes;
			}
		}
		function arm_get_mailchimp_list($api_key = '')
		{
			global $wpdb, $ARMember,$arm_global_settings, $arm_mcapi_version;
			$mailchimpList = array();
			$results = array('type' => 'error', 'message' => esc_html__('API Key is not valid.', 'ARMember'));
			if (!empty($api_key)) {
				$arm_mailchimp_dc = substr($api_key,strpos($api_key,'-')+1);
				$mailchimp_url = 'https://'.$arm_mailchimp_dc.'.api.mailchimp.com/'.$arm_mcapi_version.'/lists';
				// $mailchimp_url = $arm_global_settings->add_query_arg('apikey', $api_key, $mailchimp_url);
				$mailchimp_header = array(
					'headers' => array(
						'Authorization' => 'Bearer '.$api_key
					),
					'timeout' => '5000'
				);
				$mailchimp_url = $arm_global_settings->add_query_arg('count', '500', $mailchimp_url);

				$arm_mailchimp_response = wp_remote_get($mailchimp_url,$mailchimp_header);
				do_action('arm_general_log_entry', 'mailchimp', 'MailChimp list Get response', 'armember', $arm_mailchimp_response);
	            if( is_wp_error($arm_mailchimp_response) ){

	            } else {
	            	$arm_mailchimp_response_list = json_decode($arm_mailchimp_response['body'],true);
	            	$mailchimpLists = !empty($arm_mailchimp_response_list['lists']) ? $arm_mailchimp_response_list['lists'] : array();

					do_action('arm_general_log_entry', 'mailchimp', 'MailChimp list Get response List 2', 'armember', $arm_mailchimp_response_list);

					if(!empty($arm_mailchimp_response_list['status'])){
						$results = array('type' => 'error', 'message' => $arm_mailchimp_response_list['detail']);
					}
					else
					{
						if (count($mailchimpLists) > 0) {
							$i = 0;
							foreach ($mailchimpLists as $list) {
								$mailchimpList[$i]['id'] = $list['id'];
								$mailchimpList[$i]['name'] = $list['name'];
								$i++;
							}
							$results = array('type' => 'success', 'message' => '');
						}
					}

	            }
			}

			$results['list'] = $mailchimpList;
			return $results;
		}
		function arm_verify_constant($api_key = '', $access_token = '')
		{
			global $wpdb, $ARMember, $arm_capabilities_global;
			$ARMember->arm_check_user_cap($arm_capabilities_global['arm_manage_general_settings'], '1'); //phpcs:ignore --Reason:Verifying nonce
			$email_setttings = $this->arm_get_all_email_settings();
			$email_tools = (isset($email_setttings['arm_email_tools'])) ? $email_setttings['arm_email_tools'] : array();
			$constantList = '';
			$statusRes = array('type' => 'error', 'msg' => esc_html__('Sorry, Something went wrong. Please try again.', 'ARMember'));
			$api_key = (isset($_POST['api_key'])) ? sanitize_text_field($_POST['api_key']) : $api_key;//phpcs:ignore
			$access_token = (isset($_POST['access_token'])) ? sanitize_text_field($_POST['access_token']) : $access_token;//phpcs:ignore
			if (!empty($api_key) && !empty($access_token)) {
				$lists = $this->arm_get_constant_list($api_key, $access_token);

				do_action('arm_general_log_entry', 'constant', 'verify constant list response', 'armember', $lists);

				if (count($lists) > 0) {

					$email_tools['constant'] = array(
						'api_key' => $api_key,
						'access_token' => $access_token,
						'status' => 1,
						'list' => $lists,
						'list_id' => $lists[0]['id'],
					);
					$email_setttings['arm_email_tools'] = arm_array_map($email_tools);
					update_option('arm_email_settings', $email_setttings);
					$statusRes = array('type' => 'success', 'msg' => esc_html__('Settings has been verified.', 'ARMember'));
					foreach ($lists as $list) {
						$constantList .= '<li data-label="' . esc_attr($list['name']) . '" data-value="' . esc_attr($list['id']) . '">' . esc_attr($list['name']) . '</li>';
					}
				} else {
					$statusRes = array('type' => 'error', 'msg' => esc_html__('Constant Contact List Not Found.', 'ARMember'));
				}
			}
			$statusRes['list'] = $constantList;
			if (isset($_POST['action']) && $_POST['action'] == 'arm_verify_constant') {//phpcs:ignore
				echo json_encode($statusRes);
				exit;
			} else {
				return $statusRes;
			}
		}
		function arm_get_constant_list($api_key = '', $access_token = '')
		{
			global $wpdb, $ARMember;
			$constantList = array();
			if (!empty($api_key) && !empty($access_token)) {
				require_once(MEMBERSHIP_LIBRARY_DIR . '/constant_contact/list_contact.php');
				$lists = $cc->getLists($access_token);
				if (count($lists) > 0) {
					$i = 0;
					foreach ($lists as $list) {
						if(!empty($list->id)){
							$constantList[$i]['id'] = $list->id;
							$constantList[$i]['name'] = $list->name;
							$constantList[$i]['status'] = $list->status;
							$constantList[$i]['contact_count'] = $list->contact_count;
						}
						$i++;
					}
				}
			}
			return $constantList;
		}
		function arm_verify_getresponse($api_key = '')
		{
			global $wpdb, $ARMember, $arm_capabilities_global;
			$ARMember->arm_check_user_cap($arm_capabilities_global['arm_manage_general_settings'], '1'); //phpcs:ignore --Reason:Verifying nonce
			$email_setttings = $this->arm_get_all_email_settings();
			$email_tools = (isset($email_setttings['arm_email_tools'])) ? $email_setttings['arm_email_tools'] : array();
			$getresponseList = '';
			$statusRes = array('type' => 'error', 'msg' => esc_html__('Sorry, Something went wrong. Please try again.', 'ARMember'));
			$api_key = (isset($_POST['api_key'])) ? sanitize_text_field($_POST['api_key']) : $api_key;//phpcs:ignore
			if (!empty($api_key) ) {
				$lists = $this->arm_get_getresponse_list($api_key);

				do_action('arm_general_log_entry', 'getresponse', 'verify GetResponse list response', 'armember', $lists);

				if (count($lists) > 0) {
					$email_tools['getresponse'] = array(
						'api_key' => $api_key,
						'status' => 1,
						'list' => $lists,
						'list_id' => $lists[0]['id'],
					);
					$email_setttings['arm_email_tools'] = $email_tools;
					update_option('arm_email_settings', $email_setttings);
					$statusRes = array('type' => 'success', 'msg' => esc_html__('Settings has been verified.', 'ARMember'));
					foreach ($lists as $list) {
						$getresponseList .= '<li data-label="' . esc_attr($list['name']) . '" data-value="' . esc_attr($list['id']) . '">' . esc_html($list['name']) . '</li>';
					}
				} else {
					$statusRes = array('type' => 'error', 'msg' => esc_html__('GetResponse Contact List Not Found.', 'ARMember'));
				}
			}
			$statusRes['list'] = $getresponseList;
			if (isset($_POST['action']) && $_POST['action'] == 'arm_verify_getresponse') {//phpcs:ignore
				echo json_encode($statusRes);
				exit;
			} else {
				return $statusRes;
			}
		}
        function arm_get_getresponse_list($api_key = '')
        {
        	global $wpdb, $ARMember;
        	$getresponseList = array();
        	$arm_get_response_api_url = "https://api.getresponse.com/v3/campaigns";

        	$arm_get_response_header = array(
        		"X-Auth-Token" => "api-key ".$api_key,
        	);

        	$arm_get_response_body_params = array(
        		'timeout' => 15,
        		'headers' => $arm_get_response_header,
        	);

        	$arm_get_response_data = wp_remote_get($arm_get_response_api_url, $arm_get_response_body_params);

        	if(!is_wp_error($arm_get_response_data))
        	{
        		$arm_get_response_body_data = json_decode($arm_get_response_data['body']);
        		foreach($arm_get_response_body_data as $arm_get_response_body_key => $arm_get_response_body_val)
        		{
        			$arm_tmp_get_response_arr = array(
        				'id'   => $arm_get_response_body_val->name,
        				'name' => $arm_get_response_body_val->name,
        			);
        			array_push($getresponseList, $arm_tmp_get_response_arr);
        		}
        	}

        	return $getresponseList;
        }
        function arm_verify_madmimi($madmimi_email = '', $api_key = '')
        {
        	
            global $wpdb, $ARMember, $arm_capabilities_global;
            $ARMember->arm_check_user_cap($arm_capabilities_global['arm_manage_general_settings'], '1'); //phpcs:ignore --Reason:Verifying nonce
            $email_setttings = $this->arm_get_all_email_settings();

            $email_tools = (isset($email_setttings['arm_email_tools'])) ? $email_setttings['arm_email_tools'] : array();
            $madmimiList = '';
            $statusRes = array('type' => 'error', 'msg' => esc_html__('Sorry, Something went wrong. Please try again.', 'ARMember'));
            $madmimi_email = (isset($_POST['madmimi_email'])) ? sanitize_email($_POST['madmimi_email']) : sanitize_email($madmimi_email);//phpcs:ignore
            $api_key = (isset($_POST['api_key'])) ? sanitize_text_field($_POST['api_key']) : $api_key;//phpcs:ignore
           
            if (!empty($api_key) && !empty($madmimi_email)) {

                $lists = $this->arm_get_madmimi_list($madmimi_email, $api_key);

                do_action('arm_general_log_entry', 'madmimi', 'verify MadMimi list response', 'armember', $lists);

                if (count($lists) > 0) {
                    $email_tools['madmimi'] = array(
                        'api_key' => $api_key,
                        'email' => $madmimi_email,
                        'status' => 1,
                        'list' => $lists,
                        'list_id' => $lists[0]['id'],
                    );
                    $email_setttings['arm_email_tools'] = arm_array_map($email_tools);
                    update_option('arm_email_settings', $email_setttings);
                    $statusRes = array('type' => 'success', 'msg' => esc_html__('Settings has been verified.', 'ARMember'));
                    foreach ($lists as $list) {
                        $madmimiList .= '<li data-label="' . esc_attr($list['name']) . '" data-value="' . esc_attr($list['id']) . '">' . esc_html($list['name']) . '</li>';
                    }
                } else {
                    $statusRes = array('type' => 'error', 'msg' => esc_html__('Madmimi List Not Found.', 'ARMember'));
                }
            }
            $statusRes['list'] = $madmimiList;
            if (isset($_POST['action']) && $_POST['action'] == 'arm_verify_madmimi') {//phpcs:ignore
                echo json_encode($statusRes);
                exit;
            } else {
                return $statusRes;
            }
        }
        function arm_get_madmimi_list($madmimi_email = '', $api_key = '')
        {
            global $wpdb, $ARMember;
            $madmimiList = array();
            if (!empty($api_key) && !empty($madmimi_email)) {

                require_once(MEMBERSHIP_LIBRARY_DIR . '/madmimi/MadMimi.class.php');

                $mailer = new ARM_MadMimi($madmimi_email, $api_key);

                $string = $mailer->Lists(false);

                $xml = simplexml_load_string($string);
                
                $xml_array = $this->object2array($xml);
                
                foreach ($xml_array['list'] as $key => $value) {
                    $madmimiList[$key]['name'] = $value['@attributes']['name'];
                    $madmimiList[$key]['id'] = $value['@attributes']['id'];
                }

                
            }
            return $madmimiList;
        }
        function object2array($object) {

		    return @json_decode(@json_encode($object), 1);
		}
		function arm_verify_mailerlite($api_key = '')
        {
        	
            global $wpdb, $ARMember, $arm_capabilities_global;
            $ARMember->arm_check_user_cap($arm_capabilities_global['arm_manage_general_settings'], '1'); //phpcs:ignore --Reason:Verifying nonce
            $email_setttings = $this->arm_get_all_email_settings();

            $email_tools = (isset($email_setttings['arm_email_tools'])) ? $email_setttings['arm_email_tools'] : array();
            $mailerlitegroups_list = '';
            $statusRes = array('type' => 'error', 'msg' => esc_html__('Sorry, Something went wrong. Please try again.', 'ARMember'));
            $api_key = (isset($_POST['api_key'])) ? sanitize_text_field($_POST['api_key']) : $api_key;//phpcs:ignore
           
            if (!empty($api_key)) {

                $mailerlitegroups = $this->arm_get_mailerlite_groups($api_key);

                do_action('arm_general_log_entry', 'mailerlite', 'verify MailerLite Group response', 'armember', $mailerlitegroups);

                if (count($mailerlitegroups) > 0) {
                    $email_tools['mailerlite'] = array(
                        'api_key' => $api_key,
                        'status' => 1,
                        'list' => $mailerlitegroups,
                        'list_id' => $mailerlitegroups[0]['id'],
                    );
                    $email_setttings['arm_email_tools'] = arm_array_map($email_tools);
                    update_option('arm_email_settings', $email_setttings);
                    $statusRes = array('type' => 'success', 'msg' => esc_html__('Settings has been verified.', 'ARMember'));
                    
                    foreach ($mailerlitegroups as $mailerlitegroup) {

                        $mailerlitegroups_list .= '<li data-label="' . esc_attr($mailerlitegroup['name']) . '" data-value="' . esc_attr($mailerlitegroup['id']) . '">' . esc_html($mailerlitegroup['name']) . '</li>';
                    }

                } else {
                    $statusRes = array('type' => 'error', 'msg' => esc_html__('Mailerlite Group Not Found.', 'ARMember'));
                }
            }
            $statusRes['list'] = $mailerlitegroups_list;
            
            if (isset($_POST['action']) && $_POST['action'] == 'arm_verify_mailerlite') {//phpcs:ignore
                echo json_encode($statusRes);
                exit;
            } else {
                return $statusRes;
            }
        }
        
        function arm_get_mailerlite_groups($api_key = '')
        {
            global $wpdb, $ARMember;
            $mailerliteGroupsList = array();
            if (!empty($api_key)) {
            	
                require_once(MEMBERSHIP_LIBRARY_DIR . '/mailerlite/mailerlite_group_contact.php');

                $mailerlitegroups = $mailerlitegroupsApi->get();

				if (count($mailerlitegroups) > 0) {
					$i = 0;
					foreach ($mailerlitegroups as $mailerlitegroupslist) {
						if(!empty($mailerlitegroupslist->id)){
							$mailerliteGroupsList[$i]['id'] = $mailerlitegroupslist->id;
							$mailerliteGroupsList[$i]['name'] = $mailerlitegroupslist->name;
							$mailerliteGroupsList[$i]['active'] = $mailerlitegroupslist->active;
							$mailerliteGroupsList[$i]['total'] = $mailerlitegroupslist->total;
						}
						$i++;
					}
				}
                
            }
            return $mailerliteGroupsList;
        }
        function arm_verify_sendinblue($api_key = '')
		{
			global $wpdb, $ARMember, $arm_capabilities_global;
			$ARMember->arm_check_user_cap($arm_capabilities_global['arm_manage_general_settings'], '1'); //phpcs:ignore --Reason:Verifying nonce
			$email_setttings = $this->arm_get_all_email_settings();

			$email_tools = (isset($email_setttings['arm_email_tools'])) ? $email_setttings['arm_email_tools'] : array();
			$sendinblueList = '';
			$statusRes = array('type' => 'error', 'msg' => esc_html__('Sorry, Something went wrong. Please try again.', 'ARMember'));
			$api_key = (isset($_POST['api_key'])) ? sanitize_text_field($_POST['api_key']) : $api_key;//phpcs:ignore
					
			if (!empty($api_key)) {
				$sendinblueResp = $this->arm_get_sendinblue_list($api_key);

				do_action('arm_general_log_entry', 'sendinblue', 'verify Brevo List response', 'armember', $sendinblueResp);

				if ($sendinblueResp['type'] == 'error') {
					$statusRes = array('type' => 'error', 'msg' => $sendinblueResp['message']);
				} else {
					$lists = $sendinblueResp['list'];
					if (count($lists) > 0) {
						$email_tools['sendinblue'] = array(
							'api_key' => $api_key,
							'status' => 1,
							'list' => $lists,
							'list_id' => $lists[0]['id'],
						);
						$email_setttings['arm_email_tools'] = arm_array_map($email_tools);
						update_option('arm_email_settings', $email_setttings);
						$statusRes = array('type' => 'success', 'msg' => esc_html__('Settings has been verified.', 'ARMember'));
						foreach ($lists as $list) {
							$sendinblueList .= '<li data-label="' . esc_attr($list['name']) . '" data-value="' . esc_attr($list['id']) . '">' . esc_html($list['name']) . '</li>';
						}
					} else {
						$statusRes = array('type' => 'error', 'msg' => esc_html__('Brevo List Not Found.', 'ARMember'));
					}
				}
			}
			$statusRes['list'] = $sendinblueList;
			if (isset($_POST['action']) && $_POST['action'] == 'arm_verify_sendinblue') {//phpcs:ignore
				echo json_encode($statusRes);
				exit;
			} else {
				return $statusRes;
			}
		}

		function arm_get_sendinblue_list($api_key = '')
		{
			global $wpdb, $ARMember,$arm_global_settings, $arm_sbapi_version;
			$sendinblueList = array();
	     	$results = array('type' => 'error', 'message' => esc_html__('API Key is not valid.', 'ARMember'));
		
			if (!empty($api_key)) {
				$sendinblue_url = 'https://api.brevo.com/'.$arm_sbapi_version.'/contacts/lists?limit=50&offset=0&sort=desc';
				$arg =array(
						'timeout' => '5000',          
		                'headers' => array(
		                    'Content-Type' => 'application/json',
		                    'api-key' => $api_key,
		                )
		             );

				$arm_sendinblue_response = wp_remote_get($sendinblue_url,$arg);

	            if( !is_wp_error($arm_sendinblue_response)) {
	            
	            	$arm_sendinblue_response_list = json_decode($arm_sendinblue_response['body'],true);
	            	$sendinblueLists = !empty($arm_sendinblue_response_list['lists']) ? $arm_sendinblue_response_list['lists'] : array();
	            	if(!empty($sendinblueLists) && is_array($sendinblueLists))
	            	{
		            	if (count($sendinblueLists) > 0) 
		            	{
		            		$i = 0;
		            		foreach ($sendinblueLists as $list) {
		            			$sendinblueList[$i]['id'] = $list['id'];
		            			$sendinblueList[$i]['name'] = $list['name'];
		            			$i++;
		            		}
		            		$results = array('type' => 'success', 'message' => '');
		            	}
		            	else
			            {
			            	$results['message'] = esc_html__('Please create atleast one Brevo List.', 'ARMember');
			            }
		            }
	            }
			}

			$results['list'] = $sendinblueList;
			return $results;
		}

		function arm_delete_mail_config($id = '')
		{
			global $wpdb, $ARMember, $arm_capabilities_global;
			$ARMember->arm_check_user_cap($arm_capabilities_global['arm_manage_general_settings'], '1'); //phpcs:ignore --Reason:Verifying nonce
			$email_settings = $this->arm_get_all_email_settings();
			$email_tools = (isset($email_settings['arm_email_tools'])) ? $email_settings['arm_email_tools'] : array();
			$statusRes = array('type' => 'error', 'msg' => esc_html__('Sorry, Something went wrong. Please try again.', 'ARMember'));
			$id = (isset($_POST['id'])) ? sanitize_text_field($_POST['id']) : $id;//phpcs:ignore
			if (!empty($id)) {
				if ($id == 'aweber') {
					$email_tools['aweber'] = array(
						'consumer_key' => '',
						'consumer_secret' => '',
						'temp' => array(),
						'status' => 0,
						'list' => '',
						'list_id' => '',
					);
				}
				if ($id == 'mailchimp') {
					$email_tools['mailchimp'] = array(
						'api_key' => '',
						'status' => 0,
						'list' => '',
						'list_id' => '',
					);
				}
				if ($id == 'constant') {
					$email_tools['constant'] = array(
						'api_key' => '',
						'access_token' => '',
						'status' => 0,
						'list' => '',
						'list_id' => '',
					);
				}
                                if ($id == 'getresponse') {
					$email_tools['getresponse'] = array(
						'api_key' => '',
						'status' => 0,
						'list' => '',
						'list_id' => '',
					);
				}
				if ($id == 'madmimi') {
					$email_tools['madmimi'] = array(
						'api_key' => '',
						'email' => '',
						'status' => 0,
						'list' => '',
						'list_id' => '',
					);
				}
				if ($id == 'mailerlite') {
					$email_tools['mailerlite'] = array(
						'api_key' => '',
						'status' => 0,
						'list' => '',
						'list_id' => '',
					);
				}
				if ($id == 'sendinblue') {
					$email_tools['sendinblue'] = array(
						'api_key' => '',
						'status' => 0,
						'list' => '',
						'list_id' => '',
					);
				}
				$email_settings['arm_email_tools'] = arm_array_map($email_tools);
				update_option('arm_email_settings', $email_settings);
				$statusRes = array('type' => 'success', 'msg' => esc_html__('Settings has been verified.', 'ARMember'));
			}
			die();
		}
		function arm_get_optin_settings()
		{
			global $wpdb, $ARMember;
			$emailTools = array();
			if ($this->isOptInsFeature)
			{
				$email_settings = $this->arm_get_all_email_settings();
				if (isset($email_settings['arm_email_tools']) && !empty($email_settings['arm_email_tools'])) {
					$all_email_tools = $email_settings['arm_email_tools'];
					foreach ($all_email_tools as $tool => $et) {
						if (isset($et['status']) && $et['status'] == '1') {
							$emailTools[$tool] = $et;
						}
					}
				}
				$emailTools = apply_filters('arm_get_optin_settings', $emailTools, $email_settings);
			}
			return $emailTools;
		}
		function arm_get_all_email_settings()
		{
			global $wpdb;
			$email_settings_unser = get_option('arm_email_settings');
			$all_email_settings = maybe_unserialize($email_settings_unser);
			$all_email_settings = apply_filters('arm_get_all_email_settings', $all_email_settings);
			return $all_email_settings;
		}
		function arm_get_single_email_template($template_id, $fields = array())
		{
			global $wpdb, $ARMember;
			if ($template_id == '') {
				return false;
			}
			$select_fields = "*";
			if (is_array($fields) && !empty($fields)) {
				$select_fields = implode(',', $fields);
			}
			$res = $wpdb->get_row( $wpdb->prepare("SELECT $select_fields FROM `".$ARMember->tbl_arm_email_templates."` WHERE  `arm_template_id`=%d",$template_id) );//phpcs:ignore --Reason $ARMember->tbl_arm_email_templates is a table name
			if (!empty($res)) {
				if (!empty($res->arm_template_subject)) {
					$res->arm_template_subject = stripslashes($res->arm_template_subject);
				}
				if (!empty($res->arm_template_content)) {
					$res->arm_template_content = stripslashes($res->arm_template_content);
				}
				return $res;
			}
			return false;
		}
		function arm_get_all_email_template($field = array())
		{
			global $wpdb, $ARMember;
			if (is_array($field) && !empty($field)) {
				$field_name = implode(',', $field);
				$sql = "SELECT " . $field_name . " FROM `".$ARMember->tbl_arm_email_templates."` ORDER BY `arm_template_id` ASC ";
			} else {
				$sql = "SELECT * FROM `".$ARMember->tbl_arm_email_templates."` ORDER BY `arm_template_id` ASC ";
			}
			$results = $wpdb->get_results($sql);//phpcs:ignore --Reason Query is a select without where so no need to prepare
			if (!empty($results->arm_template_subject)) {
				$results->arm_template_subject = stripslashes($results->arm_template_subject);
			}
			if (!empty($results->arm_template_content)) {
				$results->arm_template_content = stripslashes($results->arm_template_content);
			}
			return $results;
		}
		function arm_edit_template_data()
		{
			global $wpdb, $ARMember, $arm_slugs, $arm_members_class, $arm_global_settings, $arm_email_settings, $arm_manage_coupons, $arm_manage_communication, $arm_capabilities_global;
			$return = array('status' => 'error');
			$ARMember->arm_check_user_cap($arm_capabilities_global['arm_manage_email_notifications'], '1'); //phpcs:ignore --Reason:Verifying nonce
			if (isset($_REQUEST['action']) && isset($_REQUEST['temp_id']) && $_REQUEST['temp_id'] != '') {
				$template_id = intval($_REQUEST['temp_id']);
				$temp_detail = $arm_email_settings->arm_get_single_email_template($template_id);
				if (!empty($temp_detail)) {
					$return = array(
						'status' => 'success',
						'id' => $template_id,
						'popup_heading' => esc_html(stripslashes($temp_detail->arm_template_name)),
						'arm_template_slug' => $temp_detail->arm_template_slug,
						'arm_template_subject' => esc_html(stripslashes($temp_detail->arm_template_subject)),
						'arm_template_content' => stripslashes($temp_detail->arm_template_content),
						'arm_template_status' => $temp_detail->arm_template_status,
					);
					$return = apply_filters('arm_email_attachment_file_outside',$return);
				}
			}
			echo json_encode($return);
			exit;
		}
		function arm_submit_email_template()
		{
			global $wpdb, $ARMember, $arm_capabilities_global;
			$ARMember->arm_check_user_cap($arm_capabilities_global['arm_manage_email_notifications'], '1'); //phpcs:ignore --Reason:Verifying nonce
			$response = array('type'=>'error', 'msg'=>esc_html__('Sorry, Something went wrong. Please try again.', 'ARMember'));
			if (!empty($_POST['arm_template_id']) && intval($_POST['arm_template_id']) != 0)//phpcs:ignore
			{
				$template_id = intval($_POST['arm_template_id']);//phpcs:ignore
				$arm_email_template_subject = (!empty($_POST['arm_template_subject'])) ? sanitize_text_field($_POST['arm_template_subject']) : '';//phpcs:ignore
				$arm_email_template_content = (!empty($_POST['arm_template_content'])) ? $_POST['arm_template_content'] : ''; //phpcs:ignore
				$arm_email_template_status = (!empty($_POST['arm_template_status'])) ? intval($_POST['arm_template_status']) : 0;//phpcs:ignore
				$temp_data = array(
					'arm_template_subject' => $arm_email_template_subject,
					'arm_template_content' => $arm_email_template_content,
					'arm_template_status' => $arm_email_template_status
				);
				$temp_data=apply_filters('arm_email_template_save_before',$temp_data,$_POST);//phpcs:ignore
				$update_temp = $wpdb->update($ARMember->tbl_arm_email_templates, $temp_data, array('arm_template_id' => $template_id));
				$response = array('type'=>'success', 'msg'=>esc_html__('Email Template Updated Successfully.', 'ARMember'));
			}
			echo json_encode($response);
			exit;
		}
		function arm_update_email_template_status($posted_data=array())
		{
			global $wpdb, $ARMember, $arm_capabilities_global;
			$ARMember->arm_check_user_cap($arm_capabilities_global['arm_manage_email_notifications'], '1'); //phpcs:ignore --Reason:Verifying nonce
			$response = array('type'=>'error', 'msg'=>esc_html__('Sorry, Something went wrong. Please try again.', 'ARMember'));
			if (!empty($_POST['arm_template_id']) && $_POST['arm_template_id'] != 0  && intval( $_POST['arm_template_id'] ) )//phpcs:ignore
			{
				$template_id = intval($_POST['arm_template_id']);//phpcs:ignore
				$arm_email_template_status = (!empty($_POST['arm_template_status'])) ? intval($_POST['arm_template_status']) : 0;//phpcs:ignore
				$temp_data = array(
					'arm_template_status' => $arm_email_template_status,
				);
				$update_temp = $wpdb->update($ARMember->tbl_arm_email_templates, $temp_data, array('arm_template_id' => $template_id));
				$response = array('type'=>'success', 'msg'=>esc_html__('Email Template Updated Successfully.', 'ARMember'));
			}
			echo json_encode($response);
			exit;
		}
		function arm_insert_default_email_templates()
		{
			global $wpdb, $ARMember;
			$default_email_template = $this->arm_default_email_templates();
			if (!empty($default_email_template)) {
				foreach ($default_email_template as $slug => $email_template) {
                    $oldTemp = $this->arm_get_email_template($slug);
                    if (!empty($oldTemp)) {
                        continue;
                    } else {
                        $email_template['arm_template_slug'] = $slug;
                        $email_template['arm_template_status'] = '1';
                        $ins = $wpdb->insert($ARMember->tbl_arm_email_templates, $email_template);
                    }
				}
			}
		}
		function arm_default_email_templates()
		{
			$temp_slugs = $this->templates;
			$email_templates = array(
				$temp_slugs->new_reg_user_admin => array(
					'arm_template_name' => 'Signup Completed Notification To Admin',
					'arm_template_subject' => 'New user registration at {ARM_BLOGNAME}',
					'arm_template_content' => '<p>Hello Administrator,</p><br><p>A new user has just registered at {ARM_BLOGNAME}. Here are some basic details of that newly registered user.</p><br><p>Firstname: {ARM_FIRST_NAME}</p><br><p>Lastname: {ARM_LAST_NAME}</p><br><p>Username: {ARM_USERNAME}</p><br><p>Email: {ARM_EMAIL}</p><br><p>To check further details of this user, please click on the following link:</p><br><p>{ARM_PROFILE_LINK}</p><br><br><p>Thank You</p><br><p>{ARM_BLOGNAME}</p>',
				),
				$temp_slugs->new_reg_user_with_payment => array(
					'arm_template_name' => 'Signup Completed (With Payment) Notification To User',
					'arm_template_subject' => 'Confirmation of your membership at {ARM_BLOGNAME}',
					'arm_template_content' => '<p>Hi {ARM_FIRST_NAME} {ARM_LAST_NAME},</p><br><p>Thank you for subscribing to the {ARM_PLAN} at {ARM_BLOGNAME}.</p><br><p>You can review and edit your membership details here:</p><br><p>{ARM_PROFILE_LINK}</p><br><p>Here is your latest payment information:</p><br><p>Paid With: {ARM_PAYMENT_GATEWAY}</p><br><p>Plan Name: {ARM_PLAN}</p><br><p>Plan Type: {ARM_PAYMENT_TYPE}</p><br><p>Amount: {ARM_PLAN_AMOUNT}</p><br><p>Transaction Id: {ARM_TRANSACTION_ID}</p><br><p>Have a nice day!</p>',
				),
				$temp_slugs->new_reg_user_without_payment => array(
					'arm_template_name' => 'Signup Completed (Without Payment) Notification To User',
					'arm_template_subject' => 'Confirmation of your membership at {ARM_BLOGNAME}',
					'arm_template_content' => '<p>Hi {ARM_FIRST_NAME} {ARM_LAST_NAME},</p><br><p>Thank you for subscribing to the {ARM_PLAN} at {ARM_BLOGNAME}.</p><br><p>You can review and edit your membership details here:</p><br><p>{ARM_PROFILE_LINK}</p><br><p>Have a nice day!</p>',
				),
				$temp_slugs->email_verify_user => array(
					'arm_template_name' => 'Email Verification',
					'arm_template_subject' => 'Email verification at {ARM_BLOGNAME}',
					'arm_template_content' => '<p>Hi {ARM_FIRST_NAME} {ARM_LAST_NAME},</p><br><p>You must confirm/validate your email account before logging in.</p><br><p>Please click on the following link to  activate your account:</p><br><p>{ARM_VALIDATE_URL}</p><br><p>Have a nice day!</p>',
				),
				$temp_slugs->account_verified_user => array(
					'arm_template_name' => 'Email Verified',
					'arm_template_subject' => 'Email verified successfully at {ARM_BLOGNAME}',
					'arm_template_content' => '<p>Hi {ARM_FIRST_NAME} {ARM_LAST_NAME},</p><br><p>Your account is now verified at {ARM_BLOGNAME}.</p><br><p>Have a nice day!</p>',
				),
				$temp_slugs->change_password_user => array(
					'arm_template_name' => 'Change Password',
					'arm_template_subject' => 'Your password has been changed at {ARM_BLOGNAME}',
					'arm_template_content' => '<p>Hi {ARM_FIRST_NAME} {ARM_LAST_NAME},</p><br><p>Your Password has been changed.</p><br><p>To login please fill out your credentials on:</p><br><p>{ARM_LOGIN_URL}</p><br><p>Your Username: {ARM_USERNAME}</p><br><p>Have a nice day!</p>',
				),
				$temp_slugs->forgot_passowrd_user => array(
					'arm_template_name' => 'Forgot Password',
					'arm_template_subject' => 'Reset password request at {ARM_BLOGNAME}',
					'arm_template_content' => '<p>Hi {ARM_FIRST_NAME} {ARM_LAST_NAME},</p><br><p>Someone requested that the password be reset for the following account: {ARM_BLOG_URL}</p><br><p>Username: {ARM_USERNAME},</p><br><p>If this was a mistake, just ignore this email and nothing will happen.</p><br><p>To reset your password, visit the following address:{ARM_RESET_PASSWORD_LINK}</p><br><p>If you have any problems, please contact us at {ARM_ADMIN_EMAIL}.</p>',
				),
				$temp_slugs->profile_updated_user => array(
					'arm_template_name' => 'Profile Updated',
					'arm_template_subject' => 'Your account has been updated at {ARM_BLOGNAME}',
					'arm_template_content' => '<p>Hi {ARM_FIRST_NAME} {ARM_LAST_NAME},</p><br><p>Your account has been updated.</p><br><p>To visit your profile page follow the next link:</p><br>
<p>{ARM_PROFILE_LINK}</p><br><p>Have a nice day!</p>',
				),
                                $temp_slugs->profile_updated_notification_to_admin => array(
					'arm_template_name' => 'Profile Updated Notification To Admin',
					'arm_template_subject' => 'Account of {ARM_USERNAME} has been updated at {ARM_BLOGNAME}',
					'arm_template_content' => '<p>Hello Administrator,</p><br><p>An account has been updated at {ARM_BLOGNAME}. Here are some basic details of that updated user.</p><br><p>Firstname: {ARM_FIRST_NAME}</p><br><p>Lastname: {ARM_LAST_NAME}</p><br><p>Username: {ARM_USERNAME}</p><br><p>Email: {ARM_EMAIL}</p><br><br><p>Thank You</p><br><p>Have a nice day!</p>',
				),
				$temp_slugs->grace_failed_payment => array(
					'arm_template_name' => 'Grace Period For Failed Payment',
					'arm_template_subject' => 'Reminder for failed payment at {ARM_BLOGNAME}',
					'arm_template_content' => '<p>Hi {ARM_FIRST_NAME} {ARM_LAST_NAME},</p><br><p>Unfortunately your recurring payment for {ARM_PLAN} at {ARM_BLOGNAME} has not succeeded for some reason.</p><br><p>Here are some payment details:</p><br><p>Paid With: {ARM_PAYMENT_GATEWAY}</p><br><p>Amount: {ARM_PLAN_AMOUNT}</p><br><p>Please contact the payment service provider about this.</p><br><p><strong>Note: </strong>If you do not take appropriate action within {ARM_GRACE_PERIOD_DAYS} days, than any current membership may lapse.</p><br><p>If you have any further queries, feel free to contact us at {ARM_BLOGNAME}</p><br><p>Have a nice day!</p>',
				),
				$temp_slugs->grace_eot => array(
					'arm_template_name' => 'User Enters Grace Period Notification',
					'arm_template_subject' => 'Reminder for membership expiration at {ARM_BLOGNAME}',
					'arm_template_content' => '<p>Hi {ARM_FIRST_NAME} {ARM_LAST_NAME},</p><br><p>Your {ARM_PLAN} membership has just expired.</p><br><p>But you can still access our website without any problem,</p><br><p>If you want to renew/update your membership plan, than please click on the following link:</p><br><p>{ARM_BLOG_URL}</p><br><p><strong>Note: </strong>If you do not renew/change your membership within {ARM_GRACE_PERIOD_DAYS} days, than the relevant action will be performed by system.</p><br><p>Have a nice day!</p>',
				),
				$temp_slugs->failed_payment_admin => array(
					'arm_template_name' => 'Failed Payment Notification To Admin',
					'arm_template_subject' => 'Reminder for failed payment at {ARM_BLOGNAME}',
					'arm_template_content' => '<p>Hello Administrator,</p><br><p>This is a reminder that the following member\'s recurring payment for {ARM_PLAN} membership has failed for some reason at {ARM_BLOGNAME}</p><br><p>Here are some details.</p><br><p>Username: {ARM_USERNAME}</p><br><p>Email: {ARM_EMAIL}</p><br><p>Paid With: {ARM_PAYMENT_GATEWAY}</p><br><p>Amount: {ARM_PLAN_AMOUNT}</p><br><p>Please take appropriate action.</p><br><p>Thank You.</p><br>',
				),
                                $temp_slugs->on_menual_activation => array(
					'arm_template_name' => 'Manual User Activation',
					'arm_template_subject' => 'Your account has been activated at {ARM_BLOGNAME}',
					'arm_template_content' => '<p>Hi {ARM_FIRST_NAME} {ARM_LAST_NAME},</p><br><p>Your Account has been activated.</p><br><p> Please click on the following link:</p><br><p>{ARM_BLOG_URL}</p><br><p>Have a nice day!</p>',
				),
			);
			$email_templates = apply_filters('arm_default_email_templates', $email_templates);
			return $email_templates;
		}
	}
}
global $arm_email_settings;
$arm_email_settings = new ARM_email_settings();