<?php
	global $wpdb, $ARMember, $arm_global_settings, $arm_payment_gateways;
	$payment_gateways = $arm_payment_gateways->arm_get_all_payment_gateways_for_setup();
	$arm_common_date_format = $arm_global_settings->arm_check_common_date_format(get_option('date_format'));
	$arm_default_date = date_i18n($arm_common_date_format);
?>

<div class="arm_global_settings_main_wrapper">
	<div class="page_sub_content">
		<div class="arm_debug_container">
			<form id="arm_debug_form" method="POST" action="#" id="" enctype="multipart/form-data" class="arm_admin_form">
				<div class="page_sub_title"><?php esc_html_e('Payment Gateway Debug Log Settings', 'ARMember'); ?></div>
				<div class="armclear"></div>
				<table class="form-table">
					<?php
						foreach($payment_gateways as $payment_gateway_key => $payment_gateway_val)
						{
							$arm_gateway_name = $payment_gateway_val['gateway_name'];
							$arm_debug_logs = (!empty($payment_gateway_val['payment_debug_logs']) && $payment_gateway_val['payment_debug_logs'] == '1') ? 'checked="checked"' : '';
					?>
							<tr class="form-field">
								<th class="arm-form-table-label"><?php echo esc_attr($arm_gateway_name); ?></th>
								<td class="arm-form-table-content">
									<div class="armswitch arm_payment_setting_switch">
										<input type="checkbox" id="arm_<?php echo strtolower( esc_attr($arm_gateway_name) );//phpcs:ignore?>_debug_log" <?php echo esc_attr($arm_debug_logs);?> value="1" class="armswitch_input arm_debug_mode_switch" name="payment_gateway_settings[<?php echo strtolower( esc_attr($payment_gateway_key) ); //phpcs:ignore?>][debug_log]" data-switch_key="<?php echo strtolower( esc_attr($payment_gateway_key) ); //phpcs:ignore?>"/>
										<label for="arm_<?php echo strtolower( esc_attr($arm_gateway_name) ); //phpcs:ignore?>_debug_log" class="armswitch_label"></label>
									</div>
									<?php 
										if(!empty($arm_debug_logs)){
									?>
											<div class="arm_debug_switch_<?php echo esc_attr($payment_gateway_key); ?>  arm_debug_log_action_container" >
									<?php
										} else {
									?>
											<div class="arm_debug_switch_<?php echo esc_attr($payment_gateway_key); ?> arm_debug_log_action_container" style="display: none;">
									<?php
										}
									?>
										<a href="javascript:void(0)" onclick="arm_view_payment_debug_logs('<?php echo esc_attr($payment_gateway_key); ?>', '<?php echo esc_attr($arm_gateway_name); ?>')"><?php esc_html_e('View Log', 'ARMember'); ?></a>
										<a href="javascript:void(0)" class="arm_margin_left_10" onclick="arm_download_payment_debug_logs('<?php echo esc_attr($payment_gateway_key); ?>')">
											<?php esc_html_e('Download Log', 'ARMember'); ?>
										</a>
										<div class='arm_confirm_box arm_download_confirm_box' id='arm_download_confirm_box_<?php echo esc_attr($payment_gateway_key); ?>'>
											<div class='arm_confirm_box_body'>
												<div class='arm_confirm_box_arrow'></div>
												<div class='arm_confirm_box_text'>
													<div class="arm_download_duration_selection">
														<label class="arm_select_duration_label"><?php esc_html_e('Select log duration to download', 'ARMember'); ?></label>
														<input type="hidden" id="arm_download_duration" name="action1" value="7" />
														<dl class="arm_selectbox column_level_dd arm_width_280">
															<dt>
																<span><?php esc_html_e('Last 1 Week','ARMember');?></span>
																<input type="text" style="display:none;" value="" class="arm_autocomplete"  /><i class="armfa armfa-caret-down armfa-lg"></i>
															</dt>
															<dd>
																<ul data-id="arm_download_duration">
																	<li data-label="<?php esc_attr_e('Last 1 Day', 'ARMember');?>" data-value="1"><?php esc_html_e('Last 1 Day', 'ARMember');?></li>

																	<li data-label="<?php esc_attr_e('Last 3 Days', 'ARMember');?>" data-value="3"><?php esc_html_e('Last 3 Days', 'ARMember');?></li>

																	<li data-label="<?php esc_attr_e('Last 1 Week','ARMember');?>" data-value="7"><?php esc_html_e('Last 1 Week','ARMember');?></li>

																	<li data-label="<?php esc_attr_e('Last 2 Weeks', 'ARMember');?>" data-value="15"><?php esc_html_e('Last 2 Weeks', 'ARMember');?></li>

																	<li data-label="<?php esc_attr_e('Last Month', 'ARMember');?>" data-value="30"><?php esc_html_e('Last Month', 'ARMember');?></li>

																	<li data-label="<?php esc_attr_e('All', 'ARMember');?>" data-value="all"><?php esc_html_e('All', 'ARMember');?></li>

																	<li data-label="<?php esc_attr_e('Custom', 'ARMember');?>" data-value="custom"><?php esc_html_e('Custom', 'ARMember');?></li>
																</ul>
															</dd>
														</dl>
													</div>
													<form id="arm_download_custom_duration_<?php echo esc_attr($payment_gateway_key); ?>_form">
														<div class="arm_download_custom_duration_div">
											                <div class="arm_datatable_filter_item arm_margin_left_0" >
											                    <input type="text" name="arm_filter_pstart_date" id="arm_filter_pstart_date" class="arm_download_custom_duration_date" placeholder="<?php esc_attr_e('Start Date', 'ARMember'); ?>" data-date_format="<?php echo esc_attr($arm_common_date_format); ?>" value="<?php echo esc_attr($arm_default_date); ?>" />
											                </div>
											                <div class="arm_datatable_filter_item">
											                    <input type="text" name="arm_filter_pend_date" id="arm_filter_pend_date" class="arm_download_custom_duration_date" placeholder="<?php esc_attr_e('End Date', 'ARMember'); ?>" data-date_format="<?php echo esc_attr($arm_common_date_format); ?>" value="<?php echo esc_attr($arm_default_date); ?>" />
											                </div>
										            	</div>
										            </form>
													<button type='button' class='arm_confirm_box_btn armemailaddbtn arm_download_debug_log_btn' data-selected_key='<?php echo esc_attr($payment_gateway_key); ?>'><?php esc_html_e('Download', 'ARMember'); ?></button>
												</div>
											</div>
										</div>
										<a href="javascript:void(0)" class="arm_clear_debug_log arm_margin_left_10" onclick="arm_clear_payment_debug_logs('<?php echo esc_attr($payment_gateway_key); ?>')" ><?php esc_html_e('Clear Log', 'ARMember'); ?></a>
										<?php
											$arm_debug_clear_log = $arm_global_settings->arm_get_confirm_box($payment_gateway_key, esc_html__("Are you sure you want to clear debug logs?", 'ARMember'), 'arm_clear_debug_log');
											echo $arm_debug_clear_log; //phpcs:ignore
										?>
									</div>
								</td>
							</tr>
					<?php
						}

						$arm_add_new_debug_log_gateway = "";
						$arm_add_new_debug_log_gateway = apply_filters('arm_add_payment_debug_log_field', $arm_add_new_debug_log_gateway, $payment_gateways);
						echo $arm_add_new_debug_log_gateway; //phpcs:ignore
					?>
				</table>
				<?php $nonce=wp_create_nonce('arm_wp_nonce');?>
				<input type="hidden" name='arm_wp_nonce' value="<?php echo esc_attr($nonce)?>"/>
				<?php 
					if($arm_email_settings->isOptInsFeature)
					{
						$arm_is_optins_log_enabled = get_option('arm_optins_debug_log');
						$arm_optins_debug_log = ($arm_is_optins_log_enabled) ? 'checked=checked' : '';
				?>
						<br>
						<div class="page_sub_title"><?php esc_html_e('Opt-ins Debug Log Settings', 'ARMember'); ?></div>
						<div class="armclear"></div>
						<table class="form-table">
							<tr class="form-field">
								<th class="arm-form-table-label"><?php esc_html_e('Enable Opt-ins Debug Logs', 'ARMember'); ?></th>
								<td class="arm-form-table-content">
									<div class="armswitch arm_payment_setting_switch">
										<input type="checkbox" id="arm_optins_debug_log" <?php echo esc_attr($arm_optins_debug_log); ?> value="1" class="armswitch_input arm_debug_mode_switch" name="arm_optins_debug_log" data-switch_key="optins"/>
										<label for="arm_optins_debug_log" class="armswitch_label"></label>
									</div>
									<div class="arm_debug_switch_optins arm_debug_log_action_container" style=" <?php if(empty($arm_optins_debug_log)) { echo "display:none;"; } ?>">

										<a href="javascript:void(0)" onclick="arm_view_general_debug_logs('optins', 'All')"><?php esc_html_e('View Log', 'ARMember'); ?></a>
										<a href="javascript:void(0)" onclick="arm_download_general_debug_logs('optins')" class="arm_margin_left_10"><?php esc_html_e('Download Log', 'ARMember'); ?></a>
										<div class='arm_confirm_box arm_general_debug_download_confirm_box' id='arm_general_debug_download_confirm_box_optins'>
											<div class='arm_confirm_box_body'>
												<div class='arm_confirm_box_arrow'></div>
												<div class='arm_confirm_box_text'>
													<div class="arm_download_duration_selection">
														<label class="arm_select_duration_label"><?php esc_html_e('Select log duration to download', 'ARMember'); ?></label>
														<input type="hidden" id="arm_general_download_duration" name="action1" value="7" />
														<dl class="arm_selectbox column_level_dd arm_width_280">
															<dt>
																<span><?php esc_html_e('Last 1 Week','ARMember');?></span>
																<input type="text" style="display:none;" value="" class="arm_autocomplete"  /><i class="armfa armfa-caret-down armfa-lg"></i>
															</dt>
															<dd>
																<ul data-id="arm_general_download_duration">
																	<li data-label="<?php esc_attr_e('Last 1 Day', 'ARMember');?>" data-value="1"><?php esc_html_e('Last 1 Day', 'ARMember');?></li>

																	<li data-label="<?php esc_attr_e('Last 3 Days', 'ARMember');?>" data-value="3"><?php esc_html_e('Last 3 Days', 'ARMember');?></li>

																	<li data-label="<?php esc_attr_e('Last 1 Week','ARMember');?>" data-value="7"><?php esc_html_e('Last 1 Week','ARMember');?></li>

																	<li data-label="<?php esc_attr_e('Last 2 Weeks', 'ARMember');?>" data-value="15"><?php esc_html_e('Last 2 Weeks', 'ARMember');?></li>

																	<li data-label="<?php esc_attr_e('Last Month', 'ARMember');?>" data-value="30"><?php esc_html_e('Last Month', 'ARMember');?></li>

																	<li data-label="<?php esc_attr_e('All', 'ARMember');?>" data-value="all"><?php esc_html_e('All', 'ARMember');?></li>

																	<li data-label="<?php esc_attr_e('Custom', 'ARMember');?>" data-value="custom"><?php esc_html_e('Custom', 'ARMember');?></li>
																</ul>
															</dd>
														</dl>
													</div>
													<form id="arm_general_debug_download_custom_duration_optins_form">
														<div class="arm_download_custom_duration_div">
											                <div class="arm_datatable_filter_item arm_margin_left_0" >
											                    <input type="text" name="arm_filter_pstart_date" id="arm_filter_pstart_date" class="arm_download_custom_duration_date" placeholder="<?php esc_attr_e('Start Date', 'ARMember'); ?>" data-date_format="<?php echo esc_attr($arm_common_date_format); ?>" value="<?php echo esc_attr($arm_default_date); ?>" />
											                </div>
											                <div class="arm_datatable_filter_item">
											                    <input type="text" name="arm_filter_pend_date" id="arm_filter_pend_date" class="arm_download_custom_duration_date" placeholder="<?php esc_attr_e('End Date', 'ARMember'); ?>" data-date_format="<?php echo esc_attr($arm_common_date_format); ?>" value="<?php echo esc_attr($arm_default_date); ?>" />
											                </div>
										            	</div>
										            </form>
													<button type='button' class='arm_confirm_box_btn armemailaddbtn arm_download_general_debug_log_btn' data-selected_key='optins'><?php esc_html_e('Download', 'ARMember'); ?></button>
												</div>
											</div>
										</div>
										<a href="javascript:void(0)" class="arm_clear_debug_log arm_margin_left_10" onclick="arm_clear_general_debug_logs('optins')" ><?php esc_html_e('Clear Log', 'ARMember'); ?></a>
										<?php
											$arm_debug_clear_log = $arm_global_settings->arm_get_confirm_box('optins', esc_html__("Are you sure you want to clear debug logs?", 'ARMember'), 'arm_clear_debug_log');
											echo $arm_debug_clear_log; //phpcs:ignore
										?>
									</div>
								</td>
							</tr>

						<?php
							$arm_general_debug_log_details = "";
							$arm_general_debug_log_details = apply_filters('arm_add_general_debug_log_details', $arm_general_debug_log_details);
						?>
						</table>
				<?php
					}
				?>
				<br>
				<div class="page_sub_title"><?php esc_html_e('Cron Debug Log Settings', 'ARMember'); ?></div>
				<div class="armclear"></div>
				<table class="form-table">
					<?php
						$arm_is_cron_log_enabled = get_option('arm_cron_debug_log');
						$arm_cron_debug_log = ($arm_is_cron_log_enabled) ? 'checked=checked' : '';
					?>
					<tr class="form-field">
						<th class="arm-form-table-label"><?php esc_html_e('Enable Cron Debug Logs', 'ARMember'); ?></th>
						<td class="arm-form-table-content">
							<div class="armswitch arm_payment_setting_switch">
								<input type="checkbox" id="arm_cron_debug_log" <?php echo esc_attr($arm_cron_debug_log); ?> value="1" class="armswitch_input arm_debug_mode_switch" name="arm_cron_debug_log" data-switch_key="cron"/>
								<label for="arm_cron_debug_log" class="armswitch_label"></label>
							</div>
							<?php
								if(!empty($arm_cron_debug_log)){
							?>
									<div class="arm_debug_switch_cron arm_debug_log_action_container">
							<?php
								} else {
							?>
									<div class="arm_debug_switch_cron arm_debug_log_action_container" style="display: none;">
							<?php
								}
							?>
								<a href="javascript:void(0)" onclick="arm_view_general_debug_logs('cron', 'Cron')"><?php esc_html_e('View Log', 'ARMember'); ?></a>
								<a href="javascript:void(0)" onclick="arm_download_general_debug_logs('cron')" class="arm_margin_left_10"><?php esc_html_e('Download Log', 'ARMember'); ?></a>
								<div class='arm_confirm_box arm_general_debug_download_confirm_box' id='arm_general_debug_download_confirm_box_cron'>
									<div class='arm_confirm_box_body'>
										<div class='arm_confirm_box_arrow'></div>
										<div class='arm_confirm_box_text'>
											<div class="arm_download_duration_selection">
												<label class="arm_select_duration_label"><?php esc_html_e('Select log duration to download', 'ARMember'); ?></label>
												<input type="hidden" id="arm_general_download_duration" name="action1" value="7" />
												<dl class="arm_selectbox column_level_dd arm_width_280">
													<dt>
														<span><?php esc_html_e('Last 1 Week','ARMember');?></span>
														<input type="text" style="display:none;" value="" class="arm_autocomplete"  /><i class="armfa armfa-caret-down armfa-lg"></i>
													</dt>
													<dd>
														<ul data-id="arm_general_download_duration">
															<li data-label="<?php esc_attr_e('Last 1 Day', 'ARMember');?>" data-value="1"><?php esc_html_e('Last 1 Day', 'ARMember');?></li>

															<li data-label="<?php esc_attr_e('Last 3 Days', 'ARMember');?>" data-value="3"><?php esc_html_e('Last 3 Days', 'ARMember');?></li>

															<li data-label="<?php esc_attr_e('Last 1 Week','ARMember');?>" data-value="7"><?php esc_html_e('Last 1 Week','ARMember');?></li>

															<li data-label="<?php esc_attr_e('Last 2 Weeks', 'ARMember');?>" data-value="15"><?php esc_html_e('Last 2 Weeks', 'ARMember');?></li>

															<li data-label="<?php esc_attr_e('Last Month', 'ARMember');?>" data-value="30"><?php esc_html_e('Last Month', 'ARMember');?></li>

															<li data-label="<?php esc_attr_e('All', 'ARMember');?>" data-value="all"><?php esc_html_e('All', 'ARMember');?></li>

															<li data-label="<?php esc_attr_e('Custom', 'ARMember');?>" data-value="custom"><?php esc_html_e('Custom', 'ARMember');?></li>
														</ul>
													</dd>
												</dl>
											</div>
											<form id="arm_general_debug_download_custom_duration_cron_form">
												<div class="arm_download_custom_duration_div">
									                <div class="arm_datatable_filter_item arm_margin_left_0">
									                    <input type="text" name="arm_filter_pstart_date" id="arm_filter_pstart_date" class="arm_download_custom_duration_date" placeholder="<?php esc_attr_e('Start Date', 'ARMember'); ?>" data-date_format="<?php echo esc_attr($arm_common_date_format); ?>" value="<?php echo esc_attr($arm_default_date); ?>" />
									                </div>
									                <div class="arm_datatable_filter_item">
									                    <input type="text" name="arm_filter_pend_date" id="arm_filter_pend_date" class="arm_download_custom_duration_date" placeholder="<?php esc_attr_e('End Date', 'ARMember'); ?>" data-date_format="<?php echo esc_attr($arm_common_date_format); ?>" value="<?php echo esc_attr($arm_default_date); ?>" />
									                </div>
								            	</div>
								            </form>
											<button type='button' class='arm_confirm_box_btn armemailaddbtn arm_download_general_debug_log_btn' data-selected_key='cron'><?php esc_html_e('Download', 'ARMember'); ?></button>
										</div>
									</div>
								</div>
								<a href="javascript:void(0)" class="arm_clear_debug_log arm_margin_left_10" onclick="arm_clear_general_debug_logs('cron')" ><?php esc_html_e('Clear Log', 'ARMember'); ?></a>
								<?php
									$arm_debug_clear_log = $arm_global_settings->arm_get_confirm_box('cron', esc_html__("Are you sure you want to clear debug logs?", 'ARMember'), 'arm_clear_debug_log');
									echo $arm_debug_clear_log; //phpcs:ignore
								?>
							</div>
						</td>
					</tr>		
				</table>
				<br>
				<div class="page_sub_title"><?php esc_html_e('Email Debug Log Settings', 'ARMember'); ?></div>
				<div class="armclear"></div>
				<table class="form-table">
					<?php
						$arm_is_email_log_enabled = get_option('arm_email_debug_log');
						$arm_email_debug_log = ($arm_is_email_log_enabled) ? 'checked=checked' : '';
					?>
					<tr class="form-field">
						<th class="arm-form-table-label"><?php esc_html_e('Enable Email Debug Logs', 'ARMember'); ?></th>
						<td class="arm-form-table-content">
							<div class="armswitch arm_payment_setting_switch">
								<input type="checkbox" id="arm_email_debug_log" <?php echo esc_attr($arm_email_debug_log); ?> value="1" class="armswitch_input arm_debug_mode_switch" name="arm_email_debug_log" data-switch_key="email"/>
								<label for="arm_email_debug_log" class="armswitch_label"></label>
							</div>
							<?php
								if(!empty($arm_email_debug_log)){
							?>
									<div class="arm_debug_switch_email arm_debug_log_action_container">
							<?php
								} else {
							?>
									<div class="arm_debug_switch_email arm_debug_log_action_container" style="display: none;">
							<?php
								}
							?>
								<a href="javascript:void(0)" onclick="arm_view_general_debug_logs('email', 'Email')"><?php esc_html_e('View Log', 'ARMember'); ?></a>
								<a href="javascript:void(0)" onclick="arm_download_general_debug_logs('email')" class="arm_margin_left_10"><?php esc_html_e('Download Log', 'ARMember'); ?></a>
								<div class='arm_confirm_box arm_general_debug_download_confirm_box' id='arm_general_debug_download_confirm_box_email'>
									<div class='arm_confirm_box_body'>
										<div class='arm_confirm_box_arrow'></div>
										<div class='arm_confirm_box_text'>
											<div class="arm_download_duration_selection">
												<label class="arm_select_duration_label"><?php esc_html_e('Select log duration to download', 'ARMember'); ?></label>
												<input type="hidden" id="arm_general_download_duration" name="action1" value="7" />
												<dl class="arm_selectbox column_level_dd arm_width_280">
													<dt>
														<span><?php esc_html_e('Last 1 Week','ARMember');?></span>
														<input type="text" style="display:none;" value="" class="arm_autocomplete"  /><i class="armfa armfa-caret-down armfa-lg"></i>
													</dt>
													<dd>
														<ul data-id="arm_general_download_duration">
															<li data-label="<?php esc_attr_e('Last 1 Day', 'ARMember');?>" data-value="1"><?php esc_html_e('Last 1 Day', 'ARMember');?></li>

															<li data-label="<?php esc_attr_e('Last 3 Days', 'ARMember');?>" data-value="3"><?php esc_html_e('Last 3 Days', 'ARMember');?></li>

															<li data-label="<?php esc_attr_e('Last 1 Week','ARMember');?>" data-value="7"><?php esc_html_e('Last 1 Week','ARMember');?></li>

															<li data-label="<?php esc_attr_e('Last 2 Weeks', 'ARMember');?>" data-value="15"><?php esc_html_e('Last 2 Weeks', 'ARMember');?></li>

															<li data-label="<?php esc_attr_e('Last Month', 'ARMember');?>" data-value="30"><?php esc_html_e('Last Month', 'ARMember');?></li>

															<li data-label="<?php esc_attr_e('All', 'ARMember');?>" data-value="all"><?php esc_html_e('All', 'ARMember');?></li>

															<li data-label="<?php esc_attr_e('Custom', 'ARMember');?>" data-value="custom"><?php esc_html_e('Custom', 'ARMember');?></li>
														</ul>
													</dd>
												</dl>
											</div>
											<form id="arm_general_debug_download_custom_duration_email_form">
												<div class="arm_download_custom_duration_div">
									                <div class="arm_datatable_filter_item arm_margin_left_0">
									                    <input type="text" name="arm_filter_pstart_date" id="arm_filter_pstart_date" class="arm_download_custom_duration_date" placeholder="<?php esc_attr_e('Start Date', 'ARMember'); ?>" data-date_format="<?php echo esc_attr($arm_common_date_format); ?>" value="<?php echo esc_attr($arm_default_date); ?>" />
									                </div>
									                <div class="arm_datatable_filter_item">
									                    <input type="text" name="arm_filter_pend_date" id="arm_filter_pend_date" class="arm_download_custom_duration_date" placeholder="<?php esc_attr_e('End Date', 'ARMember'); ?>" data-date_format="<?php echo esc_attr($arm_common_date_format); ?>" value="<?php echo esc_attr($arm_default_date); ?>" />
									                </div>
								            	</div>
								            </form>
											<button type='button' class='arm_confirm_box_btn armemailaddbtn arm_download_general_debug_log_btn' data-selected_key='email'><?php esc_html_e('Download', 'ARMember'); ?></button>
										</div>
									</div>
								</div>
								<a href="javascript:void(0)" class="arm_clear_debug_log arm_margin_left_10" onclick="arm_clear_general_debug_logs('email')" ><?php esc_html_e('Clear Log', 'ARMember'); ?></a>
								<?php
									$arm_debug_clear_log = $arm_global_settings->arm_get_confirm_box('email', esc_html__("Are you sure you want to clear debug logs?", 'ARMember'), 'arm_clear_debug_log');
									echo $arm_debug_clear_log; //phpcs:ignore
								?>
							</div>
						</td>
					</tr>		
				</table>
				<table class="form-table">
					<tr class="form-field">
						<th class="arm-form-table-label"></th>
						<td class="arm-form-table-content"></td>
					</tr>
				</table>
				<div class="arm_submit_btn_container">
					<button id="arm_save_debug_logs_btn" class="arm_save_btn arm_min_width_120" name="arm_save_debug_logs" value="arm_save_debug_logs" type="submit" ><?php esc_html_e('Save', 'ARMember');?></button>
				</div>
				<?php $wpnonce = wp_create_nonce( 'arm_wp_nonce' );?>
				<input type="hidden" name="arm_wp_nonce" value="<?php echo $wpnonce;?>"/>
			</form>
		</div>
	</div>
</div>


<div class="arm_view_debug_payment_logs popup_wrapper <?php echo (is_rtl()) ? 'arm_page_rtl' : ''; ?>">
	<div>
		<div class="popup_header">
            <span class="popup_close_btn arm_popup_close_btn arm_view_debug_payment_logs_close_btn"></span>
            <span class="add_rule_content"><?php esc_html_e('Debug Logs', 'ARMember'); ?> (<span class="view_payment_log_key"></span>)</span>
        </div>
        <div class="popup_content_text">
        	<div class="arm_debug_payment_log_loader arm_text_align_center arm_width_100_pct" style="margin: 45px auto; ">
        		<img src="<?php echo MEMBERSHIP_IMAGES_URL."/arm_loader.gif"; //phpcs:ignore?>">
        	</div>
        	<div class="arm_view_payment_debug_log armPageContainer" data-arm_selected_gateway=""></div>
        	<div class="armclear"></div>
        </div>
        <div class="armclear"></div>
	</div>
</div>



<div class="arm_view_debug_general_logs popup_wrapper <?php echo (is_rtl()) ? 'arm_page_rtl' : ''; ?>">
	<div>
		<div class="popup_header">
            <span class="popup_close_btn arm_popup_close_btn arm_view_debug_general_logs_close_btn"></span>
            <span class="add_rule_content"><?php esc_html_e('Debug Logs', 'ARMember'); ?> (<span class="view_general_log_key"></span>)</span>
        </div>
        <div class="popup_content_text">
        	
        	<div class="arm_debug_general_log_loader arm_text_align_center arm_width_100_pct" style="margin: 45px auto; ">
        		<img src="<?php echo MEMBERSHIP_IMAGES_URL."/arm_loader.gif"; //phpcs:ignore?>">
        	</div>
        	<div class="arm_view_general_debug_log armPageContainer" data-arm_selected_gateway=""></div>
        </div>
        <div class="armclear"></div>
	</div>
</div>