<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Studio\V1\Flow;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\ListResource;
use Twilio\Rest\Studio\V1\Flow\Engagement\EngagementContextContext;
use Twilio\Rest\Studio\V1\Flow\Engagement\EngagementContextList;
use Twilio\Rest\Studio\V1\Flow\Engagement\StepContext;
use Twilio\Rest\Studio\V1\Flow\Engagement\StepList;
use Twilio\Values;
use Twilio\Version;

/**
 * @property StepList steps
 * @property EngagementContextList engagementContext
 * @method StepContext steps(string $sid)
 * @method EngagementContextContext engagementContext()
 */
class EngagementContext extends InstanceContext {
    protected $_steps = null;
    protected $_engagementContext = null;

    /**
     * Initialize the EngagementContext
     * 
     * @param Version $version Version that contains the resource
     * @param string $flowSid Flow Sid.
     * @param string $sid Engagement Sid.
     * @return EngagementContext
     */
    public function __construct(Version $version, $flowSid, $sid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = array('flowSid' => $flowSid, 'sid' => $sid, );

        $this->uri = '/Flows/' . rawurlencode($flowSid) . '/Engagements/' . rawurlencode($sid) . '';
    }

    /**
     * Fetch a EngagementInstance
     * 
     * @return EngagementInstance Fetched EngagementInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch() {
        $params = Values::of(array());

        $payload = $this->version->fetch(
            'GET',
            $this->uri,
            $params
        );

        return new EngagementInstance(
            $this->version,
            $payload,
            $this->solution['flowSid'],
            $this->solution['sid']
        );
    }

    /**
     * Deletes the EngagementInstance
     * 
     * @return boolean True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete() {
        return $this->version->delete('delete', $this->uri);
    }

    /**
     * Magic getter to lazy load subresources
     *
     * @param string $name Subresource to return
     *
     * @return ListResource The requested subresource
     * @throws TwilioException For unknown subresources
     */
    public function __get($name) {
        if (property_exists($this, '_' . $name)) {
            $method = 'get' . ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown subresource ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     *
     * @return InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call($name, $arguments) {
        $property = $this->$name;
        if (method_exists($property, 'getContext')) {
            return call_user_func_array(array($property, 'getContext'), $arguments);
        }

        throw new TwilioException('Resource does not have a context');
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString() {
        $context = array();
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Studio.V1.EngagementContext ' . implode(' ', $context) . ']';
    }

    /**
     * Access the steps
     *
     * @return StepList
     */
    protected function getSteps() {
        if (!$this->_steps) {
            $this->_steps = new StepList($this->version, $this->solution['flowSid'], $this->solution['sid']);
        }

        return $this->_steps;
    }

    /**
     * Access the engagementContext
     *
     * @return EngagementContextList
     */
    protected function getEngagementContext() {
        if (!$this->_engagementContext) {
            $this->_engagementContext = new EngagementContextList(
                $this->version,
                $this->solution['flowSid'],
                $this->solution['sid']
            );
        }

        return $this->_engagementContext;
    }
}