<?php
if ( ( class_exists( 'LearnDash_Shortcodes_Section' ) ) && ( !class_exists( 'LearnDash_Shortcodes_Section_ld_propanel' ) ) ) {
	class LearnDash_Shortcodes_Section_ld_propanel extends LearnDash_Shortcodes_Section {

		function __construct( $fields_args = array() ) {
			$this->fields_args = $fields_args;

			$this->shortcodes_section_key 			= 	'ld_propanel';
			$this->shortcodes_section_title 		= 	esc_html__( 'ProPanel', 'ld_propanel' );
			$this->shortcodes_section_type			=	1;
			$this->shortcodes_section_description	=	esc_html__( 'This shortcode displays widgets from ProPanel.', 'ld_propanel' );

			parent::__construct();
		}

		function init_shortcodes_section_fields() {
			$this->shortcodes_option_fields = array(
				'widget' => array(
					'id'			=>	$this->shortcodes_section_key . '_widget',
					'name'  		=> 	'widget',
					'type'  		=> 	'select',
					// translators: ProPanel Widget
					'label' 		=> 	esc_html_x( 'Widget', 'ProPanel Widget', 'ld_propanel' ),
					'help_text'		=>	esc_html__( 'Select which ProPanel widget to dislay', 'ld_propanel' ),
					'value' 		=> 	'',
					'options'		=>	array(
											// translators: ProPanel widget shortcode
											'link'				=>	esc_html_x( 'Link to ProPanel Full Page', 'ProPanel widget shortcode', 'ld_propanel' ),
											// translators: ProPanel widget shortcode
											'overview'			=>	esc_html_x( 'Overview Widget', 'ProPanel widget shortcode', 'ld_propanel' ),
											// translators: ProPanel widget shortcode
											'filtering'			=>	esc_html_x( 'Filtering Widget', 'ProPanel widget shortcode', 'ld_propanel' ),
											// translators: ProPanel widget shortcode
											'reporting'			=>	esc_html_x( 'Reporting Widget', 'ProPanel widget shortcode', 'ld_propanel' ),
											// translators: ProPanel widget shortcode
											'activity'			=>	esc_html_x( 'Activity Widget', 'ProPanel widget shortcode', 'ld_propanel' ),
											// translators: ProPanel widget shortcode
											'progress_chart'	=>	esc_html_x( 'Progress Chart Widget', 'ProPanel widget shortcode', 'ld_propanel' ),
					),
				),
				'filter_groups' => array(
					'id'			=>	$this->shortcodes_section_key . '_filter_groups',
					'name'  		=> 	'filter_groups',
					'type'  		=> 	'number',
					'label' 		=> 	esc_html__( 'Filter Groups', 'ld_propanel' ),
					'help_text'		=>	esc_html__( 'Filter Widget by Group ID', 'ld_propanel' ),
					'value' 		=> 	'',
				),

				'filter_courses' => array(
					'id'			=>	$this->shortcodes_section_key . '_filter_courses',
					'name'  		=> 	'filter_courses',
					'type'  		=> 	'number',
					'label' 		=> 	sprintf(
										// translators: placeholder: Course.
										esc_html_x( 'Filter %s', 'placeholder: Course', 'ld_propanel' ),
										LearnDash_Custom_Label::get_label( 'course' )
										),
					'help_text'		=>	sprintf(
										// translators: placeholder: Course.
										esc_html_x( 'Filter Widget by %s ID', 'placeholder: Course', 'ld_propanel' ),
										LearnDash_Custom_Label::get_label( 'course' )
										),
					'value' 		=> 	'',
				),

				'filter_users' => array(
					'id'			=>	$this->shortcodes_section_key . '_filter_users',
					'name'  		=> 	'filter_users',
					'type'  		=> 	'number',
					'label' 		=> 	esc_html__( 'Filter Users', 'ld_propanel' ),
					'help_text'		=>	esc_html__( 'Filter Widget by User ID', 'ld_propanel' ),
					'value' 		=> 	'',
				),

				'filter_status' => array(
					'id'			=>	$this->shortcodes_section_key . '_filter_status',
					'name'  		=> 	'filter_status',
					'type'  		=> 	'select',
					'label' 		=> 	sprintf(
										// translators: placeholder: Course.
										esc_html_x( 'Filter %s Status', 'placeholder: Course', 'ld_propanel' ),
										LearnDash_Custom_Label::get_label( 'course' )
										),
					'help_text'		=>	sprintf(
										// translators: placeholder: Course.
										esc_html_x( 'Filter Widget by %s Status', 'placeholder: Course', 'ld_propanel' ),
										LearnDash_Custom_Label::get_label( 'course' )
										),
					'value' 		=> 	'',
					//'attrs'			=>	array( 'multiple' => 'multiple' ),
					'options'		=>	array(
											// translators: Course status - All Statuses
											''				=>	esc_html_x( 'All Statuses', 'Course status - All Statuses', 'ld_propanel' ),
											// translators: Course status - Not Started
											'not-started'	=>	esc_html_x( 'Not Started', 'Course status - Not Started', 'ld_propanel' ),
											// translators: Course status - In Progress
											'in-progress'	=>	esc_html_x( 'In Progress', 'Course status - In Progress', 'ld_propanel' ),
											// translators: Course status - Completed
											'completed'		=>	esc_html_x( 'Completed', 'Course status - Completed', 'ld_propanel' )
										)

				),

				'display_chart' => array(
					'id'			=>	$this->shortcodes_section_key . '_display_chart',
					'name'  		=> 	'display_chart',
					'type'  		=> 	'select',
					'label' 		=> 	esc_html__( 'Display Chart', 'ld_propanel' ),
					'help_text'		=>	esc_html__( 'Display Chart Orientation', 'ld_propanel' ),
					'value' 		=> 	'',
					'options'		=>	array(
											// translators: Chart orientation
											''				=>	esc_html_x( 'Stacked (default)', 'Chart orientation', 'ld_propanel' ),
											// translators: Chart orientation
											'side-by-side'	=>	esc_html_x( 'Side by Side', 'Chart orientation', 'ld_propanel' ),
										)

				),
				'per_page' => array(
					'id'			=>	$this->shortcodes_section_key . '_per_page',
					'name'  		=> 	'per_page',
					'type'  		=> 	'number',
					// translators: Pagination for Widget output
					'label' 		=> 	esc_html_x( 'Per Page', 'Pagination for Widget output', 'ld_propanel' ),
					// translators: ProPanel Widget
					'help_text'		=>	esc_html_x( 'Pagination for Widget output', 'ProPanel Widget', 'ld_propanel' ),
					'value' 		=> 	'',
				),
			);

			$this->shortcodes_option_fields = apply_filters( 'learndash_settings_fields', $this->shortcodes_option_fields, $this->shortcodes_section_key );

			parent::init_shortcodes_section_fields();
		}

		function show_shortcodes_section_footer_extra() {
			?>
			<script>
				jQuery(document).ready(function() {
					if ( jQuery( 'form#learndash_shortcodes_form_ld_propanel select#ld_propanel_widget' ).length) {
						jQuery( 'form#learndash_shortcodes_form_ld_propanel select#ld_propanel_widget').change( function() {
							var selected_widget = jQuery(this).val();

							jQuery( 'form#learndash_shortcodes_form_ld_propanel input#ld_propanel_filter_groups').val('');
							jQuery( 'form#learndash_shortcodes_form_ld_propanel input#ld_propanel_filter_courses').val('');
							jQuery( 'form#learndash_shortcodes_form_ld_propanel input#ld_propanel_filter_users').val('');
							jQuery( 'form#learndash_shortcodes_form_ld_propanel select#ld_propanel_filter_status').val('');
							jQuery( 'form#learndash_shortcodes_form_ld_propanel select#ld_propanel_display_chart').val('');
							jQuery( 'form#learndash_shortcodes_form_ld_propanel input#ld_propanel_per_page').val('');

							if ( ( selected_widget == 'reporting' ) || ( selected_widget == 'activity' ) || ( selected_widget == 'progress_chart' ) ) {
								jQuery( 'form#learndash_shortcodes_form_ld_propanel #ld_propanel_filter_groups_field').slideDown();
								jQuery( 'form#learndash_shortcodes_form_ld_propanel #ld_propanel_filter_courses_field').slideDown();
								jQuery( 'form#learndash_shortcodes_form_ld_propanel #ld_propanel_filter_users_field').slideDown();

								if ( selected_widget == 'progress_chart' ) {
									jQuery( 'form#learndash_shortcodes_form_ld_propanel #ld_propanel_display_chart_field').slideDown();
									jQuery( 'form#learndash_shortcodes_form_ld_propanel #ld_propanel_filter_status_field').hide();
									jQuery( 'form#learndash_shortcodes_form_ld_propanel #ld_propanel_per_page_field').hide();
								} else {
									jQuery( 'form#learndash_shortcodes_form_ld_propanel #ld_propanel_display_chart_field').hide();
									jQuery( 'form#learndash_shortcodes_form_ld_propanel #ld_propanel_filter_status_field').slideDown();
									jQuery( 'form#learndash_shortcodes_form_ld_propanel #ld_propanel_per_page_field').slideDown();
								}

								if ( ( selected_widget == 'progress_chart' ) || ( selected_widget == 'reporting' ) ) {
									if ( !jQuery( 'form#learndash_shortcodes_form_ld_propanel p#required-message').length ) {
										jQuery( '<p id="required-message" style="color: red;"><?php _e('When using the "reporting" or "progress_chart" widget shortcodes, a selection from the Group, Course or User filters is recommended unless also using the "filtering" widget shortcode on the same page.', 'ld_propanel') ?></p>' ).insertBefore( 'form#learndash_shortcodes_form_ld_propanel .learndash_shortcodes_section' );
									}
									jQuery( 'form#learndash_shortcodes_form_ld_propanel p#required-message').show();
								} else {
									if ( jQuery( 'form#learndash_shortcodes_form_ld_propanel p#required-message').length ) {
										jQuery( 'form#learndash_shortcodes_form_ld_propanel p#required-message').hide();
									}
								}

							} else {
								jQuery( 'form#learndash_shortcodes_form_ld_propanel #ld_propanel_filter_groups_field').hide();
								jQuery( 'form#learndash_shortcodes_form_ld_propanel #ld_propanel_filter_courses_field').hide();
								jQuery( 'form#learndash_shortcodes_form_ld_propanel #ld_propanel_filter_users_field').hide();
								jQuery( 'form#learndash_shortcodes_form_ld_propanel #ld_propanel_filter_status_field').hide();
								jQuery( 'form#learndash_shortcodes_form_ld_propanel #ld_propanel_display_chart_field').hide();
								jQuery( 'form#learndash_shortcodes_form_ld_propanel #ld_propanel_per_page_field').hide();

								if ( jQuery( 'form#learndash_shortcodes_form_ld_propanel p#required-message').length ) {
									jQuery( 'form#learndash_shortcodes_form_ld_propanel p#required-message').hide();
								}
							}
						});
						jQuery( 'form#learndash_shortcodes_form_ld_propanel select#ld_propanel_widget').change();
					}
				});
			</script>
			<?php
		}
	}
}

