<?php
if(!defined('ABSPATH')) {die('You are not allowed to call this page directly.');}

class MeprAdminNewOneOffEmail extends MeprBaseOptionsAdminEmail {
  /** Set the default enabled, title, subject & body */
  public function set_defaults($args=array()) {
    $mepr_options = MeprOptions::fetch();
    $this->to = $mepr_options->admin_email_addresses;

    $this->title = __('<b>New One-Time Subscription</b> Notice','memberpress');
    $this->description = __('This email is sent to you when a new non-recurring subscription is created.', 'memberpress');
    $this->ui_order = 1;

    $enabled = $use_template = $this->show_form = true;
    $subject = __('** New One-Time Subscription: {$trans_num}', 'memberpress');
    $body = $this->body_partial();

    $this->defaults = compact( 'enabled', 'subject', 'body', 'use_template' );
    $this->variables = MeprTransactionsHelper::get_email_vars();
  }
}

