<?php


////////////////////////////////////////////////
////// SET PREDEFINED STYLES ///////////////////
////////////////////////////////////////////////

function pc_set_predefined_style($style = false) {
	if($style) {
        $_POST['style'] = $style;    
    }
    
    if(!$style && (!isset($_POST['lcwp_nonce']) || !wp_verify_nonce($_POST['lcwp_nonce'], 'lcwp_nonce'))) {
        wp_die('Cheating?');
    }
	if(!isset($_POST['style'])) {
        wp_die('data is missing');
    }

	require_once(PC_DIR .'/settings/preset_styles.php');
	
	$style_data = pc_preset_styles_data($_POST['style']);
	if(empty($style_data)) {
        wp_die('Style not found');
    }
	
	
	// override values
	foreach($style_data as $key => $val) {
		update_option($key, $val);		
	}


	// if is not forcing inline CSS - create static file
	if(!get_option('pg_inline_css')) {
		pc_static::create_custom_style();
	}
	
    if(!$style) {
	   wp_die('success');
    }
}
add_action('wp_ajax_pc_set_predefined_style', 'pc_set_predefined_style');





////////////////////////////////////////////////
////// USERS LIST - UPDATE SHOWN COLUMNS ///////
////////////////////////////////////////////////

function pc_ulist_update_user_cols() {
	if(!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
	
    if(!isset($_POST['cols']) || !is_array($_POST['cols']) || empty($_POST['cols'])) {
        wp_die('Columns data missing');    
    }
    
    update_user_meta(get_current_user_id(), 'pc_ulist_columns', (array)$_POST['cols']);
	wp_die('success');	
}
add_action('wp_ajax_pc_ulist_update_user_cols', 'pc_ulist_update_user_cols');





////////////////////////////////////////////////
////// USERS LIST - BULK ASSIGN CATEGORIES /////
////////////////////////////////////////////////

function pc_bulk_cat_change() {
	if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
    if(isset($GLOBALS['pc_cuc_edit']) && !$GLOBALS['pc_cuc_edit']) {
        wp_die('You do not have rights to edit users');        
    }
    
	$users = (array)$_POST['users'];
	if(!count($users)) {
        wp_die('Select at least one user');
    }
	
	$cats = (array)$_POST['cats'];
	if(!count($cats)) {
        wp_die('Select at least one category');
    }
	
	global $wpdb;
	$rows_affected = $wpdb->query(
		$wpdb->prepare(
			"UPDATE ".PC_USERS_TABLE." SET categories = %s WHERE id IN (". addslashes(implode(',', $users)) .")",
			serialize($cats)
		)
	);
	
	if((int)$rows_affected != count($users)) {
		wp_die('Error updating one or more users');	
	}
	
	
	/* PC-ACTION - triggered when categories have been changed to multiple users - passes users ID array */
	do_action('pc_bulk_cat_assign_done', $users);

	wp_die('success');	
}
add_action('wp_ajax_pc_bulk_cat_change', 'pc_bulk_cat_change');





////////////////////////////////////////////////////////////
////// USERS LIST - MANAGE USERS (DEL | ENABLE | DISABLE) //
////////////////////////////////////////////////////////////

function pc_ulist_manage_users() {
	$processed = array();

    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_ajax')) {
        $resp = array(
			'status'         => 'error',
			'message'        => 'Cheating?',
            'processed_users'=> $processed,
		);
		wp_die(json_encode($resp));	
    }
    if(isset($GLOBALS['pc_cuc_edit']) && !$GLOBALS['pc_cuc_edit']) {  
        $resp = array(
			'status'         => 'error',
			'message'        => 'You do not have rights to edit users',
            'processed_users'=> $processed,
		);
		wp_die(json_encode($resp));	
    }
    
    $users = (array)$_POST['users'];
	if(!count($users)) {
        $resp = array(
			'status'         => 'error',
			'message'        => 'Affect at least one user',
            'processed_users'=> $processed,
		);
		wp_die(json_encode($resp));	
    }
    
	$action = $_POST['pc_cmd']; 
	if(!in_array($action, array('enable', 'disable', 'delete'))) {
        $resp = array(
			'status'         => 'error',
			'message'        => 'Action not recognized',
            'processed_users'=> $processed,
		);
		wp_die(json_encode($resp));	
    }
	
    // perform
    global $pc_users;

    foreach($users as $uid) {
        $uid = (int)$uid;
        
        switch($action) {
            case 'delete' : 
                
                if($pc_users->delete_user($uid)) {
                    $processed[] = $uid;	
                }
                break;

            case 'disable' : 
            case 'activate' :     
            default :
                
                $new_status = ($action == 'disable') ? 2 : 1;
                
                if($pc_users->change_status($uid, $new_status)) {
                    $processed[] = $uid;	        
                }
                break;
        }
    }
    
    
    if(count($processed) == count($users)) {
        $resp = array(
			'status'         => 'success',
            'processed_users'=> $processed,
		);		    
    }
    else {
        $resp = array(
			'status'         => 'error',
			'message'        => __('Error performing the action for users', 'pc_ml') .' '. implode(', ', array_diff($users, $processed)),
            'processed_users'=> $processed,
		);    
    }

	wp_die(json_encode($resp));	
}
add_action('wp_ajax_pc_ulist_manage_users', 'pc_ulist_manage_users');






/*******************************************************************************************************************/





////////////////////////////////////////////////
/// WP USER SYNC - MANUALLY SYNC SINGLE USER ///
////////////////////////////////////////////////

function pc_wp_sync_single_user() {
	if (!isset($_POST['pc_nonce']) || !wp_verify_nonce($_POST['pc_nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }

	global $pc_users, $pc_wp_user;
	$user_id = (int)$_POST['pc_user_id']; 
	
	$args = array('to_get' => array('username', 'psw', 'email', 'name', 'surname'));
	$ud = $pc_users->get_user($user_id, $args);
	if(empty($ud)) {wp_die('user does not exist');}	
	
	$result = $pc_wp_user->sync_wp_user($ud, 0, true);	
	
	echo (!$result) ? $pc_wp_user->pwu_sync_error : 'success';
	wp_die();	
}
add_action('wp_ajax_pc_wp_sync_single_user', 'pc_wp_sync_single_user');




////////////////////////////////////////////////
/// WP USER SYNC - SINGLE (WP) USER SYNC ///////
////////////////////////////////////////////////

function wp_to_pc_single_user_sync() {
	if (!isset($_POST['pc_nonce']) || !wp_verify_nonce($_POST['pc_nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }

	if(!isset($_POST['wp_user_id']) || !(int)$_POST['wp_user_id']) {
		$error = 'Missing user ID';	
	}
	if(!isset($_POST['pc_wps_eus_cat']) || !count( (array)$_POST['pc_wps_eus_cat'] )) {
		$error = 'Missing user categories';	
	}
	
	if(isset($error)) {
		$resp = array(
			'status'  => 'error',
			'message' => $error
		);
		wp_die(json_encode($resp));	
	}
	
	
	global $pc_wp_user;
	
	$wp_user_id = (int)$_POST['wp_user_id'];
	$cats 		= (array)$_POST['pc_wps_eus_cat'];
	$response 	= $pc_wp_user->pc_user_from_wp($wp_user_id, $cats);
	
	if(is_wp_error($response)) {
		$resp = array(
			'status'  => 'error',
			'message' => $response->get_error_message()
		);	
	}
	else {
		$resp = array(
			'status'  => 'success',
			'user_id' => $response
		);		
	}

	wp_die(json_encode($resp));	
}
add_action('wp_ajax_wp_to_pc_single_user_sync', 'wp_to_pc_single_user_sync');




////////////////////////////////////////////////
/// WP USER SYNC - BULK WP USERS IMPORT ////////
////////////////////////////////////////////////

function wp_to_pc_bulk_user_sync() {
	if (!isset($_POST['pc_nonce']) || !wp_verify_nonce($_POST['pc_nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }

	if(!isset($_POST['pc_wp_imp_cat']) || !count( (array)$_POST['pc_wp_imp_cat'] )) {
		wp_die('User categories missing');	
	}
	if(!isset($_POST['pc_wp_imp_roles']) || !count( (array)$_POST['pc_wp_imp_roles'] )) {
		wp_die('User roles missing');	
	}
	
	$cats 		= (array)$_POST['pc_wp_imp_cat'];
	$roles 		= (array)$_POST['pc_wp_imp_roles'];
	
	
	// get users
	$fetched_users = array();
	foreach($roles as $role) {
		
		$user_query = new WP_User_Query( array('role' => $role) );
		$results = $user_query->get_results(); 
		if( !empty($results) ) {
			$fetched_users = array_merge($fetched_users, $user_query->get_results());	
		}
	}
	
	if(empty($fetched_users)) {
		echo '<div class="pc_warn pcma_warn_box pc_error"><p>'. __('No users found', 'pc_ml') .'</p></div>';
		wp_die();	
	}
	
	// start syncing
	global $pc_wp_user;
	$failed_sync = array(); 
	
	foreach($fetched_users as $to_sync) {
		$response = $pc_wp_user->pc_user_from_wp($to_sync->ID, $cats);
	
		if(is_wp_error($response)) {
			
			// TEMPORARY WORKAROUND - if "already synced" is returned is due to a past bug (August 2019) - set roles again
			if($response->get_error_code() ==  'already synced') {
				$pc_wp_user->set_wps_custom_roles($to_sync->ID);
			}
			else {
				$failed_sync[ $to_sync->user_login ] = $response->get_error_message();	
			}
		}
	}
	

	// print results
	if((count($fetched_users) - count($failed_sync)) > 0) {
		echo '<div class="pc_warn pcma_warn_box pc_success"><p><strong>'. (count($fetched_users) - count($failed_sync)) .' '. __('synced users', 'pc_ml') .'</strong></p></div>';
	}
	
	if(count($failed_sync)) {
		echo '<div class="pc_warn pcma_warn_box pc_error">';
			echo '<p><strong>'. count($failed_sync) .' '. __('failed syncs', 'pc_ml') .':</strong></p>';
			
			foreach($failed_sync as $username => $message) {
				echo '<p><strong>'. $username .'</strong> - '. $message .'</p>';	
			}
		echo '</div>';	
	}
	wp_die();
}
add_action('wp_ajax_wp_to_pc_bulk_user_sync', 'wp_to_pc_bulk_user_sync');




//////////////////////////////////////////////////
/// WP USER SYNC - MANUALLY DETACH SINGLE USER ///
//////////////////////////////////////////////////

function pc_wp_detach_single_user() {
	if (!isset($_POST['pc_nonce']) || !wp_verify_nonce($_POST['pc_nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }

	global $pc_wp_user;
	$user_id = (int)$_POST['pc_user_id']; 
	
	$result = $pc_wp_user->detach_wp_user($user_id);
	
	echo ($result === true) ? 'success' : $result;
	wp_die();	
}
add_action('wp_ajax_pc_wp_detach_single_user', 'pc_wp_detach_single_user');




////////////////////////////////////////////////
/// WP USER SYNC - GLOBAL SYNC /////////////////
////////////////////////////////////////////////

function pc_wp_global_sync() {
	if (!isset($_POST['pc_nonce']) || !wp_verify_nonce($_POST['pc_nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
	global $pc_wp_user;
	
	echo $pc_wp_user->global_sync();
	wp_die();	
}
add_action('wp_ajax_pc_wp_global_sync', 'pc_wp_global_sync');




////////////////////////////////////////////////
/// WP USER SYNC - GLOBAL DETACH ///////////////
////////////////////////////////////////////////

function pc_wp_global_detach() {
	if (!isset($_POST['pc_nonce']) || !wp_verify_nonce($_POST['pc_nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
	global $pc_wp_user;
	
	echo $pc_wp_user->global_detach();
	wp_die();	
}
add_action('wp_ajax_pc_wp_global_detach', 'pc_wp_global_detach');




////////////////////////////////////////////////////
/// WP USER SYNC - SERACH & SYNC EXISTING MATCHES //
////////////////////////////////////////////////////

function pc_wps_search_and_sync_matches() {
	if (!isset($_POST['pc_nonce']) || !wp_verify_nonce($_POST['pc_nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
	global $pc_wp_user;
	
	echo $pc_wp_user->search_and_sync_matches();
	wp_die();	
}
add_action('wp_ajax_pc_wps_search_and_sync_matches', 'pc_wps_search_and_sync_matches');





/*******************************************************************************************************************/





////////////////////////////////////////////////////
/// WP USERS SEARCH FOR AUTOCOMPLETE PICKER ////////
////////////////////////////////////////////////////

function pc_ausnp_search() {
	if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
    
    $to_match = (isset($_POST['search'])) ? esc_attr($_POST['search']) : '';
    if(empty($to_match)) {
        wp_die(json_encode(array()));        
    }
    
    $to_exclude = (isset($_POST['to_exclude'])) ? (array)$_POST['to_exclude'] : array();
    
    
    
    $users = new WP_User_Query(array(
        'search'         => '*'. $to_match .'*',
        'search_columns' => array(
            'user_login',
            'user_nicename',
            'user_email',
        ),
        'role__not_in'  => 'Administrator',
        'exclude'       => $to_exclude
    ));
    
    $users = $users->get_results();
    $to_return = array();
    
    if(is_array($users)) {
        foreach($users as $u) {
            
            // ignore synced users!
            if(get_option('pg_wp_user_sync') && is_array($u->wp_capabilities) && !in_array('pvtcontent', $u->wp_capabilities)) {
                continue;        
            }
            
            $to_return[] = array(
                'id'	=> $u->ID, 
                'value'	=> '', 
                'label'	=> $u->user_login
            );	        
        }
    }

	echo json_encode($to_return);
	wp_die();
}
add_action('wp_ajax_pc_ausnp_search', 'pc_ausnp_search');






/*******************************************************************************************************************/





////////////////////////////////////////////////////
/// REGISTRATION FORMS - ADD FORM //////////////////
////////////////////////////////////////////////////

function pc_add_reg_form() {
	if (!isset($_POST['pc_nonce']) || !wp_verify_nonce($_POST['pc_nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
	
	$form_name = trim($_POST['form_name']); 
	if(empty($form_name) || strlen($form_name) > 250) {
        wp_die( __('Please insert a valid form name', 'pc_ml') );
    }
	
	$result = wp_insert_term($form_name, 'pc_reg_form', array(
		'description' => base64_encode(serialize( array(
			'include' => array('username', 'psw'), 'require' => array('username', 'psw')
		)))
	));	
	
	echo (is_wp_error($result)) ? $result->get_error_message() : $result['term_id'];
	wp_die();	
}
add_action('wp_ajax_pc_add_reg_form', 'pc_add_reg_form');




////////////////////////////////////////////////////
/// REGISTRATION FORMS - SHOW BUILDER //////////////
////////////////////////////////////////////////////

function pc_reg_form_builder() {
	if (!isset($_POST['pc_nonce']) || !wp_verify_nonce($_POST['pc_nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
    
	include_once(PC_DIR . '/classes/pc_form_framework.php');
	$f_fw = new pc_form;	
	
	$form_id = trim(addslashes($_POST['form_id'])); 
	if (!filter_var($form_id, FILTER_VALIDATE_INT)) {wp_die('Invalid form ID');}

	$term = get_term($form_id, 'pc_reg_form');
	$structure = unserialize(base64_decode($term->description));

	echo '
	<table id="pc_rf_add_f_table" class="widefat pc_table">
	  <tbody>
	  	<tr>
		  <td class="pc_label_td">'. __('Form name', 'pc_ml') .'</td>
		  <td class="pc_field_td">
		  	<input type="text" name="pc_rf_name" id="pc_rf_name" value="'. $term->name .'" placeholder="'. esc_attr__("New form's name", 'pc_ml').'" autocomplete="off" />
		  </td>
		</tr>
		<tr>
		  <td class="pc_label_td"><input type="button" name="pc_rf_add_field" id="pc_rf_add_field" class="button-secondary" value="'. esc_attr__('Add field', 'pc_ml') .'" /></td>
		  <td class="pc_field_td">
		  	<select name="pc_form_fields_dd" class="lcwp_sf_select pc_form_fields_dd" data-placeholder="'. esc_attr__('Add fields', 'pc_ml') .' .." autocomplete="off">
				<option value="custom|||text">- '. esc_html__('TEXT BLOCK', 'pc_ml') .'</option>
				<option value="custom|||page">- '. esc_html__('PAGINATOR', 'pc_ml') .'</option>
                <option value="custom|||sep">- '. esc_html__('SEPARATOR BAR', 'pc_ml') .'</option>';
			
			$unsorted_fields = $f_fw->fields;
			ksort($unsorted_fields);
			foreach($unsorted_fields as $index => $data) {

				if(in_array($index, (array)$f_fw->no_wizard_indexes)) {continue;}
				echo '<option value="'. esc_attr($index) .'">'. esc_html($data['label']) .'</option>';	
			}
			
			echo '	
			</select>
		  </td>
		</tr>  
	  </tbody>
	</table>
	
	<table id="pc_rf_builder_table" class="widefat pc_table">
	  <thead>
		<tr>
		  <th></th>
		  <th></th>
		  <th>'. __('Field', 'pc_ml') .'</th>
		  <th>'. __('Required?', 'pc_ml') .'</th>
		</tr>
	  </thead>
	  <tbody>';
	
	$txt_id = 0;	
	foreach($structure['include'] as $field) {
		// if field is not registered - skip
		if(substr($field, 0, 13) != 'custom|||text' && substr($field, 0, 12) != 'custom|||sep' && $field != 'custom|||page' && !isset($f_fw->fields[$field])) {
            continue;
        }
		
		$required = (in_array($field, (array)$structure['require']) || in_array($field, array('username', 'psw', 'categories'))) ? 'checked="checked"' : '';
		$disabled = (in_array($field, array('username', 'psw', 'categories'))) ? 'disabled="disabled"' : '';
		
		$del_code = (in_array($field, array('username', 'psw'))) ? '' : '<span class="pc_del_field dashicons dashicons-no-alt" title="'. esc_attr__('remove field', 'pc_ml') .'"></span>';
		
		// text block
		if(substr($field, 0, 13) == 'custom|||text') {
			$content = (isset($structure['texts']) && is_array($structure['texts']) && isset($structure['texts'][$txt_id])) ? $structure['texts'][$txt_id] : '';
			
			$code = '
			<td colspan="2">
				<input type="hidden" name="pc_reg_form_field[]" value="'. esc_attr($field) .'" class="pc_reg_form_builder_included" />
				<textarea name="pc_reg_form_texts[]" placeholder="'. esc_attr__('Supports HTML and shortcodes', 'pc_ml') .'">'. esc_textarea($content) .'</textarea>
			</td>';
			
			$txt_id++;
		}
        
        // separator bar
		elseif(substr($field, 0, 12) == 'custom|||sep') {
			$code = '
			<td colspan="2">
				<input type="hidden" name="pc_reg_form_field[]" value="'. esc_attr($field) .'" class="pc_reg_form_builder_included" />
				<strong>'. __('SEPARATOR BAR', 'pc_ml') .'</strong>
			</td>';
			
			$txt_id++;
		}
		
		// paginator block
		elseif($field == 'custom|||page') {
			$code = '
			<td colspan="2" class="pc_paginator_td">
				<input type="hidden" name="pc_reg_form_field[]" value="'. esc_attr($field) .'" class="pc_reg_form_builder_included" />
				<strong>'. __('PAGINATOR', 'pc_ml') .'</strong>
			</td>';
		}
		
		// standard part
		else {
			$code = '
			<td>
				<input type="hidden" name="pc_reg_form_field[]" value="'.$field.'" class="pc_reg_form_builder_included" />
				'. $f_fw->get_field_name($field) .'
			</td>
			<td>
				<input type="checkbox" name="pc_reg_form_req[]" value="'.$field.'" '.$required.' '.$disabled.' class="lcwp_sf_check pc_reg_form_builder_required" autocomplete="off" />
			</td>';
		}
		
		echo '
		<tr rel="'.$field.'">
			<td>'. $del_code .'</td>
			<td><span class="pc_move_field dashicons dashicons-move" title="'. esc_attr__('sort field', 'pc_ml') .'"></span></td>
			'. $code .'
		</tr>';
	}
		
	echo '</tbody>
	</table>
	
	<input type="button" class="pc_reg_form_save button-primary" value="'. esc_attr__('Save Form', 'pc_ml') .'">
	<hr id="pc_save_reg_f_hr" />';	
	wp_die();	
}
add_action('wp_ajax_pc_reg_form_builder', 'pc_reg_form_builder');




////////////////////////////////////////////////////
/// REGISTRATION FORMS - UPDATE FORM ///////////////
////////////////////////////////////////////////////

function pc_update_reg_form() {
	if (!isset($_POST['pc_nonce']) || !wp_verify_nonce($_POST['pc_nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
	
	include_once(PC_DIR . '/classes/simple_form_validator.php');
	$validator = new simple_fv;	
		
	$indexes = array();
	$indexes[] = array('index'=>'form_id', 'label'=>'form id', 'type'=>'int', 'required'=>true);
	$indexes[] = array('index'=>'form_name', 'label'=>'form name', 'required'=>true, 'max_len'=>250);
	$indexes[] = array('index'=>'fields_included', 'label'=>'fields included', 'required'=>true);
	$indexes[] = array('index'=>'fields_required', 'label'=>'fields required', 'required'=>true);
	$indexes[] = array('index'=>'texts', 'label'=>'text blocks');
	
	$validator->formHandle($indexes);
	$fdata = $validator->form_val;

	// check username and password fields existence
	if(!is_array($fdata['fields_included']) || !in_array('username', $fdata['fields_included']) || !in_array('psw', $fdata['fields_included'])) {
		$validator->custom_error[ esc_html__("Form structure", 'pc_ml') ] = __("Username and password fields are mandatory", 'pc_ml');	
	}
	
	$error = $validator->getErrors();
	if(!$error) {
		// clean texts from slashes
		if(!empty($fdata['texts'])) {
			$escaped = array();
			
			foreach((array)$fdata['texts'] as $val) {
				$escaped[] = stripslashes($val);
			}
			
			$fdata['texts'] = $escaped;
		}
		
		// setup array - user base64_encode to prevent WP tags cleaning
		$descr = base64_encode(
			serialize( 
				array(
					'include' => $fdata['fields_included'], 'require'=>$fdata['fields_required'], 'texts'=>$fdata['texts']
				)
			)
		);

		// update	
		$result = wp_update_term($fdata['form_id'], 'pc_reg_form', array(
			'name' => $fdata['form_name'],
			'description' => $descr
		));
		
		echo (is_wp_error($result)) ? $result->get_error_message() : 'success';
	}
	else {
		echo $error;	
	}
	wp_die();
}
add_action('wp_ajax_pc_update_reg_form', 'pc_update_reg_form');




////////////////////////////////////////////////////
/// REGISTRATION FORMS - DELETE FORM ///////////////
////////////////////////////////////////////////////

function pc_del_reg_form() {
	if (!isset($_POST['pc_nonce']) || !wp_verify_nonce($_POST['pc_nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
	
	$form_id = trim(addslashes($_POST['form_id'])); 
	if (!filter_var($form_id, FILTER_VALIDATE_INT)) {wp_die('Invalid form ID');}

	echo (wp_delete_term($form_id, 'pc_reg_form')) ? 'success' : 'Error deleting form';	
	wp_die();	
}
add_action('wp_ajax_pc_del_reg_form', 'pc_del_reg_form');





/*******************************************************************************************************************/





////////////////////////////////////////////////////
/// LIGHTBOX INSTANCES - CREATE INSTANCE TERM //////
////////////////////////////////////////////////////

function pc_add_lightbox() {
	if (!isset($_POST['pc_nonce']) || !wp_verify_nonce($_POST['pc_nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
		
	$result = wp_insert_term('|||pclbft|||', 'pc_lightboxes', array(
		'slug' => uniqid()
	));	
	if(is_wp_error($result)) {
        wp_die('error');
    }

	?>
	<li>
		<aside>
			<span class="pc_del_field dashicons dashicons-no-alt" rel="<?php echo $result['term_id'] ?>" title="<?php esc_attr_e('remove restriction', 'pc_ml') ?>"></span>
            <input type="hidden" name="pc_lb_id[]" value="<?php echo $result['term_id'] ?>" />
		</aside>   
        <div class="pc_lb_inst_toprow">
        	<table><tr>
            	<td>
                	<input type="text" name="pc_lb_note[]" class="pc_lb_note" value="" placeholder="<?php esc_attr_e("Lightbox note (mandatory)", 'pc_ml') ?>" maxlength="250" autocomplete="off" />
                </td>
                <td>
                	<span><strong><?php _e('Trigger class', 'pc_ml') ?>:</strong> <em>pc_lb_trig_<?php echo $result['term_id'] ?></em></span>
                    <strong>|</strong>
                    <strong><span><?php _e('Lightbox class', 'pc_ml') ?>:</strong> <em>pc_lb_<?php echo $result['term_id'] ?></em></span>
                </td>
			</table></tr>
		</div>                
        <div class="pclb_editow_wrap">
        	<textarea id="pclb_<?php echo $result['term_id'] ?>" class="theEditor mceEditor" name="pc_lb_contents[]"></textarea>
			<strong><em><?php _e('Save settings to use full-featured editor', 'pc_ml') ?></em></strong>
            
			<script type="text/javascript">
            (function($) { 
                "use strict";  
                
                $(document).ready(function(e) {
                    tinymce.init(tinyMCEPreInit.mceInit.pg_pvtpage_default_content); // use another editor to setup these dynamic ones
                    tinymce.execCommand("mceRemoveEditor", true, "pclb_<?php echo $result['term_id'] ?>");
                    tinymce.execCommand("mceAddEditor", true, "pclb_<?php echo $result['term_id'] ?>");
                });
            }) (jQuery);
			</script>
       	</div>
	</li>
    
    <?php
	wp_die();	
}
add_action('wp_ajax_pc_add_lightbox', 'pc_add_lightbox');




////////////////////////////////////////////////////
/// LIGHTBOX INSTANCES - DELETE INSTANCE TERM //////
////////////////////////////////////////////////////

function pc_del_lightbox() {
	if (!isset($_POST['pc_nonce']) || !wp_verify_nonce($_POST['pc_nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
	
	$lb_id = trim(addslashes($_POST['lb_id'])); 
	if (!filter_var($lb_id, FILTER_VALIDATE_INT)) {wp_die('Invalid lightbox ID');}

	
	// delete WPML translation record
	if(function_exists('icl_unregister_string')) {
		icl_unregister_string('PrivateContent Lightboxes', 'Lightbox #'.$lb_id);	
	}


	echo (wp_delete_term($lb_id, 'pc_lightboxes')) ? 'success' : 'Error deleting lightbox';	
	wp_die();		
}
add_action('wp_ajax_pc_del_lightbox', 'pc_del_lightbox');





/*******************************************************************************************************************/





////////////////////////////////////////////////////
/// MENU MANAGEMENT - LOAD MENU ITEM RESTRICTIONS //
////////////////////////////////////////////////////

function pc_menu_item_restrict() {
	if (!isset($_POST['pc_nonce']) || !wp_verify_nonce($_POST['pc_nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
	
	$menu_items = $_POST['menu_items']; 
	if (!is_array($menu_items)) {wp_die('Invalid data');}

	$vals = array();
	foreach($menu_items as $item_id) {
		$val = get_post_meta($item_id, '_menu_item_pg_hide', true);
		$vals[$item_id] = (empty($val)) ? array('') : $val;
	}
	
	echo json_encode($vals);
	wp_die();	
}
add_action('wp_ajax_pc_menu_item_restrict', 'pc_menu_item_restrict');



