<?php
// DEFINING MODULE STRUCTURE AND FIELDS


class pc_pvt_block_divi_module extends ET_Builder_Module {

	public $slug       = 'pc_pvt_block';
	public $vb_support = 'on';
    public $ml_key     = 'pc_ml';
    
    
	protected $module_credits = array(
        'module_uri' => 'https://lcweb.it/privatecontent',
        'author'     => 'LCweb',
        'author_uri' => 'https://lcweb.it/',
	);

    
    public function get_advanced_fields_config() {
        return unserialize(LC_DIVI_DEF_OPTS_OVERRIDE);
	}

    
	public function init() {
		$this->name               = 'PC - '. esc_html__('Private Block', $this->ml_key);
		$this->icon_path          =  $GLOBALS['pc_divi_icon_path'];
		$this->main_css_element   = '%%order_class%%';	
        
        $this->settings_modal_toggles  = array(
			'general'  => array(
				'toggles' => array(
					'main'     => esc_html__('Main Options', $this->ml_key),
					'styling'  => esc_html__('Styling', $this->ml_key),
				),
			),
		);
	}
 
    
    
    
    // user categories array builder
	protected function pc_uc_array($bulk_opts = true, $apply_filter = true) {

		// fix for PCPP
		if(function_exists('pcpp_is_integrated_flag')) {
			pcpp_is_integrated_flag();	
		}
		
		
		$raw = pc_static::restr_opts_arr($bulk_opts, $apply_filter);
		
		$arr = array();
		foreach($raw as $block) {
			foreach($block['opts'] as $id => $name) {
				$arr[$id] = $name;	
			}
		}
		return $arr;
	}
    
    
    
	public function get_fields() {
        
        $lb_instances = array(
			''       => __('As default', $this->ml_key), 
			'none'   => __('No login button', $this->ml_key)
		) + pc_static::get_lb_instances();
        
        
        $fields =array(
            'allow' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Who can see contents?', $this->ml_key),
				'type'            => 'categories',
                'renderer_options' => array(
                    'use_terms'    => true,
                    'term_name'    => 'pg_user_categories',
                ),
                'default'         => false,
				'default_on_front'=> false,
				//'description'     => esc_html__('Choose whether your linklink opens in a new window or not', $this->ml_key),
			),
            'block' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Among allowed, want to block specific categories?', $this->ml_key),
				'type'            => 'categories',
                'renderer_options' => array(
                    'use_terms'    => true,
                    'term_name'    => 'pg_user_categories',
                ),
                'default'         => false,
				'default_on_front'=> false,
				//'description'     => esc_html__('Choose whether your linklink opens in a new window or not', $this->ml_key),
			),
            'warning' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Show warning box?', $this->ml_key),
				'type'            => 'yes_no_button',
                'default'         => 'off',
				'default_on_front'=> 'off',		
				'options'         => array(
					'off' => esc_html__('No'),
					'on'  => esc_html__('Yes'),
				),
			),	
            'message' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Custom message for not allowed users', $this->ml_key),
				'type'            => 'text',
                'default'         => '',
				'default_on_front'=> '',
                'description'     => esc_html__('Message shown if "warning" option is enabled', $this->ml_key),
			),
            'login_lb' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__("Login button's lightbox", $this->ml_key),
				'type'            => 'select',
                'default'         => '',
				'default_on_front'=> '',
				'options'         => $lb_instances,
				//'description'     => esc_html__('Choose whether your linklink opens in a new window or not', $this->ml_key),
			),
            'registr_lb' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__("Registration button's lightbox", $this->ml_key),
				'type'            => 'select',
                'default'         => '',
				'default_on_front'=> '',
				'options'         => $lb_instances,
				//'description'     => esc_html__('Choose whether your linklink opens in a new window or not', $this->ml_key),
			),
            'pvt_block_txt' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Content', $this->ml_key),
				'type'            => 'textarea',
                'default'         => '',
				'default_on_front'=> '',
                //'description'     => esc_html__('Remember you can use placeholders and FontAwesome icons as explained in settings', GG_ML),
			),
		);
        
        
        $GLOBALS[ $this->slug .'_divi_field_indexes'] = array_keys($fields);
        return $fields;
	}


    
    public function render($attrs, $content = null, $render_slug = null) {
        return pc_divi_modules::front_shortcode_render($this->slug, $this->props);  
	}
}

new pc_pvt_block_divi_module;

