<?php
// DEFINING MODULE STRUCTURE AND FIELDS


class pc_reg_form_divi_module extends ET_Builder_Module {

	public $slug       = 'pc_reg_form';
	public $vb_support = 'on';
    public $ml_key     = 'pc_ml';
    
    
	protected $module_credits = array(
        'module_uri' => 'https://lcweb.it/privatecontent',
        'author'     => 'LCweb',
        'author_uri' => 'https://lcweb.it/',
	);

    
    public function get_advanced_fields_config() {
        return unserialize(LC_DIVI_DEF_OPTS_OVERRIDE);
	}

    
	public function init() {
		$this->name               = 'PC - '. esc_html__('Registration Form', $this->ml_key);
		$this->icon_path          =  $GLOBALS['pc_divi_icon_path'];
		$this->main_css_element   = '%%order_class%%';	
        
        $this->settings_modal_toggles  = array(
			'general'  => array(
				'toggles' => array(
					'main'     => esc_html__('Main Options', $this->ml_key),
                    'styling'  => esc_html__('Styling', $this->ml_key),
				),
			),
		);
	}
 
    
	public function get_fields() {
        
        // forms list
		pc_reg_form_ct();
		$reg_forms = get_terms('pc_reg_form', 'hide_empty=0&orderby=name&order=ASC');	
		
        $reg_form_array = array();
		foreach($reg_forms as $rf) {
			$reg_form_array[$rf->term_id] = $rf->name;
		}
        
        
        
        $fields =array(
            'form_id' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Which form to use?', $this->ml_key),
				'type'            => 'select',
				'default'         => current(array_keys($reg_form_array)),
				'default_on_front'=> current(array_keys($reg_form_array)),					
				'options'         => $reg_form_array
			),
            'layout' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Layout', $this->ml_key),
				'type'            => 'select',
				'default'         => current(array_keys($reg_form_array)),
				'default_on_front'=> current(array_keys($reg_form_array)),					
				'options'         => array(
                    '' 			=> __('Default one', $this->ml_key),
                    'one_col'	=> __('Single column', $this->ml_key),
                    'fluid'		=> __('Fluid (multi column)', $this->ml_key),
			    )
			),
            'custom_categories' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Custom categories assignment', $this->ml_key),
				'type'            => 'categories',
                'renderer_options' => array(
                    'use_terms'    => true,
                    'term_name'    => 'pg_user_categories',
                ),
                'default'         => false,
				'default_on_front'=> false,
				//'description'     => esc_html__( 'Choose whether your linklink opens in a new window or not', 'dicm-divi-custom-modules' ),
			),
            'redirect' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Custom Redirect', $this->ml_key),
				'type'            => 'text',
                'default'         => '',
				'default_on_front'=> '',
                'description'     => esc_html__('Custom redirect (optional - use a valid URL or "<em>refresh</em>" keyword)', $this->ml_key),
			),
            'align' => array(
                'toggle_slug'     => 'main',
				'label'           => esc_html__('Alignment', $this->ml_key),
				'type'            => 'select',
				'default'         => 'center',
				'default_on_front'=> 'center',					
				'options'         => $GLOBALS['pc_divi_forms_align']
			),
		);
        
        
        $GLOBALS[ $this->slug .'_divi_field_indexes'] = array_keys($fields);
        return $fields;
	}


    
    public function render($attrs, $content = null, $render_slug = null) {
        return pc_divi_modules::front_shortcode_render($this->slug, $this->props);  
	}
}

new pc_reg_form_divi_module;
