<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if(!defined('ABSPATH')) exit;



class pc_user_del_on_elementor extends Widget_Base {
	
	 public function get_icon() {
      return 'emtr_lcweb_icon';
   }
	
	public function get_name() {
		return 'pc-user-del';
	}

	public function get_categories() {
		return array('privatecontent');
	}

   public function get_title() {
      return 'PC - '. __('User Deletion', 'pc_ml');
   }



   protected function register_controls() {

		$this->start_controls_section(
			'main',
			array(
				'label' => 'PrivateContent - '. __('User Deletion', 'pc_ml'),
			)
		);
  
		$this->add_control(
		   'redirect',
		   array(
			  	'label' 		=> __('Custom Redirect', 'pc_ml'),
				'type' 			=> Controls_Manager::TEXT,
				'description'	=> __('Custom redirect (use a valid URL or "<em>refresh</em>" keyword)', 'pc_ml'),
		   )
		);
		
		$this->add_control(
		   'align',
		   array(
			  'label' 	=> __('Alignment', 'pc_ml'),
			  'type' 	=> Controls_Manager::SELECT,
			  'default' => 'center',
			  'options' => array(
			  	'center' 	=> __('Center', 'pc_ml'),
				'left'		=> __('Left', 'pc_ml'),
				'right'		=> __('Right', 'pc_ml'),
			  )
		   )
		);
			
		$this->end_controls_section();
   }


	
	////////////////////////



	protected function render() {
     	$vals = $this->get_settings();
		//var_dump($vals);

		$parts = array('redirect', 'align');
		$params = '';
		
		foreach($parts as $part) {
			$params .= $part.'="';
			
			if(!isset($vals[$part])) {$vals[$part] = '';}
			$params .= $vals[$part].'" ';	
		}
		
        echo (isset($GLOBALS['pc_user_id']) && $GLOBALS['lcwp_is_elementor_builder']) ? 
            '[PrivateContent '. __('user deletion box - logout to see it', 'pc_ml') .']' : 
            do_shortcode('[pc-user-del-box '. $params .']');
	}

}
