<?php
// REGISTER BLOCK



// reg forms
$rf = array();
foreach(get_terms('pc_reg_form', 'hide_empty=0&orderby=name&order=ASC') as $term) {
	$rf[ $term->term_id ] = $term->name;
}



// user cats
$uc = array();
foreach(get_terms('pg_user_categories', 'orderby=name&hide_empty=0') as $term) {
	$uc[ $term->term_id ] = $term->name;
}




/*
// user categories array builder
//// fix for PCPP
if(function_exists('pcpp_is_integrated_flag')) {
	pcpp_is_integrated_flag();	
}

$raw = pc_static::restr_opts_arr($bulk_opts, $apply_filter);

$pc_restr_opts = array();
foreach($raw as $block) {
	foreach($block['opts'] as $id => $name) {
		$pc_restr_opts[$id] = $name;	
	}
}
*/





// structure
$defaults = array(
	'id' => array(
		'label'		=> __('Which form?', 'pc_ml'),
		'type'		=> 'select',
		'opts'		=> $rf,
		'default' 	=> current(array_keys($rf)),
		'panel'		=> 'main',
	),
	'layout' => array(
		'label'		=> __('Layout', 'pc_ml'),
		'type'		=> 'select',
		'opts'		=> array(
			''			=> __('Default one', 'pc_ml'),
			'one_col'	=> __('Single column', 'pc_ml'),
			'fluid'		=> __('Fluid (multi column)', 'pc_ml'),
		),
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'custom_categories' => array(
		'label'		=> __('Custom categories assignment (ignored if field is in form)', 'pc_ml'),
		'type'		=> 'multi-opt',
		'opts'		=> $uc,
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'redirect' => array(
		'label'		=> __('Custom redirect', 'pc_ml'),
		'help'		=> __('Use a valid URL or "refresh" keyword', 'pc_ml'),
		'type'		=> 'text',
		'default' 	=> '',
		'panel'		=> 'main',
	),
	'pc_align' => array(
		'label'		=> __('Form alignment', 'pc_ml'),
		'type'		=> 'select',
		'opts'		=> array(
			'center'	=> __('Center', 'pc_ml'),
			'left'		=> __('Left', 'pc_ml'),
			'right'		=> __('Right', 'pc_ml'),
		),
		'default' 	=> 'center',
		'panel'		=> 'main',
	),
);




$defaults = pc_fix_block_defs($defaults);

register_block_type('lcweb/pc-registration-form', array(
	'editor_script' 	=> 'pc_registr_on_guten',
	'render_callback' 	=> 'pc_registr_guten_handler',
	'attributes' 		=> $defaults
));


wp_localize_script('wp-blocks', 'pc_registr_defaults', $defaults);
