<?php
// GOOGLE ANALYTICS IMPLEMENTATION - USER TRACKING

class pc_google_analytics {
	
	public $tid; // (string) google tracking ID (UA-XXXX-XX / G-XXXXXXXXXX)
	public $gtm_id; // (string) Google Tag Manager ID (GTM-XXXXXXX)
    public $ga4_api_secret; // (string)
    

	public function __construct() {
        $analytics_version = get_option('pg_analytics_v', 'ua'); 
        $tid_option_name = ($analytics_version == 'ua') ? 'pg_analytics_id' : 'pg_ga4_id';
        
		$this->tid = get_option($tid_option_name);
		if(empty($this->tid)) {
            return false;
        }
        
        if($analytics_version == 'ga4') {
            $this->gtm_id = get_option('pg_gtm_id');
            $this->ga4_api_secret = get_option('pg_ga4_api_secret');
            
            if(empty($this->gtm_id) || empty($this->ga4_api_secret)) {
                return false;
            }
        }

        
        // GA4 - user ID setup
        if(!is_admin() && $analytics_version == 'ga4') {
            add_action('wp_head', array($this, 'set_ga4_userid'), 1);
            add_action('wp_footer', array($this, 'add_gtm_footer_code'), 9999);
        }
        
        
        if($analytics_version != 'ga4') {
            // UA - user pageview	
            if(!is_admin()) {
                add_action('wp_footer', array($this, 'try_ga_userid'), 9999);
                
                add_action('wp_head', array($this, 'pageview'), 1);
            }	

            // registration
            add_action('pc_registered_user', array($this, 'registration'), 10, 2);

            // login
            add_action('pc_user_login', array($this, 'login'));

            // logout
            add_action('pc_user_logout', array($this, 'logout'));
        }
	}

    
	
    
    /* get user ID in the analytics format */
    public static function get_ga_uid() {
        return (isset($GLOBALS['pc_user_id'])) ? 'pc-'.$GLOBALS['pc_user_id'] : '';  
    }
    
    
    
    
    
    
	
	////////////////////////////////////////////////////////////////
    ### ANALYTICS 4 ###
	
	
    
    /* GA4 - setup user ID parameter and eventually inject Google codes */
    public function set_ga4_userid() {
        if(empty($this->tid) || empty($this->gtm_id)) {
            return false;        
        }
        ?>
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo esc_attr($this->tid) ?>"></script>
        <script type="text/javascript">
        (function() { 
            "use strict"; 
            
            window.dataLayer = window.dataLayer || [];
            window.dataLayer.push({
              'pc_user_id': <?php echo (isset($GLOBALS['pc_user_id'])) ? "'". self::get_ga_uid() ."'" : 'null' ?>
            });
               
            <?php if(get_option('pg_ga4_inject_js_code')) : ?>    
                window.dataLayer = window.dataLayer || [];
                window.gtag = function(){dataLayer.push(arguments);}
                gtag('js', new Date());

                gtag('config', '<?php echo esc_attr($this->tid) ?>');

                (function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
                new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
                j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
                'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
                })(window,document,'script','dataLayer','<?php echo esc_attr($this->gtm_id) ?>');
            <?php endif; ?>
            
            
            window.pc_ga4_event = function(event_name, params = {}, forced_uid = false) {
                const pc_uid = (forced_uid) ? 'pc-'+ forced_uid : `<?php echo self::get_ga_uid() ?>`;
                
                if(!pc_uid) {
                    return false;    
                }
                else {
                    if(typeof(window.gtag) != 'function') {
                        console.error('PrivateContent on ga4: gtag() function not found');    
                    }
                    else {
                        params.user_id = pc_uid;
                        return gtag('event', event_name, params);
                    }
                }
            };
        })();
        </script>    
        <?php     
    }
    
    
    
    /* eventually inject Google Tag Manager footer code */
    public function add_gtm_footer_code() {
        if(get_option('pg_ga4_inject_js_code')) {
            ?>
            <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=<?php echo esc_attr($this->gtm_id) ?>" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
            <?php
        }
    }
    
    
    
	
    
    /* GA4 - create custom event */
    public function trigger_event($event_id, $params = array(), $forced_uid = false) {
        if(empty($this->tid) || empty($this->ga4_api_secret)) {
            return false;        
        }
        
        $ga4_args = array(	
            'client_id' => $_SERVER['HTTP_USER_AGENT'],
            'user_id'   => ($forced_uid) ? 'pc-'.$forced_uid : self::get_ga_uid(),
            'events'    => array(
                array(
                    'name'  => $event_id,
                    'params'=> $params
                ),
            ),
        );
        return wp_remote_post('https://www.google-analytics.com/mp/collect?measurement_id='. $this->tid .'&api_secret='. esc_attr($this->ga4_api_secret), 
            array('body' => json_encode($ga4_args))
        );
    }
    
	
    
    
    
    
    
	
	////////////////////////////////////////////////////////////////
    ### UNIVERSAL ANALYTICS ###
    
    
    // set user ID
	public function try_ga_userid() {
		if(!isset($GLOBALS['pc_user_id']) || !get_option('pg_analytics_id')) {return false;}
		?>
        <script type="text/javascript">
        (function($) { 
            "use strict";   
            
            if(typeof(ga) == 'function') {
                ga('set', 'userId', '<?php echo self::get_ga_uid() ?>');	
            }
        })(jQuery);    
		</script>
        <?php
	}
    
    
	
	/* Logged User pageview */
	public function pageview() {
		if(!isset($GLOBALS['pc_user_id'])) {
            return false;
        }

		$params = array(
			't'		=> 'pageview',
			//'ni'	=> 1,
			//'sc'	=> 'start',
		);
		$resp = $this->call($params, $GLOBALS['pc_user_id']);	
	}
	
	
	
	/* registration event */
	public function registration($user_id, $user_status) {
		$params = array(
			't'		=> 'event',
			'ec'	=> 'PrivateContent',
			'ea'	=> 'registration',
			'el'	=> 'User Registration',
			'ni'	=> 0,
		);
		$resp = $this->call($params, $user_id);	

		$this->uid = '';
	}
	
	
	
	/* login event */
	public function login($user_id) {
		$params = array(
			't'		=> 'event',
			'ec'	=> 'PrivateContent',
			'ea'	=> 'login',
			'el'	=> 'User Login',
			'ni'	=> 0,
			'sc'	=> 'start'
		);
		$resp = $this->call($params, $user_id);	
	}
	
	
	
	/* logout event */
	public function logout($user_id) {
		$params = array(
			't'		=> 'event',
			'ec'	=> 'PrivateContent',
			'ea'	=> 'logout',
			'el'	=> 'User Logout',
			'ni'	=> 0,
			'sc'	=> 'end'
		);
		$resp = $this->call($params, $user_id);	
		
		$this->uid = '';
	}
	
	

	/* get user IP */
	private function get_user_IP() {
		$client  = @$_SERVER['HTTP_CLIENT_IP'];
		$forward = @$_SERVER['HTTP_X_FORWARDED_FOR'];
		$remote  = $_SERVER['REMOTE_ADDR'];
		
		if(filter_var($client, FILTER_VALIDATE_IP)) {
			$ip = $client;
		}
		elseif(filter_var($forward, FILTER_VALIDATE_IP)) {
			$ip = $forward;
		}
		else {
			$ip = $remote;
		}
		return $ip;	
	}
	
	
	
	/* POST call to use Google Measurement Protocol */
	public function call($params, $user_id = false) {

		// get url without base
		$url = str_replace(get_home_url(), '', pc_static::curr_url());

		$fixed_params = array(
			'v'		=> 1,
			'tid'	=> $this->tid,
			'ds'	=> 'crm',
			'dt'	=> wp_title('', false) . ' | ', 
			'z'		=> rand(1000000, 9999999),
			'uid'	=> 'pc-'. $user_id,
			'dp'	=> $url,
			'an'	=> 'LCweb PrivateContent',
			'av'	=> PC_VERS,
			'uip'	=> $this->get_user_IP(),
			'ua'	=> $_SERVER['HTTP_USER_AGENT'],
			
		);
		$params = array_merge($fixed_params, $params);
        
		return wp_remote_post('https://www.google-analytics.com/collect', 
			array('body' => $params)
		);
	}
    
}


$GLOBALS['pc_google_analytics'] = new pc_google_analytics; // todo - remove it when UA will be disabled