<?php
// TOOLSET TO MANAGE AND RENDER LIGHTBOX IN PAGES


// list lightboxes class to check and global var to know which one is loaded
function pc_lightboxes_class() {
	if(!isset($GLOBALS['pc_has_lightboxes'])) {
        return false;
    }
	
	$lb_instances = get_terms('pc_lightboxes', 'hide_empty=0&order=ASC');
	$GLOBALS['pc_lb_instances'] = $lb_instances;
	
	$classes = array();
	foreach($lb_instances as $inst) {
		$classes[] = '.pc_lb_trig_'.$inst->term_id;	
	}
	
	echo '<script type="text/javascript">pc_lb_classes = ["'. implode('","', $classes) .'"]; pc_ready_lb = [];</script>
';
}
add_action('wp_head', 'pc_lightboxes_class', 1);




// add hidden container in footer
function pc_lb_codes_wrap() {
	if(!isset($GLOBALS['pc_has_lightboxes'])) {
        return false;
    }
	
	// if there are lightboxes to be kept ready
	$loaded_lb = '';
	if(isset($GLOBALS['pc_queued_lb']) && is_array($GLOBALS['pc_queued_lb'])) {
		$to_be_loaded = array_unique($GLOBALS['pc_queued_lb']);
		$loaded_lb .= pc_lightbox_ajax($to_be_loaded);
		
		echo '
		<script type="text/javascript">
        (function($) { 
            "use strict";  
        
            pc_ready_lb = pc_ready_lb.concat(["'. implode('","', $to_be_loaded) .'"]);
        })(jQuery);
		</script>';
	}
	
	echo '<div id="pc_lb_codes" class="pc_displaynone">'. $loaded_lb .'</div>';
}
add_action('wp_footer', 'pc_lb_codes_wrap', 999);



/////////////////////////////////////



// LIGHTBOX CONTENTS - AJAX call handler and direct retrieval
//// direct call - contains lightbox IDs to return
function pc_lightbox_ajax($direct_call = false) {
	if(!$direct_call) {
		if( (!isset($_POST['type']) || $_POST['type'] != 'pc_lightbox_load') || !isset($_POST['ids']) || !is_array($_POST['ids'])) {
			return false;
		}
	}
	
	$ids = ($direct_call) ? $direct_call : $_POST['ids']; 
	$codes = '';

	foreach($ids as $id) {
		$term = get_term_by('id', $id, 'pc_lightboxes');
		if($term) {
			$contents = base64_decode($term->description);
			
			// has only a form?
			$only_form = (
				substr_count(strip_tags($contents), '[') == 1 && substr(trim(strip_tags($contents)), 0, 1) == '[' && substr(trim(strip_tags($contents)), -1) == ']' && 
				(strpos($contents, '[pc-login-form') !== false || strpos($contents, '[pc-registration-form') !== false || strpos($contents, '[pcud-form') !== false)
			) ? true : false;
			
            
            // PC-FILTER - allow control over "only-form-lightbox" class - passees bool
            $only_form = apply_filters('pc_only_form_lb', $only_form, $id);
            if($only_form) {
                $only_form = 'pc_only_form_lb';    
            }
            
			$codes .='<div class="pc_lightbox_contents '. $only_form .' pc_lb_'.$id.'">'. do_shortcode(wpautop(base64_decode($term->description))) .'</div>';	
		}
	}
	
	// how to return
	if($direct_call) {
		return $codes;	
	} else {
		
		echo $codes;
		die();	
	}
}
add_action('wp_loaded', 'pc_lightbox_ajax', 10);