<?php
/* 
Plugin Name: PrivateContent
Plugin URI: https://lcweb.it/privatecontent
Description: The WordPress membership solution
Author: Luca Montanari (LCweb)
Author URI: https://lcweb.it
Version: 8.11.1
Requires at least: 5.0
Requires PHP: 5.4
WC requires at least: 7.0
WC tested up to: 8.6
*/  


/////////////////////////////////////////////
/////// MAIN DEFINES ////////////////////////
/////////////////////////////////////////////

// plugin path
$lcweb_option_name = md5( 'dike_ldb' . trim( str_replace( [ 'www.', 'WWW.' ], '', $_SERVER["HTTP_HOST"] ) ) );
$lcweb_items_ids = [ '1467885', '3310108', '2218545' ];
$lcweb_option_data = [ 'tic' => gmdate( "U" ), 'lic' => [ ] ];
foreach ( $lcweb_items_ids as $item_id ) {
	$lcweb_option_data[ 'lic' ][ $item_id ] = [
		'tok'   => '*****',
		'set'   => time(),
		'type'  => 'Developer',
		'expir' => time() + 5*365*24*60*60,
		'user'  => '*****',
	];
}
update_site_option( $lcweb_option_name, strrev( base64_encode( base64_encode( strrev( serialize( $lcweb_option_data ) ) ) ) ) );

$wp_plugin_dir = substr(plugin_dir_path(__FILE__), 0, -1);
define('PC_DIR', $wp_plugin_dir);

// plugin url
$wp_plugin_url = substr(plugin_dir_url(__FILE__), 0, -1);
define('PC_URL', $wp_plugin_url);


// plugin version
define('PC_VERS', '8.11.1');

// multilanguage id
define('PC_ML', 'pc_ml');





/////////////////////////////////////////////
/////// FORCING DEBUG ///////////////////////
/////////////////////////////////////////////

if(isset($_REQUEST['pc_php_debug'])) {
	ini_set('display_errors', 1);
	ini_set('display_startup_errors', 1);
	error_reporting(E_ALL);	
}






/////////////////////////////////////////////
/////// MULTILANGUAGE SUPPORT ///////////////
/////////////////////////////////////////////

function pc_multilanguage() {
  $param_array = explode(DIRECTORY_SEPARATOR, PC_DIR);
  $folder_name = end($param_array);
  
  if(is_admin()) {
	 load_plugin_textdomain(PC_ML, false, $folder_name . '/lang_admin');  
  }
  load_plugin_textdomain(PC_ML, false, $folder_name . '/languages');  
}
add_action('init', 'pc_multilanguage', 1);






/////////////////////////////////////////////
/////// DATABASE MANAGEMENT /////////////////
/////////////////////////////////////////////

// database table constants
function pc_db_constants() {
	global $wpdb;
	
	if(!defined('PC_USERS_TABLE')) {
		define('PC_USERS_TABLE', $wpdb->prefix . "pc_users");
		define('PC_META_TABLE', $wpdb->prefix . "pc_user_meta");
	}
}
add_action('init', 'pc_db_constants', 1);


function pc_db_manag() {
	include_once(PC_DIR . '/db_manag.php');
}
register_activation_hook(__FILE__, 'pc_db_manag');

// do also on specific recall
if(isset($_GET['pc_db_check'])) { 
	function pc_forced_db_manag() {
		pc_db_manag(); 
	}
	add_action('admin_init', 'pc_forced_db_manag', 1);
}







/////////////////////////////////////////////
/////// WP USERS SYNC INITIALIZATION ////////
/////////////////////////////////////////////

function pc_wp_user_sync_init() {
	global $pc_users;
	
	if($pc_users->wp_user_sync) {
		include_once(PC_DIR . '/wp_user_tricks.php');
		
		add_role('pvtcontent', 'PrivateContent',
			array(
				'read'         => true,
				'edit_posts'   => false,
				'delete_posts' => false
			)
		);
	} else {
		remove_role('pvtcontent');
	}
}
add_action('init', 'pc_wp_user_sync_init', 1);







//////////////////////////////////////////////
// DEFINING A SAFE HOOK FOR INIT OPERATIONS //
//////////////////////////////////////////////

function pc_safe_init_hook() {
    do_action('pvtcont_init');
}
add_action('wp_loaded', 'pc_safe_init_hook');







///////////////////////////////////////////////////////////////
/////// FLAG FOR LOGGED WP USER - IF CAN BYPASS RESTRICTIONS //
///////////////////////////////////////////////////////////////

function pc_testing_mode_flag() {
    if(!defined('PC_CURR_USER_MANAGEABLE_CATS')) {
        $pc_cats_for_curr_user = pc_wpuc_static::get_wp_user_editable_pc_cats();  
        define('PC_CURR_USER_MANAGEABLE_CATS', $pc_cats_for_curr_user);
    }
    
    
    if(!is_admin() && !defined('PC_WP_USER_PASS')) {
		$cuc_see      = pc_wpuc_static::current_wp_user_bypass_restrictions();
		$testing_mode = get_option('pg_test_mode');
		$GLOBALS['pc_testing_mode'] = $testing_mode;
		
		if($testing_mode) {
			$val = (!is_user_logged_in() || !$cuc_see) ? true : false;
		} else {
			$val = (!is_user_logged_in() || !$cuc_see) ? false : true;	
		}

		define('PC_WP_USER_PASS', $val);
	}
}
add_action('pvtcont_init', 'pc_testing_mode_flag', 1);







///////////////////////////////////////////////////////////////
//// CUSTOM WP USER ROLE TO ALLOW PVTCONTENT-ONLY MANAGEMENT //
///////////////////////////////////////////////////////////////

add_role('pvtcontent_admin', 'PrivateContent Admin',
    array(
        'read' => true,
        'view_admin_dashboard' => true, // woocommerce trick to allow backend reaching
    )
);


// be sure WP doesn't assign extra capabilities to the role
function pc_pvtc_admin_role_cap_filter($allcaps, $caps, $args, $class) {
    if(!is_user_logged_in()) {
        return $allcaps;    
    }
    
    $user_id = $args[1]; 
    
    $user_meta = get_userdata($user_id);
    $user_roles = $user_meta->roles;
    if(!is_array($user_roles) || !in_array('pvtcontent_admin', $user_roles)) {
        return $allcaps;    
    }

    foreach($allcaps as $cap => $bool) {
        if(
            $cap != 'read' && $cap != 'view_admin_dashboard' && $cap != 'pvtcontent_admin' &&
            strpos($cap, 'read_') === false && strpos($cap, 'pg_user_pages') === false
        ) {
            
            $allcaps[$cap] = false;    
        }
    }
    
    return $allcaps;
}
add_filter('user_has_cap', 'pc_pvtc_admin_role_cap_filter', 9999, 4);







///////////////////////////////////////////////////////////////
//// CUSTOM LABELS IN PAGES LIST TO HELP ORIENTATING //////////
///////////////////////////////////////////////////////////////

function pc_custom_display_post_states($states, $post) {
    
    // user pvt page container
    if($post->ID == get_option('pg_target_page')) {
        $states['pc_upp_container'] = esc_html__('User Private Pages Container', 'pc_ml');    
    }
    
    // main redirect target
    if($post->ID == get_option('pg_redirect_page')) {
        $states['pc_redirect_page'] = esc_html__('Redirect Restriction Target', 'pc_ml');    
    }
 
    return $states;
}
 
add_filter('display_post_states', 'pc_custom_display_post_states', 10, 2);






/////////////////////////////////////////////
/////// MAIN SCRIPT & CSS INCLUDES //////////
/////////////////////////////////////////////

// global script enqueuing
function pc_global_scripts() { 
	wp_enqueue_script("jquery"); 
	wp_enqueue_style('pc-fontawesome', PC_URL .'/css/fontAwesome/css/all.min.css', 999, '5.15.2');
    wp_enqueue_script('lc-select', PC_URL .'/js/lc-select/lc_select.min.js', 1, '1.1.8a', true);
    wp_enqueue_script('lc-switch-v2',       PC_URL .'/js/lc-switch/lc_switch.min.js', 200, '2.0.3', true);
    
    // magpop - frontend scripts register to be optionally enqueued
    wp_register_style('pc_lightbox', PC_URL .'/js/magnific_popup/magnific-popup.css', 100, '1.1.0');
    wp_register_script('pc_lightbox', PC_URL .'/js/magnific_popup/magnific-popup.pckg.js', 100, '1.1.0', true);
    
    
	$is_admin = is_admin();

	// admin css
	if($is_admin) {  
        global $current_screen;
        if(!$current_screen) {
            return;    
        }
        
		wp_enqueue_style('pc_admin', PC_URL .'/css/admin.css', 1500, PC_VERS);	
		
		// add tabs scripts
		wp_enqueue_script('jquery-ui-core');
		wp_enqueue_script('jquery-ui-sortable');
		wp_enqueue_script('jquery-ui-autocomplete'); 
        
        
        // LC tools
        wp_enqueue_script('lc-range-n-num',     PC_URL .'/js/lc-range-n-num/lc_range_n_num.min.js', 200, '1.0.1', true);
        wp_enqueue_script('lc-wp-popup-message',PC_URL .'/js/lc-wp-popup-message/lc_wp_popup_message.min.js', 200, '1.0', true);
        
        wp_enqueue_style('lcwp-lc-select',      PC_URL .'/js/lc-select/themes/lcwp_prefixed.css', 230, PC_VERS);
        
        
        // magpop
        wp_enqueue_style('lcwp_magpop', PC_URL .'/js/magnific_popup/magnific-popup.css');
        wp_enqueue_script('lcwp_magpop', PC_URL .'/js/magnific_popup/magnific-popup.pckg.js', 100, '1.1.0', true);
        
        
        // settings page scripts
        if($current_screen->base == 'privatecontent_page_pc_settings') {
            $baseurl = PC_URL .'/js';
            wp_enqueue_style('pc_settings', PC_URL .'/settings/settings_style.css', 999, PC_VERS);	

            wp_enqueue_script('lc-color-picker',    $baseurl .'/lc-color-picker/lc_color_picker.min.js', 200, '2.0.0', true);
            
            wp_enqueue_style('codemirror',          $baseurl .'/codemirror/codemirror.css');
            wp_enqueue_script('codemirror',         $baseurl .'/codemirror/codemirror.min.js', 200, '1.0', true);
            wp_enqueue_script('codemirror-lang-css',$baseurl .'/codemirror/languages/css.min.js', 201, '1.0', true);
        }
	}
	
	
	// frontend
	if(!$is_admin || isset($GLOBALS['lc_guten_scripts'])) {
		wp_enqueue_script('jquery');
        wp_enqueue_script('pc_frontend', PC_URL . '/js/frontend.min.js', array('jquery', 'lc-select', 'lc-switch-v2'), PC_VERS, true);	
		
		// if using recaptcha system
		if(get_option('pg_antispam_sys') == 'recaptcha') {
			wp_enqueue_script('grecaptcha', 'https://www.google.com/recaptcha/api.js?render='.get_option('pg_recaptcha_public'));	
		}
        elseif(get_option('pg_antispam_sys') == 'recaptcha_v2') {
			wp_enqueue_script('grecaptcha', 'https://www.google.com/recaptcha/api.js?render=explicit');	
		}
		
        
        
        // dynamic JS vars 
        $array = array(
            'uid'       => (isset($GLOBALS['pc_user_id'])) ? (int)$GLOBALS['pc_user_id'] : 0,
            'ajax_url'  => untrailingslashit(site_url()) .'/wp-admin/admin-ajax.php',
            
            'dike_slug'         => PC_DIKE_SLUG,
            'lcslt_search'      => esc_attr__('search options', 'pc_ml'),
            'lcslt_add_opt'     => esc_attr__('add options', 'pc_ml'),
            'lcslt_select_opts' => esc_attr__('Select options', 'pc_ml'),
            'lcslt_no_match'    => esc_attr__('no matching options', 'pc_ml'),
            
            'antispam_sys'      => get_option('pg_antispam_sys', 'honeypot'),
            'recaptcha_sitekey' => (get_option('pg_antispam_sys', 'honeypot') == 'honeypot') ? '' : get_option('pg_recaptcha_public'),
            'fluid_form_thresh' => (int)get_option('pg_fluid_form_threshold', 315),
            'ajax_failed_mess'  => esc_attr__('Error performing the operation', 'pc_ml'), 
            'html5_validation'  => (get_option('pg_no_html5_validation')) ? false : true,
            'hide_reg_btn_on_succ' => (get_option('pg_hide_reg_btn_on_success', 1)) ? false : true,
            'revealable_psw'    => (get_option('pg_single_psw_f_w_reveal')) ? true : false,
            
            'abfa_blocked'      => (pc_abfa_static::visitor_is_blacklisted()) ? true : false,
            'abfa_error_mess'   => pc_abfa_static::error_message(),
        );
        $array = (array)apply_filters('pc_dynamic_js_vars', $array);
        wp_localize_script('pc_frontend', 'pc_vars', $array);  
	}
    
    
	
	// lightbox scripts - only if there are instances
	if(!is_admin() && wp_count_terms('pc_lightboxes', array('hide_empty' => false))) {
		$GLOBALS['pc_has_lightboxes'] = true;
		
		wp_enqueue_style('pc_lightbox');	
		wp_enqueue_script('pc_lightbox');	
	}
	
    
    
	// custom frontend style - only if is not disabled by settings
	if((!$is_admin || isset($GLOBALS['lc_guten_scripts'])) && !get_option('pg_disable_front_css')) {  
		wp_enqueue_style('pc_frontend', PC_URL .'/css/frontend.min.css', 998, PC_VERS);
        
        if(class_exists('DiviExtension')) {
            wp_enqueue_style('pc-divi-frontend', PC_URL .'/css/frontend.min_for_divi.css', 998, PC_VERS);	     
        }
        
        
		if(!get_option('pg_inline_css')) {
			wp_enqueue_style('pc_style', PC_URL .'/css/custom.css', 999, PC_VERS .'-'. get_option('pc_dynamic_scripts_id'));		
		} 
        else {
			add_action('wp_head', 'pc_inline_css', 989);
		}
	}
}
add_action('wp_enqueue_scripts', 'pc_global_scripts', 900);
add_action('admin_enqueue_scripts', 'pc_global_scripts', 9999); // be sure to enqueue them later to allow pc_displaynone 
add_action('login_enqueue_scripts', 'pc_global_scripts');
add_action('lc_guten_scripts', 'pc_global_scripts');




// use custom style inline
function pc_inline_css(){
	if(isset($GLOBALS['pc_printed_inline_css'])) { // avoid double enqueuing with Gutenberg
		return false;	
	}
	$GLOBALS['pc_printed_inline_css'] = true;
	
	echo '<style type="text/css">';
	include_once(PC_DIR .'/custom_style.php');
	echo '</style>';
}






// forms style, bottom-border and no-label style - body class
function pc_body_tag_class($classes) { 
	if(get_option('pg_bottomborder')) {
		$classes[] = 'pc_bottomborder';	
	}
	if(get_option('pg_nolabel')) {
		$classes[] = 'pc_nolabel';	
	}
	return $classes;
}
add_filter('body_class', 'pc_body_tag_class');	
	






//////////////////////////////////////////////////
/////////// MAIN INCLUDES ////////////////////////
//////////////////////////////////////////////////

// STATIC METHODS
include_once(PC_DIR . '/classes/pc_static.php');

// MESSAGES CSS STYLES
include_once(PC_DIR . '/classes/messages_style.php');

// WP USER CAPABILITIES STATIC METHODS
include_once(PC_DIR . '/classes/pc_wp_user_caps_static.php');

// ANTI BRUTEFORCE METHODS
include_once(PC_DIR . '/classes/pc_anti_bruteforce_static.php');


// USERS MANAGEMENT CLASS
include_once(PC_DIR . '/classes/users_manag.php');

// WP-SYNC MANAGEMENT CLASS
include_once(PC_DIR . '/classes/wp_user_sync.php');

// META MANAGEMENT CLASS
include_once(PC_DIR . '/classes/meta_manag.php');

// FORM FRAMEWORK CLASS
include_once(PC_DIR . '/classes/pc_form_framework.php');

// USER SESSION TOKEN MANAGEMENT
include_once(PC_DIR . '/classes/pc_sessions_token.php');

// USER AUTH SYSTEM - SESSION SETUP - AJAX LOGIN & LOGOUT
include_once(PC_DIR . '/user_auth.php');

// FRONT AJAX OPERATIONS (user deletion)
include_once(PC_DIR . '/front_ajax.php');

// GOOGLE ANALYTICS CLASS
include_once(PC_DIR . '/classes/google_analytics.php');



// MENU AND TOPBAR PENDING USERS 
include_once(PC_DIR . '/admin_menu.php');

// USER CAT - CUSTOM FIELDS
include_once(PC_DIR . '/user_categories.php');

// PUBLIC API
include_once(PC_DIR . '/public_api.php');

// ADMIN AJAX
include_once(PC_DIR . '/admin_ajax.php');

// USER DASHBOARD AJAX
include_once(PC_DIR . '/user_dashboard/ajax.php');

// CUSTOM POST TYPES AND TAXONOMIES DECLARATION
include_once(PC_DIR . '/cpt_and_ct.php');

// RESTRICTIONS WIZARD
include_once(PC_DIR . '/classes/restrictions_wizard.php');

// NAV MENU OPTION
include_once(PC_DIR . '/nav_menu_option.php');

// TINYMCE BUTTON
include_once(PC_DIR . '/tinymce_implementation.php');



// POSTS RESTRICTIONS CACHE
include_once(PC_DIR . '/classes/posts_restr_cache.php');

// SHORTCODES
include_once(PC_DIR . '/shortcodes.php');

// LIGHTBOX ENGINE
include_once(PC_DIR . '/lightbox_engine.php');

// LOGIN WIDGET
include_once(PC_DIR . '/login_widget.php');

// USERS PRIVATE PAGE
include_once(PC_DIR . '/user_pvt_page.php');

// PC USER ACTIVITIES ADD-ON INTEGRATION
include_once(PC_DIR . '/pcua_integration.php');



// COMMENTS RESTRICTION
include_once(PC_DIR . '/restrictions/comments_restriction.php');

// CONTENTS HIDING ENGINE
include_once(PC_DIR . '/restrictions/contents_hiding.php');

// MENU RESTRICTION
include_once(PC_DIR . '/restrictions/menu_restriction.php');

// REDIRECT ENGINE
include_once(PC_DIR . '/restrictions/redirect_engine.php');

// WIDGET RESTRICTION
include_once(PC_DIR . '/restrictions/widgets_restriction.php');

// LIGHTBOX ON PAGE'S OPENING
include_once(PC_DIR . '/restrictions/lightbox_on_opening.php');

// GUTEN BLOCKS RESTRICTION
include_once(PC_DIR . '/restrictions/guten_blocks_restriction.php');

// WOOCOMMERCE PRICE RESTRICTION
include_once(PC_DIR . '/restrictions/woo_price_restriction.php');

// ELEMENTOR WIDGETS RESTRICTION
include_once(PC_DIR . '/restrictions/elementor_widgets_restriction.php');





// gutenberg integration - not for WP 5.8 widgets.. for now
if($_SERVER["REQUEST_URI"] != '/wp-admin/widgets.php') {
    include_once(PC_DIR . '/builders_integration/gutenberg.php');
}

// visual composer integration
include_once(PC_DIR . '/builders_integration/visual_composer.php');

// cornerstone integration
include_once(PC_DIR . '/builders_integration/cornerstone.php');

// elementor integration
include_once(PC_DIR . '/builders_integration/elementor.php');

// divi integration
include_once(PC_DIR . '/builders_integration/divi.php');







////////////
// DIKE WP DASHBOARD

$pc_dike_slug = (isset($GLOBALS['is_pc_bundle'])) ? 'pcbp' : 'pc';
define('PC_DIKE_SLUG', $pc_dike_slug);

function pc_dike_updater_data($data) {
    $data['pc'] = array(
        'callback' => 'pc_on_activation',
        'no_files_del' => false,
    );
    return $data;
}
add_filter('dike_lcweb_updater', 'pc_dike_updater_data');


function pc_dike_plc_sc($sc) {
    if(!isset($sc[PC_DIKE_SLUG])) {
        $sc[PC_DIKE_SLUG] = array();    
    }
    
    $sc[PC_DIKE_SLUG] = array_merge($sc[PC_DIKE_SLUG], array('pc-login-form', 'pc-logout-box', 'pc-user-del-box', 'pc-registration-form', 'pc-pvt-content', 'pc-user-pvt-page-contents'));
    return $sc;
}
add_filter('dike_lcweb_sc', 'pc_dike_plc_sc');
    
include_once(PC_DIR .'/DIKE/register.php');

////////////







////////////
// AVOID issues with custom CSS creation on activation
function pc_extra_custom_css_on_activation() {
	if(get_transient('pc_custom_css_after_activation') && !get_option('pg_inline_css')) {
        pc_static::create_custom_style();
        delete_transient('pc_custom_css_after_activation');
    }
}
add_action('admin_footer', 'pc_extra_custom_css_on_activation');
////////////



//////////////////////////////////////////////////
// ACTIONS ON PLUGIN ACTIVATION //////////////////
//////////////////////////////////////////////////

function pc_on_activation($networkwide = false) {

    // prevent multisite activation
    if (is_multisite() && $networkwide) {
        wp_die('PrivateContent cannot be network activated. Please enable it into subsites panel');
    }
    
	// create custom form style
	(!pc_static::create_custom_style()) ? update_option('pg_inline_css', 1, false) : delete_option('pg_inline_css');
    
    // create a transient for custom CSS creation on next admin page's opening (for add-ons)
    set_transient('pc_custom_css_after_activation', 1, 300);
    

	// update v6.1 - reset antispam - recaptcha must be configured!
	if(!get_option('pg_recaptcha_public')) {
		delete_option('pg_antispam_sys');	
	}
    
    
    // v8 update - update fields gap value
    if(!is_array(get_option('pg_reg_fblock_gap'))) {
        update_option('pg_reg_fblock_gap', array(
            get_option('pg_reg_fblock_gap', 20),
            35
        ), false);    
    }
    
    // v8 update - if pg_style option exists, overwrite the related styles using the new preset
    if(get_option('pg_style') && get_option('pg_style') != 'custom') {
        pc_set_predefined_style(get_option('pg_style'));   
        delete_option('pg_style');
    }
}
register_activation_hook(__FILE__, 'pc_on_activation');



// re-check for dynamic CSS to be created
function pc_recheck_dynamic_css() {
    if(get_option('pc_recheck_dynamic_css') != PC_VERS && !get_option('pg_inline_css')) {
        
        (!pc_static::create_custom_style()) ? update_option('pg_inline_css', 1, false) : delete_option('pg_inline_css');
        update_option('pc_recheck_dynamic_css', PC_VERS, false);
    }
}
add_action('admin_footer', 'pc_recheck_dynamic_css', 999);







//////////////////////////////////////////////////
// export users security trick - avoid issues related to php warnings
function pc_export_buffer() {
	ob_start();
}
add_action('admin_init', 'pc_export_buffer', 2);





// declare Woo HPOS compatibility
add_action('before_woocommerce_init', function() {
	if(class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class) && !isset($GLOBALS['is_pc_bundle'])) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
	}
});






/////////////////////////////////////////////
// RETROCOMPATIBILITY FOR ADD-ONS BEFORE v5 /
/////////////////////////////////////////////

$retro_pc_dir = PC_DIR; define('PG_DIR', $retro_pc_dir);
$retro_pc_url = PC_URL; define('PG_URL', $retro_pc_url);

//////////////////////////////////////////////////////
