<?php
// WIDGET RESTRICTION - BACKEND AND FRONTEND


// Add fields fields
function pc_widget_restriction_fields($t, $return, $instance){
	global $current_screen;
	
	// not in live builder - avoid layers/elementor interference
	if($_SERVER["REQUEST_URI"] != '/wp-admin/admin-ajax.php' || !is_null($current_screen)) {
		if(is_object($current_screen) && $current_screen->base != 'widgets') {
            return false;
        }
	}

	$field_id = $t->get_field_id('pc_allow');
	$instance = wp_parse_args( (array)$instance, array( 'title' => '', 'text' => '', 'pc_allow' => array()));
    
	if(!isset($instance['pc_allow']) || !is_array($instance['pc_allow'])) {
        $instance['pc_allow'] = array();
    }
    ?>
    <p class="pc_widget_control_wrap">
        <label><?php _e('Which PrivateContent user categories can see this widget?', 'pc_ml') ?></label>
        <select id="<?php echo $field_id ?>" name="pc_allow[]" multiple="multiple"  class="pc_lc_select" data-placeholder="<?php esc_attr_e('select a category', 'pc_ml') ?> .." autocomplete="off">
        	<?php
			echo pc_static::user_cat_dd_opts($instance['pc_allow']);
			?>
        </select>
    </p>
    
    <script type="text/javascript">
    (function($) { 
        "use strict";  
        
        $(document).ready(function() {
            pc_wr_lc_select();
        }); 
    })(jQuery);
	</script>
    
	<?php
    $retrun = null;
    return array($t, $return, $instance);
}
add_action('in_widget_form', 'pc_widget_restriction_fields', 999, 3);




// Callback - save fields (ajax passed data - save and returns to in_widget_form)
function pc_widget_restriction_save($instance, $new_instance, $old_instance, $widget){
	
	if(isset($instance['design']) && !isset($_POST['pc_allow'])) {
		return $instance;	
	}
	$opt_name = 'pg_widget_control_'.$widget->id;
	
	// sanitize value
	$allow = (isset($_POST['pc_allow'])) ? (array)$_POST['pc_allow'] : array(); 
	
	
	// no value - delete and stop
	if(empty($allow)) {
		$instance['pc_allow'] = $allow;	
		delete_option($opt_name);	
		return $instance;
	}
	
	
	// check and save
	if(in_array('all', $allow)) {
        $allow = array('all');
    } 
	if(in_array('unlogged', $allow)) {
        $allow = array('unlogged');
    } 
	
	// save in WP options to be faster
	$data = array(
		'allow' => $allow
	);
	update_option($opt_name, $data);
	
	if(isset($_POST['pc_allow'])) {
		$instance['pc_allow'] = $allow;	
	} 
	
	return $instance;
}
add_filter('widget_update_callback', 'pc_widget_restriction_save', 5, 4);



// add lc select script into page
function pc_wr_lc_select() {
	global $current_screen;
	if(is_null($current_screen) || $current_screen->base == 'widgets') :
	?>
	<script type="text/javascript">
    (function($) { 
        "use strict"; 
        
        jQuery(document).ready(function($) {
            var dd_count = $('#widgets-right select.pc_lc_select').length;
            pc_wr_lc_select();

            $(document).on('click', '.widgets-chooser-actions .button-primary', function() {
                let pc_lc_select_intval = setInterval(function() {
                    var new_count = $('#widgets-right select.pc_lc_select').length;

                    if(new_count != dd_count) {
                        dd_count = new_count;
                        clearInterval(pc_lc_select_intval);
                        
                        pc_wr_lc_select();
                    }
                }, 100); 
            });
        });


        window.pc_wr_lc_select = function() {
            new lc_select('.pc_widget_control_wrap select', {
                wrap_width : '100%',
                addit_classes : ['lcslt-lcwp'],
            });
        };
    })(jQuery);
    </script>
    <?php
	endif;
}
add_action('admin_footer', 'pc_wr_lc_select');




// widget deletion - clean database
function pc_wc_delete_action() {
	if ( isset($_POST['widget-id']) ) {
		$widget_id = $_POST['widget-id'];

        if (isset( $_POST['delete_widget']) && $_POST['delete_widget']) {
        	delete_option('pg_widget_control_'.$widget_id);
		}
	}
}
add_action('sidebar_admin_setup', 'pc_wc_delete_action');




///////////////////////////////////////////////////////////////////////////////////////////




// APPLY - frontend implementation
function pc_do_widget_restriction($sidebars_widgets) {
	$filtered_widgets = $sidebars_widgets;
	
	// in frontend and only if WP user functions are registered
	if(!is_admin() && defined('PC_WP_USER_PASS')) {
		if(!isset($GLOBALS['pc_widget_control_opts'])) {$GLOBALS['pc_widget_control_opts'] = array();}
		$stored = $GLOBALS['pc_widget_control_opts'];
		
		foreach($sidebars_widgets as $widget_area => $widget_list) {
			if ($widget_area == 'wp_inactive_widgets' || empty($widget_list) || !is_array($widget_list)) {continue;}
	
			foreach($widget_list as $pos => $widget_id) {
				if(isset($stored[$widget_id])) {
					$opt = $stored[$widget_id];	
				} else {
					$opt = get_option('pg_widget_control_'.$widget_id); 
					$GLOBALS['pc_widget_control_opts'][$widget_id] = $opt;
				}
				
				if($opt) {
					if(isset($opt['allow']) && is_array($opt['allow']) && count($opt['allow']))	{
						
						$val = implode(',', $opt['allow']);
						if(pc_user_check($val, $blocked = '', $wp_user_pass = true) !== 1) {
							unset( $filtered_widgets[$widget_area][$pos] );	
						}	
					}
				}
			}
		}
	}
	
	return $filtered_widgets;
}
add_filter('sidebars_widgets', 'pc_do_widget_restriction', 999);
