<?php 


// redirects - custom field allowing custom URL insertion
function pc_redirect_custom_field($field_id, $field, $value, $all_vals) {
	
	// WP pages list
	$pages = pc_static::get_pages(); 
	
	// label and note
	switch($field_id) {
		case 'pg_redirect_page' : 
			$label = __("Main redirect target for restricted pages", 'pc_ml'); 
			$note = __('Unlogged users trying to reach restricted page will be moved there', 'pc_ml'); 
			break;
			
		case 'pg_blocked_users_redirect' : 
			$label = __("Redirect target for blocked users", 'pc_ml'); 
			$note = __('Logged users not matching specific restrictions will be moved there (eg. page visible only by unlogged)', 'pc_ml'); 
			break;
		
		case 'pg_logged_user_redirect' : 
			$label = __("Redirect page after user's login", 'pc_ml'); 
			$note = __("This value can be overwritten in user categories or through shortcode", 'pc_ml'); 
			break;
			
		case 'pg_logout_user_redirect' : 
			$label = __("Redirect page after user's logout", 'pc_ml'); 
			$note = __("This value can be overwritten through shortcode or using any URL + <strong>?pc_logout</strong>", 'pc_ml'); 
			break;	
		
	}
	
	
	// main redirect - if no value - select first page
	if($field_id == 'pg_redirect_page' && !$value) {
		$value = key($pages);	
	}
	
	// options
	$opts = array(
		'' 			=> ($field_id == 'pg_logged_user_redirect') ? '- '. esc_html__('Refresh the page', 'pc_ml') : '- '. esc_html__('Do not redirect users', 'pc_ml'), 
		'use_main' 	=> '- '. esc_html__('Use main redirect target', 'pc_ml'),
		'custom' 	=> '- '. esc_html__('Custom redirect', 'pc_ml')
	) + $pages;
	
	// specific cases
	if($field_id == 'pg_redirect_page' || $field_id == 'pg_blocked_users_redirect') {unset($opts['']);}
	if($field_id != 'pg_blocked_users_redirect') {unset($opts['use_main']);}
	
	// custom text visibility
	$ct_vis = ($value == 'custom' || ($field_id == 'pg_redirect_page' && !$value)) ? '' : 'pc_displaynone';
	
	// custom text value
	$ct_val = isset($all_vals[$field_id .'_custom']) ? esc_attr($all_vals[$field_id .'_custom']) : '';
	
	
	// build code
	echo '
	<tr class="'. esc_attr($field_id) .'">
		<td class="lcwp_sf_label" rowspan="2"><label>'. $label .'</label></td>
		<td class="lcwp_sf_field">
			<select name="'. esc_attr($field_id) .'" class="lcwp_sf_select pc_redirect_cf_select" autocomplete="off">';
			
				foreach($opts as $id => $name) {
					echo '<option value="'. $id .'" '.selected($value, $id).'>'. esc_html($name) .'</option>';	
				}
	echo '
			</select>   
		</td>
		<td><p class="lcwp_sf_note">'. $note .'</p></td>
	</tr>
	<tr>
		<td colspan="2" class="pc_redirect_cfw '. $field_id .'_cfw '.$ct_vis.'">
			<input type="text" name="'. $field_id .'_custom" value="'.$ct_val.'" />
		</td>
	</tr>';
	
	?>
    <script type="text/javascript">
    (function($) { 
        "use strict";
        
        $(document).on('change', '.pc_redirect_cf_select', function(e) {
			var $subj = $('.'+ $(this).attr('name') +'_cfw');
			
			if($(this).val() == 'custom') {
				$subj.show();	
			} else {
				$subj.hide();
			}
		});
    })(jQuery);
    </script>
    <?php
}





// targeted users allowed to use the plugin
function pc_users_tup_cb($field_id, $field, $value, $all_vals) {
    ?>
    <tr class="pc_<?php echo esc_attr($field_id) ?>">
        <td class="lcwp_sf_label"><label><?php _e('Targeted users able to use the plugin', 'pc_ml') ?><br/><small class="lcwp_sf_note"><?php _e('NB: administrators are always included', 'pc_ml') ?></small></label></td>
		<td class="lcwp_sf_field" colspan="2">
            
            <?php 
            $the_val = (isset($all_vals['pg_users_tup'])) ? $all_vals['pg_users_tup'] : array();
            echo pc_wpuc_static::autocomplete_users_search_n_pick('pg_users_tup', $the_val);
            ?>
            <input type="hidden" name="<?php echo esc_attr($field_id) ?>" /> <!-- js vis trick -->
		</td>
	</tr>
    <?php
}

    
    





// WP user sync - buttons
//// perform sync
function pc_do_wp_sync($field_id, $field, $value, $all_vals) {
	if($field['hide']) {return false;}
	?>
	<tr>
        <td colspan="2">
        	<input type="button" id="pc_do_wp_sync" class="button-secondary" value="<?php esc_attr_e('Sync users', 'pc_ml') ?>" />
        	<span class="pc_gwps_result"></span>
        </td>
        <td><span class="lcwp_sf_note"><strong><?php _e('Only users with unique username and e-mail will be synced', 'pc_ml') ?></strong></span></td>
    </tr>
    <?php	
}

//// sync existing users - only if $_GET['wps_existing_sync'] isset
function pc_wps_matches_sync($field_id, $field, $value, $all_vals) {
	if($field['hide'] || !isset($_GET['wps_existing_sync'])) {return false;}
	?>
	<tr>
        <td colspan="2">
        	<input type="button" id="pc_wps_matches_sync" class="button-secondary" value="<?php esc_attr_e('Search existing matches and sync', 'pc_ml') ?>" />
        	<span class="pc_gwps_result"></span>
        </td>
        <td><span class="lcwp_sf_note"><strong><?php _e('Search matches between existing PrivateContent and WP users, and sync them', 'pc_ml') ?></strong></span></td>
    </tr>
    <?php	
}

//// unsync
function pc_clean_wp_sync($field_id, $field, $value, $all_vals) {
	if($field['hide']) {return false;}
	?>
	<tr>
        <td colspan="2">
        	<input type="button" id="pc_clean_wp_sync" class="button-secondary" value="<?php esc_attr_e('Clear sync', 'pc_ml') ?>" />
        	<span class="pc_gwps_result"></span>
        </td>
        <td><span class="lcwp_sf_note"><strong><?php _e('Detach previous sync and delete related WP users', 'pc_ml') ?></strong></span></td>
    </tr>
    <?php	
}




// registration form builder
function pc_sc_reg_form_builder($field_id, $field, $value, $all_vals) {
?>
    <table id="pc_reg_form_builder_cmd_wrap" class="widefat">
        <tbody>
            <tr>
                <td>
                    <input type="text" name="pg_new_reg_form_name" id="pc_new_reg_form_name" placeholder="<?php esc_attr_e("New form's name", 'pc_ml') ?>" maxlength="150" autocomplete="off" />
                </td>
                <td>
                    <input type="button" value="<?php esc_attr_e('Add', 'pc_ml') ?>" id="pc_reg_form_add" class="button-secondary" />
                </td>
                <td>
                    <select name="pg_form_builder_dd" class="lcwp_sf_select pc_form_builder_dd" data-placeholder="<?php esc_attr_e('Select a form to edit', 'pc_ml') ?> .." autocomplete="off">
                        <?php 
                        $a = 0;
                        $reg_forms = get_terms('pc_reg_form', 'hide_empty=0&orderby=name&order=ASC');
                        foreach($reg_forms as $rf) {
                           $sel = (!$a) ? 'selected="selected"' : '';
                            
                           echo '<option value="'.$rf->term_id.'" '.$sel.'>'.$rf->term_id.' - '.$rf->name.'</option>';
                           $a++;
                        }
                        ?>
                    </select>
                </td>
                <td id="pc_reg_form_cmd">
                    <input type="button" value="<?php esc_attr_e('Save', 'pc_ml') ?>" class="pc_reg_form_save button-primary" />
                    <input type="button" value="<?php esc_attr_e('Delete', 'pc_ml') ?>" id="pc_reg_form_del" class="button-secondary" />
                </td>
            </tr> 	
        </tbody>
    </table>

    <i id="pc_reg_form_loader"></i>
    <br class="clear" /> 
    
    <div id="pc_reg_form_builder"></div>	
<?php	
}



// Fixed fields - placeholder and icons
function pc_fix_field_detail($field_id, $field, $value, $all_vals) {
	include_once(PC_DIR .'/classes/pc_form_framework.php');
	
	$f_fw = new pc_form;
	$fields = $f_fw->fields;
	$fname = $field['cb_subj'];
	
	switch($fname) {
		case 'name' 		: $label 	= __("Name's icon and placeholder text", 'pc_ml'); break;
		case 'surname' 		: $label 	= __("Surname's icon and placeholder text", 'pc_ml'); break;
		case 'username' 	: $label 	= __("Username's icon and placeholder text", 'pc_ml'); break;
		case 'psw' 			: $label 	= __("Password's icon and placeholder text", 'pc_ml'); break;
		case 'repeat_psw' 	: $label 	= __("Repeat password's icon and placeholder text", 'pc_ml'); break;
		case 'categories' 	: $label 	= __("Category's icon and placeholder text", 'pc_ml'); break;
		case 'email' 		: $label 	= __("E-mail's icon and placeholder text", 'pc_ml'); break;
		case 'tel' 			: $label 	= __("Telephone's icon and placeholder text", 'pc_ml'); break;	
	}
	
	
	$icon = get_option('pg_'. $fname .'_icon');
    $shown_icon = $icon;
    
	$plac = get_option('pg_'. $fname .'_placeh', ($fname == 'repeat_psw') ? 'Repeat password' : $fields[$fname]['placeh']);
    
    // special case for psw field with revealer
    if(isset($all_vals['pg_single_psw_f_w_reveal']) && $all_vals['pg_single_psw_f_w_reveal'] && $fname == 'psw') {
        $shown_icon = 'far fa-eye';    
        $noclick_css = 'style="pointer-events: none; filter: contrast(0.8);"';    
    } else {
        $noclick_css = '';        
    }
	?>
    <tr class="pc_<?php echo $field_id ?>">
		<td class="lcwp_sf_label">
        	<label><?php echo $label ?></label>
        </td>
		<td class="lcwp_sf_field">
			
            <div class="pc_field_icon_trigger" <?php echo $noclick_css ?>>
                <i class="<?php echo esc_attr(pc_static::fontawesome_v4_retrocomp($shown_icon)) ?>" title="<?php esc_attr_e('set icon', 'pc_ml') ?>"></i>
                <input type="hidden" name="pg_<?php echo $fname ?>_icon" value="<?php echo esc_attr(pc_static::fontawesome_v4_retrocomp($icon)) ?>" autocomplete="off" /> 
            </div>
            
            <input type="text" name="pg_<?php echo $fname ?>_placeh" value="<?php echo $plac ?>" class="pc_cust_field_placeh" />  
		</td>
	</tr>
    <?php
}



// Buttons icon
function pc_btns_icon($field_id, $field, $value, $all_vals) {
	$btn = $field['cb_subj'];
	$opt_name = 'pg_'. $btn .'_btn_icon';
	
	switch($btn) {
		case 'register' : $label 	= __("Registration form - button's icon", 'pc_ml'); break;
		case 'login' 	: $label 	= __("Login form - button's icon", 'pc_ml'); break;
		case 'logout' 	: $label 	= __("Logout button's icon", 'pc_ml'); break;	
		case 'user_del' : $label 	= __("User deletion's icon", 'pc_ml'); break;	
	}
	
	$icon = get_option($opt_name);
	?>
    <tr class="pc_<?php echo $field_id ?>">
		<td class="lcwp_sf_label">
        	<label><?php echo $label ?></label>
        </td>
		<td class="lcwp_sf_field">
			
            <div class="pc_field_icon_trigger">
                <i class="<?php echo esc_attr(pc_static::fontawesome_v4_retrocomp($icon)) ?>" title="<?php esc_attr_e('set icon', 'pc_ml') ?>"></i>
                <input type="hidden" name="<?php echo $opt_name ?>" value="<?php echo esc_attr(pc_static::fontawesome_v4_retrocomp($icon)) ?>" autocomplete="off" /> 
            </div>
		</td>
	</tr>
    <?php
}



// Lightbox Instances
function pg_lightbox_instances($field_id, $field, $value, $all_vals) {
	?>
    <ul id="pc_lb_inst">
		<?php 
		$lb_instances = get_terms('pc_lightboxes', 'hide_empty=0&order=ASC');
		 
		if(empty($lb_instances)) : ?>
            <em><?php _e('no existing instances', 'pc_ml') ?> ..</em>
			
        <?php else : 
            $a = 0;
            foreach($lb_instances as $inst) : 
			
				if(isset($GLOBALS['pc_lb_data']) && isset($GLOBALS['pc_lb_data'][$inst->term_id])) {
					$note 		= $GLOBALS['pc_lb_data'][$inst->term_id]['note'];	
					$contents 	= $GLOBALS['pc_lb_data'][$inst->term_id]['contents'];	
				}
				else {
					$note 		= ($inst->name == '|||pclbft|||') ? '' : $inst->name;	
					$contents 	= base64_decode($inst->description);	
				}
				?>	
                
                <li>
                    <aside>
                        <span class="pc_del_field dashicons dashicons-no-alt" rel="<?php echo $inst->term_id ?>" title="<?php esc_attr_e('remove restriction', 'pc_ml') ?>"></span>
                        <input type="hidden" name="pc_lb_id[]" value="<?php echo $inst->term_id ?>" />
                    </aside>    
                    <div class="pc_lb_inst_toprow">
                        <table>
                          <tr>
                            <td>
                                <input type="text" name="pc_lb_note[]" class="pc_lb_note" value="<?php echo $note ?>" placeholder="<?php esc_attr_e("Lightbox note (mandatory)", 'pc_ml') ?>" maxlength="250" autocomplete="off" />
                            </td>
                            <td>
                                <span><strong><?php _e('Trigger class', 'pc_ml') ?>:</strong> <em>pc_lb_trig_<?php echo $inst->term_id ?></em></span>
                                <strong>|</strong>
                                <span><strong><?php _e('Lightbox class', 'pc_ml') ?>:</strong> <em>pc_lb_<?php echo $inst->term_id ?></em></span>
                            </td>
                          </tr>
                        </table>
                    </div>                
                    <div class="pclb_editow_wrap">
                        <?php 
						$args = array('textarea_rows'=> 2);
						wp_editor($contents, 'pclb_'.$inst->term_id, $args); 
						?>
                    </div>
                </li>
            <?php endforeach;
         endif; ?>
    </ul>
    
    <?php // force textarea name to be array ?>
    <script type="text/javascript">
    (function($) { 
        "use strict";
        
        $(document).ready(function(e) {
            setTimeout(function() {
                $('.pclb_editow_wrap textarea.wp-editor-area').attr('name', 'pc_lb_contents[]');
            }, 500);
        });
    })(jQuery);    
    </script>
    <?php	
}




// Settings -> URL-based custom restrictions - HTML template
function pc_cr_template($url = '', $allow = false, $block = false) {
	$code = '<li>';
	
	$code .= '
	<aside>
		<span class="pc_del_field dashicons dashicons-no-alt" title="'. esc_attr__('remove restriction', 'pc_ml') .'"></span>
		<span class="pc_move_field dashicons dashicons-move" title="'. esc_attr__('sort restriction', 'pc_ml') .'"></span>
	</aside>';
	
	$code .= '
	<div class="pg_cr_url_fwrap">
		<input type="text" name="pg_cr_url[]" value="'. $url .'" placeholder="'. esc_attr__("URL to restrict. Supports also regular expressions", 'pc_ml') .'" autocomplete="off" />
	</div>';
		
	$code .= '
	<div class="pg_cr_allow_fwrap">
		<label>'. __('Which user categories can access?', 'pc_ml') .'</label>
		<select name="pg_cr_allow[][]" class="lcwp_sf_select pg_cr_allow" multiple="multiple" autocomplete="off">
			'. pc_static::user_cat_dd_opts($allow) .'
		</select>
	</div>';
	
	
	$code .= '
	<div class="pg_cr_allow_fwrap">
		<label>'. __('Among them - want to block someone?', 'pc_ml') .'</label>
		<select name="pg_cr_block[][]" class="lcwp_sf_select pg_cr_block" multiple="multiple" autocomplete="off">
			'. pc_static::user_cat_dd_opts($block, false) .'
		</select>
	</div>';	
			
			
	return $code . '</li>';
}




// preset styles preview and setter 
function pg_preset_styles($field_id, $field, $value, $all_vals) {

	echo '
	<table id="pc_preset_styles_cmd_wrap" class="widefat lcwp_settings_table">
		<tr class="pc_'. $field_id .'">
			<td class="lcwp_sf_label"><label>'. __('Setup a preset style?', 'pc_ml') .'</label></td>
			<td class="lcwp_sf_field">
				<select name="'. $field_id .'" id="pc_pred_styles" class="lcwp_sf_select mg_pred_styles_cf_select" autocomplete="off">
					<option value="">('. esc_html__('choose an option to preview', 'pc_ml') .')</option>';
				
					foreach(pc_preset_style_names() as $id => $name) {
						echo '<option value="'. esc_attr($id) .'">'. $name .'</option>';	
					}
		  echo '
				</select>   
			</td>
			<td style="width: 50px;">
				<input name="mg_set_style" id="pc_set_style" value="'. esc_attr__('Set', 'pc_ml') .'" class="button-secondary" type="button" />
			</td>
			<td><p class="lcwp_sf_note">'. __('Overrides styling options and applies preset styles', 'pc_ml') .'. '. __('Once applied, <strong>page will be reloaded</strong> showing updated options', 'pc_ml') .'</p></td>
		</tr>
		<tr class="pc_displaynone">
			<td class="lcwp_sf_label"><label>'. __('Preview', 'pc_ml') .'</label></td>
			<td colspan="3" id="pc_preset_styles_preview"></td>
		</tr>
	</table>';
	
	?>
    <script type="text/javascript">
    (function($) { 
        "use strict";    
        
        // predefined style - preview toggle
        $(document).on("change", '#pc_pred_styles', function() {
            const sel = $('#pc_pred_styles').val();

            if(!sel) {
                $('#pc_preset_styles_cmd_wrap tr').last().hide();
                $('#pc_preset_styles_preview').empty();	
            }
            else {
                $('#pc_preset_styles_cmd_wrap tr').last().show();

                const img_url = '<?php echo PC_URL ?>/img/preset_styles_demo/'+ sel +'.jpg';
                $('#pc_preset_styles_preview').html('<img src="'+ img_url +'" />');		
            }
        });


        // set predefined style 
        $(document).on('click', '#pc_set_style', function() {
            const sel_style = $('#pc_pred_styles').val();
            
            if(!sel_style) {
                return false;
            }

            if(!confirm('<?php esc_attr_e('This will overwrite your current settings reloading the page, continue?', 'pc_ml') ?>')) {
                return false;
            } 
            $(this).replaceWith('<div class="pc_spinner pc_spinner_inline"></div>');

            var data = {
                action     : 'pc_set_predefined_style',
                style      : sel_style,
                lcwp_nonce : '<?php echo wp_create_nonce('lcwp_nonce') ?>'
            };
            $.post(ajaxurl, data, function(response) {
                if($.trim(response) == 'success') {
                    lc_wp_popup_message('success', "<?php esc_attr_e('Style successfully applied!','pc_ml') ?>");	

                    setTimeout(function() {
                        window.location.reload();	
                    }, 1500);
                }
                else {
                    lc_wp_popup_message('error', response);	
                }
            })
            .fail(function(e) {
                console.error(e);
                lc_wp_popup_message('error', "Error applying preset style");	
            });	
        });
    })(jQuery); 
    </script>
    <?php
}




// URL-based restrictions
function pg_url_base_restr_field($field_id, $field, $value, $all_vals) {
	?>
    <ul id="pc_cr_list">
		<?php if(empty($all_vals['pg_cr_url'])) : ?>
            <em><?php _e('no custom restrictions added', 'pc_ml') ?> ..</em>
        <?php else : 
    
            $a = 0;
            foreach($all_vals['pg_cr_url'] as $pg_cr_url) {
                $block = (is_array($all_vals['pg_cr_block']) && isset($all_vals['pg_cr_block'][$a])) ? $all_vals['pg_cr_block'][$a] : array(); 
                
                echo pc_cr_template($pg_cr_url, $all_vals['pg_cr_allow'][$a], $block);
                $a++;	
            }
        
         endif; ?>
    </ul>
    <?php	
}



