<?php 

// user private page container - contents when unlogged
function pc_so_pvtpag_content() {
	return array(
		'original_content'		=> __("Original content", 'pc_ml'),
		'original_plus_form'	=> __("Original content + login form", 'pc_ml'),
		'form_plus_original'	=> __("Login form + original content", 'pc_ml'),	
		'only_form'				=> __("Only login form", 'pc_ml'),		
	);	
}


// WP user sync - emulable roles
function pc_wps_emulable_roles() {
	global $pc_wp_user;	
	$roles = array();
	
    if(!function_exists('get_editable_roles')) {
        require_once ABSPATH . 'wp-admin/includes/user.php';
    }
    
	foreach(get_editable_roles() as $role_id => $data) { 
		if(!in_array($role_id, $pc_wp_user->forbidden_roles)) {
			$roles[ $role_id ] = $data['name'];
		}
	}
    
    // bbPress
    if(function_exists('bbp_get_dynamic_roles')) {
        foreach(bbp_get_dynamic_roles() as $role_id => $data) {
            if(!in_array($role_id, $pc_wp_user->forbidden_roles)) {
                $roles[ $role_id ] = $data['name'];
            }       
        }
    }
				  
	return $roles;
}



// WP roles (using capabilities)
function pc_wp_roles($role = false) {
	$roles = array(
		'read' 				=> __('Subscriber', 'pc_ml'),
		'edit_posts'		=> __('Contributor', 'pc_ml'),
		'upload_files'		=> __('Author', 'pc_ml'),
		'edit_pages'		=> __('Editor', 'pc_ml'),
		'manage_options' 	=> __('Administrator', 'pc_ml')
	);
	
	return ($role) ? $roles[$role] : $roles;
}



// brief additional WP capabilities list for PC admin role
function pc_admin_role_addit_caps() {
	$caps = array(
        'upload_files' 	    => __('Manage media files', 'pc_ml'),
        'moderate_comments' => __('Moderate comments', 'pc_ml'),
        'manage_categories' => __('Manage post categories', 'pc_ml'),
        
		'man_cpt_post' 	=> __('Manage Posts', 'pc_ml'),
        'man_cpt_page' 	=> __('Manage Pages', 'pc_ml'),
	);
    
    $args = array(
        '_builtin' => false
    );
    $cpt_obj = get_post_types($args, 'objects');
    
    foreach($cpt_obj as $id => $obj) {
        if($id == 'pg_user_page') {
            continue;    
        }
        
        $caps[ 'man_cpt_'. $id ] = __('Manage', 'pc_ml') .' '. $obj->labels->name;        
    }
	
	return $caps;
}





// password strength options
function pc_psw_strength_opts() {
	return array(
		'chars_digits'	=> __('use characters and digits', 'pc_ml'),
		'use_uppercase'	=> __('use uppercase characters', 'pc_ml'),
		'use_symbols'	=> __('use symbols', 'pc_ml')
	);	
}





// Message styles
function pc_mess_styles_opts() {
	return array(
		'outlined_w_icon'	=> __('Outlined with icon', 'pc_ml'),
        'soft_colors'       => __('Soft colors', 'pc_ml'),
        'soft_colors_w_icon'=> __('Soft colors with icon', 'pc_ml'),
        'bold_colors'       => __('Bold colors', 'pc_ml'),
        'bold_colors_w_icon'=> __('Bold colors with icon', 'pc_ml'),
        'minimal'           => __('Minimal', 'pc_ml'),
	);	
}