<?php 
include_once(PC_DIR .'/settings/field_options.php'); 
include_once(PC_DIR .'/settings/preset_styles.php'); 

$ml_key = 'pc_ml';


//// custom post type and taxonomies
$cpt = pc_static::get_cpt();
$ct  = pc_static::get_ct();

# fields code
$cpt_n_ct_code = array();
if(!empty($cpt)) {
	$cpt_n_ct_code['pg_extend_cpt'] = array(
		'label' 	=> __("Enable restrictions engine on these post types", $ml_key),
		'type'		=> 'select',
		'val' 		=> $cpt,
		'multiple'	=> true,
		'fullwidth' => true,
		'note'		=> '', 
	); 	
}
if(!empty($ct)) {
	$cpt_n_ct_code['pg_extend_ct'] = array(
		'label' 	=> __("Enable restrictions engine on these taxonomies", $ml_key),
		'type'		=> 'select',
		'val' 		=> $ct,
		'multiple'	=> true,
		'fullwidth' => true,
		'note'		=> '', 
	); 	
}
//////////////////////////////////


// WP pages list
$pages = pc_static::get_pages(); 

// PC lightbox instances
$lb_instances = pc_static::get_lb_instances();

// using WP user sync?
$wps_enabled = ((!isset($_POST['pc_settings']) && get_option('pg_wp_user_sync')) || (isset($_POST['pc_settings']) && isset($_POST['pg_wp_user_sync']) && $_POST['pg_wp_user_sync'])) ? true : false;



////////////////////////////////////////////////////////////



// PC-FILTER - manipulate settings tabs
$tabs = array(
	'main_opts' 	=> __('Main Options', $ml_key),
	'registration' 	=> __('Registration', $ml_key),
	'wp_user_sync' 	=> __('WP User Sync', $ml_key),
	'messages' 		=> __('Messages', $ml_key),
	'pc_lightbox'	=> __('Lightbox', $ml_key),
	'styling' 		=> __('Styling', $ml_key),
	'pc_cust_restr' => __('Custom Restrictions', $ml_key),
);
$GLOBALS['pc_settings_tabs'] = apply_filters('pc_settings_tabs', $tabs);	




// STRUCTURE
/* tabs index => array( 
	'sect_id' => array(
		'sect_name'	=> name
		'fields'	=> array(
			...
		)
	)
   )
*/

$structure = array();

// MAIN OPTIONS
$structure['main_opts'] = array(
	'user_pvt_pag' => array(
		'sect_name'	=>  __('Users Private Page', $ml_key),
		'fields' 	=> array(
			
			'pg_target_page' => array(
				'label' => __("Page to use as users private page container", $ml_key),
				'type'	=> 'select',
				'val' 	=> array('' => '('. __('no private page', $ml_key) .')') + $pages,
				'note'	=> __("Chosen page's content will be <strong>overwritten</strong> once user logs in", $ml_key), 
			), 
			'pg_target_page_content' => array(
				'label' => __("Default container page content", $ml_key),
				'type'	=> 'select',
				'val' 	=> pc_so_pvtpag_content(),
				'note'	=> __('Define container page contents for <strong>unlogged</strong> users', $ml_key), 
				
				'js_vis'=> array(
					'linked_field' 	=> 'pg_target_page',
					'condition'		=> '',
					'operator'		=> '!=',
				)
			), 
            'pg_pvtpage_overriding_method' => array(
				'label' => __("User contents overriding mehod", $ml_key),
				'type'	=> 'select',
				'val' 	=> array(
                    'contents'      => __('Replace only contents', $ml_key),
                    'full_page'     => __('Replace full page', $ml_key),
                    'placeholder'   => __('Inject contents replacing placeholder', $ml_key)
                ),
				'note'	=> __('Define how user private page will be changed for logged users', $ml_key), 
				
				'js_vis'=> array(
					'linked_field' 	=> 'pg_target_page',
					'condition'		=> '',
					'operator'		=> '!=',
				)
			),
            'pg_pvtpage_om_placeh_legend' => array(
				'label'     => __("Required placeholder", $ml_key),
				'type'      => 'label_message',
				'content'   => '<strong>%PC-USER-PAG-CONTENT%</strong>',
				'hide'      => (empty(get_option('pg_target_page'))) ? true : false,
                
				'js_vis'=> array(
					'linked_field' 	=> 'pg_pvtpage_overriding_method',
					'condition'		=> 'placeholder',
				)
			),
			'pg_pvtpage_default_content' => array(
				'label' => __("Default private page content for new users", $ml_key),
				'type'	=> 'wp_editor',
				'rows' 	=> 4,
				
				'js_vis'=> array(
					'linked_field' 	=> 'pg_target_page',
					'condition'		=> '',
					'operator'		=> '!=',
				)
			), 
			'pg_pvtpage_enable_preset' => array(
				'label' => __('Enable preset content?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __('If checked, displays the preset content in user private pages. Then every user will see it', $ml_key),
				
				'js_vis'=> array(
					'linked_field' 	=> 'pg_target_page',
					'condition'		=> '',
					'operator'		=> '!=',
				)
			), 
			'pg_pvtpage_preset_pos' => array(
				'label' => __("Preset content position", $ml_key),
				'type'	=> 'select',
				'val' 	=> array('before' => __('Before page contents', $ml_key), 'after' => __('After page contents', $ml_key)),
				'note'	=> __("Set preset content's position in private page", $ml_key), 
				
				'js_vis'=> array(
					'linked_field' 	=> 'pg_target_page',
					'condition'		=> '',
					'operator'		=> '!=',
				)
			), 
			'pg_pvtpage_preset_txt' => array(
				'label' => __("Preset content", $ml_key),
				'type'	=> 'wp_editor',
				'rows' 	=> 4,
				
				'js_vis'=> array(
					'linked_field' 	=> 'pg_target_page',
					'condition'		=> '',
					'operator'		=> '!=',
				)
			), 
			'pg_pvtpage_wps_comments' => array(
				'label' => __('Allow comments for WP synced users?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __('Gives the ability to communicate with user through his private page contents', $ml_key) .'<br/>'. __('<strong>Note</strong>: only users with WP sync will be able to do this', $ml_key),
				
				'js_vis'=> array(
					'linked_field' 	=> 'pg_target_page',
					'condition'		=> '',
					'operator'		=> '!=',
				)
			), 	
		),
	),
		
		
	'redirects' => array(
		'sect_name'	=>  __('Redirects', $ml_key),
		'fields' 	=> array(
			
			'pg_redirect_page' => array(
				'type'		=> 'custom',
				'callback'	=> 'pc_redirect_custom_field',
				'validation'=> array(
					array('index' => 'pg_redirect_page', 'label' => __("Main redirect target for restricted pages", $ml_key), 'required'=>true),
					array('index' => 'pg_redirect_page_custom', 'label' => __("Main redirect target for restricted pages", $ml_key) .' - '. __('Custom URL', $ml_key), 'type' => 'url'),
				)
			), 
			'pg_blocked_users_redirect' => array(
				'type'		=> 'custom',
				'callback'	=> 'pc_redirect_custom_field',
				'validation'=> array(
					array('index' => 'pg_blocked_users_redirect', 'label' => __("Redirect target for blocked users", $ml_key), 'required'=>true),
					array('index' => 'pg_blocked_users_redirect_custom', 'label' => __("Redirect target for blocked users", $ml_key) .' - '. __('Custom URL', $ml_key), 'type' => 'url'),
				)
			),
			'pg_registered_user_redirect' => array(
				'label' => __("Redirect page after registration", $ml_key),
				'type'	=> 'select',
				'val' 	=> array('' => '- '. esc_html__('Do not redirect users', $ml_key)) + $pages,
				'note'	=> __("This value can be overwritten in user categories or through shortcode", $ml_key), 
			), 
			'pg_logged_user_redirect' => array(
				'type'		=> 'custom',
				'callback'	=> 'pc_redirect_custom_field',
				'validation'=> array(
					array('index' => 'pg_logged_user_redirect', 'label' => "Redirect page after user login"),
					array('index' => 'pg_logged_user_redirect_custom', 'label' => __("Redirect page after user login", $ml_key) .' - '. __('Custom URL', $ml_key), 'type' => 'url'),
				)
			), 
			'pg_redirect_back_after_login' => array(
				'label' => __('Redirect users to the last restricted page?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __('If checked, move logged users back to last restricted page they tried to see (where available)', $ml_key),
			), 
			'pg_logout_user_redirect' => array(
				'type'		=> 'custom',
				'callback'	=> 'pc_redirect_custom_field',
				'validation'=> array(
					array('index' => 'pg_logout_user_redirect', 'label' => "Redirect page after user login"),
					array('index' => 'pg_logout_user_redirect_custom', 'label' => __("Redirect page after user logout", $ml_key) .' - '. __('Custom URL', $ml_key), 'type' => 'url'),
				)
			), 
		),
	),
	
	
	'contents_hiding' => array(
		'sect_name'	=>  __('Contents hiding system', $ml_key),
		'fields' 	=> array(
			
			'pc_chs_behavior' => array(
				'label' => __("Restricted posts behavior", $ml_key),
				'type'	=> 'select',
				'val' 	=> array(
					'warning_box' 	=> __('Warning Box', $ml_key),
					'no_contents' 	=> __('No contents', $ml_key),
					'excerpt' 		=> __('Excerpt', $ml_key),
					'excerpt_n_wb'	=> __('Excerpt + warning box', $ml_key),
					'cust_content'	=> __('Custom contents', $ml_key),
					'excerpt_n_cc'	=> __('Excerpt + custom contents', $ml_key),
				),
				'note'	=> __('What replaces restricted element contents in their own pages', $ml_key), 
			),
			'pc_chs_lists_behavior' => array(
				'label' => __("Restricted posts behavior (in lists)", $ml_key),
				'type'	=> 'select',
				'val' 	=> array(
					'no_contents' 	=> __('No contents', $ml_key),
					'excerpt' 		=> __('Excerpt', $ml_key),
					'cust_content'	=> __('Custom contents', $ml_key),
                    'do_not_act'	=> __('Do not act', $ml_key),
				),
				'note'	=> __('What replaces restricted element contents in searches, archives and categories', $ml_key), 
			),
			'pc_chs_cust_content' => array(
				'label' => __("Restricted elements - custom contents", $ml_key) .'<br/><small>('. __('related option must be chosen to use this', $ml_key) .')</small>',
				'type'	=> 'wp_editor',
				'rows' 	=> 2,
			), 
			'pg_warn_box_login' => array(
				'label' => __("Warning box - Login button", $ml_key),
				'type'	=> 'select',
				'val' 	=> array('' => __('No login button', $ml_key)) + $lb_instances,
				'note'	=> __("Hide login button or select a lightbox instance to use", $ml_key), 
			), 
			'pg_warn_box_registr' => array(
				'label' => __("Warning box - Registration button", $ml_key),
				'type'	=> 'select',
				'val' 	=> array('' => __('No registration button', $ml_key)) + $lb_instances,
                'def'   => '',
				'note'	=> __("Hide registration button or select a lightbox instance to use", $ml_key), 
			),
		),
	),
	
	
	'lb_on_open' => array(
		'sect_name'	=>  __("Lightbox on page's opening", $ml_key, $ml_key),
		'fields' 	=> array(
			
			'pg_def_lb_on_open' => array(
				'label' => __("Default lightbox shown to unlogged users", $ml_key),
				'type'	=> 'select',
				'val' 	=> array('none' => __('No lightbox', $ml_key)) + $lb_instances,
				'note'	=> __("Default value to be inherited in restricrion's wizard", $ml_key), 
			), 
		),
	),
	
	
	'site_lock' => array(
		'sect_name'	=>  __('Complete Site Lock', $ml_key),
		'fields' 	=> array(
			
			'pg_complete_lock' => array(
				'label' => __('Enable lock?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __('<font class="lcwp_settings_rednote"><strong>Note</strong>: "Restriction redirect target" will be visible to allow the users login. Be sure you are using a Wordpress page</font>', $ml_key),
			), 
			'pg_complete_lock_exclude_menu' => array(
				'label' => __('Avoid removing menus?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __('Check to leave navigation menu visible', $ml_key),
				
				'js_vis'=> array(
					'linked_field' 	=> 'pg_complete_lock',
					'condition'		=> true 
				)
			), 
			'pg_complete_lock_excluded_pages' => array(
				'label' 	=> __("Excluded Pages", $ml_key),
				'type'		=> 'select',
				'val' 		=> pc_static::get_pages(),
				'multiple'	=> true,
				'fullwidth' => true,
				'note'		=> __('Set pages excluded in the lock', $ml_key),
				
				'js_vis'	=> array(
					'linked_field' 	=> 'pg_complete_lock',
					'condition'		=> true 
				)
			),	
				
		),
	),
		
	
	'cpt_n_ct' => array(
		'sect_name'	=>  __('Custom Post types and Taxonomies', $ml_key),
		'fields' 	=> $cpt_n_ct_code
	),	
	
	
	'analytics' => array(
		'sect_name'	=>  __('Google Analytics', $ml_key),
		'fields' 	=> array(
            
            'pg_analytics_v' => array(
				'label' => __("Analytics version", $ml_key),
				'type'	=> 'select',
				'val' 	=> array(
					'ua' 	=> 'Universal Analytics',
					'ga4' 	=> 'Analytics 4',
				),
				'note'	=> '', 
			),
			'pg_analytics_id' => array(
				'label' => __('Tracking ID', $ml_key),
				'type'	=> 'text',
				'placeh'=> 'UA-XXXX-XX',
				'maxlen'	=> 20,
				'note'	=> '<a href="https://support.google.com/analytics/answer/1008080#trackingID" target="_blank">'. __('how to find it?', $ml_key) .'</a>',
                
                'js_vis'	=> array(
					'linked_field' 	=> 'pg_analytics_v',
					'condition'		=> 'ua' 
				)
			),
            'pg_ua_setup_note' => array(
                'type'      => 'message',
                'content'   => '<font class="lcwp_settings_rednote"><strong>NB: '. __("Universal Analytics will be discontinued by Google on July 1st 2023, please move to Analytics 4 (GA4)", $ml_key) .'</strong></font><br/><br/>'. __("Once saved, PrivateContent will track specific logged users navigation and their events. In order to do so, remember to <a href='https://support.google.com/analytics/answer/3123666?utm_id=ad#setup' target='_blank'>enable the related Analytics option</a>.", $ml_key) .'<br>'. 
							__('<strong>ONLY</strong> enable the function creating a new Analytics view, PrivateContent will do the rest.', $ml_key),
                
                'js_vis'	=> array(
					'linked_field' 	=> 'pg_analytics_v',
					'condition'		=> 'ua' 
				)
            ),
            
            'pg_ga4_id' => array(
				'label' => __('Measurement ID', $ml_key),
				'type'	=> 'text',
				'placeh'=> 'G-XXXXXXXXXX',
				'maxlen'	=> 12,
				'note'	=> '<a href="https://support.google.com/analytics/answer/9539598#find-G-ID" target="_blank">'. __('how to find it?', $ml_key) .'</a>',
                
                'js_vis'	=> array(
					'linked_field' 	=> 'pg_analytics_v',
					'condition'		=> 'ga4' 
				)
			),
            'pg_ga4_api_secret' => array(
				'label' => __('API Secret Key', $ml_key),
				'type'	=> 'text',
				'placeh'=> '',
				'maxlen'	=> 22,
				'note'	=> '<a href="TODO" target="_blank">'. __('how to find it?', $ml_key) .'</a>',
                
                'js_vis'	=> array(
					'linked_field' 	=> 'pg_analytics_v',
					'condition'		=> 'ga4' 
				)
			),
            'pg_gtm_id' => array(
				'label' => __('Google Tag Manager ID', $ml_key),
				'type'	=> 'text',
				'placeh'=> 'GTM-XXXXXXX',
				'maxlen'	=> 11,
				'note'	=> '<a href="https://support.google.com/tagmanager/answer/6103696" target="_blank">'. __('how to find it?', $ml_key) .'</a>',
                
                'js_vis'	=> array(
					'linked_field' 	=> 'pg_analytics_v',
					'condition'		=> 'ga4' 
				)
			),
            'pg_ga4_inject_js_code' => array(
				'label' => __('Install Google codes in the website?', $ml_key) ,
				'type'	=> 'checkbox',
				'note'	=> __('Check to inject Google codes along with your account IDs (<a href="https://developers.google.com/tag-platform/tag-manager/web" target="_blank">which codes?</a>).<br/><strong>Be sure they are not already added by other SEO tool</strong>', $ml_key),
                
                'js_vis'	=> array(
					'linked_field' 	=> 'pg_analytics_v',
					'condition'		=> 'ga4' 
				)
			), 
            'pg_ga4_setup_note' => array(
                'type'      => 'message',
                'content'   => __("Once saved, PrivateContent will setup the 'pc_user_id' tag to start the User ID tracking and create specific events.<br/><strong>Remember</strong> to include Google Analytics and Google Tag Manager codes into the website. Check the <a href='TODO' target='_blank'>documentation chapter</a> to know more.", $ml_key),
                
                'js_vis'	=> array(
					'linked_field' 	=> 'pg_analytics_v',
					'condition'		=> 'ga4' 
				)
            ),
		),
	), 
    
    
    'wp_users_to_manag_pc' => array(
		'sect_name'	=>  __('WordPress users interactions', $ml_key),
		'fields' 	=> array(

			'pg_min_role_tmu' => array(
				'label' => __("Minimum role to manage users", $ml_key),
				'type'	=> 'select',
				'val' 	=> pc_wp_roles(),
				'def'	=> "edit_pages",
				'note'	=> __("Minimum WordPress role to edit and manage users", $ml_key) .'.<br/><strong>'. __('This option can be extended for each user category in the categories manager area', $ml_key) .'.</strong>',  
			),  
            'pg_any_pc_admin_cmu' => array(
				'label' => __('Extend the privilege also to users having "PrivateContent admin" role?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __('Normally they can manage only targered user categories. Checking this option any PrivateContent user will be manageable by them', $ml_key),
			), 
            'pg_tu_can_edit_user_cats' => array(
				'label' => __('Specifically selected WP users can edit PrivateContent user categories?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __('Checking this option, WP users allowed to edit targeted PrivateContent user categories will be also able to edit their categories assignment', $ml_key),
			), 
            'spcr101' => array(
				'type' => 'spacer',
			),
            'pg_min_role' => array(
				'label' => __("Minimum role bypassing front restrictions", $ml_key),
				'type'	=> 'select',
				'val' 	=> array_merge(
                    array(
                        'inherit_tmu' => '- '. esc_html__('inherit "To manage users" value'),
                        'only_targeted' => '- '. esc_html__('only targeted users'),
                    ), 
                    pc_wp_roles()
                ),
				'def'	=> "edit_pages",
				'note'	=> __("WordPress users owning the role capability, will be able to bypass frontend restrictions.", $ml_key) .'.<br/>'. __('NB: WP users having "PrivateContent admin" role bypass restrictions by default. "Obviously this will be ignored if "testing mode" is enabled', $ml_key), 
			),
            'pg_users_tup_field' => array(
				'type'		=> 'custom',
				'callback'	=> 'pc_users_tup_cb',
                'validation'=> array(
					array('index' => 'pg_users_tup', 'label' => "Targeted users able to bypass front restrictions"),
				),
                
                'js_vis' => array(
					'linked_field' 	=> 'pg_min_role',
					'condition'		=> 'only_targeted' 
				)
			), 
            'pg_pc_admin_role_add_caps' => array(
				'label' => __("PrivateContent Admin (WP role) - additional capabilities", $ml_key),
				'type'	=> 'select',
                'multiple' => true,
                'fullwidth'=> true,
				'val' 	=> pc_admin_role_addit_caps(),
				'def'	=> array(),
				'note'	=> __("Defines additional capabilities for the special 'PrivateContent Admin' WordPress role. By default it is only able to manage targeted PrivateContent categories and bypasses frontend restrictions", $ml_key), 
			),
            
        ),
    ),  
	
	
	'user_sessions_control' => array(
		'sect_name'	=>  __("User Sessions Control", $ml_key, $ml_key),
		'fields' 	=> array(
			
			'pg_use_session_token' => array(
				'label' => __('Control sessions?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, user sessions will be tracked to avoid multiple logins from different devices", $ml_key) .'<br/><em><strong>FYI:</strong> '. __('it will involve a new cookie named "pc_session_token"', $ml_key) .'</em>',
			), 
			'pg_allowed_simult_sess' => array(
				'label' 	=> __("How many allowed simultaneous sessions?", $ml_key),
				'type'		=> 'slider',
				'min_val'	=> 1,
				'max_val'	=> 5,	
				'step'		=> 1,
				'value'		=> '',
				'def'		=> 1,
                'respect_limits' => false,
				'note'	=> __('Logged users owning old login tokens will be logged-out', $ml_key),
				
				'js_vis'=> array(
					'linked_field' 	=> 'pg_use_session_token',
					'condition'		=> true 
				)
			),
		),
	),
	
	
	
	'advanced' => array(
		'sect_name'	=>  __('Advanced', $ml_key),
		'fields' 	=> array(
			
			'pg_test_mode' => array(
				'label' => __('Enable "testing" mode?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, WordPress users <strong>won't</strong> be able to see restricted contents", $ml_key),
			), 
			'pg_use_remember_me' => array(
				'label' => __('Use "remember me" check in login form?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, allows users to be logged into the website for 14-days through cookies", $ml_key),
			), 
			'pg_allow_email_login' => array(
				'label' => __('Allow login also through e-mail?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, allows user login inserting username or e-mail.", $ml_key) .'<br/><strong class="lcwp_settings_rednote">'. __('Be sure database is ok with this: every user should have a unique e-mail', $ml_key) .'</strong>',
			), 
			'pg_no_cookie_login' => array(
				'label' => __('Short login cookie', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, user session automatically ends 5 minutes after user closes its browser or has no interactions.<br/><strong>NB:</strong> using WP user sync, this behavior could be overrided", $ml_key),
			), 
            'pg_abfa_attempts' => array(
				'label' 	=> __("Anti bruteforce system - how many errors allow before block visitor?", $ml_key),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 20,	
				'step'		=> 1,
				'value'		=> '',
				'def'		=> 8,
                'respect_limits' => false,
				'note'		=> __("Control performed on login form, use zero to skip this check", $ml_key),
			),
            'pg_htaccess_cred' => array(
				'label' => __("HTACCESS credentials needed?", $ml_key),
                'already_set_label' => __('Credentials already set!', $ml_key),
				'type'	=> 'psw',
				'note'	=> __('In case of HTACCESS hidden website, its credentials are mandatory to remotely fetch page contents.<br/>Insert them in <strong>USERNAME:PASSWORD</strong> format.', $ml_key), 
				
				'js_vis'=> array(
					'linked_field' 	=> 'pg_pvtpage_overriding_method',
					'condition'		=> 'full_page',
				)
			),
			'pg_use_first_last_name' => array(
				'label' => __('Use first/last name in forms?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, replaces name/surname with first/last name", $ml_key),
			), 
			'pg_inline_css' => array(
				'label' => __('Use dynamic CSS inline?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, uses dynamic CSS inline (useful for multisite installations)", $ml_key),
			),
		),
	),  
);



// REGISTRATION OPTIONS
$structure['registration'] = array(
	'main_reg_opts' => array(
		'sect_name'	=>  __('General Registration Settings', $ml_key),
		'fields' 	=> array(
			
			'pg_allow_duplicated_mails' => array(
				'label' => __('Allow duplicated e-mails?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, allows users with same e-mail into the database", $ml_key) .'.<br/><strong>'. __('Strongly not recommended', $ml_key) .'</strong>',
			),
			'pg_registration_cat' => array(
				'label' => __("Default category for registered users", $ml_key),
				'type'	=> 'select',
				'val' 	=> pc_static::user_cats(),
                'def'		=> (function_exists('array_key_first') && count(pc_static::user_cats())) ? array_key_first(pc_static::user_cats()) : '',
				'multiple' 	=> true,
				'required'	=> true,
				'note'	=> __("Default user registration categories (ignored if you use category field in forms)", $ml_key), 
			), 
            'pg_registered_pvtpage' => array(
				'label' => __('Enable private page for new registered users?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> '',
			),
			'pg_registered_pending' => array(
				'label' => __('Set users status as pending after registration?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> '',
			),
            'pg_onlymail_registr' => array(
				'label' => __('Use e-mail value as username in registration forms?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, username field will be hidden in registration form and e-mail value will be copied and used instead", $ml_key) .'.<br/><strong>'. __('Be sure e-mail field is in your forms', $ml_key) .'</strong>',
                
                'js_vis'=> array(
					'linked_field' 	=> 'pg_allow_duplicated_mails',
					'condition'		=> false,
				)
			),
		),
	),
    
    'reg_form_opts' => array(
		'sect_name'	=>  __('Registration Forms Settings', $ml_key),
		'fields' 	=> array(
			
			'pg_reg_cat_label' => array(
				'label' => __('"Category" field - custom label', $ml_key),
				'type'	=> 'text',
				'note'	=> __("Set a custom label for category field in registration forms", $ml_key),
			),
            'pg_reg_cat_placeh' => array(
				'label' => __('"Category" field - placeholder option', $ml_key),
				'type'	=> 'text',
				'note'	=> 
                    __("Set a placeholder option for category field in registration forms, avoiding a default chosen category.", $ml_key). '<br/><strong>'. __("Only for single-choice field. Leave empty to discard", $ml_key) .'</strong>',
                
                'js_vis'=> array(
					'linked_field' 	=> 'pg_reg_multiple_cats',
					'condition'		=> false,
				)
			),
			'pg_reg_multiple_cats' => array(
				'label' => __('Allow multiple user categories selection during registration?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("Check to allow users choose multiple categories in registration forms", $ml_key),
			),
            'pg_autologin_registered' => array(
				'label' => __('Auto-login registered users?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __('Check to automatically login active users after their registration', $ml_key) .'<br/><strong>'. __("NB: obviously you should use the registration form redirect (or a page refresh) to effectively show changes", $ml_key) .'</strong>',
                
                'js_vis'=> array(
					'linked_field' 	=> 'pg_registered_pending',
					'condition'		=> false,
				)
			),
            'pg_forms_pags_progress' => array(
				'label' => __('Show pagination progress on top of forms?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked a progress bar (with clickable page numbers) will be prepended to form fields", $ml_key),
			),
            'pg_hide_reg_btn_on_success' => array(
				'label' => __('Hide submit button on successful registration?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> '',
                'def'   => 1,
			),
			'pg_no_html5_validation' => array(
				'label' => __('Disable HTML5 fields validation?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("Disables client-side fields validation", $ml_key),
			),
			'pg_antispam_sys' => array(
				'label' => __("Anti-spam system", $ml_key),
				'type'	=> 'select',
				'val' 	=> array(
					'honeypot'     => __('Honey pot hidden system', $ml_key), 
					'recaptcha'    => __("Google's invisible reCAPTCHA (v3)", $ml_key),
                    'recaptcha_v2' => __("Google's invisible reCAPTCHA (v2)", $ml_key),
				),
				'note'	=> __("Choose the anti-spam solution you prefer", $ml_key), 
			),
			'pg_recaptcha_public' => array(
				'label' 	=> __('reCAPTCHA - site key', $ml_key),
				'type'		=> 'text',
				'maxlen'	=> 255,
				'fullwidth'	=> true,
				
				'js_vis'=> array(
					'linked_field' 	=> 'pg_antispam_sys',
					'condition'		=> 'honeypot',
                    'operator'		=> '!=',
				)
			),
			'pg_recaptcha_secret' => array(
				'label' 	=> __('reCAPTCHA - secret key', $ml_key),
				'type'		=> 'text',
				'maxlen'	=> 255,
				'fullwidth'	=> true,
				'note'		=> __('To use reCAPTCHA you need to <a href="https://www.google.com/recaptcha/admin" target="_blank">create your personal keys</a>. Choose "invisible reCAPTCHA", insert the current domain and you will get your keys.', $ml_key),
				
				'js_vis'=> array(
					'linked_field' 	=> 'pg_antispam_sys',
					'condition'		=> 'honeypot',
                    'operator'		=> '!=',
				)
			),
			
		),
	),
	
	'disclaimer' => array(
		'sect_name'	=>  __('Disclaimer', $ml_key),
		'fields' 	=> array(
			
			'pg_use_disclaimer' => array(
				'label' => __('Enable disclaimer?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, append the disclaimer to the registration form", $ml_key),
			),
			'pg_disclaimer_txt' => array(
				'label' => __("Disclaimer text", $ml_key),
				'type'	=> 'wp_editor',
				'rows' 	=> 2,
			), 
		),
	),
	
	
	'psw_security' => array(
		'sect_name'	=>  __('Password Settings', $ml_key),
		'fields' 	=> array(
			
			'pg_psw_min_length' => array(
				'label' 	=> __('Minimum password length', $ml_key),
				'type'		=> 'slider',
				'min_val'	=> 4,
				'max_val'	=> 10,	
				'step'		=> 1,
				'def'		=> 4,
                'respect_limits' => false,
				'note'		=> __("Set minimum characters length for user's password", $ml_key),
			),
			'pg_psw_strength' => array(	
				'label' => __("Password strength options", $ml_key),
				'type'	=> 'select',
				'val' 	=> pc_psw_strength_opts(),
				'multiple' 	=> true,
				'note'	=> __("Improve passwords strength using these options", $ml_key), 
			), 
            'spcr1' => array(
				'type' => 'spacer',
			),
            'pg_show_psw_helper' => array(
				'label' => __('Show helper in frontend forms?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, password requirements will be shown in frontend forms", $ml_key),
			),
            'pg_single_psw_f_w_reveal' => array(
				'label' => __('Use only one password field with input revealer in front forms?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked", $ml_key) .':<br/>'.
                            '- '. __('"repeat password" field will be removed', $ml_key) .'<br/>'.
                            '- '. __('password field will always have the icon enabled', $ml_key) .'<br/>'.
                            '- '. __('a clickable eye will be always used as icon', $ml_key),
			),
		),
	),
	
	
	'rf_builder' => array(
		'sect_name'	=>  __('Registration forms builder', $ml_key),
		'fields' 	=> array(
			
			'pc_sc_reg_form_builder' => array(
				'type'		=> 'custom',
				'callback'	=> 'pc_sc_reg_form_builder',
			), 
		),
	),
);




// WP USER SYNC OPTIONS
$structure['wp_user_sync'] = array(
	'wps_main' => array(
		'sect_name'	=>  __('Wordpress Users System Integration', $ml_key),
		'fields' 	=> array(
			
			'pg_wp_user_sync' => array(
				'label' => __('Enable integration?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __('If checked, privateContent users will be logged also with basic WP account', $ml_key) .'<br/>'. __("<strong><font class='lcwp_settings_rednote'>What does this imply?</font></strong> For more details, please check the related documentation chapter", $ml_key)
			), 
			
			'pg_require_wps_registration' => array(
				'label' => __('Require sync during frontend registration?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __('Allows new users only if WP user sync is successful (automatically adds e-mail field into registration forms)', $ml_key),
				
				'js_vis'=> array(
					'linked_field' 	=> 'pg_wp_user_sync',
					'condition'		=> true 
				)
			), 
			'pg_custom_wps_roles' => array(
				'label' 	=> __("Additional user roles", $ml_key),
				'type'		=> 'select',
				'val' 		=> pc_wps_emulable_roles(),
				'multiple'	=> true,
				'note'		=> __('Set which roles will be <strong>emulated</strong> to synced users', $ml_key),
				
				'js_vis'=> array(
					'linked_field' 	=> 'pg_wp_user_sync',
					'condition'		=> true 
				)
			),
		),
	),
		
	'wp_to_pc_registration' => array(
		'sect_name'	=>  __('WordPress to PrivateContent - Registration Sync', $ml_key),
		'fields' 	=> array(
			
			'wp_to_pc_sync_on_register' => array(
				'label' => __('Sync newly registered WP users?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __('If checked, WordPress users registered on <strong>frontend</strong> will be automatically synced in PrivateContent', $ml_key)
			), 
			'wp_to_pc_sync_on_register_cats' => array(
				'label' 	=> __("Default categories for synced users", $ml_key),
				'type'		=> 'select',
				'val' 		=> pc_static::user_cats(),
				'multiple' 	=> true,
				'note'		=> __("Choose at least a category that will be assigned to imported users", $ml_key), 
				
				'js_vis'	=> array(
					'linked_field' 	=> 'wp_to_pc_sync_on_register',
					'condition'		=> true 
				)
			), 
			'wp_to_pc_sync_on_register_roles' => array(
				'label' 	=> __("Limit sync to these roles", $ml_key),
				'type'		=> 'select',
				'val' 		=> pc_wps_emulable_roles(),
				'multiple'	=> true,
				'note'		=> __('Sync on WP registration will be limited only to these user roles. Leave empty to sync each user', $ml_key),
				
				'js_vis'	=> array(
					'linked_field' 	=> 'wp_to_pc_sync_on_register',
					'condition'		=> true 
				)
			),
		),
	),
			
	'wps_comments_lock' => array(
		'sect_name'	=>  __('Comments restriction', $ml_key),
		'fields' 	=> array(	
			
			'pg_lock_comments' => array(
				'label' => __('Hide comments block in every page?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __('If checked, totally hides comment block on site for unlogged users (overriding other restrictions)', $ml_key),
			), 
			'pg_hc_warning' => array(
				'label' => __('Display warning for hidden comment blocks?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __('If checked, shows a warning box replacing comment form (can be overrided for single posts)', $ml_key),
			), 
		),
	),	
			
	'wps_manual_bulk_sync' => array(	
		'sect_name'	=>  __('Manual Bulk Sync', $ml_key),
		'fields' 	=> array(	
		
			'pc_do_wp_sync' => array(
				'type'		=> 'custom',
				'callback'	=> 'pc_do_wp_sync',
				'hide'	=> ($wps_enabled) ? false : true,
			), 
			'pc_wps_matches_sync' => array(
				'type'		=> 'custom',
				'callback'	=> 'pc_wps_matches_sync',
				'hide'	=> ($wps_enabled) ? false : true,
			),
			'pc_clean_wp_sync' => array(
				'type'		=> 'custom',
				'callback'	=> 'pc_clean_wp_sync',
				'hide'	=> ($wps_enabled) ? false : true,
			),  
			
			'wps_mbs_message' => array(
				'type'		=> 'message',
				'content'	=> __('Enable the sync and save settings to view options', $ml_key),
				'hide'	=> ($wps_enabled) ? true : false,
			),  
			
		),
	),
);




// CUSTOM MESSAGES
$structure['messages'] = array(
	'restr_cont_mess' => array(
		'sect_name'	=>  __('Restricted Content Messages', $ml_key),
		'fields' 	=> array(
			
			'pg_default_nl_mex' => array(
				'label' 	=> __('Default message for unlogged users', $ml_key),
				'type'		=> 'text',
				'maxlen'	=> 255,
				'fullwidth'	=> true,
				'note'		=> __('Leave empty to use default message', $ml_key) .': "'. __('You must be logged in to view this content', $ml_key).'"',
			),
			'pg_default_uca_mex' => array(
				'label' 	=> __('Custom message for users having wrong permissions', $ml_key),
				'type'		=> 'text',
				'maxlen'	=> 200,
				'fullwidth'	=> true,
				'note'		=> __('Leave empty to use default message', $ml_key) .': "'. __("Sorry, you don't have the right permissions to view this content", $ml_key).'"',
			),
		),
	),
	
	
	'restr_comm_mess' => array(
		'sect_name'	=>  __('Restricted Comment Messages', $ml_key),
		'fields' 	=> array(
			
			'pg_default_hc_mex' => array(
				'label' 	=> __('Custom message for unlogged users', $ml_key),
				'type'		=> 'text',
				'maxlen'	=> 255,
				'fullwidth'	=> true,
				'note'		=> __('Leave empty to use default message', $ml_key) .': "'. __('You must be logged in to post comments', $ml_key).'"',
			),
			'pg_default_hcwp_mex' => array(
				'label' 	=> __('Custom message for users having wrong permissions', $ml_key),
				'type'		=> 'text',
				'maxlen'	=> 200,
				'fullwidth'	=> true,
				'note'		=> __('Leave empty to use default message', $ml_key) .': "'. __("Sorry, you don't have the right permissions to post comments", $ml_key).'"',
			),
		),
	),
	
	
	'pvtpag_mess' => array(
		'sect_name'	=>  __('Private Page Messages', $ml_key),
		'fields' 	=> array(
			
			'pg_default_nhpa_mex' => array(
				'label' 	=> __("Default message if a user doesn't have its own private page", $ml_key),
				'type'		=> 'text',
				'maxlen'	=> 255,
				'fullwidth'	=> true,
				'note'		=> __('Leave empty to use default message', $ml_key) .': "'. __("You don't have a reserved area", $ml_key).'"',
			),
		),
	),
	
	
	'login_mess' => array(
		'sect_name'	=>  __('Login Form Messages', $ml_key),
		'fields' 	=> array(
			
			'pg_login_ok_mex' => array(
				'label' 	=> __('Default message for successful login', $ml_key),
				'type'		=> 'text',
				'maxlen'	=> 170,
				'fullwidth'	=> true,
				'note'		=> __('Leave empty to use default message', $ml_key) .': "'. __("Logged successfully, welcome!", $ml_key).'"',
			),
			'pg_default_pu_mex' => array(
				'label' 	=> __('Default message for pending users', $ml_key),
				'type'		=> 'text',
				'maxlen'	=> 170,
				'fullwidth'	=> true,
				'note'		=> __('Leave empty to use default message', $ml_key) .': "'. __("Sorry, your account has not been activated yet", $ml_key).'"',
			),
			'pg_default_du_mex' => array(
				'label' 	=> __('Default message for disabled users', $ml_key),
				'type'		=> 'text',
				'maxlen'	=> 170,
				'fullwidth'	=> true,
				'note'		=> __('Leave empty to use default message', $ml_key) .': "'. __("Sorry, your account has been disabled", $ml_key).'"',
			),
		),
	),
	
	
	'reg_form_mess' => array(
		'sect_name'	=>  __('Registration Form Message', $ml_key),
		'fields' 	=> array(
			
			'pg_default_sr_mex' => array(
				'label' 	=> __("Default message for successfully registered users", $ml_key),
				'type'		=> 'text',
				'maxlen'	=> 200,
				'fullwidth'	=> true,
				'note'		=> __('Leave empty to use default message', $ml_key) .': "'. __("Registration was successful. Welcome!", $ml_key).'"',
			),
		),
	),
);



// LIGHTBOX
$structure['pc_lightbox'] = array(
	'lightbox_wizard' => array(
		'sect_name'	=> __('Lightbox instances', $ml_key) .'<a id="pc_add_lb_trig">'. __('Add instance', $ml_key) .'</a>',
		'fields' 	=> array(
			
			// custom validation in view.php
			'pg_lightbox_instances' => array(
				'type'		=> 'custom',
				'callback'	=> 'pg_lightbox_instances',
			), 
		),
	),
);




// STYLING OPTIONS

// fixed field details - dynamically build array
$fix_fields = array('name', 'surname', 'username', 'psw', 'repeat_psw', 'categories', 'email', 'tel');
$ff_details_structure = array(
	'spcr1' => array('hide'	=> true, 'type' => 'spacer') // trick to print the table
);
foreach($fix_fields as $ff) {
	$ff_details_structure['pg_'. $ff .'_details'] = array(
		'type'		=> 'custom',
		'callback'	=> 'pc_fix_field_detail',
		'cb_subj'	=> $ff,
		'validation'=> array(
			array('index' => 'pg_'. $ff .'_placeh', 'label' => $ff ." placeholder", 'maxlen'=> 150),
			array('index' => 'pg_'. $ff .'_icon', 'label' => $ff ." icon"),
		)
	);			
}

// buttons icon - dynamically build array
$buttons = array('register', 'login', 'logout', 'user_del');
$btn_icons_structure = array(
	'spcr1' => array('hide'	=> true, 'type' => 'spacer') // trick to print the table
);
foreach($buttons as $btn) {
	$btn_icons_structure['pg_'. $btn .'_btn_icon'] = array(
		'type'		=> 'custom',
		'callback'	=> 'pc_btns_icon',
		'cb_subj'	=> $btn,
		'validation'=> array(
			array('index' => 'pg_'. $btn .'_btn_icon', 'label' => $btn ." icon"),
		)
	);			
}

$structure['styling'] = array(
	
	'fix_field_details' => array(
		'sect_name'	=>  __('Fixed field details', $ml_key),
		'fields' 	=> $ff_details_structure 
	),
	
	'button_icons' => array(
		'sect_name'	=>  __('Buttons icon', $ml_key),
		'fields' 	=> $btn_icons_structure
	), 
	
    
	'main_styling_opts' => array(
		'sect_name'	=>  __('General Styling Settings', $ml_key),
		'fields' 	=> array(
			
			'pg_bottomborder' => array(
				'label' => __('Use bottom-border style?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, fields will just have a bottom border", $ml_key),
			), 
			'pg_nolabel' => array(
				'label' => __('Hide labels?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, input and dropdown labels will be hidden, focusing placeholders", $ml_key),
			),
			'pg_reg_layout' => array(
				'label' => __("Default forms layout", $ml_key),
				'type'	=> 'select',
				'val' 	=> array(
					'one_col' => __('Single column', $ml_key), 
					'fluid' => __('Fluid (multi column)', $ml_key)
				),
				'note'	=> __("Select default layout for registration and User Data add-on forms", $ml_key), 
			),
            'pg_onecol_form_max_w' => array(
				'label' 	=> __("One-column forms - maximum width", $ml_key),
				'type'		=> 'slider',
				'min_val'	=> 50,
				'max_val'	=> 1500,	
				'step'		=> 1,
				'value'		=> 'px',
				'def'		=> 460,
                'respect_limits' => false,
				'note'	    => ''
			),
            'pg_fluid_form_threshold' => array(
				'label' 	=> __("Fluid forms - columns maximum width", $ml_key), 
				'type'		=> 'slider',
				'min_val'	=> 50,
				'max_val'	=> 1000,	
				'step'		=> 1,
				'value'		=> 'px',
				'def'		=> 370,
                'respect_limits' => false,
				'note'	    => __("Threshold defining how fluid forms will be columnized", $ml_key),
			),
            'pg_messages_style' => array(
				'label' => __("Messages style", $ml_key),
				'type'	=> 'select',
				'val' 	=> pc_mess_styles_opts(),
				'note'	=> 'Choose the style you want to use for success/error messages and for warning boxes', 
			),
            'pg_messages_style_preview' => array(
				'label' => __("Messages style's preview", $ml_key),
				'type'	=> 'label_message',
				'content' => '<img src="" id="pg_messages_style_preview" />', 
			),
            
		),
	), 
    
    
	'lightbox_styling' => array(
		'sect_name'	=>  __('Lightbox', $ml_key),
		'fields' 	=> array(
			
			'pg_lb_padding' => array(
				'label' 	=> __("Padding", $ml_key),
				'type'		=> 'slider',
				'min_val'	=> 10,
				'max_val'	=> 35,	
				'step'		=> 1,
				'value'		=> 'px',
				'def'		=> 25,
                'respect_limits' => false,
				'note'		=> __("Set lightbox padding - ignored if it contains only a form (default: 25px)", $ml_key),
			),
			'pg_lb_border_radius' => array(
				'label' 	=> __("Border Radius", $ml_key),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 50,	
				'step'		=> 1,
				'value'		=> 'px',
				'def'		=> 3,
                'respect_limits' => false,
				'note'		=> __("Set lightbox border radius - ignored if it contains only a form (default: 3px)", $ml_key),
			),
			'pg_lb_border_w' => array(
				'label' 	=> __("Border width", $ml_key),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 10,	
				'step'		=> 1,
				'value'		=> 'px',
				'def'		=> 0,
                'respect_limits' => false,
				'note'		=> __("Set lightbox borders width (default: 0px)", $ml_key),
			),
			'pg_lb_max_w' => array(
				'label' 	=> __("Maximum width", $ml_key),
				'type'		=> 'slider',
				'min_val'	=> 40,
				'max_val'	=> 95,	
				'step'		=> 1,
				'value'		=> '%',
				'def'		=> 70,
                'respect_limits' => true,
				'note'		=> __("Set lightbox max-width - on mobile it is fixed to 90% (default: 70%)", $ml_key),
			),
			'spcr1' => array(
				'type' => 'spacer',
			),
			'pg_lb_border_col' => array(
				'label' => __('Border color', $ml_key),
				'type'	=> 'color',
				'def'	=> '#dddddd',
				'note'	=> '',
			),
			'pg_lb_overlay_col' => array(
				'label' => __('Overlay color', $ml_key),
				'type'	=> 'color',
				'def'	=> '#111111',
				'note'	=> '',
			),
			'pg_lb_overlay_alpha' => array(
				'label' 	=> __("Overlay opacity", $ml_key),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 100,	
				'step'		=> 5,
				'value'		=> '%',
				'def'		=> 80,
                'respect_limits' => true,
				'note'		=> '',
			),
			'pg_lb_bg' => array(
				'label' => __('Background color', $ml_key),
				'type'	=> 'color',
				'def'	=> '#ffffff',
				'note'	=> ''
			),
			'pg_txt_col' => array(
				'label' => __('Text color', $ml_key),
				'type'	=> 'color',
				'def'	=> '#555555',
				'note'	=> __("Note: this won't apply to PrivateContent forms", $ml_key),
			),
		),
	),
    
    
	'typography' => array(
		'sect_name'	=>  __('Typography', $ml_key),
		'fields' 	=> array(
			
			'pg_labels_font_size' => array(
				'label' 	=> __("Form labels - font size", $ml_key),
                'type'			=> 'val_n_type',
				'max_val_len'	=> 4,
				'def'			=> 15,
				'types' 		=> array(
					'px'	=> 'px',
					'rem'	=> 'rem',
					'vmax'	=> 'vmax',
				),
                'required'  => true,
				'note'		=> __("Set labels size for any privateContent form (default: 15px)", $ml_key),
			),
			'pg_fields_font_size' => array(
				'label' 	=> __("Form fields - font size", $ml_key),
                'type'			=> 'val_n_type',
				'max_val_len'	=> 4,
				'def'			=> 14,
				'types' 		=> array(
					'px'	=> 'px',
					'rem'	=> 'rem',
					'vmax'	=> 'vmax',
				),
                'required'  => true,
				'note'		=> __("Set registration form labels size (default: 14px)", $ml_key),
			),
			'pg_btns_font_size' => array(
				'label' 	=> __("Form buttons - font size", $ml_key),
                'type'			=> 'val_n_type',
				'max_val_len'	=> 4,
				'def'			=> 14,
				'types' 		=> array(
					'px'	=> 'px',
					'rem'	=> 'rem',
					'vmax'	=> 'vmax',
				),
                'required'  => true,
				'note'		=> __("Set buttons font size (default: 14px)", $ml_key),
			),
			'pg_forms_font_family' => array(
				'label' => __('Form elements - font family', $ml_key),
				'type'	=> 'text',
				'note'	=> __("Set forms font family (leave empty to use theme's one)", $ml_key),
			),
		),
	),	
	
	
    'preset_styles' => array(
		'sect_name'	=>  __('Preset Styles', $ml_key),
		'fields' 	=> array(
			
			'preset_styles_field' => array(
				'type'		=> 'custom',
				'callback'	=> 'pg_preset_styles'
			), 
		),
	),
    
    
	'elems_layout' => array(
		'sect_name'	=>  __('Elements Layout', $ml_key),
		'fields' 	=> array(
            
			'pg_form_add_padding' => array(
				'label' 	=> __("Forms additional padding <small>(vertical / horizontal)</small>", $ml_key),
				'type'		=> '2_numbers',
				'min_val'	=> 0,
				'max_val'	=> 40,	
				'value'		=> 'px',
				'def'		=> array(0, 0),
				'note'		=> ''
			),
			'pg_field_padding' => array(
				'label' 	=> __("Fields padding <small>(vertical / horizontal)</small>", $ml_key),
				'type'		=> '2_numbers',
				'min_val'	=> 0,
				'max_val'	=> 15,	
				'value'		=> 'px',
				'def'		=> array(get_option('pg_field_padding', 3), get_option('pg_field_padding', 3)),
				'note'		=> '',
			),
			'pg_buttons_padding' => array(
				'label' 	=> __("Buttons padding <small>(vertical / horizontal)</small>", $ml_key),
				'type'		=> '2_numbers',
				'min_val'	=> 0,
				'max_val'	=> 25,	
				'value'		=> 'px',
				'def'		=> array(6, 15),
				'note'		=> '',
			),
			'spcr1' => array(
				'type' => 'spacer',
			),
			'pg_forms_border_w' => array(
				'label' 	=> __("Forms border width", $ml_key),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 10,	
				'step'		=> 1,
				'value'		=> 'px',
				'def'		=> 1,
                'respect_limits' => false,
				'note'		=> '',
			),
			'pg_field_border_w' => array(
				'label' 	=> __("Fields border width", $ml_key),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 5,	
				'step'		=> 1,
				'value'		=> 'px',
				'def'		=> 1,
                'respect_limits' => false,
				'note'		=> '',
			),
			'pg_btn_border_w' => array(
				'label' 	=> __("Buttons border width", $ml_key),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 5,	
				'step'		=> 1,
				'value'		=> 'px',
				'def'		=> 1,
                'respect_limits' => false,
				'note'		=> '',
			),
			'spcr2' => array(
				'type' => 'spacer',
			),
			'pg_form_border_radius' => array(
				'label' 	=> __("Forms border radius", $ml_key),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 50,	
				'step'		=> 1,
				'value'		=> 'px',
				'def'		=> 2,
                'respect_limits' => false,
				'note'	=> '',
			),
            'pg_field_border_radius' => array(
				'label' 	=> __("Fields border radius", $ml_key),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 50,	
				'step'		=> 1,
				'value'		=> 'px',
				'def'		=> 0,
                'respect_limits' => false,
				'note'	=> '',
			),
			'pg_btn_border_radius' => array(
				'label' 	=> __("Buttons border radius", $ml_key),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 50,	
				'step'		=> 1,
				'value'		=> 'px',
				'def'		=> 2,
                'respect_limits' => false,
				'note'	=> '',
			),
            'spcr2a' => array(
				'type' => 'spacer',
			),
			'pg_reg_fblock_gap' => array(
				'label' 	=> __("Registration fields gap", $ml_key),
                'type'		=> '2_numbers',
				'min_val'	=> 0,
				'max_val'	=> 200,	
				'value'		=> 'px',
				'def'		=> array(20, 35),
				'note'		=> __("Defines the vertical and horizontal gap between registration form fields (default: 20 / 35px)", $ml_key),
			),
            'pg_login_fields_gap' => array(
				'label' 	=> __("Login fields gap", $ml_key),
				'type'		=> 'slider',
				'min_val'	=> 10,
				'max_val'	=> 40,	
				'step'		=> 1,
				'value'		=> 'px',
				'def'		=> 15,
                'respect_limits' => false,
				'note'		=> __("Defines the vertical space between login form fields (default: 15px)", $ml_key),
			),
            'pg_fullw_login_fields' => array(
				'label' => __('Fullwidth login fields?', $ml_key),
				'type'	=> 'checkbox',
                'def'   => true,
				'note'	=> __("If checked, the login fields will fill the whole form's width", $ml_key),
			),
            'pg_fullw_login_btn' => array(
				'label' => __('Fullwidth login form buttons?', $ml_key),
				'type'	=> 'checkbox',
				'note'	=> __("If checked, the login buttons will fill the whole form's width", $ml_key),
			),
			'pg_separator_margin' => array(
				'label' 	=> __("Separator bar's extra margin", $ml_key),
				'type'		=> 'slider',
				'min_val'	=> 0,
				'max_val'	=> 150,	
				'step'		=> 1,
				'value'		=> 'px',
				'def'		=> 10,
                'respect_limits' => false,
				'note'		=> __("Defines an extra vertical margin for separator bar in registration forms (default: 10px)", $ml_key),
			),
			
		), 
	),	
	
	
	'colors' => array(
		'sect_name'	=>  __('Colors', $ml_key),
		'fields' 	=> array(
			
			'pg_forms_bg_col' => array(
				'label' => __('Forms background color', $ml_key),
				'type'	=> 'color',
				'def'	=> '#fefefe',
                'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
				'note'	=> '',
			),
			'pg_forms_border_col' => array(
				'label' => __('Forms border color', $ml_key),
				'type'	=> 'color',
				'def'	=> '#ebebeb',
                'extra_modes' => array('alpha'),
				'note'	=> '',
			),
            'pg_forms_shadow' => array(
				'label' => __("Apply form's shadow?", $ml_key),
				'type'	=> 'select',
				'val' 	=> array(
					'' 	=> __('No', $ml_key),
					'light'    => __('Light', $ml_key),
					'medium'   => __('Medium', $ml_key),
					'heavy'    => __('Heavy', $ml_key),
				),
				'note'	=> '', 
			),
            'pg_forms_shadow_col' => array(
				'label' => __("Form's shadow color", $ml_key),
				'type'	=> 'color',
				'def'	=> '#000000',
                'extra_modes' => array(),
				'note'	=> '',
                
                'js_vis'=> array(
					'linked_field' 	=> 'pg_forms_shadow',
					'condition'		=> '',
                    'operator'		=> '!=',
				)
			),
			'pg_label_col' => array(
				'label' => __('Labels color', $ml_key),
				'type'	=> 'color',
				'def'	=> '#333333',
                'extra_modes' => array(),
				'note'	=> '',
			),
			'spcr1' => array(
				'type' => 'spacer',
			),
			'pg_fields_bg_col' => array(
				'label' => __('Fields background color - default status', $ml_key),
				'type'	=> 'color',
				'def'	=> '#fefefe',
                'extra_modes' => array('alpha'),
				'note'	=> '',
			),
			'pg_fields_border_col' => array(
				'label' => __('Fields border color - default status', $ml_key),
				'type'	=> 'color',
				'def'	=> '#cccccc',
                'extra_modes' => array('alpha'),
				'note'	=> '',
			),
			'pg_fields_placeh_col' => array(
				'label' => __('Fields placeholder color - default status', $ml_key),
				'type'	=> 'color',
				'def'	=> '#888888',
                'extra_modes' => array(),
				'note'	=> '',
			),
			'pg_fields_txt_col' => array(
				'label' => __('Fields text color - default status', $ml_key),
				'type'	=> 'color',
				'def'	=> '#808080',
                'extra_modes' => array(),
				'note'	=> '',
			),
			'pg_fields_icon_col' => array(
				'label' => __('Fields icon color - default status', $ml_key),
				'type'	=> 'color',
				'def'	=> '#808080',
                'extra_modes' => array('alpha'),
				'note'	=> '',
			),
			'pg_fields_icon_bg' => array(
				'label' 		=> __('Fields icon background - default status', $ml_key),
				'type'			=> 'color',
				'def'		    => '#f8f8f8',
				'extra_modes'   => array('alpha', 'linear-gradient', 'radial-gradient'),
			),
			'pg_fields_bg_col_h' => array(
				'label' => __('Fields background color - on hover', $ml_key),
				'type'	=> 'color',
				'def'	=> '#ffffff',
                'extra_modes' => array('alpha'),
				'note'	=> '',
			),
			'pg_fields_border_col_h' => array(
				'label' => __('Fields border color - on hover', $ml_key),
				'type'	=> 'color',
				'def'	=> '#aaaaaa',
                'extra_modes' => array('alpha'),
				'note'	=> '',
			),
			'pg_fields_placeh_col_h' => array(
				'label' => __('Fields placeholder color - on hover', $ml_key),
				'type'	=> 'color',
				'def'	=> '#666666',
                'extra_modes' => array(),
				'note'	=> '',
			),
			'pg_fields_txt_col_h' => array(
				'label' => __('Fields text color - on hover', $ml_key),
				'type'	=> 'color',
				'def'	=> '#444444',
                'extra_modes' => array(),
				'note'	=> '',
			),
			'pg_fields_icon_col_h' => array(
				'label' => __('Fields icon color - hover status', $ml_key),
				'type'	=> 'color',
				'def'	=> '#666666',
                'extra_modes' => array('alpha'),
				'note'	=> '',
			),
			'pg_fields_icon_bg_h' => array(
				'label' 			=> __('Fields icon background - hover status', $ml_key),
				'type'				=> 'color',
				'def'				=> '#f0f0f0',
				'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
				'note'				=> '',
			),
			'spcr2' => array(
				'type' => 'spacer',
			),
			'pg_btn_bg_col' => array(
				'label' => __('Buttons background color - default status', $ml_key),
				'type'	=> 'color',
				'def'	=> '#f4f4f4',
                'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
				'note'	=> '',
			),
			'pg_btn_border_col' => array(
				'label' => __('Buttons border color - default status', $ml_key),
				'type'	=> 'color',
				'def'	=> '#cccccc',
                'extra_modes' => array('alpha'),
				'note'	=> '',
			),
			'pg_btn_txt_col' => array(
				'label' => __('Buttons text color - default status', $ml_key),
				'type'	=> 'color',
				'def'	=> '#444444',
                'extra_modes' => array(),
				'note'	=> '',
			),
			'pg_btn_bg_col_h' => array(
				'label' => __('Buttons background color - on hover', $ml_key),
				'type'	=> 'color',
				'def'	=> '#efefef',
                'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
				'note'	=> '',
			),
			'pg_btn_border_col_h' => array(
				'label' => __('Buttons border color - on hover', $ml_key),
				'type'	=> 'color',
				'def'	=> '#cacaca',
                'extra_modes' => array('alpha'),
				'note'	=> '',
			),
			'pg_btn_txt_col_h' => array(
				'label' => __('Buttons text color - on hover', $ml_key),
				'type'	=> 'color',
				'def'	=> '#222222',
                'extra_modes' => array(),
				'note'	=> '',
			),
            'spcr3' => array(
				'type' => 'spacer',
			),
            'pg_lcswitch_knob_col' => array(
				'label' => __('Switch knob color', $ml_key),
				'type'	=> 'color',
				'def'	=> '#ffffff',
                'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
				'note'	=> '',
			),
            'pg_lcswitch_off_col' => array(
				'label' => __('Switch color - off status', $ml_key),
				'type'	=> 'color',
				'def'	=> '#cccccc',
                'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
				'note'	=> '',
			),
            'pg_lcswitch_on_col' => array(
				'label' => __('Switch color - on status', $ml_key),
				'type'	=> 'color',
				'def'	=> '#75b936',
                'extra_modes' => array('alpha', 'linear-gradient', 'radial-gradient'),
				'note'	=> '',
			),
            'spcr4a' => array(
				'type' => 'spacer',
                
                'js_vis'=> array(
					'linked_field' 	=> 'pg_forms_pags_progress',
					'condition'		=> true 
				)
			),
            'pg_fpp_bg' => array(
				'label' => __('Forms pagination progressbar - default status - background', $ml_key),
				'type'	=> 'color',
				'def'	=> '#e4e4e4',
                'extra_modes' => array('linear-gradient', 'radial-gradient'),
				'note'	=> '',
                
                'js_vis'=> array(
					'linked_field' 	=> 'pg_forms_pags_progress',
					'condition'		=> true 
				)
			),
            'pg_fpp_col' => array(
				'label' => __('Forms pagination progressbar - default status - color', $ml_key),
				'type'	=> 'color',
				'def'	=> '#373737',
                'extra_modes' => array(),
				'note'	=> '',
                
                'js_vis'=> array(
					'linked_field' 	=> 'pg_forms_pags_progress',
					'condition'		=> true 
				)
			),
            'pg_fpp_bg_h' => array(
				'label' => __('Forms pagination progressbar - active status - background', $ml_key),
				'type'	=> 'color',
				'def'	=> '#74b945',
                'extra_modes' => array('linear-gradient', 'radial-gradient'),
				'note'	=> '',
                
                'js_vis'=> array(
					'linked_field' 	=> 'pg_forms_pags_progress',
					'condition'		=> true 
				)
			),
            'pg_fpp_col_h' => array(
				'label' => __('Forms pagination progressbar - active status - color', $ml_key),
				'type'	=> 'color',
				'def'	=> '#ffffff',
                'extra_modes' => array(),
				'note'	=> '',
                
                'js_vis'=> array(
					'linked_field' 	=> 'pg_forms_pags_progress',
					'condition'		=> true 
				)
			),
		),
	),
	
	
	'cust_css' => array(
		'sect_name'	=>  __('Custom CSS', $ml_key),
		'fields' 	=> array(
			
			'pg_custom_css' => array(
				'label' => 'custom CSS',
				'type'	=> 'code_editor',
				'language'	=> 'css',
			),
		),
	),
);



// URL-BASED RESTRICTIONS
$structure['pc_cust_restr'] = array(
	'url_base_restr' => array(
		'sect_name'	=> __('URL-based Restrictions', $ml_key) .'<a id="pc_add_cr_trig">'. __('Add restriction', $ml_key) .'</a>',
		'fields' 	=> array(
			
			'pg_url_base_restr_field' => array(
				'type'		=> 'custom',
				'callback'	=> 'pg_url_base_restr_field',
				'validation'=> array(
					array('index' => 'pg_cr_url', 'label'=>'Custom restrictions - url'),
					array('index' =>'pg_cr_allow', 'label'=>'Custom restrictions - allowed'),
					array('index' =>'pg_cr_block', 'label'=>'Custom restrictions - blocked')
				)
			), 
		),
	),
);




// PC-FILTER - manipulate settings structure
$GLOBALS['pc_settings_structure'] = apply_filters('pc_settings_structure', $structure);
