<?php 
dike_lc('lcweb', PC_DIKE_SLUG, true);

include_once(PC_DIR . '/classes/simple_form_validator.php');
include_once(PC_DIR . '/settings/settings_engine.php'); 
include_once(PC_DIR . '/settings/field_options.php'); 
include_once(PC_DIR . '/settings/custom_fields.php');
include_once(PC_DIR . '/settings/structure.php'); 

global $pc_wp_user;
$ml_key = 'pc_ml';

$engine = new pc_settings_engine('pc_settings', $GLOBALS['pc_settings_tabs'], $GLOBALS['pc_settings_structure']);
?>

<div class="wrap lcwp_settings_wrap">
    <div class="lcwp_settings_head">
        <h2 class="lcwp_settings_page_title"><?php esc_html_e('PrivateContent Settings', $ml_key) ?></h2>  
        
        <div class="lcwp_settings_head_cmds">
            <?php echo $engine->import_export_btns() ?>
            <form class="lcwp_sf_search_wrap">
                <i class="dashicons dashicons-no-alt"></i>
                <input type="text" name="lcwp_sf_search" value="" placeholder="<?php esc_attr_e('search fields', $ml_key) ?> .." /> 
            </form>
        </div>
    </div>

	<?php
    // get fetched data and allow customizations
    if($engine->form_submitted()) {
        $fdata = $engine->form_data;
        $errors = (!empty($engine->errors)) ? $engine->errors : array();
        
        
        
        /////////////////////////////////////////////////////////
        
    
        
        // validate custom redirects
        if($fdata['pg_redirect_page'] == 'custom' && empty($fdata['pg_redirect_page_custom'])) {
            $errors[ esc_html__('Restriction redirect target / Custom URL', $ml_key) ] = __('Insert a valid URL', $ml_key); 	
        }
        if($fdata['pg_logged_user_redirect'] == 'custom' && empty($fdata['pg_logged_user_redirect_custom'])) {
            $errors[ esc_html__('Logged In Users Redirect / Custom URL', $ml_key) ] = __('Insert a valid URL', $ml_key); 	
        }
        if($fdata['pg_logout_user_redirect'] == 'custom' && empty($fdata['pg_logout_user_redirect_custom'])) {
            $errors[ esc_html__('Logged In Users Redirect / Custom URL', $ml_key) ] = __('Insert a valid URL', $ml_key); 	
        }
        
        
        
		// Google Analytics - validate tracking code
		if(!empty($fdata['pg_analytics_id'])) {
			if(!preg_match('/^ua-\d{4,9}-\d{1,4}$/i', $fdata['pg_analytics_id'])) {
				$errors[ esc_html__('Google Analytics', $ml_key) ] = __('Tracking ID format is wrong', $ml_key); 	
			}
		}
		
		
        
        // Manage user pvt pages management capabilities on settings save
        if(isset($fdata['pg_min_role'])) {     
            pc_wpuc_static::upp_manag_wp_roles_setup($fdata['pg_min_role']);
            
            // PC categories custom capability setup
            $include_pc_admin_role = (isset($fdata['pg_any_pc_admin_cmu']) && $fdata['pg_any_pc_admin_cmu']) ? true : false;
            pc_wpuc_static::pc_cats_manag_cap_setup($fdata['pg_min_role'], $include_pc_admin_role);
        }
        
        //PC Admin (WP role) capabilities setup
        if(isset($fdata['pg_pc_admin_role_add_caps'])) {
            pc_wpuc_static::man_pc_admin_role_caps( (array)$fdata['pg_pc_admin_role_add_caps'] );
        }
        
        
        
		// WP registration to PC - where enabled, require caregories
		if(!empty($fdata['wp_to_pc_sync_on_register']) && empty($fdata['wp_to_pc_sync_on_register_cats'])) {
			$errors[ esc_html__('WordPress to PrivateContent - Registration Sync', $ml_key) ] = __('Select at least one category', $ml_key); 
		}
		
		
        
		// lightbox instances - validate and save
		if(isset($_POST['pc_lb_id'])) {
			$tot_lb = count($_POST['pc_lb_id']);
			$GLOBALS['pc_lb_data'] = array(); // utility array to keep changes also with errors 
			
			// check fields consistency
			if(
				(!is_array($_POST['pc_lb_note']) || count($_POST['pc_lb_note']) != $tot_lb) ||
				(!is_array($_POST['pc_lb_contents']) || count($_POST['pc_lb_contents']) != $tot_lb)
			) {
				$errors[ esc_html__('Lightbox instances', $ml_key) ] = __('Missing fields', $ml_key); 		
			}
			
			else {
				// every field must be filled
				$a = 0;
				foreach($_POST['pc_lb_id'] as $lb_id) {
					$note 		= stripslashes($_POST['pc_lb_note'][$a]);
					$contents 	= stripslashes($_POST['pc_lb_contents'][$a]);
					
					$GLOBALS['pc_lb_data'][$lb_id] = array(
						'note' 		=> $note,
						'contents'	=> $contents
					);
					
					if(empty($note) || empty($contents)) {
						$errors[ esc_html__('Lightbox instances', $ml_key) ] = __('Every field must be filled', $ml_key); 	
					}
					else {
						wp_update_term($lb_id, 'pc_lightboxes', array(
						  'name' 		=> $note,
						  'description'	=> base64_encode($contents)
						));
						
						// sync with WPML
						if(function_exists('icl_register_string')) {
							icl_register_string('PrivateContent Lightboxes', 'Lightbox #'.$lb_id, $contents);
						}
						
						// sync with Polylang
						if(function_exists('pll_register_string')) {
							pll_register_string('PrivateContent Lightboxes', $contents, 'Lightbox #'.$lb_id, true);
						}
					}
					
					$a++;
				}
			}
		}
		
        
		
        // custom restrictions - check data existence in arrays
        if(!empty($fdata['pg_cr_url'])) {
            for($a=0; $a < count($fdata['pg_cr_url']); $a++) {
                if(empty($fdata['pg_cr_url'][$a]) || !isset($fdata['pg_cr_allow'][$a]) || empty($fdata['pg_cr_allow'][$a])) {
                    
                    $errors[ esc_html__('Custom Restrictions', $ml_key) ] = __('Each restriction must have an "allow" value', $ml_key); 	
                    break;	
                }
            }
        }
        
        
        
        /////////////////////////////////////////////////////////
        
    
        
        // PC-FILTER - manipulate setting errors - passes errors array and form values - error subject as index + error text as val
        $errors = apply_filters('pc_setting_errors', $errors, $fdata);	
        
        
        // save or print error
        if(empty($errors)) {
            
            // apply custom WPS roles
            if(isset($fdata['pg_wp_user_sync'])) {
                $old_roles = $pc_wp_user->get_wps_custom_roles();
                $new_roles = array_unique( array_merge(array('pvtcontent'), (array)$fdata['pg_custom_wps_roles']));

                sort($old_roles); sort($new_roles);

                if($old_roles !== $new_roles) {
					$pc_wp_user->wps_roles = $new_roles;
                    $pc_wp_user->set_wps_custom_roles();
                    
                    $fdata['pg_custom_wps_roles'] = $new_roles;
                }	
            }
            
            // PC-FILTER - allow data manipulation (or custom actions) before settings save - passes form values
            $engine->form_data = apply_filters('pc_before_save_settings', $fdata); 
            
            // save
            $engine->save_data();
            
            
            
            // create custom style css file
            if(!get_option('pg_inline_css') && !isset($_POST['pg_inline_css'])) {
                if(!pc_static::create_custom_style()) {
                    update_option('pg_inline_css', 1);	
                    echo '<div class="updated"><p>'. __('An error occurred during dynamic CSS creation. Code will be used inline anyway', $ml_key) .'</p></div>';
                }
                else {
                    delete_option('pg_inline_css');
                }
            }
			
            $engine->successful_save_redirect();
        }
        
        // compose and return errors
        else {
            echo $engine->get_error_message_html($errors);	
        }
    }
	
	
	// if successfully saved
	echo $engine->get_success_message_html();
	
	// print form code
    echo $engine->get_code();
    ?>
</div>




<?php
// FIELDS ICON WIZARD
echo pc_static::fa_icon_picker_code( __('no icon', $ml_key), true);
?>

<script type="text/javascript">
(function($) { 
    "use strict"; 

    <?php pc_static::fa_icon_picker_js('pc_field_icon_trigger'); ?>
})(jQuery); 
</script>




<?php // SCRIPTS ?>
<script type="text/javascript">
(function($) { 
    "use strict";    

    const settings_baseurl = `<?php echo $engine->baseurl ?>`;
    
    $(document).ready(function($) {
        // codemirror - execute before tabbing
        $('.lcwp_sf_code_editor').each(function() {
            CodeMirror.fromTextArea( $(this)[0], {
                lineNumbers: true,
                mode: "css"
            });
        });
        
        // unwrap unwanted warnings in lcwp_settings_head
        setTimeout(function() {
            $('.lcwp_settings_head > *').not('.lcwp_settings_page_title, .lcwp_settings_head_cmds').each(function() {
                $('.lcwp_settings_wrap').prepend( $(this).detach() ); 
            });
        }, 200);
        
        

        var rf_is_acting = false; // registration form builder flag 
        var li_is_acting = false; // lightbox instance flag  
        var wps_is_acting = false; // WP user sync flag 
        var pc_nonce = '<?php echo wp_create_nonce('lcwp_ajax') ?>';

        const lc_select_refresh_evt = new Event('lc-select-refresh', {bubbles:true});


        // lightbox instance - add 
        $(document).on('click', '#pc_add_lb_trig', function() {
            li_is_acting = true;

            var $parent = $(this).parents('h3');
            $parent.append('<span class="pc_spinner pc_spinner_inline"></span>');

            var data = {
                action: 'pc_add_lightbox',
                pc_nonce: pc_nonce
            };
            $.post(ajaxurl, data, function(response) {
                $parent.find('.pc_spinner').remove();
                li_is_acting = false;

                if($.trim(response) == 'error') {
                    alert("<?php esc_attr_e('Error creating lightbox term', $ml_key) ?>");	
                }
                else {
                    if(!$('#pc_lb_inst li').length) {
                        $('#pc_lb_inst li em').remove();	
                    }

                    $('#pc_lb_inst').append(response);	
                }
            });
        });


        // lightbox instance - remove
        $(document).on('click', '#pc_lb_inst li .pc_del_field', function() {
            if(!li_is_acting && confirm("<?php esc_attr_e("Once deleted, you will not be able to use this trigger class. Continue?", $ml_key) ?>")) {

                var $li = $(this).parents('li');
                var lb_id = $(this).attr('rel');

                li_is_acting = true;
                $li.fadeTo(200, 0.5);

                var data = {
                    action	: 'pc_del_lightbox',
                    lb_id	: $(this).attr('rel'),
                    pc_nonce: pc_nonce
                };
                $.post(ajaxurl, data, function(response) {
                    li_is_acting = false;

                    if($.trim(response) != 'success') {
                        alert(response);	
                        $li.fadeTo(200, 1);
                    } else {
                        $li.remove();
                    }
                });
            }
        });


        /////////////////////////////////////////////////////////////////////


        // custom restrictions - add 
        $(document).on('click', '#pc_add_cr_trig', function() {
            if($('#pc_cr_list em').length) {$('#pc_cr_list').empty();}

            $('#pc_cr_list').append(' <?php echo addslashes(str_replace(array("\r", "\n", "\t", "\v"), '', pc_cr_template())); ?> ');
            lcwp_sf_live_select();
        });


        // custom restrictions - remove
        $(document).on('click', '#pc_cr_list li .pc_del_field', function() {
            if(confirm("<?php esc_attr_e("Remove this restriction?", $ml_key) ?>")) {
                $(this).parents('li').slideUp(function() {
                    $(this).remove();
                });
            }
        });


        // custom restrictions - avoid empty "allow/block" dropdown
        $("form.form-wrap").submit(function(e) {
            $('#pc_cr_list .pg_cr_allow').each(function() {
                if($(this).val() == null) {
                    $(this).replaceWith('<input type="hidden" name="pg_cr_allow[][]" value="" />');	
                }
            });

            $('#pc_cr_list .pg_cr_block').each(function() {
                if($(this).val() == null) {
                    $(this).replaceWith('<input type="hidden" name="pg_cr_block[][]" value="" />');	
                }
            });
        });


        // custom restrictions - all/unlogged toggles
        $(document).on('change', '#pc_cr_list li select', function() {
            var pc_sel = $(this).val();
            if(!pc_sel) {
                pc_sel = [];
            }

            // if ALL is selected, discard the rest
            if($.inArray("all", pc_sel) >= 0) {
                $(this).find('option').prop('selected', false);
                $(this).find('.pc_all_field').prop('selected', true);

                $(this)[0].dispatchEvent(lc_select_refresh_evt);
            }

            // if UNLOGGED is selected, discard the rest
            else if($.inArray("unlogged", pc_sel) >= 0) {
                $(this).find('option').prop('selected', false);
                $(this).find('.pc_unl_field').prop('selected', true);

                $(this)[0].dispatchEvent(lc_select_refresh_evt);
                var unlogged_chosen = true;
            }	
        });


        // custom restrictions - set allow/block dropdown indexes to allow multidimensional saving
        $("form.form-wrap").submit(function() {
            $('#pc_cr_list > li').each(function(i, v) {
                $(this).find('.pg_cr_allow').attr('name', 'pg_cr_allow['+ i +'][]');
                $(this).find('.pg_cr_block').attr('name', 'pg_cr_block['+ i +'][]');
            });

            return true;
        });


        // custom restrictions - sortable
        $("#pc_cr_list").sortable({ 
            handle: '.pc_move_field',
            axis: "y" 
        });
        $("#pc_cr_list .pc_move_field").disableSelection();


        /////////////////////////////////////////////////////////////////////


        // registration form builder - add form
        $(document).on('click', '#pc_reg_form_add', function() {
            var name = $.trim( $('#pc_new_reg_form_name').val());
            if(!name || rf_is_acting) {return false;}

            rf_is_acting = true;
            $('#pc_reg_form_loader').html('<span class="pc_spinner"></span>');

            var data = {
                action: 'pc_add_reg_form',
                form_name: name,
                pc_nonce: pc_nonce
            };
            $.post(ajaxurl, data, function(response) {
                $('#pc_reg_form_loader').empty();
                rf_is_acting = false;

                if($.isNumeric(response)) {
                    $('.pc_form_builder_dd option').removeAttr('selected');
                    $('.pc_form_builder_dd').append('<option value="'+ response +'" selected="selected">'+ response +' - '+ name +'</option>');

                    $('#pc_new_reg_form_name').val('');

                    const evt = new Event 
                    $('.pc_form_builder_dd')[0].dispatchEvent(lc_select_refresh_evt);
                }
                else {
                    alert(response);	
                }
            });
        });


        // registration form builder - load builder
        $(document).on('change', '.pc_form_builder_dd', function() {
            var val = $(this).val();
            if(!val) {
                $('#pc_reg_form_cmd').css('visibility', 'hidden');
                $('#pc_reg_form_builder').empty();
                return false;
            }

            if(rf_is_acting) {
                return false;
            }
            rf_is_acting = true;
            $('#pc_reg_form_loader').html('<span class="pc_spinner"></span>');

            var data = {
                action: 'pc_reg_form_builder',
                form_id: val,
                pc_nonce: pc_nonce
            };
            $.post(ajaxurl, data, function(response) {
                $('#pc_reg_form_cmd').css('visibility', 'visible');
                $('#pc_reg_form_builder').html(response);

                pc_live_checks();
                lcwp_sf_live_select();

                /*** sort formbuilder rows ***/
                $( "#pc_reg_form_builder tbody" ).sortable({ 
                    handle: '.pc_move_field',
                    axis: "y" 
                });
                $( "#pc_reg_form_builder tbody td .pc_move_field" ).disableSelection();

                $('#pc_reg_form_loader').empty();
                rf_is_acting = false;
            });
        });
        // on start - load first form
        if($('.pc_form_builder_dd option').length) {
            $('.pc_form_builder_dd').trigger('change');	
        }


        // add field to builder
        $(document).on('click', '#pc_rf_add_field', function() { 
            var f_val = $('.pc_form_fields_dd').val();
            var f_name = $('.pc_form_fields_dd option[value="'+ f_val +'"]').text();

            if(f_val != 'custom|||text' && f_val != 'custom|||page' && f_val != 'custom|||sep' && $('#pc_rf_builder_table tr[rel="'+ f_val +'"]').length) {
                alert("<?php esc_attr_e('Field already in the form', $ml_key) ?>");
                return false;	
            }

            var required = (f_val == 'categories') ? 'checked="checked"' : '';
            var disabled = (f_val == 'categories') ? 'disabled="disabled"' : ''; 

            if(f_val == 'custom|||text') {
                const d = new Date();
                let ct_uniq_id = f_val + '|||'+ d.getTime();            

                var code = 
                '<td colspan="2">'+
                    '<input type="hidden" name="pc_reg_form_field[]" value="'+ ct_uniq_id +'" class="pc_reg_form_builder_included" />'+
                    '<textarea name="pc_reg_form_texts[]" placeholder="<?php esc_attr_e('Supports HTML and shortcodes', $ml_key) ?>"></textarea>'+
                '</td>';
            }
            else if(f_val == 'custom|||sep') {
                const d = new Date();
                let ct_uniq_id = f_val + '|||'+ d.getTime();            

                var code = 
                '<td colspan="2" class="pc_separator_bar_td">'+
                    '<input type="hidden" name="pc_reg_form_field[]" value="'+ ct_uniq_id +'" class="pc_reg_form_builder_included" />'+
                    '<strong><?php esc_attr_e('SEPARATOR BAR', $ml_key) ?></strong>'+
                '</td>';
            }
            else if(f_val == 'custom|||page') {
                var code = 
                '<td colspan="2" class="pc_paginator_td">'+
                    '<input type="hidden" name="pc_reg_form_field[]" value="'+ f_val +'" class="pc_reg_form_builder_included" />'+
                    '<strong><?php esc_attr_e('PAGINATOR', $ml_key) ?></strong>'+
                '</td>';
            }
            else {
                var code = 
                '<td>'+
                    '<input type="hidden" name="pc_reg_form_field[]" value="'+ f_val +'" class="pc_reg_form_builder_included" />'+
                    f_name +
                '</td>'+
                '<td>'+
                    '<input type="checkbox" name="pc_reg_form_req[]" value="'+ f_val +'" '+required+' '+disabled+' class="lcwp_sf_check pc_reg_form_builder_required" autocomplete="off" />'+
                '</td>';	
            }

            $('#pc_rf_builder_table tbody').append(
            '<tr rel="'+ f_val +'">'+
                '<td><span class="pc_del_field dashicons dashicons-no-alt" title="<?php esc_attr_e('remove field', $ml_key) ?>"></span></td>'+
                '<td><span class="pc_move_field dashicons dashicons-move" title="<?php esc_attr_e('sort field', $ml_key) ?>"></span></td>'+
                code +
            '</tr>');

            pc_live_checks();
        });


        // delete form field
        $(document).on('click', '#pc_rf_builder_table .pc_del_field', function() { 
            if(!rf_is_acting) {
                $(this).parents('tr').fadeOut(400 ,function() {
                    $(this).remove();
                });
            }
        });


        // update form structure 
        $(document).on('click', '.pc_reg_form_save', function() {
            if(rf_is_acting) {
                return false;
            }

            rf_is_acting = true;
            $('#pc_reg_form_loader').html('<span class="pc_spinner"></span>');

            var form_id = $('.pc_form_builder_dd').val();
            var form_name = $('#pc_rf_name').val();

            // create fields + required array
            var included = [];
            var required = [];
            var texts 	= [];

            $('#pc_rf_builder_table tbody tr').each(function(i,v) {
                var f = $(this).find('.pc_reg_form_builder_included').val();
                included.push(f);

                if(f.substr(0, 13) == 'custom|||text') {
                    texts.push( $(this).find('textarea').val() );	
                }
                else {
                    if( $(this).find('.pc_reg_form_builder_required').is(':checked') ) {
                        required.push(f);	
                    }
                }
            });

            var data = {
                action: 'pc_update_reg_form',
                form_id: form_id,
                form_name: form_name, 
                fields_included: included,
                fields_required: required,
                texts: texts,
                pc_nonce: pc_nonce
            };
            $.post(ajaxurl, data, function(response) {
                $('#pc_reg_form_loader').empty();
                rf_is_acting = false;

                if($.trim(response) == 'success') {
                    $('.pc_form_builder_dd option[value='+ form_id +']').html( form_id+' - '+form_name );
                    $('.pc_form_builder_dd')[0].dispatchEvent(lc_select_refresh_evt);

                    $('.pc_reg_form_save').css('background-color', '#7fc241').css('color', '#fff');
                    setTimeout(function(){
                        $('.pc_reg_form_save').css('background-color', '').css('color', '');
                    }, 500);
                }
                else {alert(response);}
            });	
        });


        // delete form - leaving one
        $(document).on('click', '#pc_reg_form_del', function() {
            if($('.pc_form_builder_dd option').length == 1) {
                alert("<?php esc_attr_e('At least one form is required', $ml_key) ?>");
                return false;	
            }

            var form_id = $('.pc_form_builder_dd').val();
            if(!form_id) {return false;}

            if(confirm("<?php esc_attr_e('Delete this form? Related shortcodes will show the first one', $ml_key) ?>")) {
                rf_is_acting = true;
                $('#pc_reg_form_loader').html('<span class="pc_spinner"></span>');

                var data = {
                    action: 'pc_del_reg_form',
                    form_id: form_id,
                    pc_nonce: pc_nonce
                };
                $.post(ajaxurl, data, function(response) {
                    $('#pc_reg_form_loader').empty();
                    rf_is_acting = false;

                    if($.trim(response) == 'success') {
                        $('.pc_form_builder_dd option[value='+ form_id +']').remove();
                        $('.pc_form_builder_dd option').first().attr('selected', 'selected');
                        $('.pc_form_builder_dd')[0].dispatchEvent(lc_select_refresh_evt);	

                        $('#pc_reg_form_del').css('background-color', '#BB7071').css('color', '#fff');
                        setTimeout(function(){
                            $('#pc_reg_form_del').css('background-color', '').css('color', '');
                        }, 500);
                    }
                    else {alert(response);}
                });	
            }
        });



        ///////////////////////////////////////////////////



        // sync WP users sync
        $(document).on('click', '#pc_do_wp_sync', function() {
            if(!wps_is_acting && confirm("<?php esc_attr_e('Mirror wordpress users will be created. Continue?', $ml_key) ?>")) {

                wps_is_acting = true;
                var $result_wrap = $(this).next('span');
                $result_wrap.html('<span class="pc_spinner pc_spinner_inline"></span>');

                var data = {
                    action: 'pc_wp_global_sync',
                    pc_nonce: pc_nonce
                };
                $.post(ajaxurl, data, function(response) {
                    $result_wrap.html(response);
                    wps_is_acting = false;
                });
            }
        });

        // clean WP users sync
        $(document).on('click', '#pc_clean_wp_sync', function() {
            if(!wps_is_acting && confirm("<?php esc_attr_e('WARNING: this will delete connected wordpress users and any related content will be lost. Continue?', $ml_key) ?>")) {

                wps_is_acting = true;
                var $result_wrap = $(this).next('span');
                $result_wrap.html('<span class="pc_spinner"></span>');

                var data = {
                    action: 'pc_wp_global_detach',
                    pc_nonce: pc_nonce
                };
                $.post(ajaxurl, data, function(response) {
                    $result_wrap.html(response);
                    wps_is_acting = false;
                });
            }
        });

        // search existing matches and sync
        $(document).on('click', '#pc_wps_matches_sync', function() {
            if(!wps_is_acting && confirm("<?php esc_attr_e('WARNING: this will turn matched WP userse into PrivateContent mirrors. Continue?', $ml_key) ?>")) {

                wps_is_acting = true;
                var $result_wrap = $(this).next('span');
                $result_wrap.html('<span class="pc_spinner"></span>');

                var data = {
                    action: 'pc_wps_search_and_sync_matches',
                    pc_nonce: pc_nonce
                };
                $.post(ajaxurl, data, function(response) {
                    $result_wrap.html(response);
                    wps_is_acting = false;
                });
            }
        });



        //////////////////////////////////////



        // messages styles preview
        const show_mess_preview_img = function() {
            const baseurl = '<?php echo PC_URL ?>/img/mess_styles/|||.jpg',
            val = document.querySelector('select[name="pg_messages_style"]').value;

            document.getElementById('pg_messages_style_preview').setAttribute('src', baseurl.replace('|||', val));

            return true;
        };
        show_mess_preview_img();

        $(document).on('change', 'select[name="pg_messages_style"]', show_mess_preview_img);



        //////////////////////////////////////



        // options search
        let lcwp_sf_search_tout = false;
        $(document).on('keyup', '.lcwp_sf_search_wrap input', function(e) {
            const val = $(this).val().trim();

            if(lcwp_sf_search_tout) {
                clearTimeout(lcwp_sf_search_tout);    
            }

            lcwp_sf_search_tout = setTimeout(function() {
                // reset
                $('.lcsw_sf_search_no_res').remove();
                $('.lcsw_sf_search_excluded').removeClass('lcsw_sf_search_excluded');

                // elaborate
                if(val.length < 3) {
                    $('.lcwp_sf_search_wrap').removeClass('lcwp_sf_searching');
                }
                else {
                    $('.lcwp_sf_search_wrap').addClass('lcwp_sf_searching');
                    $('.lcwp_sf_spacer').parent().addClass('lcsw_sf_search_excluded');  

                    // cycle through sections
                    $('.lcwp_settings_table').each(function() {
                        let hide_table = true;

                        $(this).find('.lcwp_sf_label label').each(function() {
                            const $tr = $(this).parents('tr').first();

                            let matching_string = $(this).text().trim().toLowerCase();
                            if($tr.find('.lcwp_sf_note').length) {
                                matching_string += ' '+ $tr.find('.lcwp_sf_note').text();
                            }

                            if(matching_string.indexOf( val.toLowerCase() ) === -1) {
                                $tr.addClass('lcsw_sf_search_excluded');    
                            }
                            else {
                                hide_table = false;
                                $tr.removeClass('lcsw_sf_search_excluded');    
                            }
                        });

                        if(hide_table) {
                            $(this).addClass('lcsw_sf_search_excluded');
                            $(this).prev('h3').addClass('lcsw_sf_search_excluded');
                        }
                    });

                    // leave only tabs with matching options
                    $('.lcwp_settings_block').each(function() {
                        if(!$(this).find('> *:not(.lcsw_sf_search_excluded):not(script):not(style)').length) {
                            $('a.nav-tab[href="#'+ $(this).attr('id') +'"]').addClass('lcsw_sf_search_excluded');    
                        }
                    });

                    // select first tab with matching options
                    if($('a.nav-tab').not('.lcsw_sf_search_excluded').length) {
                        $('a.nav-tab').not('.lcsw_sf_search_excluded').first().click();
                    } else {
                        $('.nav-tab-wrapper').append('<span class="lcsw_sf_search_no_res"><?php esc_html_e('No matching options', $ml_key) ?> ..</span>');    
                    }
                }
            }, 500);
        });
        $('.lcwp_sf_search_wrap input').val(''); // avoid browser cache


        // reset search
        $(document).on('click', '.lcwp_sf_search_wrap i', function() {
            $('.lcwp_sf_search_wrap input').val('').trigger('keyup');        
        });


        //////////////////////////////////////////////////


        // tabify
        $('.lcwp_settings_tabs').each(function() {
            var sel = '';
            var hash = window.location.hash;

            var $form = $(".lcwp_settings_form");
            var form_act = $form.attr('action');

            // track URL on opening
            if(hash && $(this).find('.nav-tab[href="'+ hash +'"]').length) {
                $(this).find('.nav-tab').removeClass('nav-tab-active');
                $(this).find('.nav-tab[href="'+ hash +'"]').addClass('nav-tab-active');	

                $form.attr('action', form_act + hash);
            }

            // if no active - set first as active
            if(!$(this).find('.nav-tab-active').length) {
                $(this).find('.nav-tab').first().addClass('nav-tab-active');	
            }

            // hide unselected
            $(this).find('.nav-tab').each(function() {
                var id = $(this).attr('href');

                if($(this).hasClass('nav-tab-active')) {
                    sel = id
                }
                else {
                    $(id).hide();
                }
            });

            // scroll to top by default
            $("html, body").animate({scrollTop: 0}, 0);

            // track clicks
            if(sel) {
                $(this).find('.nav-tab').on('click', function(e) {
                    e.preventDefault();
                    if($(this).hasClass('nav-tab-active')) {return false;}

                    var sel_id = $(this).attr('href');
                    window.location.hash = sel_id.replace('#', '');

                    $form.attr('action', form_act + sel_id);

                    // show selected and hide others
                    $(this).parents('.lcwp_settings_tabs').find('.nav-tab').each(function() {
                        var id = $(this).attr('href');

                        if(sel_id == id) {
                            $(this).addClass('nav-tab-active');
                            $(id).show();		
                        }
                        else {
                            $(this).removeClass('nav-tab-active');
                            $(id).hide();	
                        }
                    });
                });
            }
        });


        // sticky tabs on scroll
        let lcwp_sf_sticky_tabs_tout = false;

        const $tabs = $('.lcwp_settings_tabs'),
              tabs_top_pos = Math.round($tabs.offset().top);

        const lcwp_sf_sticky_tabs = function() {
            if(lcwp_sf_sticky_tabs_tout) {
                clearTimeout(lcwp_sf_sticky_tabs_tout);    
            }

            lcwp_sf_sticky_tabs_tout = setTimeout(function() {
                if(document.documentElement.scrollTop > (tabs_top_pos + $tabs.outerHeight(true) + 20)) {
                    $('.lcwp_settings_form').css('margin-top', $tabs.outerHeight(true));
                    $tabs.addClass('lcwp_st_sticky');
                }
                else {
                    $('.lcwp_settings_form').css('margin-top', 0);
                    $tabs.removeClass('lcwp_st_sticky'); 
                }
            }, 10);
        };
        $(window).scroll(function() {
            lcwp_sf_sticky_tabs();
        });
        $(window).resize(function() {
            lcwp_sf_sticky_tabs();    
        });
        lcwp_sf_sticky_tabs(); // on page's show



        // sliders
        new lc_range_n_num('.lcwp_sf_slider_input', {
            unit_width: 17    
        });


        // colorpicker
        $('.lcwp_sf_colpick').each(function() {
            let modes = $(this).data('modes'),
                alpha = (modes && modes.indexOf('alpha') !== -1) ? true : false;

            modes = (modes) ? modes.trim().split(' ') : [];
            modes.push('solid');

            // remove alpha mode
            const index = modes.indexOf('alpha');
            if(index !== -1) {
              modes.splice(index, 1);
            }

            // def colors 
            let def_color = $(this).data('def-color');
            def_color = (def_color.indexOf('gradient') !== -1) ? ['#008080', def_color] : [def_color, 'linear-gradient(90deg, #ffffff 0%, #000000 100%)']; 

            new lc_color_picker('input[name="'+ $(this).attr('name') +'"]', {
                modes           : modes,
                transparency    : alpha,
                no_input_mode   : false,
                wrap_width      : '90%',
                fallback_colors : def_color,
                preview_style   : {
                    input_padding   : 40,
                    side            : 'right',
                    width           : 35,
                },
            });
        });



        // lc switch
        const pc_live_checks = function() {
            lc_switch('.lcwp_sf_check', {
                on_txt      : "<?php echo strtoupper(esc_attr__('yes')) ?>",
                off_txt     : "<?php echo strtoupper(esc_attr__('no')) ?>",   
            });
        };
        pc_live_checks();


        // lc select
        const lcwp_sf_live_select = function() { 

            new lc_select('.lcwp_sf_select', {
                wrap_width : '90%',
                addit_classes : ['lcslt-lcwp'],
            });
        };
        lcwp_sf_live_select();


        // auto-height textarea
        window.lcwp_sf_textAreaAdjust = function(o) {
            o.style.height = "1px";
            o.style.height = (4 + o.scrollHeight)+"px";
        };
        $('.lcwp_sf_textarea').each(function() {
            lcwp_sf_textAreaAdjust(this);    
        });



        //////////////////////////////////////////////////


        // fixed submit position
        const lcwp_sf_fixed_submit = function(btn_selector) {
            const $subj = $(btn_selector);
            if(!$subj.length) {
                return false;
            }

            let clone = $subj.clone().wrap("<div />").parent().html();

            setInterval(function() {

                // if page has scrollers or scroll is far from bottom
                if(($(document).height() > $(window).height()) && ($(document).height() - $(window).height() - $(window).scrollTop()) > 130) {
                    if(!$('.lcwp_settings_fixed_submit').length) {	
                        $subj.after('<div class="lcwp_settings_fixed_submit">'+ clone +'</div>');
                    }
                }
                else {
                    if($('.lcwp_settings_fixed_submit').length) {	
                        $('.lcwp_settings_fixed_submit').remove();
                    }
                }
            }, 50);
        };
        lcwp_sf_fixed_submit('.lcwp_settings_submit');


        //////////////////////////////////////////////////


        // popup message for better visibility
        if($('.lcwp_settings_result').length) {
            const $subj = $('.lcwp_settings_result');

            // if success - simply hide main one
            if($subj.hasClass('updated')) {
                $subj.remove();	
                lc_wp_popup_message('success', '<p>'+ $subj.find('p').html() +'</p>');   
            }

            // show errors but keep them visible on top
            else {
                const pre_heading = (window.location.href.indexOf('lcwp_sf_import') !== -1) ? 
                    `<?php esc_html_e('One or more errors occurred during the import', $ml_key) ?>` : 
                    `<?php esc_html_e('One or more errors occurred', $ml_key) ?>`;
                      
                const error_contents = ($subj.find('ul').length) ? $subj.find('ul')[0].outerHTML : $subj.find('p')[0].innerHTML;
                
                lc_wp_popup_message('error', "<h4><?php esc_html_e('One or more errors occurred', $ml_key) ?>:</h4>" + error_contents);
                $("html, body").animate({scrollTop: 0}, 0);


                // try adding links bringing directly to option lines
                $subj.find('ul li').each(function() {
                    const $err_li = $(this);

                    let subjs = $err_li.text().split(' - ')[0];
                    subjs = subjs.split(',');

                    $.each(subjs, function(i, label) {
                        label = label.toString().trim();

                        $('.lcwp_sf_label label').each(function() {
                            if( $(this).text().trim().toLowerCase() == label.toLowerCase() ) {
                                $err_li.html( 
                                    $err_li.html().replace(label, '<a href="#'+ $(this).parents('tr').first().attr('class') +'" title="<?php esc_attr_e('go to option', $ml_key) ?>" class="lcwp_sf_err_link">'+ label +'</a>')
                                );

                                return false;
                            }
                        });
                    });
                });
            }
            
            // remove eventual url parameters
            history.replaceState(null, null, settings_baseurl);
        }	


        // error-to-option direct search
        $(document).on('click', '.lcwp_sf_err_link', function(e) {
            e.preventDefault();
            const tr_selector = $(this).attr('href').replace('#', ''),
                  label = $('.'+tr_selector +' .lcwp_sf_label').text();

            $('.lcwp_sf_search_wrap input').val(label).trigger('keyup');
        });
    });
    
})(jQuery);   
</script>


<?php
// PC-ACTION - allow extra code printing in settings (for javascript/css)
do_action('pc_settings_extra_code');
?>
