<?php 
dike_lc('lcweb', PC_DIKE_SLUG, true);

global $pc_users, $pc_wp_user;

// editing user?
if(isset($_GET['user'])) {
	$user_id = (int)addslashes($_GET['user']);

	// does user exist?
	$user_data = $pc_users->get_user($user_id, array(
    	'to_get' => array('username', 'surname', 'status', 'insert_date', 'last_access')
	));
	
	if(!$user_data) {
		wp_die('
		<div class="notice notice-error">
			<p>'. __('User not found', 'pc_ml') .'</p>
		</div>');
	}
}
else {
	$user_id = false;	
}


// can access this page?
$cuc_user_id = ($user_id) ? $user_id : 'some'; 
$cuc_edit    = pc_wpuc_static::current_wp_user_can_edit_pc_user($cuc_user_id);
$GLOBALS['pc_ud_cuc_edit'] = $cuc_edit;

if(!$cuc_edit) {
    wp_die('
    <div class="notice notice-error">
        <p>'. __('You are not allowed to access this page', 'pc_ml') .'</p>
    </div>');
}


$GLOBALS['pc_user_dashboard_user_id'] = $user_id;
?>


<div class="wrap pc_user_dashboard_wrap">
	
    <?php $page_title = ($user_id) ? __('Edit') .' '. $user_data['username'] : __('Add PrivateContent User', 'pc_ml'); ?>
    <h1 class="wp-heading-inline pc_user_dashboard_heading pc_page_title">
    	<img src="<?php echo PC_URL ?>/img/pc_page_icon.png" />
		<?php echo $page_title ?>
   	</h1>
	
    
    <?php 
	// status panel
	if($user_id) {
		
		switch((int)$user_data['status']) {
			case 1 : $txt = __('active', 'pc_ml'); break;
			case 2 : $txt = __('disabled', 'pc_ml'); break;
			case 3 : $txt = __('pending', 'pc_ml'); break;
			default: $txt = __('deleted', 'pc_ml'); break;	
		}
	
		echo 
		'<div class="pc_user_dashboard_status_panel">
			<div class="pc_user_dashboard_added_on">
				<div>
					<span>'. __('Added on', 'pc_ml') .'</span>
					<strong>'. $pc_users->data_to_human('insert_date', $user_data['insert_date']) .'</strong>
				</div>
				<div>
					<span>'. __('Last access', 'pc_ml') .'</span>
					<strong>'. strip_tags($pc_users->data_to_human('last_access', $user_data['last_access']), '<time>') .'</strong>
				</div>
			</div>
			<div>
				<span>'. __('User status', 'pc_ml') .'</span>
				<div class="pc_edit_user_status pc_eus_'. $user_data['status'] .'">'. $txt .'</div>
				
				<div class="pc_user_dashboard_edit_status_wrap">';
			
				if($cuc_edit) {
					echo '
					<i class="fas fa-times-circle pc_del_user" title="'. esc_attr__('delete user', 'pc_ml') .'" data-status="0"></i>
					';
					
					if(in_array((int)$user_data['status'], array(2, 3))) {
						echo '<i class="fas fa-check-circle pc_enable_user" aria-hidden="true" title="'. esc_attr__('enable user', 'pc_ml') .'" data-status="1"></i>';
					}
					else {
						echo '<i class="fas fa-minus-circle pc_disable_user" aria-hidden="true" title="'. esc_attr__('disable user', 'pc_ml') .'" data-status="2"></i>';
					}
				}
				
				echo '
				</div>
			</div>
		</div>';
	}

	
	include_once('dashboard_engine.php'); 
	include_once('structure.php'); 
	
    $engine = new pc_user_dashboard_engine($GLOBALS['pc_user_dashboard_tabs'], $GLOBALS['pc_user_dashboard_structure'], $user_id);
    echo $engine->get_code();
    ?>
</div>





<?php // SCRIPTS ?>
<script type="text/javascript">
(function($) { 
    "use strict";     
    
    <?php if($user_id) : ?>
    var page_tit = jQuery('title').text().replace("<?php esc_attr_e('Add User', 'pc_ml') ?>", "<?php esc_attr_e('Edit User', 'pc_ml') ?>");
    $('title').html(page_tit);
    <?php endif; ?>


    $(document).ready(function($) {
        const pc_nonce = '<?php echo wp_create_nonce('lcwp_ajax') ?>';
        let is_acting = false;

        
        // save user's data (create/update)
        $(document).on('click', '.pc_user_dashboard_submit', function(e) {
            e.preventDefault();	
            if(is_acting) {
                return false;
            }

            var $btn = $('.pc_user_dashboard_submit');
            $btn.fadeTo(200, 0.7);

            $('.pc_user_dashboard_errors').remove();
            is_acting = true;

            var data = 
                'action=pc_save_user_dashboard_ajax'+
                '&pc_user_id=<?php echo (int)$user_id; ?>'+
                '&pc_nonce='+ pc_nonce + '&' +
                $('.pc_user_dashboard_form').serialize();

            $.post(ajaxurl, data, function(response) {
                try {
                    const resp = JSON.parse(response);

                    if(resp.response == 'success') {
                        var message = "<?php ($user_id) ? esc_attr_e('User updated successfully!', 'pc_ml') : esc_attr_e('User added successfully!', 'pc_ml') ?>"; 
                        lc_wp_popup_message('success', message);

                        setTimeout(function() { 
                            <?php echo ($user_id) ? 
                                    'window.location.reload();' : 
                                    'window.location.href = window.location.href.replace( window.location.hash, "") + "&user=" + resp.user_id'; 
                            ?>
                        }, 1800);
                    }
                    else { 
                        lc_wp_popup_message('error', resp.text);
                        $('.pc_user_dashboard_heading').after('<div class="error pc_user_dashboard_errors"><p>'+ resp.text +'</p></div>')
                    }
                }
                catch(e) {
                    console.error(e);
                    lc_wp_popup_message('error', "<?php esc_attr_e('Error performing the action', 'pc_ml') ?>");
                }
            })
            .fail(function(e) {
                lc_wp_popup_message('error', "<?php esc_attr_e('Error performing the action', 'pc_ml') ?>");
                console.error(e.responseText);
            })
            .always(function() {
                $btn.fadeTo(200, 1);
                is_acting = false;       
            });

        });


        // form submission through "enter"
        $(document).on("keypress", ".pc_user_dashboard_wrap input", function(e) { 
            if(e.keyCode === 13){
                e.preventDefault();	
                var $trigger = $('.pc_user_dashboard_submit').trigger('click');
                return false;
            }
        });



        // change user status or delete him
        $(document).on('click', '.pc_user_dashboard_edit_status_wrap i', function(e) {
            if(is_acting) {return false;}
            var new_status = parseInt($(this).data('status'), 10);

            if(!new_status) {
                if(!confirm("<?php esc_attr_e('Do you really want to delete this user?', 'pc_ml') ?>")) {
                    return false;	
                }
            }

            var $btn = $(this);
            $btn.fadeTo(200, 0.7);
            is_acting = true;

            var data = {
                action		: 'pc_user_dashboard_change_status',
                pc_user_id	: <?php echo (int)$user_id; ?>,
                status		: new_status,
                pc_nonce	: pc_nonce
            };
            $.post(ajaxurl, data, function(response) {
                if($.trim(response) == 'success') {

                    switch(new_status) {
                        case 0 : var txt = "<?php esc_attr_e('User deleted successfully!', 'pc_ml') ?>"; break; 
                        case 1 : var txt = "<?php esc_attr_e('User enabled successfully!', 'pc_ml') ?>"; break; 
                        case 2 : var txt = "<?php esc_attr_e('User disabled successfully!', 'pc_ml') ?>"; break; 	
                    }

                    lc_wp_popup_message('success', txt);

                    setTimeout(function() {

                        if(!new_status) {
                            window.location.replace("<?php echo admin_url() ?>admin.php?page=pc_user_manage");
                        } else {
                            location.reload();
                        }
                    }, 1800);
                }
                else { 
                    lc_wp_popup_message('error', response);

                    $btn.fadeTo(200, 1);
                    is_acting = false;
                }
            });
        });







        ///////////////////////////////////////////



        // WP user sync
        $(document).on('click', '#pc_sync_with_wp', function(e) {
            e.preventDefault();

            if(is_acting || !confirm("<?php esc_attr_e('A mirror WordPress user will be created. Continue?', 'pc_ml') ?>")) {
                return false;
            }

            var $btn = $(this);
            $btn.fadeTo(200, 0.7);
            is_acting = true;

            var data = {
                action		: 'pc_wp_sync_single_user',
                pc_user_id	: <?php echo (int)$user_id; ?>,
                pc_nonce	: pc_nonce
            };
            $.post(ajaxurl, data, function(response) {
                if($.trim(response) == 'success') {
                    lc_wp_popup_message('success', "<?php esc_attr_e('User synced successfully!', 'pc_ml') ?>");

                    setTimeout(function() {
                        location.reload();
                    }, 1800);
                }
                else { 
                    lc_wp_popup_message('error', response);

                    $btn.fadeTo(200, 1);
                    is_acting = false;
                }
            });
        });



        // WP user detach
        $(document).on('click', '#pc_detach_from_wp', function(e) {
            e.preventDefault();

            if(is_acting || !confirm("<?php esc_attr_e('WARNING: this will delete connected wordpres user and any related content will be lost. Continue?', 'pc_ml') ?>")) {
                return false;
            }

            var $btn = $(this);
            $btn.fadeTo(200, 0.7);
            is_acting = true;

            var data = {
                action		: 'pc_wp_detach_single_user',
                pc_user_id	: <?php echo (int)$user_id; ?>,
                pc_nonce	: pc_nonce
            };
            $.post(ajaxurl, data, function(response) {
                if($.trim(response) == 'success') {
                    lc_wp_popup_message('success', "<?php esc_attr_e('User detached successfully!', 'pc_ml') ?>");

                    setTimeout(function() {
                        location.reload();
                    }, 1800);
                }
                else { 
                    lc_wp_popup_message('error', response);

                    $btn.fadeTo(200, 1);
                    is_acting = false;
                }
            });
        });



        // WP user sync - edit WP fields through lightbox
        $('#pc_wps_wp_fields a').magnificPopup({
            type		: 'iframe',
            mainClass	: 'pc_wps_wp_fields_lb',
            iframe		: {
               markup	: 
               '<div class="mfp-iframe-scaler">'+
                  '<div class="mfp-close"></div>'+
                  '<iframe class="mfp-iframe" frameborder="0" onload="pc_wps_wpf_lb_height(this)" allowfullscreen></iframe>'+
              '</div>'
            },
            modal			: true, 
            closeOnBgClick	: false,
            preloader		: false,  
        });


        window.pc_wps_wpf_lb_height = function(iframe) {
            setTimeout(function() {
                var h = iframe.contentWindow.document.body.scrollHeight + "px";
                $('.pc_wps_wp_fields_lb .mfp-content').height(h);
                $('.pc_wps_wp_fields_lb .mfp-close').show();
            }, 400);
        };



        //////////////////////////////////////////////////



        // replacing $ UI tabs 
        $('.pc_user_dashboard_tabs').each(function() {
            var sel = '';
            var hash = window.location.hash;
            var $form = $(".pc_user_dashboard_form");

            // track URL on opening
            if(hash && $(this).find('.nav-tab[href="'+ hash +'"]').length) {
                $(this).find('.nav-tab').removeClass('nav-tab-active');
                $(this).find('.nav-tab[href="'+ hash +'"]').addClass('nav-tab-active');	
            }

            // if no active - set first as active
            if(!$(this).find('.nav-tab-active').length) {
                $(this).find('.nav-tab').first().addClass('nav-tab-active');	
            }

            // hide unselected
            $(this).find('.nav-tab').each(function() {
                var id = $(this).attr('href');

                if($(this).hasClass('nav-tab-active')) {
                    sel = id
                }
                else {
                    $(id).hide();
                }
            });

            // scroll to top by default
            $("html, body").animate({scrollTop: 0}, 0);

            // track clicks
            if(sel) {
                $(this).find('.nav-tab').on('click', function(e) {
                    e.preventDefault();
                    if($(this).hasClass('nav-tab-active')) {return false;}

                    var sel_id = $(this).attr('href');
                    window.location.hash = sel_id.replace('#', '');

                    // show selected and hide others
                    $(this).parents('.pc_user_dashboard_tabs').find('.nav-tab').each(function() {
                        var id = $(this).attr('href');

                        if(sel_id == id) {
                            $(this).addClass('nav-tab-active');
                            $(id).show();		
                        }
                        else {
                            $(this).removeClass('nav-tab-active');
                            $(id).hide();	
                        }
                    });
                });
            }
       });



       // lc switch
        var pc_live_checks = function() {
            lc_switch('.lcwp_sf_check', {
                on_txt      : "<?php echo strtoupper(esc_attr__('yes')) ?>",
                off_txt     : "<?php echo strtoupper(esc_attr__('no')) ?>",   
            });
        }
        pc_live_checks();



        // lc_select
        var pc_lc_select = function() { 
            new lc_select('.pc_user_dashboard_wrap .pc_lc_select', {
                wrap_width      : '98%',
                addit_classes   : ['lcslt-lcwp'],
                pre_placeh_opt  : true,
            });
        }
        pc_lc_select();




        //////////////////////////////////////////////////




        // fixed submit position
        var pc_fixed_submit = function(btn_selector) {
            var $subj = $(btn_selector);
            if(!$subj.length) {return false;}

            var clone = $subj.clone().wrap("<div />").parent().html();

            setInterval(function() {

                // if page has scrollers or scroll is far from bottom
                if(($(document).height() > $(window).height()) && ($(document).height() - $(window).height() - $(window).scrollTop()) > 130) {
                    if(!$('.pc_user_dashboard_fixed_submit').length) {	
                        $subj.after('<div class="pc_user_dashboard_fixed_submit">'+ clone +'</div>');
                    }
                }
                else {
                    if($('.pc_user_dashboard_fixed_submit').length) {	
                        $('.pc_user_dashboard_fixed_submit').remove();
                    }
                }
            }, 50);
        };
        pc_fixed_submit('.pc_user_dashboard_submit');




        // avoid surname and password fields autopopulation
        setTimeout(function() {
            $('[data-sect-id="main"] input[type=password]').val('');

            <?php if(!$user_id || !isset($user_data['surname']) || (isset($user_data['surname']) && empty($user_data['surname']))) : ?>
                $('[data-sect-id="main"] input[name=surname]').val('');
            <?php endif; ?> 
        }, 300);



        // auto password generator
        $(document).on('click', '.pc_psw_generator', function() {
            const $this  = $(this),
                  $field = $(this).parents('td').first().find('input'); 
            
            let psw = $this.data('psw');
                psw = psw.split('');
                
            for (var i = psw.length - 1; i > 0; i--) {
                let rand = Math.floor(Math.random() * (i + 1));
                [psw[i], psw[rand]] = [psw[rand], psw[i]];
            }

            $field.val( psw.join('') );
            
            // set field as visible
            if($field.attr('type') == 'password') {
                $('.pc_toggle_psw_vis').trigger('click');        
            }
        });
        
        
        
        // password visibility system
        $(document).on('click', '.pc_toggle_psw_vis', function() {
            const $this  = $(this),
                  $field = $(this).parents('td').first().find('input'); 

            if($field.attr('type') == 'password') {
                $field.attr('type', 'text');    
                $this.removeClass('dashicons-visibility').addClass('dashicons-hidden');          
            } 
            else {
                $field.attr('type', 'password');   
                $this.addClass('dashicons-visibility').removeClass('dashicons-hidden');
            }
        });

    });
    
})(jQuery);
</script>



<?php
// PC-ACTION - allow extra code printing in user dashboard (for javascript/css)
do_action('pc_user_dashboard_extra_code');
?>
