<?php 
////////////////////////////////////////////////////
/////////// IF EXPORTING USERS DATA ////////////////
////////////////////////////////////////////////////

// security check
if(!isset($_POST['pc_export_user_data'])) {
    wp_die('<p>Nice try!</p>');
}
if (!isset($_POST['pc_nonce']) || !wp_verify_nonce($_POST['pc_nonce'], 'lcwp_nonce')) {
    wp_die('<p>Cheating?</p>');
};


global $pc_users;
include_once(PC_DIR . '/classes/simple_form_validator.php');		
		
$validator = new simple_fv;
$indexes = array();

$indexes[] = array('index'=>'users_type', 'label'=>__( 'Users type', 'pc_ml' ), 'required'=>true);
$indexes[] = array('index'=>'export_type', 'label'=>__( 'Export type', 'pc_ml' ), 'required'=>true);
$indexes[] = array('index'=>'pc_all_cats', 'label'=>'export all');
$indexes[] = array('index'=>'pc_categories', 'label'=>'Categories');


$validator->formHandle($indexes);
$fdata = $validator->form_val;

if(empty($fdata['pc_all_cats']) && empty($fdata['pc_categories'])) {
	$validator->custom_error[ esc_html__('Exported categories', 'pc_ml') ] = __('Choose at least one option', 'pc_ml');
}
$error = $validator->getErrors();


// error printed in import_export.php
if(!$error) {
    switch($fdata['users_type']) {
        default : 
            $status = false;
            break;
            
        case 'actives' :
            $status = array('1', '3');
            break;
            
        case 'disabled' :
            $status = array('2');
            break;
    }
    
    
	// users query
	$args = array(
		'limit' 	=> -1,
	);
    
    if($status) {
        $args['search'] = array(
            array(
                array('key' => 'status', 'val' => $status, 'operator' => 'IN')
            )
		);    
    }
	
	// in case of specific cats fetching
	if(empty($fdata['pc_all_cats'])) {
		$args['categories'] = (array)$fdata['pc_categories'];
	}
	
    
	$response = $pc_users->export_users($args, $fdata['export_type']);
    if($response !== true) {
        echo '<div class="error pc_imp_exp_mess"><p>'. $response .'</p></div>';        
    }
}	
