<?php
dike_lc('lcweb', PC_DIKE_SLUG, true);

include_once(PC_DIR . '/classes/pc_form_framework.php');	
global $pc_users;

$cuc_edit   = pc_wpuc_static::current_wp_user_can_edit_pc_user('some'); 


//////////////////////////////////////// 
// IMPORT SCRIPT
if(isset($_POST['pc_import_users']) && $cuc_edit) {
	require_once('import_script.php');
}

//////////////////////////////////////
// EXPORT SCRIPT
if(isset($_POST['pc_export_user_data'])) {
	require_once('export_script.php');	
}


?>
<div class="wrap pc_form pc_imp_exp_wrap">  
    <?php 
    echo '<h2 class="pc_page_title">' . __( 'Import & Export Users', 'pc_ml' ) . "</h2>";
    
    if(isset($error) && !empty($error)) {
        echo '<div class="error pc_imp_exp_mess"><p>'. $error .'</p></div>';
    }
    if(isset($success) && !empty($success)) {
        echo $success;
    }
    
    if(!get_option('pg_min_role_tmu')) : ?> 
		<h2><?php _e('Import Users', 'pc_ml') ?></h2>
		<div class="pc_warn pc_error"><p><?php _e("Please save plugin settings first", 'pc_ml') ?></p></div>
    	<p>&nbsp;</p>
    
    <?php 
    elseif(!pc_wpuc_static::current_wp_user_can_edit_pc_user('some')) : 
    ?>

    
    <?php 
    else : 
    ?> 
		<h2><?php _e('Import Users', 'pc_ml') ?></h2>

        <?php
        if(!ini_get('allow_url_fopen')) :
            echo '<div class="pc_warn pc_error"><p>' . __("Your server doesn't give the permissions to manage files. Please enable the fopen() function", 'pc_ml') .'</p></div>
			<p>&nbsp;</p>';
        
		else :
        ?>
        <form method="post" class="form-wrap" action="<?php echo str_replace( '%7E', '~', $_SERVER['REQUEST_URI']); ?>" enctype="multipart/form-data">
            <table class="widefat pc_table">
                <tbody>
                    <tr>
                        <td class="pc_label_td"><?php _e('CSV file', 'pc_ml'); ?></td>
                        <td class="pc_field_td">
                            <input type="file" name="pc_imp_file" value="" accept=".csv" />
                        </td>
                        <td><span class="info"><?php _e('Select a valid CSV file containing users', 'pc_ml'); ?></span></td>
                    </tr>
                    <tr>
                        <td class="pc_label_td"><?php _e("Fields Delimiter", 'pc_ml'); ?></td>
                        <td class="pc_field_td">
                            <?php $val = (isset($fdata['pc_imp_separator']) && $fdata['pc_imp_separator']) ? $fdata['pc_imp_separator'] : ';'; ?>
                            <input type="text" name="pc_imp_separator" value="<?php echo esc_attr($val); ?>" maxlength="1" autocomplete="off" />
                        </td>
                        <td><span class="info"><?php _e('CSV fields delimiter (normally is ";")', 'pc_ml'); ?></span></td>
                    </tr>
                    <tr>
                        <td class="pc_label_td"><?php _e("Enable private page?", 'pc_ml'); ?></td>
                        <td class="pc_field_td">
                            <?php $checked = (isset($fdata['pc_imp_pvt_page']) && $fdata['pc_imp_pvt_page']) ? 'checked="checked"' : ''; ?>
                            <input type="checkbox" name="pc_imp_pvt_page" value="1" <?php echo $checked; ?> class="pc_lc_switch" autocomplete="off" />
                        </td>
                        <td><span class="info"><?php _e('If checked, enable private page for imported users', 'pc_ml'); ?></span></td>
                    </tr>
                    <tr>
                        <td class="pc_label_td"><?php _e("Default categories for imported users", 'pc_ml'); ?></td>
                        <td class="pc_field_td">
                            <select name="pc_imp_cat[]" class="pc_lc_select" data-placeholder="<?php esc_attr_e("Select categories", 'pc_ml'); ?> .." multiple="multiple" autocomplete="off">
                                <?php
                                // all user categories
                                $user_categories = get_terms('pg_user_categories', 'orderby=name&hide_empty=0');
    
                                foreach ($user_categories as $ucat) {
                                    if(!get_option('pg_tu_can_edit_user_cats') && PC_CURR_USER_MANAGEABLE_CATS != 'any' && !in_array($ucat->term_id, (array)PC_CURR_USER_MANAGEABLE_CATS)) {
                                        continue;    
                                    }
                                    
                                    $sel = (isset($fdata['pc_imp_cat']) && in_array($ucat->term_id, (array)$fdata['pc_imp_cat'])) ? 'selected="selected"' : '';
                                    echo '<option value="'. $ucat->term_id .'" '.$sel.'>'. esc_html($ucat->name) .'</option>';
                                }
                                ?>
                            </select> 
                        </td>
                        <td><span class="info"><?php _e("Choose at least a category that will be assigned to imported users", 'pc_ml'); ?></span></td>
                    </tr>
                    <tr>
                        <td class="pc_label_td"><?php _e("Ignore first row?", 'pc_ml'); ?></td>
                        <td class="pc_field_td">
                            <?php $checked = (isset($fdata['pc_imp_ignore_first']) && $fdata['pc_imp_ignore_first']) ? 'checked="checked"' : ''; ?>
                            <input type="checkbox" name="pc_imp_ignore_first" value="1" <?php echo $checked; ?> class="pc_lc_switch" autocomplete="off" />
                        </td>
                        <td><span class="info"><?php _e("If checked, ignore first CSV row (normally used for headings)", 'pc_ml'); ?></span></td>
                    </tr>
                    <tr>
                        <td class="pc_label_td"><?php _e("Abort if errors are found?", 'pc_ml'); ?></td>
                        <td class="pc_field_td">
                            <?php $checked = (isset($fdata['pc_imp_error_stop']) && $fdata['pc_imp_error_stop']) ? 'checked="checked"' : ''; ?>
                            <input type="checkbox" name="pc_imp_error_stop" value="1" <?php echo $checked; ?> class="pc_lc_switch" autocomplete="off" />
                        </td>
                        <td><span class="info"><?php _e("If checked, abort import process whether an error is found", 'pc_ml'); ?></span></td>
                    </tr>
                    <tr>
                        <td class="pc_label_td"><?php _e("Abort if duplicated are found?", 'pc_ml'); ?></td>
                        <td class="pc_field_td">
                            <?php $checked = (isset($fdata['pc_imp_existing_stop']) && $fdata['pc_imp_existing_stop']) ? 'checked="checked"' : ''; ?>
                            <input type="checkbox" name="pc_imp_existing_stop" value="1" <?php echo $checked; ?> class="pc_lc_switch" autocomplete="off" />
                        </td>
                        <td><span class="info">
                            <?php $masm = (defined('PCMA_DIR') && get_option('pcma_mv_duplicates')) ? ' '. __('or e-mail', 'pc_ml') : ''; ?>
                            <?php echo __('If checked, abort import process whether a duplicated username', 'pc_ml') . $masm .' '. __('is found', 'pc_ml'); ?>
                            </span></td>
                    </tr>

                    <?php
                    // WP user sync - if is active add option to abort in case of no sync
                    if($pc_users->wp_user_sync) :
                    ?>
                    <tr>
                        <td class="pc_label_td"><?php _e("Abort if wordpress sync fails?", 'pc_ml'); ?></td>
                        <td class="pc_field_td">
                            <?php $checked = (isset($fdata['pc_wps_error_stop']) && $fdata['pc_wps_error_stop']) ? 'checked="checked"' : ''; ?>
                            <input type="checkbox" name="pc_wps_error_stop" value="1" <?php echo $checked; ?> class="pc_lc_switch" autocomplete="off" />
                        </td>
                        <td><span class="info"><?php _e("If checked, abort import process whether a mirrored user already exists", 'pc_ml'); ?></span></td>
                    </tr>
                    <?php
                    endif;

                    // PC-ACTION - add fields in import form - must comply with table code
                    do_action('pc_import_form');
                    ?>
                </tbody>
            </table>
            
            
            <?php
            //// custom fields importing
            // PC-FILTER - allow custom fields to be imported - passes an array, use only registered field indexes
            $cust_fields = apply_filters('pc_import_custom_fields', array());
            
            if(count((array)$cust_fields)) :
                $f_fw = new pc_form;
                ?>
                <table class="widefat pc_table pc_cfi_table">
                    <thead>
                        <tr>  
                            <th colspan="3">
                                <strong><?php _e('Custom fields import', 'pc_ml') ?></strong>  
                                <button id="pc_cfi_btn" class="button-secondary" type="button">
                                    <span class="dashicons dashicons-plus"></span> <?php _e('add field', 'pc_ml') ?>
                                </button>
                            </th>
                        </tr>  
                    </thead>
                    <tbody>
                    <?php
                        if(isset($_POST['pc_cfi_import'])) {
                            $col_num = 7;

                            foreach($_POST['pc_cfi_import'] as $cf) {
                                echo '
                                <tr>
                                  <td><span class="pc_del_field dashicons dashicons-no-alt"></span></td>
                                  <td>'. __('column', 'pc_ml').' <span class="pc_cfi_col_num">'. $col_num .'<span></td>
                                  <td>
                                    <select name="pc_cfi_import[]" class="pc_lc_select" data-placeholder="'. esc_attr__('Select field', 'pc_ml') .'..">';

                                        foreach($cust_fields as $index) {
                                            if(!isset($f_fw->fields[$index]) || in_array($index, $pc_users->fixed_fields)) {
                                                continue;
                                            }

                                            echo '<option value="'. esc_attr($index) .'" '. selected($cf, $index, false).'>'. esc_html($f_fw->fields[$index]['label']) .'</option>';	
                                        }

                                    echo '
                                    </select>
                                  </td>	
                                </tr>';	

                                $col_num++;
                            }
                        }
                    ?>
                    </tbody>
                </table>
                
                <script type="text/javascript">
                (function($) { 
                    "use strict";   
                    
                    var init_col = 6; // start from 6+1 column - first 6 are for standard fields

                    var fields_dd = 
                    '<select name="pc_cfi_import[]" class="pc_lc_select" data-placeholder="<?php esc_attr_e('Select field', 'pc_ml') ?>..">' +
                        <?php
                        foreach($cust_fields as $index) {
                            if(!isset($f_fw->fields[$index]) || in_array($index, $pc_users->fixed_fields)) {
                                continue;
                            }
                            echo '\'<option value="'.$index.'">'. str_replace("'", "\'", $f_fw->fields[$index]['label']) .'</option>\'+';	
                        }
                        ?>
                    '</select>';

                    // add
                    $(document).on('click', '#pc_cfi_btn', function(){
                        var col_count = init_col + $('.pc_cfi_table tbody tr').length;

                        $('.pc_cfi_table tbody').append(
                        '<tr>' +
                            '<td><span class="pc_del_field dashicons dashicons-no-alt"></span></td>' +	
                            '<td><?php esc_attr_e('column', PCUD_ML) ?> <span class="pc_cfi_col_num">'+ (col_count + 1) +'<span></td>' +
                            '<td>'+ fields_dd +'</td>' +	
                        '</tr>');

                        pc_ie_lc_select();
                    });

                    // remove
                    $(document).on('click', '.pc_cfi_table .pc_del_field', function(){
                        $(this).parents('tr').slideUp(200, function() {
                            $(this).remove();
                        });

                        // recalculate column number
                        setTimeout(function() {
                            var col_count = init_col;
                            $('.pc_cfi_table td .pc_cfi_col_num').each(function() {
                                col_count++;
                                $(this).text(col_count);
                            });
                        }, 250);
                    });
                    
                })(jQuery);
                </script>
                <?php		
            endif; // end if custom fields import
            ?>
            
            <br/>
            <input type="hidden" name="pc_nonce" value="<?php echo wp_create_nonce('lcwp_nonce') ?>" /> 
            <input type="submit" name="pc_import_users" value="<?php esc_attr_e('Import', 'pc_ml') ?>" class="button-primary" />  
        </form>
        
        <br/><br/><hr/><br/>
        
        <?php endif; // end allow_url_fopen check ?>
	<?php endif; // end user role check ?>
    
    
          
    
    <!-- ****************************************************************************** -->
    
    
    
    
    <?php if($pc_users->wp_user_sync) : ?>
    
    <h2><?php _e('Import WordPress Users', 'pc_ml') ?></h2>
    
    <form method="post" class="form-wrap">
    	<table class="widefat pc_table">
          <tr>
            <td class="pc_label_td">
				<?php _e("Which roles to import?", 'pc_ml'); ?>
            </td>
            <td class="pc_field_td">
            	<select name="pc_wp_imp_roles[]" class="pc_lc_select" data-placeholder="<?php esc_attr_e('Select an option', 'pc_ml') ?> .." multiple="multiple" autocomplete="off">
                	<?php
					foreach(get_editable_roles() as $role_id => $data) { 
						
						if(!in_array($role_id, array('administrator', 'pvtcontent', 'editor')) ) {
							echo '<option value="'. $role_id .'">'. esc_html($data['name']) .'</option>';
						}
					}
					?>
                </select>
            </td>
          </tr>
          <tr>
             <td class="pc_label_td">
			 	<?php _e("Default categories for imported users", 'pc_ml'); ?>
             </td>
             <td class="pc_field_td">
                <select name="pc_wp_imp_cat[]" class="pc_lc_select" data-placeholder="<?php esc_attr_e("Select a category", 'pc_ml'); ?> .." multiple="multiple" autocomplete="off">
                    <?php
                    // all user categories
                    $user_categories = get_terms('pg_user_categories', 'orderby=name&hide_empty=0');
                    
                    foreach ($user_categories as $ucat) {
                        if(!get_option('pg_tu_can_edit_user_cats') && PC_CURR_USER_MANAGEABLE_CATS != 'any' && !in_array($ucat->term_id, (array)PC_CURR_USER_MANAGEABLE_CATS)) {
                            continue;    
                        }
                        
                    	echo '<option value="'. $ucat->term_id .'">'. esc_html($ucat->name) .'</option>';
                    }
                    ?>
                </select> 
             </td>
             <td><span class="info"><?php _e("Choose at least a category that will be assigned to imported users", 'pc_ml'); ?></span></td>
           </tr>
        </table>
      
      	<div id="pc_wp_imp_resp"></div>
      
        <br/>
      	<div id="pc_wp_imp_btn">
       		<input type="button" name="pc_wp_import_btn" value="<?php esc_attr_e('Import', 'pc_ml') ?>" class="button-primary" /> 
            <span></span>
        </div> 
    </form>
    
    
	<br/><br/><hr/><br/>

    
	<script type="text/javascript">
    (function($) {
        "use strict"; 
        
		let pc_wps_is_syncing = false;
		
		// sync
		$(document).on('click', '[name=pc_wp_import_btn]', function(e) {
			var cats = $('[name="pc_wp_imp_cat[]"]').serialize();
			var roles = $('[name="pc_wp_imp_roles[]"]').serialize();
			
			if(!cats || !roles || pc_wps_is_syncing) {
                return false;
            }

			if(confirm("<?php esc_attr_e("Do you really want to turn every user belonging to these roles into a PrivateContent user? Won't be possible to have them back in future", 'pc_ml') ?>")) {
				pc_wps_is_syncing = true;
				
				$('#pc_wp_imp_resp').empty();
				$('#pc_wp_imp_btn span').html('<i class="pc_spinner"></i>');
									
				var data = 'action=wp_to_pc_bulk_user_sync&pc_nonce=<?php echo wp_create_nonce('lcwp_ajax') ?>&'+ cats +'&'+ roles;
				$.post(ajaxurl, data, function(response) {
					
					$('#pc_wp_imp_resp').html(response);
					$('#pc_wp_imp_btn span').empty();
					
					pc_wps_is_syncing = false;	
				});	
			}
		});	     
    })(jQuery);
	</script>	

    <?php endif; ?>
    
    
    
    
    <!-- ****************************************************************************** -->
    
      
    
    <h2><?php _e('Export Users', 'pc_ml') ?></h2>
    
    <form method="post" id="pc_export_form" class="form-wrap" action="<?php echo str_replace( '%7E', '~', $_SERVER['REQUEST_URI']); ?>">
        <table class="widefat pc_table">
            <tbody>
                <tr>
                    <td class="pc_label_td"><?php _e("Users type", 'pc_ml'); ?></td>
                    <td class="pc_field_td">
                        <select name="users_type" class="pc_lc_select" data-placeholder="<?php esc_attr_e('Select an option', 'pc_ml') ?> .." autocomplete="off">
                            <option value="all"><?php _e('Any', 'pc_ml') ?></option>
                            <option value="actives"><?php _e('Only actives', 'pc_ml') ?></option>
                            <option value="disabled"><?php _e('Only disabled', 'pc_ml') ?></option>
                        </select>
                    </td>
                    <td></td>  
                </tr>
                <tr>
                    <td class="pc_label_td"><?php _e("Export as", 'pc_ml') ?></td>
                    <td class="pc_field_td">
                        <select name="export_type" class="pc_lc_select" data-placeholder="<?php esc_attr_e('Select an option', 'pc_ml') ?> .." autocomplete="off">
                            <option value="excel"><?php _e('Excel', 'pc_ml') ?> (.xls)</option>
                            <option value="csv">CSV</option>
                        </select>
                    </td>
                    <td></td>  
                </tr>

                <?php
                // PC-ACTION - add fields in export form - must comply with table code
                do_action('pc_export_form');
                ?>

                <tr>
                    <td colspan="3"></td>
                </tr>
                <tr>
                    <td class="pc_label_td" rowspan="2"><?php _e("Categories", 'pc_ml'); ?></td>
                    <td class="pc_field_td" >
                        <?php if(PC_CURR_USER_MANAGEABLE_CATS == 'any') : ?>
                        <label class="pc_exp_cat_label"><?php _e('Export every user?', 'pc_ml') ?></label>
                        <input type="checkbox" name="pc_all_cats" id="pc_export_all_cat" value="all" class="pc_lc_switch" autocomplete="off" />
                        <?php endif; ?>
                    </td>
                    <td></td>
                </tr>
                <tr>
                    <td class="pc_cat_lists" colspan="2">
                        <select name="pc_categories[]" class="pc_lc_select" data-placeholder="<?php esc_attr_e('Select categories', 'pc_ml') ?> .." multiple="multiple" autocomplete="off">
                            <?php
    $user_categories = get_terms('pg_user_categories', 'orderby=name&hide_empty=0');
                            foreach ($user_categories as $ucat) {
                                if(!get_option('pg_tu_can_edit_user_cats') && PC_CURR_USER_MANAGEABLE_CATS != 'any' && !in_array($ucat->term_id, (array)PC_CURR_USER_MANAGEABLE_CATS)) {
                                    continue;    
                                }
                                
                                echo '<option value="'. (int)$ucat->term_id .'">'. esc_html($ucat->name) .'</option>'; 
                            }
                            ?>
                        </select>
                    </td>
                </tr>
            </tbody>
        </table>

        <br/>
        <input type="hidden" name="pc_nonce" value="<?php echo wp_create_nonce('lcwp_nonce') ?>" /> 
        <input type="submit" name="pc_export_user_data" value="<?php esc_attr_e('Export', 'pc_ml') ?>" class="button-primary" />  
    </form>
</div>  





<?php // SCRIPTS ?>
<script type="text/javascript" >
(function($) { 
    "use strict";   
    
    $(document).ready(function() {

        // remove any message on export submit
        $(document).on('click', 'input[name="pc_export_user_data"]', function() {
            $('.pc_imp_exp_mess').remove();
        });
        
        
        
        // lc switch
        lc_switch('.pc_imp_exp_wrap .pc_lc_switch', {
            on_txt      : "<?php echo strtoupper(esc_attr__('yes')) ?>",
            off_txt     : "<?php echo strtoupper(esc_attr__('no')) ?>",   
        });

        
        // select/deselect all
        $(document).on('lcs-statuschange', '#pc_export_all_cat', function(){
            if( $(this).is(':checked') ) {
                $('.pc_cat_lists').slideUp();	
            }
            else {$('.pc_cat_lists').slideDown();}
        });
        

        // lc_select
        window.pc_ie_lc_select = function() {
            new lc_select('.pc_imp_exp_wrap .pc_lc_select', {
                wrap_width : '100%',
                addit_classes : ['lcslt-lcwp'],
            });
        };
        pc_ie_lc_select();
    });
})(jQuery);
</script>


