<?php 
////////////////////////////////////////////////////
/////////// IF IMPORING USERS //////////////////////
////////////////////////////////////////////////////

// security check
if(!isset($_POST['pc_import_users'])) {die('Nice try!');}
if (!isset($_POST['pc_nonce']) || !wp_verify_nonce($_POST['pc_nonce'], 'lcwp_nonce')) {die('<p>Cheating?</p>');};
	
include_once(PC_DIR . '/classes/simple_form_validator.php');
include_once(PC_DIR . '/classes/pc_form_framework.php');
global $wpdb, $pc_users, $pc_wp_user;
	
$f_fw = new pc_form;
$validator = new simple_fv;
$indexes = array();

$indexes[] = array('index'=>'pc_imp_separator', 'label'=>__("Field Delimiter", 'pc_ml'), 'required'=>true, 'max_len'=>1);
$indexes[] = array('index'=>'pc_imp_pvt_page', 'label'=>"Enable Pvt Page");
$indexes[] = array('index'=>'pc_imp_cat', 'label'=>__('Category', 'pc_ml'), 'required'=>true);
$indexes[] = array('index'=>'pc_imp_ignore_first', 'label'=>"Ignore first row");
$indexes[] = array('index'=>'pc_imp_auto_psw', 'label'=>"Ignore first row");
$indexes[] = array('index'=>'pc_imp_error_stop', 'label'=>"Stop if errors found");
$indexes[] = array('index'=>'pc_imp_existing_stop', 'label'=>"Stop if duplicated found");
$indexes[] = array('index'=>'pc_wps_error_stop', 'label'=>"Stop if wp sync fails");
$indexes[] = array('index'=>'pc_cfi_import', 'label'=>"Custom fields");

$validator->formHandle($indexes);
$fdata = $validator->form_val;


// more compatible upload validation
if(!isset($_FILES["pc_imp_file"]) || !isset($_FILES["pc_imp_file"]["tmp_name"]) || trim($_FILES["pc_imp_file"]["tmp_name"]) == '') {
	$validator->custom_error[ esc_html__("CSV file", 'pc_ml') ] = __("is missing", 'pc_ml');
}
if( pc_static::stringToExt(strtolower($_FILES["pc_imp_file"]["name"])) != '.csv'){
	$validator->custom_error[ esc_html__("CSV file", 'pc_ml') ] = __("invalid file uploaded", 'pc_ml');
}

$error = $validator->getErrors();

// error printed in import_export.php
if(!$error) {
	mb_internal_encoding('utf-8');
	$tmp_file = $_FILES["pc_imp_file"]["tmp_name"];

	// manage CSV and save data
	$imp_err = array();
	$imp_username_exist = array();
	$imp_mail_exist = array();
	$img_wps_exists = array();
	$imp_data = array();
	
	if (($handle = fopen($tmp_file, "r")) !== false) {
        
		$row = 1;
		$fields = 6; // mandatory number of fields (name, surname, username, psw, mail, tel)
        $reduce_index = (!$fdata['pc_imp_auto_psw']) ? 0 : 1;
		
		while (($data = fgetcsv($handle, 0, $fdata['pc_imp_separator'])) !== FALSE) {
			if(!$fdata['pc_imp_ignore_first'] || ($fdata['pc_imp_ignore_first'] && $row > 1)) {
			
				$pcud_additional_f = (isset($_POST['pc_cfi_import'])) ? count($_POST['pc_cfi_import']) : 0;
				if(count($data) != ($fields - $reduce_index + $pcud_additional_f)) {  
					$error = __('Row '.$row.' has a wrong number of values', 'pc_ml');
					break;
				}
                
                $data = array_map("utf8_encode", $data);
                
				// validate data
				if(
                    empty($data[2]) || 
                    (empty($data[3]) && !$fdata['pc_imp_auto_psw']) || 
                    (empty($data[4]) && !filter_var(trim($data[4]), FILTER_VALIDATE_EMAIL))
                ) {
					$imp_err[] = $row;
				}
				else {
					
					//// check username and eventually mail unicity
					// mail check
					$mail_ck_query = ($f_fw->mail_is_required && !empty($data[4]) && $fdata['pc_imp_existing_stop']) ? "OR email = '".addslashes(trim($data[4]))."'" : '';  
					$existing_user = $wpdb->get_row( 
						"SELECT id, username, email FROM ". PC_USERS_TABLE ." WHERE (username = '". addslashes(trim($data[2])) ."' ". $mail_ck_query .") LIMIT 1" 
					);
					if($existing_user) {
						if(trim($data[2]) == $existing_user->username) {
                            $imp_username_exist[] = $row;
                        }
						if(trim($data[4]) == $existing_user->email && $f_fw->mail_is_required) {
                            $imp_mail_exist[] = $row;
                        }
					}

					// add user to list
					else {
						$wp_sync = $pc_users->wp_user_sync;
						
						// WP user sync check
						if($fdata['pc_wps_error_stop'] && trim($data[4]) && $pc_wp_user->wp_user_exists(trim($data[2]), trim($data[4])) ) {
							$img_wps_exists[] = $row;
						}
						
						// clean data
						$data = pc_static::strip_opts($data);
			
						$imp_data[$row]['name'] = trim($data[0]);
						$imp_data[$row]['surname'] = trim($data[1]);
						$imp_data[$row]['username'] = trim($data[2]);
                        
                        if(!$fdata['pc_imp_auto_psw']) {
                            $imp_data[$row]['psw'] = $data[3];
                            $imp_data[$row]['check_psw'] = $data[3];
                        }
                        else {
                            $psw = wp_generate_password(10, true);
					
                            while($f_fw->check_psw_strength($psw) !== true) {
                                $psw = wp_generate_password(10, true);	
                            }
                            
                            $imp_data[$row]['psw'] = $psw;
                            $imp_data[$row]['check_psw'] = $psw; 
                        }
                        
						$imp_data[$row]['email'] = trim($data[ (4 - $reduce_index) ]);
						$imp_data[$row]['tel'] = trim($data[ (5 - $reduce_index) ]);
						$imp_data[$row]['disable_pvt_page'] = (!$fdata['pc_imp_pvt_page']) ? 1 : 0;
						$imp_data[$row]['categories'] = (array)$fdata['pc_imp_cat'];
						
						// custom fields import
						if(is_array($fdata['pc_cfi_import']) && count($fdata['pc_cfi_import'])) {
							$index = 6 - $reduce_index;
							
							foreach($fdata['pc_cfi_import'] as $field) {
								$imp_data[$row][$field] = $data[$index];
								$index++;	
							}
						}	
					}
				}
			}
			$row++;
		}
		fclose($handle);
		
		
		// if CSV file management is ok
		if(!$error) {
			
			// if there are errors and abort import 
			if($fdata['pc_imp_error_stop'] && count($imp_err)) {
				$error = __('Missing values have been found in rows','pc_ml').': '. implode(', ', $imp_err);	
			}
			elseif($fdata['pc_imp_existing_stop'] && count($imp_username_exist)) {
				$error = __('Users with existing username have been found at rows','pc_ml').': '. implode(', ', $imp_username_exist);	
			}
			elseif($fdata['pc_imp_existing_stop'] && count($imp_mail_exist)) {
				$error = __('Users with existing e-mail have been found at rows','pc_ml').': '. implode(', ', $imp_mail_exist);	
			}
			elseif($fdata['pc_wps_error_stop'] && count($img_wps_exists)) {
				$error = __('Wordpress mirror users already exist at rows','pc_ml').': '. implode(', ', $img_wps_exists);	
			}


			// import
			else {
				include_once(PC_DIR .'/classes/pc_form_framework.php');	
				$f_fw = new pc_form;
				$pc_fields = $f_fw->fields;
				
				$imported_list = array(); // users ID array for action
				foreach($imp_data as $user_row => $u_data) {
					
					// track array fields and insert an affective array (explode with comma)
					foreach($u_data as $fid => $fval) {
						if(
							isset($pc_fields[$fid]) && ($pc_fields[$fid]['type'] == 'checkbox' || 
							($pc_fields[$fid]['type'] == 'select' && isset($pc_fields[$fid]['multiple']) && $pc_fields[$fid]['multiple'])) ) 
						{
							if(!is_array($u_data[$fid])) {
								$u_data[$fid] = explode('|', str_replace(array('|', '|'), '|', $u_data[$fid]) );
							}
						}
					}
					
                    
                    // PC-FILTER - allow import data filter for each user - passes also flags to know whether to stop if errors are found
                    $username = $u_data['username'];
                    $u_data = apply_filters('pc_import_data', $u_data, $fdata['pc_imp_error_stop'], $fdata['pc_imp_existing_stop']);
                    if(!is_array($u_data)) {
                        $error = esc_html__('Error importing user', 'pc_ml') .' "'. $username .'": '. $u_data;
						break;        
                    }
                    
                    
					// insert
					$user_id = $pc_users->insert_user($u_data, $status = 1, $allow_wp_sync_fail = true);
					
					if(empty($user_id)) {
						$error = esc_html__('Error importing user', 'pc_ml') .' "'. $username .'": '. $pc_users->validation_errors;
						break;
					}
					else {
						$imported_list[$user_id] = $u_data;
					}	
				}
				
				// PC-ACTION - users have been imported - passes an array containing user ids and related imported data
				if(!empty($imported_list)) {
					do_action('pc_imported_users', $imported_list);
				}
			}
			
			////////////////////////////////////////
			// success message
			if(!$error) {
				$success = '
				<div class="updated pc_imp_exp_mess"><p><strong>'. __('Import completed succesfully', 'pc_ml') .'</strong><br/><br/>
					'. __('Users added', 'pc_ml') .': '.count($imp_data);

					if(count($imp_err))	{ 
						$success .= '<br/>'. __('Missing values', 'pc_ml') .': '. count($imp_err) .' ('. __('at rows', 'pc_ml') .': '.implode(',', $imp_err).')';
					}
					
					if(count($imp_username_exist))	{ 
						$success .= '<br/>'.count($imp_username_exist).' '. __('existing users', 'pc_ml').' ('. __('at rows', 'pc_ml') .': '.implode(',', $imp_username_exist).')';
					}
					
					if(count($imp_mail_exist))	{ 
						$success .= '<br/>'.count($imp_mail_exist).' '. __('duplicated e-mails', 'pc_ml').' ('. __('at rows', 'pc_ml') .': '.implode(',', $imp_mail_exist).')';
					}
					
					if(count($img_wps_exists))	{ 
						$success .= '<br/>'.count($img_wps_exists).' '. __('existing WP mirror users', 'pc_ml').' ('. __('at rows', 'pc_ml') .': '.implode(',', $img_wps_exists).')';
					}

				$success .= '</p></div>';	
			}
		}
		
	} 
	else {
        // error printed in import_export.php
        $error = __('Temporary file cannot be read', 'pc_ml');
    }
}
