<?php

/////////////////////////////////////////////////
////// BULK NO-PLAN USERS ASSOCIATION ///////////
/////////////////////////////////////////////////

function pcpp_bulk_no_plan_assoc() {
	if(!$GLOBALS['pcpp_enabled'] || !isset($_POST['pcpp_nonce']) || !wp_verify_nonce($_POST['pcpp_nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
	global $pc_users, $pc_meta, $pcpp_subscr;
	
	$plans = $pcpp_subscr->get_plans(false);
	$plan_id = trim(addslashes($_POST['plan_id'])); 
	if(!isset($plans[$plan_id])) {
        wp_die( __('Wrong or missing plan ID', PCPP_ML) );
    }

	$use_trial = (int)$_POST['use_trial'];
	
	// query all users without a plan
	$args = array(
		'to_get'      => array('id', 'name', 'surname', 'username', 'email', 'tel', 'wp_user_id'),
		'limit'       => -1,
		'search'      => array(
			array('key'=>'pcpp_plan', 'operator'=>'NOT IN', 'val'=>array_keys($plans))
		)
	);
	$users_data = $pc_users->get_users($args);
	
	
	foreach($users_data as $ud) {
	
		// create order
		$order_obj = $pcpp_subscr->create_order($ud['id'], $plan_id);	
        $order_id = $pcpp_subscr->order_obj_to_id($order_obj);
        
		if(!$order_id) {
			continue;
		}
		
		// set new main order and manage access metas
		pcpp_user_subscr_static::manag_orders($ud['id'], $order_id, 'add');
		
		// eventually setup trial
		if($use_trial) {
			pcpp_user_subscr_static::setup_trial_meta($ud['id'], $plan_id);
		}
	}

	wp_die('success');	
}
add_action('wp_ajax_pcpp_bulk_no_plan_assoc', 'pcpp_bulk_no_plan_assoc');





///////////////////////////////////////////////////////////////////





/////////////////////////////////////////////////
////// ADD USER - ASSOCIATE USER WITH NO PLAN ///
/////////////////////////////////////////////////

function pcpp_no_plan_associate() {
    if(!$GLOBALS['pcpp_enabled'] || !isset($_POST['pcpp_nonce']) || !wp_verify_nonce($_POST['pcpp_nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
	global $pc_meta, $pcpp_subscr;
	
	$user_id = trim(addslashes($_POST['user_id'])); 
	if(!filter_var($user_id, FILTER_VALIDATE_INT)) {
        wp_die( __('Error processing the action', PCPP_ML) );
    }
	
	$plans = $pcpp_subscr->get_plans(false);
	$plan_id = trim(addslashes($_POST['plan_id'])); 
	if(!isset($plans[$plan_id])) {
        wp_die( __('Wrong or missing plan ID', PCPP_ML) );
    }

	$use_trial = (int)$_POST['use_trial'];
	
	// create order
	$order_obj = $pcpp_subscr->create_order($user_id, $plan_id);	
    $order_id = $pcpp_subscr->order_obj_to_id($order_obj);
    
	if(!$order_id) {
		wp_die( __('Error creating new order', PCPP_ML) );
	}
	
	// set new main order and manage access metas
	pcpp_user_subscr_static::manag_orders($user_id, $order_id, 'add');
	
	// eventually setup trial
	if($use_trial) {
		pcpp_user_subscr_static::setup_trial_meta($user_id, $plan_id);
	}

	wp_die('success');	
}
add_action('wp_ajax_pcpp_no_plan_associate', 'pcpp_no_plan_associate');





///////////////////////////////////////////////////////////////////





/////////////////////////////////////////////////
////// EDIT USER - CHANGE USER PLAN /////////////
/////////////////////////////////////////////////

function pcpp_change_user_plan() {
	global $pc_meta, $pcpp_subscr;
    
    if(!$GLOBALS['pcpp_enabled'] || !isset($_POST['pcpp_nonce']) || !wp_verify_nonce($_POST['pcpp_nonce'], 'lcwp_ajax')) {
        wp_die( json_encode(array(
			'status' => 'error', 
			'error' => 'cheating?'
		)));	
    }
	
	if(!(int)$_POST['user_id']) {
        wp_die( json_encode(array(
			'status' => 'error', 
			'error' => 'wrong user ID'
		)));	
    }
    $user_id = (int)$_POST['user_id'];
	
    
    // clean any unpaid duration extension
    pcpp_user_subscr_static::clean_pending_expir_ext_order($user_id);
    
	
	// dissociates from plans
	if($_POST['plan_id'] == 'no_plan') {
		$pc_meta->delete_meta($user_id, 'pcpp_plan');	
		$pc_meta->delete_meta($user_id, 'pcpp_subscr_status');	
		$pc_meta->delete_meta($user_id, 'pcpp_subscr_end');	
		
		wp_die( json_encode(array(
            'status' => 'success', 
        )));
	}
	
	
	// normal plan change
	$plan_id = trim(addslashes($_POST['plan_id'])); 
	if(!filter_var($user_id, FILTER_VALIDATE_INT)) {
        $error = __('Wrong or missing plan ID', PCPP_ML);
    }
	
	// check among valid plans
	$plans = $pcpp_subscr->get_plans(false);
	if(!isset($plans[$plan_id])) {
        $error = __('Wrong or missing plan ID', PCPP_ML);
    }

	// responses
	if(isset($error)) {
		wp_die( json_encode(array(
			'status' => 'error', 
			'error' => $error
		)));	
	}
	else {
		// set old order to cancelled if not paid  
		$curr_order = $pc_meta->get_meta($user_id, 'pcpp_active_order');
		if($curr_order) {
			$pcpp_subscr->cancel_order($curr_order, __('Manual subscription plan change'));	
		}

		// create new order for new plan
		$order_obj = $pcpp_subscr->create_order($user_id, $plan_id);
        $new_order_id = $pcpp_subscr->order_obj_to_id($order_obj);
	
		// set new main order and manage access metas
		pcpp_user_subscr_static::manag_orders($user_id, $new_order_id, 'add');
		
		// remove expired plan's notification flag
		$pc_meta->delete_meta($user_id, 'pcpp_expire_subscr_notified');
		
		
		wp_die( json_encode(array(
			'status' => 'success'
		)));		
	}	
}
add_action('wp_ajax_pcpp_change_user_plan', 'pcpp_change_user_plan');






/////////////////////////////////////////////////////
/// EDIT USER - CHANGE USER TRIAL EXPIRATION DATE ///
/////////////////////////////////////////////////////

function pcpp_change_user_trial_exp_date() {
	if(!$GLOBALS['pcpp_enabled'] || !isset($_POST['pcpp_nonce']) || !wp_verify_nonce($_POST['pcpp_nonce'], 'lcwp_ajax')) {
        $error = 'Cheating?';
    }
	include_once(PC_DIR .'/classes/simple_form_validator.php');
	global $pc_meta, $pcpp_subscr;
	
	$validator = new simple_fv;	
	$indexes = array();
	$indexes[] = array('index'=>'user_id', 'label'=>__('User ID', PCPP_ML), 'type'=>'int', 'required'=>true);
	$indexes[] = array('index'=>'date', 'label'=>__('Expiration date', PCPP_ML), 'type'=>'iso_date', 'required'=>true);
	$indexes[] = array('index'=>'time', 'label'=>__('Expiration time', PCPP_ML), 'required'=>true);
	
	$validator->formHandle($indexes);
	$fdata = $validator->form_val;
	$errors = $validator->getErrors();
	
	// calculate ending and check it's not before now
	$ending = strtotime($fdata['date'] .' '. $fdata['time'] .':00');
	if((int)$ending <= (int)current_time('timestamp')) {
		$errors .= __('Chosen date is already expired', PCPP_ML);	
	}
	
	// responses
	if(!empty($errors)) {
		wp_die( json_encode(array(
			'status' => 'error', 
			'error' => $errors
		)));	
	}
	else {
		
		// save meta
		$pc_meta->update_meta($fdata['user_id'], 'pcpp_trial_ending', $ending);
	
		wp_die( json_encode(array(
			'status' 		=> 'success', 
			'ending_html'	=> pcpp_static::time_to_date_html($ending)
		)));		
	}	
}
add_action('wp_ajax_pcpp_change_user_trial_exp_date', 'pcpp_change_user_trial_exp_date');






/////////////////////////////////////////////////////
/// EDIT USER - CHANGE USER SUBSCR EXPIRATION DATE //
/////////////////////////////////////////////////////

function pcpp_change_user_plan_exp_date() {
	if(!$GLOBALS['pcpp_enabled'] || !isset($_POST['pcpp_nonce']) || !wp_verify_nonce($_POST['pcpp_nonce'], 'lcwp_ajax')) {
        $error = 'Cheating?';
    }
	include_once(PC_DIR .'/classes/simple_form_validator.php');
	global $pc_meta, $pcpp_subscr;
	
	$validator = new simple_fv;	
	$indexes = array();
	$indexes[] = array('index'=>'user_id', 'label'=>__('User ID', PCPP_ML), 'type'=>'int', 'required'=>true);
	$indexes[] = array('index'=>'date', 'label'=>__('Expiration date', PCPP_ML), 'type'=>'iso_date');
	$indexes[] = array('index'=>'time', 'label'=>__('Expiration time', PCPP_ML), 'required'=>true);
	$indexes[] = array('index'=>'unlimited', 'label'=>__('unlimited plan?', PCPP_ML), 'type'=>'int', 'required'=>true);
	
	$validator->formHandle($indexes);
	$fdata = $validator->form_val;
	$errors = $validator->getErrors();
	
	// or unlimited or valid date must be specified
	if(empty($errors)) {
		if(empty($fdata['unlimited']) && empty($fdata['date'])) {
			$errors = __('Specify a valid date or set it to unlimited', PCPP_ML);	
		}
	}
	
	// calculate ending and check it's not before now
	$ending = (empty($fdata['unlimited'])) ? strtotime($fdata['date'] .' '. $fdata['time'] .':00') : 'unlimited';
	if($ending != 'unlimited' && (int)$ending <= (int)current_time('timestamp')) {
		$errors .= __('Chosen date is already expired', PCPP_ML);	
	}
	
	// responses
	if(!empty($errors)) {
		wp_die( json_encode(array(
			'status' => 'error', 
			'error' => $errors
		)));	
	}
	else {
		
		// save meta
		$pc_meta->update_meta($fdata['user_id'], 'pcpp_subscr_end', $ending);
	
		// remove expired plan's notification flag
		$pc_meta->delete_meta($fdata['user_id'], 'pcpp_expire_subscr_notified');
	
	
		wp_die( json_encode(array(
			'status' 		=> 'success', 
			'ending_html'	=> pcpp_static::time_to_date_html($ending)
		)));		
	}	
}
add_action('wp_ajax_pcpp_change_user_plan_exp_date', 'pcpp_change_user_plan_exp_date');






/////////////////////////////////////////////////
////// EDIT USER - DELETE ORDER /////////////////
/////////////////////////////////////////////////

function pcpp_del_user_order() {
	if(!$GLOBALS['pcpp_enabled'] || !isset($_POST['pcpp_nonce']) || !wp_verify_nonce($_POST['pcpp_nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
	global $pc_meta, $pcpp_subscr;
	
	$user_id = (int)$_POST['user_id']; 
	if(!$user_id) {
        $error =  __('Error processing the action', PCPP_ML);
    }
	
	$order_id = (int)$_POST['order_id']; 
	if(!$order_id) {
        wp_die( __('Missing order ID', PCPP_ML) );
    }

	pcpp_user_subscr_static::manag_orders($user_id, $order_id, 'remove'); 
	wp_delete_post($order_id, true);
    
    wp_die('success');	
}
add_action('wp_ajax_pcpp_del_user_order', 'pcpp_del_user_order');






/////////////////////////////////////////////////
////// EDIT USER - STOP TRIAL PERIOD ////////////
/////////////////////////////////////////////////

function pcpp_stop_trial_period() {
	if(!$GLOBALS['pcpp_enabled'] || !isset($_POST['pcpp_nonce']) || !wp_verify_nonce($_POST['pcpp_nonce'], 'lcwp_ajax')) {
        wp_die('Cheating?');
    }
	global $pc_meta, $pcpp_subscr;
	
	$user_id = (int)$_POST['user_id']; 
	if(!$user_id) {
        $error =  __('Error processing the action', PCPP_ML);
    }
	
	$pc_meta->update_meta($user_id, 'pcpp_subscr_status', 'unpaid');	
    $pc_meta->delete_meta($user_id, 'pcpp_trial_ending');	
    
    wp_die('success');	
}
add_action('wp_ajax_pcpp_stop_trial_period', 'pcpp_stop_trial_period');