<?php
// PRIVATECONTENT INTEGRATIONS - ADMIN SIDE


//// ADMIN USER DASHBOARD BLOCK
// new user - box to set user subscription
// old user - box to associate plan
// pcpp user - summarize pcpp data and allow edit


// tab contents
function pcpp_user_dashboard_block_hook($sections, $user_id) {
	if(!$GLOBALS['pcpp_enabled']) {
        return $sections;
    }
	global $pc_meta;
    
    // know whether user has got an associated plan
    $user_has_plan = false;
    if($user_id) {
        $user_has_plan = $pc_meta->get_meta($user_id, 'pcpp_plan');    
    }
    
	return 
	$sections + array(
		'pcpp' => array(
			'name'		=> 'Premium Plans add-on - '. __('Subscription Details', PCPP_ML),
			'classes'	=> ($user_has_plan) ? 'pc_ud_fullw_block pcpp_ud_block' : 'pc_ud_2_cols_form pcpp_ud_block',
			'callback' 	=> 'pcpp_user_dashboard_block'
		)
	);	
}
add_filter('pc_user_dashboard_main_tab_sections', 'pcpp_user_dashboard_block_hook', 10, 2);



function pcpp_user_dashboard_block($user_id) {
	dike_lc('lcweb', PCPP_DIKE_SLUG, true);
    
    if(!$GLOBALS['pcpp_enabled']) {
        return false;
    }
	global $pc_users, $pc_meta, $pcpp_subscr;
		
		
	/*** NEW USER ***/
	if(empty($user_id)) { 
		?>
        <div class="pc_wps_warn" id="pcpp_no_plan_associate_wrap">
            <table class="widefat pcpp_udb_new_user">
                <tbody>
                    <tr>
                        <td>
                            <label><?php _e("Select user subscription's plan", PCPP_ML) ?></label>

                            <select name="pcpp_plan" class="pc_lc_select" data-placeholder="<?php esc_attr_e('Select a plan', PCPP_ML) ?> .." autocomplete="off">
                                <option value="no_plan"><?php esc_html_e("No plan associated", PCPP_ML) ?></option>

                                <?php
                                foreach($pcpp_subscr->get_plans(false) as $plan_id => $plan_name) {
                                    $to_match = (isset($_POST['pcpp_plan']) && $_POST['pcpp_plan']) ? $_POST['pcpp_plan'] : get_option('pcpp_default_plan', 0);

                                    echo '<option value="'. (int)$plan_id .'">'. esc_html($plan_name . pcpp_static::dd_plan_details($plan_id)) .'</option>';	
                                }
                                ?>
                            </select>
                        </td>
                    </tr>

                    <?php if($pcpp_subscr->is_trial_enabled()) : ?>
                        <tr>
                            <td>
                                <label>
                                    <?php $ckd = (isset($_POST['pcpp_apply_trial']) && $_POST['pcpp_apply_trial']) ? 'checked="checked"' : ''; ?>
                                    <input type="checkbox" name="pcpp_apply_trial" value="1" <?php echo $ckd ?> autocomplete="off" /> 

                                    <?php _e('Apply trial period?', PCPP_ML) ?> (<?php echo $pcpp_subscr->trial_duration.' '.pcpp_static::sing_plur_switch($pcpp_subscr->trial_dur_type, $pcpp_subscr->trial_duration); ?>)
                                </label>
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        <?php
	}
	
	
	/*** EXISTING USER ***/
	else {
		// prior user subscription check
		pcpp_user_subscr_static::check_subscr_expir($user_id);
		
		// get pcpp data
		$fields = array('pcpp_plan', 'pcpp_subscr_end', 'pcpp_subscr_status', 'pcpp_trial_ending', 'pcpp_active_order', 'pcpp_orders', 'pcpp_recurr_subscr');
		$ud = $pc_users->get_user($user_id, array('to_get' => $fields));

        
		//// user hasn't got plan 
		if(empty($ud['pcpp_plan'])) {
            echo '
			<div class="pc_warn pc_wps_warn pc_warning">
				<p>
					'. __("User doesn't have any plan associated", PCPP_ML) .'
					
					<button class="button-secondary" id="pcpp_no_plan_associate">
						'. __('Assign plan', PCPP_ML) .'
					</button>
				</p>

				<div id="pcpp_no_plan_associate_wrap" class="pc_ud_2_cols_form pc_displaynone">

					<table class="widefat pcpp_udb_new_user">
				        <tbody>
                            <tr>
				                <td>
                                    <label>'. __('Select plan', PCPP_ML) .'</label>
                                    <select name="pcpp_plan" class="pc_lc_select" data-placeholder="'. esc_attr__('Select a plan', PCPP_ML) .'.." autocomplete="off">';

                                        foreach($pcpp_subscr->get_plans(false) as $plan_id => $plan_name) {
                                            echo '<option value="'. (int)$plan_id .'">'. esc_html($plan_name . pcpp_static::dd_plan_details($plan_id)) .'</option>';	
                                        }

                                        echo '		
								    </select>
				                </td>
                                <td>
                                    <input type="button" name="pcpp_udb_assign_btn" value="'. esc_attr__('Assign', PCPP_ML) .'" class="button-secondary pcpp_udb_assign_btn" />
                                </td>
                            </tr>';
						
                            if($pcpp_subscr->is_trial_enabled()) {
                                $ckd = (isset($_POST['pcpp_apply_trial']) && $_POST['pcpp_apply_trial']) ? 'checked="checked"' : '';
                                
                                echo '
                                <tr>
                                    <td>
                                        <label>
                                            <input type="checkbox" name="pcpp_apply_trial" value="1" '. $ckd .' autocomplete="off" /> 
                                            '. __('Apply trial period?', PCPP_ML) .' ('. $pcpp_subscr->trial_duration.' '.pcpp_static::sing_plur_switch($pcpp_subscr->trial_dur_type, $pcpp_subscr->trial_duration) .') 
                                        </label>
                                    </td>
                                    <td></td>
                                </tr>';
                            }
            
                        echo '
                        </tbody>
                    </table>
                </div>
			</div>';
			
			?>
			<script type="text/javascript">
            (function($) { 
                "use strict"; 
                
                var pcpp_is_acting = false;

                
                // assign plan
                $(document).on('click', '.pcpp_udb_assign_btn', function(e) {
                    e.preventDefault();
                    if(pcpp_is_acting) {
                        return false;
                    }

                    pcpp_is_acting = true;
                    var $btn = $(this);
                    $btn.fadeTo(200, 0.7);

                    // trial period bool
                    if($('input[name="pcpp_apply_trial"]').length) {
                        var use_trial = ($('input[name="pcpp_apply_trial"]').is(':checked')) ? 1 : 0;
                    } else {
                        var use_trial = 0;
                    }

                    var data = {
                        action: 'pcpp_no_plan_associate',
                        user_id: <?php echo (int)$user_id ?>,
                        plan_id: $('#pcpp_no_plan_associate_wrap select').val(),
                        use_trial: use_trial, 
                        pcpp_nonce: '<?php echo wp_create_nonce('lcwp_ajax') ?>'
                    };
                    $.post(ajaxurl, data, function(response) {	
                        if($.trim(response) == 'success') {
                            lc_wp_popup_message('success', "<?php esc_attr_e('Plan successfully associated', PCPP_ML) ?>!");

                            setTimeout(function() {
                                window.location.reload();
                            }, 1800);	
                        }
                        else {
                            lc_wp_popup_message('error', response);
                            $btn.fadeTo(200, 1);
                        }
                    })
                    .fail(function(e) {
                        if(e.status) {
                            console.error(e);

                            lc_wp_popup_message('error', "<?php esc_html_e('Error associating the plan', PCPP_ML) ?>");
                            $btn.fadeTo(200, 1);
                        }
                    })
                    .always(function() {
                        pcpp_is_acting = false;
                    });	
                });


                // show selector
                $('#pcpp_no_plan_associate').on('click', function(e) {
                    e.preventDefault();

                    $('#pcpp_no_plan_associate_wrap').slideDown();
                    $(this).parent().slideUp();
                });
                
            })(jQuery); 
			</script>
			<?php
		}
		
		
		
		//// user has plan - management
		else {
            $is_woo_subscr = (!empty($ud['pcpp_recurr_subscr'])) ? true : false;
            $woo_subscr_obj = ($is_woo_subscr) ? wcs_get_subscription($ud['pcpp_recurr_subscr']) : false;
            
            // user MUST NOT be desynced if has woo subscr
            if($is_woo_subscr) {
                echo '<style type="text/css">#pc_detach_from_wp {display: none !important;}</style>';    
            }
            
            
            // recheck expiration date if is marked as active or inherit
            $orig_subscr_status = $ud['pcpp_subscr_status'];
            if(in_array($ud['pcpp_subscr_status'], array('active', 'inherit'))) {
                $ud['pcpp_subscr_status'] = pcpp_user_subscr_static::check_subscr_expir($user_id);	
            }
            
            $user_may_access = pcpp_user_subscr_static::may_access($user_id);

            $exp_date_visibility = ($user_may_access) ? '' : 'pcpp_hide_exp_date'; 
			$plans_list = $pcpp_subscr->get_plans(false);
            
            $plan_title = get_the_title($ud['pcpp_plan']);
            if(empty($plan_title)) {
                $plan_title = '<em>['. __('plan not found', PCPP_ML) .']</em>';        
            }
            
            
			// trial expiration date block
			if($ud['pcpp_subscr_status'] == 'trial') {
				$teb = '
				<td id="pcpp_trial_exp_wrap">
					<h4>'. __('Trial expiration date', PCPP_ML) .' 
                        <a href="javascript:void(0)" class="dashicons dashicons-edit" title="'. esc_attr__('change trial expiration date', PCPP_ML) .'"></a>
                    </h4>
                    
                    <p>
                        '. pcpp_static::edit_exp_date_code($ud['pcpp_trial_ending']) .'
                        <input type="button" class="button-primary" id="pcpp_edit_trial_exp_btn" value="'. esc_attr__('Apply', PCPP_ML) .'" />
                        <input type="button" class="button-secondary pcpp_cancel" value="'. esc_attr__('cancel', PCPP_ML) .'" />
                    </p>
					
                    <span>'. pcpp_static::time_to_date_html($ud['pcpp_trial_ending']) .'</span>
				</td>';
				$tr_class = 'pcpp_eud_is_trial';
			} 
			else {
				$teb = '<td class="pc_displaynone"></td>';
				$tr_class = '';
			}
            
            
            // plan extension unpaid (inherit status) - show the theoretical expiration date
            if($orig_subscr_status == 'inherit') {
                $pde_ed = '
                <td id="pcpp_pending_dur_ext_exp_date">
					<h4><span class="dashicons dashicons-warning"></span> '. __('Pending duration extension order', PCPP_ML) .'</h4>
					<span>'. __('Completing the order, user subscription will expire the', PCPP_ML) .' <strong>'. pcpp_static::time_to_date_html($ud['pcpp_subscr_end']) .'</strong></span>
				</td>';  
                
                $exp_date_visibility = 'pcpp_hide_exp_date';
            }
            else {
                $pde_ed = '<td class="pc_displaynone"></td>';     
            }
            
			echo  '
			<table class="widefat pcpp_user_dashboard_table">
				<tr id="pcpp_aut_first_row" class="'. $tr_class .'">
					<td id="pcpp_edit_plan_wrap">
						<h4>'. __('Current plan', PCPP_ML) .' <a href="javascript:void(0)" class="dashicons dashicons-edit" title="'. esc_attr__('change plan', PCPP_ML) .'"></a></h4>
						<p>
							<select name="pcpp_edit_plan" id="pcpp_edit_plan" autocomplete="off" data-curr-plan="'. esc_attr($ud['pcpp_plan']) .'">
								<option value="no_plan">'. esc_html__("Dissociates from plans", PCPP_ML) .'</option>';
								
								foreach($plans_list as $plan_id => $plan_name) {
									echo '<option value="'. (int)$plan_id .'" '. selected($ud['pcpp_plan'], $plan_id, false) .'>'. esc_html($plan_name . pcpp_static::dd_plan_details($plan_id)) .'</option>'; 
								}
								
							echo '
							</select>
							<input type="button" class="button-primary" id="pcpp_edit_plan_btn" value="'. esc_attr__('Apply', PCPP_ML) .'" />
							<input type="button" class="button-secondary pcpp_cancel" value="'. esc_attr__('cancel', PCPP_ML) .'" />
						</p>
						<span>'. $plan_title .'</span>
					</td>
					<td id="pcpp_edit_status_wrap">
						<h4>'. __('Subscription status', PCPP_ML) .' ';
                        
                            if($ud['pcpp_subscr_status'] != 'trial') {
                                $edit_status_url_id = ($is_woo_subscr) ? $ud['pcpp_recurr_subscr'] : $ud['pcpp_active_order'];
                                echo '
                                <a href="'. admin_url('post.php?post='. $edit_status_url_id .'&action=edit') .'" target="_blank" class="dashicons dashicons-edit" title="'. esc_attr__('manage status', PCPP_ML) .'"></a>';
                            }
                           
                        echo '        
                        </h4>
						<span id="pcpp_eus_'. $ud['pcpp_subscr_status'] .'" class="pc_edit_user_status">'. pcpp_static::subscr_statuses($ud['pcpp_subscr_status']) .'</span>';
            
                        if($is_woo_subscr && in_array($ud['pcpp_subscr_status'], array('active', 'unpaid'))) {
                            echo '<span class="pc_edit_user_status pcpp_recurr_pay_status" target="_blank">'. __('Recurring payment', PCPP_ML) .'</span>';
                        }
                        if($ud['pcpp_subscr_status'] == 'trial') {
                            echo '<a href="javascript:void(0)" class="pcpp_stop_user_trial dashicons dashicons-dismiss" title="'. esc_attr__('stop trial period', PCPP_ML) .'"></a>';
                        }
            
                    echo '
					</td>
                    
					'. $teb .'
                    
					<td id="pcpp_edit_exp_wrap" class="'. $exp_date_visibility .'">';

                        if(empty($exp_date_visibility)) {
                            if(!$is_woo_subscr) {
                                echo '
                                <h4>'. __('Expiration date', PCPP_ML) .' <a href="javascript:void(0)" class="dashicons dashicons-edit" title="'. esc_attr__('change expiration date', PCPP_ML) .'"></a></h4>
                                <p>
                                    '. pcpp_static::edit_exp_date_code($ud['pcpp_subscr_end']) .'
                                    <input type="button" class="button-primary" id="pcpp_edit_exp_btn" value="'. esc_attr__('Apply', PCPP_ML) .'" />
                                    <input type="button" class="button-secondary pcpp_cancel" value="'. esc_attr__('cancel', PCPP_ML) .'" />

                                    <em id="pcpp_unl_plan_check"><input type="checkbox" '. checked($ud['pcpp_subscr_end'], 'unlimited', false) .' value="1" autocomplete="off" /> '. __('Unlimited Plan', PCPP_ML) .'</em>
                                </p>
                                <span>'. pcpp_static::time_to_date_html($ud['pcpp_subscr_end']) .'</span>';
                            }
                            else {
                                $due_date = get_date_from_gmt( $woo_subscr_obj->calculate_date('next_payment'));
                                $due_date = pcpp_static::time_to_date_html(strtotime($due_date), true); 

                                echo '
                                <h4>'. __('Next due date', PCPP_ML) .' <a href="'. admin_url('post.php?post='. $ud['pcpp_recurr_subscr'] .'&action=edit') .'" target="_blank" class="dashicons dashicons-edit" title="'. esc_attr__('manage due date', PCPP_ML) .'"></a></h4>

                                <span>'. pcpp_woo_subscr_static::next_due_date($ud['pcpp_recurr_subscr']) .'</span>';        
                            }
                        }
					
                    echo '
                    </td>
                    
                    
                    '. $pde_ed .' 
				</tr>
				<tr>	
					<td colspan="5" id="pcpp_user_orders_list">';
			
					if(empty($ud['pcpp_orders'])) {
						echo '<span>'. __("User doesn't have subscription orders yet", PCPP_ML) .'</span>';	
					}
					else {
						echo '
						<a href="javascript:void(0)" id="pcpp_toggle_orders_history">
							<span class="dashicons dashicons-arrow-down"></span> 
							'. __('Show orders history', PCPP_ML) .'
						</a>
						
						<table class="widefat pc_table pc_add_user pc_displaynone" id="pcpp_orders_history">
						  <thead>
						  	<tr>
								<th></th>
								<th>'. __('Order ID', PCPP_ML) .'</th>
								<th>'. __('Submission date', PCPP_ML) .'</th>
								<th>'. __('Related Plan', PCPP_ML) .'</th>
								<th>'. __('Amount', PCPP_ML) .'</th>
								<th>'. __('Order Status', PCPP_ML) .'</th>
							</tr>
						  </thead>
                          <tbody>
							';
						
						$a = 0;
						foreach(array_reverse($ud['pcpp_orders']) as $order_id) {
                            
							// check if exists - otherwise remove
							if(get_post_status($order_id) === false) {
								pcpp_user_subscr_static::manag_orders($user_id, $order_id, 'remove');
								continue;
							}
							$date = get_the_date(get_option('date_format'), $order_id);
                            $date_title = esc_attr(get_the_date(get_option('date_format') .' - '. get_option('time_format'), $order_id));
                            
							$is_act_order_class = (!$a) ? 'pcpp_user_act_order' : ''; 
                            $del_block = '
                            <td>
                                <span class="pcpp_del_order pc_del_field dashicons dashicons-no-alt '. $is_act_order_class .'" title="'. esc_attr__('delete order', PCPP_ML) .'" data-id="'. $order_id .'"></span>
                            </td>';
							
							// WPML & Polylang compatibility - plan name 
							if(!isset($plans_list[ $pcpp_subscr->get_order_plan_id($order_id) ])) { 
								$ol_plan_name = (isset($plans_list[ pcpp_static::wpml_get_trans_id($pcpp_subscr->get_order_plan_id($order_id)) ])) ?
                                    $plans_list[ pcpp_static::wpml_get_trans_id($pcpp_subscr->get_order_plan_id($order_id)) ] :
                                    '<em>['. __('plan not found', PCPP_ML) .']</em>';
							} else {
								$ol_plan_name =	$plans_list[ $pcpp_subscr->get_order_plan_id($order_id) ];
							}
                            
                            // is expiration extension tag
                            $is_expir_ext = ($pcpp_subscr->is_plan_expir_ext_order($order_id)) ? ' <em>('. __('duration extension', PCPP_ML) .')</em>' : '';
                            
                            // linked to woo subscription tag
                            $rel_woo_subscr = '';

                            if(pcpp_woo_subscr_static::order_belongs_to_subscr($order_id)) {
                                $rel_woo_subscr = pcpp_woo_subscr_static::get_order_subscr($order_id);
                                
                                if($rel_woo_subscr) {
                                    $rel_woo_subscr = ' <em>(<a href="'. admin_url('post.php?post='. $rel_woo_subscr->get_id() .'&action=edit') .'">'. __('subscription', PCPP_ML) .' #'. $rel_woo_subscr->get_id() .'</a>)</em>';        
                                }
                                else {
                                    $rel_woo_subscr = ' <em>('. __('subscription not found', PCPP_ML) .')</em>';    
                                }
                            }
                            
							echo '
							<tr>
								'. $del_block .'
								<td><a href="'.admin_url( 'post.php?post='.$order_id.'&action=edit').'" target="_blank">#'.$order_id.'</a></td>
								<td title="'. $date_title .'">'. $date .'</td>
								<td>'. $ol_plan_name . $is_expir_ext . $rel_woo_subscr .'</td>
								<td>'. pcpp_static::get_order_amount($order_id) .'</td>
								<td>'. pcpp_static::get_order_ecomm_status($order_id) .'</td>
							</tr>'; 
							
							$a++;
						}
						
						?>
                          </tbody>
						</table>
					<?php 
					} 
					?>
						
					<script type="text/javascript">
                    (function($) { 
                        "use strict";     
                        
                        let pcpp_is_acting = false;

                        
                        // stop trial period
                        $('.pcpp_stop_user_trial').on('click', function() {
                            if(pcpp_is_acting) {
                                return false;
                            }

                            if(confirm("<?php esc_attr_e("Do you really want to stop the user trial period?", PCPP_ML) ?>")) {
                                pcpp_is_acting = true;

                                var data = {
                                    action: 'pcpp_stop_trial_period',
                                    user_id: <?php echo (int)$user_id ?>,
                                    pcpp_nonce: '<?php echo wp_create_nonce('lcwp_ajax') ?>'
                                };
                                $.post(ajaxurl, data, function(response) {
                                    var resp = $.trim(response);

                                    if(resp != 'success') {
                                        pcpp_is_acting = false;
                                        lc_wp_popup_message('error', resp);
                                    }
                                    else {
                                        window.location.reload();
                                    }
                                })
                                .fail(function(e) {
                                    if(e.status) {
                                        console.error(e);
                                        
                                        lc_wp_popup_message('error', "<?php esc_html_e('Error stopping the trial period', PCPP_ML) ?>");
                                    }
                                })
                                .always(function() {
                                    pcpp_is_acting = false;
                                });	
                            }
                        });
                        
                        
                        
                        // change plan
                        $('#pcpp_edit_plan_btn').on('click', function() {
                            var $subj = $(this).parents('td');
                            var val = $('#pcpp_edit_plan').val();

                            if(pcpp_is_acting || val == $('#pcpp_edit_plan').data('curr-plan')) {
                                return false;
                            }
                            
                            const confirm_mess = (val == 'no_plan') ?
                                `<?php esc_attr_e("Do you really want to detach user from subscription plans?", PCPP_ML) ?>` :
                                `<?php esc_attr_e("Do you really want to change subscription plan? A new order will be created", PCPP_ML) ?>`;

                            if(confirm(confirm_mess)) {
                                pcpp_is_acting = true;
                                $subj.addClass('pcpp_eud_is_acting');

                                var data = {
                                    action: 'pcpp_change_user_plan',
                                    user_id: <?php echo (int)$user_id ?>,
                                    plan_id: val,
                                    pcpp_nonce: '<?php echo wp_create_nonce('lcwp_ajax') ?>'
                                };
                                $.post(ajaxurl, data, function(response) {
                                    try {
                                        var resp = $.parseJSON(response);

                                        if(resp.status == 'error') {
                                            lc_wp_popup_message('error', resp.error);
                                        }
                                        else {
                                            lc_wp_popup_message('success', "<?php esc_attr_e('Plan successfully changed!', PCPP_ML) ?>");
                                            window.location.reload(); // refresh page to see changes
                                        }
                                    }
                                    catch(e) {
                                        console.error(e);
                                        lc_wp_popup_message('error', "<?php esc_attr_e('Error changing the plan', PCPP_ML) ?>");    
                                    }
                                })
                                .fail(function(e) {
                                    if(e.status) {
                                        console.error(e);

                                        lc_wp_popup_message('error', "<?php esc_html_e('Error changing the plan', PCPP_ML) ?>");
                                    }
                                })
                                .always(function() {
                                    $subj.removeClass('pcpp_eud_is_acting');
                                    pcpp_is_acting = false;
                                });	
                            }
                        });

                        
                        
                        // change trial period expiration date
                        $('#pcpp_edit_trial_exp_btn').on('click', function() {
                            var $subj = $(this).parents('td');
                            if(pcpp_is_acting) {
                                return false;
                            }

                            if(confirm("<?php esc_attr_e("Do you really want to change trial period expiration?", PCPP_ML) ?>")) {
                                pcpp_is_acting = true;
                                $subj.addClass('pcpp_eud_is_acting');

                                var data = {
                                    action: 'pcpp_change_user_trial_exp_date',
                                    user_id: <?php echo (int)$user_id ?>,
                                    date: $('#pcpp_edit_exp_date').val(),
                                    time: $('#pcpp_edit_exp_hour').val() +':'+ $('#pcpp_edit_exp_min').val(),
                                    pcpp_nonce: '<?php echo wp_create_nonce('lcwp_ajax') ?>'
                                };
                                $.post(ajaxurl, data, function(response) {
                                    try{
                                        var resp = $.parseJSON(response);

                                        if(resp.status == 'error') {
                                            lc_wp_popup_message('error', resp.error);	
                                        }
                                        else {
                                            $subj.find('span').html( resp.ending_html );
                                            $subj.find('input.pcpp_cancel').trigger('click');
                                        }
                                    }
                                    catch(e) {
                                        console.error(e);
                                        lc_wp_popup_message('error', "<?php esc_attr_e('Error changing trial expiration date', PCPP_ML) ?>");
                                    }
                                })
                                .fail(function(e) {
                                    if(e.status) {
                                        console.error(e);
                                        lc_wp_popup_message('error', "<?php esc_html_e('Error changing trial expiration date', PCPP_ML) ?>");
                                    }
                                })
                                .always(function() {
                                    $subj.removeClass('pcpp_eud_is_acting');
                                    pcpp_is_acting = false;
                                });	
                            }
                        });
                        
                        
                        
                        // change plan expiration date
                        $('#pcpp_edit_exp_btn').on('click', function() {
                            var $subj = $(this).parents('td');
                            if(pcpp_is_acting) {
                                return false;
                            }

                            if(confirm("<?php esc_attr_e("Do you really want to change subscription expiration date?", PCPP_ML) ?>")) {
                                pcpp_is_acting = true;
                                $subj.addClass('pcpp_eud_is_acting');

                                var data = {
                                    action: 'pcpp_change_user_plan_exp_date',
                                    user_id: <?php echo (int)$user_id ?>,
                                    date: $('#pcpp_edit_exp_date').val(),
                                    time: $('#pcpp_edit_exp_hour').val() +':'+ $('#pcpp_edit_exp_min').val(),
                                    unlimited: ($('#pcpp_unl_plan_check input').is(':checked')) ? 1 : 0,
                                    pcpp_nonce: '<?php echo wp_create_nonce('lcwp_ajax') ?>'
                                };
                                $.post(ajaxurl, data, function(response) {
                                    try{
                                        var resp = $.parseJSON(response);

                                        if(resp.status == 'error') {
                                            lc_wp_popup_message('error', resp.error);	
                                        }
                                        else {
                                            $subj.find('span').html( resp.ending_html );
                                            $subj.find('input.pcpp_cancel').trigger('click');
                                        }
                                    }
                                    catch(e) {
                                        console.error(e);
                                        lc_wp_popup_message('error', "<?php esc_attr_e('Error changing the plan expiration date', PCPP_ML) ?>");
                                    }
                                })
                                .fail(function(e) {
                                    if(e.status) {
                                        console.error(e);
                                        lc_wp_popup_message('error', "<?php esc_html_e('Error changing the plan expiration date', PCPP_ML) ?>");
                                    }
                                })
                                .always(function() {
                                    $subj.removeClass('pcpp_eud_is_acting');
                                    pcpp_is_acting = false;
                                });	
                            }
                        });

                        
                        
                        // unlimited plan toggle - disable normal fields
                        $(document).on('input', '#pcpp_unl_plan_check input', function() {
                            const $wrap     = $(this).parents('p').first(),
                                  $fields   = $wrap.find('#pcpp_edit_exp_date, #pcpp_edit_exp_hour, #pcpp_edit_exp_min');
                            
                            (this.checked) ? $fields.prop('disabled', 'disabled') : $fields.removeAttr('disabled');
                        });
                        
                        

                        // delete user order
                        $(document).on('click', '.pcpp_del_order', function() {
                            if(pcpp_is_acting || !confirm("<?php esc_attr_e("Do you really want to delete this order?", PCPP_ML) ?>")) {
                                return false;
                            }
                                
                            const $subj         = $(this),
                                  is_act_order  = ($subj.hasClass('pcpp_user_act_order')) ? true : false,
                                  $wrap         = $subj.parents('tr').first();
                            
                            pcpp_is_acting = true;

                            $subj.hide(); 
                            $subj.after('<span class="pc_spinner pc_spinner_inline pcpp_duo_loading"></span>');

                            var data = {
                                action: 'pcpp_del_user_order',
                                user_id: <?php echo (int)$user_id ?>,
                                order_id: parseInt($subj.data('id'), 10),
                                pcpp_nonce: '<?php echo wp_create_nonce('lcwp_ajax') ?>'
                            };
                            $.post(ajaxurl, data, function(response) {
                                var resp = $.trim(response);

                                if(resp != 'success') {
                                    pcpp_is_acting = false;
                                    lc_wp_popup_message('error', resp);
                                    $subj.show();
                                }
                                else {
                                    (is_act_order) ? window.location.reload() : $wrap.remove();
                                }
                            })
                            .fail(function(e) {
                                if(e.status) {
                                    console.error(e);
                                    
                                    lc_wp_popup_message('error', "<?php esc_html_e('Error deleting the order', PCPP_ML) ?>");
                                    $subj.show();
                                }
                            })
                            .always(function() {
                                pcpp_is_acting = false;
                                $subj.parent().find('.pcpp_duo_loading').remove();
                            });	
                        });

                        
                        /////////////////////////////////////////////////

                        
                        // show edit block
                        $('#pcpp_aut_first_row td#pcpp_edit_plan_wrap h4 a, #pcpp_aut_first_row td#pcpp_edit_exp_wrap h4 a, #pcpp_trial_exp_wrap h4 a').on('click', function(){
                            var $subj = $(this).parents('td');
                            $subj.find('span').hide();
                            $subj.find('p').show();

                            // hide other ones
                            $('#pcpp_aut_first_row td').not($subj).find('input.pcpp_cancel').trigger('click');
                        });

                        // hide edit block
                        $('#pcpp_aut_first_row td input.pcpp_cancel').on('click', function(){
                            var $subj = $(this).parents('td');
                            $subj.find('span').show();
                            $subj.find('p').hide();
                        });


                        // toggle orders history
                        $('#pcpp_toggle_orders_history').on('click', function(){
                            var $subj = $(this);

                            $('#pcpp_orders_history').toggle(0, function() {
                                if( $(this).is(':hidden') ) {
                                    $subj.html("<span class='dashicons dashicons-arrow-down'></span> <?php esc_attr_e('show orders history', PCPP_ML) ?>");
                                } else {
                                    $subj.html("<span class='dashicons dashicons-arrow-up'></span> <?php esc_attr_e('hide orders history', PCPP_ML) ?>");	
                                }
                            });
                        });

                    })(jQuery);
					</script>
					<?php
					
			echo '	</td>
				</tr>
			</table>';
		}
	}
}




// require pcpp_plan field only for new users
function pcpp_add_user_require_plan($form_structure, $user_id) {
	if($GLOBALS['pcpp_enabled'] && !$user_id) {
		if(!isset($form_structure['require'])) {
			$form_structure['require'] = array();	
		}
		
		$form_structure['include'][] = 'pcpp_plan';
		$form_structure['require'][] = 'pcpp_plan';
	}
	
	return $form_structure;
}
add_filter('pc_user_dashboard_validation', 'pcpp_add_user_require_plan', 10, 2);





// assign plan on admin user insertion
function pcpp_add_user_assign_plan($user_id) {
	if(!$GLOBALS['pcpp_enabled'] || !isset($GLOBALS['pc_adding_user_by_admin'])) {
        return false;
    }
	
	global $pc_meta, $pcpp_subscr;
	$plan_id = $pc_meta->get_meta($user_id, 'pcpp_plan'); 
	
	// no associated plan - remove meta
	if($plan_id == 'no_plan') {
		$pc_meta->delete_meta($user_id, 'pcpp_plan');
		return true;	
	}
	
	
	// plan selected - perform actions
	$order_obj = $pcpp_subscr->create_order($user_id, $plan_id);
	$order_id = $pcpp_subscr->order_obj_to_id($order_obj);
    
	// set new main order and manage access metas
	pcpp_user_subscr_static::manag_orders($user_id, $order_id, 'add');
	
	// eventually setup trial
	if(isset($_POST['pcpp_apply_trial']) && $_POST['pcpp_apply_trial']) {
		pcpp_user_subscr_static::setup_trial_meta($user_id, $plan_id);
	}
}
add_action('pc_user_added', 'pcpp_add_user_assign_plan', 999);








////////////////////////////////////////////////////////////////////////////////







// IMPORT form - add fields
function pcpp_import_add_fields() {
	if(!$GLOBALS['pcpp_enabled']) {
        return false;
    }
	global $pcpp_subscr;
	
	?>
    <tr>
       <td class="pc_label_td"><em>Premium plans add-on</em> - <?php _e("Associate plan", PCPP_ML); ?></td>
       <td class="pc_field_td">
		<select name="pcpp_plan" autocomplete="off" class="pc_lc_select">
			<option value="no_plan"><?php esc_html_e("Do not associate", PCPP_ML) ?></option>
            <?php
            foreach($pcpp_subscr->get_plans(false) as $plan_id => $plan_name) {
                $sel = (isset($_POST['pcpp_plan']) && $_POST['pcpp_plan'] == $plan_id) ? 'selected="selected"' : '';
                echo '<option value="'.$plan_id.'" '.$sel.'>'. esc_html($plan_name . pcpp_static::dd_plan_details($plan_id)) .'</option>'; 
            }
			?>
        </select>
       </td>
       <td><span class="info"><?php _e("Select which plan will be associated with imported users", PCPP_ML); ?></span></td>
    </tr> 
    <?php if($pcpp_subscr->is_trial_enabled()) : ?>
    <tr>
        <td class="pc_label_td">
            <em>Premium plans add-on</em> - <?php _e('Apply trial period?', PCPP_ML) ?> (<?php echo $pcpp_subscr->trial_duration.' '.pcpp_static::sing_plur_switch($pcpp_subscr->trial_dur_type, $pcpp_subscr->trial_duration); ?>)
        </td>
        <td class="pc_field_td">
            <?php $ckd = (isset($_POST['pcpp_apply_trial']) && $_POST['pcpp_apply_trial']) ? 'checked="checked"' : ''; ?>
           <input type="checkbox" name="pcpp_apply_trial" value="1" <?php echo $ckd ?> autocomplete="off" class="pc_lc_switch" />
        </td>
        <td></td>
    </tr>
	<?php
	endif;
}
add_action('pc_import_form', 'pcpp_import_add_fields');



// import users - perform plan association
function pcpp_import_create_orders($imported_list) {
	if(!$GLOBALS['pcpp_enabled'] || empty($imported_list) || !isset($_POST['pcpp_plan']) ||
		(isset($_POST['pcpp_plan']) && empty($_POST['pcpp_plan'])) || 
		(isset($_POST['pcpp_plan']) && $_POST['pcpp_plan'] == 'no_plan')
	) {
        return false;
    }
    
	global $pc_users, $pcpp_subscr;
	
	// get plan specifications
	$plan_id = (int)$_POST['pcpp_plan'];
	$plan_data = $pcpp_subscr->get_plan_data($plan_id);
	
	
	// get users data to perform actions
	$args = array(
		'user_id'	=> array_keys($imported_list),
		'to_get' 	=> array('id', 'name', 'surname', 'username', 'email', 'tel', 'wp_user_id'),
		'limit' 	=> -1
	);
	$users_data = $pc_users->get_users($args);

	// create order
	foreach($users_data as $ud) {
		$order_obj = $pcpp_subscr->create_order($ud['id'], $plan_id, $ud);	
        $order_id = $pcpp_subscr->order_obj_to_id($order_obj);
        
		if($order_id) {
			
			// set new main order and manage access metas
			pcpp_user_subscr_static::manag_orders($ud['id'], $order_id, 'add');
			
			// eventually setup trial
			if($pcpp_subscr->is_trial_enabled() && isset($_POST['pcpp_apply_trial']) && $_POST['pcpp_apply_trial']) {
				pcpp_user_subscr_static::setup_trial_meta($ud['id'], $plan_id);
			}
		}
	}
}
add_action('pc_imported_users', 'pcpp_import_create_orders');






////////////////////////////////////////////////////////////////////////////////






// PC CAT RESTRICTIONS - add plans to allow plan-based restriction
function pcpp_user_cat_dd_opts($opts) {
	if(!$GLOBALS['pcpp_enabled']) {
        return $opts;
    }
	global $pcpp_subscr;
	
	$opts['pcpp_plans'] = array(
		'name' => __('Premium Plans', PCPP_ML),
		'opts' => array()
	);
	
	foreach($pcpp_subscr->get_plans(false) as $plan_id => $plan_name) {
		$opts['pcpp_plans']['opts'][ 'PCPP_'.$plan_id ] = 'PP - '.$plan_name;		
	}
	
	return $opts;
}
add_filter('pc_user_cat_dd_opts', 'pcpp_user_cat_dd_opts');






////////////////////////////////////////////////////////////////////////////////






// eventually remove orders on user deletion (recurrng payments already stopped by woo subscr)
function pcpp_del_order_on_user_del($user_id) {
	if(get_option('pcpp_del_orders_on_user_del')) {
		global $pc_meta;
        
		$user_orders = $pc_meta->get_meta($user_id, 'pcpp_orders');
        $user_recurr_pay = $pc_meta->get_meta($user_id, 'pcpp_recurr_subscr');
		
		if(is_array($user_orders)) {
			$GLOBALS['pcpp_deleting_user_orders'] = true;
			
			foreach($user_orders as $order_id) {
                
                // do not delete if order is paid, is important for earning statistics
                if(PCPP_ECOMMERCE == 'woocomm') {
                    $order_obj = wc_get_order($order_id);   
                    if(is_object($order_obj) && $order_obj->get_status() == 'completed') {
                        continue;    
                    }
                }
                
				wp_delete_post($order_id, true);	
			}
		}
	}
}
add_action('pc_pre_user_delete', 'pcpp_del_order_on_user_del');




// update user orders on order post deletion
function pcpp_update_on_order_deletion($order_id) {
	if(!$GLOBALS['pcpp_enabled'] || isset($GLOBALS['pcpp_deleting_user_orders'])) {
        return false;
    }
	global $pc_users, $pc_meta, $pcpp_subscr;

    
    // linked pvTContent user?
    $linked_user_id = get_post_meta($order_id, 'pvtcontent_user_id', true);
    if(!$linked_user_id) {
        return true;    
    }
    
    
    pcpp_user_subscr_static::manag_orders($linked_user_id, $order_id, 'remove');
    
    
    // woo subscription? detach and set user as "expired"
    if(PCPP_ECOMMERCE == 'woocomm' && pcpp_woo_subscr_static::order_is_subscr($order_id)) {
        $args = array(
            'to_get' => array('id'),
            'search' => array(
                array('key' => 'pcpp_recurr_subscr', 'operator' => '=', 'val' => $order_id)
            )
        );
        $result = $pc_users->get_users($args);      
        
        foreach($result as $udata) {		
            $pc_meta->update_meta($udata['id'], 'pcpp_plan', '');
            $pc_meta->update_meta($udata['id'], 'pcpp_active_order', '');
            $pc_meta->update_meta($udata['id'], 'pcpp_subscr_end', '');
            $pc_meta->update_meta($udata['id'], 'pcpp_subscr_status', 'expired');		

            // PCPP-ACTION - allow extra operations when new user main order changed
            do_action('pcpp_new_user_main_order', $udata['id']); 	            
        }
    }
}
add_action('before_delete_post', 'pcpp_update_on_order_deletion');






////////////////////////////////////////////////////////////////////////////////






// USERS LIST - add badge to flag user subscription status
function pcpp_users_list_badge($badges, $user_id) {
	if(!$GLOBALS['pcpp_enabled']) {
        return $badges;
    }
	global $pc_users, $pcpp_subscr;
	
	// prior status check
    $fields = array('pcpp_plan', 'pcpp_active_order', 'pcpp_subscr_status', 'pcpp_trial_ending', 'pcpp_subscr_end', 'pcpp_orders', 'pcpp_recurr_subscr');
    $user_data = $pc_users->get_user($user_id, array('to_get' => $fields));
    
    $status = pcpp_user_subscr_static::check_subscr_expir($user_id, $user_data);
    
	if(!is_string($status)) {
		return $badges;	
	}
	
	// recheck expiration date if is marked as active or inherit
	if(in_array($status, array('active', 'inherit', 'suspended'))) {
		$status = pcpp_user_subscr_static::check_subscr_expir($user_id);	
	}
    
	$badges .= '<img src="'.PCPP_URL.'/img/status_badges/'. $status .'.png" title="'. esc_attr( get_the_title($user_data['pcpp_plan']) .' - '. ucfirst(strtolower(pcpp_static::subscr_statuses($status))) .' '. __('subscription', PCPP_ML)) .'" />';
    
	return $badges;
}
add_filter('pc_users_list_badges', 'pcpp_users_list_badge', 10, 2);





// USERS LIST - add options into advanced filter atts
function pcpp_ulist_adv_search_user_atts($atts) {
    $to_add = array();

    foreach(pcpp_static::subscr_statuses() as $key => $name) {
        if(in_array($key, array('inherit', 'no_act_order'))) {
            continue;    
        }
        
        $to_add['pcpp_'. $key .'_status'] = array(
            'name'      => 'Premium Plans add-on - '. sprintf(__("%s Status", PCPP_ML), $name),
            'db_key'    => 'pcpp_subscr_status',
            'db_val'    => $key
        );
    }
    
    return array_merge($atts, $to_add);
}
add_filter('pc_ulist_adv_search_user_atts', 'pcpp_ulist_adv_search_user_atts');    






////////////////////////////////////////////////////////////////////////////////






//// EXPORT USERS integration

// add field
function pcpp_export_field() {
	if(!$GLOBALS['pcpp_enabled']) {return false;}
	?>
	<tr>
      <td class="pc_label_td"><?php _e("Export subscriptions data", PCPP_ML) ?></td>
      <td class="pc_field_td">
          <input type="checkbox" name="pcpp_export_data" value="1" class="pc_lc_switch" autocomplete="off" />
      </td>
    </tr>
    <?php
}
add_action('pc_export_form', 'pcpp_export_field');



// add fields to the export query
function pcpp_export_fields($to_get) {
	
	if(isset($_POST['pcpp_export_data'])) {
		$to_get['pcpp_plan'] 			= __("Subscription's plan", PCPP_ML);
		$to_get['pcpp_subscr_end'] 		= __("Subscription's end", PCPP_ML);
		$to_get['pcpp_subscr_status'] 	= __("Subscription's status", PCPP_ML);
	
		$GLOBALS['pcpp_doing_export'] = current_time('timestamp'); 
		$GLOBALS['pcpp_export_u_expir_date'] = array();
	}
	return $to_get;
}
add_filter('pc_export_fields', 'pcpp_export_fields');



// manipulate fetched data
function pcpp_export_data_to_human($data, $index) {
	if(!isset($GLOBALS['pcpp_doing_export'])) {
		return $data;	
	}
	
	if($index == 'pcpp_plan') {
		return ($data) ? get_the_title($data) : '';	
	}
	
	elseif($index == 'pcpp_subscr_end') {
		$GLOBALS['pcpp_export_u_expir_time'] = $data;
		
		if($data == 'unlimited') {
			return __('no expiration', PCPP_ML);	
		}
		
		return (!empty($data)) ? date_i18n('Y-m-d H:i:s', (int)$data) : '';
	}
	
	elseif($index == 'pcpp_subscr_status') {
		
		// avoid checking every user and just check if expir data already passed
		if(
			isset($GLOBALS['pcpp_export_u_expir_time']) &&
			$GLOBALS['pcpp_export_u_expir_time'] && $GLOBALS['pcpp_export_u_expir_time'] != 'unlimited' &&
			$GLOBALS['pcpp_export_u_expir_time'] <= $GLOBALS['pcpp_doing_export']
		) {
			$data = 'expired';
		}
		return ($data) ? pcpp_static::subscr_statuses($data) : '';	
	}
	

	return $data;		
}
add_filter('pc_data_to_human', 'pcpp_export_data_to_human', 10, 2);





////////////////////////////////////////////////////////////////////////////////





///////////////////////////////////////
// MAIL ACTIONS INTEGRATIONS //////////
///////////////////////////////////////


// pcma settings - add tab	
function pcpp_pcma_tabs($tabs) {
	$tabs['pcpp_expir_reminder'] = 'Premium Plans add-on';
	return $tabs;	
}
add_filter('pcma_settings_tabs', 'pcpp_pcma_tabs');	
	


// forewarning time custom field
function pcpp_pcma_reminder_endpoint($field_id, $field, $value, $all_vals) {
	$num = get_option('pcpp_expir_reminder_forewarn_num', 1);
	$type = get_option('pcpp_expir_reminder_forewarn_type');
	?>
	<table class="widefat lcwp_settings_table pc_settings_block">
    	<tbody>
            <tr>
            	<td class="lcwp_sf_label">
                	<?php _e("Reminders endpoint link <small>(to be used in server's cronjob)</small>", PCPP_ML) ?>
                </td>
                <td colspan="2">               	
                    <a href="javascript:void(0)" onclick="pcpp_copy()" title="<?php esc_attr_e('copy endpoint', PCPP_ML) ?>" id="pcal_copy">
                    	<strong id="pcpp_see_endpoint"><?php echo PCPP_URL ?>/pcma_reminders_endpoint.php</strong>
                    	&nbsp; <span class="dashicons dashicons-admin-page"></span>
                    </a>
                    
                    <script type="text/javascript">
					(function($) { 
                        "use strict"; 
						
						// copy url attr
						window.pcpp_copy = function() {
							var $temp = $("<input>");
							$("body").append($temp);
							$temp.val( $('#pcpp_see_endpoint').text() ).select();
						 
							document.execCommand("copy");
							$temp.remove();	
							
                            lc_wp_popup_message('success', "<?php esc_attr_e('Endpoint copied in your clipboard', PCPP_ML) ?>");
						};
					})(jQuery);
					</script>
                </td>
        </tbody>
    </table>
    <?php
}	
	

	
// pcma settings - add tab contents	and hook into mailchimp tab
function pcpp_pcma_tab_content($structure) {
    $ml_key = PCPP_ML;
        
	$def_see_subj = __("Your subscription has expired", $ml_key);
	$def_see_txt	= __('Hello %USERNAME%, 
your subscription on %SITE-TITLE% has expired.

We wish you would like to stay with us. Click on the following link to renew now:
%RENEW-LINK%', $ml_key);
	
    
    $def_bte_subj = __("Your trial period is about to end", $ml_key);
	$def_bte_txt	= __('Hello %USERNAME%, 
your trial period on %SITE-TITLE% will expire in [pcpp-subscr-expir type="countdown"].

We hope you are enjoying the website and want to join our subscribers!', $ml_key);
    
    
	
	$structure['pcpp_expir_reminder'] = array(
		'pcpp_pcma_endpoint' => array(
			'sect_name'	=>  __("Reminders Endpoint", $ml_key),
			'fields' 	=> array(
			
				'pcpp_pcma_reminder_endpoint' => array(
					'type'		=> 'custom',
					'label'		=> __('Reminder forewarning', $ml_key),
					'callback'	=> 'pcpp_pcma_reminder_endpoint',
					'note' => __('Set when users reminder is sent', $ml_key)
				),
			),
		),
        
		
		'pcpp_see_texts' => array(
			'sect_name'	=>  __('Expired subscription reminder', $ml_key),
			'fields' 	=> array(
                
				'pcpp_pcma_see_enble' => array(
                    'label' => __('Enable this reminder?', $ml_key),
                    'type'	=> 'checkbox',
                    'def'   => true,
                    'note'	=> __("If checked, each time the endpoint page will be opened, the system will send a reminder e-mail to users having an expired subscription", $ml_key),
                ),
				'pcpp_see_legend' => pcma_phs_legend(
					array(
						'%SITE-TITLE%'	=> __('Website title specified in WP settings', $ml_key),
						'%NAME%'		=> __("User's name", $ml_key),
						'%SURNAME%'		=> __("User's surame",$ml_key),
						'%USERNAME%'	=> __("User's userame", $ml_key),
						'%MAIL%'		=> __("User's e-mail", $ml_key),
						'%RENEW-LINK%'	=> __("User's renew page link", $ml_key),
                        '[pcpp-user-plan]'=> __("Add-on's shortcode returning user's plan name", $ml_key) .' (<a href="https://doc.lcweb.it/pc_premium_plans/#user_plan_sc" target="_blank">'. esc_html__('read more', $ml_key) .'</a>)',
					)
				),
				'pcpp_see_title' => array(
					'label' 	=> __('E-mail title', $ml_key),
					'type'		=> 'text',
					'def' 		=> $def_see_subj,
					'fullwidth' => true,
				),
				'pcud_see_txt' => array(
					'label' => __("E-mail text", $ml_key),
					'type'	=> 'wp_editor',
					'def' 	=> $def_see_txt,
					'rows' 	=> 13,
				), 
			),
		),
        
        
        'pcpp_bte_texts' => array(
			'sect_name'	=>  __('Trial period expiration forewarning', $ml_key),
			'fields' 	=> array(
                
				'pcpp_pcma_bte_enble' => array(
                    'label' => __('Enable this reminder?', $ml_key),
                    'type'	=> 'checkbox',
                    'note'	=> __("If checked, each time the endpoint page will be opened, the system will send a reminder e-mail to users having an expiring trial period (basing on the forewarning period you define)", $ml_key),
                ),
                'pcpp_pcma_bte_forewarn' => array(
					'label' 	=> __("How many forewarning days?", PCPP_ML),
					'type'		=> 'slider',
					'min_val'	=> 1,
					'max_val'	=> 30,	
					'step'		=> 1,
					'value'		=> '',
					'def'		=> 1,
					'note'		=> esc_html__('Number of forewarning days before the trial period expiration', $ml_key),
                    'respect_limits' => true,
				),
				'pcpp_bte_legend' => pcma_phs_legend(
					array(
						'%SITE-TITLE%'	    => __('Website title specified in WP settings', $ml_key),
						'%NAME%'		    => __("User's name", $ml_key),
						'%SURNAME%'		    => __("User's surame",$ml_key),
						'%USERNAME%'	    => __("User's userame", $ml_key),
						'%MAIL%'		    => __("User's e-mail", $ml_key),
                        '[pcpp-user-plan]'=> __("Add-on's shortcode returning user's plan name", $ml_key) .' (<a href="https://doc.lcweb.it/pc_premium_plans/#user_plan_sc" target="_blank">'. esc_html__('read more', $ml_key) .'</a>)',
						'[pcpp-subscr-expir]'=> __("Add-on's shortcode returning user's expiration date", $ml_key) .' (<a href="https://doc.lcweb.it/pc_premium_plans/#user_exp_sc" target="_blank">'. esc_html__('read more', $ml_key) .'</a>)',
					)
				),
				'pcpp_bte_title' => array(
					'label' 	=> __('E-mail title', $ml_key),
					'type'		=> 'text',
					'def' 		=> $def_bte_subj,
					'fullwidth' => true,
				),
				'pcud_bte_txt' => array(
					'label' => __("E-mail text", $ml_key),
					'type'	=> 'wp_editor',
					'def' 	=> $def_bte_txt,
					'rows' 	=> 13,
				), 
			),
		),
	);
	
	
	
	// mailchimp - add option to remove expired users
	$to_add = array(
		'pcma_pcpp_exclude_expired' => array(
			'label' => 'Premium Plans add-on - '. __('exclude expired users?', $ml_key),
			'type'	=> 'checkbox',
			'note'	=> __("If checked exclude users with expired subscriptions from Mailchimp list", $ml_key),
		),
	);
	$to_edit = $structure['mailchimp']['mailchimp_config']['fields'];
	
    include_once(PC_DIR .'/settings/settings_engine.php');
    $structure['mailchimp']['mailchimp_config']['fields'] = pc_settings_engine::inject_array_elem($to_add, $to_edit, 'pcma_mc_def_discl');
	
	return $structure;
}
add_action('pcma_settings_structure', 'pcpp_pcma_tab_content');		



// unsync users with expired plans
function pcpp_pcma_mailchimp_user_subscribe($may_subscribe, $user_id) {
	if(!$GLOBALS['pcpp_enabled']) {return $may_subscribe;}
	global $pc_meta;
	
	if($pc_meta->get_meta($user_id, 'pcpp_subscr_status') == 'expired') {
		return false;
	}
	
	return $may_subscribe;		
}
add_filter('pcma_mailchimp_user_subscribe', 'pcpp_pcma_mailchimp_user_subscribe', 10, 2);



// Quick Mail receivers query management (user categories) 
function pcpp_pcma_qm_cat_query($args) {
    if(isset($GLOBALS['pcpp_enabled']) && $GLOBALS['pcpp_enabled']) {
        $args['search'][] = array('key'=>'pcpp_subscr_status', 'operator'=>'!=', 'val'=>'expired'); 
    }
    
    return $args;
}
add_filter('pcma_qm_cat_query', 'pcpp_pcma_qm_cat_query');



// Quick Mail receivers query management (user categories) 
function pcpp_pcma_ec_aa_user_array($to_return) {
    if(!isset($GLOBALS['pcpp_enabled']) || !$GLOBALS['pcpp_enabled']) {
        return $to_return;
    }
    global $pc_users;
    
    // perform a unique query
    $to_return_w_key = array();
    $ids_list = array();
    
    foreach($to_return as $tr) {
        $ids_list[] = $tr['id'];  
        $to_return_w_key[ $tr['id'] ] = $tr;
    }
    
    $args = array(
		'limit'   => count($ids_list),
		'to_get'  => array('id', 'pcpp_subscr_status'),
        'search'  => array(
            array('key'=>'id', 'operator'=>'IN', 'val'=>$ids_list),
        )
	);
    $users = $pc_users->get_users($args);

    $checked = array();
    foreach($users as $ud) {
        if($ud['pcpp_subscr_status'] != 'expired') {
            $checked[] = $to_return_w_key[ $ud['id'] ];            
        }
    }
    return $checked;
}
add_filter('pcma_ec_aa_user_array', 'pcpp_pcma_ec_aa_user_array');




// Allows further filter over users needing Mailchimp sync
function pcpp_pcma_mc_to_sync_array($to_sync) {
    if(!isset($GLOBALS['pcpp_enabled']) || !$GLOBALS['pcpp_enabled']) {
        return $to_sync;
    }
    global $pc_users;
    
    // perform a unique query
    $ids_list = array_keys($to_sync);
    $args = array(
		'limit'   => count($ids_list),
		'to_get'  => array('id', 'pcpp_subscr_status'),
        'search'  => array(
            array('key'=>'id', 'operator'=>'IN', 'val'=>$ids_list),
        )
	);
    $users = $pc_users->get_users($args);

    foreach($users as $ud) {
        if($ud['pcpp_subscr_status'] == 'expired') {
            unset($to_sync[ $ud['id'] ]);         
        }
    }
    return $to_sync;
}
add_filter('pcma_mc_to_sync_array', 'pcpp_pcma_mc_to_sync_array');




// Avoid PCPP plans to be targeted by PvtContent sales block
function pcpp_avoid_plans_sell_block($block, $product_id) {
    global $pcpp_subscr;
    
    if(is_string($pcpp_subscr->get_plans(false, false, $product_id))) {
        return false;    
    } 
    return $block;
}
add_filter('pc_block_woo_product_sell', 'pcpp_avoid_plans_sell_block', 100, 2);





////////////////////////////////////////////////////////////////////////////////





//////////////////////////////////////////
// MAIL ACTIONS - CAMPAIGN INTEGRATIONS //
//////////////////////////////////////////


// add custom HTML fields
function pcpp_pcma_ecb_extra_fields($post, $metas, $can_be_edited) {
    if(!isset($GLOBALS['pcpp_enabled']) || !$GLOBALS['pcpp_enabled']) {
        return false;
    }
    global $pcpp_subscr;
    
    $plans = $pcpp_subscr->get_plans(false, false);
    if(empty($plans)) {
        return false;    
    }
    
    $sel_plans    = get_post_meta($post->ID, 'pcma_ecb_pcpp_plans', true);
    $only_active  = get_post_meta($post->ID, 'pcma_ecb_only_pcpp_active', true);
     
    $vis        = (!isset($metas['pcma_ecb_include_pc_cats']) || empty($metas['pcma_ecb_include_pc_cats'])) ? 'pc_displaynone' : '';
    $disabled   = ($can_be_edited) ? '' : 'disabled'; 
    
    ?>
    <tr class="pcma_ecb_pcpp_plans_wrap <?php echo $vis ?>">
        <td><?php _e('Target users belonging to subscription plans', PCMA_ML); ?></td>
        <td>
            <select name="pcma_ecb_pcpp_plans[]" multiple="multiple" class="pcma_lc_select" data-placeholder="<?php esc_attr_e('Leave empty to discard', PCPP_ML) ?> .." autocomplete="off" <?php echo $disabled ?>>
                
                <?php
                foreach($plans as $pid => $pname) {
                    $sel = (is_array($sel_plans) && in_array($pid, $sel_plans)) ? 'selected="selected"' : '';
                    echo '<option value="'. (int)$pid .'" '. $sel .'>'. esc_html($pname) .'</option>';
                }
                ?>
            </select> 
        </td>
    </tr>
    <tr class="pcma_ecb_only_pcpp_active_wrap <?php echo $vis ?>">
        <td><?php _e('Target only useres with active subscription?', PCMA_ML); ?></td>
        <td>
            <input type="checkbox" name="pcma_ecb_only_pcpp_active" value="1" <?php checked('1', $only_active) ?> class="pcma_lc_switch" autocomplete="off" <?php echo $disabled ?> /> 
            
            <script type="text/javascript">
            (function($) { 
                "use strict";
                
                $(document).on('pcma_ecb_include_pc_cats_updated', function(e, val) {
                    
                    if(typeof(val) != 'object' || !val.length) {
                        $('.pcma_ecb_pcpp_plans_wrap, .pcma_ecb_only_pcpp_active_wrap').addClass('pc_displaynone');
                    } 
                    else {
                        $('.pcma_ecb_pcpp_plans_wrap, .pcma_ecb_only_pcpp_active_wrap').removeClass('pc_displaynone');    
                    }
                });
                
            })(jQuery);
            </script>
        </td>
    </tr>
    <?php
}
add_action('pcma_ecb_extra_fields', 'pcpp_pcma_ecb_extra_fields', 10, 3);	




// fetch "filter by plan" field value in meta save and ajax call
function pcma_pcpp_filter_ecb_meta_save($fdata) {
    
    $fdata['pcma_ecb_pcpp_plans'] = (isset($_POST['pcma_ecb_pcpp_plans'])) ? (array)$_POST['pcma_ecb_pcpp_plans'] : array();
    $fdata['pcma_ecb_only_pcpp_active'] = (isset($_POST['pcma_ecb_only_pcpp_active']) && $_POST['pcma_ecb_only_pcpp_active']) ? 1 : false;
    return $fdata;
}
add_filter('pcma_filter_ecb_meta_save', 'pcma_pcpp_filter_ecb_meta_save');
add_filter('pcma_filter_ecb_list_receivers', 'pcma_pcpp_filter_ecb_meta_save');




// filter "get_users" query args if there are plans specified
function pcma_pcpp_email_campaign_receivers_query($args, $campaign_id, $receivers_data) {
    global $pcpp_subscr;
    if(!isset($GLOBALS['pcpp_enabled']) || !$GLOBALS['pcpp_enabled']) {
        return $args;
    }
    
    $search_arr = array();
    
    // target plans part
    $target_plans = ($campaign_id) ? (array)get_post_meta($campaign_id, 'pcma_ecb_pcpp_plans', true) : (array)$receivers_data['pcma_ecb_pcpp_plans'];

    // be sure chosen plans are still valid
    $plans = $pcpp_subscr->get_plans(false, false);
    foreach($target_plans as $key => $pid) {
        if(!isset($plans[$pid])) {
            unset($target_plans[$pid]);
        }
    }
    if(!empty($target_plans)) {
        $search_arr[] = array('key'=>'pcpp_plan', 'operator'=>'IN', 'val'=>$target_plans);  
    }
    
    
    // only active subscribers part
    $oas_val = ($campaign_id) ? (array)get_post_meta($campaign_id, 'pcma_ecb_only_pcpp_active', true) : $receivers_data['pcma_ecb_only_pcpp_active'];
    if(!empty($oas_val)) {
        $search_arr[] = array('key'=>'pcpp_subscr_status', 'operator'=>'IN', 'val'=>array('active', 'trial', 'no_act_order'));    
    }
    
    
    // act only if there's something to filter
    if(empty($search_arr)) {
        return $args;
    }
    $search_arr['relation'] = 'AND'; 
    
    if(!isset($args['search']) || !is_array($args['search'])) {
        $args['search'] = array();    
    }

    $args['search']['pcpp_plan'] = $search_arr;
    return $args;
}
add_filter('pcma_email_campaign_receivers_query', 'pcma_pcpp_email_campaign_receivers_query', 10, 3);

